/**********************************************************************
zyGrib: meteorological GRIB file viewer
Copyright (C) 2008 - Jacques Zaninetti - http://www.zygrib.org

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
***********************************************************************/

#ifndef GRIBPOINTINFO_H
#define GRIBPOINTINFO_H

#include "GriddedReader.h"

class DataPointInfo
{
    public :
        DataPointInfo (GriddedReader *reader, float x, float y, time_t date);
		
		float getDataValue (const DataCode &dtc);
		
        bool hasPressure() const {return pressure!=GRIB_NOTDEF;}
        bool hasTemp()     const {return temp!=GRIB_NOTDEF;}
        bool hasTempPot()  const {return tempPot!=GRIB_NOTDEF;}
        bool hasTempMin()  const {return tempMin!=GRIB_NOTDEF;}
        bool hasTempMax()  const {return tempMax!=GRIB_NOTDEF;}
        bool hasRain()     const {return rain!=GRIB_NOTDEF;}
        bool hasCloud()    const {return cloud!=GRIB_NOTDEF;}
        bool hasHumidRel()      const {return humidRel!=GRIB_NOTDEF;}
        bool hasHumidSpec()     const {return humidSpec!=GRIB_NOTDEF;}
        bool hasDewPoint()      const {return dewPoint!=GRIB_NOTDEF;}
        bool hasIsotherm0HGT()  const {return isotherm0HGT!=GRIB_NOTDEF;}
        bool hasSnowDepth()     const {return snowDepth!=GRIB_NOTDEF;}
        bool hasSnowCateg()     const {return snowCateg!=GRIB_NOTDEF;}
        bool hasFrzRainCateg()  const {return frzRainCateg!=GRIB_NOTDEF;}
        bool hasCAPEsfc()   	const {return CAPEsfc!=GRIB_NOTDEF;}

		//----------------------------------------------
		// Special case : wind
        bool hasWind (const Altitude &alt) const;
        bool getWindValues (const Altitude &alt, float *speed, float*dir) const;
        void getWindVxVy   (const Altitude &alt, float *vx, float*vy) const;
        
		//----------------------------------------------
        float   x, y;       // position
        time_t   date;
        float   vx, vy;     // wind
		float   windSpeed;
		float   windDir;
        float   pressure;
        float   temp;
        float   tempPot;
        float   tempMin;
        float   tempMax;
        float   rain;
        float   cloud;
        float   humidRel;
        float   humidSpec;
        float   dewPoint;
        float   isotherm0HGT;
        float   snowDepth;
        float   snowCateg;
        float   frzRainCateg;
        float   CAPEsfc;

		// data at 850 700 500 300 200 hPa
		bool    hasAltitudeData;
		float  hThetae [5];
		float  hGeopot [5];
		float  hTemp [5];
		float  hHumidRel [5];
		float  hHumidSpec [5];
		float  hVx [5];
		float  hVy [5];
		float  hWindSpeed [5];
		float  hWindDir [5];
        
	private:
        GriddedReader *reader;
        void initDataPointInfo();
        
};

#endif
