/**********************************************************************
zyGrib: meteorological GRIB file viewer
Copyright (C) 2008 - Jacques Zaninetti - http://www.zygrib.org

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
***********************************************************************/

#ifndef MAPDRAWER_H
#define MAPDRAWER_H

#include <QWidget>
#include <QBitmap>

#include "GshhsReader.h"
#include "GisReader.h"
#include "Projection.h"
#include "POI.h"

class GribPlot;
class IacPlot;


//==============================================================================
class MapDrawer : public QObject
{
    Q_OBJECT

    friend class Terrain;

public:
	MapDrawer(GshhsReader *gshhsReader);
	MapDrawer(const MapDrawer &model);
	~MapDrawer();

	void draw_GSHHSandGRIB1(
			QPainter &pntGlobal,
			bool mustRedraw,
			bool isEarthMapValid,
			Projection *proj,
			GribPlot   *gribPlot
		);
	
	void draw_GSHHSandIAC(
			QPainter &pntGlobal,
			bool mustRedraw,
			bool isEarthMapValid,
			Projection *proj,
			IacPlot   *iacPlot
		);
	
	void draw_GSHHS (
			QPainter &pntGlobal,
			bool mustRedraw,
			bool isEarthMapValid,
			Projection *proj
		);
	
	// Cartouche : dates de la prévision courante + infos générales
	void draw_Cartouche_GRIB1(QPainter &pnt, const Projection *proj, GribPlot *gribPlot);
	void draw_Cartouche_IAC  (QPainter &pnt, const Projection *proj, IacPlot *iacPlot);

	enum DrawGribPlainDataMode {
		 drawNone,
		 drawWind,
		 drawCloud,
		 drawRain,
		 drawCAPEsfc,
		 drawSnowDepth,
		 drawSnowCateg,
		 drawFrzRainCateg,
		 drawHumid,
		 drawTemp,
		 drawTempPot,
		 drawTempMin,
		 drawTempMax,
		 drawDewpoint,
		 drawDeltaDewpoint
	};

private:
    QPixmap     *imgEarth;   // images précalculées pour accélérer l'affichage
    QPixmap     *imgAll;
    GshhsReader *gshhsReader;
    
    GisReader	*gisReader;
	bool		gisReaderIsNew;
    
    
    int   showCitiesNamesLevel;
    bool  showCountriesNames;
    bool  showCountriesBorders;
    bool  showRivers;
    bool  showLonLatGrid;
    
    int	  colorMapMode;
    bool  colorMapSmooth;
    
    double isobarsStep;
    bool   showIsobars;
    bool   showIsobarsLabels;
    bool   showPressureMinMax;

    double isotherms0Step;
    bool   showIsotherms0;
    bool   showIsotherms0Labels;
    
    bool  showWindArrows;
    bool  showBarbules;
    bool  showGribGrid;
    bool  showTemperatureLabels;
    
    QColor  seaColor, landColor, backgroundColor;
	QColor  windArrowsColor;	
	QPen	isobarsPen;
	QPen	isotherms0Pen;
	QPen	seaBordersPen;
	QPen	boundariesPen;
	QPen	riversPen;

	void	updateGraphicsParameters();
	void	initGraphicsParameters  ();
	
	void 	draw_MeteoData_IAC   (QPainter &pnt, Projection *proj, IacPlot *iacPlot);
	void 	draw_MeteoData_GRIB1 (QPainter &pnt, Projection *proj, GribPlot *gribPlot);
	void	draw_Map_Background  (bool isEarthMapValid, Projection *proj);
	void	draw_Map_Foreground  (QPainter &pnt, Projection *proj);

};


#endif
