""" Unit tests for mapped interfaces.

$Id$
"""

import unittest
from Testing import ZopeTestCase
from Testing.ZopeTestCase.functional import Functional
from Products.CMFCore.utils import getToolByName
from Products.Five.traversable import newInteraction

# we need to install test products *before* Five as Five
# looks up zcml files in the products it can find.
ZopeTestCase.installProduct('CMFonFiveTest')
ZopeTestCase.installProduct('CMFonFive')
ZopeTestCase.installProduct('Five')

class ActionsToolTests(ZopeTestCase.ZopeTestCase):

    def afterSetUp(self):
        self.folder.manage_addProduct['CMFonFive'].manage_addTool(
            'Five Actions Tool')
        self.login()

    def test_ActionsToolDocument(self):
        tool = getToolByName(self.folder, 'portal_fiveactions')
        # The action created for the content should appear in the list
        # of actions for such content
        self.folder.manage_addProduct['CMFonFiveTest'].manage_addCMFContent(
            'content', 'Content Title')
        newInteraction()
        actions = tool.listActions(object=self.folder.content)
        action_names = [action.id for action in actions]
        self.failUnless('action_content_public.html' in action_names,
            'Expected menu item was not found in action list')
        # But not the protected action:
        self.failIf('action_content_protected.html' in action_names,
            'Protected menu item was found in action list')
        # And there should be no actions anywhere else:
        self.failUnlessEqual(list(tool.listActions(object=self.folder)), [])


def test_suite():
    suite = unittest.TestSuite()
    suite.addTest(unittest.makeSuite(ActionsToolTests))
    return suite




if __name__ == '__main__':
    unittest.main()
