
from Products.CMFCore import CMFCorePermissions
from AccessControl import ClassSecurityInfo
from Globals import InitializeClass

from Products.CMFDefault.SkinnedFolder import SkinnedFolder
from Products.BTreeFolder2.BTreeFolder2 import BTreeFolder2Base
from Acquisition import aq_base

factory_type_information =  { 'id'             : 'Photo Album',
                              'meta_type'      : 'Photo Album',
                              'description'    : """Photo Albums contain other albums or images..""",
                              'icon'           : 'photoalbum_icon.gif',
                              'product'        : 'CMFPhotoAlbum',
                              'factory'        : 'addPhotoAlbum',
                              'filter_content_types' : 1,
                              'allowed_content_types' : ('Photo', 'Photo Album'),
                              'immediate_view' : 'photoalbum_view',
                              'actions'        :
                              ( { 'id'            : 'view',
                                  'name'          : 'View',
                                  'action'        : 'photoalbum_view',
                                  'permissions'   : (CMFCorePermissions.View,),
                                  'category'      : 'folder'},
                                { 'id'            : 'local_roles',
                                  'name'          : 'Local Roles',
                                  'action'        : 'folder_localrole_form',
                                  'permissions'   : (CMFCorePermissions.ManageProperties,),
                                  'category'      : 'folder'},
                                { 'id'            : 'edit',
                                  'name'          : 'Properties',
                                  'action'        : 'portal_form/folder_edit_form',
                                  'permissions'   : (CMFCorePermissions.ManageProperties,),
                                  'category'      : 'folder'
                                  },
                                { 'id'            : 'mkdir',
                                  'name'          : 'mkdir',
                                  'action'        : 'createPhotoAlbumInstance',
                                  'permissions'   : (CMFCorePermissions.AddPortalContent,),
                                  'category'      : 'folder',
                                  'visible'       : 0
                                  }
                                )
                              }

class PhotoAlbum (BTreeFolder2Base, SkinnedFolder):
    meta_type = 'Photo Album'
    
    security=ClassSecurityInfo()

    # this is needed to allow discussion in the album
    # but disabled because it doesn't work with the current implementation
    # of cmfbacktalk
    #isPortalContent = 1
    #_isPortalContent = 1 

    def __init__(self, id, title=''):
        BTreeFolder2Base.__init__(self, id)
        SkinnedFolder.__init__(self, id)
        self.title = title

    def _checkId(self, id, allow_dup=0):
        SkinnedFolder._checkId(self, id, allow_dup)
        BTreeFolder2Base._checkId(self, id, allow_dup)


    security.declarePrivate('PUT_factory')
    def PUT_factory( self, name, typ, body ):
        """
        Dispatcher for PUT requests to non-existent IDs.
        PhotoAlbums should always use photos for images.
        """
        if typ.startswith('image'):
            self.invokeFactory( 'Photo', name )

            # XXX: this is butt-ugly.
            obj = aq_base( self._getOb( name ) )
            self._delObject( name )
            return obj
   
    security.declareProtected(CMFCorePermissions.View, 'SearchableText')
    def SearchableText(self):
        """ Used by the catalog for basic full text indexing """
        return "%s %s" % ( self.title_or_id(), self.description )  
    
    security.declareProtected(CMFCorePermissions.View, 'listPhotos')
    def listPhotos(self):
        """ lists the photos in the album """
        return self.listFolderContents(contentFilter={'Type':('Photo',)})
    
    security.declareProtected(CMFCorePermissions.View, 'listPhotoAlbums')
    def listPhotoAlbums(self):
        """ lists the children albums """
        return self.listFolderContents(contentFilter={'Type':('Photo Album',)})
    
    security.declareProtected(CMFCorePermissions.View, 'listOtherContents')
    def listOtherContents(self):
        """ lists all other contents except Photo and Photo Album """
        allowedContentTypes = self.getTypeInfo().allowed_content_types

        # filter is a builtin reserved name!
        filtered = [type for type in allowedContentTypes if type not in ['Photo', 'Photo Album'] ]
        
        if filtered:
            return self.listFolderContents(contentFilter={'Type':filter})

def addPhotoAlbum( self, id, title='', description='', REQUEST=None ):
    """ adds a Photo Album """
    sf = PhotoAlbum(id)
    sf.title=title
    sf.description=description
    self._setObject( id, sf )
    if REQUEST is not None:
        REQUEST['RESPONSE'].redirect( sf.absolute_url() + '/manage_main' )

InitializeClass(PhotoAlbum)
