from Products.CMFCore.utils import getToolByName
from Products.DCWorkflow.Transitions import TRIGGER_AUTOMATIC, TRIGGER_WORKFLOW_METHOD
from Products.DCWorkflow.Default import p_request, p_review
from Products import CMFMember
from Products.CMFMember import permission
from Products.CMFCore import CMFCorePermissions
from Products.CMFMember.Extensions import MemberApprovalWorkflow
from Products.CMFMember.Extensions import MemberAutoWorkflow
from Products.CMFMember.utils import logException

# Execute the 'trigger' transition -- this should trigger
# any automatic transitions for which the guard conditions
# are satisfied.
def triggerAutomaticTransitions(ob):
    wf_tool=getToolByName(ob, 'portal_workflow')
    if 'trigger' in [action.get('id',None) for action in wf_tool.getActionsFor(ob)]:
        wf_tool.doActionFor(ob, 'trigger')


def addWorkflowScripts(wf):
    if not 'register' in wf.scripts.objectIds():
        wf.scripts.manage_addProduct['ExternalMethod'].manage_addExternalMethod('register', 'Register a Member', 'CMFMember.Workflow', 'register')
    if not 'autoRegister' in wf.scripts.objectIds():
        wf.scripts.manage_addProduct['ExternalMethod'].manage_addExternalMethod('autoRegister', 'Auto-Register a Member', 'CMFMember.Workflow', 'autoRegister')
    if not 'disable' in wf.scripts.objectIds():
        wf.scripts.manage_addProduct['ExternalMethod'].manage_addExternalMethod('disable', 'Disable a Member', 'CMFMember.Workflow', 'disable')
    if not 'enable' in wf.scripts.objectIds():
        wf.scripts.manage_addProduct['ExternalMethod'].manage_addExternalMethod('enable', 'Enable a Member', 'CMFMember.Workflow', 'enable')
    if not 'makePublic' in wf.scripts.objectIds():
        wf.scripts.manage_addProduct['ExternalMethod'].manage_addExternalMethod('makePublic', 'Make a Member profile public', 'CMFMember.Workflow', 'makePublic')
    if not 'makePrivate' in wf.scripts.objectIds():
        wf.scripts.manage_addProduct['ExternalMethod'].manage_addExternalMethod('makePrivate', 'Make a Member profile private', 'CMFMember.Workflow', 'makePrivate')

def setupWorkflow(context, out, force_reinstall=None):
    wf_tool=getToolByName(context, 'portal_workflow')
    
    workflows = { 'member_approval_workflow' : 'member_approval_workflow (Portal Member Workflow: Approval Required)',
                  'member_auto_workflow'     : 'member_auto_workflow (Portal Member Workflow: Automatic Approval)' }
    
    exist = lambda wf: wf in wf_tool.objectIds() 
   
    for wf in workflows.keys():
        if exist(wf) and force_reinstall:
            wf_tool.manage_delObjects([wf])
        if not exist(wf):
            wf_tool.manage_addWorkflow( workflows[wf],
                                        wf)
            addWorkflowScripts(wf_tool[wf])
    
    wf_tool.setChainForPortalTypes(('ControlTool',), '')
    wf_tool.updateRoleMappings()
    wf_tool.setChainForPortalTypes(('MemberDataContainer',), 'folder_workflow')

    # NOTE: updateRoleMappings is called later, during SetupMember
    # We need to do the updateRoleMappings only once after all workflows
    # have been set because otherwise the empty one (i.e ControlTool) are
    # reseted to (Default)

# call the Member object's method
def register(self, state_change):
    obj=state_change.object
    return obj.cm_register()

# call the Member object's method
def autoRegister(self, state_change):
    obj=state_change.object
    return obj.cm_register(auto=1)

# Reset password, set old_state and update listed attribute
def disable(self, state_change):
    obj=state_change.object
    try:
        obj.cm_resetPassword()
        workflow_tool = getToolByName(obj, 'portal_workflow')
        obj.old_state = workflow_tool.getInfoFor(obj, 'review_state', '')
        obj.cm_updateListed()
    except:
         # write tracebacks because otherwise workflow will swallow exceptions
        logException()
        raise

# Delete old_state and update listed attribute
def enable(self, state_change):
    obj=state_change.object
    try:
        if hasattr(obj, 'old_state'):
            delattr(obj, 'old_state')
        obj.cm_updateListed()
    except:
        # write tracebacks because otherwise workflow will swallow exceptions
        logException()
        raise

    # When member is disabled, member's password is reset
    # When member is enabled, email new password to the member
    try:
        obj.mailPassword()
    except:
        pass

# Update listed attribute
def makePublic(self, state_change):
    obj=state_change.object
    try:
        obj.cm_updateListed()
    except:
        # write tracebacks because otherwise workflow will swallow exceptions
        logException()
        raise

# Update listed attribute
def makePrivate(self, state_change):
    obj=state_change.object
    try:
        obj.cm_updateListed()
    except:
        # write tracebacks because otherwise workflow will swallow exceptions
        logException()
        raise
