/*
 * This file is part of the ZoneMinder Project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#ifndef ZONEMINDER_SRC_ZM_DEFINE_H_
#define ZONEMINDER_SRC_ZM_DEFINE_H_

// These macros have not been adopted by the C++11 standard.
// However glibc 2.17 (CentOS 7) still depends on them to provide the macros which are guarded by these defines.
#if !defined(__STDC_FORMAT_MACROS)
#  define __STDC_FORMAT_MACROS
#endif
#if !defined(__STDC_CONSTANT_MACROS)
#  define __STDC_CONSTANT_MACROS
#endif

#include <cinttypes>
#include <cstddef>

typedef std::int64_t int64;
typedef std::int32_t int32;
typedef std::int16_t int16;
typedef std::int8_t int8;
typedef std::uint64_t uint64;
typedef std::uint32_t uint32;
typedef std::uint16_t uint16;
typedef std::uint8_t uint8;

#ifndef FALLTHROUGH
#if defined(__clang__)
#define FALLTHROUGH [[clang::fallthrough]]
#elif defined(__GNUC__) && __GNUC__ >= 7
#define FALLTHROUGH [[gnu::fallthrough]]
#else
#define FALLTHROUGH
#endif
#endif

#endif // ZONEMINDER_SRC_ZM_DEFINE_H_
