package ONVIF::Analytics::Types::NetworkCapabilities;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %IPFilter_of :ATTR(:get<IPFilter>);
my %ZeroConfiguration_of :ATTR(:get<ZeroConfiguration>);
my %IPVersion6_of :ATTR(:get<IPVersion6>);
my %DynDNS_of :ATTR(:get<DynDNS>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        IPFilter
        ZeroConfiguration
        IPVersion6
        DynDNS
        Extension

    ) ],
    {
        'IPFilter' => \%IPFilter_of,
        'ZeroConfiguration' => \%ZeroConfiguration_of,
        'IPVersion6' => \%IPVersion6_of,
        'DynDNS' => \%DynDNS_of,
        'Extension' => \%Extension_of,
    },
    {
        'IPFilter' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'ZeroConfiguration' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'IPVersion6' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'DynDNS' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'Extension' => 'ONVIF::Analytics::Types::NetworkCapabilitiesExtension',
    },
    {

        'IPFilter' => 'IPFilter',
        'ZeroConfiguration' => 'ZeroConfiguration',
        'IPVersion6' => 'IPVersion6',
        'DynDNS' => 'DynDNS',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Analytics::Types::NetworkCapabilities

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
NetworkCapabilities from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * IPFilter


=item * ZeroConfiguration


=item * IPVersion6


=item * DynDNS


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Analytics::Types::NetworkCapabilities
   IPFilter =>  $some_value, # boolean
   ZeroConfiguration =>  $some_value, # boolean
   IPVersion6 =>  $some_value, # boolean
   DynDNS =>  $some_value, # boolean
   Extension =>  { # ONVIF::Analytics::Types::NetworkCapabilitiesExtension
     Dot11Configuration =>  $some_value, # boolean
     Extension =>  { # ONVIF::Analytics::Types::NetworkCapabilitiesExtension2
     },
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

