SET DEFINE OFF
INSERT INTO role (roleid,name,type,readonly)
values ('1','User role','1','0')
/

INSERT INTO role (roleid,name,type,readonly)
values ('2','Admin role','2','0')
/

INSERT INTO role (roleid,name,type,readonly)
values ('3','Super admin role','3','1')
/

INSERT INTO role (roleid,name,type,readonly)
values ('4','Guest role','1','0')
/

INSERT INTO ugset (ugsetid,hash)
values ('1','b21d61561974b06cbeb97a71ca880e92f0fc06d49ac3246280afb88dfa6050a6')
/

INSERT INTO users (userid,username,name,surname,passwd,url,autologin,autologout,refresh,rows_per_page,roleid)
values ('1','Admin','Zabbix','Administrator','$2y$10$92nDno4n0Zm7Ej7Jfsz8WukBfgSS/U0QkIuu8WkJPihXBb2A1UrEK','','1','0','30s','50','3')
/

INSERT INTO users (userid,username,name,surname,passwd,url,autologin,autologout,refresh,rows_per_page,roleid)
values ('2','guest','','','$2y$10$89otZrRNmde97rIyzclecuk6LwKAsHN0BcvoOKGjbT.BwMBfm7G06','','0','15m','30s','50','4')
/

INSERT INTO hstgrp (groupid,name,flags,uuid,type)
values ('1','Templates','0','7df96b18c230490a9a0a9e2307226338','1')
/

INSERT INTO hstgrp (groupid,name,flags,uuid,type)
values ('2','Linux servers','0','dc579cd7a1a34222933f24f52a68bcd8','0')
/

INSERT INTO hstgrp (groupid,name,flags,uuid,type)
values ('4','Zabbix servers','0','6f6799aa69e844b4b3918f779f2abf08','0')
/

INSERT INTO hstgrp (groupid,name,flags,uuid,type)
values ('5','Discovered hosts','0','f2481361f99448eea617b7b1d4765566','0')
/

INSERT INTO hstgrp (groupid,name,flags,uuid,type)
values ('6','Virtual machines','0','137f19e6e2dc4219b33553b812627bc2','0')
/

INSERT INTO hstgrp (groupid,name,flags,uuid,type)
values ('7','Hypervisors','0','1b837a3c078647049a0c00c61b4d57b5','0')
/

INSERT INTO hstgrp (groupid,name,flags,uuid,type)
values ('9','Templates/Network devices','0','36bff6c29af64692839d077febfc7079','1')
/

INSERT INTO hstgrp (groupid,name,flags,uuid,type)
values ('10','Templates/Operating systems','0','846977d1dfed4968bc5f8bdb363285bc','1')
/

INSERT INTO hstgrp (groupid,name,flags,uuid,type)
values ('11','Templates/Server hardware','0','e960332b3f6c46a1956486d4f3f99fce','1')
/

INSERT INTO hstgrp (groupid,name,flags,uuid,type)
values ('12','Templates/Applications','0','a571c0d144b14fd4a87a9d9b2aa9fcd6','1')
/

INSERT INTO hstgrp (groupid,name,flags,uuid,type)
values ('13','Templates/Databases','0','748ad4d098d447d492bb935c907f652f','1')
/

INSERT INTO hstgrp (groupid,name,flags,uuid,type)
values ('14','Templates/Virtualization','0','02e4df4f20b848e79267641790f241da','1')
/

INSERT INTO hstgrp (groupid,name,flags,uuid,type)
values ('15','Templates/Telephony','0','1d12408342854fd5a4436dd6d5d1bd4a','1')
/

INSERT INTO hstgrp (groupid,name,flags,uuid,type)
values ('16','Templates/SAN','0','7c2cb727f85b492d88cd56e17127c64d','1')
/

INSERT INTO hstgrp (groupid,name,flags,uuid,type)
values ('17','Templates/Video surveillance','0','d37f71c7e3f7469bab645852a69a2018','1')
/

INSERT INTO hstgrp (groupid,name,flags,uuid,type)
values ('18','Templates/Power','0','3dcd5bbe90534f9e8eb5c2d53756af63','1')
/

INSERT INTO hstgrp (groupid,name,flags,uuid,type)
values ('19','Applications','0','a571c0d144b14fd4a87a9d9b2aa9fcd6','0')
/

INSERT INTO hstgrp (groupid,name,flags,uuid,type)
values ('20','Databases','0','748ad4d098d447d492bb935c907f652f','0')
/

INSERT INTO hstgrp (groupid,name,flags,uuid,type)
values ('21','Templates/Cloud','0','c2c162144c2d4c5491c8801193af4945','1')
/

INSERT INTO drules (druleid,proxyid,name,iprange,delay,status,concurrency_max)
values ('2',NULL,'Local network','192.168.0.1-254','1h','1','0')
/

INSERT INTO dchecks (dcheckid,druleid,type,key_,snmp_community,ports,snmpv3_securityname,snmpv3_securitylevel,snmpv3_authpassphrase,snmpv3_privpassphrase,uniq,snmpv3_authprotocol,snmpv3_privprotocol,snmpv3_contextname,host_source,name_source,allow_redirect)
values ('2','2','9','system.uname','','10050','','0','','','0','0','0','','1','0','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('1','0','Email','mail.example.com','example.com','zabbix@example.com','','','','','25','0','0','0','0','1','3','10s','0','','30s','0','0','','','','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('3','2','SMS','','','','','/dev/ttyS0','','','25','0','0','0','0','1','3','10s','1','','30s','0','0','','','','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('4','0','Email (HTML)','mail.example.com','example.com','zabbix@example.com','','','','','25','0','0','0','0','1','3','10s','1','','30s','0','0','','','','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('5','4','Mattermost','','','','','','','','25','0','0','0','0','1','1','10s','1',TO_NCLOB('var SEVERITY_COLORS = [' || chr(13) || chr(10) || '    ''#97AAB3'', ''#7499FF'', ''#FFC859'',' || chr(13) || chr(10) || '    ''#FFA059'', ''#E97659'', ''#E45959''' || chr(13) || chr(10) || '];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'var RESOLVE_COLOR = ''#009900'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'var SEND_MODE_HANDLERS = {' || chr(13) || chr(10) || '    alarm: handlerAlarm,' || chr(13) || chr(10) || '    event: handlerEvent' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'if (!String.prototype.format) {' || chr(13) || chr(10) || '    String.prototype.format = function() {' || chr(13) || chr(10) || '        var args = arguments;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return this.replace(/{(\d+)}/g, function(match, number) {' || chr(13) || chr(10) || '            return number in args' || chr(13) || chr(10) || '                ? args[number]' || chr(13) || chr(10) || '                : match' || chr(13) || chr(10) || '            ;' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '    };' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function isEventProblem(params) {' || chr(13) || chr(10) || '    return params.event_value == 1' || chr(13) || chr(10) || '        && params.event_update_status == 0' || chr(13) || chr(10) || '    ;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function isEventUpdate(params) {' || chr(13) || chr(10) || '    return params.event_value == 1' || chr(13) || chr(10) || '        && params.event_update_status == 1' || chr(13) || chr(10) || '    ;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function isEventResolve(params) {' || chr(13) || chr(10) || '    return params.event_value == 0;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function getPermalink(mattermost_url, team_name, postid) {' || chr(13) || chr(10) || '')||
TO_NCLOB('    return ''{0}/{1}/pl/{2}''.format(' || chr(13) || chr(10) || '        mattermost_url.replace(/\/+$/, ''''),' || chr(13) || chr(10) || '        team_name,' || chr(13) || chr(10) || '        postid' || chr(13) || chr(10) || '    );' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function getChannel(send_to) {' || chr(13) || chr(10) || '    switch (true) {' || chr(13) || chr(10) || '        case /.+\/#.+/.test(send_to):' || chr(13) || chr(10) || '            return getChannelByName(send_to);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        case /@.+/.test(send_to):' || chr(13) || chr(10) || '            return getDirectChannel(send_to);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        default:' || chr(13) || chr(10) || '            return getChannelByID(send_to);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function getChannelByName(send_to) {' || chr(13) || chr(10) || '    var team_chan = send_to' || chr(13) || chr(10) || '        .trim()' || chr(13) || chr(10) || '        .split(''/#'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var resp = JSON.parse(req.get(' || chr(13) || chr(10) || '        Mattermost.channel_byname.format(team_chan[0], team_chan[1]),' || chr(13) || chr(10) || '        JSON.stringify(fields)' || chr(13) || chr(10) || '    )' || chr(13) || chr(10) || '    );' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (req.getStatus() != 200) {' || chr(13) || chr(10) || '        throw ''[{0}] {1}''.format(resp.status_code, resp.message);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return resp;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function getDirectChannel(send_to) {' || chr(13) || chr(10) || '    Zabbix.log(5, ''[ Mattermost Webhook ] Call {0}({1})''.format(' || chr(13) || chr(10) || '        arguments.callee.name,' || chr(13) || chr(10) || '')||
TO_NCLOB('        JSON.stringify(arguments)' || chr(13) || chr(10) || '    ));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var teamUser = send_to' || chr(13) || chr(10) || '            .trim()' || chr(13) || chr(10) || '            .split(''/@''),' || chr(13) || chr(10) || '        bot = getBotUser(),' || chr(13) || chr(10) || '        user = getUserByName(teamUser[1]);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var resp = JSON.parse(req.post(' || chr(13) || chr(10) || '        Mattermost.direct_channel,' || chr(13) || chr(10) || '        JSON.stringify([bot.id, user.id])' || chr(13) || chr(10) || '    )' || chr(13) || chr(10) || '    );' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Zabbix.log(5, ''[ Mattermost Webhook ] Result {0}: {1}''.format(' || chr(13) || chr(10) || '        arguments.callee.name,' || chr(13) || chr(10) || '        JSON.stringify(resp)' || chr(13) || chr(10) || '    ));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (req.getStatus() != 201) {' || chr(13) || chr(10) || '        throw ''[{0}] {1}''.format(resp.status_code, resp.message);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    resp.team_name = teamUser[0];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return resp;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function getChannelByID(channelID) {' || chr(13) || chr(10) || '    Zabbix.log(5, ''[ Mattermost Webhook ] Call {0}({1})''.format(' || chr(13) || chr(10) || '        arguments.callee.name,' || chr(13) || chr(10) || '        JSON.stringify(arguments)' || chr(13) || chr(10) || '    ));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var resp = JSON.parse(req.get(' || chr(13) || chr(10) || '        Mattermost.get_channel.format(channelID),' || chr(13) || chr(10) || '        JSON.stringify(fields)' || chr(13) || chr(10) || '    )' || chr(13) || chr(10) || '    );' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    Zabbix.log(5, ''[ Mattermost Webhook ] Result {0}: {1}''.format(' || chr(13) || chr(10) || '        arguments.callee.name,' || chr(13) || chr(10) || '        JSON.stringify(resp)' || chr(13) || chr(10) || '    ));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (req.getStatus() != 200) {' || chr(13) || chr(10) || '        throw ''[{0}] {1}''.format(resp.status_code, resp.message);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return resp;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function getBotUser() {' || chr(13) || chr(10) || '    Zabbix.log(5, ''[ Mattermost Webhook ] Call {0}({1})''.format(' || chr(13) || chr(10) || '        arguments.callee.name,' || chr(13) || chr(10) || '        JSON.stringify(arguments)' || chr(13) || chr(10) || '    ));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var resp = JSON.parse(req.get(' || chr(13) || chr(10) || '        Mattermost.bot_user,' || chr(13) || chr(10) || '        JSON.stringify(fields)' || chr(13) || chr(10) || '    )' || chr(13) || chr(10) || '    );' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Zabbix.log(5, ''[ Mattermost Webhook ] Result {0}: {1}''.format(' || chr(13) || chr(10) || '        arguments.callee.name,' || chr(13) || chr(10) || '        JSON.stringify(resp)' || chr(13) || chr(10) || '    ));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (req.getStatus() != 200) {' || chr(13) || chr(10) || '        throw ''[{0}] {1}''.format(resp.status_code, resp.message);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return resp;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function getUserByName(userName) {' || chr(13) || chr(10) || '    Zabbix.log(5, ''[ Mattermost Webhook ] Call {0}({1})''.format(' || chr(13) || chr(10) || '        arguments.callee.name,' || chr(13) || chr(10) || '        JSON.stringify(arguments)' || chr(13) || chr(10) || '')||
TO_NCLOB('    ));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var resp = JSON.parse(req.get(' || chr(13) || chr(10) || '        Mattermost.user_byname.format(userName),' || chr(13) || chr(10) || '        JSON.stringify(fields)' || chr(13) || chr(10) || '    )' || chr(13) || chr(10) || '    );' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Zabbix.log(5, ''[ Mattermost Webhook ] Result {0}: {1}''.format(' || chr(13) || chr(10) || '        arguments.callee.name,' || chr(13) || chr(10) || '        JSON.stringify(resp)' || chr(13) || chr(10) || '    ));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (req.getStatus() != 200) {' || chr(13) || chr(10) || '        throw ''[{0}] {1}''.format(resp.status_code, resp.message);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return resp;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function getTeamByID(teamID) {' || chr(13) || chr(10) || '    Zabbix.log(5, ''[ Mattermost Webhook ] Call {0}({1})''.format(' || chr(13) || chr(10) || '        arguments.callee.name,' || chr(13) || chr(10) || '        JSON.stringify(arguments)' || chr(13) || chr(10) || '    ));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var resp = JSON.parse(req.get(' || chr(13) || chr(10) || '        Mattermost.get_team.format(teamID),' || chr(13) || chr(10) || '        JSON.stringify(fields)' || chr(13) || chr(10) || '    )' || chr(13) || chr(10) || '    );' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Zabbix.log(5, ''[ Mattermost Webhook ] Result {0}: {1}''.format(' || chr(13) || chr(10) || '        arguments.callee.name,' || chr(13) || chr(10) || '        JSON.stringify(resp)' || chr(13) || chr(10) || '    ));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (req.getStatus() != 200) {' || chr(13) || chr(10) || '        throw ''[{0}] {1}''.format(resp.status_code, resp.message);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    return resp;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function createProblemURL(zabbix_url, triggerid, eventid, event_source) {' || chr(13) || chr(10) || '    var problem_url = '''';' || chr(13) || chr(10) || '    if (event_source === ''0'') {' || chr(13) || chr(10) || '        problem_url = ''{0}/tr_events.php?triggerid={1}&eventid={2}''' || chr(13) || chr(10) || '            .format(' || chr(13) || chr(10) || '                zabbix_url,' || chr(13) || chr(10) || '                triggerid,' || chr(13) || chr(10) || '                eventid' || chr(13) || chr(10) || '            );' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        problem_url = zabbix_url;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return problem_url;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function getTagValue(event_tags, key) {' || chr(13) || chr(10) || '    var pattern = new RegExp(''('' + key + '':.+)'');' || chr(13) || chr(10) || '    var tagValue = event_tags' || chr(13) || chr(10) || '        .split('','')' || chr(13) || chr(10) || '        .filter(function (v) {' || chr(13) || chr(10) || '            return v.match(pattern);' || chr(13) || chr(10) || '        })' || chr(13) || chr(10) || '        .map(function (v) {' || chr(13) || chr(10) || '            return v.split('':'')[1];' || chr(13) || chr(10) || '        })[0]' || chr(13) || chr(10) || '        || 0;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return tagValue;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function handlerAlarm(req, params) {' || chr(13) || chr(10) || '    var channel = getChannel(params.send_to);' || chr(13) || chr(10) || '    var fields = {' || chr(13) || chr(10) || '        channel_id: channel.id,' || chr(13) || chr(10) || '        props: {}' || chr(13) || chr(10) || '    };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    if (isEventProblem(params)) {' || chr(13) || chr(10) || '        var team_name = channel.team_name' || chr(13) || chr(10) || '            ? channel.team_name' || chr(13) || chr(10) || '            : getTeamByID(channel.team_id).name;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        fields.props.attachments = [' || chr(13) || chr(10) || '            createMessage(' || chr(13) || chr(10) || '                SEVERITY_COLORS[params.event_nseverity] || 0,' || chr(13) || chr(10) || '                params.event_date,' || chr(13) || chr(10) || '                params.event_time,' || chr(13) || chr(10) || '                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)' || chr(13) || chr(10) || '            )' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var resp = JSON.parse(req.post(' || chr(13) || chr(10) || '            Mattermost.post_message,' || chr(13) || chr(10) || '            JSON.stringify(fields)' || chr(13) || chr(10) || '        )' || chr(13) || chr(10) || '        );' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (req.getStatus() != 201) {' || chr(13) || chr(10) || '            throw ''[{0}] {1}''.format(resp.status_code, resp.message);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result.tags.__mattermost_post_id = resp.id;' || chr(13) || chr(10) || '        result.tags.__mattermost_channel_id = channel.id;' || chr(13) || chr(10) || '        result.tags.__mattermost_channel_name = channel.name;' || chr(13) || chr(10) || '        result.tags.__mattermost_message_link = getPermalink(' || chr(13) || chr(10) || '            params.mattermost_url,' || chr(13) || chr(10) || '            team_name,' || chr(13) || chr(10) || '            resp.id' || chr(13) || chr(10) || '        );' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '')||
TO_NCLOB('    else if (isEventUpdate(params)) {' || chr(13) || chr(10) || '        fields.root_id = getTagValue(params.event_tags, ''mattermost_post_id'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (params.event_source === ''0'') {}' || chr(13) || chr(10) || '        fields.props.attachments = [' || chr(13) || chr(10) || '            createMessage(' || chr(13) || chr(10) || '                SEVERITY_COLORS[params.event_nseverity] || 0,' || chr(13) || chr(10) || '                params.event_update_date,' || chr(13) || chr(10) || '                params.event_update_time,' || chr(13) || chr(10) || '                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source),' || chr(13) || chr(10) || '                true' || chr(13) || chr(10) || '            )' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        resp = JSON.parse(req.post(' || chr(13) || chr(10) || '            Mattermost.post_message, JSON.stringify(fields)' || chr(13) || chr(10) || '        )' || chr(13) || chr(10) || '        );' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (req.getStatus() != 201) {' || chr(13) || chr(10) || '            throw ''[{0}] {1}''.format(resp.status_code, resp.message);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else if (isEventResolve(params)) {' || chr(13) || chr(10) || '        fields.channel_id = getTagValue(params.event_tags, ''mattermost_channel_id'');' || chr(13) || chr(10) || '        fields.id = getTagValue(params.event_tags, ''mattermost_post_id'');' || chr(13) || chr(10) || '        fields.props.attachments = [' || chr(13) || chr(10) || '            createMessage(' || chr(13) || chr(10) || '                RESOLVE_COLOR,' || chr(13) || chr(10) || '                params.event_date,' || chr(13) || chr(10) || '                params.event_time,' || chr(13) || chr(10) || '')||
TO_NCLOB('                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)' || chr(13) || chr(10) || '            )' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var post_id = getTagValue(params.event_tags, ''mattermost_post_id'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        resp = JSON.parse(req.put(' || chr(13) || chr(10) || '            Mattermost.chat_update.format(post_id),' || chr(13) || chr(10) || '            JSON.stringify(fields)' || chr(13) || chr(10) || '        )' || chr(13) || chr(10) || '        );' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (req.getStatus() != 200) {' || chr(13) || chr(10) || '            throw ''[{0}] {1}''.format(resp.status_code, resp.message);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function handlerEvent(req, params) {' || chr(13) || chr(10) || '    var channel = getChannel(params.send_to);' || chr(13) || chr(10) || '    var fields = {' || chr(13) || chr(10) || '        channel_id: channel.id,' || chr(13) || chr(10) || '        props: {}' || chr(13) || chr(10) || '    };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (isEventProblem(params)) {' || chr(13) || chr(10) || '        var team_name = channel.team_name' || chr(13) || chr(10) || '            ? channel.team_name' || chr(13) || chr(10) || '            : getTeamByID(channel.team_id).name;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        fields.props.attachments = [' || chr(13) || chr(10) || '            createMessage(' || chr(13) || chr(10) || '                SEVERITY_COLORS[params.event_nseverity] || 0,' || chr(13) || chr(10) || '                params.event_date,' || chr(13) || chr(10) || '                params.event_time,' || chr(13) || chr(10) || '                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)' || chr(13) || chr(10) || '            )' || chr(13) || chr(10) || '')||
TO_NCLOB('        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var resp = JSON.parse(req.post(Mattermost.post_message, JSON.stringify(fields)));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (req.getStatus() != 201) {' || chr(13) || chr(10) || '            throw ''[{0}] {1}''.format(resp.status_code, resp.message);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result.tags.__mattermost_channel_name = channel.name;' || chr(13) || chr(10) || '        result.tags.__mattermost_message_link = getPermalink(' || chr(13) || chr(10) || '            params.mattermost_url,' || chr(13) || chr(10) || '            team_name,' || chr(13) || chr(10) || '            resp.id' || chr(13) || chr(10) || '        );' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else if (isEventUpdate(params)) {' || chr(13) || chr(10) || '        fields.props.attachments = [' || chr(13) || chr(10) || '            createMessage(' || chr(13) || chr(10) || '                SEVERITY_COLORS[params.event_nseverity] || 0,' || chr(13) || chr(10) || '                params.event_update_date,' || chr(13) || chr(10) || '                params.event_update_time,' || chr(13) || chr(10) || '                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source),' || chr(13) || chr(10) || '                false' || chr(13) || chr(10) || '            )' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        resp = JSON.parse(req.post(Mattermost.post_message, JSON.stringify(fields)));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (req.getStatus() != 201) {' || chr(13) || chr(10) || '            throw ''[{0}] {1}''.format(resp.status_code, resp.message);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else if (isEventResolve(params)) {' || chr(13) || chr(10) || '')||
TO_NCLOB('        fields.props.attachments = [' || chr(13) || chr(10) || '            createMessage(' || chr(13) || chr(10) || '                RESOLVE_COLOR,' || chr(13) || chr(10) || '                params.event_recovery_date,' || chr(13) || chr(10) || '                params.event_recovery_time,' || chr(13) || chr(10) || '                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)' || chr(13) || chr(10) || '            )' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        resp = JSON.parse(req.post(Mattermost.post_message, JSON.stringify(fields)));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (req.getStatus() != 201) {' || chr(13) || chr(10) || '            throw ''[{0}] {1}''.format(resp.status_code, resp.message);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function createMessage(' || chr(13) || chr(10) || '    event_severity_color,' || chr(13) || chr(10) || '    event_date,' || chr(13) || chr(10) || '    event_time,' || chr(13) || chr(10) || '    problem_url,' || chr(13) || chr(10) || '    isShort' || chr(13) || chr(10) || ') {' || chr(13) || chr(10) || '    var message = {' || chr(13) || chr(10) || '        fallbac: params.alert_subject,' || chr(13) || chr(10) || '        title: params.alert_subject,' || chr(13) || chr(10) || '        color: event_severity_color,' || chr(13) || chr(10) || '        title_link: problem_url,' || chr(13) || chr(10) || '        footer: problem_url,' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        fields: [' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                title: ''Host'',' || chr(13) || chr(10) || '                value: ''{0} [{1}]''.format(params.host_name, params.host_ip),' || chr(13) || chr(10) || '                short: true' || chr(13) || chr(10) || '            },' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '')||
TO_NCLOB('                title: ''Event time'',' || chr(13) || chr(10) || '                value: ''{0} {1}''.format(event_date, event_time),' || chr(13) || chr(10) || '                short: true' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '    };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    ' || chr(13) || chr(10) || '    if (params.event_source === ''0'') {' || chr(13) || chr(10) || '        message.fields.push(' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                title: ''Severity'',' || chr(13) || chr(10) || '                value: params.event_severity,' || chr(13) || chr(10) || '                short: true' || chr(13) || chr(10) || '            },' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                title: ''Opdata'',' || chr(13) || chr(10) || '                value: params.event_opdata,' || chr(13) || chr(10) || '                short: true' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        );' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (!isShort && params.event_source === ''0'') {' || chr(13) || chr(10) || '        message.fields.push(' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                title: ''Event tags'',' || chr(13) || chr(10) || '                value: ''`{0}`''.format(params.event_tags.replace(/__.+?:(.+?,|.+)/g, '''') || ''None''),' || chr(13) || chr(10) || '                short: true' || chr(13) || chr(10) || '            },' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                title: ''Trigger description'',' || chr(13) || chr(10) || '                value: params.trigger_description,' || chr(13) || chr(10) || '                short: true' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        );' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    if (params.event_source !== ''0'' || params.event_update_status === ''1'') {' || chr(13) || chr(10) || '        message.fields.push(' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                title: ''Details'',' || chr(13) || chr(10) || '                value: params.alert_message,' || chr(13) || chr(10) || '                short: false' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        );' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return message;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function validateParams(params) {' || chr(13) || chr(10) || '    if (typeof params.bot_token !== ''string'' || params.bot_token.trim() === '''') {' || chr(13) || chr(10) || '        throw ''Field "bot_token" cannot be empty'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (isNaN(params.event_id)) {' || chr(13) || chr(10) || '        throw ''Field "event_id" is not a number'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: "'' + params.event_source + ''".\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'') {' || chr(13) || chr(10) || '        params.event_nseverity = ''0'';' || chr(13) || chr(10) || '        params.event_severity = ''Not classified'';' || chr(13) || chr(10) || '        params.event_update_status = ''0'';' || chr(13) || chr(10) || '        params.send_mode = ''event'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source === ''1'' || params.event_source === ''2'') {' || chr(13) || chr(10) || '        params.event_value = ''1'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '    if (params.event_source === ''1'') {' || chr(13) || chr(10) || '        params.host_name = params.discovery_host_dns;' || chr(13) || chr(10) || '        params.host_ip = params.discovery_host_ip;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_nseverity" parameter given: '' + params.event_nseverity + ''\nMust be 0-5.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.event_severity !== ''string'' || params.event_severity.trim() === '''') {' || chr(13) || chr(10) || '        throw ''Field "event_severity" cannot be empty'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.host_ip !== ''string'' || params.host_ip.trim() === '''') {' || chr(13) || chr(10) || '        throw ''Field "host_ip" cannot be empty'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.host_name !== ''string'' || params.host_name.trim() === '''') {' || chr(13) || chr(10) || '        throw ''Field "host_name" cannot be empty'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    if (typeof params.mattermost_url !== ''string'' || params.mattermost_url.trim() === '''') {' || chr(13) || chr(10) || '        throw ''Field "mattermost_url" cannot be empty'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (!/^(http|https):\/\/.+/.test(params.mattermost_url)) {' || chr(13) || chr(10) || '        throw ''Field "mattermost_url" must contain a schema'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([''alarm'', ''event''].indexOf(params.send_mode) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "send_mode" parameter given: '' + params.send_mode + ''\nMust be "alarm" or "event".'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.send_to !== ''string'' || params.send_to.trim() === '''') {' || chr(13) || chr(10) || '        throw ''Field "send_to" cannot be empty'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (isNaN(params.trigger_id) && params.event_source === ''0'') {' || chr(13) || chr(10) || '        throw ''field "trigger_id" is not a number'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.zabbix_url !== ''string'' || params.zabbix_url.trim() === '''') {' || chr(13) || chr(10) || '        throw ''Field "zabbix_url" cannot be empty'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (!/^(http|https):\/\/.+/.test(params.zabbix_url)) {' || chr(13) || chr(10) || '        throw ''Field "zabbix_url" must contain a schema'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    validateParams(params);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var req = new HttpRequest(),' || chr(13) || chr(10) || '')||
TO_NCLOB('        fields = {},' || chr(13) || chr(10) || '        result = {tags: {}};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.HTTPProxy === ''string'' && params.HTTPProxy.trim() !== '''') {' || chr(13) || chr(10) || '        req.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    req.addHeader(''Content-Type: application/json; charset=utf-8'');' || chr(13) || chr(10) || '    req.addHeader(''Authorization: Bearer '' + params.bot_token);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    params.mattermost_url = params.mattermost_url.replace(/\/+$/, '''');' || chr(13) || chr(10) || '    params.zabbix_url = params.zabbix_url.replace(/\/+$/, '''');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var APIEndpoint = params.mattermost_url + ''/api/v4/'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var Mattermost = {' || chr(13) || chr(10) || '        post_message: APIEndpoint + ''posts'',' || chr(13) || chr(10) || '        get_channel: APIEndpoint + ''channels/{0}'',' || chr(13) || chr(10) || '        get_team: APIEndpoint + ''teams/{0}'',' || chr(13) || chr(10) || '        chat_update: APIEndpoint + ''posts/{0}'',' || chr(13) || chr(10) || '        direct_channel: APIEndpoint + ''channels/direct'',' || chr(13) || chr(10) || '        channel_byname: APIEndpoint + ''teams/name/{0}/channels/name/{1}'',' || chr(13) || chr(10) || '        user_byname: APIEndpoint + ''users/username/{0}'',' || chr(13) || chr(10) || '        bot_user: APIEndpoint + ''users/me''' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    params.send_mode = params.send_mode.toLowerCase();' || chr(13) || chr(10) || '    params.send_mode = params.send_mode in SEND_MODE_HANDLERS' || chr(13) || chr(10) || '        ? params.send_mode' || chr(13) || chr(10) || '        : ''alarm'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    SEND_MODE_HANDLERS[params.send_mode](req, params);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source === ''0'') {' || chr(13) || chr(10) || '        return JSON.stringify(result);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        return ''OK'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(4, ''[ Mattermost Webhook ] Mattermost notification failed: '' + error);' || chr(13) || chr(10) || '    throw ''Mattermost notification failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__mattermost_message_link}','Open in Mattermost: {EVENT.TAGS.__mattermost_channel_name}','','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('6','4','Opsgenie','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('var method,' || chr(13) || chr(10) || '    Media = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '    name: '''',' || chr(13) || chr(10) || '    labels: [],' || chr(13) || chr(10) || '    HTTPProxy: '''',' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Media.params = params;' || chr(13) || chr(10) || '        Media.params.api += Media.params.api.endsWith(''/'') ? '''' : ''/'';' || chr(13) || chr(10) || '        Media.params.web += Media.params.web.endsWith(''/'') ? '''' : ''/'';' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setProxy: function (HTTPProxy) {' || chr(13) || chr(10) || '        if (typeof HTTPProxy !== ''undefined'' && HTTPProxy.trim() !== '''') {' || chr(13) || chr(10) || '            Media.HTTPProxy = HTTPProxy;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setTags: function(event_tags_json) {' || chr(13) || chr(10) || '        if (typeof event_tags_json !== ''undefined'' && event_tags_json !== ''''' || chr(13) || chr(10) || '                && event_tags_json !== ''{EVENT.TAGSJSON}'') {' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                var tags = JSON.parse(event_tags_json),' || chr(13) || chr(10) || '                    label;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                tags.forEach(function (tag) {' || chr(13) || chr(10) || '                    if (typeof tag.tag === ''string'') {' || chr(13) || chr(10) || '                        label = (tag.tag + (typeof tag.value !== ''undefined''' || chr(13) || chr(10) || '')||
TO_NCLOB('                                && tag.value !== '''' ? ('':'' + tag.value) : '''')).replace(/\s/g, ''_'');' || chr(13) || chr(10) || '                        Media.labels.push(label);' || chr(13) || chr(10) || '                    }' || chr(13) || chr(10) || '                });' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ '' + Media.name + '' Webhook ] Failed to parse "event_tags_json" param'');' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (method, query, data, allow_404) {' || chr(13) || chr(10) || '        if (typeof(allow_404) === ''undefined'') {' || chr(13) || chr(10) || '            allow_404 = false;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        [''api'', ''token''].forEach(function (field) {' || chr(13) || chr(10) || '            if (typeof Media.params !== ''object'' || typeof Media.params[field] === ''undefined''' || chr(13) || chr(10) || '                    || Media.params[field] === '''') {' || chr(13) || chr(10) || '                throw ''Required '' + Media.name + '' param is not set: "'' + field + ''".'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            url = Media.params.api + query,' || chr(13) || chr(10) || '            request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '        request.addHeader(''Authorization: '' + Media.params.token);' || chr(13) || chr(10) || '        request.setProxy(Media.HTTPProxy);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '')||
TO_NCLOB('        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ '' + Media.name + '' Webhook ] Sending request: '' +' || chr(13) || chr(10) || '            url + ((typeof data === ''string'') ? (''\n'' + data) : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (method) {' || chr(13) || chr(10) || '            case ''get'':' || chr(13) || chr(10) || '                response = request.get(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''post'':' || chr(13) || chr(10) || '                response = request.post(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''put'':' || chr(13) || chr(10) || '                response = request.put(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                throw ''Unsupported HTTP request method: '' + method;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ '' + Media.name + '' Webhook ] Received response with status code '' +' || chr(13) || chr(10) || '            request.getStatus() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ '' + Media.name + '' Webhook ] Failed to parse response.'');' || chr(13) || chr(10) || '                response = null;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('        if ((request.getStatus() < 200 || request.getStatus() >= 300)' || chr(13) || chr(10) || '                && (!allow_404 || request.getStatus() !== 404)) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (response !== null) {' || chr(13) || chr(10) || '                if (typeof response.errors === ''object'' && Object.keys(response.errors).length > 0) {' || chr(13) || chr(10) || '                    message += '': '' + JSON.stringify(response.errors);' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '                else if (typeof response.errorMessages === ''object'' && Object.keys(response.errorMessages).length > 0) {' || chr(13) || chr(10) || '                    message += '': '' + JSON.stringify(response.errorMessages);' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '                else if (typeof response.message === ''string'') {' || chr(13) || chr(10) || '                    message += '': '' + response.message;' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            throw message + '' Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return {' || chr(13) || chr(10) || '            status: request.getStatus(),' || chr(13) || chr(10) || '            response: response' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    getAlertId: function (requestId) {' || chr(13) || chr(10) || '        status_counter = params.status_counter || 25; ' || chr(13) || chr(10) || '        do {' || chr(13) || chr(10) || '            resp = Media.request(''get'', ''requests/'' + requestId, undefined, true);' || chr(13) || chr(10) || '        status_counter -= 1;            ' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '')||
TO_NCLOB('        while ( status_counter > 0 && ' || chr(13) || chr(10) || '            ( ' || chr(13) || chr(10) || '            typeof resp.response !== ''object'' || ' || chr(13) || chr(10) || '            typeof resp.response.data === ''undefined'' ||' || chr(13) || chr(10) || '            resp.response.data.success === false &&' || chr(13) || chr(10) || '                !resp.response.data.status.includes("There is no open alert") &&' || chr(13) || chr(10) || '                !resp.response.data.status.includes("Alert is already")' || chr(13) || chr(10) || '            ) ' || chr(13) || chr(10) || '        );' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof resp.response !== ''object'' || typeof resp.response.data === ''undefined'') {' || chr(13) || chr(10) || '            throw ''Cannot get '' + Media.name + '' issue ID. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else if (resp.response.data.success === false ) {' || chr(13) || chr(10) || '            throw Media.name + '': Operation status ('' + resp.response.data.status + '')'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return resp;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var result = {tags: {}},' || chr(13) || chr(10) || '        params = JSON.parse(value),' || chr(13) || chr(10) || '        media = {},' || chr(13) || chr(10) || '        fields = {},' || chr(13) || chr(10) || '        resp = {},' || chr(13) || chr(10) || '        responders = [],' || chr(13) || chr(10) || '        tags = [],' || chr(13) || chr(10) || '        required_params = [' || chr(13) || chr(10) || '            ''alert_subject'',' || chr(13) || chr(10) || '            ''alert_message'',' || chr(13) || chr(10) || '            ''event_id'',' || chr(13) || chr(10) || '            ''event_source'',' || chr(13) || chr(10) || '')||
TO_NCLOB('            ''event_value'',' || chr(13) || chr(10) || '            ''event_update_status'',' || chr(13) || chr(10) || '            ''opsgenie_api'',' || chr(13) || chr(10) || '            ''opsgenie_web'',' || chr(13) || chr(10) || '            ''opsgenie_token''' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        severities = [' || chr(13) || chr(10) || '            ''not_classified'',' || chr(13) || chr(10) || '            ''information'',' || chr(13) || chr(10) || '            ''warning'',' || chr(13) || chr(10) || '            ''average'',' || chr(13) || chr(10) || '            ''high'',' || chr(13) || chr(10) || '            ''disaster'',' || chr(13) || chr(10) || '            ''resolved'',' || chr(13) || chr(10) || '            ''default''' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        priority;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (required_params.indexOf(key) !== -1 && params[key].trim() === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" cannot be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            if (key.startsWith(''opsgenie_'')) {' || chr(13) || chr(10) || '                media[key.substring(9)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Possible values of event_source:' || chr(13) || chr(10) || '    // 0 - Trigger, 1 - Discovery, 2 - Autoregistration, 3 - Internal.' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: "'' + params.event_source + ''".\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    // Check event_value for trigger-based and internal events.' || chr(13) || chr(10) || '    // Possible values: 1 for problem, 0 for recovering' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check event_update_status only for trigger-based events.' || chr(13) || chr(10) || '    // Possible values: 0 - Webhook was called because of problem/recovery event, 1 - Update operation.' || chr(13) || chr(10) || '    if (params.event_source === ''0'' && params.event_update_status !== ''0'' && params.event_update_status !== ''1'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check event_id for a numeric value.' || chr(13) || chr(10) || '    if (isNaN(parseInt(params.event_id)) || params.event_id < 1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_id" parameter given: '' + params.event_id + ''\nMust be a positive number.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ((params.event_source === ''1'' || params.event_source === ''2'')  && params.event_value === ''0'') {' || chr(13) || chr(10) || '        throw ''Recovery operations are supported only for Trigger and Internal actions.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {' || chr(13) || chr(10) || '        params.event_nseverity = ''7'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    if (params.event_value === ''0'') {' || chr(13) || chr(10) || '        params.event_nseverity = ''6'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    priority = params[''severity_'' + severities[params.event_nseverity]];' || chr(13) || chr(10) || '    params.zbxurl = params.zbxurl + (params.zbxurl.endsWith(''/'') ? '''' : ''/'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Media.name = ''Opsgenie'';' || chr(13) || chr(10) || '    Media.setParams(media);' || chr(13) || chr(10) || '    Media.params.token = ''GenieKey '' + Media.params.token;' || chr(13) || chr(10) || '    Media.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    Media.setTags(params.event_tags_json); // Set Media.labels' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Create an issue.' || chr(13) || chr(10) || '    // Numeric value of the event that triggered an action (1 for problem, 0 for recovering).' || chr(13) || chr(10) || '    // Numeric value of the problem update status. Possible values:' || chr(13) || chr(10) || '    // 0 - Webhook was called because of problem/recovery event, 1 - Update operation.' || chr(13) || chr(10) || '    if ((params.event_source == 0 && params.event_value == 1 && params.event_update_status == 0)' || chr(13) || chr(10) || '            || (params.event_source == 3 && params.event_value == 1)' || chr(13) || chr(10) || '            || params.event_source == 1 || params.event_source == 2) {' || chr(13) || chr(10) || '        fields.message = params.alert_subject;' || chr(13) || chr(10) || '        fields.alias = params.event_id;' || chr(13) || chr(10) || '        fields.description = params.alert_message;' || chr(13) || chr(10) || '        fields.priority = priority;' || chr(13) || chr(10) || '        fields.source = ''Zabbix'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (params.event_source === ''0'') {' || chr(13) || chr(10) || '            fields.details = {' || chr(13) || chr(10) || '')||
TO_NCLOB('                ''Zabbix server'': params.zbxurl,' || chr(13) || chr(10) || '                Problem: params.zbxurl + ''tr_events.php?triggerid='' + params.trigger_id + ''&eventid='' + params.event_id' || chr(13) || chr(10) || '            };' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            fields.details = {''Zabbix server'': params.zbxurl};' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof params.opsgenie_teams === ''string'') {' || chr(13) || chr(10) || '            responders = params.opsgenie_teams.split('','');' || chr(13) || chr(10) || '            fields.responders = responders.map(function(team) {' || chr(13) || chr(10) || '                return {type: ''team'', name: team.trim()};' || chr(13) || chr(10) || '            });' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        fields.tags = Media.labels;' || chr(13) || chr(10) || '        if (typeof params.opsgenie_tags === ''string'') {' || chr(13) || chr(10) || '            tags = params.opsgenie_tags.split('','');' || chr(13) || chr(10) || '            tags.forEach(function(item) {' || chr(13) || chr(10) || '                fields.tags.push(item.trim());' || chr(13) || chr(10) || '            });' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        resp = Media.request(''post'', '''', fields);' || chr(13) || chr(10) || '        if (typeof resp.response !== ''object'' || typeof resp.response.result === ''undefined'') {' || chr(13) || chr(10) || '            throw ''Cannot create '' + Media.name + '' issue. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (resp.status === 202) {' || chr(13) || chr(10) || '            resp = Media.getAlertId(resp.response.requestId);' || chr(13) || chr(10) || '')||
TO_NCLOB('            if (params.event_source == 0 && params.event_value == 1 && params.event_update_status == 0) {' || chr(13) || chr(10) || '                result.tags.__zbx_ops_issuekey = resp.response.data.alertId;' || chr(13) || chr(10) || '                result.tags.__zbx_ops_issuelink = Media.params.web + ''alert/detail/'' + resp.response.data.alertId;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            throw Media.name + '' response code is unexpected. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Update or close the created issue.' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        fields.user = (params.event_value != 0) ? params.zbxuser : '''';' || chr(13) || chr(10) || '        fields.note = params.alert_message;' || chr(13) || chr(10) || '        if ( [0, 3].indexOf(parseInt(params.event_source)) > -1  && params.event_value == 0 ) {' || chr(13) || chr(10) || '            // skip sending of close request from update operation(mandatory when both update & recovery operations are defined in action)  ' || chr(13) || chr(10) || '            method = params.event_update_status == 0 ? "close" : "skip";' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else if ( params.event_source == 0 && params.event_value == 1 && params.event_update_status == 1 && params.event_update_action.includes(''acknowledged'')) {' || chr(13) || chr(10) || '            method = params.event_update_action.includes(''unacknowledged'') ? "unacknowledge" : "acknowledge";' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            method = "notes";' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (method !== "skip") {' || chr(13) || chr(10) || '        resp = Media.request(''post'', params.event_id + ''/'' + method +''?identifierType=alias'', fields);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('        if (typeof resp.response !== ''object'' || typeof resp.response.result === ''undefined'') {' || chr(13) || chr(10) || '            throw ''Cannot update '' + Media.name + '' issue. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (resp.status === 202) {' || chr(13) || chr(10) || '            resp = Media.getAlertId(resp.response.requestId);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            throw Media.name + '' response code is unexpected. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    return JSON.stringify(result);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ '' + Media.name + '' Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_ops_issuelink}','Opsgenie: {EVENT.TAGS.__zbx_ops_issuekey}','Please refer to https://docs.opsgenie.com/docs/alert-api and https://www.zabbix.com/documentation/7.0/manual/config/notifications/media/webhook#example_scripts.' || chr(13) || chr(10) || '  ' || chr(13) || chr(10) || 'Set global macro {$ZABBIX.URL} with your Zabbix server URL.' || chr(13) || chr(10) || 'Add dedicated user with media type "Opsgenie".' || chr(13) || chr(10) || 'Change the values of the variables opsgenie_api (https://api.opsgenie.com/v2/alerts or https://api.eu.opsgenie.com/v2/alerts),' || chr(13) || chr(10) || 'opsgenie_web (for example, https://myzabbix.app.opsgenie.com), opsgenie_token.','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('7','4','PagerDuty','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('try {' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        req = new HttpRequest(),' || chr(13) || chr(10) || '        fields = {},' || chr(13) || chr(10) || '        resp = '''';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Correspondence between the PagerDuty and Zabbix severity level' || chr(13) || chr(10) || '    var severityMapping = [' || chr(13) || chr(10) || '        ''info'',    // Not classified' || chr(13) || chr(10) || '        ''info'',    // Information' || chr(13) || chr(10) || '        ''warning'', // Warning' || chr(13) || chr(10) || '        ''warning'', // Average' || chr(13) || chr(10) || '        ''error'',   // High' || chr(13) || chr(10) || '        ''critical'' // Disaster' || chr(13) || chr(10) || '    ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (!severityMapping[params.severity]) {' || chr(13) || chr(10) || '        params.severity = ''0'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.HTTPProxy === ''string'' && params.HTTPProxy.trim() !== '''') {' || chr(13) || chr(10) || '        req.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (isNaN(parseInt(params.eventid)) || params.eventid < 1) {' || chr(13) || chr(10) || '        throw ''incorrect value for variable "eventid". The value must be a positive number.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    if (params.eventname.length < 1) {' || chr(13) || chr(10) || '        throw ''incorrect value for variable "eventname". The value must be a non-empty string.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    if (isNaN(parseInt(params.severity)) || (params.severity < 0 && params.severity > 5)) {' || chr(13) || chr(10) || '        throw ''incorrect value for variable "severity". The value must be a number 0..5.'';' || chr(13) || chr(10) || '')||
TO_NCLOB('    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: "'' + params.event_source + ''".\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.eventvalue !== ''0'' && params.eventvalue !== ''1''' || chr(13) || chr(10) || '        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "eventvalue" parameter given: "'' + params.eventvalue + ''".\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source === ''0'') {' || chr(13) || chr(10) || '        if (params.hostname.length < 1) {' || chr(13) || chr(10) || '            throw ''incorrect value for variable "hostname". The value must be a non-empty string.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        if (isNaN(parseInt(params.triggerid)) || params.triggerid < 1) {' || chr(13) || chr(10) || '            throw ''incorrect value for variable "triggerid". The value must be a positive number.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        if (params.eventack != ''Yes'' && params.eventack != ''No'') {' || chr(13) || chr(10) || '            throw ''incorrect value for variable "eventack". The value must be Yes or No.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        if (isNaN(parseInt(params.eventupdate)) || (params.eventupdate < 0 || params.eventupdate > 1)) {' || chr(13) || chr(10) || '            throw ''incorrect value for variable "eventupdate". The value must be 0 or 1.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    req.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    fields.routing_key = params.token;' || chr(13) || chr(10) || '    fields.dedup_key = params.eventid;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (((params.eventvalue == 1) && (params.eventupdate == 0)) || params.event_source !== ''0'') {' || chr(13) || chr(10) || '        fields.event_action = ''trigger'';' || chr(13) || chr(10) || '        fields.payload = {' || chr(13) || chr(10) || '            summary: params.eventname,' || chr(13) || chr(10) || '            source: (params.event_source === ''1'') ? ''Discovery'' : params.hostname + '' : '' + params.hostip,' || chr(13) || chr(10) || '            severity: severityMapping[params.severity],' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '        ' || chr(13) || chr(10) || '        if (params.event_source === ''0'') {' || chr(13) || chr(10) || '            fields.payload.custom_details = {' || chr(13) || chr(10) || '                ''Event date'': params.eventdate,' || chr(13) || chr(10) || '                ''Event time'': params.eventtime,' || chr(13) || chr(10) || '                ''Trigger description'': params.triggerdesc,' || chr(13) || chr(10) || '                ''Trigger opdata'': params.triggeropdata,' || chr(13) || chr(10) || '                ''Event tags'': params.eventtags,' || chr(13) || chr(10) || '                ''Event host'': params.hostname,' || chr(13) || chr(10) || '                ''Event host ip'': params.hostip' || chr(13) || chr(10) || '            };' || chr(13) || chr(10) || '            fields.links = [{' || chr(13) || chr(10) || '                href: params.url + ''/tr_events.php?triggerid='' + params.triggerid + ''&eventid='' + params.eventid,' || chr(13) || chr(10) || '                text: ''Event link''' || chr(13) || chr(10) || '            }];' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '')||
TO_NCLOB('            fields.payload.custom_details = {' || chr(13) || chr(10) || '                ''Alert message'': params.alert_message' || chr(13) || chr(10) || '            };' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        fields.client = ''Zabbix'';' || chr(13) || chr(10) || '        fields.client_url = params.url;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else if ((params.eventvalue == 1) && (params.eventupdate == 1) && (params.eventack == ''Yes''))' || chr(13) || chr(10) || '        fields.event_action = ''acknowledge'';' || chr(13) || chr(10) || '    else if (params.eventvalue == 0) {' || chr(13) || chr(10) || '        fields.event_action = ''resolve'';' || chr(13) || chr(10) || '        fields.payload = {' || chr(13) || chr(10) || '            summary: params.eventname,' || chr(13) || chr(10) || '            source: (params.event_source === ''1'') ? ''Discovery'' : params.hostname + '' : '' + params.hostip,' || chr(13) || chr(10) || '            severity: severityMapping[params.severity],' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (params.event_source === ''0'') {' || chr(13) || chr(10) || '            fields.payload.custom_details = {' || chr(13) || chr(10) || '                ''Event date'': params.eventdate,' || chr(13) || chr(10) || '                ''Event time'': params.eventtime,' || chr(13) || chr(10) || '                ''Trigger description'': params.triggerdesc,' || chr(13) || chr(10) || '                ''Trigger opdata'': params.triggeropdata,' || chr(13) || chr(10) || '                ''Event tags'': params.eventtags,' || chr(13) || chr(10) || '                ''Event host'': params.hostname,' || chr(13) || chr(10) || '                ''Event host ip'': params.hostip' || chr(13) || chr(10) || '            };' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else' || chr(13) || chr(10) || '')||
TO_NCLOB('        throw ''incorrect values. Update message without ack will not be sent.'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Zabbix.log(4, ''[PagerDuty Webhook] Sending request:'' + JSON.stringify(fields));' || chr(13) || chr(10) || '    resp = req.post(''https://events.pagerduty.com/v2/enqueue'',' || chr(13) || chr(10) || '        JSON.stringify(fields)' || chr(13) || chr(10) || '    );' || chr(13) || chr(10) || '    Zabbix.log(4, ''[PagerDuty Webhook] Receiving response:'' + resp);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    try {' || chr(13) || chr(10) || '        resp = JSON.parse(resp);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    catch (error) {' || chr(13) || chr(10) || '        throw ''incorrect response. PagerDuty returned a non-JSON object.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (req.getStatus() != 202) {' || chr(13) || chr(10) || '        if (typeof resp === ''object'' && typeof resp.errors === ''object'' && typeof resp.errors[0] === ''string'') {' || chr(13) || chr(10) || '            throw resp.errors[0];' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            throw ''Unknown error.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (resp.status != ''success'') {' || chr(13) || chr(10) || '        throw ''Unknown error.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return ''OK'';' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[PagerDuty Webhook] Notification failed : '' + error);' || chr(13) || chr(10) || '    throw ''PagerDuty notification failed : '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','0','0','','','Please refer to https://v2.developer.pagerduty.com/docs/send-an-event-events-api-v2 and https://www.zabbix.com/documentation/7.0/manual/config/notifications/media/webhook#example_scripts.' || chr(13) || chr(10) || '  ' || chr(13) || chr(10) || 'Set global macro {$ZABBIX.URL} with your Zabbix server URL.' || chr(13) || chr(10) || 'Add a dedicated user with the media type "PagerDuty" and place the integration key in the "token" parameter to integrate into the service.','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('8','4','Pushover','','','','','','','','25','0','0','0','0','0','3','10s','1',TO_NCLOB('try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        request = new HttpRequest(),' || chr(13) || chr(10) || '        data,' || chr(13) || chr(10) || '        response,' || chr(13) || chr(10) || '        severities = [' || chr(13) || chr(10) || '            {name: ''not_classified'', color: ''#97AAB3''},' || chr(13) || chr(10) || '            {name: ''information'', color: ''#7499FF''},' || chr(13) || chr(10) || '            {name: ''warning'', color: ''#FFC859''},' || chr(13) || chr(10) || '            {name: ''average'', color: ''#FFA059''},' || chr(13) || chr(10) || '            {name: ''high'', color: ''#E97659''},' || chr(13) || chr(10) || '            {name: ''disaster'', color: ''#E45959''},' || chr(13) || chr(10) || '            {name: ''resolved'', color: ''#009900''},' || chr(13) || chr(10) || '            {name: ''default'', color: ''#000000''}' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        priority;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.HTTPProxy === ''string'' && params.HTTPProxy.trim() !== '''') {' || chr(13) || chr(10) || '        request.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: "'' + params.event_source + ''".\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {' || chr(13) || chr(10) || '        params.event_nseverity = ''7'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value === ''0'') {' || chr(13) || chr(10) || '        params.event_nseverity = ''6'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    priority = params[''priority_'' + severities[params.event_nseverity].name] || params.priority_default;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (isNaN(priority) || priority < -2 || priority > 2) {' || chr(13) || chr(10) || '        throw ''"priority" should be -2..2'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source === ''0'' && isNaN(params.triggerid)) {' || chr(13) || chr(10) || '        throw ''field "triggerid" is not a number'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (isNaN(params.eventid)) {' || chr(13) || chr(10) || '        throw ''field "eventid" is not a number'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.message !== ''string'' || params.message.trim() === '''') {' || chr(13) || chr(10) || '        throw ''field "message" cannot be empty'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    data = {' || chr(13) || chr(10) || '        token: params.token,' || chr(13) || chr(10) || '        user: params.user,' || chr(13) || chr(10) || '        title: params.title,' || chr(13) || chr(10) || '        message: params.message,' || chr(13) || chr(10) || '        url: (params.event_source === ''0'') ' || chr(13) || chr(10) || '            ? params.url + ''/tr_events.php?triggerid='' + params.triggerid + ''&eventid='' + params.eventid' || chr(13) || chr(10) || '            : params.url,' || chr(13) || chr(10) || '        url_title: params.url_title,' || chr(13) || chr(10) || '')||
TO_NCLOB('        priority: priority' || chr(13) || chr(10) || '    };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (priority == 2) {' || chr(13) || chr(10) || '        if (isNaN(params.retry) || params.retry < 30) {' || chr(13) || chr(10) || '            throw ''field "retry" should be a number with value of at least 30 if "priority" is set to 2'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (isNaN(params.expire) || params.expire > 10800) {' || chr(13) || chr(10) || '            throw ''field "expire" should be a number with value of at most 10800 if "priority" is set to 2'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        data.retry = params.retry;' || chr(13) || chr(10) || '        data.expire = params.expire;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    data = JSON.stringify(data);' || chr(13) || chr(10) || '    Zabbix.log(4, ''[ Pushover Webhook ] Sending request: '' + params.endpoint + ''\n'' + data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '    response = request.post(params.endpoint, data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Zabbix.log(4, ''[ Pushover Webhook ] Received response with status code '' + request.getStatus() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (response !== null) {' || chr(13) || chr(10) || '        try {' || chr(13) || chr(10) || '            response = JSON.parse(response);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        catch (error) {' || chr(13) || chr(10) || '            Zabbix.log(4, ''[ Pushover Webhook ] Failed to parse response received from Pushover'');' || chr(13) || chr(10) || '            response = null;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    if (request.getStatus() != 200 || response === null || typeof response !== ''object'' || response.status !== 1) {' || chr(13) || chr(10) || '        if (response !== null && typeof response === ''object'' && typeof response.errors === ''object''' || chr(13) || chr(10) || '                && typeof response.errors[0] === ''string'') {' || chr(13) || chr(10) || '            throw response.errors[0];' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            throw ''Unknown error. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return ''OK'';' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(4, ''[ Pushover Webhook ] Pushover notification failed: '' + error);' || chr(13) || chr(10) || '    throw ''Pushover notification failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','0','0','','','Please refer to setup guide here: https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/pushover' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Set token parameter with to your Pushover application key.' || chr(13) || chr(10) || 'When assigning Pushover media to the Zabbix user - add user key into send to field.','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('9','4','Slack','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('var SEVERITY_COLORS = [' || chr(13) || chr(10) || '    ''#97AAB3'', ''#7499FF'', ''#FFC859'',' || chr(13) || chr(10) || '    ''#FFA059'', ''#E97659'', ''#E45959''' || chr(13) || chr(10) || '];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'var RESOLVE_COLOR = ''#009900'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'var SLACK_MODE_HANDLERS = {' || chr(13) || chr(10) || '    alarm: handlerAlarm,' || chr(13) || chr(10) || '    event: handlerEvent' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'if (!String.prototype.format) {' || chr(13) || chr(10) || '    String.prototype.format = function() {' || chr(13) || chr(10) || '        var args = arguments;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return this.replace(/{(\d+)}/g, function(match, number) {' || chr(13) || chr(10) || '            return number in args' || chr(13) || chr(10) || '                ? args[number]' || chr(13) || chr(10) || '                : match' || chr(13) || chr(10) || '            ;' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '    };' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function isEventProblem(params) {' || chr(13) || chr(10) || '    return params.event_value == 1' || chr(13) || chr(10) || '        && params.event_update_status == 0' || chr(13) || chr(10) || '    ;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function isEventUpdate(params) {' || chr(13) || chr(10) || '    return params.event_value == 1' || chr(13) || chr(10) || '        && params.event_update_status == 1' || chr(13) || chr(10) || '    ;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function isEventResolve(params) {' || chr(13) || chr(10) || '    return params.event_value == 0;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('function getPermalink(channelId, messageTimestamp) {' || chr(13) || chr(10) || '    var req = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.HTTPProxy === ''string'' && params.HTTPProxy.trim() !== '''') {' || chr(13) || chr(10) || '        req.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    req.addHeader(''Content-Type: application/x-www-form-urlencoded; charset=utf-8'');' || chr(13) || chr(10) || '    req.addHeader(''Authorization: Bearer '' + params.bot_token);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var query = ''{0}?channel={1}&message_ts={2}''.format(' || chr(13) || chr(10) || '            Slack.getPermalink,' || chr(13) || chr(10) || '            encodeURIComponent(channelId),' || chr(13) || chr(10) || '            encodeURIComponent(messageTimestamp)),' || chr(13) || chr(10) || '        resp = JSON.parse(req.get(query));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (req.getStatus() != 200 || !resp.ok || resp.ok === ''false'') {' || chr(13) || chr(10) || '        throw ''message was created, but getting message link was failed with reason "'' + resp.error + ''"'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return resp.permalink;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function createProblemURL(zabbix_url, triggerid, eventid, event_source) {' || chr(13) || chr(10) || '    var problem_url = '''';' || chr(13) || chr(10) || '    if (event_source === ''0'') {' || chr(13) || chr(10) || '        problem_url = ''{0}/tr_events.php?triggerid={1}&eventid={2}''' || chr(13) || chr(10) || '            .format(' || chr(13) || chr(10) || '                zabbix_url,' || chr(13) || chr(10) || '                triggerid,' || chr(13) || chr(10) || '                eventid' || chr(13) || chr(10) || '            );' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '')||
TO_NCLOB('        problem_url = zabbix_url;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return problem_url;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function handlerAlarm(params) {' || chr(13) || chr(10) || '    var fields = {' || chr(13) || chr(10) || '        channel: params.channel,' || chr(13) || chr(10) || '        as_user: params.slack_as_user,' || chr(13) || chr(10) || '    };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (isEventProblem(params)) {' || chr(13) || chr(10) || '        fields.attachments = [' || chr(13) || chr(10) || '            createMessage(' || chr(13) || chr(10) || '                SEVERITY_COLORS[params.event_nseverity] || 0,' || chr(13) || chr(10) || '                params.event_date,' || chr(13) || chr(10) || '                params.event_time,' || chr(13) || chr(10) || '                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)' || chr(13) || chr(10) || '            )' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var resp = JSON.parse(req.post(Slack.postMessage, JSON.stringify(fields)));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (req.getStatus() != 200 || !resp.ok || resp.ok === ''false'') {' || chr(13) || chr(10) || '            throw resp.error;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result.tags = {' || chr(13) || chr(10) || '            [''__message_ts_'' + params.channel]: resp.ts,' || chr(13) || chr(10) || '            [''__channel_id_'' + params.channel]: resp.channel,' || chr(13) || chr(10) || '            [''__message_link_'' + params.channel]: getPermalink(resp.channel, resp.ts),' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else if (isEventUpdate(params)) {' || chr(13) || chr(10) || '        try {' || chr(13) || chr(10) || '')||
TO_NCLOB('            var channel_event_tags = JSON.parse(params.event_tags);' || chr(13) || chr(10) || '        } catch (error) {' || chr(13) || chr(10) || '            throw ''Cannot process event tags: '' + error;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (Array.isArray(channel_event_tags)) {' || chr(13) || chr(10) || '            for (i in channel_event_tags) {' || chr(13) || chr(10) || '                if (channel_event_tags[i].tag.includes(''__message_ts_'' + params.channel)) {' || chr(13) || chr(10) || '                    fields.thread_ts = channel_event_tags[i].value;' || chr(13) || chr(10) || '                    break;' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        fields.attachments = [' || chr(13) || chr(10) || '            createMessage(' || chr(13) || chr(10) || '                SEVERITY_COLORS[params.event_nseverity] || 0,' || chr(13) || chr(10) || '                params.event_update_date,' || chr(13) || chr(10) || '                params.event_update_time,' || chr(13) || chr(10) || '                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source),' || chr(13) || chr(10) || '                true' || chr(13) || chr(10) || '            )' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        resp = JSON.parse(req.post(Slack.postMessage, JSON.stringify(fields)));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (req.getStatus() != 200 || !resp.ok || resp.ok === ''false'') {' || chr(13) || chr(10) || '            throw resp.error;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else if (isEventResolve(params)) {' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        fields.text = '''';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('        try {' || chr(13) || chr(10) || '            var channel_event_tags = JSON.parse(params.event_tags);' || chr(13) || chr(10) || '        } catch (error) {' || chr(13) || chr(10) || '            throw ''Cannot process event tags: '' + error;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (Array.isArray(channel_event_tags)) {' || chr(13) || chr(10) || '            for (i in channel_event_tags) {' || chr(13) || chr(10) || '                if (channel_event_tags[i].tag.includes(''__channel_id_'' + params.channel)) {' || chr(13) || chr(10) || '                    fields.channel = channel_event_tags[i].value;' || chr(13) || chr(10) || '                    continue;' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '                if (channel_event_tags[i].tag.includes(''__message_ts_'' + params.channel)) {' || chr(13) || chr(10) || '                    fields.ts = channel_event_tags[i].value;' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        fields.attachments = [' || chr(13) || chr(10) || '            createMessage(' || chr(13) || chr(10) || '                RESOLVE_COLOR,' || chr(13) || chr(10) || '                params.event_date,' || chr(13) || chr(10) || '                params.event_time,' || chr(13) || chr(10) || '                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)' || chr(13) || chr(10) || '            )' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        resp = JSON.parse(req.post(Slack.chatUpdate, JSON.stringify(fields)));' || chr(13) || chr(10) || '        if (req.getStatus() != 200 || !resp.ok || resp.ok === ''false'') {' || chr(13) || chr(10) || '            throw resp.error;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '')||
TO_NCLOB('}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function handlerEvent(params) {' || chr(13) || chr(10) || '    var fields = {' || chr(13) || chr(10) || '        channel: params.channel,' || chr(13) || chr(10) || '        as_user: params.slack_as_user' || chr(13) || chr(10) || '    };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (isEventProblem(params)) {' || chr(13) || chr(10) || '        fields.attachments = [' || chr(13) || chr(10) || '            createMessage(' || chr(13) || chr(10) || '                SEVERITY_COLORS[params.event_nseverity] || 0,' || chr(13) || chr(10) || '                params.event_date,' || chr(13) || chr(10) || '                params.event_time,' || chr(13) || chr(10) || '                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)' || chr(13) || chr(10) || '            )' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var resp = JSON.parse(req.post(Slack.postMessage, JSON.stringify(fields)));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (req.getStatus() != 200 || !resp.ok || resp.ok === ''false'') {' || chr(13) || chr(10) || '            throw resp.error;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result.tags = {' || chr(13) || chr(10) || '            [''__message_link_'' + params.channel]: getPermalink(resp.channel, resp.ts)' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else if (isEventUpdate(params)) {' || chr(13) || chr(10) || '        fields.attachments = [' || chr(13) || chr(10) || '            createMessage(' || chr(13) || chr(10) || '                SEVERITY_COLORS[params.event_nseverity] || 0,' || chr(13) || chr(10) || '                params.event_update_date,' || chr(13) || chr(10) || '                params.event_update_time,' || chr(13) || chr(10) || '')||
TO_NCLOB('                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source),' || chr(13) || chr(10) || '                false' || chr(13) || chr(10) || '            )' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        resp = JSON.parse(req.post(Slack.postMessage, JSON.stringify(fields)));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (req.getStatus() != 200 || !resp.ok || resp.ok === ''false'') {' || chr(13) || chr(10) || '            throw resp.error;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else if (isEventResolve(params)) {' || chr(13) || chr(10) || '        fields.attachments = [' || chr(13) || chr(10) || '            createMessage(' || chr(13) || chr(10) || '                RESOLVE_COLOR,' || chr(13) || chr(10) || '                params.event_recovery_date,' || chr(13) || chr(10) || '                params.event_recovery_time,' || chr(13) || chr(10) || '                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)' || chr(13) || chr(10) || '            )' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        resp = JSON.parse(req.post(Slack.postMessage, JSON.stringify(fields)));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (req.getStatus() != 200 || !resp.ok || resp.ok === ''false'') {' || chr(13) || chr(10) || '            throw resp.error;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function createMessage(' || chr(13) || chr(10) || '    event_severity_color,' || chr(13) || chr(10) || '    event_date,' || chr(13) || chr(10) || '    event_time,' || chr(13) || chr(10) || '    problem_url,' || chr(13) || chr(10) || '    isShort,' || chr(13) || chr(10) || '    messageText' || chr(13) || chr(10) || ') {' || chr(13) || chr(10) || '')||
TO_NCLOB('    var message = {' || chr(13) || chr(10) || '        fallback: params.alert_subject,' || chr(13) || chr(10) || '        title: params.alert_subject,' || chr(13) || chr(10) || '        color: event_severity_color,' || chr(13) || chr(10) || '        title_link: problem_url,' || chr(13) || chr(10) || '        pretext: messageText || '''',' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        fields: [' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                title: ''Host'',' || chr(13) || chr(10) || '                value: ''{0} [{1}]''.format(params.host_name, params.host_conn),' || chr(13) || chr(10) || '                short: true' || chr(13) || chr(10) || '            },' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                title: ''Event time'',' || chr(13) || chr(10) || '                value: ''{0} {1}''.format(event_date, event_time),' || chr(13) || chr(10) || '                short: true' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '    };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source === ''0'') {' || chr(13) || chr(10) || '        message.fields.push(' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                title: ''Severity'',' || chr(13) || chr(10) || '                value: params.event_severity,' || chr(13) || chr(10) || '                short: true' || chr(13) || chr(10) || '            },' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                title: ''Opdata'',' || chr(13) || chr(10) || '                value: params.event_opdata,' || chr(13) || chr(10) || '                short: true' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        );' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (!isShort  && params.event_source === ''0'') {' || chr(13) || chr(10) || '        message[''actions''] = [' || chr(13) || chr(10) || '')||
TO_NCLOB('            {' || chr(13) || chr(10) || '                type: ''button'',' || chr(13) || chr(10) || '                text: ''Open in Zabbix'',' || chr(13) || chr(10) || '                url: problem_url' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        message.fields.push(' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                title: ''Event tags'',' || chr(13) || chr(10) || '                value: JSON.parse(params.event_tags).filter(function (e) { return !e.tag.includes(''__'') }).map(function (e) { return e.tag + '': '' + e.value }).join(''\n'') || ''None'',' || chr(13) || chr(10) || '                short: true' || chr(13) || chr(10) || '            },' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                title: ''Trigger description'',' || chr(13) || chr(10) || '                value: params.trigger_description,' || chr(13) || chr(10) || '                short: true' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        );' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' || params.event_update_status === ''1'') {' || chr(13) || chr(10) || '        message.fields.push(' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                title: ''Details'',' || chr(13) || chr(10) || '                value: params.alert_message,' || chr(13) || chr(10) || '                short: false' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        );' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return message;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function validateParams(params) {' || chr(13) || chr(10) || '    if (typeof params.bot_token !== ''string'' || params.bot_token.trim() === '''') {' || chr(13) || chr(10) || '')||
TO_NCLOB('        throw ''Field "bot_token" cannot be empty'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.channel !== ''string'' || params.channel.trim() === '''') {' || chr(13) || chr(10) || '        throw ''Field "channel" cannot be empty'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (isNaN(params.event_id)) {' || chr(13) || chr(10) || '        throw ''Field "event_id" is not a number'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: "'' + params.event_source + ''".\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'') {' || chr(13) || chr(10) || '        params.event_nseverity = ''0'';' || chr(13) || chr(10) || '        params.event_severity = ''Not classified'';' || chr(13) || chr(10) || '        params.event_update_status = ''0'';' || chr(13) || chr(10) || '        params.slack_mode = ''event'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source === ''1'' || params.event_source === ''2'') {' || chr(13) || chr(10) || '        params.event_value = ''1'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source === ''1'') {' || chr(13) || chr(10) || '        params.host_name = params.discovery_host_dns;' || chr(13) || chr(10) || '        params.host_ip = params.discovery_host_ip;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (!~[0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity))) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_nseverity" parameter given: '' + params.event_nseverity + ''\nMust be 0-5.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    if (typeof params.event_severity !== ''string'' || params.event_severity.trim() === '''') {' || chr(13) || chr(10) || '        throw ''Field "event_severity" cannot be empty'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.host_conn !== ''string'' || params.host_conn.trim() === '''') {' || chr(13) || chr(10) || '        throw ''Field "host_conn" cannot be empty'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.host_name !== ''string'' || params.host_name.trim() === '''') {' || chr(13) || chr(10) || '        throw ''Field "host_name" cannot be empty'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (!~[''true'', ''false''].indexOf(params.slack_as_user.toLowerCase())) {' || chr(13) || chr(10) || '        throw ''Incorrect "slack_as_user" parameter given: '' + params.slack_as_user + ''\nMust be "true" or "false".'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (!~[''alarm'', ''event''].indexOf(params.slack_mode)) {' || chr(13) || chr(10) || '        throw ''Incorrect "slack_mode" parameter given: '' + params.slack_mode + ''\nMust be "alarm" or "event".'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    if (isNaN(params.trigger_id) && params.event_source === ''0'') {' || chr(13) || chr(10) || '        throw ''field "trigger_id" is not a number'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.zabbix_url !== ''string'' || params.zabbix_url.trim() === '''') {' || chr(13) || chr(10) || '        throw ''Field "zabbix_url" cannot be empty'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (!/^(http|https):\/\/.+/.test(params.zabbix_url)) {' || chr(13) || chr(10) || '        throw ''Field "zabbix_url" must contain a schema'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    validateParams(params);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var req = new HttpRequest(),' || chr(13) || chr(10) || '        result = {tags: {}};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.HTTPProxy === ''string'' && params.HTTPProxy.trim() !== '''') {' || chr(13) || chr(10) || '        req.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    req.addHeader(''Content-Type: application/json; charset=utf-8'');' || chr(13) || chr(10) || '    req.addHeader(''Authorization: Bearer '' + params.bot_token);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var slack_endpoint = ''https://slack.com/api/'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var Slack = {' || chr(13) || chr(10) || '        postMessage: slack_endpoint + ''chat.postMessage'',' || chr(13) || chr(10) || '        getPermalink: slack_endpoint + ''chat.getPermalink'',' || chr(13) || chr(10) || '        chatUpdate: slack_endpoint + ''chat.update''' || chr(13) || chr(10) || '    };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    params.slack_mode = params.slack_mode.toLowerCase();' || chr(13) || chr(10) || '    params.slack_mode = params.slack_mode in SLACK_MODE_HANDLERS' || chr(13) || chr(10) || '        ? params.slack_mode' || chr(13) || chr(10) || '        : ''alarm'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    SLACK_MODE_HANDLERS[params.slack_mode](params);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source === ''0'') {' || chr(13) || chr(10) || '        return JSON.stringify(result);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        return ''OK'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(4, ''[ Slack Webhook ] Slack notification failed : '' + error);' || chr(13) || chr(10) || '    throw ''Slack notification failed : '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','0','','','','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('10','4','Discord','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('var SEVERITY_COLORS = [' || chr(13) || chr(10) || '    ''#97AAB3'', // Not classified.' || chr(13) || chr(10) || '    ''#7499FF'', // Information.' || chr(13) || chr(10) || '    ''#FFC859'', // Warning.' || chr(13) || chr(10) || '    ''#FFA059'', // Average.' || chr(13) || chr(10) || '    ''#E97659'', // High.' || chr(13) || chr(10) || '    ''#E45959'', // Disaster.' || chr(13) || chr(10) || '    ''#009900''  // Resolved.' || chr(13) || chr(10) || '];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function stringTruncate(str, len) {' || chr(13) || chr(10) || '    return str.length > len ? str.substring(0, len - 3) + ''...'' : str;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    Zabbix.log(4, ''[ Discord Webhook ] Executed with params: '' + value);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var params = JSON.parse(value);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (!params.discord_endpoint) {' || chr(13) || chr(10) || '        throw ''Cannot get discord_endpoint'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        params.discord_endpoint = params.discord_endpoint.replace(''/api/'', ''/api/v7/'') + ''?wait=True'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    params.zabbix_url = (params.zabbix_url.endsWith(''/''))' || chr(13) || chr(10) || '        ? params.zabbix_url.slice(0, -1) : params.zabbix_url;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3, 4].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: "'' + params.event_source + ''".\nMust be 0-4.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Set params to true for non trigger-based events.' || chr(13) || chr(10) || '    if (params.event_source !== ''0'') {' || chr(13) || chr(10) || '')||
TO_NCLOB('        params.use_default_message = ''true'';' || chr(13) || chr(10) || '        params.event_nseverity = ''0'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: "'' + params.event_value + ''".\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'' && params.event_source === ''0'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: "'' + params.event_update_status + ''".\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value == 0) {' || chr(13) || chr(10) || '        params.event_nseverity = ''6'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (!SEVERITY_COLORS[params.event_nseverity]) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_nseverity" parameter given: '' + params.event_nseverity + ''\nMust be 0-5.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var color = parseInt(SEVERITY_COLORS[params.event_nseverity].replace(''#'', ''''), 16),' || chr(13) || chr(10) || '        fields = [],' || chr(13) || chr(10) || '        body = {' || chr(13) || chr(10) || '            embeds: [' || chr(13) || chr(10) || '                {' || chr(13) || chr(10) || '                    color: color || 0,' || chr(13) || chr(10) || '')||
TO_NCLOB('                    url: (params.event_source === ''0'')' || chr(13) || chr(10) || '                        ? params.zabbix_url + ''/tr_events.php?triggerid='' + params.trigger_id +' || chr(13) || chr(10) || '                            ''&eventid='' + params.event_id' || chr(13) || chr(10) || '                        : params.zabbix_url' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            ]' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Default message from {ALERT.MESSAGE}.' || chr(13) || chr(10) || '    if (params.use_default_message.toLowerCase() == ''true'') {' || chr(13) || chr(10) || '        body.embeds[0].title = stringTruncate(params.alert_subject, 256);' || chr(13) || chr(10) || '        body.embeds[0].description = stringTruncate(params.alert_message, 2048);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        fields.push(' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                name: ''Host'',' || chr(13) || chr(10) || '                value: params.host_name + '' ['' + params.host_ip + '']''' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        );' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        // Resolved message.' || chr(13) || chr(10) || '        if (params.event_value == 0 && params.event_update_status == 0) {' || chr(13) || chr(10) || '            body.embeds[0].title = stringTruncate(''OK: '' + params.event_name, 256);' || chr(13) || chr(10) || '            fields.push(' || chr(13) || chr(10) || '                {' || chr(13) || chr(10) || '                    name: ''Recovery time'',' || chr(13) || chr(10) || '                    value: params.event_recovery_time + '' '' + params.event_recovery_date,' || chr(13) || chr(10) || '                    inline: ''True''' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            );' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('        // Problem message.' || chr(13) || chr(10) || '        else if (params.event_value == 1 && params.event_update_status == 0) {' || chr(13) || chr(10) || '            body.embeds[0].title = stringTruncate(''PROBLEM: '' + params.event_name, 256);' || chr(13) || chr(10) || '            fields.push(' || chr(13) || chr(10) || '                {' || chr(13) || chr(10) || '                    name: ''Event time'',' || chr(13) || chr(10) || '                    value: params.event_time + '' '' + params.event_date,' || chr(13) || chr(10) || '                    inline: ''True''' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            );' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        // Update message.' || chr(13) || chr(10) || '        else if (params.event_update_status == 1) {' || chr(13) || chr(10) || '            body.embeds[0].title = stringTruncate(''UPDATE: '' + params.event_name, 256);' || chr(13) || chr(10) || '            body.embeds[0].description = params.event_update_user + '' '' + params.event_update_action + ''.'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (params.event_update_message) {' || chr(13) || chr(10) || '                body.embeds[0].description += '' Comment:\n>>> '' + params.event_update_message;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            body.embeds[0].description = stringTruncate(body.embeds[0].description, 2048);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            fields.push(' || chr(13) || chr(10) || '                {' || chr(13) || chr(10) || '                    name: ''Event update time'',' || chr(13) || chr(10) || '                    value: params.event_update_time + '' '' + params.event_update_date,' || chr(13) || chr(10) || '                    inline: ''True''' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            );' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '        fields.push(' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                name: ''Severity'',' || chr(13) || chr(10) || '                value: params.event_severity,' || chr(13) || chr(10) || '                inline: ''True''' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        );' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (params.event_opdata) {' || chr(13) || chr(10) || '            fields.push(' || chr(13) || chr(10) || '                {' || chr(13) || chr(10) || '                    name: ''Operational data'',' || chr(13) || chr(10) || '                    value: stringTruncate(params.event_opdata, 1024),' || chr(13) || chr(10) || '                    inline: ''True''' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            );' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (params.event_value == 1 && params.event_update_status == 0 && params.trigger_description) {' || chr(13) || chr(10) || '            fields.push(' || chr(13) || chr(10) || '                {' || chr(13) || chr(10) || '                    name: ''Trigger description'',' || chr(13) || chr(10) || '                    value: stringTruncate(params.trigger_description, 1024)' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            );' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        body.embeds[0].footer = {' || chr(13) || chr(10) || '            text: ''Event ID: '' + params.event_id' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (params.event_tags) {' || chr(13) || chr(10) || '            body.embeds[0].footer.text += ''\nEvent tags: '' + params.event_tags;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '')||
TO_NCLOB('        body.embeds[0].footer.text = stringTruncate(body.embeds[0].footer.text, 2048);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (fields.length > 0) {' || chr(13) || chr(10) || '        body.embeds[0].fields = fields;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var req = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.HTTPProxy === ''string'' && params.HTTPProxy.trim() !== '''') {' || chr(13) || chr(10) || '        req.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    req.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var resp = req.post(params.discord_endpoint, JSON.stringify(body)),' || chr(13) || chr(10) || '        data = JSON.parse(resp);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Zabbix.log(4, ''[ Discord Webhook ] JSON: '' + JSON.stringify(body));' || chr(13) || chr(10) || '    Zabbix.log(4, ''[ Discord Webhook ] Response: '' + resp);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (data.id) {' || chr(13) || chr(10) || '        return resp;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        var message = ((typeof data.message === ''string'') ? data.message : ''Unknown error'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(3, ''[ Discord Webhook ] FAILED with response: '' + resp);' || chr(13) || chr(10) || '        throw message + ''. For more details check zabbix server log.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ Discord Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','0','0','','','','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('11','4','SIGNL4','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('// SIGNL4 Webhook' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var response,' || chr(13) || chr(10) || '        payload,' || chr(13) || chr(10) || '        params = JSON.parse(value),' || chr(13) || chr(10) || '        endpoint = ''https://connect.signl4.com/webhook/'',' || chr(13) || chr(10) || '        request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.HTTPProxy === ''string'' && params.HTTPProxy.trim() !== '''') {' || chr(13) || chr(10) || '        request.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.teamsecret === ''string'' && params.teamsecret.trim() !== '''') {' || chr(13) || chr(10) || '        endpoint += params.teamsecret;' || chr(13) || chr(10) || '        delete params.teamsecret;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        throw ''The team secret of your SIGNL4 team cannot be empty.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.Severity === ''string'' && params.Severity === ''{EVENT.SEVERITY}'') {' || chr(13) || chr(10) || '        params.Severity = ''Not classified'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (typeof params.User === ''string'' && params.User === ''{USER.FULLNAME}'') {' || chr(13) || chr(10) || '        params.User = '''';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	if (typeof params.Event_Update_Action === ''string'' && params.Event_Update_Action === ''{EVENT.UPDATE.ACTION}'') {' || chr(13) || chr(10) || '        params.Event_Update_Action = '''';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	// Assemble X-S4-ExternalID for two-way integration' || chr(13) || chr(10) || '')||
TO_NCLOB('	// Format: "ZabbixEventID: 222 ZabbixURL: https://your-zabbix-server/zabbix/"' || chr(13) || chr(10) || '	params[''X-S4-ExternalID''] = ''ZabbixEventID: '' + params.Event_ID;' || chr(13) || chr(10) || '	if (typeof params.Zabbix_URL === ''string'' && params.Zabbix_URL.indexOf(''http'') == 0) {' || chr(13) || chr(10) || '		// Make sure the URL ends with ''/''' || chr(13) || chr(10) || '		if (params.Zabbix_URL.charAt(params.Zabbix_URL.length - 1) != ''/'') {' || chr(13) || chr(10) || '			params.Zabbix_URL = params.Zabbix_URL + ''/'';' || chr(13) || chr(10) || '		}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		params[''X-S4-ExternalID''] = params[''X-S4-ExternalID''] + '' ZabbixURL: '' +  params.Zabbix_URL;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '		// Add Link parameter' || chr(13) || chr(10) || '		params[''Link''] = params.Zabbix_URL + "tr_events.php?triggerid="+params.Trigger_ID + "&eventid=" + params.Event_ID;' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '	// Check if this is a new problem or a recovery' || chr(13) || chr(10) || '	if (params.Trigger_Status == ''OK'') {' || chr(13) || chr(10) || '		params[''X-S4-Status''] = ''resolved'';' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '	else {' || chr(13) || chr(10) || '		params[''X-S4-Status''] = ''new'';' || chr(13) || chr(10) || '		params[''X-S4-SourceSystem''] = ''Zabbix'';' || chr(13) || chr(10) || '	}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    payload = JSON.stringify(params);' || chr(13) || chr(10) || '    Zabbix.log(4, ''[ SIGNL4 Webhook ] Sending request: '' + payload);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '    response = request.post(endpoint, ''payload='' + payload);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Zabbix.log(4, ''[ SIGNL4 Webhook ] Received response with status code '' +' || chr(13) || chr(10) || '            request.getStatus() + ''\n'' + response' || chr(13) || chr(10) || '    );' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '    if (request.getStatus() !== 201) {' || chr(13) || chr(10) || '        throw ''Request failed with status code '' + request.getStatus() +' || chr(13) || chr(10) || '                ''. Check debug log for more information.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return ''OK'';' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(4, ''[ SIGNL4 Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','0','0','','','SIGNL4 is a mobile alert notification app for powerful alerting, alert management and mobile assignment of work items. It offers alerting via app push, SMS and voice calls including escalations, tracking, and duty scheduling.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Get the app at https://www.signl4.com.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Find out more including an integration video here: https://www.signl4.com/blog/portfolio_item/zabbix-mobile-alert-notification-duty-schedule-escalation/','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('12','4','Jira','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('var Jira = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Jira.params = params;' || chr(13) || chr(10) || '        if (typeof Jira.params.url === ''string'') {' || chr(13) || chr(10) || '            if (!Jira.params.url.endsWith(''/'')) {' || chr(13) || chr(10) || '                Jira.params.url += ''/'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            Jira.params.url += ''rest/api/latest/'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setProxy: function (HTTPProxy) {' || chr(13) || chr(10) || '        Jira.HTTPProxy = HTTPProxy;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setTags: function (event_tags_json) {' || chr(13) || chr(10) || '        if (typeof event_tags_json !== ''undefined'' && event_tags_json !== ''''' || chr(13) || chr(10) || '            && event_tags_json !== ''{EVENT.TAGSJSON}'') {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                var tags = JSON.parse(event_tags_json),' || chr(13) || chr(10) || '                    label;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                Jira.labels = [];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                tags.forEach(function (tag) {' || chr(13) || chr(10) || '                    if (typeof tag.tag !== ''undefined'' && typeof tag.value !== ''undefined''' || chr(13) || chr(10) || '                        && !tag.tag.startsWith(''__zbx'')) {' || chr(13) || chr(10) || '')||
TO_NCLOB('                        label = (tag.tag + (tag.value ? ('':'' + tag.value) : '''')).replace(/\s/g, ''_'');' || chr(13) || chr(10) || '                        if (label.length < 256) {' || chr(13) || chr(10) || '                            Jira.labels.push(label);' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '                    }' || chr(13) || chr(10) || '                });' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                // Code is not missing here.' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    escapeMarkup: function (str) {' || chr(13) || chr(10) || '        var length = str.length,' || chr(13) || chr(10) || '            result = '''',' || chr(13) || chr(10) || '            markup = [''{'', ''|'', ''}'', ''~'', ''_'', ''\\'', ''['', '']'', ''^'', ''<'', ''>'', ''?'', ''!'', ''#'', ''+'', ''*'', ''&''];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        for (var i = 0; i < length; i++) {' || chr(13) || chr(10) || '            var char = str[i];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            result += (markup.indexOf(char) !== -1) ? (''&#'' + str[i].charCodeAt() + '';'') : char;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return result;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    addCustomFields: function (data, fields) {' || chr(13) || chr(10) || '        if (typeof fields === ''object'' && Object.keys(fields).length) {' || chr(13) || chr(10) || '            var schemaData = Jira.request(''get'', ''field/'').response,' || chr(13) || chr(10) || '                schema = {};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            schemaData.forEach(function (item) {' || chr(13) || chr(10) || '                schema[item.id] = item.schema;' || chr(13) || chr(10) || '            });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('            Object.keys(fields).forEach(function (field) {' || chr(13) || chr(10) || '                if (typeof schema[field] === ''object'' && schema[field].type) {' || chr(13) || chr(10) || '                    switch (schema[field].type) {' || chr(13) || chr(10) || '                        case ''number'':' || chr(13) || chr(10) || '                            data.fields[field] = parseInt(fields[field]);' || chr(13) || chr(10) || '                            break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                        case ''datetime'':' || chr(13) || chr(10) || '                            if (fields[field].match(/\d+[.-]\d+[.-]\d+T\d+:\d+:\d+/) !== null) {' || chr(13) || chr(10) || '                                data.fields[field] = fields[field].replace(/\./g, ''-'');' || chr(13) || chr(10) || '                            }' || chr(13) || chr(10) || '                            break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                        case ''option'':' || chr(13) || chr(10) || '                            data.fields[field] = { value: fields[field] };' || chr(13) || chr(10) || '                            break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                        case ''array'':' || chr(13) || chr(10) || '                            if (schema[field].items === ''option'') {' || chr(13) || chr(10) || '                                data.fields[field] = [{ value: fields[field] }];' || chr(13) || chr(10) || '                            } else {' || chr(13) || chr(10) || '                                data.fields[field] = [fields[field]];' || chr(13) || chr(10) || '                            }' || chr(13) || chr(10) || '                            break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                        default:' || chr(13) || chr(10) || '                            data.fields[field] = fields[field];' || chr(13) || chr(10) || '                    }' || chr(13) || chr(10) || '')||
TO_NCLOB('                }' || chr(13) || chr(10) || '            });' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            Zabbix.log(4, ''[ Jira Webhook ] Failed to retrieve field schema.'');' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        return data;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (method, query, data) {' || chr(13) || chr(10) || '        [''url'', ''user'', ''password'', ''project_key'', ''issue_type''].forEach(function (field) {' || chr(13) || chr(10) || '            if (typeof Jira.params !== ''object'' || typeof Jira.params[field] === ''undefined''' || chr(13) || chr(10) || '                || Jira.params[field] === '''') {' || chr(13) || chr(10) || '                throw ''Required Jira param is not set: "'' + field + ''".'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            url = Jira.params.url + query,' || chr(13) || chr(10) || '            request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '        request.addHeader(''Authorization: Basic '' + btoa(Jira.params.user + '':'' + Jira.params.password));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof Jira.HTTPProxy !== ''undefined'' && Jira.HTTPProxy !== '''') {' || chr(13) || chr(10) || '            request.setProxy(Jira.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('        Zabbix.log(4, ''[ Jira Webhook ] Sending request: '' + url + ((typeof data === ''string'') ? (''\n'' + data) : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (method) {' || chr(13) || chr(10) || '            case ''get'':' || chr(13) || chr(10) || '                response = request.get(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''post'':' || chr(13) || chr(10) || '                response = request.post(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''put'':' || chr(13) || chr(10) || '                response = request.put(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                throw ''Unsupported HTTP request method: '' + method;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ Jira Webhook ] Received response with status code '' + request.getStatus() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ Jira Webhook ] Failed to parse response received from Jira'');' || chr(13) || chr(10) || '                response = null;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() < 200 || request.getStatus() >= 300) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (response !== null && typeof response.errors !== ''undefined''' || chr(13) || chr(10) || '')||
TO_NCLOB('                && Object.keys(response.errors).length > 0) {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.errors);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (response !== null && typeof response.errorMessages !== ''undefined''' || chr(13) || chr(10) || '                && Object.keys(response.errorMessages).length > 0) {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.errorMessages);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            throw message + '' Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return {' || chr(13) || chr(10) || '            status: request.getStatus(),' || chr(13) || chr(10) || '            response: response' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    createIssue: function (summary, description, fields) {' || chr(13) || chr(10) || '        var data = {' || chr(13) || chr(10) || '            fields: {' || chr(13) || chr(10) || '                project: {' || chr(13) || chr(10) || '                    key: Jira.params.project_key' || chr(13) || chr(10) || '                },' || chr(13) || chr(10) || '                issuetype: {' || chr(13) || chr(10) || '                    name: Jira.params.issue_type' || chr(13) || chr(10) || '                },' || chr(13) || chr(10) || '                summary: summary,' || chr(13) || chr(10) || '                description: description' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (Jira.labels && Jira.labels.length > 0) {' || chr(13) || chr(10) || '            data.fields.labels = Jira.labels;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '')||
TO_NCLOB('        var result = Jira.request(''post'', ''issue'', Jira.addCustomFields(data, fields));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof result.response !== ''object'' || typeof result.response.key === ''undefined'') {' || chr(13) || chr(10) || '            throw ''Cannot create Jira issue. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return result.response.key;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    updateIssue: function (summary, fields, update) {' || chr(13) || chr(10) || '        var data = { fields: {} };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (summary) {' || chr(13) || chr(10) || '            data.fields.summary = summary;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Jira.request(''put'', ''issue/'' + encodeURIComponent(Jira.params.issue_key), Jira.addCustomFields(data, fields));' || chr(13) || chr(10) || '        Jira.commentIssue(update);' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    commentIssue: function (update) {' || chr(13) || chr(10) || '        var data = {};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof update === ''string'') {' || chr(13) || chr(10) || '            data.body = update;' || chr(13) || chr(10) || '            Jira.request(''post'', ''issue/'' + encodeURIComponent(Jira.params.issue_key) + ''/comment'', data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else if (update.status === ''1'') {' || chr(13) || chr(10) || '            data.body = update.user + '' '' + update.action + ''.'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (update.message) {' || chr(13) || chr(10) || '                data.body += ''\nMessage: {quote}'' + Jira.escapeMarkup(update.message) + ''{quote}'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '            Jira.request(''post'', ''issue/'' + encodeURIComponent(Jira.params.issue_key) + ''/comment'', data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        fields = {},' || chr(13) || chr(10) || '        jira = {},' || chr(13) || chr(10) || '        update = {},' || chr(13) || chr(10) || '        result = { tags: {} },' || chr(13) || chr(10) || '        required_params = [''alert_subject'', ''summary'', ''event_recovery_value'', ''event_source'', ''event_value''];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (key.startsWith(''jira_'')) {' || chr(13) || chr(10) || '                jira[key.substring(5)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''customfield_'')) {' || chr(13) || chr(10) || '                fields[key] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''event_update_'')) {' || chr(13) || chr(10) || '                update[key.substring(13)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (required_params.indexOf(key) !== -1 && params[key] === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" can\''t be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '')||
TO_NCLOB('    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'' && params.event_source === ''0'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_recovery_value === ''0'') {' || chr(13) || chr(10) || '        throw ''Recovery operations are supported only for trigger-based actions.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Jira.setParams(jira);' || chr(13) || chr(10) || '    Jira.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    Jira.setTags(params.event_tags_json);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Create issue for non trigger-based events.' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_recovery_value !== ''0'') {' || chr(13) || chr(10) || '        Jira.createIssue(params.alert_subject, params.alert_message);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Create issue for trigger-based events.' || chr(13) || chr(10) || '    else if (params.event_value === ''1'' && update.status === ''0'' && !jira.issue_key.startsWith(jira.project_key)) {' || chr(13) || chr(10) || '')||
TO_NCLOB('        var key = Jira.createIssue(params.alert_subject,' || chr(13) || chr(10) || '            (Object.keys(fields).length ? params.trigger_description : params.alert_message), fields);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result.tags.__zbx_jira_issuekey = key;' || chr(13) || chr(10) || '        result.tags.__zbx_jira_issuelink = params.jira_url +' || chr(13) || chr(10) || '            (params.jira_url.endsWith(''/'') ? '''' : ''/'') + ''browse/'' + key;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Update created issue for trigger-based event.' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        if (!jira.issue_key.startsWith(jira.project_key)) {' || chr(13) || chr(10) || '            throw ''Incorrect Issue key given: '' + jira.issue_key;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        Jira.updateIssue(params.alert_subject, fields,' || chr(13) || chr(10) || '            ((params.event_value === ''0'' && !Object.keys(fields).length)' || chr(13) || chr(10) || '                ? params.alert_message : update));' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return JSON.stringify(result);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ Jira Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_jira_issuelink}','Jira: {EVENT.TAGS.__zbx_jira_issuekey}','','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('14','4','MS Teams','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('var SEVERITY_COLORS = [' || chr(13) || chr(10) || '    ''#97AAB3'', // Not classified.' || chr(13) || chr(10) || '    ''#7499FF'', // Information.' || chr(13) || chr(10) || '    ''#FFC859'', // Warning.' || chr(13) || chr(10) || '    ''#FFA059'', // Average.' || chr(13) || chr(10) || '    ''#E97659'', // High.' || chr(13) || chr(10) || '    ''#E45959'', // Disaster.' || chr(13) || chr(10) || '    ''#009900'', // Resolved.' || chr(13) || chr(10) || '    ''#000000''  // Default.' || chr(13) || chr(10) || '];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.teams_endpoint !== ''string'' || params.teams_endpoint.trim() === '''') {' || chr(13) || chr(10) || '        throw ''Cannot get teams_endpoint'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else if (!params.teams_endpoint.startsWith(''http'')) {' || chr(13) || chr(10) || '        throw ''Invalid MS Teams webhook URL: '' + params.teams_endpoint;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    params.zabbix_url = (params.zabbix_url.endsWith(''/''))' || chr(13) || chr(10) || '        ? params.zabbix_url.slice(0, -1) : params.zabbix_url;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3, 4].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: "'' + params.event_source + ''".\nMust be 0-4.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Set "use_default_message" to true for non trigger-based events.' || chr(13) || chr(10) || '    if (params.event_source !== ''0'') {' || chr(13) || chr(10) || '        params.use_default_message = ''true'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '            && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: "'' + params.event_value + ''".\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'' && params.event_source === ''0'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: "'' + params.event_update_status + ''".\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value == 0) {' || chr(13) || chr(10) || '        params.event_nseverity = ''6'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (!SEVERITY_COLORS[params.event_nseverity]) {' || chr(13) || chr(10) || '        params.event_nseverity = ''7'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var request = new HttpRequest(),' || chr(13) || chr(10) || '        facts = [],' || chr(13) || chr(10) || '        body = {' || chr(13) || chr(10) || '            themeColor: SEVERITY_COLORS[params.event_nseverity].replace(''#'', ''''),' || chr(13) || chr(10) || '            summary: params.alert_subject,' || chr(13) || chr(10) || '            sections: [' || chr(13) || chr(10) || '                {' || chr(13) || chr(10) || '                    markdown: ''false'',' || chr(13) || chr(10) || '                    activityTitle: params.alert_subject,' || chr(13) || chr(10) || '                    text: (params.use_default_message.toLowerCase() == ''true'')' || chr(13) || chr(10) || '                        ? params.alert_message' || chr(13) || chr(10) || '')||
TO_NCLOB('                        : params.trigger_description' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            ],' || chr(13) || chr(10) || '            potentialAction: [' || chr(13) || chr(10) || '                {' || chr(13) || chr(10) || '                    ''@type'': ''OpenUri'',' || chr(13) || chr(10) || '                    name: (params.event_source === ''0'')' || chr(13) || chr(10) || '                        ? ''Event Info''' || chr(13) || chr(10) || '                        : ''Zabbix Home'',' || chr(13) || chr(10) || '                    targets: [' || chr(13) || chr(10) || '                        {' || chr(13) || chr(10) || '                            os: ''default'',' || chr(13) || chr(10) || '                            uri: (params.event_source === ''0'')' || chr(13) || chr(10) || '                                ? params.zabbix_url + ''/tr_events.php?triggerid='' +' || chr(13) || chr(10) || '                                    params.trigger_id + ''&eventid='' + params.event_id' || chr(13) || chr(10) || '                                : params.zabbix_url' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '                    ]' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            ]' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.use_default_message.toLowerCase() !== ''true'') {' || chr(13) || chr(10) || '        // Problem message.' || chr(13) || chr(10) || '        if (params.event_value === ''1'' && params.event_update_status === ''0'') {' || chr(13) || chr(10) || '            facts.push({' || chr(13) || chr(10) || '                name: ''Event time'',' || chr(13) || chr(10) || '                value: params.event_time + '' '' + params.event_date' || chr(13) || chr(10) || '            });' || chr(13) || chr(10) || '            facts.push({' || chr(13) || chr(10) || '                name: ''Host'',' || chr(13) || chr(10) || '')||
TO_NCLOB('                value: params.host_name + '' ['' + params.host_ip + '']''' || chr(13) || chr(10) || '            });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        // Update message.' || chr(13) || chr(10) || '        else if (params.event_update_status === ''1'') {' || chr(13) || chr(10) || '            body.sections[0].text = params.event_update_user + '' '' + params.event_update_action + ''.'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (params.event_update_message) {' || chr(13) || chr(10) || '                body.sections[0].text += ''<br>Message:<br>'' + params.event_update_message;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            facts.push({' || chr(13) || chr(10) || '                name: ''Event update time'',' || chr(13) || chr(10) || '                value: params.event_update_time + '' '' + params.event_update_date' || chr(13) || chr(10) || '            });' || chr(13) || chr(10) || '            facts.push({' || chr(13) || chr(10) || '                name: ''Host'',' || chr(13) || chr(10) || '                value: params.host_name + '' ['' + params.host_ip + '']''' || chr(13) || chr(10) || '            });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        // Resolved message.' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            facts.push({' || chr(13) || chr(10) || '                name: ''Recovery time'',' || chr(13) || chr(10) || '                value: params.event_recovery_time + '' '' + params.event_recovery_date' || chr(13) || chr(10) || '            });' || chr(13) || chr(10) || '            facts.push({' || chr(13) || chr(10) || '                name: ''Host'',' || chr(13) || chr(10) || '                value: params.host_name + '' ['' + params.host_ip + '']''' || chr(13) || chr(10) || '            });' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('        if (params.event_severity && params.event_severity !== ''{EVENT.SEVERITY}'') {' || chr(13) || chr(10) || '            facts.push({' || chr(13) || chr(10) || '                name: ''Severity'',' || chr(13) || chr(10) || '                value: params.event_severity' || chr(13) || chr(10) || '            });' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (params.event_opdata && params.event_opdata !== ''{EVENT.OPDATA}'') {' || chr(13) || chr(10) || '            facts.push({' || chr(13) || chr(10) || '                name: ''Operational data'',' || chr(13) || chr(10) || '                value: params.event_opdata' || chr(13) || chr(10) || '            });' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (params.event_tags && params.event_tags !== ''{EVENT.TAGS}'') {' || chr(13) || chr(10) || '            facts.push({' || chr(13) || chr(10) || '                name: ''Event tags'',' || chr(13) || chr(10) || '                value: params.event_tags' || chr(13) || chr(10) || '            });' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Object.keys(params)' || chr(13) || chr(10) || '            .forEach(function (key) {' || chr(13) || chr(10) || '                if (key.startsWith(''fact_'') && params[key] !== '''') {' || chr(13) || chr(10) || '                    facts.push({' || chr(13) || chr(10) || '                        name: key.substring(5),' || chr(13) || chr(10) || '                        value: params[key]' || chr(13) || chr(10) || '                    });' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '                else if (key.startsWith(''openUri_'') && params[key] !== '''' && !params[key].startsWith(''{'')) {' || chr(13) || chr(10) || '                    body.potentialAction.push({' || chr(13) || chr(10) || '                        ''@type'': ''OpenUri'',' || chr(13) || chr(10) || '')||
TO_NCLOB('                        name: key.substring(8),' || chr(13) || chr(10) || '                        targets: [' || chr(13) || chr(10) || '                            {' || chr(13) || chr(10) || '                                os: ''default'',' || chr(13) || chr(10) || '                                uri: params[key]' || chr(13) || chr(10) || '                            }' || chr(13) || chr(10) || '                        ]' || chr(13) || chr(10) || '                    });' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            });' || chr(13) || chr(10) || '        body.sections[0].facts = facts;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    body.sections[0].text = body.sections[0].text.replace(/(?:\r\n|\r|\n)/g, ''<br>'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.HTTPProxy === ''string'' && params.HTTPProxy !== '''') {' || chr(13) || chr(10) || '        request.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Zabbix.log(4, ''[ MS Teams Webhook ] JSON: '' + JSON.stringify(body));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var response = request.post(params.teams_endpoint, JSON.stringify(body));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Zabbix.log(4, ''[ MS Teams Webhook ] Response: '' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (response === ''1'') {' || chr(13) || chr(10) || '        return ''OK'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ MS Teams Webhook ] FAILED with response: '' + response);' || chr(13) || chr(10) || '        throw response;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '')||
TO_NCLOB('    Zabbix.log(3, ''[ MS Teams Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','0','0','','','','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('15','4','Redmine','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('var Redmine = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Redmine.params = params;' || chr(13) || chr(10) || '        if (typeof Redmine.params.url === ''string'') {' || chr(13) || chr(10) || '            if (!Redmine.params.url.endsWith(''/'')) {' || chr(13) || chr(10) || '                Redmine.params.url += ''/'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    addCustomFields: function (data, fields) {' || chr(13) || chr(10) || '        if (typeof fields === ''object'' && Object.keys(fields).length) {' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            data.issue.custom_fields = [];' || chr(13) || chr(10) || '            Object.keys(fields)' || chr(13) || chr(10) || '                .forEach(function (field) {' || chr(13) || chr(10) || '                    var field_value = fields[field];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                    if (field_value !== undefined) {' || chr(13) || chr(10) || '                        data.issue.custom_fields.push({ id: field, value: field_value });' || chr(13) || chr(10) || '                    }' || chr(13) || chr(10) || '                });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        return data;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (method, query, data) {' || chr(13) || chr(10) || '        [''url'', ''access_key''].forEach(function (field) {' || chr(13) || chr(10) || '')||
TO_NCLOB('            if (typeof Redmine.params !== ''object'' || typeof Redmine.params[field] === ''undefined''' || chr(13) || chr(10) || '                || Redmine.params[field] === '''' ) {' || chr(13) || chr(10) || '                throw ''Required param is not set: "'' + field + ''".'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            url = Redmine.params.url + query,' || chr(13) || chr(10) || '            request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof Redmine.HTTPProxy === ''string'' && Redmine.HTTPProxy.trim() !== '''') {' || chr(13) || chr(10) || '            request.setProxy(Redmine.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '        request.addHeader(''X-Redmine-API-Key: '' + Redmine.params.access_key);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ Redmine Webhook ] Sending request: '' +' || chr(13) || chr(10) || '            url + ((typeof data === ''string'') ? ('' '' + data) : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (method) {' || chr(13) || chr(10) || '            case ''get'':' || chr(13) || chr(10) || '                response = request.get(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''post'':' || chr(13) || chr(10) || '                response = request.post(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''put'':' || chr(13) || chr(10) || '                response = request.put(url, data);' || chr(13) || chr(10) || '')||
TO_NCLOB('                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                throw ''Unsupported HTTP request method: '' + method;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ Redmine Webhook ] Received response with status code '' + request.getStatus() + '': '' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ Redmine Webhook ] Failed to parse response received from Redmine'');' || chr(13) || chr(10) || '                response = null;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() < 200 || request.getStatus() >= 300) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (response !== null && typeof response.errors !== ''undefined''' || chr(13) || chr(10) || '                && Object.keys(response.errors).length > 0) {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.errors);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (response !== null && typeof response.errorMessages !== ''undefined''' || chr(13) || chr(10) || '                && Object.keys(response.errorMessages).length > 0) {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.errorMessages);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('            throw message + '' Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return {' || chr(13) || chr(10) || '            status: request.getStatus(),' || chr(13) || chr(10) || '            response: response' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    getProjectID: function(name) {' || chr(13) || chr(10) || '        var result = Redmine.request(''get'', ''projects.json''),' || chr(13) || chr(10) || '            project_id;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (result.response) {' || chr(13) || chr(10) || '            var projects = result.response.projects || [];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            for (var i in projects) {' || chr(13) || chr(10) || '                if (projects[i].name === name) {' || chr(13) || chr(10) || '                    project_id = projects[i].id;' || chr(13) || chr(10) || '                    break;' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            Zabbix.log(4, ''[ Redmine Webhook ] Failed to retrieve project data.'');' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof project_id === ''undefined'') {' || chr(13) || chr(10) || '            throw ''Cannot find project with name: '' + name;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return project_id;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    createIssue: function(subject, description, priority, fields) {' || chr(13) || chr(10) || '        var project_id = /^\d+$/.test(Redmine.params.project)' || chr(13) || chr(10) || '                ? Redmine.params.project' || chr(13) || chr(10) || '')||
TO_NCLOB('                : Redmine.getProjectID(Redmine.params.project),' || chr(13) || chr(10) || '            data = {' || chr(13) || chr(10) || '                issue: {' || chr(13) || chr(10) || '                    project_id: project_id,' || chr(13) || chr(10) || '                    tracker_id: Redmine.params.tracker_id,' || chr(13) || chr(10) || '                    subject: subject,' || chr(13) || chr(10) || '                    description: description' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            },' || chr(13) || chr(10) || '            result;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (priority) {' || chr(13) || chr(10) || '            data.issue.priority_id = priority;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result = Redmine.request(''post'', ''issues.json'', Redmine.addCustomFields(data, fields));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof result.response !== ''object''' || chr(13) || chr(10) || '            || typeof result.response.issue.id === ''undefined''' || chr(13) || chr(10) || '            || result.status != 201) {' || chr(13) || chr(10) || '            throw ''Cannot create Redmine issue. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return result.response.issue.id;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    updateIssue: function (note, fields, status) {' || chr(13) || chr(10) || '        var data = {' || chr(13) || chr(10) || '            issue: {' || chr(13) || chr(10) || '                notes: note || ''''' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (status) {' || chr(13) || chr(10) || '            data.issue.status_id = status;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('        Redmine.request(''put'', ''issues/'' + Redmine.params.issue_key + ''.json'', Redmine.addCustomFields(data, fields));' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        params_redmine = {},' || chr(13) || chr(10) || '        params_fields = {},' || chr(13) || chr(10) || '        params_update = {},' || chr(13) || chr(10) || '        result = {tags: {}},' || chr(13) || chr(10) || '        required_params = [' || chr(13) || chr(10) || '            ''alert_subject'', ''tracker_id'', ''project'',' || chr(13) || chr(10) || '            ''event_source'', ''event_value'',  ''event_update_status''' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        severities = [' || chr(13) || chr(10) || '            {name: ''not_classified'', color: ''#97AAB3''},' || chr(13) || chr(10) || '            {name: ''information'', color: ''#7499FF''},' || chr(13) || chr(10) || '            {name: ''warning'', color: ''#FFC859''},' || chr(13) || chr(10) || '            {name: ''average'', color: ''#FFA059''},' || chr(13) || chr(10) || '            {name: ''high'', color: ''#E97659''},' || chr(13) || chr(10) || '            {name: ''disaster'', color: ''#E45959''},' || chr(13) || chr(10) || '            {name: ''resolved'', color: ''#009900''},' || chr(13) || chr(10) || '            {name: null, color: ''#000000''}' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        priority;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (key.startsWith(''redmine_'')) {' || chr(13) || chr(10) || '                params_redmine[key.substring(8)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''customfield_'')) {' || chr(13) || chr(10) || '')||
TO_NCLOB('                params_fields[key.substring(12)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''event_update_'')) {' || chr(13) || chr(10) || '                params_update[key.substring(13)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (required_params.indexOf(key) !== -1 && params[key].trim() === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" cannot be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '    if (params.event_source === ''0'' && params.event_update_status !== ''0'' && params.event_update_status !== ''1'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    if (typeof params_redmine.close_status_id === ''string'' && params_redmine.close_status_id.trim() !== '''' && !parseInt(params_redmine.close_status_id, 10)) {' || chr(13) || chr(10) || '        throw ''Incorrect "redmine_close_status_id" parameter given! Must be an integer.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_value === ''0'') {' || chr(13) || chr(10) || '        throw ''Recovery operations are supported only for trigger-based actions.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source === ''0''' || chr(13) || chr(10) || '        && ((params.event_value === ''1'' && params.event_update_status === ''1'')' || chr(13) || chr(10) || '            || (params.event_value === ''0''' || chr(13) || chr(10) || '                && (params.event_update_status === ''0'' || params.event_update_status === ''1'')))' || chr(13) || chr(10) || '        && (isNaN(parseInt(params.redmine_issue_key)) || parseInt(params.redmine_issue_key) < 1 )) {' || chr(13) || chr(10) || '        throw ''Incorrect "redmine_issue_key" parameter given: '' + params.redmine_issue_key +' || chr(13) || chr(10) || '            ''\nMust be positive integer.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {' || chr(13) || chr(10) || '        params.event_nseverity = ''7'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value === ''0'') {' || chr(13) || chr(10) || '        params.event_nseverity = ''6'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    priority = params[''severity_'' + severities[params.event_nseverity].name];' || chr(13) || chr(10) || '    priority = priority && priority.trim() || severities[7].name;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Redmine.setParams(params_redmine);' || chr(13) || chr(10) || '')||
TO_NCLOB('    Redmine.HTTPProxy = params.HTTPProxy;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Create issue for non trigger-based events.' || chr(13) || chr(10) || '    if (params.event_source !== ''0''' || chr(13) || chr(10) || '        && params.event_value !== ''0'') {' || chr(13) || chr(10) || '        Redmine.createIssue(params.alert_subject, params.alert_message, priority);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Create issue for trigger-based events.' || chr(13) || chr(10) || '    else if (params.event_value === ''1'' && params_update.status === ''0'') {' || chr(13) || chr(10) || '        var issue_id = Redmine.createIssue(params.alert_subject,' || chr(13) || chr(10) || '            params.alert_subject + ''\n'' + params.alert_message + ''\n'' +' || chr(13) || chr(10) || '            params.zabbix_url + (params.zabbix_url.endsWith(''/'') ? '''' : ''/'') +' || chr(13) || chr(10) || '            ''tr_events.php?triggerid='' + params.trigger_id + ''&eventid='' + params.event_id + ''\n'',' || chr(13) || chr(10) || '            priority,' || chr(13) || chr(10) || '            params_fields);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result.tags.__zbx_redmine_issue_id = issue_id;' || chr(13) || chr(10) || '        result.tags.__zbx_redmine_issuelink = params.redmine_url +' || chr(13) || chr(10) || '            (params.redmine_url.endsWith(''/'') ? '''' : ''/'') + ''issues/'' + issue_id;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Close issue if parameter close_status_id is set and it is a recovery operation' || chr(13) || chr(10) || '    else if (params.event_value === ''0'' && typeof params_redmine.close_status_id === ''string'' && params_redmine.close_status_id.trim() !== '''') {' || chr(13) || chr(10) || '        Redmine.updateIssue(params.alert_subject + ''\n'' + params.alert_message, params_fields, params_redmine.close_status_id);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Update created issue for trigger-based event.' || chr(13) || chr(10) || '')||
TO_NCLOB('    else {' || chr(13) || chr(10) || '        Redmine.updateIssue(params.alert_subject + ''\n'' + params.alert_message, params_fields);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return JSON.stringify(result);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ Redmine Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_redmine_issuelink}','Redmine: issue #{EVENT.TAGS.__zbx_redmine_issue_id}','','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('16','4','Telegram','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('var Telegram = {' || chr(13) || chr(10) || '    token: null,' || chr(13) || chr(10) || '    to: null,' || chr(13) || chr(10) || '    message: null,' || chr(13) || chr(10) || '    proxy: null,' || chr(13) || chr(10) || '    parse_mode: null,' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    escapeMarkup: function (str, mode) {' || chr(13) || chr(10) || '        switch (mode) {' || chr(13) || chr(10) || '            case ''markdown'':' || chr(13) || chr(10) || '                return str.replace(/([_*\[`])/g, ''\\$&'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''markdownv2'':' || chr(13) || chr(10) || '                return str.replace(/([_*\[\]()~`>#+\-=|{}.!])/g, ''\\$&'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''html'':' || chr(13) || chr(10) || '                return str.replace(/<(\s|[^a-z\/])/g, ''&lt;$1'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                return str;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    sendMessage: function () {' || chr(13) || chr(10) || '        var params = {' || chr(13) || chr(10) || '            chat_id: Telegram.to,' || chr(13) || chr(10) || '            text: Telegram.message,' || chr(13) || chr(10) || '            disable_web_page_preview: true,' || chr(13) || chr(10) || '            disable_notification: false' || chr(13) || chr(10) || '        },' || chr(13) || chr(10) || '        data,' || chr(13) || chr(10) || '        response,' || chr(13) || chr(10) || '        request = new HttpRequest(),' || chr(13) || chr(10) || '        url = ''https://api.telegram.org/bot'' + Telegram.token + ''/sendMessage'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (Telegram.parse_mode !== null) {' || chr(13) || chr(10) || '            params[''parse_mode''] = Telegram.parse_mode;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '        if (Telegram.proxy) {' || chr(13) || chr(10) || '            request.setProxy(Telegram.proxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '        data = JSON.stringify(params);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        // Remove replace() function if you want to see the exposed token in the log file.' || chr(13) || chr(10) || '        Zabbix.log(4, ''[Telegram Webhook] URL: '' + url.replace(Telegram.token, ''<TOKEN>''));' || chr(13) || chr(10) || '        Zabbix.log(4, ''[Telegram Webhook] params: '' + data);' || chr(13) || chr(10) || '        response = request.post(url, data);' || chr(13) || chr(10) || '        Zabbix.log(4, ''[Telegram Webhook] HTTP code: '' + request.getStatus());' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        try {' || chr(13) || chr(10) || '            response = JSON.parse(response);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        catch (error) {' || chr(13) || chr(10) || '            response = null;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() !== 200 || typeof response.ok !== ''boolean'' || response.ok !== true) {' || chr(13) || chr(10) || '            if (typeof response.description === ''string'') {' || chr(13) || chr(10) || '                throw response.description;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else {' || chr(13) || chr(10) || '                throw ''Unknown error. Check debug log for more information.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    if (typeof params.Token === ''undefined'') {' || chr(13) || chr(10) || '        throw ''Incorrect value is given for parameter "Token": parameter is missing'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Telegram.token = params.Token;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.HTTPProxy) {' || chr(13) || chr(10) || '        Telegram.proxy = params.HTTPProxy;' || chr(13) || chr(10) || '    } ' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    params.ParseMode = params.ParseMode.toLowerCase();' || chr(13) || chr(10) || '    ' || chr(13) || chr(10) || '    if ([''markdown'', ''html'', ''markdownv2''].indexOf(params.ParseMode) !== -1) {' || chr(13) || chr(10) || '        Telegram.parse_mode = params.ParseMode;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Telegram.to = params.To;' || chr(13) || chr(10) || '    Telegram.message = params.Subject + ''\n'' + params.Message;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([''markdown'', ''html'', ''markdownv2''].indexOf(params.ParseMode) !== -1) {' || chr(13) || chr(10) || '        Telegram.message = Telegram.escapeMarkup(Telegram.message, params.ParseMode);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Telegram.sendMessage();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return ''OK'';' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(4, ''[Telegram Webhook] notification failed: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error + ''.'';' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'10s','0','0','','','https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/telegram' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1. Register bot: send "/newbot" to @BotFather and follow instructions' || chr(13) || chr(10) || '2. Copy and paste the obtained token into the "Token" field above' || chr(13) || chr(10) || '3. If you want to send personal notifications, you need to get chat id of the user you want to send messages to:' || chr(13) || chr(10) || '    3.1. Send "/getid" to "@myidbot" in Telegram messenger' || chr(13) || chr(10) || '    3.2. Copy returned chat id and save it in the "Telegram Webhook" media for the user' || chr(13) || chr(10) || '    3.3. Ask the user to send "/start" to your bot (Telegram bot won''t send anything to the user without it)' || chr(13) || chr(10) || '4. If you want to send group notifications, you need to get group id of the group you want to send messages to:' || chr(13) || chr(10) || '    4.1. Add "@myidbot" to your group' || chr(13) || chr(10) || '    4.2. Send "/getgroupid@myidbot" in your group' || chr(13) || chr(10) || '    4.3. Copy returned group id save it in the "Telegram Webhook" media for the user you created for  group notifications' || chr(13) || chr(10) || '    4.4. Send "/start@your_bot_name_here" in your group (Telegram bot won''t send anything to the group without it)','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('17','4','Zendesk','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('var Zendesk = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zendesk.params = params;' || chr(13) || chr(10) || '        if (typeof Zendesk.params.url === ''string'') {' || chr(13) || chr(10) || '            if (!Zendesk.params.url.endsWith(''/'')) {' || chr(13) || chr(10) || '                Zendesk.params.url += ''/'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            Zendesk.params.url += ''api/v2/'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    addCustomFields: function (data, fields) {' || chr(13) || chr(10) || '        if (typeof fields === ''object'' && Object.keys(fields).length) {' || chr(13) || chr(10) || '            var schema = Zendesk.getSchema(),' || chr(13) || chr(10) || '                arr = [],' || chr(13) || chr(10) || '                i,' || chr(13) || chr(10) || '                n;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (schema) {' || chr(13) || chr(10) || '                Object.keys(fields)' || chr(13) || chr(10) || '                    .forEach(function(field) {' || chr(13) || chr(10) || '                        for (i = 0, n = schema.ticket_fields.length; i < n; i++) {' || chr(13) || chr(10) || '                            if (schema.ticket_fields[i].id == field' || chr(13) || chr(10) || '                                && [''text'', ''integer'', ''date''].indexOf(schema.ticket_fields[i].type) !== -1){' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                                switch (schema.ticket_fields[i].type) {' || chr(13) || chr(10) || '                                    case ''integer'':' || chr(13) || chr(10) || '')||
TO_NCLOB('                                        fields[field] = parseInt(fields[field]);' || chr(13) || chr(10) || '                                        break;' || chr(13) || chr(10) || '                                    case ''date'':' || chr(13) || chr(10) || '                                        if (fields[field].match(/^\d{4}[.-]\d{2}[.-]\d{2}$/) !== null) {' || chr(13) || chr(10) || '                                            fields[field] = fields[field].replace(/\./g, ''-'');' || chr(13) || chr(10) || '                                        }' || chr(13) || chr(10) || '                                        else {' || chr(13) || chr(10) || '                                            fields[field] = '''';' || chr(13) || chr(10) || '                                        }' || chr(13) || chr(10) || '                                        break;' || chr(13) || chr(10) || '                                }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                                arr.push({id: field, value: fields[field]});' || chr(13) || chr(10) || '                                break;' || chr(13) || chr(10) || '                            }' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '                    });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                if (arr.length) {' || chr(13) || chr(10) || '                    data.ticket[''custom_fields''] = arr;' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[Zendesk Webhook] Failed to retrieve field schema.'');' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return data;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (method, query, data) {' || chr(13) || chr(10) || '')||
TO_NCLOB('        [''url'', ''token'', ''type''].forEach(function (field) {' || chr(13) || chr(10) || '            if (typeof Zendesk.params !== ''object'' || typeof Zendesk.params[field] === ''undefined'') {' || chr(13) || chr(10) || '                throw ''Required Zendesk param is not set: '' + field + ''\n'' + Zendesk.params[field];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            url = Zendesk.params.url + query,' || chr(13) || chr(10) || '            request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof Zendesk.HTTPProxy === ''string'' && Zendesk.HTTPProxy.trim() !== '''') {' || chr(13) || chr(10) || '            request.setProxy(Zendesk.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '        request.addHeader(''Authorization: Basic '' + btoa(Zendesk.params.token));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[Zendesk Webhook] Sending request: '' + url + ((typeof data === ''string'') ? ('' '' + data) : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (method) {' || chr(13) || chr(10) || '            case ''get'':' || chr(13) || chr(10) || '                response = request.get(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''post'':' || chr(13) || chr(10) || '                response = request.post(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('            case ''put'':' || chr(13) || chr(10) || '                response = request.put(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                throw ''Unsupported HTTP request method: '' + method;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[Zendesk Webhook] Received response with status code '' + request.getStatus() + ''. '' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[Zendesk Webhook] Failed to parse response received from Zendesk.'');' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() < 200 || request.getStatus() >= 300) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (response !== null && typeof response.error !== ''undefined''' || chr(13) || chr(10) || '                && Object.keys(response.error).length > 0) {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.error);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (response !== null && typeof response.description !== ''undefined''' || chr(13) || chr(10) || '                && Object.keys(response.description).length > 0) {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.description);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else {' || chr(13) || chr(10) || '')||
TO_NCLOB('                message += ''. '' + response;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            throw message + ''. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return {' || chr(13) || chr(10) || '            status: request.getStatus(),' || chr(13) || chr(10) || '            response: response' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    getSchema: function() {' || chr(13) || chr(10) || '        var result = Zendesk.request(''get'', ''ticket_fields.json'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return result.response;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    createIssue: function(data, fields) {' || chr(13) || chr(10) || '        var result = Zendesk.request(''post'', ''tickets.json'', Zendesk.addCustomFields(data, fields));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof result.response !== ''object'' || typeof result.response.ticket.id === ''undefined''' || chr(13) || chr(10) || '            || result.status != 201) {' || chr(13) || chr(10) || '            throw ''Cannot create Zendesk issue. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return result.response.ticket.id;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    updateIssue: function(data, fields) {' || chr(13) || chr(10) || '        Zendesk.request(''put'', ''tickets/'' + Zendesk.params.issue_key + ''.json'', Zendesk.addCustomFields(data, fields));' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        fields = {},' || chr(13) || chr(10) || '')||
TO_NCLOB('        zendesk = {},' || chr(13) || chr(10) || '        update = {},' || chr(13) || chr(10) || '        data = {},' || chr(13) || chr(10) || '        result = {tags: {}},' || chr(13) || chr(10) || '        required_params = [' || chr(13) || chr(10) || '            ''alert_subject'',' || chr(13) || chr(10) || '            ''alert_message'',' || chr(13) || chr(10) || '            ''event_id'',' || chr(13) || chr(10) || '            ''event_source'',' || chr(13) || chr(10) || '            ''event_value'',' || chr(13) || chr(10) || '            ''event_update_status''' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        severities = [' || chr(13) || chr(10) || '            {name: ''not_classified'', color: ''#97AAB3''},' || chr(13) || chr(10) || '            {name: ''information'', color: ''#7499FF''},' || chr(13) || chr(10) || '            {name: ''warning'', color: ''#FFC859''},' || chr(13) || chr(10) || '            {name: ''average'', color: ''#FFA059''},' || chr(13) || chr(10) || '            {name: ''high'', color: ''#E97659''},' || chr(13) || chr(10) || '            {name: ''disaster'', color: ''#E45959''},' || chr(13) || chr(10) || '            {name: ''resolved'', color: ''#009900''},' || chr(13) || chr(10) || '            {name: ''default'', color: ''#000000''}' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        priority;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (key.startsWith(''zendesk_'')) {' || chr(13) || chr(10) || '                zendesk[key.substring(8)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''customfield_'')) {' || chr(13) || chr(10) || '                fields[key.substring(12)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''event_update_'')) {' || chr(13) || chr(10) || '')||
TO_NCLOB('                update[key.substring(13)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (required_params.indexOf(key) !== -1 && params[key].trim() === '''') {' || chr(13) || chr(10) || '                throw ''Parameter '' + key + '' cannot be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Possible values: question, incident, problems, task' || chr(13) || chr(10) || '    if ([''question'', ''incident'', ''problem'', ''task''].indexOf(params.zendesk_type) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "zendesk_type" parameter given: '' + params.zendesk_type +' || chr(13) || chr(10) || '            ''\nMust be one of question, incident, problem, task.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Possible values: 0 - Trigger, 1 - Discovery, 2 - Autoregistration, 3 - Internal.' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    // Possible values: 1 for problem, 0 for recovering' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '')||
TO_NCLOB('    // Possible values: 0 - Webhook was called because of problem/recovery event, 1 - Update operation.' || chr(13) || chr(10) || '    if (params.event_source === ''0'' && params.event_update_status !== ''0'' && params.event_update_status !== ''1'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_value === ''0'') {' || chr(13) || chr(10) || '        throw ''Recovery operations are supported only for trigger-based actions.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Zendesk_issue_key must be a positive integer if an update action is being performed.' || chr(13) || chr(10) || '    if (params.event_source === ''0'' && ((params.event_value === ''1'' && params.event_update_status === ''1'')' || chr(13) || chr(10) || '        || (params.event_value === ''0'' && (params.event_update_status === ''0'' || params.event_update_status === ''1'')))' || chr(13) || chr(10) || '        && (isNaN(parseInt(params.zendesk_issue_key)) || parseInt(params.zendesk_issue_key) < 1 )) {' || chr(13) || chr(10) || '        throw ''Incorrect "zendesk_issue_key" parameter given: '' + params.zendesk_issue_key +' || chr(13) || chr(10) || '            ''\nMust be positive integer.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {' || chr(13) || chr(10) || '        params.event_nseverity = ''7'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value === ''0'') {' || chr(13) || chr(10) || '        params.event_nseverity = ''6'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    priority = params[''severity_'' + severities[params.event_nseverity].name] || severities[7].name;' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '    Zendesk.setParams(zendesk);' || chr(13) || chr(10) || '    Zendesk.HTTPProxy = params.HTTPProxy;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Create issue for non trigger-based events.' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_value !== ''0'') {' || chr(13) || chr(10) || '        data = {' || chr(13) || chr(10) || '            ticket: {' || chr(13) || chr(10) || '                external_id: params.event_id,' || chr(13) || chr(10) || '                type: Zendesk.params.type,' || chr(13) || chr(10) || '                status: ''new'',' || chr(13) || chr(10) || '                subject: params.alert_subject,' || chr(13) || chr(10) || '                comment: {' || chr(13) || chr(10) || '                    body: params.alert_message,' || chr(13) || chr(10) || '                    public: ''false''' || chr(13) || chr(10) || '                },' || chr(13) || chr(10) || '                priority: priority,' || chr(13) || chr(10) || '                tags: params.event_tags' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zendesk.createIssue(data, fields);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Create issue for trigger-based events.' || chr(13) || chr(10) || '    else if (params.event_value === ''1'' && update.status === ''0'') {' || chr(13) || chr(10) || '        data = {' || chr(13) || chr(10) || '            ticket: {' || chr(13) || chr(10) || '                external_id: params.event_id,' || chr(13) || chr(10) || '                type: Zendesk.params.type,' || chr(13) || chr(10) || '                status: ''new'',' || chr(13) || chr(10) || '                subject: params.alert_subject,' || chr(13) || chr(10) || '                comment: {' || chr(13) || chr(10) || '')||
TO_NCLOB('                    body: params.zbxurl + (params.zbxurl.endsWith(''/'') ? '''' : ''/'') + ''tr_events.php?triggerid='' +' || chr(13) || chr(10) || '                        params.trigger_id + ''&eventid='' + params.event_id + ''\n'' + params.alert_message,' || chr(13) || chr(10) || '                    public: ''false''' || chr(13) || chr(10) || '                },' || chr(13) || chr(10) || '                priority: priority,' || chr(13) || chr(10) || '                tags: params.event_tags' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '        var key = Zendesk.createIssue(data, fields);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result.tags.__zbx_zdk_issuekey = key;' || chr(13) || chr(10) || '        result.tags.__zbx_zdk_issuelink = params.zendesk_url +' || chr(13) || chr(10) || '            (params.zendesk_url.endsWith(''/'') ? '''' : ''/'') + ''agent/tickets/'' + key;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Update created issue for trigger-based event.' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        data = {' || chr(13) || chr(10) || '            ticket: {' || chr(13) || chr(10) || '                type: Zendesk.params.type,' || chr(13) || chr(10) || '                subject: params.alert_subject,' || chr(13) || chr(10) || '                comment: {' || chr(13) || chr(10) || '                    body: params.alert_message,' || chr(13) || chr(10) || '                    public: ''false''' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zendesk.updateIssue(data, fields);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return JSON.stringify(result);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[Zendesk Webhook] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_zdk_issuelink}','Zendesk: {EVENT.TAGS.__zbx_zdk_issuekey}','','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('18','4','ServiceNow','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('var ServiceNow = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        ServiceNow.params = params;' || chr(13) || chr(10) || '        if (typeof ServiceNow.params.url === ''string'') {' || chr(13) || chr(10) || '            if (!ServiceNow.params.url.endsWith(''/'')) {' || chr(13) || chr(10) || '                ServiceNow.params.url += ''/'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            ServiceNow.params.url += ''api/now/table/incident'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setProxy: function (HTTPProxy) {' || chr(13) || chr(10) || '        ServiceNow.HTTPProxy = HTTPProxy;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setFields: function (data, fields) {' || chr(13) || chr(10) || '        if (typeof fields === ''object'' && Object.keys(fields).length) {' || chr(13) || chr(10) || '            Object.keys(fields)' || chr(13) || chr(10) || '                .forEach(function(field) {' || chr(13) || chr(10) || '                    data[field] = (fields[field].match(/^\d{4}\.\d{2}\.\d{2}$/) !== null)' || chr(13) || chr(10) || '                        ? fields[field].replace(/\./g, ''-'')' || chr(13) || chr(10) || '                        : fields[field];' || chr(13) || chr(10) || '                });' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (method, data) {' || chr(13) || chr(10) || '        [''url'', ''user'', ''password''].forEach(function (field) {' || chr(13) || chr(10) || '')||
TO_NCLOB('            if (typeof ServiceNow.params !== ''object'' || typeof ServiceNow.params[field] === ''undefined''' || chr(13) || chr(10) || '                || ServiceNow.params[field] === '''' ) {' || chr(13) || chr(10) || '                throw ''Required ServiceNow param is not set: "'' + field + ''".'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            url = ServiceNow.params.url,' || chr(13) || chr(10) || '            request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '        request.addHeader(''Authorization: Basic '' + btoa(ServiceNow.params.user + '':'' + ServiceNow.params.password));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof ServiceNow.HTTPProxy !== ''undefined'' && ServiceNow.HTTPProxy !== '''') {' || chr(13) || chr(10) || '            request.setProxy(ServiceNow.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ ServiceNow Webhook ] Sending request: '' + url + ((typeof data === ''string'')' || chr(13) || chr(10) || '            ? (''\n'' + data)' || chr(13) || chr(10) || '            : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (method) {' || chr(13) || chr(10) || '            case ''get'':' || chr(13) || chr(10) || '                response = request.get(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''post'':' || chr(13) || chr(10) || '                response = request.post(url, data);' || chr(13) || chr(10) || '')||
TO_NCLOB('                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''put'':' || chr(13) || chr(10) || '                response = request.put(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                throw ''Unsupported HTTP request method: '' + method;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ ServiceNow Webhook ] Received response with status code '' +' || chr(13) || chr(10) || '            request.getStatus() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ ServiceNow Webhook ] Failed to parse response received from ServiceNow'');' || chr(13) || chr(10) || '                response = null;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() < 200 || request.getStatus() >= 300) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (response !== null && typeof response.error.message !== ''undefined''' || chr(13) || chr(10) || '                && Object.keys(response.error).length > 0) {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.error.message);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            throw message + '' Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '')||
TO_NCLOB('        else if (typeof response.result !== ''object'' || typeof response.result.sys_id === ''undefined'') {' || chr(13) || chr(10) || '            throw ''Cannot create ServiceNow incident. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return response.result;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        fields = {},' || chr(13) || chr(10) || '        servicenow = {},' || chr(13) || chr(10) || '        data = {},' || chr(13) || chr(10) || '        result = {tags: {}},' || chr(13) || chr(10) || '        required_params = [' || chr(13) || chr(10) || '            ''alert_subject'', ''alert_message'', ''event_source'', ''event_value'',' || chr(13) || chr(10) || '            ''event_update_status'', ''event_recovery_value'', ''event_nseverity''' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        severities = [' || chr(13) || chr(10) || '            {name: ''not_classified'', color: ''#97AAB3''},' || chr(13) || chr(10) || '            {name: ''information'', color: ''#7499FF''},' || chr(13) || chr(10) || '            {name: ''warning'', color: ''#FFC859''},' || chr(13) || chr(10) || '            {name: ''average'', color: ''#FFA059''},' || chr(13) || chr(10) || '            {name: ''high'', color: ''#E97659''},' || chr(13) || chr(10) || '            {name: ''disaster'', color: ''#E45959''},' || chr(13) || chr(10) || '            {name: ''resolved'', color: ''#009900''},' || chr(13) || chr(10) || '            {name: ''default'', color: ''#000000''}' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        method = ''post'',' || chr(13) || chr(10) || '        process_tags = true;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '')||
TO_NCLOB('            if (key.startsWith(''servicenow_'')) {' || chr(13) || chr(10) || '                servicenow[key.substring(11)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''u_'')) {' || chr(13) || chr(10) || '                fields[key] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (required_params.indexOf(key) !== -1 && params[key] === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" can\''t be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {' || chr(13) || chr(10) || '        params.event_nseverity = ''7'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'' && params.event_source === ''0'') {' || chr(13) || chr(10) || '')||
TO_NCLOB('        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_recovery_value === ''0'') {' || chr(13) || chr(10) || '        throw ''Recovery operations are supported only for trigger-based actions.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    data.short_description = params.alert_subject;' || chr(13) || chr(10) || '    data.description = params.alert_message;' || chr(13) || chr(10) || '    data.comments = params.alert_message;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params[''urgency_for_'' + severities[params.event_nseverity].name] !== ''undefined'') {' || chr(13) || chr(10) || '        data.urgency = params[''urgency_for_'' + severities[params.event_nseverity].name];' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    ServiceNow.setParams(servicenow);' || chr(13) || chr(10) || '    ServiceNow.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    ServiceNow.setFields(data, fields);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source === ''0'' && (params.event_value === ''0'' || params.event_update_status === ''1'')) {' || chr(13) || chr(10) || '        process_tags = false;' || chr(13) || chr(10) || '        method = ''put'';' || chr(13) || chr(10) || '        delete data.description;' || chr(13) || chr(10) || '        delete data.urgency;' || chr(13) || chr(10) || '        ServiceNow.params.url += ''/'' + params.servicenow_sys_id;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var response = ServiceNow.request(method, data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (process_tags) {' || chr(13) || chr(10) || '        result.tags.__zbx_servicenow_sys_id = response.sys_id;' || chr(13) || chr(10) || '        result.tags.__zbx_servicenow_link = params.servicenow_url +' || chr(13) || chr(10) || '')||
TO_NCLOB('            (params.servicenow_url.endsWith(''/'') ? '''' : ''/'') + ''incident.do?sys_id='' + response.sys_id;' || chr(13) || chr(10) || '        result.tags.__zbx_servicenow_number = response.number;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return JSON.stringify(result);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ ServiceNow Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_servicenow_link}','ServiceNow: {EVENT.TAGS.__zbx_servicenow_number}','','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('19','4','Zammad','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('var Zammad = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zammad.params = params;' || chr(13) || chr(10) || '        if (typeof Zammad.params.url === ''string'') {' || chr(13) || chr(10) || '            if (!Zammad.params.url.endsWith(''/'')) {' || chr(13) || chr(10) || '                Zammad.params.url += ''/'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (method, query, data) {' || chr(13) || chr(10) || '        [''url'', ''access_token''].forEach(function (field) {' || chr(13) || chr(10) || '            if (typeof Zammad.params !== ''object'' || typeof Zammad.params[field] === ''undefined''' || chr(13) || chr(10) || '                || Zammad.params[field] === '''' ) {' || chr(13) || chr(10) || '                throw ''Required param is not set: "'' + field + ''".'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            url = Zammad.params.url + query,' || chr(13) || chr(10) || '            request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof Zammad.HTTPProxy === ''string'' && Zammad.HTTPProxy.trim() !== '''') {' || chr(13) || chr(10) || '            request.setProxy(Zammad.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '')||
TO_NCLOB('        request.addHeader(''Authorization: Token token='' + Zammad.params.access_token);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ Zammad Webhook ] Sending request: '' +' || chr(13) || chr(10) || '            url + ((typeof data === ''string'') ? ('' '' + data) : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (method) {' || chr(13) || chr(10) || '            case ''get'':' || chr(13) || chr(10) || '                response = request.get(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''post'':' || chr(13) || chr(10) || '                response = request.post(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''put'':' || chr(13) || chr(10) || '                response = request.put(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                throw ''Unsupported HTTP request method: '' + method;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ Zammad Webhook ] Received response with status code '' + request.getStatus() + '': '' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ Zammad Webhook ] Failed to parse response received from Zammad'');' || chr(13) || chr(10) || '                response = null;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '')||
TO_NCLOB('        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() < 200 || request.getStatus() >= 300) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (response !== null && typeof response.errors !== ''undefined''' || chr(13) || chr(10) || '                && Object.keys(response.errors).length > 0) {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.errors);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (response !== null && typeof response.errorMessages !== ''undefined''' || chr(13) || chr(10) || '                && Object.keys(response.errorMessages).length > 0) {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.errorMessages);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            throw message + '' Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return {' || chr(13) || chr(10) || '            status: request.getStatus(),' || chr(13) || chr(10) || '            response: response' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setTicketTags: function (tags, ticket_id) {' || chr(13) || chr(10) || '        var data = {' || chr(13) || chr(10) || '            item: '''',' || chr(13) || chr(10) || '            object: ''Ticket'',' || chr(13) || chr(10) || '            o_id: ticket_id' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        try {' || chr(13) || chr(10) || '            var tags_json = JSON.parse(tags),' || chr(13) || chr(10) || '                result;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('            for (var i in tags_json) {' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                if (tags_json[i].value) {' || chr(13) || chr(10) || '                    data.item = tags_json[i].tag + ": " + tags_json[i].value;' || chr(13) || chr(10) || '                } else {' || chr(13) || chr(10) || '                    data.item = tags_json[i].tag;' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '                result = Zammad.request(''post'', ''api/v1/tags/add'', data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                if (typeof result.response !== ''object'' || result.status != 200) {' || chr(13) || chr(10) || '                    Zabbix.log(4, ''[ Zammad Webhook ] Cannot add ticket tag:'' + tags_json[i].tag);' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        catch (error) {' || chr(13) || chr(10) || '            Zabbix.log(4, ''[ Zammad Webhook ] Failed to add ticket tags:'' + error);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    createTicket: function(subject, message, priority) {' || chr(13) || chr(10) || '        var data = {' || chr(13) || chr(10) || '                title: subject,' || chr(13) || chr(10) || '                group: ''Users'',' || chr(13) || chr(10) || '                article: {' || chr(13) || chr(10) || '                    subject: subject,' || chr(13) || chr(10) || '                    body: message,' || chr(13) || chr(10) || '                    type: ''note'',' || chr(13) || chr(10) || '                    internal: false' || chr(13) || chr(10) || '                },' || chr(13) || chr(10) || '                customer: Zammad.params.customer' || chr(13) || chr(10) || '            },' || chr(13) || chr(10) || '            result;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('        if (priority) {' || chr(13) || chr(10) || '            data.priority_id = priority;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result = Zammad.request(''post'', ''api/v1/tickets'', data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof result.response !== ''object''' || chr(13) || chr(10) || '            || typeof result.response.id === ''undefined''' || chr(13) || chr(10) || '            || result.status != 201) {' || chr(13) || chr(10) || '            throw ''Cannot create Zammad ticket. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return result.response.id;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    updateTicket: function(subject, message) {' || chr(13) || chr(10) || '        var data = {' || chr(13) || chr(10) || '            ticket_id: Zammad.params.ticket_id,' || chr(13) || chr(10) || '            subject: subject,' || chr(13) || chr(10) || '            body: message || '''',' || chr(13) || chr(10) || '            type: ''note'',' || chr(13) || chr(10) || '            internal: false' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result = Zammad.request(''post'', ''api/v1/ticket_articles'', data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof result.response !== ''object''' || chr(13) || chr(10) || '            || typeof result.response.id === ''undefined''' || chr(13) || chr(10) || '            || result.status != 201) {' || chr(13) || chr(10) || '            throw ''Cannot update Zammad ticket. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '')||
TO_NCLOB('        params_zammad = {},' || chr(13) || chr(10) || '        params_update = {},' || chr(13) || chr(10) || '        result = {tags: {}},' || chr(13) || chr(10) || '        required_params = [' || chr(13) || chr(10) || '            ''alert_subject'', ''customer'',' || chr(13) || chr(10) || '            ''event_source'', ''event_value'',' || chr(13) || chr(10) || '            ''event_update_status''' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        severities = [' || chr(13) || chr(10) || '            {name: ''not_classified'', color: ''#97AAB3''},' || chr(13) || chr(10) || '            {name: ''information'', color: ''#7499FF''},' || chr(13) || chr(10) || '            {name: ''warning'', color: ''#FFC859''},' || chr(13) || chr(10) || '            {name: ''average'', color: ''#FFA059''},' || chr(13) || chr(10) || '            {name: ''high'', color: ''#E97659''},' || chr(13) || chr(10) || '            {name: ''disaster'', color: ''#E45959''},' || chr(13) || chr(10) || '            {name: ''resolved'', color: ''#009900''},' || chr(13) || chr(10) || '            {name: null, color: ''#000000''}' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        priority;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (key.startsWith(''zammad_'')) {' || chr(13) || chr(10) || '                params_zammad[key.substring(7)] = params[key].trim();' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''event_update_'')) {' || chr(13) || chr(10) || '                params_update[key.substring(13)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (required_params.indexOf(key) !== -1 && params[key].trim() === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" cannot be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '')||
TO_NCLOB('        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '    if (params.event_source === ''0'' && params.event_update_status !== ''0'' && params.event_update_status !== ''1'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_value === ''0'') {' || chr(13) || chr(10) || '        throw ''Recovery operations are supported only for trigger-based actions.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source === ''0''' || chr(13) || chr(10) || '        && ((params.event_value === ''1'' && params.event_update_status === ''1'')' || chr(13) || chr(10) || '            || (params.event_value === ''0''' || chr(13) || chr(10) || '                && (params.event_update_status === ''0'' || params.event_update_status === ''1'')))' || chr(13) || chr(10) || '        && (isNaN(parseInt(params.zammad_ticket_id)) || parseInt(params.zammad_ticket_id) < 1 )) {' || chr(13) || chr(10) || '')||
TO_NCLOB('        throw ''Incorrect "zammad_ticket_id" parameter given: '' + params.zammad_ticket_id +' || chr(13) || chr(10) || '            ''\nMust be positive integer.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {' || chr(13) || chr(10) || '        params.event_nseverity = ''7'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value === ''0'') {' || chr(13) || chr(10) || '        params.event_nseverity = ''6'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    priority = params[''severity_'' + severities[params.event_nseverity].name];' || chr(13) || chr(10) || '    priority = priority && priority.trim() || severities[7].name;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Zammad.setParams(params_zammad);' || chr(13) || chr(10) || '    Zammad.HTTPProxy = params.HTTPProxy;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Create ticket for non trigger-based events.' || chr(13) || chr(10) || '    if (params.event_source !== ''0''' || chr(13) || chr(10) || '        && params.event_value !== ''0'') {' || chr(13) || chr(10) || '        Zammad.createTicket(params.alert_subject, params.alert_message, priority, params.event_tags);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Create ticket for trigger-based events.' || chr(13) || chr(10) || '    else if (params.event_value === ''1'' && params_update.status === ''0''' || chr(13) || chr(10) || '             && Number.isInteger(parseInt(Zammad.params.ticket_id)) === false) {' || chr(13) || chr(10) || '        var ticket_id = Zammad.createTicket(params.alert_subject,' || chr(13) || chr(10) || '            params.alert_subject + ''\n'' + params.alert_message + ''\n'' +' || chr(13) || chr(10) || '            params.zabbix_url + (params.zabbix_url.endsWith(''/'') ? '''' : ''/'') +' || chr(13) || chr(10) || '')||
TO_NCLOB('            ''tr_events.php?triggerid='' + params.trigger_id + ''&eventid='' + params.event_id + ''\n'',' || chr(13) || chr(10) || '            priority);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result.tags.__zbx_zammad_ticket_id = ticket_id;' || chr(13) || chr(10) || '        result.tags.__zbx_zammad_ticketlink = params.zammad_url +' || chr(13) || chr(10) || '            (params.zammad_url.endsWith(''/'') ? '''' : ''/'') + ''#ticket/zoom/'' + ticket_id;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (Zammad.params.enable_tags.toLowerCase() === ''true'') {' || chr(13) || chr(10) || '            Zammad.setTicketTags(params.event_tags, ticket_id);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Update created ticket for trigger-based event.' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        Zammad.updateTicket(params.alert_subject, params.alert_message);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return JSON.stringify(result);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ Zammad Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_zammad_ticketlink}','Zammad: ticket #{EVENT.TAGS.__zbx_zammad_ticket_id}','','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('20','4','Jira ServiceDesk','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('var Jira = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '    schema: {},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Jira.params = params;' || chr(13) || chr(10) || '        if (typeof Jira.params.url === ''string'') {' || chr(13) || chr(10) || '            if (!Jira.params.url.endsWith(''/'')) {' || chr(13) || chr(10) || '                Jira.params.url += ''/'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            Jira.params.url += ''rest/servicedeskapi/'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setProxy: function (HTTPProxy) {' || chr(13) || chr(10) || '        Jira.HTTPProxy = HTTPProxy;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setTags: function(event_tags_json) {' || chr(13) || chr(10) || '        if (!Jira.schema) {' || chr(13) || chr(10) || '            Zabbix.log(4, ''[ Jira Service Desk Webhook ] Cannot add labels because failed to retrieve field schema.'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var block = Jira.schema.requestTypeFields.filter(function(object) {' || chr(13) || chr(10) || '            return object.fieldId == ''labels'';' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (block[0] && typeof event_tags_json !== ''undefined'' && event_tags_json !== ''''' || chr(13) || chr(10) || '            && event_tags_json !== ''{EVENT.TAGSJSON}'') {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '')||
TO_NCLOB('                var tags = JSON.parse(event_tags_json),' || chr(13) || chr(10) || '                    label;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                Jira.labels = [];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                tags.forEach(function (tag) {' || chr(13) || chr(10) || '                    if (typeof tag.tag !== ''undefined'' && typeof tag.value !== ''undefined'' ) {' || chr(13) || chr(10) || '                        label = (tag.tag + (tag.value ? ('':'' + tag.value) : '''')).replace(/\s/g, ''_'');' || chr(13) || chr(10) || '                        if (label.length < 255) {' || chr(13) || chr(10) || '                            Jira.labels.push(label);' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '                    }' || chr(13) || chr(10) || '                });' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                // Code is not missing here.' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    addCustomFields: function (data, fields) {' || chr(13) || chr(10) || '        if (typeof fields === ''object'' && Object.keys(fields).length) {' || chr(13) || chr(10) || '            if (Jira.schema) {' || chr(13) || chr(10) || '                Object.keys(fields)' || chr(13) || chr(10) || '                    .forEach(function(field) {' || chr(13) || chr(10) || '                        data.requestFieldValues[field] = fields[field];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                        var block = Jira.schema.requestTypeFields.filter(function(object) {' || chr(13) || chr(10) || '                            return object.fieldId == field;' || chr(13) || chr(10) || '                        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('                        if (typeof block[0] === ''object'' && typeof block[0].jiraSchema === ''object''' || chr(13) || chr(10) || '                            && (block[0].jiraSchema.type === ''number'' || block[0].jiraSchema.type === ''datetime'')) {' || chr(13) || chr(10) || '                            switch (block[0].jiraSchema.type) {' || chr(13) || chr(10) || '                                case ''number'':' || chr(13) || chr(10) || '                                    data.requestFieldValues[field] = parseInt(fields[field]);' || chr(13) || chr(10) || '                                    break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                                case ''datetime'':' || chr(13) || chr(10) || '                                    if (fields[field].match(/\d+[.-]\d+[.-]\d+T\d+:\d+:\d+/) !== null) {' || chr(13) || chr(10) || '                                        data.requestFieldValues[field] = fields[field].replace(/\./g, ''-'');' || chr(13) || chr(10) || '                                    }' || chr(13) || chr(10) || '                                    else {' || chr(13) || chr(10) || '                                        delete data.requestFieldValues[field];' || chr(13) || chr(10) || '                                    }' || chr(13) || chr(10) || '                                    break;' || chr(13) || chr(10) || '                            }' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '                    });' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ Jira Service Desk Webhook ] Cannot add custom fields'' +' || chr(13) || chr(10) || '                    ''because failed to retrieve field schema.'');' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return data;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    request: function (method, query, data) {' || chr(13) || chr(10) || '        [''url'', ''user'', ''password'', ''servicedesk_id'', ''request_type_id''].forEach(function (field) {' || chr(13) || chr(10) || '            if (typeof Jira.params !== ''object'' || typeof Jira.params[field] === ''undefined''' || chr(13) || chr(10) || '                || Jira.params[field] === '''' ) {' || chr(13) || chr(10) || '                throw ''Required Jira param is not set: "'' + field + ''".'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            url = Jira.params.url + query,' || chr(13) || chr(10) || '            request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '        request.addHeader(''Authorization: Basic '' + btoa(Jira.params.user + '':'' + Jira.params.password));' || chr(13) || chr(10) || '        request.addHeader(''X-ExperimentalApi: opt-in'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof Jira.HTTPProxy !== ''undefined'' && Jira.HTTPProxy !== '''') {' || chr(13) || chr(10) || '            request.setProxy(Jira.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ Jira Service Desk Webhook ] Sending request: '' + url +' || chr(13) || chr(10) || '            ((typeof data === ''string'') ? (''\n'' + data) : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (method) {' || chr(13) || chr(10) || '            case ''get'':' || chr(13) || chr(10) || '                response = request.get(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '            case ''post'':' || chr(13) || chr(10) || '                response = request.post(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''put'':' || chr(13) || chr(10) || '                response = request.put(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                throw ''Unsupported HTTP request method: '' + method;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ Jira Service Desk Webhook ] Received response with status code '' +' || chr(13) || chr(10) || '            request.getStatus() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ Jira Service Desk Webhook ] Failed to parse response received from Jira'');' || chr(13) || chr(10) || '                response = null;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() < 200 || request.getStatus() >= 300) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (response !== null && typeof response.errors !== ''undefined''' || chr(13) || chr(10) || '                && Object.keys(response.errors).length > 0) {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.errors);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '')||
TO_NCLOB('            else if (response !== null && typeof response.errorMessage !== ''undefined''' || chr(13) || chr(10) || '                && Object.keys(response.errorMessage).length > 0) {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.errorMessage);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            throw message + '' Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return {' || chr(13) || chr(10) || '            status: request.getStatus(),' || chr(13) || chr(10) || '            response: response' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    getSchema: function() {' || chr(13) || chr(10) || '        var result = Jira.request(''get'', ''servicedesk/'' + Jira.params.servicedesk_id + ''/requesttype/'' +' || chr(13) || chr(10) || '            Jira.params.request_type_id + ''/field'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof Jira.schema !== ''object'' && typeof Jira.schema.requestTypeFields !== ''object'') {' || chr(13) || chr(10) || '            Jira.schema = null;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            Jira.schema = result.response;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    createRequest: function(summary, description, fields) {' || chr(13) || chr(10) || '        var data = {' || chr(13) || chr(10) || '            serviceDeskId: Jira.params.servicedesk_id,' || chr(13) || chr(10) || '            requestTypeId: Jira.params.request_type_id,' || chr(13) || chr(10) || '            requestFieldValues: {' || chr(13) || chr(10) || '                summary: summary,' || chr(13) || chr(10) || '                description: description' || chr(13) || chr(10) || '')||
TO_NCLOB('            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (Jira.labels && Jira.labels.length > 0) {' || chr(13) || chr(10) || '            data.requestFieldValues.labels = Jira.labels;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        var result = Jira.request(''post'', ''request'', Jira.addCustomFields(data, fields));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof result.response !== ''object'' || typeof result.response.issueKey === ''undefined'') {' || chr(13) || chr(10) || '            throw ''Cannot create Jira request. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return result.response.issueKey;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        fields = {},' || chr(13) || chr(10) || '        jira = {},' || chr(13) || chr(10) || '        comment = {public: true},' || chr(13) || chr(10) || '        result = {tags: {}},' || chr(13) || chr(10) || '        required_params = [' || chr(13) || chr(10) || '            ''alert_subject'', ''alert_message'', ''event_source'', ''event_value'',' || chr(13) || chr(10) || '            ''event_update_status'', ''event_recovery_value''' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (key.startsWith(''jira_'')) {' || chr(13) || chr(10) || '                jira[key.substring(5)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''customfield_'')) {' || chr(13) || chr(10) || '                fields[key] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '')||
TO_NCLOB('            else if (required_params.indexOf(key) !== -1 && params[key] === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" cannot be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'' && params.event_source === ''0'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_recovery_value === ''0'') {' || chr(13) || chr(10) || '        throw ''Recovery operations are supported only for trigger-based actions.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Jira.setParams(jira);' || chr(13) || chr(10) || '    Jira.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    Jira.getSchema();' || chr(13) || chr(10) || '')||
TO_NCLOB('    Jira.setTags(params.event_tags_json);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Create request for non trigger-based events.' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_recovery_value !== ''0'') {' || chr(13) || chr(10) || '        Jira.createRequest(params.alert_subject, params.alert_message);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Create request for trigger-based events.' || chr(13) || chr(10) || '    else if (params.event_value === ''1'' && params.event_update_status === ''0''' || chr(13) || chr(10) || '        && jira.request_key === ''{EVENT.TAGS.__zbx_jira_requestkey}'') {' || chr(13) || chr(10) || '        var key = Jira.createRequest(params.alert_subject, params.alert_message, fields);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result.tags.__zbx_jira_requestkey = key;' || chr(13) || chr(10) || '        result.tags.__zbx_jira_requestlink = params.jira_url +' || chr(13) || chr(10) || '            (params.jira_url.endsWith(''/'') ? '''' : ''/'') + ''browse/'' + key;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Comment created request for trigger-based event.' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        if (jira.request_key === ''{EVENT.TAGS.__zbx_jira_requestkey}'' || jira.request_key.trim() === '''') {' || chr(13) || chr(10) || '            throw ''Incorrect Request key given: '' + jira.request_key;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        comment.body = params.alert_message;' || chr(13) || chr(10) || '        Jira.request(''post'', ''request/'' + Jira.params.request_key + ''/comment'', comment);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return JSON.stringify(result);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ Jira Service Desk Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_jira_requestlink}','Jira ServiceDesk: {EVENT.TAGS.__zbx_jira_requestkey}','','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('21','4','OTRS','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('var OTRS = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '    entrypoint: ''nph-genericinterface.pl/Webservice/ZabbixTicketConnector/Ticket'',' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        OTRS.params = params;' || chr(13) || chr(10) || '        if (typeof OTRS.params.url === ''string'') {' || chr(13) || chr(10) || '            if (!OTRS.params.url.endsWith(''/'')) {' || chr(13) || chr(10) || '                OTRS.params.url += ''/'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    addDynamicFields: function (data, fields) {' || chr(13) || chr(10) || '        if (typeof fields === ''object'' && Object.keys(fields).length) {' || chr(13) || chr(10) || '            data.DynamicField = [];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            Object.keys(fields)' || chr(13) || chr(10) || '                .forEach(function(field) {' || chr(13) || chr(10) || '                    if (field !== undefined) {' || chr(13) || chr(10) || '                        if (fields[field].match(/^\d{4}[.-]\d{2}[.-]\d{2}$/)) {' || chr(13) || chr(10) || '                            fields[field] = fields[field].replace(/\./g, ''-'');' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                        data.DynamicField.push({Name: field, Value: fields[field]});' || chr(13) || chr(10) || '                    }' || chr(13) || chr(10) || '                });' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return data;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    request: function (method, query, data) {' || chr(13) || chr(10) || '        [''url'', ''auth_user'', ''auth_password'', ''queue'',' || chr(13) || chr(10) || '            ''customer'', ''ticket_state'', ''default_priority_id'', ''time_unit''].forEach(function (field) {' || chr(13) || chr(10) || '            if (typeof OTRS.params !== ''object'' || typeof OTRS.params[field] === ''undefined''' || chr(13) || chr(10) || '                || OTRS.params[field] === '''' ) {' || chr(13) || chr(10) || '                throw ''Required param is not set: "'' + field + ''".'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            request = new HttpRequest(),' || chr(13) || chr(10) || '            url = OTRS.params.url + query +' || chr(13) || chr(10) || '                ''?UserLogin='' + encodeURIComponent(OTRS.params.auth_user) +' || chr(13) || chr(10) || '                ''&Password='' + encodeURIComponent(OTRS.params.auth_password);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof OTRS.HTTPProxy !== ''undefined'' && OTRS.HTTPProxy.trim() !== '''') {' || chr(13) || chr(10) || '            request.setProxy(OTRS.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ OTRS Webhook ] Sending request: '' +' || chr(13) || chr(10) || '            url + ((typeof data === ''string'') ? ('' '' + data) : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (method) {' || chr(13) || chr(10) || '            case ''get'':' || chr(13) || chr(10) || '')||
TO_NCLOB('                response = request.get(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''post'':' || chr(13) || chr(10) || '                response = request.post(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''put'':' || chr(13) || chr(10) || '                response = request.put(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                throw ''Unsupported HTTP request method: '' + method;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ OTRS Webhook ] Received response with status code '' + request.getStatus() + '': '' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() < 200 || request.getStatus() >= 300) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            message += '': '' + response;' || chr(13) || chr(10) || '            throw message + '' Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ OTRS Webhook ] Failed to parse response received from OTRS'');' || chr(13) || chr(10) || '                response = null;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('        if (typeof response.Error !== ''undefined''' || chr(13) || chr(10) || '            && Object.keys(response.Error).length > 0) {' || chr(13) || chr(10) || '            message = ''Request failed: '' + JSON.stringify(response.Error);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return {' || chr(13) || chr(10) || '            status: request.getStatus(),' || chr(13) || chr(10) || '            response: response' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    createTicket: function(subject, message, priority, fields) {' || chr(13) || chr(10) || '        var result,' || chr(13) || chr(10) || '            data = {' || chr(13) || chr(10) || '                Ticket: {' || chr(13) || chr(10) || '                    Title: subject,' || chr(13) || chr(10) || '                    Queue: OTRS.params.queue,' || chr(13) || chr(10) || '                    State: OTRS.params.ticket_state,' || chr(13) || chr(10) || '                    PriorityID: priority || OTRS.params.default_priority_id,' || chr(13) || chr(10) || '                    CustomerUser: OTRS.params.customer' || chr(13) || chr(10) || '                },' || chr(13) || chr(10) || '                Article: {' || chr(13) || chr(10) || '                    Subject: subject,' || chr(13) || chr(10) || '                    Body: message,' || chr(13) || chr(10) || '                    TimeUnit: OTRS.params.time_unit,' || chr(13) || chr(10) || '                    ContentType: ''text/plain; charset=utf8''' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result = OTRS.request(''post'', OTRS.entrypoint, OTRS.addDynamicFields(data, fields));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof result.response !== ''object''' || chr(13) || chr(10) || '            || typeof result.response.TicketID === ''undefined''' || chr(13) || chr(10) || '')||
TO_NCLOB('            || result.status != 200) {' || chr(13) || chr(10) || '            throw ''Cannot create OTRS ticket. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return result.response.TicketID;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    updateTicket: function(subject, message) {' || chr(13) || chr(10) || '        var result,' || chr(13) || chr(10) || '            data = {' || chr(13) || chr(10) || '                Article: {' || chr(13) || chr(10) || '                    Subject: subject,' || chr(13) || chr(10) || '                    Body: message || '''',' || chr(13) || chr(10) || '                    TimeUnit: OTRS.params.time_unit,' || chr(13) || chr(10) || '                    ContentType: ''text/plain; charset=utf8''' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result = OTRS.request(''put'', OTRS.entrypoint + ''/'' + encodeURIComponent(OTRS.params.ticket_id), data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof result.response !== ''object''' || chr(13) || chr(10) || '            || typeof result.response.TicketID === ''undefined''' || chr(13) || chr(10) || '            || result.status != 200) {' || chr(13) || chr(10) || '            throw ''Cannot update OTRS ticket. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        params_otrs = {},' || chr(13) || chr(10) || '        params_fields = {},' || chr(13) || chr(10) || '        params_update = {},' || chr(13) || chr(10) || '        result = {tags: {}},' || chr(13) || chr(10) || '        required_params = [' || chr(13) || chr(10) || '')||
TO_NCLOB('            ''alert_subject'', ''event_source'',' || chr(13) || chr(10) || '            ''event_value'',  ''event_update_status''' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        severities = [' || chr(13) || chr(10) || '            {name: ''not_classified'', color: ''#97AAB3''},' || chr(13) || chr(10) || '            {name: ''information'', color: ''#7499FF''},' || chr(13) || chr(10) || '            {name: ''warning'', color: ''#FFC859''},' || chr(13) || chr(10) || '            {name: ''average'', color: ''#FFA059''},' || chr(13) || chr(10) || '            {name: ''high'', color: ''#E97659''},' || chr(13) || chr(10) || '            {name: ''disaster'', color: ''#E45959''},' || chr(13) || chr(10) || '            {name: ''resolved'', color: ''#009900''},' || chr(13) || chr(10) || '            {name: null, color: ''#000000''}' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        priority;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (key.startsWith(''otrs_'')) {' || chr(13) || chr(10) || '                params_otrs[key.substring(5)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''dynamicfield_'')) {' || chr(13) || chr(10) || '                params_fields[key.substring(13)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''event_update_'')) {' || chr(13) || chr(10) || '                params_update[key.substring(13)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (required_params.indexOf(key) !== -1 && params[key].trim() === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" cannot be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '    if (params.event_source === ''0'' && params.event_update_status !== ''0'' && params.event_update_status !== ''1'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_value === ''0'') {' || chr(13) || chr(10) || '        throw ''Recovery operations are supported only for trigger-based actions.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source === ''0''' || chr(13) || chr(10) || '        && ((params.event_value === ''1'' && params.event_update_status === ''1'')' || chr(13) || chr(10) || '            || (params.event_value === ''0''' || chr(13) || chr(10) || '                && (params.event_update_status === ''0'' || params.event_update_status === ''1'')))' || chr(13) || chr(10) || '        && (isNaN(parseInt(params.otrs_ticket_id)) || parseInt(params.otrs_ticket_id) < 1 )) {' || chr(13) || chr(10) || '')||
TO_NCLOB('        throw ''Incorrect "otrs_ticket_id" parameter given: '' + params.otrs_ticket_id +' || chr(13) || chr(10) || '            ''\nMust be positive integer.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {' || chr(13) || chr(10) || '        params.event_nseverity = ''7'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value === ''0'') {' || chr(13) || chr(10) || '        params.event_nseverity = ''6'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    priority = params[''severity_'' + severities[params.event_nseverity].name];' || chr(13) || chr(10) || '    priority = priority && priority.trim() || severities[7].name;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    OTRS.setParams(params_otrs);' || chr(13) || chr(10) || '    OTRS.HTTPProxy = params.HTTPProxy;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Create ticket for non trigger-based events.' || chr(13) || chr(10) || '    if (params.event_source !== ''0''' || chr(13) || chr(10) || '        && params.event_value !== ''0'') {' || chr(13) || chr(10) || '        OTRS.createTicket(params.alert_subject, params.alert_message, priority);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Create ticket for trigger-based events.' || chr(13) || chr(10) || '    else if (params.event_value === ''1'' && params_update.status === ''0'') {' || chr(13) || chr(10) || '        var ticket_id = OTRS.createTicket(params.alert_subject,' || chr(13) || chr(10) || '            params.alert_subject + ''\n'' + params.alert_message + ''\n'' +' || chr(13) || chr(10) || '            params.zabbix_url + (params.zabbix_url.endsWith(''/'') ? '''' : ''/'') +' || chr(13) || chr(10) || '            ''tr_events.php?triggerid='' + params.trigger_id + ''&eventid='' + params.event_id + ''\n'',' || chr(13) || chr(10) || '            priority,' || chr(13) || chr(10) || '')||
TO_NCLOB('            params_fields);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result.tags.__zbx_otrs_ticket_id = ticket_id;' || chr(13) || chr(10) || '        result.tags.__zbx_otrs_ticketlink = params.otrs_url +' || chr(13) || chr(10) || '            (params.otrs_url.endsWith(''/'') ? '''' : ''/'') + ''index.pl?Action=AgentTicketZoom;TicketID='' + ticket_id;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Update created ticket for trigger-based event.' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        OTRS.updateTicket(params.alert_subject, params.alert_message);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return JSON.stringify(result);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ OTRS Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_otrs_ticketlink}','OTRS: ticket #{EVENT.TAGS.__zbx_otrs_ticket_id}','','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('22','4','iLert','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('try {' || chr(13) || chr(10) || '    var result = { tags: {} },' || chr(13) || chr(10) || '        params = JSON.parse(value),' || chr(13) || chr(10) || '        req = new HttpRequest(),' || chr(13) || chr(10) || '        resp = '''';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.HTTPProxy === ''string'' && params.HTTPProxy.trim() !== '''') {' || chr(13) || chr(10) || '        req.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    var alertSourceKey = params[''.ILERT.ALERT.SOURCE.KEY''];' || chr(13) || chr(10) || '    if (!alertSourceKey || (typeof alertSourceKey === ''string'' && alertSourceKey.trim() === '''')) {' || chr(13) || chr(10) || '        throw ''incorrect value for variable "ILERT.ALERT.SOURCE.KEY". The value must be a non-empty string.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    delete params[''.ILERT.ALERT.SOURCE.KEY''];' || chr(13) || chr(10) || '    ' || chr(13) || chr(10) || '    var ilertApiBaseURL = "https://api.ilert.com";' || chr(13) || chr(10) || '    var reqURL = encodeURI(ilertApiBaseURL + "/api/v1/events/zabbix-mt/" + alertSourceKey)' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var incidentKey = "zabbix-" + params[''EVENT.ID''];' || chr(13) || chr(10) || '    var incidentViewURL = ilertApiBaseURL + "/api/v1/incidents/resolve-ik/" + alertSourceKey + "/" + incidentKey;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    req.addHeader(''Accept: application/json'');' || chr(13) || chr(10) || '    req.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Zabbix.log(4, ''[iLert Webhook] Sending request:'' + JSON.stringify(params));' || chr(13) || chr(10) || '    resp = req.post(reqURL, JSON.stringify(params));' || chr(13) || chr(10) || '    Zabbix.log(4, ''[iLert Webhook] Receiving response:'' + resp);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    try {' || chr(13) || chr(10) || '')||
TO_NCLOB('        resp = JSON.parse(resp);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    catch (error) {' || chr(13) || chr(10) || '        throw ''incorrect response. iLert returned a non-JSON object.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (req.getStatus() == 200) {' || chr(13) || chr(10) || '        result.tags.__ilert_incident_url = incidentViewURL;' || chr(13) || chr(10) || '        return JSON.stringify(result);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (req.getStatus() == 400 && typeof resp === ''object'' && typeof resp.code === ''string'') {' || chr(13) || chr(10) || '        if (resp.code === ''NO_OPEN_INCIDENT_WITH_KEY'') {' || chr(13) || chr(10) || '          return JSON.stringify(result);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        if (resp.code === ''INCIDENT_ALREADY_ACCEPTED'') {' || chr(13) || chr(10) || '          result.tags.__ilert_incident_url = incidentViewURL;' || chr(13) || chr(10) || '          return JSON.stringify(result);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof resp === ''object'' && typeof resp.message === ''string'') {' || chr(13) || chr(10) || '        throw resp.message;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        throw ''Unknown error.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[iLert Webhook] Notification failed : '' + error);' || chr(13) || chr(10) || '    throw ''iLert notification failed : '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__ilert_incident_url}','iLert incident','Please refer to https://docs.ilert.com/integrations/zabbix/native ' || chr(13) || chr(10) || '  ' || chr(13) || chr(10) || 'Set global macro {$ZABBIX.URL} with your Zabbix server URL.' || chr(13) || chr(10) || 'Add a dedicated user with the media type "iLert". You can also rewrite the incident summary via ".ILERT.INCIDENT.SUMMARY" parameter or leave it empty to use the standard pattern.','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('23','4','SolarWinds Service Desk','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('var SolarWinds = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        SolarWinds.params = params;' || chr(13) || chr(10) || '        SolarWinds.params.endpoint = ''https://api.samanage.com/'';' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setProxy: function (HTTPProxy) {' || chr(13) || chr(10) || '        SolarWinds.HTTPProxy = HTTPProxy;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    addCustomFields: function (data, fields) {' || chr(13) || chr(10) || '        if (typeof data.incident === ''object'' && typeof fields === ''object'' && Object.keys(fields).length) {' || chr(13) || chr(10) || '            if (typeof fields.sw_fields === ''object'' && Object.keys(fields.sw_fields).length) {' || chr(13) || chr(10) || '                Object.keys(fields.sw_fields)' || chr(13) || chr(10) || '                    .forEach(function(field) {' || chr(13) || chr(10) || '                        try {' || chr(13) || chr(10) || '                            data.incident[field] = JSON.parse(fields.sw_fields[field]);' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '                        catch (error) {' || chr(13) || chr(10) || '                            data.incident[field] = fields.sw_fields[field];' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '                    });' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (typeof fields.sw_customfields === ''object'' && Object.keys(fields.sw_customfields).length) {' || chr(13) || chr(10) || '')||
TO_NCLOB('                data.incident.custom_fields_values = {custom_fields_value: []};' || chr(13) || chr(10) || '                Object.keys(fields.sw_customfields)' || chr(13) || chr(10) || '                    .forEach(function(field) {' || chr(13) || chr(10) || '                        data.incident.custom_fields_values.custom_fields_value.push({' || chr(13) || chr(10) || '                            name: field,' || chr(13) || chr(10) || '                            value: fields.sw_customfields[field]' || chr(13) || chr(10) || '                        });' || chr(13) || chr(10) || '                    });' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return data;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (method, query, data) {' || chr(13) || chr(10) || '        [''token''].forEach(function (field) {' || chr(13) || chr(10) || '            if (typeof SolarWinds.params !== ''object'' || typeof SolarWinds.params[field] === ''undefined''' || chr(13) || chr(10) || '                || SolarWinds.params[field] === '''' ) {' || chr(13) || chr(10) || '                throw ''Required SolarWinds param is not set: "'' + field + ''".'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            url = SolarWinds.params.endpoint + query,' || chr(13) || chr(10) || '            request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '        request.addHeader(''X-Samanage-Authorization: Bearer '' + SolarWinds.params.token);' || chr(13) || chr(10) || '        request.addHeader(''Accept: application/vnd.samanage.v2.1+json'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof SolarWinds.HTTPProxy !== ''undefined'' && SolarWinds.HTTPProxy !== '''') {' || chr(13) || chr(10) || '')||
TO_NCLOB('            request.setProxy(SolarWinds.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ SolarWinds SD Webhook ] Sending request: '' + url + ((typeof data === ''string'')' || chr(13) || chr(10) || '            ? (''\n'' + data)' || chr(13) || chr(10) || '            : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (method) {' || chr(13) || chr(10) || '            case ''get'':' || chr(13) || chr(10) || '                response = request.get(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''post'':' || chr(13) || chr(10) || '                response = request.post(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''put'':' || chr(13) || chr(10) || '                response = request.put(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                throw ''Unsupported HTTP request method: '' + method;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ SolarWinds SD Webhook ] Received response with status code '' + request.getStatus() +' || chr(13) || chr(10) || '            ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '')||
TO_NCLOB('                Zabbix.log(4, ''[ SolarWinds SD Webhook ] Failed to parse response received from SolarWinds'');' || chr(13) || chr(10) || '                response = null;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() < 200 || request.getStatus() >= 300) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (response !== null && typeof response.error !== ''undefined''' || chr(13) || chr(10) || '                && Object.keys(response.error).length > 0) {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.error);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (response !== null && typeof response === ''object''' || chr(13) || chr(10) || '                && Object.keys(response).length > 0) {' || chr(13) || chr(10) || '                Object.keys(response)' || chr(13) || chr(10) || '                    .forEach(function(field) {' || chr(13) || chr(10) || '                        message += ''\n'' + field + '': '' + response[field][0];' || chr(13) || chr(10) || '                    });' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            throw message + '' Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return {' || chr(13) || chr(10) || '            status: request.getStatus(),' || chr(13) || chr(10) || '            response: response' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    createIncident: function(name, description, fields) {' || chr(13) || chr(10) || '        var data = {' || chr(13) || chr(10) || '            incident: {' || chr(13) || chr(10) || '')||
TO_NCLOB('                name: name,' || chr(13) || chr(10) || '                description: description,' || chr(13) || chr(10) || '                priority: SolarWinds.params.priority' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var result = SolarWinds.request(''post'', ''incidents.json'', SolarWinds.addCustomFields(data, fields));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof result.response !== ''object'' || typeof result.response.id === ''undefined'') {' || chr(13) || chr(10) || '            throw ''Cannot create SolarWinds incident. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return result.response.id;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    updateIncident: function(name, fields, message) {' || chr(13) || chr(10) || '        var data = {' || chr(13) || chr(10) || '            incident: {' || chr(13) || chr(10) || '                name: name,' || chr(13) || chr(10) || '                priority: SolarWinds.params.priority' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        SolarWinds.request(' || chr(13) || chr(10) || '            ''put'',' || chr(13) || chr(10) || '            ''incidents/'' + SolarWinds.params.incident_id + ''.json'',' || chr(13) || chr(10) || '            SolarWinds.addCustomFields(data, fields));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        SolarWinds.commenIncident(message);' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    commenIncident: function(message) {' || chr(13) || chr(10) || '        var data = {' || chr(13) || chr(10) || '            comment: {' || chr(13) || chr(10) || '                body: message' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '        SolarWinds.request(''post'', ''incidents/'' + SolarWinds.params.incident_id + ''/comments.json'', data);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        fields = {},' || chr(13) || chr(10) || '        samanage = {},' || chr(13) || chr(10) || '        result = {tags: {}},' || chr(13) || chr(10) || '        required_params = [''alert_subject'', ''event_recovery_value'', ''event_source'', ''event_value'', ''priority_default''],' || chr(13) || chr(10) || '        severities = [' || chr(13) || chr(10) || '            {name: ''not_classified''},' || chr(13) || chr(10) || '            {name: ''information''},' || chr(13) || chr(10) || '            {name: ''warning''},' || chr(13) || chr(10) || '            {name: ''average''},' || chr(13) || chr(10) || '            {name: ''high''},' || chr(13) || chr(10) || '            {name: ''disaster''},' || chr(13) || chr(10) || '            {name: ''resolved''},' || chr(13) || chr(10) || '            {name: ''default''}' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    fields.sw_fields = {};' || chr(13) || chr(10) || '    fields.sw_customfields = {};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (key.startsWith(''samanage_'')) {' || chr(13) || chr(10) || '                samanage[key.substring(9)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''sw_field_'')) {' || chr(13) || chr(10) || '                fields.sw_fields[key.substring(9)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''sw_customfield_'')) {' || chr(13) || chr(10) || '')||
TO_NCLOB('                fields.sw_customfields[key.substring(15)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (required_params.indexOf(key) !== -1 && params[key] === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" can\''t be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'' && params.event_source === ''0'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_recovery_value === ''0'') {' || chr(13) || chr(10) || '        throw ''Recovery operations are supported only for trigger-based actions.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {' || chr(13) || chr(10) || '        params.event_nseverity = ''7'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value === ''0'') {' || chr(13) || chr(10) || '        params.event_nseverity = ''6'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    samanage.priority = params[''priority_'' + severities[params.event_nseverity].name] || params.priority_default;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    SolarWinds.setParams(samanage);' || chr(13) || chr(10) || '    SolarWinds.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Create incident for non trigger-based events.' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_recovery_value !== ''0'') {' || chr(13) || chr(10) || '        SolarWinds.createIncident(params.alert_subject, params.alert_message);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Create incident for trigger-based events.' || chr(13) || chr(10) || '    else if (params.event_value === ''1'' && params.event_update_status === ''0''' || chr(13) || chr(10) || '            && samanage.incident_id === ''{EVENT.TAGS.__zbx_solarwinds_inc_id}'') {' || chr(13) || chr(10) || '        var key = SolarWinds.createIncident(params.alert_subject, params.alert_message, fields);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result.tags.__zbx_solarwinds_inc_id = key;' || chr(13) || chr(10) || '        result.tags.__zbx_solarwinds_inc_link = params.samanage_url +' || chr(13) || chr(10) || '            (params.samanage_url.endsWith(''/'') ? '''' : ''/'') + ''incidents/'' + key;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Update created incident for trigger-based event.' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        if (samanage.incident_id === ''{EVENT.TAGS.__zbx_solarwinds_inc_id}'' || samanage.incident_id === '''') {' || chr(13) || chr(10) || '')||
TO_NCLOB('            throw ''Incorrect incident key given: '' + samanage.incident_id;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        if (!params.alert_message) {' || chr(13) || chr(10) || '            throw ''Parameter "alert_message" can\''t be empty.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        SolarWinds.updateIncident(params.alert_subject, fields, params.alert_message);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source === ''0'') {' || chr(13) || chr(10) || '        return JSON.stringify(result);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        return ''OK'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ SolarWinds SD Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_solarwinds_inc_link}','SolarWinds incident ID: {EVENT.TAGS.__zbx_solarwinds_inc_id}','','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('24','4','SysAid','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('var SysAid = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        var required = [''url'', ''auth_user'', ''auth_password'', ''category_level_1'', ''category_level_2'',' || chr(13) || chr(10) || '            ''category_level_3'', ''incident_id'', ''template_id'', ''urgency_id'', ''incident_state'',' || chr(13) || chr(10) || '            ''default_priority_id''' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        required.forEach(function (field) {' || chr(13) || chr(10) || '            if (typeof params !== ''object'' || typeof params[field] === ''undefined'' || params[field] === '''') {' || chr(13) || chr(10) || '                throw ''Required param is not set: "'' + field + ''".'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        SysAid.params = params;' || chr(13) || chr(10) || '        if (typeof SysAid.params.url === ''string'' && !SysAid.params.url.endsWith(''/'')) {' || chr(13) || chr(10) || '            SysAid.params.url += ''/'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    login: function () {' || chr(13) || chr(10) || '        var result = SysAid.request(''post'', ''api/v1/login'', {' || chr(13) || chr(10) || '            user_name: SysAid.params.auth_user,' || chr(13) || chr(10) || '            password: SysAid.params.auth_password' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return result.response.user.id;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (method, query, data) {' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '')||
TO_NCLOB('            request = SysAid.req || (SysAid.req = new HttpRequest()),' || chr(13) || chr(10) || '            url = SysAid.params.url + query;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof SysAid.HTTPProxy !== ''undefined'' && SysAid.HTTPProxy.trim() !== '''') {' || chr(13) || chr(10) || '            request.setProxy(SysAid.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ SysAid Webhook ] Sending request: '' +' || chr(13) || chr(10) || '            url + ((typeof data === ''string'') ? ('' '' + data) : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (method) {' || chr(13) || chr(10) || '            case ''get'':' || chr(13) || chr(10) || '                response = request.get(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''post'':' || chr(13) || chr(10) || '                response = request.post(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''put'':' || chr(13) || chr(10) || '                response = request.put(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                throw ''Unsupported HTTP request method: '' + method;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ SysAid Webhook ] Received response with status code '' + request.getStatus() + '': '' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() !== 200) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '            message += '': '' + response;' || chr(13) || chr(10) || '            throw message + '' Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ SysAid Webhook ] Failed to parse response received from SysAid'');' || chr(13) || chr(10) || '                response = null;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response === null || (typeof response.Error !== ''undefined'' && Object.keys(response.Error).length > 0)) {' || chr(13) || chr(10) || '            throw ''Request failed: '' + JSON.stringify(response.Error);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return {' || chr(13) || chr(10) || '            status: request.getStatus(),' || chr(13) || chr(10) || '            response: response' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    createIncident: function(subject, message, priority) {' || chr(13) || chr(10) || '        var result = SysAid.request(''post'', ''api/v1/sr/?template='' + encodeURIComponent(SysAid.params.template_id), {' || chr(13) || chr(10) || '            info: [' || chr(13) || chr(10) || '                {' || chr(13) || chr(10) || '                    key: ''problem_type'',' || chr(13) || chr(10) || '                    value: [' || chr(13) || chr(10) || '                        SysAid.params.category_level_1,' || chr(13) || chr(10) || '                        SysAid.params.category_level_2,' || chr(13) || chr(10) || '')||
TO_NCLOB('                        SysAid.params.category_level_3' || chr(13) || chr(10) || '                    ].join(''_'')' || chr(13) || chr(10) || '                },' || chr(13) || chr(10) || '                {' || chr(13) || chr(10) || '                    key: ''title'',' || chr(13) || chr(10) || '                    value: subject' || chr(13) || chr(10) || '                },' || chr(13) || chr(10) || '                {' || chr(13) || chr(10) || '                    key: ''description'',' || chr(13) || chr(10) || '                    value: message' || chr(13) || chr(10) || '                },' || chr(13) || chr(10) || '                {' || chr(13) || chr(10) || '                    key: ''status'',' || chr(13) || chr(10) || '                    value: ''1''' || chr(13) || chr(10) || '                },' || chr(13) || chr(10) || '                {' || chr(13) || chr(10) || '                    key: ''urgency'',' || chr(13) || chr(10) || '                    value: SysAid.params.urgency_id' || chr(13) || chr(10) || '                },' || chr(13) || chr(10) || '                {' || chr(13) || chr(10) || '                    key: ''priority'',' || chr(13) || chr(10) || '                    value: priority || SysAid.params.default_priority_id,' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            ]' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (result.response.id === ''undefined'') {' || chr(13) || chr(10) || '            throw ''Cannot create SysAid incident. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return result.response.id;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    updateTicket: function(note) {' || chr(13) || chr(10) || '        var date = new Date().getTime();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('        SysAid.request(''put'', ''api/v1/sr/'' + encodeURIComponent(SysAid.params.incident_id), {' || chr(13) || chr(10) || '            id: SysAid.params.incident_id,' || chr(13) || chr(10) || '            info: [' || chr(13) || chr(10) || '                {' || chr(13) || chr(10) || '                    key: ''update_time'',' || chr(13) || chr(10) || '                    value: date' || chr(13) || chr(10) || '                },' || chr(13) || chr(10) || '                {' || chr(13) || chr(10) || '                    key: ''notes'',' || chr(13) || chr(10) || '                    value: [' || chr(13) || chr(10) || '                        {' || chr(13) || chr(10) || '                            userName: ''Zabbix'',' || chr(13) || chr(10) || '                            createDate: date,' || chr(13) || chr(10) || '                            text: note' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '                    ]' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            ]' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        params_sysaid = {},' || chr(13) || chr(10) || '        params_update = {},' || chr(13) || chr(10) || '        result = {tags: {}},' || chr(13) || chr(10) || '        required_params = [''alert_subject'', ''event_source'', ''event_value'',  ''event_update_status''],' || chr(13) || chr(10) || '        severities = [' || chr(13) || chr(10) || '            {name: ''not_classified'', color: ''#97AAB3''},' || chr(13) || chr(10) || '            {name: ''information'', color: ''#7499FF''},' || chr(13) || chr(10) || '            {name: ''warning'', color: ''#FFC859''},' || chr(13) || chr(10) || '            {name: ''average'', color: ''#FFA059''},' || chr(13) || chr(10) || '            {name: ''high'', color: ''#E97659''},' || chr(13) || chr(10) || '')||
TO_NCLOB('            {name: ''disaster'', color: ''#E45959''},' || chr(13) || chr(10) || '            {name: ''resolved'', color: ''#009900''},' || chr(13) || chr(10) || '            {name: null, color: ''#000000''}' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        priority;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (key.startsWith(''sysaid_'')) {' || chr(13) || chr(10) || '                params_sysaid[key.substring(7)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''event_update_'')) {' || chr(13) || chr(10) || '                params_update[key.substring(13)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (required_params.indexOf(key) !== -1 && params[key].trim() === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" cannot be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '')||
TO_NCLOB('    if (params.event_source === ''0'' && params.event_update_status !== ''0'' && params.event_update_status !== ''1'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_value === ''0'') {' || chr(13) || chr(10) || '        throw ''Recovery operations are supported only for trigger-based actions.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source === ''0'' && ((params.event_value === ''1'' && params.event_update_status === ''1'')' || chr(13) || chr(10) || '            || (params.event_value === ''0'' && (params.event_update_status === ''0'' || params.event_update_status === ''1'')))' || chr(13) || chr(10) || '            && (isNaN(parseInt(params.sysaid_incident_id)) || parseInt(params.sysaid_incident_id) < 1 )) {' || chr(13) || chr(10) || '        throw ''Incorrect "sysaid_incident_id" parameter given: '' + params.sysaid_incident_id + ''\nMust be positive integer.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {' || chr(13) || chr(10) || '        params.event_nseverity = ''7'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value === ''0'') {' || chr(13) || chr(10) || '        params.event_nseverity = ''6'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    priority = params[''severity_'' + severities[params.event_nseverity].name];' || chr(13) || chr(10) || '    priority = priority && priority.trim() || severities[7].name;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    SysAid.setParams(params_sysaid);' || chr(13) || chr(10) || '    SysAid.HTTPProxy = params.HTTPProxy;' || chr(13) || chr(10) || '')||
TO_NCLOB('    SysAid.login();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_value !== ''0'') {' || chr(13) || chr(10) || '        // Create ticket for non trigger-based events.' || chr(13) || chr(10) || '        SysAid.createIncident(params.alert_subject, params.alert_message, priority);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else if (params.event_value === ''1'' && params_update.status === ''0'') {' || chr(13) || chr(10) || '        // Create ticket for trigger-based events.' || chr(13) || chr(10) || '        var incident_id = SysAid.createIncident(params.alert_subject, params.alert_subject + ''\n'' + params.alert_message +' || chr(13) || chr(10) || '                ''\n'' + params.zabbix_url + (params.zabbix_url.endsWith(''/'') ? '''' : ''/'') + ''tr_events.php?triggerid='' +' || chr(13) || chr(10) || '                params.trigger_id + ''&eventid='' + params.event_id + ''\n'', priority' || chr(13) || chr(10) || '        );' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result.tags.__zbx_sysaid_incident_id = incident_id;' || chr(13) || chr(10) || '        result.tags.__zbx_sysaid_incidentlink = params.sysaid_url +' || chr(13) || chr(10) || '            (params.sysaid_url.endsWith(''/'') ? '''' : ''/'') + ''SREdit.jsp?id='' + incident_id + ''&fromId=IncidentsList'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        // Update created ticket for trigger-based event.' || chr(13) || chr(10) || '        SysAid.updateTicket(params.alert_subject + ''\n'' + params.alert_message);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return JSON.stringify(result);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ SysAid Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_sysaid_incidentlink}','SysAid: incident #{EVENT.TAGS.__zbx_sysaid_incident_id}','','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('25','4','TOPdesk','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('var Media = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '    name: '''',' || chr(13) || chr(10) || '    labels: [],' || chr(13) || chr(10) || '    HTTPProxy: '''',' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Media.params = params;' || chr(13) || chr(10) || '        Media.params.api += Media.params.api.endsWith(''/'') ? '''' : ''/'';' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setProxy: function (HTTPProxy) {' || chr(13) || chr(10) || '        if (typeof HTTPProxy !== ''undefined'' && HTTPProxy.trim() !== '''') {' || chr(13) || chr(10) || '            Media.HTTPProxy = HTTPProxy;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (method, query, data) {' || chr(13) || chr(10) || '        [''api'', ''token''].forEach(function (field) {' || chr(13) || chr(10) || '            if (typeof Media.params !== ''object'' || typeof Media.params[field] === ''undefined''' || chr(13) || chr(10) || '                    || Media.params[field] === '''') {' || chr(13) || chr(10) || '                throw ''Required '' + Media.name + '' param is not set: "'' + field + ''".'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            url = Media.params.api + query,' || chr(13) || chr(10) || '            request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '        request.addHeader(''Accept: application/json'');' || chr(13) || chr(10) || '')||
TO_NCLOB('        request.addHeader(''Authorization: '' + Media.params.token);' || chr(13) || chr(10) || '        request.setProxy(Media.HTTPProxy);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ '' + Media.name + '' Webhook ] Sending request: '' +' || chr(13) || chr(10) || '            url + ((typeof data === ''string'') ? (''\n'' + data) : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (method) {' || chr(13) || chr(10) || '            case ''get'':' || chr(13) || chr(10) || '                response = request.get(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''post'':' || chr(13) || chr(10) || '                response = request.post(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''put'':' || chr(13) || chr(10) || '                response = request.put(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                throw ''Unsupported HTTP request method: '' + method;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ '' + Media.name + '' Webhook ] Received response with status code '' +' || chr(13) || chr(10) || '            request.getStatus() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '')||
TO_NCLOB('                Zabbix.log(4, ''[ '' + Media.name + '' Webhook ] Failed to parse response.'');' || chr(13) || chr(10) || '                response = null;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() < 200 || request.getStatus() >= 300) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (response !== null) {' || chr(13) || chr(10) || '                if (typeof response.errors === ''object'' && Object.keys(response.errors).length > 0) {' || chr(13) || chr(10) || '                    message += '': '' + JSON.stringify(response.errors);' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '                else if (typeof response.errorMessages === ''object'' && Object.keys(response.errorMessages).length > 0) {' || chr(13) || chr(10) || '                    message += '': '' + JSON.stringify(response.errorMessages);' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '                else if (typeof response.message === ''string'') {' || chr(13) || chr(10) || '                    message += '': '' + response.message;' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            throw message + '' Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return {' || chr(13) || chr(10) || '            status: request.getStatus(),' || chr(13) || chr(10) || '            response: response' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var result = {tags: {}},' || chr(13) || chr(10) || '')||
TO_NCLOB('        params = JSON.parse(value),' || chr(13) || chr(10) || '        media = {},' || chr(13) || chr(10) || '        fields = {},' || chr(13) || chr(10) || '        resp = {},' || chr(13) || chr(10) || '        required_params = [' || chr(13) || chr(10) || '            ''alert_subject'',' || chr(13) || chr(10) || '            ''alert_message'',' || chr(13) || chr(10) || '            ''event_id'',' || chr(13) || chr(10) || '            ''event_source'',' || chr(13) || chr(10) || '            ''event_value'',' || chr(13) || chr(10) || '            ''event_update_status'',' || chr(13) || chr(10) || '            ''topdesk_api'',' || chr(13) || chr(10) || '            ''topdesk_user'',' || chr(13) || chr(10) || '            ''topdesk_password''' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        severities = [' || chr(13) || chr(10) || '            ''not_classified'',' || chr(13) || chr(10) || '            ''information'',' || chr(13) || chr(10) || '            ''warning'',' || chr(13) || chr(10) || '            ''average'',' || chr(13) || chr(10) || '            ''high'',' || chr(13) || chr(10) || '            ''disaster'',' || chr(13) || chr(10) || '            ''resolved'',' || chr(13) || chr(10) || '            ''default''' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        priority;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (required_params.indexOf(key) !== -1 && params[key].trim() === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" cannot be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            if (key.startsWith(''topdesk_'')) {' || chr(13) || chr(10) || '                media[key.substring(8)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Possible values of event_source:' || chr(13) || chr(10) || '')||
TO_NCLOB('    // 0 - Trigger, 1 - Discovery, 2 - Autoregistration, 3 - Internal.' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: "'' + params.event_source + ''".\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check event_value for trigger-based and internal events.' || chr(13) || chr(10) || '    // Possible values: 1 for problem, 0 for recovering' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check event_update_status only for trigger-based events.' || chr(13) || chr(10) || '    // Possible values: 0 - Webhook was called because of problem/recovery event, 1 - Update operation.' || chr(13) || chr(10) || '    if (params.event_source === ''0'' && params.event_update_status !== ''0'' && params.event_update_status !== ''1'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check event_id for a numeric value.' || chr(13) || chr(10) || '    if (isNaN(parseInt(params.event_id)) || params.event_id < 1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_id" parameter given: '' + params.event_id + ''\nMust be a positive number.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ((params.event_source === ''1'' || params.event_source === ''2'')  && params.event_value === ''0'') {' || chr(13) || chr(10) || '')||
TO_NCLOB('        throw ''Recovery operations are supported only for Trigger and Internal actions.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {' || chr(13) || chr(10) || '        params.event_nseverity = ''7'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value === ''0'') {' || chr(13) || chr(10) || '        params.event_nseverity = ''6'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    priority = params[''severity_'' + severities[params.event_nseverity]];' || chr(13) || chr(10) || '    params.zbxurl = params.zbxurl + (params.zbxurl.endsWith(''/'') ? '''' : ''/'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Media.name = ''TOPdesk'';' || chr(13) || chr(10) || '    Media.setParams(media);' || chr(13) || chr(10) || '    Media.params.token = ''Basic '' + btoa(Media.params.user + '':'' + Media.params.password);' || chr(13) || chr(10) || '    Media.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Create an issue.' || chr(13) || chr(10) || '    // Numeric value of the event that triggered an action (1 for problem, 0 for recovering).' || chr(13) || chr(10) || '    // Numeric value of the problem update status. Possible values:' || chr(13) || chr(10) || '    // 0 - Webhook was called because of problem/recovery event, 1 - Update operation.' || chr(13) || chr(10) || '    if ((params.event_source == 0 && params.event_value == 1 && params.event_update_status == 0)' || chr(13) || chr(10) || '            || (params.event_source == 3 && params.event_value == 1)' || chr(13) || chr(10) || '            || params.event_source == 1 || params.event_source == 2) {' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ '' + Media.name + '' Webhook ] Request of the ticket creating.'');' || chr(13) || chr(10) || '')||
TO_NCLOB('        fields.caller = {dynamicName: ''Zabbix''};' || chr(13) || chr(10) || '        fields.briefDescription = params.alert_subject;' || chr(13) || chr(10) || '        fields.request = params.alert_message.replace(/\n/g, ''<br>'');' || chr(13) || chr(10) || '        fields.priority = {name: priority};' || chr(13) || chr(10) || '        fields.processingStatus = {name: Media.params.status};' || chr(13) || chr(10) || '        fields.externalNumber = params.event_id;' || chr(13) || chr(10) || '        fields.request += ''<br>'' + params.zbxurl;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (params.event_source === ''0'') {' || chr(13) || chr(10) || '            fields.request += ''tr_events.php?triggerid='' + params.trigger_id + ''&eventid='' + params.event_id;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        resp = Media.request(''post'', ''tas/api/incidents'', fields);' || chr(13) || chr(10) || '        if (typeof resp.response !== ''object'' || typeof resp.response.id === ''undefined'') {' || chr(13) || chr(10) || '            throw ''Cannot create '' + Media.name + '' issue. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (params.event_source == 0 && params.event_value == 1 && params.event_update_status == 0) {' || chr(13) || chr(10) || '            result.tags.__zbx_tpd_issuekey = resp.response.number;' || chr(13) || chr(10) || '            result.tags.__zbx_tpd_issuelink = Media.params.api +' || chr(13) || chr(10) || '                ''tas/secure/incident?action=show&unid='' + resp.response.id;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Update a created issue.' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        if (params.event_source == 3 && params.event_value == 0) {' || chr(13) || chr(10) || '            throw ''Internal event recovery actions are not supported.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ '' + Media.name + '' Webhook ] Request of the ticket updating.'');' || chr(13) || chr(10) || '        fields.action = params.alert_message.replace(/\n/g, ''<br>'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        resp = Media.request(''put'', ''tas/api/incidents/number/'' + Media.params.issue_key, fields);' || chr(13) || chr(10) || '        if (typeof resp.response !== ''object'' || typeof resp.response.id === ''undefined''' || chr(13) || chr(10) || '                || resp.response.number !== Media.params.issue_key) {' || chr(13) || chr(10) || '            throw ''Cannot update '' + Media.name + '' issue. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return JSON.stringify(result);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ '' + Media.name + '' Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_tpd_issuelink}','TOPdesk: {EVENT.TAGS.__zbx_tpd_issuekey}','Please refer to https://developers.topdesk.com/documentation/index.html and https://www.zabbix.com/documentation/7.0/manual/config/notifications/media/webhook#example_scripts.' || chr(13) || chr(10) || '  ' || chr(13) || chr(10) || 'Set global macro {$ZABBIX.URL} with your Zabbix server URL.' || chr(13) || chr(10) || 'Add a dedicated user with the media type "TOPdesk".' || chr(13) || chr(10) || 'Change the values of the variables topdesk_api (URL), topdesk_password, topdesk_user. The topdesk_status is the default status for creating a new TOPdesk ticket.','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('26','4','iTop','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('var Itop = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (params.log !== ''private_log'' && params.log !== ''public_log'') {' || chr(13) || chr(10) || '            throw ''Incorrect "itop_log" parameter given: '' + params.log + ''\nMust be "private_log" or "public_log".'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Itop.params = params;' || chr(13) || chr(10) || '        if (typeof Itop.params.url === ''string'') {' || chr(13) || chr(10) || '            if (!Itop.params.url.endsWith(''/'')) {' || chr(13) || chr(10) || '                Itop.params.url += ''/'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            Itop.params.url += ''webservices/rest.php?version='' + encodeURIComponent(Itop.params.api_version);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setProxy: function (HTTPProxy) {' || chr(13) || chr(10) || '        Itop.HTTPProxy = HTTPProxy;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setCreatePayload: function () {' || chr(13) || chr(10) || '        json_data.operation = ''core/create'';' || chr(13) || chr(10) || '        json_data.fields.org_id = Itop.params.organization_id;' || chr(13) || chr(10) || '        json_data.fields.title = params.alert_subject;' || chr(13) || chr(10) || '        json_data.fields.description = params.alert_message.replace(''<'', ''&lt;'')' || chr(13) || chr(10) || '            .replace(''>'', ''&gt;'')' || chr(13) || chr(10) || '            .replace(/(?:\r\n|\r|\n)/g, ''<br>'');' || chr(13) || chr(10) || '')||
TO_NCLOB('    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setUpdatePayload: function () {' || chr(13) || chr(10) || '        json_data.operation = ''core/update'';' || chr(13) || chr(10) || '        json_data.key = Itop.params.id;' || chr(13) || chr(10) || '        json_data.fields.title = params.alert_subject;' || chr(13) || chr(10) || '        json_data.fields[Itop.params.log] = {' || chr(13) || chr(10) || '            add_item: {' || chr(13) || chr(10) || '                message: params.alert_subject + ''\n'' + params.alert_message,' || chr(13) || chr(10) || '                format: ''text''' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (data) {' || chr(13) || chr(10) || '        [''url'', ''user'', ''password'', ''organization_id'', ''class'', ''api_version'', ''id''].forEach(function (field) {' || chr(13) || chr(10) || '            if (typeof Itop.params !== ''object'' || typeof Itop.params[field] === ''undefined''' || chr(13) || chr(10) || '                    || Itop.params[field] === '''' ) {' || chr(13) || chr(10) || '                throw ''Required Itop param is not set: "itop_'' + field + ''".'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            url = Itop.params.url,' || chr(13) || chr(10) || '            request = new HttpRequest(),' || chr(13) || chr(10) || '            object;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: multipart/form-data'');' || chr(13) || chr(10) || '        request.addHeader(''Authorization: Basic '' + btoa(Itop.params.user + '':'' + Itop.params.password));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (Itop.HTTPProxy) {' || chr(13) || chr(10) || '            request.setProxy(Itop.HTTPProxy);' || chr(13) || chr(10) || '')||
TO_NCLOB('        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ iTop Webhook ] Sending request: '' + url + ''&json_data='' + data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        response = request.post(url + ''&json_data='' + encodeURIComponent(data));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ iTop Webhook ] Received response with status code '' + request.getStatus() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        try {' || chr(13) || chr(10) || '            response = JSON.parse(response);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        catch (error) {' || chr(13) || chr(10) || '            Zabbix.log(4, ''[ iTop Webhook ] Failed to parse response received from iTop'');' || chr(13) || chr(10) || '            throw ''Failed to parse response received from iTop.\nRequest status code '' +' || chr(13) || chr(10) || '                    request.getStatus() + ''. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() < 200 || request.getStatus() >= 300) {' || chr(13) || chr(10) || '            throw ''Request failed with status code '' + request.getStatus() + ''. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else if (typeof response.code !== ''undefined'' && response.code !== 0) {' || chr(13) || chr(10) || '            throw ''Request failed with iTop code '' + response.code + '': '' +' || chr(13) || chr(10) || '                    JSON.stringify(response.message) + ''. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '')||
TO_NCLOB('            Object.keys(response.objects)' || chr(13) || chr(10) || '                .forEach(function (key) {' || chr(13) || chr(10) || '                    object = response.objects[key];' || chr(13) || chr(10) || '                });' || chr(13) || chr(10) || '    ' || chr(13) || chr(10) || '            return {' || chr(13) || chr(10) || '                status: request.getStatus(),' || chr(13) || chr(10) || '                response: object.fields' || chr(13) || chr(10) || '            };' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        json_data = {},' || chr(13) || chr(10) || '        itop_params = {},' || chr(13) || chr(10) || '        result = {tags: {}},' || chr(13) || chr(10) || '        required_params = [' || chr(13) || chr(10) || '            ''alert_subject'', ''summary'', ''event_recovery_value'',' || chr(13) || chr(10) || '            ''event_source'', ''event_value'', ''action_name''' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (key.startsWith(''itop_'')) {' || chr(13) || chr(10) || '                itop_params[key.substring(5)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (required_params.indexOf(key) !== -1 && params[key] === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" can\''t be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '')||
TO_NCLOB('        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '            && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'' && params.event_source === ''0'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_recovery_value === ''0'') {' || chr(13) || chr(10) || '        throw ''Recovery operations are supported only for trigger-based actions.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Itop.setParams(itop_params);' || chr(13) || chr(10) || '    Itop.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    json_data.operation = '''';' || chr(13) || chr(10) || '    json_data.class = Itop.params.class;' || chr(13) || chr(10) || '    json_data.comment = Itop.params.comment;' || chr(13) || chr(10) || '    json_data.output_fields = ''id, friendlyname'';' || chr(13) || chr(10) || '    json_data.fields = {};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Create issue for non trigger-based events.' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_recovery_value !== ''0'') {' || chr(13) || chr(10) || '')||
TO_NCLOB('        Itop.setCreatePayload();' || chr(13) || chr(10) || '        Itop.request(json_data);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Create issue for trigger-based events.' || chr(13) || chr(10) || '    else if (params.event_value === ''1'' && params.event_update_status === ''0''' || chr(13) || chr(10) || '            && Itop.params.id === ''{EVENT.TAGS.__zbx_itop_id}'') {' || chr(13) || chr(10) || '        Itop.setCreatePayload();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response = Itop.request(json_data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result.tags.__zbx_itop_id = response.response.id;' || chr(13) || chr(10) || '        result.tags.__zbx_itop_key = response.response.friendlyname;' || chr(13) || chr(10) || '        result.tags.__zbx_itop_link = params.itop_url + (params.itop_url.endsWith(''/'') ? '''' : ''/'') +' || chr(13) || chr(10) || '                ''pages/UI.php?operation=details&class='' + encodeURIComponent(Itop.params.class) + ''&id='' +' || chr(13) || chr(10) || '                encodeURIComponent(response.response.id);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Update created issue for trigger-based event.' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        if (Itop.params.id === ''{EVENT.TAGS.__zbx_itop_id}'') {' || chr(13) || chr(10) || '            throw ''Incorrect iTop ticket ID given: '' + Itop.params.id;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        Itop.setUpdatePayload();' || chr(13) || chr(10) || '        Itop.request(json_data);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return JSON.stringify(result);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ iTop Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_itop_link}','iTop: {EVENT.TAGS.__zbx_itop_key}','','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('27','4','Rocket.Chat','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('var RocketChat = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        RocketChat.params = params;' || chr(13) || chr(10) || '        if (RocketChat.params.url && RocketChat.params.api_url) {' || chr(13) || chr(10) || '            if (!RocketChat.params.url.endsWith(''/'')) {' || chr(13) || chr(10) || '                RocketChat.params.url += ''/'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            if (!RocketChat.params.api_url.endsWith(''/'')) {' || chr(13) || chr(10) || '                RocketChat.params.api_url += ''/'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            if (RocketChat.params.api_url.startsWith(''/'')) {' || chr(13) || chr(10) || '                RocketChat.params.api_url = RocketChat.params.api_url.substring(1);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            RocketChat.params.url += RocketChat.params.api_url;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setProxy: function (HTTPProxy) {' || chr(13) || chr(10) || '        RocketChat.HTTPProxy = HTTPProxy;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    addFields: function (fields) {' || chr(13) || chr(10) || '        var data = [];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof fields === ''object'' && Object.keys(fields).length) {' || chr(13) || chr(10) || '            Object.keys(fields)' || chr(13) || chr(10) || '                .forEach(function(field) {' || chr(13) || chr(10) || '                    if (fields[field] === '''') {' || chr(13) || chr(10) || '')||
TO_NCLOB('                        Zabbix.log(4, ''[ RocketChat Webhook ] Field "'' + field +' || chr(13) || chr(10) || '                            ''" can\''t be empty. The field ignored.'');' || chr(13) || chr(10) || '                    }' || chr(13) || chr(10) || '                    else {' || chr(13) || chr(10) || '                        try {' || chr(13) || chr(10) || '                            var parts = field.split('':''),' || chr(13) || chr(10) || '                                prefix = parts[0].split(''_'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                            if (typeof prefix[2] === ''undefined''' || chr(13) || chr(10) || '                                    || (prefix[2] === ''p'' && params.event_value === ''1'')' || chr(13) || chr(10) || '                                    || (prefix[2] === ''r'' && params.event_value === ''0'')) {' || chr(13) || chr(10) || '                                data.push({' || chr(13) || chr(10) || '                                    title: field.substring(field.indexOf('':'') + 1),' || chr(13) || chr(10) || '                                    value: fields[field],' || chr(13) || chr(10) || '                                    short: prefix[1] === ''short''' || chr(13) || chr(10) || '                                });' || chr(13) || chr(10) || '                            }' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '                        catch (error) {' || chr(13) || chr(10) || '                            Zabbix.log(4, ''[ RocketChat Webhook ] Can\''t parse field "'' + field +' || chr(13) || chr(10) || '                                ''". The field ignored.'');' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '                    }' || chr(13) || chr(10) || '                });' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return data;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    request: function (method, query, data) {' || chr(13) || chr(10) || '        [''url'', ''api_url'', ''user_id'', ''user_token'', ''send_to''].forEach(function (field) {' || chr(13) || chr(10) || '            if (typeof RocketChat.params !== ''object'' || typeof RocketChat.params[field] === ''undefined''' || chr(13) || chr(10) || '                    || RocketChat.params[field] === '''' ) {' || chr(13) || chr(10) || '                throw ''Required parameter is not set: "'' + field + ''".'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            url = RocketChat.params.url + query,' || chr(13) || chr(10) || '            request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '        request.addHeader(''X-Auth-Token:'' + RocketChat.params.user_token);' || chr(13) || chr(10) || '        request.addHeader(''X-User-Id:'' + RocketChat.params.user_id);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof RocketChat.HTTPProxy !== ''undefined'' && RocketChat.HTTPProxy !== '''') {' || chr(13) || chr(10) || '            request.setProxy(RocketChat.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ RocketChat Webhook ] Sending request: '' + url +' || chr(13) || chr(10) || '            ((typeof data === ''string'') ? (''\n'' + data) : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (method) {' || chr(13) || chr(10) || '            case ''get'':' || chr(13) || chr(10) || '                response = request.get(url, data);' || chr(13) || chr(10) || '')||
TO_NCLOB('                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''post'':' || chr(13) || chr(10) || '                response = request.post(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                throw ''Unsupported HTTP request method: '' + method;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ RocketChat Webhook ] Received response with status code '' +' || chr(13) || chr(10) || '            request.getStatus() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ RocketChat Webhook ] Failed to parse response received from RocketChat'');' || chr(13) || chr(10) || '                response = null;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() < 200 || request.getStatus() >= 300) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (response !== null && typeof response.message !== ''undefined'') {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.message);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (response !== null && typeof response.error !== ''undefined'') {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.error);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '            throw message + ''. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return {' || chr(13) || chr(10) || '            status: request.getStatus(),' || chr(13) || chr(10) || '            response: response' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    postMessage: function(use_default_message, message, fields) {' || chr(13) || chr(10) || '        var data = {' || chr(13) || chr(10) || '            channel: RocketChat.params.send_to,' || chr(13) || chr(10) || '            attachments: [{' || chr(13) || chr(10) || '                collapsed: false,' || chr(13) || chr(10) || '                color: RocketChat.params.color,' || chr(13) || chr(10) || '                title: params.alert_subject' || chr(13) || chr(10) || '            }]' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (RocketChat.params.title_link) {' || chr(13) || chr(10) || '            data.attachments[0].title_link = RocketChat.params.title_link;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (use_default_message) {' || chr(13) || chr(10) || '            data.attachments[0].text = message;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            data.attachments[0].fields = RocketChat.addFields(fields);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var result = RocketChat.request(''post'', ''chat.postMessage'', data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof result.response !== ''object'' || typeof result.response.message._id === ''undefined'') {' || chr(13) || chr(10) || '            throw ''Cannot send RocketChat message. Check debug log for more information.'';' || chr(13) || chr(10) || '')||
TO_NCLOB('        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return {' || chr(13) || chr(10) || '            id: result.response.message._id,' || chr(13) || chr(10) || '            rid: result.response.message.rid,' || chr(13) || chr(10) || '            channel: result.response.channel' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    sendMessage: function(update, fields) {' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var data = {' || chr(13) || chr(10) || '            message: {' || chr(13) || chr(10) || '                rid: RocketChat.params.room_id,' || chr(13) || chr(10) || '                tmid: RocketChat.params.msg_id,' || chr(13) || chr(10) || '                tshow: true' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (update.status === ''0'') {' || chr(13) || chr(10) || '            data.message.attachments = [{' || chr(13) || chr(10) || '                collapsed: false,' || chr(13) || chr(10) || '                color: RocketChat.params.color,' || chr(13) || chr(10) || '                title: params.alert_subject,' || chr(13) || chr(10) || '                title_link: RocketChat.params.title_link,' || chr(13) || chr(10) || '                fields: RocketChat.addFields(fields)' || chr(13) || chr(10) || '            }];' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            data.message.alias = update.user;' || chr(13) || chr(10) || '            data.message.msg = update.action;' || chr(13) || chr(10) || '            if (update.message) {' || chr(13) || chr(10) || '                data.message.attachments = [{' || chr(13) || chr(10) || '                    color: RocketChat.params.color,' || chr(13) || chr(10) || '                    text: update.message' || chr(13) || chr(10) || '                }];' || chr(13) || chr(10) || '')||
TO_NCLOB('            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        RocketChat.request(''post'', ''chat.sendMessage'', data);' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    getMessageLink: function(rid, id) {' || chr(13) || chr(10) || '        var room = RocketChat.request(''get'', ''rooms.info?roomId='' + encodeURIComponent(rid)),' || chr(13) || chr(10) || '            link = params.rc_url +' || chr(13) || chr(10) || '                (params.rc_url.endsWith(''/'') ? '''' : ''/'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (room.response.room.t) {' || chr(13) || chr(10) || '            case ''c'':' || chr(13) || chr(10) || '                link += ''channel/'' + room.response.room.name + ''?msg='' + id;' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''p'':' || chr(13) || chr(10) || '                link += ''group/'' + room.response.room.name + ''?msg='' + id;' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''d'':' || chr(13) || chr(10) || '                link += ''direct/'' + rid + ''?msg='' + id;' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ RocketChat Webhook ] Can\''t get room type. Link to message will not be added.'');' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return link;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        response,' || chr(13) || chr(10) || '        fields = {},' || chr(13) || chr(10) || '        rc = {},' || chr(13) || chr(10) || '')||
TO_NCLOB('        update = {},' || chr(13) || chr(10) || '        result = {tags: {}},' || chr(13) || chr(10) || '        required_params = [''alert_subject'', ''alert_message'', ''event_source'', ''event_value''],' || chr(13) || chr(10) || '        severities = [' || chr(13) || chr(10) || '            {name: ''not_classified'', color: ''#97AAB3''},' || chr(13) || chr(10) || '            {name: ''information'', color: ''#7499FF''},' || chr(13) || chr(10) || '            {name: ''warning'', color: ''#FFC859''},' || chr(13) || chr(10) || '            {name: ''average'', color: ''#FFA059''},' || chr(13) || chr(10) || '            {name: ''high'', color: ''#E97659''},' || chr(13) || chr(10) || '            {name: ''disaster'', color: ''#E45959''},' || chr(13) || chr(10) || '            {name: ''resolved'', color: ''#009900''},' || chr(13) || chr(10) || '            {name: ''default'', color: ''#000000''}' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (key.startsWith(''rc_'')) {' || chr(13) || chr(10) || '                rc[key.substring(3)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''field_'')) {' || chr(13) || chr(10) || '                fields[key.substring(6)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''event_update_'')) {' || chr(13) || chr(10) || '                update[key.substring(13)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (required_params.indexOf(key) !== -1 && params[key] === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" can\''t be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Forcing parameters for non trigger-based events.' || chr(13) || chr(10) || '    if (params.event_source !== ''0'') {' || chr(13) || chr(10) || '        params.use_default_message = ''true'';' || chr(13) || chr(10) || '        params.event_nseverity = ''0'';' || chr(13) || chr(10) || '        params.rc_title_link = false;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '            && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'' && params.event_source === ''0'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {' || chr(13) || chr(10) || '        params.event_nseverity = ''7'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value === ''0'') {' || chr(13) || chr(10) || '        params.event_nseverity = ''6'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    RocketChat.setParams(rc);' || chr(13) || chr(10) || '    RocketChat.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    RocketChat.params.color = severities[params.event_nseverity].color;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Send default message if use_default_message === true.' || chr(13) || chr(10) || '    if (params.use_default_message.toLowerCase() === ''true'') {' || chr(13) || chr(10) || '        response = RocketChat.postMessage(true, params.alert_message);' || chr(13) || chr(10) || '        result.tags.__zbx_rc_id = response.id;' || chr(13) || chr(10) || '        result.tags.__zbx_rc_rid = response.rid;' || chr(13) || chr(10) || '        result.tags.__zbx_rc_msg_url = RocketChat.getMessageLink(response.rid, response.id);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Send message for trigger-based events.' || chr(13) || chr(10) || '    else if (params.event_value === ''1'' && update.status === ''0'') {' || chr(13) || chr(10) || '        response = RocketChat.postMessage(false, params.alert_message, fields);' || chr(13) || chr(10) || '        result.tags.__zbx_rc_id = response.id;' || chr(13) || chr(10) || '        result.tags.__zbx_rc_rid = response.rid;' || chr(13) || chr(10) || '        result.tags.__zbx_rc_msg_url = RocketChat.getMessageLink(response.rid, response.id);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Send thread message for trigger-based event.' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        RocketChat.sendMessage(update, fields);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return JSON.stringify(result);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ RocketChat Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_rc_msg_url}','Rocket.Chat','','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('28','4','VictorOps','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('var VictorOps = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        VictorOps.params = params;' || chr(13) || chr(10) || '        if (VictorOps.params.endpoint) {' || chr(13) || chr(10) || '            if (!VictorOps.params.endpoint.endsWith(''/'')) {' || chr(13) || chr(10) || '                VictorOps.params.endpoint += ''/'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (typeof VictorOps.params.routing_key !== ''undefined''' || chr(13) || chr(10) || '                    && VictorOps.params.routing_key !== ''{ALERT.SENDTO}''' || chr(13) || chr(10) || '                    && VictorOps.params.routing_key !== ''Default'') {' || chr(13) || chr(10) || '                VictorOps.params.endpoint += VictorOps.params.routing_key;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setProxy: function (HTTPProxy) {' || chr(13) || chr(10) || '        VictorOps.HTTPProxy = HTTPProxy;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    addFields: function (fields) {' || chr(13) || chr(10) || '        var data = {};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof fields === ''object'') {' || chr(13) || chr(10) || '            Object.keys(fields)' || chr(13) || chr(10) || '                .forEach(function(field) {' || chr(13) || chr(10) || '                    if (fields[field] === '''') {' || chr(13) || chr(10) || '                        Zabbix.log(4, ''[ VictorOps Webhook ] Field "'' + field +' || chr(13) || chr(10) || '')||
TO_NCLOB('                            ''" can\''t be empty. The field ignored.'');' || chr(13) || chr(10) || '                    }' || chr(13) || chr(10) || '                    else {' || chr(13) || chr(10) || '                        try {' || chr(13) || chr(10) || '                            var parts = field.split('':''),' || chr(13) || chr(10) || '                                prefix = parts[0].split(''_'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                            if (typeof prefix[1] === ''undefined''' || chr(13) || chr(10) || '                                    || (prefix[1] === ''p'' && params.event_value === ''1''' || chr(13) || chr(10) || '                                        && (params.event_update_status === ''0''' || chr(13) || chr(10) || '                                            || params.event_update_status === ''{EVENT.UPDATE.STATUS}''))' || chr(13) || chr(10) || '                                    || (prefix[1] === ''r'' && params.event_value === ''0''' || chr(13) || chr(10) || '                                        && (params.event_update_status === ''0''' || chr(13) || chr(10) || '                                            || params.event_update_status === ''{EVENT.UPDATE.STATUS}''))' || chr(13) || chr(10) || '                                    || (prefix[1] === ''u'' && params.event_update_status === ''1'')) {' || chr(13) || chr(10) || '                                data[field.substring(field.indexOf('':'') + 1)] = fields[field];' || chr(13) || chr(10) || '                            }' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '                        catch (error) {' || chr(13) || chr(10) || '                            Zabbix.log(4, ''[ VictorOps Webhook ] Can\''t parse field "'' + field +' || chr(13) || chr(10) || '                                ''". The field ignored.'');' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '                    }' || chr(13) || chr(10) || '                });' || chr(13) || chr(10) || '')||
TO_NCLOB('        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return data;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (data) {' || chr(13) || chr(10) || '        if (typeof VictorOps.params !== ''object'' || typeof VictorOps.params.endpoint === ''undefined''' || chr(13) || chr(10) || '                || VictorOps.params.endpoint === '''' ) {' || chr(13) || chr(10) || '            throw ''Required parameter is not set: "vops_endpoint".'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            url = VictorOps.params.endpoint,' || chr(13) || chr(10) || '            request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof VictorOps.HTTPProxy !== ''undefined'' && VictorOps.HTTPProxy !== '''') {' || chr(13) || chr(10) || '            request.setProxy(VictorOps.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ VictorOps Webhook ] Sending request: '' + url +' || chr(13) || chr(10) || '            ((typeof data === ''string'') ? (''\n'' + data) : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        response = request.post(url, data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ VictorOps Webhook ] Received response with status code '' +' || chr(13) || chr(10) || '            request.getStatus() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '')||
TO_NCLOB('                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ VictorOps Webhook ] Failed to parse response received from VictorOps'');' || chr(13) || chr(10) || '                response = null;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() < 200 || request.getStatus() >= 300) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (response !== null && typeof response.messages !== ''undefined'') {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.messages);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            throw message + ''. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return response;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        fields = {},' || chr(13) || chr(10) || '        vops = {},' || chr(13) || chr(10) || '        required_params = [''event_source'', ''event_value'', ''priority_update''],' || chr(13) || chr(10) || '        severities = [' || chr(13) || chr(10) || '            {name: ''not_classified'', color: ''#97AAB3''},' || chr(13) || chr(10) || '            {name: ''information'', color: ''#7499FF''},' || chr(13) || chr(10) || '            {name: ''warning'', color: ''#FFC859''},' || chr(13) || chr(10) || '            {name: ''average'', color: ''#FFA059''},' || chr(13) || chr(10) || '            {name: ''high'', color: ''#E97659''},' || chr(13) || chr(10) || '')||
TO_NCLOB('            {name: ''disaster'', color: ''#E45959''},' || chr(13) || chr(10) || '            {name: ''resolved'', color: ''#009900''},' || chr(13) || chr(10) || '            {name: ''default'', color: ''#000000''}' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (key.startsWith(''vops_'')) {' || chr(13) || chr(10) || '                vops[key.substring(5)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''field'')) {' || chr(13) || chr(10) || '                fields[key.substring(5)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (required_params.indexOf(key) !== -1 && params[key] === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" can\''t be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '            && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '')||
TO_NCLOB('    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'' && params.event_source === ''0'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {' || chr(13) || chr(10) || '        params.event_nseverity = ''7'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value === ''0'') {' || chr(13) || chr(10) || '        params.event_nseverity = ''6'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_update_status === ''1'') {' || chr(13) || chr(10) || '        fields['':message_type''] = params.priority_update;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        fields['':message_type''] = params[''priority_'' + severities[params.event_nseverity].name]' || chr(13) || chr(10) || '            || ''INFO'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_info && params.event_source === ''0'') {' || chr(13) || chr(10) || '        fields['':event_info''] = params.event_info;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    VictorOps.setParams(vops);' || chr(13) || chr(10) || '    VictorOps.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    VictorOps.request(VictorOps.addFields(fields));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return ''OK'';' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ VictorOps Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','0','0','','','','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('29','4','Brevis.one','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('var BrevisOne = {' || chr(13) || chr(10) || '    params: [],' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    addParam: function (name, value) {' || chr(13) || chr(10) || '        BrevisOne.params.push(name + ''='' + encodeURIComponent(value));' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setProxy: function (HTTPProxy) {' || chr(13) || chr(10) || '        BrevisOne.HTTPProxy = HTTPProxy;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setPayload: function (params) {' || chr(13) || chr(10) || '        var parts = params.send_to.split('':''),' || chr(13) || chr(10) || '            defaultValues = {' || chr(13) || chr(10) || '                ring: ''true'',' || chr(13) || chr(10) || '                flash: ''true'',' || chr(13) || chr(10) || '                telauto: ''false''' || chr(13) || chr(10) || '            };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        BrevisOne.addParam(''username'', params.username);' || chr(13) || chr(10) || '        BrevisOne.addParam(''password'', params.password);' || chr(13) || chr(10) || '        BrevisOne.addParam(''text'', params.text);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (parts.length > 1) {' || chr(13) || chr(10) || '            BrevisOne.addParam(''mode'', parts[0]);' || chr(13) || chr(10) || '            BrevisOne.addParam(''to'', parts[1]);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            BrevisOne.addParam(''to'', parts[0]);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Object.keys(defaultValues)' || chr(13) || chr(10) || '            .forEach(function (key) {' || chr(13) || chr(10) || '                if (params[key] && params[key].trim() && params[key].toLowerCase() === defaultValues[key]) {' || chr(13) || chr(10) || '')||
TO_NCLOB('                    BrevisOne.addParam(key, defaultValues[key]);' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            });' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function () {' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            request = new HttpRequest(),' || chr(13) || chr(10) || '            data = ''?'' + BrevisOne.params.join(''&'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: multipart/form-data'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof BrevisOne.HTTPProxy !== ''undefined'' && BrevisOne.HTTPProxy !== '''') {' || chr(13) || chr(10) || '            request.setProxy(BrevisOne.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ BrevisOne Webhook ] Sending request.'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        response = request.post(params.endpoint + data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ BrevisOne Webhook ] Received response with status code '' +' || chr(13) || chr(10) || '            request.getStatus() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() < 200 || request.getStatus() >= 300) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (response) {' || chr(13) || chr(10) || '                message += '': '' + response;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            throw message + ''. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value);' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '    [''endpoint'', ''password'', ''username'', ''text'', ''send_to''].forEach(function (field) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'' || typeof params[field] === ''undefined''' || chr(13) || chr(10) || '                || !params[field].trim()) {' || chr(13) || chr(10) || '            throw ''Required parameter is not set: "'' + field + ''".'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.send_to === ''{ALERT.SENDTO}'') {' || chr(13) || chr(10) || '        throw ''Required parameter is not set: "send_to".'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    BrevisOne.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    BrevisOne.setPayload(params);' || chr(13) || chr(10) || '    BrevisOne.request();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return ''OK'';' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ BrevisOne Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','0','0','','','','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('30','4','Express.ms','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('var Express = {' || chr(13) || chr(10) || '    params: [],' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Express.params = params;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof Express.params.url === ''string'' && !Express.params.url.endsWith(''/'')) {' || chr(13) || chr(10) || '            Express.params.url += ''/'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setProxy: function (HTTPProxy) {' || chr(13) || chr(10) || '        Express.HTTPProxy = HTTPProxy;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (query, data) {' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            url = Express.params.url + query,' || chr(13) || chr(10) || '            request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '        request.addHeader(''Authorization: Bearer '' + Express.params.token);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof Express.HTTPProxy !== ''undefined'' && Express.HTTPProxy !== '''') {' || chr(13) || chr(10) || '            request.setProxy(Express.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ Express Webhook ] Sending request: '' + url +' || chr(13) || chr(10) || '')||
TO_NCLOB('            ((typeof data === ''string'') ? (''\n'' + data) : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        response = request.post(url, data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ Express Webhook ] Received response with status code '' +' || chr(13) || chr(10) || '            request.getStatus() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ Express Webhook ] Failed to parse response received from Express'');' || chr(13) || chr(10) || '                response = {};' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response.status !== ''ok'') {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (typeof response.reason !== ''undefined'') {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.reason);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            throw message + ''. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return response.result;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    postMessage: function (is_problem) {' || chr(13) || chr(10) || '        var data,' || chr(13) || chr(10) || '            url,' || chr(13) || chr(10) || '            result = {tags: {}},' || chr(13) || chr(10) || '            response;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('        if (is_problem) {' || chr(13) || chr(10) || '            data = {' || chr(13) || chr(10) || '                group_chat_id: Express.params.send_to,' || chr(13) || chr(10) || '                notification: {' || chr(13) || chr(10) || '                    status: ''ok'',' || chr(13) || chr(10) || '                    body: Express.params.message' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            };' || chr(13) || chr(10) || '            url = ''api/v4/botx/notifications/direct'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            data = {' || chr(13) || chr(10) || '                reply: {' || chr(13) || chr(10) || '                    status: ''ok'',' || chr(13) || chr(10) || '                    body: Express.params.message' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            };' || chr(13) || chr(10) || '            url = ''api/v3/botx/events/reply_event'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                var tags = JSON.parse(Express.params.tags);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                throw ''Value of "express_tags" is not JSON. Value: '' + Express.params.tags + ''.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            tags.forEach(function(tag) {' || chr(13) || chr(10) || '                if (tag.tag === ''__zbx_ex_sync_id_'' + Express.params.send_to) {' || chr(13) || chr(10) || '                    data.source_sync_id = tag.value;' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (!data.source_sync_id) {' || chr(13) || chr(10) || '                throw ''Cannot update data. sync_id for the provided sender is unknown.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '')||
TO_NCLOB('        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        response = Express.request(url, data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (is_problem && response.sync_id) {' || chr(13) || chr(10) || '            result.tags[''__zbx_ex_sync_id_'' + Express.params.send_to] = response.sync_id;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            return JSON.stringify(result);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            return ''OK'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        express = {},' || chr(13) || chr(10) || '        required_params = [' || chr(13) || chr(10) || '            ''express_url'', ''express_send_to'', ''express_message'', ''express_tags'', ''express_token'',' || chr(13) || chr(10) || '            ''event_source'', ''event_value'', ''event_update_status''' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (key.startsWith(''express_'')) {' || chr(13) || chr(10) || '                express[key.substring(8)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (required_params.indexOf(key) !== -1' || chr(13) || chr(10) || '                    && (params[key].trim() === '''' || params[key] === ''{ALERT.SENDTO}'')) {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" can\''t be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Forcing event_value and event_update_status for non trigger-based events.' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' ) {' || chr(13) || chr(10) || '        params.event_value = ''1'';' || chr(13) || chr(10) || '        params.event_update_status = ''0'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'' && params.event_source === ''0'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Express.setParams(express);' || chr(13) || chr(10) || '    Express.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return Express.postMessage(params.event_value === ''1'' && params.event_update_status === ''0'');' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ Express Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','0','','','','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('31','4','ManageEngine ServiceDesk','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('var MEngine = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        MEngine.params = params;' || chr(13) || chr(10) || '        if (typeof MEngine.params.url === ''string'') {' || chr(13) || chr(10) || '            if (!MEngine.params.url.endsWith(''/'')) {' || chr(13) || chr(10) || '                MEngine.params.url += ''/'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            MEngine.params.url += ''api/v3/'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (MEngine.params.on_premise.toLowerCase() !== ''true''' || chr(13) || chr(10) || '                && typeof MEngine.params.on_demand_url_auth === ''string'') {' || chr(13) || chr(10) || '            if (!MEngine.params.on_demand_url_auth.endsWith(''/'')) {' || chr(13) || chr(10) || '                MEngine.params.on_demand_url_auth += ''/'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            MEngine.params.on_demand_url_auth += ''oauth/v2/token?'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setProxy: function (HTTPProxy) {' || chr(13) || chr(10) || '        MEngine.HTTPProxy = HTTPProxy;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    createLink: function (id, url) {' || chr(13) || chr(10) || '        return url + (url.endsWith(''/'') ? '''' : ''/'') +' || chr(13) || chr(10) || '            ((MEngine.params.on_premise.toLowerCase() === ''true'')' || chr(13) || chr(10) || '                ? (''WorkOrder.do?woMode=viewWO&woID='' + id)' || chr(13) || chr(10) || '')||
TO_NCLOB('                : (''app/itdesk/ui/requests/'' + id + ''/details'')' || chr(13) || chr(10) || '            );' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    refreshAccessToken: function () {' || chr(13) || chr(10) || '        [' || chr(13) || chr(10) || '            ''on_demand_url_auth'',' || chr(13) || chr(10) || '            ''on_demand_refresh_token'',' || chr(13) || chr(10) || '            ''on_demand_client_id'',' || chr(13) || chr(10) || '            ''on_demand_client_secret''' || chr(13) || chr(10) || '        ].forEach(function (field) {' || chr(13) || chr(10) || '            if (typeof MEngine.params !== ''object'' || typeof MEngine.params[field] === ''undefined''' || chr(13) || chr(10) || '                    || MEngine.params[field].trim() === '''' ) {' || chr(13) || chr(10) || '                throw ''Required MEngine param is not set: "sd_'' + field + ''".'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            request = new HttpRequest(),' || chr(13) || chr(10) || '            url = MEngine.params.on_demand_url_auth +' || chr(13) || chr(10) || '                ''refresh_token='' + encodeURIComponent(MEngine.params.on_demand_refresh_token) +' || chr(13) || chr(10) || '                ''&grant_type=refresh_token&client_id='' + encodeURIComponent(MEngine.params.on_demand_client_id) +' || chr(13) || chr(10) || '                ''&client_secret='' + encodeURIComponent(MEngine.params.on_demand_client_secret) +' || chr(13) || chr(10) || '                ''&redirect_uri=https://www.zoho.com&scope=SDPOnDemand.requests.ALL'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (MEngine.HTTPProxy) {' || chr(13) || chr(10) || '            request.setProxy(MEngine.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('        Zabbix.log(4, ''[ ManageEngine Webhook ] Refreshing access token. Request: '' + url);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        response = request.post(url);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ ManageEngine Webhook ] Received response with status code '' +' || chr(13) || chr(10) || '        request.getStatus() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        try {' || chr(13) || chr(10) || '            response = JSON.parse(response);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        catch (error) {' || chr(13) || chr(10) || '            Zabbix.log(4, ''[ ManageEngine Webhook ] Failed to parse response received from Zoho Accounts'');' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if ((request.getStatus() < 200 || request.getStatus() >= 300) && !response.access_token) {' || chr(13) || chr(10) || '            throw ''Access token refresh failed with HTTP status code '' + request.getStatus() +' || chr(13) || chr(10) || '                ''. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            MEngine.params.on_demand_auth_token = response.access_token;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (method, query, data) {' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            url = MEngine.params.url + query,' || chr(13) || chr(10) || '            input,' || chr(13) || chr(10) || '            request = new HttpRequest(),' || chr(13) || chr(10) || '            message;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (MEngine.params.on_premise.toLowerCase() === ''true'') {' || chr(13) || chr(10) || '            request.addHeader(''TECHNICIAN_KEY: '' + MEngine.params.on_premise_auth_token);' || chr(13) || chr(10) || '')||
TO_NCLOB('        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            request.addHeader(''Authorization: Zoho-oauthtoken '' + MEngine.params.on_demand_auth_token);' || chr(13) || chr(10) || '            request.addHeader(''Accept: application/v3+json'');' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (MEngine.HTTPProxy) {' || chr(13) || chr(10) || '            request.setProxy(MEngine.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        input = ''input_data='' + encodeURIComponent(data);' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ ManageEngine Webhook ] Sending request: '' + url + ''?'' + input);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (method) {' || chr(13) || chr(10) || '            case ''post'':' || chr(13) || chr(10) || '                response = request.post(url, input);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''put'':' || chr(13) || chr(10) || '                response = request.put(url, input);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                throw ''Unsupported HTTP request method: '' + method;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ ManageEngine Webhook ] Received response with status code '' +' || chr(13) || chr(10) || '            request.getStatus() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        try {' || chr(13) || chr(10) || '            response = JSON.parse(response);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '')||
TO_NCLOB('        catch (error) {' || chr(13) || chr(10) || '            Zabbix.log(4, ''[ ManageEngine Webhook ] Failed to parse response received from ManageEngine'');' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if ((request.getStatus() < 200 || request.getStatus() >= 300)' || chr(13) || chr(10) || '                && typeof response.response_status !== ''object'') {' || chr(13) || chr(10) || '            throw ''Request failed with HTTP status code '' + request.getStatus() +' || chr(13) || chr(10) || '                ''. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else if (typeof response.response_status === ''object'' && response.response_status.status === ''failed'') {' || chr(13) || chr(10) || '            message = ''Request failed with status_code '';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (typeof response.response_status.messages === ''object''' || chr(13) || chr(10) || '                    && response.response_status.messages[0]' || chr(13) || chr(10) || '                    && response.response_status.messages[0].message) {' || chr(13) || chr(10) || '                message += response.response_status.messages[0].status_code +' || chr(13) || chr(10) || '                    ''. Message: '' + response.response_status.messages[0].message;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else {' || chr(13) || chr(10) || '                message += response.response_status.status_code;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            message += ''. Check debug log for more information.'';' || chr(13) || chr(10) || '            throw message;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else if (response.request) {' || chr(13) || chr(10) || '            return response.request.id;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '')||
TO_NCLOB('    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    createPaylaod: function (fields, isNote) {' || chr(13) || chr(10) || '        var data = {},' || chr(13) || chr(10) || '            result;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (isNote) {' || chr(13) || chr(10) || '            data.description = fields[''field_string:description''].replace(/(?:\r\n|\r|\n)/g, ''<br>'');' || chr(13) || chr(10) || '            result = {request_note: data};' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            Object.keys(fields)' || chr(13) || chr(10) || '                .forEach(function(field) {' || chr(13) || chr(10) || '                    if (fields[field].trim() === '''') {' || chr(13) || chr(10) || '                        Zabbix.log(4, ''[ ManageEngine Webhook ] Field "'' + field +' || chr(13) || chr(10) || '                            ''" can\''t be empty. The field ignored.'');' || chr(13) || chr(10) || '                    }' || chr(13) || chr(10) || '                    else {' || chr(13) || chr(10) || '                        try {' || chr(13) || chr(10) || '                            var prefix = field.split('':'')[0],' || chr(13) || chr(10) || '                                root;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                            if  (prefix.startsWith(''udf_'') && !data.udf_fields) {' || chr(13) || chr(10) || '                                data.udf_fields = {};' || chr(13) || chr(10) || '                                root = data.udf_fields;' || chr(13) || chr(10) || '                            }' || chr(13) || chr(10) || '                            else if (prefix.startsWith(''udf_'')) {' || chr(13) || chr(10) || '                                root = data.udf_fields;' || chr(13) || chr(10) || '                            }' || chr(13) || chr(10) || '                            else {' || chr(13) || chr(10) || '')||
TO_NCLOB('                                root = data;' || chr(13) || chr(10) || '                            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                            if (prefix.endsWith(''string'')) {' || chr(13) || chr(10) || '                                root[field.substring(field.indexOf('':'') + 1)' || chr(13) || chr(10) || '                                    .toLowerCase()] = fields[field];' || chr(13) || chr(10) || '                            }' || chr(13) || chr(10) || '                            else {' || chr(13) || chr(10) || '                                root[field.substring(field.indexOf('':'') + 1)' || chr(13) || chr(10) || '                                    .toLowerCase()] = {' || chr(13) || chr(10) || '                                    name: fields[field]' || chr(13) || chr(10) || '                                };' || chr(13) || chr(10) || '                            }' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '                        catch (error) {' || chr(13) || chr(10) || '                            Zabbix.log(4, ''[ ManageEngine Webhook ] Can\''t parse field "'' + field +' || chr(13) || chr(10) || '                                ''". The field ignored.'');' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '                    }' || chr(13) || chr(10) || '                });' || chr(13) || chr(10) || '            if (data.description) {' || chr(13) || chr(10) || '                data.description = data.description.replace(/(?:\r\n|\r|\n)/g, ''<br>'');' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            result = {request: data};' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return result;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        fields = {},' || chr(13) || chr(10) || '')||
TO_NCLOB('        sd = {},' || chr(13) || chr(10) || '        result = {tags: {}},' || chr(13) || chr(10) || '        required_params = [' || chr(13) || chr(10) || '            ''sd_on_premise'', ''field_string:subject'', ''field_string:description'',' || chr(13) || chr(10) || '            ''event_recovery_value'', ''event_source'', ''event_value'', ''event_update_status''' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        severities = [' || chr(13) || chr(10) || '            {name: ''not_classified'', color: ''#97AAB3''},' || chr(13) || chr(10) || '            {name: ''information'', color: ''#7499FF''},' || chr(13) || chr(10) || '            {name: ''warning'', color: ''#FFC859''},' || chr(13) || chr(10) || '            {name: ''average'', color: ''#FFA059''},' || chr(13) || chr(10) || '            {name: ''high'', color: ''#E97659''},' || chr(13) || chr(10) || '            {name: ''disaster'', color: ''#E45959''},' || chr(13) || chr(10) || '            {name: ''default'', color: ''#000000''}' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (key.startsWith(''sd_'')) {' || chr(13) || chr(10) || '                sd[key.substring(3)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''field_'') || key.startsWith(''udf_field_'')) {' || chr(13) || chr(10) || '                fields[key] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (required_params.indexOf(key) !== -1 && params[key].trim() === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" can\''t be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'' && params.event_source === ''0'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_recovery_value === ''0'') {' || chr(13) || chr(10) || '        throw ''Recovery operations are supported only for trigger-based actions.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {' || chr(13) || chr(10) || '        params.event_nseverity = ''6'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_update_status === ''1'' && (typeof params.sd_request_id === ''undefined''' || chr(13) || chr(10) || '            || params.sd_request_id.trim() === ''''' || chr(13) || chr(10) || '            || params.sd_request_id === ''{EVENT.TAGS.__zbx_sd_request_id}'')) {' || chr(13) || chr(10) || '')||
TO_NCLOB('        throw ''Parameter "sd_request_id" can\''t be empty for update operation.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    MEngine.setParams(sd);' || chr(13) || chr(10) || '    MEngine.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (MEngine.params.on_premise.toLowerCase() !== ''true'') {' || chr(13) || chr(10) || '        MEngine.refreshAccessToken();' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Create issue for non trigger-based events.' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_recovery_value !== ''0'') {' || chr(13) || chr(10) || '        fields[''field_object:priority''] = params[''priority_'' + severities[params.event_nseverity].name]' || chr(13) || chr(10) || '        || ''Normal'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        MEngine.request(''post'', ''requests'', MEngine.createPaylaod(fields));' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Create issue for trigger-based events.' || chr(13) || chr(10) || '    else if (params.event_value === ''1'' && params.event_update_status === ''0'') {' || chr(13) || chr(10) || '        fields[''field_object:priority''] = params[''priority_'' + severities[params.event_nseverity].name]' || chr(13) || chr(10) || '        || ''Normal'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var id = MEngine.request(''post'', ''requests'', MEngine.createPaylaod(fields));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result.tags.__zbx_sd_request_id = id;' || chr(13) || chr(10) || '        result.tags.__zbx_sd_request_link = MEngine.createLink(id, params.sd_url);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Update created issue for trigger-based event.' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        if (params.event_update_status === ''1'') {' || chr(13) || chr(10) || '')||
TO_NCLOB('            MEngine.request(''post'', ''requests/'' + params.sd_request_id + ''/notes'',' || chr(13) || chr(10) || '                MEngine.createPaylaod(fields, true)' || chr(13) || chr(10) || '            );' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        delete fields[''field_string:description''];' || chr(13) || chr(10) || '        MEngine.request(''put'', ''requests/'' + params.sd_request_id, MEngine.createPaylaod(fields));' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return JSON.stringify(result);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ ManageEngine Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_sd_request_link}','ManageEngine: {EVENT.TAGS.__zbx_sd_request_id}','','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('32','4','Github','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('var Github = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        Github.params = params;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setProxy: function (HTTPProxy) {' || chr(13) || chr(10) || '        Github.HTTPProxy = HTTPProxy;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    urlCheckFormat: function (url) {' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof url === ''string'' && !url.endsWith(''/'')) {' || chr(13) || chr(10) || '            url += ''/'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (url.indexOf(''http://'') === -1 && url.indexOf(''https://'') === -1) {' || chr(13) || chr(10) || '            url = ''https://'' + url;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return url;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    createProblemURL: function (zabbix_url, triggerid, eventid, event_source) {' || chr(13) || chr(10) || '        var problem_url = zabbix_url;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (event_source === ''0'') {' || chr(13) || chr(10) || '            problem_url += ''tr_events.php?triggerid='' + triggerid + ''&eventid='' + eventid;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return problem_url;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (method, url, data) {' || chr(13) || chr(10) || '        [''token'', ''user_agent''].forEach(function (field) {' || chr(13) || chr(10) || '')||
TO_NCLOB('            if (typeof Github.params !== ''object'' || typeof Github.params[field] === ''undefined'' || Github.params[field] === '''') {' || chr(13) || chr(10) || '                throw ''Required Github param is not set: "'' + field + ''".'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''User-Agent: '' + Github.params.user_agent);' || chr(13) || chr(10) || '        request.addHeader(''Accept: application/vnd.github.v3+json'');' || chr(13) || chr(10) || '        request.addHeader(''Authorization: token '' + Github.params.token);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof Github.HTTPProxy !== ''undefined'' && Github.HTTPProxy !== '''') {' || chr(13) || chr(10) || '            request.setProxy(Github.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ Github Webhook ] Sending request: '' + url + ((typeof data === ''string'')' || chr(13) || chr(10) || '            ? (''\n'' + data)' || chr(13) || chr(10) || '            : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (method) {' || chr(13) || chr(10) || '            case ''post'':' || chr(13) || chr(10) || '                response = request.post(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''patch'':' || chr(13) || chr(10) || '                response = request.patch(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('            default:' || chr(13) || chr(10) || '                throw ''Unsupported HTTP request method: '' + method;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ Github Webhook ] Received response with status code '' +' || chr(13) || chr(10) || '            request.getStatus() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ Github Webhook ] Failed to parse response received from Github'');' || chr(13) || chr(10) || '                response = null;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof response !== ''object'') {' || chr(13) || chr(10) || '            throw ''Failed to process response received from Github. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() < 200 || request.getStatus() >= 300) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (response.message) {' || chr(13) || chr(10) || '                message += '': '' + response.message;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            throw message + '' Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return response;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '')||
TO_NCLOB('    var params = JSON.parse(value),' || chr(13) || chr(10) || '        github = {},' || chr(13) || chr(10) || '        url = '''',' || chr(13) || chr(10) || '        data = {},' || chr(13) || chr(10) || '        comment_data,' || chr(13) || chr(10) || '        result = { tags: {} },' || chr(13) || chr(10) || '        required_params = [' || chr(13) || chr(10) || '            ''alert_subject'', ''alert_message'', ''event_source'', ''event_value'',' || chr(13) || chr(10) || '            ''event_update_status'', ''event_recovery_value'', ''event_severity'',' || chr(13) || chr(10) || '            ''event_id'', ''trigger_id'', ''zabbix_url'',' || chr(13) || chr(10) || '            ''github_token'', ''github_url'', ''github_user_agent''' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        method = ''post'',' || chr(13) || chr(10) || '        process_tags = true;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (key.startsWith(''github_'')) {' || chr(13) || chr(10) || '                github[key.substring(7)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (required_params.indexOf(key) !== -1 && params[key] === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" can\''t be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '')||
TO_NCLOB('        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'' && params.event_source === ''0'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_recovery_value === ''0'') {' || chr(13) || chr(10) || '        throw ''Recovery operations are supported only for trigger-based actions.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.zabbix_url !== ''string'' || params.zabbix_url.trim() === '''' || params.zabbix_url === ''{$ZABBIX.URL}'') {' || chr(13) || chr(10) || '        throw ''Field "zabbix_url" cannot be empty.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check for backslash in the end of url and schema.' || chr(13) || chr(10) || '    github.url = Github.urlCheckFormat(github.url);' || chr(13) || chr(10) || '    params.zabbix_url = Github.urlCheckFormat(params.zabbix_url);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Default url for creating issue' || chr(13) || chr(10) || '    url = github.url + ''repos/'' + github.repo + ''/issues'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    data.title = params.alert_subject;' || chr(13) || chr(10) || '    data.body = params.alert_message;' || chr(13) || chr(10) || '    data.labels = [' || chr(13) || chr(10) || '        { name: "Zabbix" }' || chr(13) || chr(10) || '')||
TO_NCLOB('    ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Adding label corresponding to trigger severity in Zabbix.' || chr(13) || chr(10) || '    if (params.event_severity !== ''undefined'' && params.event_source === ''0'') {' || chr(13) || chr(10) || '        data.labels.push({ name: params.event_severity });' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // In case of update or resolve event.' || chr(13) || chr(10) || '    if (params.event_source === ''0'' && (params.event_value === ''0'' || params.event_update_status === ''1'')) {' || chr(13) || chr(10) || '        process_tags = false;' || chr(13) || chr(10) || '        method = ''patch'';' || chr(13) || chr(10) || '        url = github.url + ''repos/'' + github.repo + ''/issues/'' + github.issue_number;' || chr(13) || chr(10) || '        comment_data = Object.assign({}, data);' || chr(13) || chr(10) || '        delete data.body;' || chr(13) || chr(10) || '    } else {' || chr(13) || chr(10) || '        problem_url = Github.createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source);' || chr(13) || chr(10) || '        data.body += ''\nEvent details in Zabbix: ['' + problem_url + '']('' + problem_url + '')'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Github.setParams(github);' || chr(13) || chr(10) || '    Github.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var response = Github.request(method, url, data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Leave a comment if comment_data present.' || chr(13) || chr(10) || '    if (typeof comment_data === ''object'') {' || chr(13) || chr(10) || '        url = github.url + ''repos/'' + github.repo + ''/issues/'' + github.issue_number + ''/comments'';' || chr(13) || chr(10) || '        Github.request("post", url, comment_data);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    if (process_tags) {' || chr(13) || chr(10) || '        result.tags.__zbx_github_issue_number = response.number;' || chr(13) || chr(10) || '        result.tags.__zbx_github_repo = github.repo;' || chr(13) || chr(10) || '        result.tags.__zbx_github_link = response.html_url;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Zabbix.log(4, ''[ Github Webhook ] Result: '' + JSON.stringify(result));' || chr(13) || chr(10) || '    return JSON.stringify(result);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(4, ''[ Github Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_github_link}','Github: Issue {EVENT.TAGS.__zbx_github_issue_number}','','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('33','4','GLPi','','','','','','','','25','0','0','0','0','1','1','10s','1',TO_NCLOB('var GLPi = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        GLPi.params = params;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setProxy: function (HTTPProxy) {' || chr(13) || chr(10) || '        GLPi.HTTPProxy = HTTPProxy;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    urlCheckFormat: function (url) {' || chr(13) || chr(10) || '        if (typeof url === ''string'' && !url.endsWith(''/'')) {' || chr(13) || chr(10) || '            url += ''/'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (url.indexOf(''http://'') === -1 && url.indexOf(''https://'') === -1) {' || chr(13) || chr(10) || '            url = ''https://'' + url;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return url;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    getAuthToken: function (url, token) {' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '        request.addHeader(''Authorization: user_token '' + token);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        response = request.get(url + "apirest.php/initSession");' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '')||
TO_NCLOB('            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ GLPi Webhook ] Failed to receive authentication token from GLPi.'');' || chr(13) || chr(10) || '                response = null;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (Array.isArray(response)) {' || chr(13) || chr(10) || '            if (response[1]) {' || chr(13) || chr(10) || '                throw ''Error received from GLPi: '' + response[1];' || chr(13) || chr(10) || '            } else {' || chr(13) || chr(10) || '                throw ''Failed to receive authentication token from GLPi.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof response !== ''object'' || !response.session_token) {' || chr(13) || chr(10) || '            throw ''Failed to process response received from getting GLPi authentication token. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return response.session_token;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    getProblemUrl: function (zabbix_url, triggerid, eventid, event_source) {' || chr(13) || chr(10) || '        var problem_url = zabbix_url;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (event_source === ''0'') {' || chr(13) || chr(10) || '            problem_url += ''tr_events.php?triggerid='' + triggerid + ''&eventid='' + eventid;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return problem_url;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (method, url, data) {' || chr(13) || chr(10) || '')||
TO_NCLOB('        if (typeof GLPi.params !== ''object'' || typeof GLPi.params.authToken === ''undefined'' || GLPi.params.authToken === '''') {' || chr(13) || chr(10) || '            throw ''Required GLPi param authToken is not set.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '        request.addHeader(''Session-Token:'' + GLPi.params.authToken);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof GLPi.HTTPProxy !== ''undefined'' && GLPi.HTTPProxy !== '''') {' || chr(13) || chr(10) || '            request.setProxy(GLPi.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ GLPi Webhook ] Sending request: '' + url + ((typeof data === ''string'')' || chr(13) || chr(10) || '            ? (''\n'' + data)' || chr(13) || chr(10) || '            : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (method) {' || chr(13) || chr(10) || '            case ''post'':' || chr(13) || chr(10) || '                response = request.post(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''put'':' || chr(13) || chr(10) || '                response = request.put(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                throw ''Unsupported HTTP request method: '' + method;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ GLPi Webhook ] Received response with status code '' +' || chr(13) || chr(10) || '')||
TO_NCLOB('            request.getStatus() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ GLPi Webhook ] Failed to parse response received from GLPi'');' || chr(13) || chr(10) || '                response = null;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof response !== ''object'' || typeof response === ''undefined'' || response === null) {' || chr(13) || chr(10) || '            throw ''Failed to process response received from GLPi. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() < 200 || request.getStatus() >= 300) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (response.message) {' || chr(13) || chr(10) || '                message += '': '' + response.message;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            throw message + '' Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return response;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        glpi = {},' || chr(13) || chr(10) || '        url = '''',' || chr(13) || chr(10) || '        data = {},' || chr(13) || chr(10) || '        comment_data,' || chr(13) || chr(10) || '')||
TO_NCLOB('        result = { tags: {} },' || chr(13) || chr(10) || '        required_params = [' || chr(13) || chr(10) || '            ''alert_subject'', ''alert_message'', ''event_source'', ''event_value'',' || chr(13) || chr(10) || '            ''event_update_status'', ''event_recovery_value'',' || chr(13) || chr(10) || '            ''event_id'', ''trigger_id'', ''zabbix_url'',' || chr(13) || chr(10) || '            ''glpi_token'', ''glpi_url''' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        method = ''post'',' || chr(13) || chr(10) || '        process_tags = true,' || chr(13) || chr(10) || '        response;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (key.startsWith(''glpi_'')) {' || chr(13) || chr(10) || '                glpi[key.substring(5)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (required_params.indexOf(key) !== -1 && params[key] === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" can\''t be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '')||
TO_NCLOB('    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'' && params.event_source === ''0'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_recovery_value === ''0'') {' || chr(13) || chr(10) || '        throw ''Recovery operations are supported only for trigger-based actions.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.zabbix_url !== ''string'' || params.zabbix_url.trim() === '''' || params.zabbix_url === ''{$ZABBIX.URL}'') {' || chr(13) || chr(10) || '        throw ''Field "zabbix_url" cannot be empty.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check for backslash in the end of url and schema.' || chr(13) || chr(10) || '    glpi.url = GLPi.urlCheckFormat(glpi.url);' || chr(13) || chr(10) || '    params.zabbix_url = GLPi.urlCheckFormat(params.zabbix_url);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    glpi.authToken = GLPi.getAuthToken(glpi.url, glpi.token);' || chr(13) || chr(10) || '    GLPi.setParams(glpi);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    data = {' || chr(13) || chr(10) || '        ''input'': {' || chr(13) || chr(10) || '            ''name'': params.alert_subject,' || chr(13) || chr(10) || '            ''content'': params.alert_message + ''\n<a href='' + GLPi.getProblemUrl(params.zabbix_url, params.trigger_id, params.event_id, params.event_source) + ''>Link to problem in Zabbix</a>'',' || chr(13) || chr(10) || '            ''status'': 1,  // Set status "New"' || chr(13) || chr(10) || '            ''urgency'': params.event_nseverity' || chr(13) || chr(10) || '')||
TO_NCLOB('        }' || chr(13) || chr(10) || '    };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // In case of resolve' || chr(13) || chr(10) || '    if (params.event_source === ''0'' && params.event_value === ''0'') {' || chr(13) || chr(10) || '        process_tags = false;' || chr(13) || chr(10) || '        dataFollowup = {' || chr(13) || chr(10) || '            ''input'': {' || chr(13) || chr(10) || '                ''items_id'': glpi.problem_id,' || chr(13) || chr(10) || '                ''itemtype'': ''Problem'',' || chr(13) || chr(10) || '                ''content'': params.alert_message + ''\n<a href='' + GLPi.getProblemUrl(params.zabbix_url, params.trigger_id, params.event_id, params.event_source) + ''>Link to problem in Zabbix</a>''' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '        dataProblem = {' || chr(13) || chr(10) || '            ''id'': glpi.problem_id,' || chr(13) || chr(10) || '            ''input'': {' || chr(13) || chr(10) || '                ''name'': params.alert_subject,' || chr(13) || chr(10) || '                ''status'': 5,  // Set status "Solved"' || chr(13) || chr(10) || '                ''urgency'': params.event_nseverity' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        GLPi.request(''put'', glpi.url + ''apirest.php/Problem/'' + glpi.problem_id, dataProblem);' || chr(13) || chr(10) || '        GLPi.request(''post'', glpi.url + ''apirest.php/Problem/'' + glpi.problem_id + ''/ITILFollowup'', dataFollowup);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // In case of update' || chr(13) || chr(10) || '    else if (params.event_source === ''0'' && params.event_update_status === ''1'') {' || chr(13) || chr(10) || '        process_tags = false;' || chr(13) || chr(10) || '        dataFollowup = {' || chr(13) || chr(10) || '            ''input'': {' || chr(13) || chr(10) || '')||
TO_NCLOB('                ''items_id'': glpi.problem_id,' || chr(13) || chr(10) || '                ''itemtype'': ''Problem'',' || chr(13) || chr(10) || '                ''content'': params.alert_message + ''\n<a href='' + GLPi.getProblemUrl(params.zabbix_url, params.trigger_id, params.event_id, params.event_source) + ''>Link to problem in Zabbix</a>''' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '        dataProblem = {' || chr(13) || chr(10) || '            ''id'': glpi.problem_id,' || chr(13) || chr(10) || '            ''input'': {' || chr(13) || chr(10) || '                ''name'': params.alert_subject,' || chr(13) || chr(10) || '                ''urgency'': params.event_nseverity' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        GLPi.request(''put'', glpi.url + ''apirest.php/Problem/'' + glpi.problem_id, dataProblem);' || chr(13) || chr(10) || '        GLPi.request(''post'', glpi.url + ''apirest.php/Problem/'' + glpi.problem_id + ''/ITILFollowup'', dataFollowup);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // In case of problem' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        response = GLPi.request(''post'', glpi.url + ''apirest.php/Problem/'', data);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (process_tags) {' || chr(13) || chr(10) || '        result.tags.__zbx_glpi_problem_id = response.id;' || chr(13) || chr(10) || '        result.tags.__zbx_glpi_link = glpi.url + ''front/problem.form.php?id='' + response.id;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Zabbix.log(4, ''[ GLPi Webhook ] Result: '' + JSON.stringify(result));' || chr(13) || chr(10) || '    return JSON.stringify(result);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '')||
TO_NCLOB('    Zabbix.log(4, ''[ GLPi Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_glpi_link}','GLPi: Problem {EVENT.TAGS.__zbx_glpi_problem_id}','','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('34','0','Gmail','smtp.gmail.com','example.com','zabbix@example.com','','','','','587','1','0','0','1','1','3','10s','1','','30s','0','0','','','','1')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('35','0','Gmail relay','smtp-relay.gmail.com','example.com','zabbix@example.com','','','','','587','1','0','0','0','1','3','10s','1','','30s','0','0','','','','2')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('36','0','Office365','smtp.office365.com','example.com','zabbix@example.com','','','','','587','1','0','0','1','1','3','10s','1','','30s','0','0','','','','3')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('37','0','Office365 relay','example-com.mail.protection.outlook.com','example.com','zabbix@example.com','','','','','25','1','0','0','0','1','3','10s','1','','30s','0','0','','','','4')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('38','4','Line','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('function sendMessage(to, messages, params) {' || chr(13) || chr(10) || '    var response,' || chr(13) || chr(10) || '        request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.HTTPProxy === ''string'' && params.HTTPProxy.trim() !== '''') {' || chr(13) || chr(10) || '        request.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '    request.addHeader(''Authorization: Bearer '' + params.bot_token);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    response = request.post(''https://api.line.me/v2/bot/message/push'', JSON.stringify({' || chr(13) || chr(10) || '        "to": to,' || chr(13) || chr(10) || '        "messages": messages' || chr(13) || chr(10) || '    }));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (request.getStatus() !== 200) {' || chr(13) || chr(10) || '        throw response;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function validateParams(params) {' || chr(13) || chr(10) || '    if (typeof params.bot_token !== ''string'' || params.bot_token.trim() === '''') {' || chr(13) || chr(10) || '        throw ''Field "bot_token" cannot be empty'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: "'' + params.event_source + ''".\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'') {' || chr(13) || chr(10) || '        params.event_nseverity = ''0'';' || chr(13) || chr(10) || '        params.event_severity = ''Not classified'';' || chr(13) || chr(10) || '        params.event_update_status = ''0'';' || chr(13) || chr(10) || '')||
TO_NCLOB('    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source === ''1'' || params.event_source === ''2'') {' || chr(13) || chr(10) || '        params.event_value = ''1'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_nseverity" parameter given: '' + params.event_nseverity + ''\nMust be 0-5.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (isNaN(params.trigger_id) && params.event_source === ''0'') {' || chr(13) || chr(10) || '        throw ''field "trigger_id" is not a number'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.zabbix_url !== ''string'' || params.zabbix_url.trim() === '''') {' || chr(13) || chr(10) || '        throw ''Field "zabbix_url" cannot be empty'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (!/^(http|https):\/\/.+/.test(params.zabbix_url)) {' || chr(13) || chr(10) || '        throw ''Field "zabbix_url" must contain a schema'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function getZabbixProblemLink(params) {' || chr(13) || chr(10) || '')||
TO_NCLOB('    return params.zabbix_url + (params.zabbix_url.endsWith(''/'') ? '''' : ''/'') + ''tr_events.php?triggerid='' + params.trigger_id + ''&eventid='' + params.event_id;    ' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    validateParams(params);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    severity_emoji = [' || chr(13) || chr(10) || '        "\u26AA",' || chr(13) || chr(10) || '        "\uD83D\uDD35",' || chr(13) || chr(10) || '        "\uD83D\uDFE4",' || chr(13) || chr(10) || '        "\uD83D\uDFE1",' || chr(13) || chr(10) || '        "\uD83D\uDFE0",' || chr(13) || chr(10) || '        "\uD83D\uDD34",' || chr(13) || chr(10) || '    ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // If its a trigger and a recovery operation and not an update operation.' || chr(13) || chr(10) || '    if (params.event_source === ''0'' && params.event_value === ''0'' && params.event_update_status === ''0'') {' || chr(13) || chr(10) || '        var line_message = [' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                "type": "text",' || chr(13) || chr(10) || '                "text": ''\u2705 '' + params.alert_subject + ''\n\n'' + params.alert_message + ''\n'' + params.trigger_description + ''\n\n'' + getZabbixProblemLink(params)' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // If its a trigger and its a problem.' || chr(13) || chr(10) || '    else if (params.event_source === ''0'' && params.event_value === ''1'') {' || chr(13) || chr(10) || '        var line_message = [' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                "type": "text",' || chr(13) || chr(10) || '')||
TO_NCLOB('                "text": severity_emoji[params.event_nseverity] + '' '' + params.alert_subject + ''\n\n'' + params.alert_message + ''\n'' + params.trigger_description + ''\n\n'' + getZabbixProblemLink(params)' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // If its a trigger and its an update operation.' || chr(13) || chr(10) || '    else if (params.event_source === ''0'' && params.event_update_status === ''1'') {' || chr(13) || chr(10) || '        var line_message = [' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                "type": "text",' || chr(13) || chr(10) || '                "text": ''\u2733 '' + severity_emoji[params.event_nseverity] + '' '' + params.alert_subject + ''\n\n'' + params.alert_message + ''\n'' + params.trigger_description + ''\n\n'' + getZabbixProblemLink(params)' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        var line_message = [' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                "type": "text",' || chr(13) || chr(10) || '                "text": params.alert_subject + ''\n\n'' + params.alert_message + ''\n''' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    sendMessage(params.send_to, line_message, params);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return ''OK'';' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (err) {' || chr(13) || chr(10) || '    Zabbix.log(4, ''[ Line Webhook ] Line notification failed : '' + err);' || chr(13) || chr(10) || '    throw ''Line notification failed : '' + err;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','0','0','','','Please refer to setup guide here: https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/line' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Set bot_token parameter to your Line bot token.' || chr(13) || chr(10) || 'When assigning Line media to the Zabbix user - add the ID of the target recipient. Use a userId, groupId, or roomId value.','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('39','4','OTRS CE','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('var OTRS = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '    entrypoint: ''nph-genericinterface.pl/Webservice/ZabbixTicketConnector/Ticket'',' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        OTRS.params = params;' || chr(13) || chr(10) || '        if (typeof OTRS.params.url === ''string'') {' || chr(13) || chr(10) || '            if (!OTRS.params.url.endsWith(''/'')) {' || chr(13) || chr(10) || '                OTRS.params.url += ''/'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    addDynamicFields: function (data, fields) {' || chr(13) || chr(10) || '        if (typeof fields === ''object'' && Object.keys(fields).length) {' || chr(13) || chr(10) || '            data.DynamicField = [];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            Object.keys(fields)' || chr(13) || chr(10) || '                .forEach(function(field) {' || chr(13) || chr(10) || '                    if (field !== undefined) {' || chr(13) || chr(10) || '                        if (fields[field].match(/^\d{4}[.-]\d{2}[.-]\d{2}$/)) {' || chr(13) || chr(10) || '                            fields[field] = fields[field].replace(/\./g, ''-'');' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                        data.DynamicField.push({Name: field, Value: fields[field]});' || chr(13) || chr(10) || '                    }' || chr(13) || chr(10) || '                });' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return data;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    request: function (method, query, data) {' || chr(13) || chr(10) || '        [''url'', ''auth_user'', ''auth_password'', ''queue'',' || chr(13) || chr(10) || '            ''customer'', ''ticket_state'', ''default_priority_id'', ''time_unit''].forEach(function (field) {' || chr(13) || chr(10) || '            if (typeof OTRS.params !== ''object'' || typeof OTRS.params[field] === ''undefined''' || chr(13) || chr(10) || '                || OTRS.params[field] === '''' ) {' || chr(13) || chr(10) || '                throw ''Required param is not set: "'' + field + ''".'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            request = new HttpRequest(),' || chr(13) || chr(10) || '            url = OTRS.params.url + query +' || chr(13) || chr(10) || '                ''?UserLogin='' + encodeURIComponent(OTRS.params.auth_user) +' || chr(13) || chr(10) || '                ''&Password='' + encodeURIComponent(OTRS.params.auth_password);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof OTRS.HTTPProxy !== ''undefined'' && OTRS.HTTPProxy.trim() !== '''') {' || chr(13) || chr(10) || '            request.setProxy(OTRS.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ OTRS Webhook ] Sending request: '' +' || chr(13) || chr(10) || '            url + ((typeof data === ''string'') ? ('' '' + data) : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (method) {' || chr(13) || chr(10) || '            case ''get'':' || chr(13) || chr(10) || '')||
TO_NCLOB('                response = request.get(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''post'':' || chr(13) || chr(10) || '                response = request.post(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''put'':' || chr(13) || chr(10) || '                response = request.put(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                throw ''Unsupported HTTP request method: '' + method;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ ((OTRS)) CE Webhook ] Received response with status code '' + request.getStatus() + '': '' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() < 200 || request.getStatus() >= 300) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            message += '': '' + response;' || chr(13) || chr(10) || '            throw message + '' Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ ((OTRS)) CE Webhook ] Failed to parse response received from ((OTRS)) CE'');' || chr(13) || chr(10) || '                response = null;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('        if (typeof response.Error !== ''undefined''' || chr(13) || chr(10) || '            && Object.keys(response.Error).length > 0) {' || chr(13) || chr(10) || '            message = ''Request failed: '' + JSON.stringify(response.Error);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return {' || chr(13) || chr(10) || '            status: request.getStatus(),' || chr(13) || chr(10) || '            response: response' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    createTicket: function(subject, message, priority, fields) {' || chr(13) || chr(10) || '        var result,' || chr(13) || chr(10) || '            data = {' || chr(13) || chr(10) || '                Ticket: {' || chr(13) || chr(10) || '                    Title: subject,' || chr(13) || chr(10) || '                    Queue: OTRS.params.queue,' || chr(13) || chr(10) || '                    State: OTRS.params.ticket_state,' || chr(13) || chr(10) || '                    PriorityID: priority || OTRS.params.default_priority_id,' || chr(13) || chr(10) || '                    CustomerUser: OTRS.params.customer' || chr(13) || chr(10) || '                },' || chr(13) || chr(10) || '                Article: {' || chr(13) || chr(10) || '                    Subject: subject,' || chr(13) || chr(10) || '                    Body: message,' || chr(13) || chr(10) || '                    TimeUnit: OTRS.params.time_unit,' || chr(13) || chr(10) || '                    ContentType: ''text/plain; charset=utf8''' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result = OTRS.request(''post'', OTRS.entrypoint, OTRS.addDynamicFields(data, fields));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof result.response !== ''object''' || chr(13) || chr(10) || '')||
TO_NCLOB('            || typeof result.response.TicketID === ''undefined''' || chr(13) || chr(10) || '            || result.status != 200) {' || chr(13) || chr(10) || '            throw ''Cannot create ((OTRS)) CE ticket. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return result.response.TicketID;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    updateTicket: function(subject, message) {' || chr(13) || chr(10) || '        var result,' || chr(13) || chr(10) || '            data = {' || chr(13) || chr(10) || '                Article: {' || chr(13) || chr(10) || '                    Subject: subject,' || chr(13) || chr(10) || '                    Body: message || '''',' || chr(13) || chr(10) || '                    TimeUnit: OTRS.params.time_unit,' || chr(13) || chr(10) || '                    ContentType: ''text/plain; charset=utf8''' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result = OTRS.request(''put'', OTRS.entrypoint + ''/'' + encodeURIComponent(OTRS.params.ticket_id), data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof result.response !== ''object''' || chr(13) || chr(10) || '            || typeof result.response.TicketID === ''undefined''' || chr(13) || chr(10) || '            || result.status != 200) {' || chr(13) || chr(10) || '            throw ''Cannot update ((OTRS)) CE ticket. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        params_otrs = {},' || chr(13) || chr(10) || '        params_fields = {},' || chr(13) || chr(10) || '        params_update = {},' || chr(13) || chr(10) || '        result = {tags: {}},' || chr(13) || chr(10) || '')||
TO_NCLOB('        required_params = [' || chr(13) || chr(10) || '            ''alert_subject'', ''event_source'',' || chr(13) || chr(10) || '            ''event_value'',  ''event_update_status''' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        severities = [' || chr(13) || chr(10) || '            {name: ''not_classified'', color: ''#97AAB3''},' || chr(13) || chr(10) || '            {name: ''information'', color: ''#7499FF''},' || chr(13) || chr(10) || '            {name: ''warning'', color: ''#FFC859''},' || chr(13) || chr(10) || '            {name: ''average'', color: ''#FFA059''},' || chr(13) || chr(10) || '            {name: ''high'', color: ''#E97659''},' || chr(13) || chr(10) || '            {name: ''disaster'', color: ''#E45959''},' || chr(13) || chr(10) || '            {name: ''resolved'', color: ''#009900''},' || chr(13) || chr(10) || '            {name: null, color: ''#000000''}' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        priority;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (key.startsWith(''otrs_'')) {' || chr(13) || chr(10) || '                params_otrs[key.substring(5)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''dynamicfield_'')) {' || chr(13) || chr(10) || '                params_fields[key.substring(13)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''event_update_'')) {' || chr(13) || chr(10) || '                params_update[key.substring(13)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (required_params.indexOf(key) !== -1 && params[key].trim() === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" cannot be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '')||
TO_NCLOB('        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '    if (params.event_source === ''0'' && params.event_update_status !== ''0'' && params.event_update_status !== ''1'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_value === ''0'') {' || chr(13) || chr(10) || '        throw ''Recovery operations are supported only for trigger-based actions.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source === ''0''' || chr(13) || chr(10) || '        && ((params.event_value === ''1'' && params.event_update_status === ''1'')' || chr(13) || chr(10) || '            || (params.event_value === ''0''' || chr(13) || chr(10) || '                && (params.event_update_status === ''0'' || params.event_update_status === ''1'')))' || chr(13) || chr(10) || '        && (isNaN(parseInt(params.otrs_ticket_id)) || parseInt(params.otrs_ticket_id) < 1 )) {' || chr(13) || chr(10) || '')||
TO_NCLOB('        throw ''Incorrect "otrs_ticket_id" parameter given: '' + params.otrs_ticket_id +' || chr(13) || chr(10) || '            ''\nMust be positive integer.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {' || chr(13) || chr(10) || '        params.event_nseverity = ''7'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value === ''0'') {' || chr(13) || chr(10) || '        params.event_nseverity = ''6'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    priority = params[''severity_'' + severities[params.event_nseverity].name];' || chr(13) || chr(10) || '    priority = priority && priority.trim() || severities[7].name;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    OTRS.setParams(params_otrs);' || chr(13) || chr(10) || '    OTRS.HTTPProxy = params.HTTPProxy;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Create ticket for non trigger-based events.' || chr(13) || chr(10) || '    if (params.event_source !== ''0''' || chr(13) || chr(10) || '        && params.event_value !== ''0'') {' || chr(13) || chr(10) || '        OTRS.createTicket(params.alert_subject, params.alert_message, priority);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Create ticket for trigger-based events.' || chr(13) || chr(10) || '    else if (params.event_value === ''1'' && params_update.status === ''0'') {' || chr(13) || chr(10) || '        var ticket_id = OTRS.createTicket(params.alert_subject,' || chr(13) || chr(10) || '            params.alert_subject + ''\n'' + params.alert_message + ''\n'' +' || chr(13) || chr(10) || '            params.zabbix_url + (params.zabbix_url.endsWith(''/'') ? '''' : ''/'') +' || chr(13) || chr(10) || '            ''tr_events.php?triggerid='' + params.trigger_id + ''&eventid='' + params.event_id + ''\n'',' || chr(13) || chr(10) || '')||
TO_NCLOB('            priority,' || chr(13) || chr(10) || '            params_fields);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result.tags.__zbx_otrs_ticket_id = ticket_id;' || chr(13) || chr(10) || '        result.tags.__zbx_otrs_ticketlink = params.otrs_url +' || chr(13) || chr(10) || '            (params.otrs_url.endsWith(''/'') ? '''' : ''/'') + ''index.pl?Action=AgentTicketZoom;TicketID='' + ticket_id;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Update created ticket for trigger-based event.' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        OTRS.updateTicket(params.alert_subject, params.alert_message);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return JSON.stringify(result);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ ((OTRS)) CE Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_otrs_ticketlink}','((OTRS)) CE: ticket #{EVENT.TAGS.__zbx_otrs_ticket_id}','','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('40','4','Event-Driven Ansible','','','','','','','','25','0','0','0','0','1','3','10s','1',TO_NCLOB('var Eda = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        var required_params = [' || chr(13) || chr(10) || '                ''send_to'',' || chr(13) || chr(10) || '                ''event_source'',' || chr(13) || chr(10) || '                ''event_value'',' || chr(13) || chr(10) || '                ''event_date'',' || chr(13) || chr(10) || '                ''event_time''],' || chr(13) || chr(10) || '            integer_fields = [' || chr(13) || chr(10) || '                ''event_id'',' || chr(13) || chr(10) || '                ''event_nseverity'',' || chr(13) || chr(10) || '                ''event_object'',' || chr(13) || chr(10) || '                ''event_source'',' || chr(13) || chr(10) || '                ''event_value'',' || chr(13) || chr(10) || '                ''host_id'',' || chr(13) || chr(10) || '                ''trigger_id''];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        required_params.forEach(function (field) {' || chr(13) || chr(10) || '            if (typeof params !== ''object'' || typeof params[field] === ''undefined'' || params[field] === '''') {' || chr(13) || chr(10) || '                throw ''Required param is not set: "'' + field + ''".'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Eda.params = params;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        integer_fields.forEach(function (key) {' || chr(13) || chr(10) || '                if (typeof Eda.params[key] !== ''undefined'') {' || chr(13) || chr(10) || '                    if (isNaN(Eda.params[key])) {' || chr(13) || chr(10) || '                        throw ''Parameter "'' + key + ''" must be integer. Given value: '' + Eda.params[key];' || chr(13) || chr(10) || '                    }' || chr(13) || chr(10) || '')||
TO_NCLOB('                    Eda.params[key] = parseInt(Eda.params[key]);' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        // Check type of event. Possible values: 0 - Trigger' || chr(13) || chr(10) || '        if (params.event_source != 0) {' || chr(13) || chr(10) || '            throw (''Incorrect "event_source" parameter given: '' + params.event_source ' || chr(13) || chr(10) || '                + ''\nOnly trigger-based events are supported'');' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        // Check trigger update and trigger resolve events' || chr(13) || chr(10) || '        if (params.event_source == 0 && params.event_value != 1) {' || chr(13) || chr(10) || '            throw (''Incorrect "event_value" parameter given: "'' + params.event_value ' || chr(13) || chr(10) || '                + ''".\nOnly trigger-based events of problem are supported'');' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        ' || chr(13) || chr(10) || '        // Check endpoint' || chr(13) || chr(10) || '        Eda.params.endpoint = (Eda.params.endpoint.startsWith(''/''))' || chr(13) || chr(10) || '                ? Eda.params.endpoint : ''/'' + Eda.params.endpoint;' || chr(13) || chr(10) || '        // Prepare groups' || chr(13) || chr(10) || '        Eda.params.host_groups = (typeof Eda.params[''host_groups''] !== ''undefined'')' || chr(13) || chr(10) || '                ? this.prepareHostgroups(Eda.params.host_groups): []' || chr(13) || chr(10) || '        // Prepare tags' || chr(13) || chr(10) || '        Eda.params.event_tags = (typeof Eda.params[''event_tags''] !== ''undefined'')' || chr(13) || chr(10) || '                ? this.transformTags(Eda.params.event_tags): {}' || chr(13) || chr(10) || '        // Prepare timestamp' || chr(13) || chr(10) || '        Eda.params.event_datetime_timestamp = this.getTimestamp(' || chr(13) || chr(10) || '            Eda.params.event_date, Eda.params.event_time)' || chr(13) || chr(10) || '')||
TO_NCLOB('    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setProxy: function (HTTPProxy) {' || chr(13) || chr(10) || '        Eda.HTTPProxy = HTTPProxy;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    prepareHostgroups: function (hostgroups) {' || chr(13) || chr(10) || '        var host_groups = []; ' || chr(13) || chr(10) || '        hostgroups.split('','').forEach(function (group) {' || chr(13) || chr(10) || '            group = group.trim();' || chr(13) || chr(10) || '            if (group.length > 0) {' || chr(13) || chr(10) || '                host_groups.push(group);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '        return host_groups;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    getTimestamp: function (date, time) {' || chr(13) || chr(10) || '        try {' || chr(13) || chr(10) || '            return Date.parse(date.split(''.'').join(''-'') + ''T'' + time + ''.000Z'') / 1000 + new Date().getTimezoneOffset() * 60;' || chr(13) || chr(10) || '        } catch (_) {}' || chr(13) || chr(10) || '    ' || chr(13) || chr(10) || '        throw (''Failed to parse event time.'');' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    transformTags: function (event_tags) {' || chr(13) || chr(10) || '        var tags = {};' || chr(13) || chr(10) || '        if (event_tags) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                JSON.parse(event_tags).forEach(function (object) {' || chr(13) || chr(10) || '                    var tag = object[''tag''];' || chr(13) || chr(10) || '                    tags[tag] = tags[tag] || [];' || chr(13) || chr(10) || '                    tags[tag].push(object[''value'']);' || chr(13) || chr(10) || '                });' || chr(13) || chr(10) || '            } catch (error) {' || chr(13) || chr(10) || '')||
TO_NCLOB('                throw ''Event tags format is invalid.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    ' || chr(13) || chr(10) || '        return tags;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    sendMessage: function () {' || chr(13) || chr(10) || '        var response, request = new HttpRequest();' || chr(13) || chr(10) || '        var url = Eda.params[''send_to''] + Eda.params[''endpoint''];' || chr(13) || chr(10) || '        var data = JSON.stringify(Eda.params);' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ Event-Driven Ansible webhook ] URL: '' + url + '' data: '' + data);' || chr(13) || chr(10) || '        ' || chr(13) || chr(10) || '        if (typeof Eda.HTTPProxy !== ''undefined'' && Eda.HTTPProxy !== '''') {' || chr(13) || chr(10) || '            request.setProxy(Eda.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '        response = request.post(url, data);' || chr(13) || chr(10) || '        ' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ Event-Driven Ansible webhook ] HTTP code: '' + request.getStatus()' || chr(13) || chr(10) || '            + '' response: '' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() !== 200) {' || chr(13) || chr(10) || '            throw ''Request failed with status code '' + request.getStatus() + '': '' + response;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value);' || chr(13) || chr(10) || '    ' || chr(13) || chr(10) || '    Eda.setParams(params);' || chr(13) || chr(10) || '    Eda.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    Eda.sendMessage();' || chr(13) || chr(10) || '    return true;' || chr(13) || chr(10) || '')||
TO_NCLOB('}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ Event-Driven Ansible webhook ] notification failed: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','0','0','','','','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,maxsessions,maxattempts,attempt_interval,message_format,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description,provider)
values ('41','4','MantisBT','','','','','','','','25','0','0','0','0','1','1','10s','1',TO_NCLOB('var Mantisbt = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        Mantisbt.params = params;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setProxy: function (HTTPProxy) {' || chr(13) || chr(10) || '        Mantisbt.HTTPProxy = HTTPProxy;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    checkUrlFormat: function (url) {' || chr(13) || chr(10) || '        if (typeof url === ''string'' && !url.endsWith(''/'')) {' || chr(13) || chr(10) || '            url += ''/'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (url.indexOf(''http://'') === -1 && url.indexOf(''https://'') === -1) {' || chr(13) || chr(10) || '            url = ''https://'' + url;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return url;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    getProblemURL: function (zabbix_url, triggerid, eventid, event_source) {' || chr(13) || chr(10) || '        var problem_url = zabbix_url;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (event_source === ''0'') {' || chr(13) || chr(10) || '            problem_url += ''tr_events.php?triggerid='' + triggerid + ''&eventid='' + eventid;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return problem_url;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (method, url, data) {' || chr(13) || chr(10) || '        [''token'', ''url'', ''category''].forEach(function (field) {' || chr(13) || chr(10) || '')||
TO_NCLOB('            if (typeof Mantisbt.params !== ''object'' || typeof Mantisbt.params[field] === ''undefined'' || Mantisbt.params[field] === '''') {' || chr(13) || chr(10) || '                throw ''Required MantisBT param is not set: "'' + field + ''".'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '        request.addHeader(''Authorization: '' + Mantisbt.params.token);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof Mantisbt.HTTPProxy !== ''undefined'' && Mantisbt.HTTPProxy !== '''') {' || chr(13) || chr(10) || '            request.setProxy(Mantisbt.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ MantisBT Webhook ] Sending request: '' + url + ((typeof data === ''string'') ? (''\n'' + data) : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (method) {' || chr(13) || chr(10) || '            case ''post'':' || chr(13) || chr(10) || '                response = request.post(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''patch'':' || chr(13) || chr(10) || '                response = request.patch(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                throw ''Unsupported HTTP request method: '' + method;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('        Zabbix.log(4, ''[ MantisBT Webhook ] Received response with status code '' + request.getStatus() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ MantisBT Webhook ] Failed to parse the response received from MantisBT'');' || chr(13) || chr(10) || '                response = null;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof response !== ''object'') {' || chr(13) || chr(10) || '            throw ''Failed to process the response received from MantisBT. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() < 200 || request.getStatus() >= 300) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (typeof response.message !== ''undefined'') {' || chr(13) || chr(10) || '                message += '': '' + response.message;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            throw message;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return response;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        mantisbt = {},' || chr(13) || chr(10) || '        url = '''',' || chr(13) || chr(10) || '        data = {},' || chr(13) || chr(10) || '')||
TO_NCLOB('        result = { tags: {} },' || chr(13) || chr(10) || '        required_params = [' || chr(13) || chr(10) || '            ''alert_subject'', ''alert_message'', ''event_source'', ''event_value'', ''event_update_action'',' || chr(13) || chr(10) || '            ''event_update_status'', ''event_recovery_value'', ''event_nseverity'', ''event_tagsjson'',' || chr(13) || chr(10) || '            ''event_id'', ''trigger_id'', ''zabbix_url'', ''alert_sendto'',' || chr(13) || chr(10) || '            ''mantisbt_token'', ''mantisbt_url'', ''mantisbt_category'', ''mantisbt_issue_number'', ''mantisbt_use_zabbix_tags''' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        method,' || chr(13) || chr(10) || '        severities = [''none'', ''low'', ''normal'', ''high'', ''urgent'', ''immediate''];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (key.startsWith(''mantisbt_'')) {' || chr(13) || chr(10) || '                mantisbt[key.substring(9)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (required_params.indexOf(key) !== -1 && params[key] === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" cannot be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1'' && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '')||
TO_NCLOB('        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'' && params.event_source === ''0'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_recovery_value === ''0'') {' || chr(13) || chr(10) || '        throw ''Recovery operations are supported for trigger-based actions only.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.zabbix_url !== ''string'' || params.zabbix_url.trim() === '''' || params.zabbix_url === ''{$ZABBIX.URL}'') {' || chr(13) || chr(10) || '        throw ''Field "zabbix_url" cannot be empty.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check for backslash in the end of url and schema.' || chr(13) || chr(10) || '    mantisbt.url = Mantisbt.checkUrlFormat(mantisbt.url);' || chr(13) || chr(10) || '    params.zabbix_url = Mantisbt.checkUrlFormat(params.zabbix_url);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // In case of resolve event.' || chr(13) || chr(10) || '    if (params.event_source === ''0'' && params.event_value === ''0'') {' || chr(13) || chr(10) || '        method = "patch";' || chr(13) || chr(10) || '        url = mantisbt.url + ''api/rest/issues/'' + mantisbt.issue_number;' || chr(13) || chr(10) || '        data = {' || chr(13) || chr(10) || '            summary: params.alert_subject,' || chr(13) || chr(10) || '            status: {' || chr(13) || chr(10) || '')||
TO_NCLOB('                name: "resolved"' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '        if (/commented/.test(params.event_update_action)) {' || chr(13) || chr(10) || '            data.additional_information = params.event_update_message;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        process_tags = false;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // In case of update event.' || chr(13) || chr(10) || '    else if (params.event_source === ''0'' && params.event_update_status === ''1'') {' || chr(13) || chr(10) || '        method = "patch";' || chr(13) || chr(10) || '        url = mantisbt.url + ''api/rest/issues/'' + mantisbt.issue_number;' || chr(13) || chr(10) || '        data = {' || chr(13) || chr(10) || '            status: {},' || chr(13) || chr(10) || '            priority: {' || chr(13) || chr(10) || '                name: severities[parseInt(params.event_nseverity, 10)]' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '        if (/commented/.test(params.event_update_action)) {' || chr(13) || chr(10) || '            data.additional_information = params.event_update_message;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        if (/acknowledged/.test(params.event_update_action)) {' || chr(13) || chr(10) || '            data.status.name = "acknowledged";' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        if (/unacknowledged/.test(params.event_update_action)) {' || chr(13) || chr(10) || '            data.status.name = "new";' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        process_tags = false;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        method = ''post'';' || chr(13) || chr(10) || '        url = mantisbt.url + ''api/rest/issues'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        data = {' || chr(13) || chr(10) || '')||
TO_NCLOB('            summary: params.alert_subject,' || chr(13) || chr(10) || '            description: params.alert_message,' || chr(13) || chr(10) || '            project: { name: params.alert_sendto },' || chr(13) || chr(10) || '            category: { name: mantisbt.category },' || chr(13) || chr(10) || '            priority: {' || chr(13) || chr(10) || '                name: parseInt(params.event_nseverity, 10) ? severities[parseInt(params.event_nseverity, 10)] : "none"' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '        if (params.event_source === ''0'') {' || chr(13) || chr(10) || '            problem_url = Mantisbt.getProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source);' || chr(13) || chr(10) || '            data.description += ''\n'' + problem_url;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (mantisbt.use_zabbix_tags === "true") {' || chr(13) || chr(10) || '                var alert_tags = JSON.parse(params.event_tagsjson);' || chr(13) || chr(10) || '                data.tags = alert_tags.map(function (t) { return { name: t.value ? (t.tag + '': '' + t.value) : t.tag }; });' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        process_tags = true;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Mantisbt.setParams(mantisbt);' || chr(13) || chr(10) || '    Mantisbt.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var response = Mantisbt.request(method, url, data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (process_tags) {' || chr(13) || chr(10) || '        result.tags.__zbx_mantisbt_issue_number = response.issue.id;' || chr(13) || chr(10) || '        result.tags.__zbx_mantisbt_link = mantisbt.url + ''view.php?id='' + response.issue.id;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    Zabbix.log(4, ''[ MantisBT Webhook ] Result: '' + JSON.stringify(result));' || chr(13) || chr(10) || '    return JSON.stringify(result);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(4, ''[ MantisBT Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_mantisbt_link}','MantisBT: Issue ID {EVENT.TAGS.__zbx_mantisbt_issue_number}','','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('1','5','zabbix_url','{$ZABBIX.URL}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('2','5','bot_token','<YOUR BOT TOKEN>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('3','5','mattermost_url','<YOUR MATTERMOST URL>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('4','5','send_mode','alarm','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('5','5','send_to','{ALERT.SENDTO}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('6','5','event_tags','{EVENT.TAGS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('8','5','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('10','5','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('11','5','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('12','5','event_date','{EVENT.DATE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('13','5','event_time','{EVENT.TIME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('14','5','event_severity','{EVENT.SEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('15','5','event_opdata','{EVENT.OPDATA}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('16','5','event_id','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('18','5','trigger_id','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('19','5','trigger_description','{TRIGGER.DESCRIPTION}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('20','5','host_name','{HOST.HOST}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('21','5','host_ip','{HOST.IP}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('22','5','event_update_date','{EVENT.UPDATE.DATE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('23','5','event_update_time','{EVENT.UPDATE.TIME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('24','5','event_recovery_date','{EVENT.RECOVERY.DATE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('25','5','event_recovery_time','{EVENT.RECOVERY.TIME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('37','6','zbxurl','{$ZABBIX.URL}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('39','7','token','<put your key>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('40','7','eventid','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('41','7','eventname','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('42','7','hostname','{HOST.NAME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('43','7','hostip','{HOST.IP}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('44','7','severity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('45','7','triggerdesc','{TRIGGER.DESCRIPTION}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('46','7','triggeropdata','{EVENT.OPDATA}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('47','7','eventtags','{EVENT.TAGS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('48','7','triggerid','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('49','7','eventdate','{EVENT.DATE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('50','7','eventtime','{EVENT.TIME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('52','7','eventack','{EVENT.ACK.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('53','7','eventupdate','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('54','7','eventvalue','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('55','7','url','{$ZABBIX.URL}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('56','8','token','<PUSHOVER TOKEN HERE>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('57','8','user','{ALERT.SENDTO}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('58','8','message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('59','8','title','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('60','8','url','{$ZABBIX.URL}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('61','8','url_title','Zabbix','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('63','8','eventid','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('64','8','triggerid','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('65','9','zabbix_url','{$ZABBIX.URL}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('66','9','bot_token','<PLACE YOUR KEY HERE>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('67','9','channel','{ALERT.SENDTO}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('68','9','slack_mode','alarm','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('69','9','slack_as_user','true','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('71','9','event_tags','{EVENT.TAGSJSON}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('73','9','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('75','9','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('76','9','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('77','9','event_date','{EVENT.DATE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('78','9','event_time','{EVENT.TIME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('79','9','event_severity','{EVENT.SEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('80','9','event_opdata','{EVENT.OPDATA}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('81','9','event_id','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('83','9','trigger_id','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('84','9','trigger_description','{TRIGGER.DESCRIPTION}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('85','9','host_name','{HOST.NAME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('87','9','event_update_date','{EVENT.UPDATE.DATE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('88','9','event_update_time','{EVENT.UPDATE.TIME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('89','9','event_recovery_date','{EVENT.RECOVERY.DATE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('90','9','event_recovery_time','{EVENT.RECOVERY.TIME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('91','10','zabbix_url','{$ZABBIX.URL}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('92','10','discord_endpoint','{ALERT.SENDTO}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('93','10','use_default_message','false','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('94','10','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('95','10','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('96','10','event_name','{EVENT.NAME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('97','10','event_id','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('98','10','event_severity','{EVENT.SEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('99','10','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('100','10','event_opdata','{EVENT.OPDATA}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('101','10','event_tags','{EVENT.TAGS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('102','10','event_time','{EVENT.TIME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('103','10','event_date','{EVENT.DATE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('104','10','event_recovery_date','{EVENT.RECOVERY.DATE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('105','10','event_recovery_time','{EVENT.RECOVERY.TIME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('106','10','event_update_date','{EVENT.UPDATE.DATE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('107','10','event_update_time','{EVENT.UPDATE.TIME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('108','10','event_update_action','{EVENT.UPDATE.ACTION}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('109','10','event_update_message','{EVENT.UPDATE.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('110','10','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('111','10','event_update_user','{USER.FULLNAME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('112','10','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('113','10','host_ip','{HOST.IP}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('114','10','host_name','{HOST.NAME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('115','10','trigger_description','{TRIGGER.DESCRIPTION}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('116','10','trigger_id','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('117','8','endpoint','https://api.pushover.net/1/messages.json','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('118','8','retry','60','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('119','8','expire','1200','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('120','11','teamsecret','{ALERT.SENDTO}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('121','11','Subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('122','11','Message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('123','11','Severity','{EVENT.SEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('125','11','Hostname','{HOST.NAME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('127','12','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('128','12','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('129','12','event_recovery_value','{EVENT.RECOVERY.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('130','12','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('131','12','event_tags_json','{EVENT.TAGSJSON}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('132','12','event_update_action','{EVENT.UPDATE.ACTION}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('133','12','event_update_message','{EVENT.UPDATE.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('134','12','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('135','12','event_update_user','{USER.FULLNAME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('136','12','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('137','12','jira_issue_key','{EVENT.TAGS.__zbx_jira_issuekey}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('138','12','jira_issue_type','<PLACE ISSUETYPE NAME>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('139','12','jira_password','<PLACE PASSWORD OR TOKEN>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('140','12','jira_project_key','<PLACE PROJECT KEY>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('141','12','jira_url','<PLACE YOUR JIRA URL>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('142','12','jira_user','<PLACE LOGIN>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('143','12','trigger_description','{TRIGGER.DESCRIPTION}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('169','14','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('170','14','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('171','14','event_date','{EVENT.DATE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('172','14','event_id','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('173','14','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('174','14','event_opdata','{EVENT.OPDATA}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('175','14','event_recovery_date','{EVENT.RECOVERY.DATE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('176','14','event_recovery_time','{EVENT.RECOVERY.TIME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('177','14','event_severity','{EVENT.SEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('178','14','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('179','14','event_status','{EVENT.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('180','14','event_tags','{EVENT.TAGS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('181','14','event_time','{EVENT.TIME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('182','14','event_update_action','{EVENT.UPDATE.ACTION}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('183','14','event_update_date','{EVENT.UPDATE.DATE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('184','14','event_update_message','{EVENT.UPDATE.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('185','14','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('186','14','event_update_time','{EVENT.UPDATE.TIME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('187','14','event_update_user','{USER.FULLNAME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('188','14','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('189','14','host_ip','{HOST.IP}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('190','14','host_name','{HOST.NAME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('191','14','teams_endpoint','<PLACE WEBHOOK URL HERE>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('192','14','trigger_description','{TRIGGER.DESCRIPTION}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('193','14','trigger_id','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('194','14','use_default_message','false','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('195','14','zabbix_url','{$ZABBIX.URL}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('196','15','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('197','15','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('198','15','event_id','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('199','15','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('200','15','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('201','15','event_update_message','{EVENT.UPDATE.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('202','15','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('203','15','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('204','15','redmine_access_key','<PUT YOUR ACCESS KEY>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('205','15','redmine_issue_key','{EVENT.TAGS.__zbx_redmine_issue_id}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('206','15','redmine_project','<PUT YOUR PROJECT ID OR NAME>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('207','15','redmine_tracker_id','<PUT YOUR TRACKER ID>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('208','15','redmine_url','<PUT YOUR REDMINE URL>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('209','15','trigger_id','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('210','15','zabbix_url','{$ZABBIX.URL}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('211','16','Message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('212','16','ParseMode','','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('213','16','Subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('214','16','To','{ALERT.SENDTO}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('215','16','Token','<PLACE YOUR TOKEN>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('216','17','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('217','17','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('218','17','event_id','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('219','17','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('220','17','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('221','17','event_tags','{EVENT.TAGS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('222','17','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('223','17','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('224','17','severity_average','normal','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('225','17','severity_default','-','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('226','17','severity_disaster','urgent','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('227','17','severity_high','high','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('228','17','severity_information','low','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('229','17','severity_not_classified','low','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('230','17','severity_warning','normal','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('231','17','trigger_id','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('232','17','zbxurl','{$ZABBIX.URL}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('233','17','zendesk_issue_key','{EVENT.TAGS.__zbx_zdk_issuekey}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('234','17','zendesk_token','<put your {enduser_email_address}/token:{api_token}>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('235','17','zendesk_type','incident','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('236','17','zendesk_url','<put your Zendesk URL>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('237','18','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('238','18','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('239','18','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('240','18','event_recovery_value','{EVENT.RECOVERY.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('241','18','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('242','18','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('243','18','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('244','18','servicenow_password','<PLACE PASSWORD HERE>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('245','18','servicenow_sys_id','{EVENT.TAGS.__zbx_servicenow_sys_id}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('246','18','servicenow_url','{ALERT.SENDTO}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('247','18','servicenow_user','<PLACE USERNAME HERE>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('248','18','urgency_for_average','2','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('249','18','urgency_for_disaster','1','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('250','18','urgency_for_high','2','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('251','18','urgency_for_information','3','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('252','18','urgency_for_not_classified','3','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('253','18','urgency_for_warning','3','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('254','19','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('255','19','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('256','19','event_id','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('257','19','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('258','19','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('259','19','event_tags','{EVENT.TAGSJSON}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('260','19','event_update_message','{EVENT.UPDATE.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('261','19','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('262','19','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('263','19','trigger_id','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('264','19','zabbix_url','{$ZABBIX.URL}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('265','19','zammad_access_token','<PUT YOUR ACCESS TOKEN>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('266','19','zammad_customer','<PUT YOUR CUSTOMER EMAIL>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('267','19','zammad_enable_tags','true','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('268','19','zammad_ticket_id','{EVENT.TAGS.__zbx_zammad_ticket_id}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('269','19','zammad_url','<PUT YOUR ZAMMAD URL>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('270','20','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('271','20','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('272','20','event_recovery_value','{EVENT.RECOVERY.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('273','20','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('274','20','event_tags_json','{EVENT.TAGSJSON}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('275','20','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('276','20','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('277','20','jira_password','<PLACE PASSWORD OR TOKEN>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('278','20','jira_request_key','{EVENT.TAGS.__zbx_jira_requestkey}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('279','20','jira_request_type_id','<PLACE REQUEST TYPE ID>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('280','20','jira_servicedesk_id','<PLACE SERVICEDESK ID>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('281','20','jira_url','<PLACE YOUR JIRA URL>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('282','20','jira_user','<PLACE LOGIN>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('283','21','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('284','21','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('285','21','event_id','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('286','21','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('287','21','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('288','21','event_update_message','{EVENT.UPDATE.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('289','21','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('290','21','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('291','21','otrs_auth_password','<PUT YOUR USER PASSWORD>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('292','21','otrs_auth_user','<PUT YOUR USER NAME>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('293','21','otrs_customer','<PUT YOUR CUSTOMER EMAIL>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('294','21','otrs_default_priority_id','3','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('295','21','otrs_queue','<PUT YOUR QUEUE NAME>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('296','21','otrs_ticket_id','{EVENT.TAGS.__zbx_otrs_ticket_id}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('297','21','otrs_ticket_state','new','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('298','21','otrs_time_unit','0','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('299','21','otrs_url','<PUT YOUR OTRS URL>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('300','21','trigger_id','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('301','21','zabbix_url','{$ZABBIX.URL}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('302','11','Event_Ack_Status','{EVENT.ACK.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('303','11','Event_Date_Time','{EVENT.DATE} {EVENT.TIME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('304','11','Event_ID','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('305','11','Event_Update_Action','{EVENT.UPDATE.ACTION}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('306','11','Event_Update_Status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('307','11','Host_IP','{HOST.IP}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('308','11','Trigger_ID','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('309','11','Trigger_Status','{TRIGGER.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('310','11','User','{USER.FULLNAME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('311','11','Zabbix_URL','{$ZABBIX.URL}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('312','10','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('313','22','.ILERT.ALERT.SOURCE.KEY','{ALERT.SENDTO}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('314','22','.ILERT.INCIDENT.SUMMARY','','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('315','22','ALERT.MESSAGE','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('316','22','ALERT.SUBJECT','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('317','22','EVENT.ACK.STATUS','{EVENT.ACK.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('318','22','EVENT.DATE','{EVENT.DATE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('319','22','EVENT.ID','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('320','22','EVENT.NAME','{EVENT.NAME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('321','22','EVENT.NSEVERITY','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('322','22','EVENT.OPDATA','{EVENT.OPDATA}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('323','22','EVENT.RECOVERY.DATE','{EVENT.RECOVERY.DATE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('324','22','EVENT.RECOVERY.TIME','{EVENT.RECOVERY.TIME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('325','22','EVENT.RECOVERY.VALUE','{EVENT.RECOVERY.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('326','22','EVENT.SEVERITY','{EVENT.SEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('327','22','EVENT.TAGS','{EVENT.TAGS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('328','22','EVENT.TIME','{EVENT.TIME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('329','22','EVENT.UPDATE.ACTION','{EVENT.UPDATE.ACTION}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('330','22','EVENT.UPDATE.DATE','{EVENT.UPDATE.DATE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('331','22','EVENT.UPDATE.MESSAGE','{EVENT.UPDATE.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('332','22','EVENT.UPDATE.STATUS','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('333','22','EVENT.UPDATE.TIME','{EVENT.UPDATE.TIME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('334','22','EVENT.VALUE','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('335','22','HOST.HOST','{HOST.HOST}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('336','22','HOST.IP','{HOST.IP}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('337','22','HOST.NAME','{HOST.NAME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('338','22','ITEM.ID1','{ITEM.ID1}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('339','22','ITEM.ID2','{ITEM.ID2}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('340','22','ITEM.ID3','{ITEM.ID3}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('341','22','ITEM.ID4','{ITEM.ID4}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('342','22','ITEM.ID5','{ITEM.ID5}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('343','22','ITEM.NAME1','{ITEM.NAME1}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('344','22','ITEM.NAME2','{ITEM.NAME2}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('345','22','ITEM.NAME3','{ITEM.NAME3}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('346','22','ITEM.NAME4','{ITEM.NAME4}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('347','22','ITEM.NAME5','{ITEM.NAME5}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('348','22','TRIGGER.DESCRIPTION','{TRIGGER.DESCRIPTION}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('349','22','TRIGGER.ID','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('350','22','TRIGGER.NAME','{TRIGGER.NAME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('351','22','TRIGGER.SEVERITY','{TRIGGER.SEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('352','22','TRIGGER.STATUS','{TRIGGER.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('353','22','TRIGGER.URL','{TRIGGER.URL}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('354','22','TRIGGER.VALUE','{TRIGGER.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('355','22','USER.FULLNAME','{USER.FULLNAME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('356','22','ZABBIX.URL','{$ZABBIX.URL}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('357','5','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('358','5','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('359','5','discovery_host_dns','{DISCOVERY.DEVICE.DNS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('360','5','discovery_host_ip','{DISCOVERY.DEVICE.IPADDRESS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('361','5','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('362','6','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('363','6','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('364','6','event_id','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('365','6','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('366','6','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('367','6','event_tags_json','{EVENT.TAGSJSON}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('368','6','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('369','6','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('370','6','opsgenie_api','<put your opsgenie api>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('371','6','opsgenie_tags','','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('372','6','opsgenie_teams','','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('373','6','opsgenie_token','<put your token>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('374','6','opsgenie_web','<put your opsgenie web>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('375','6','severity_average','P3','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('376','6','severity_default','P5','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('377','6','severity_disaster','P1','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('378','6','severity_high','P2','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('379','6','severity_information','P5','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('380','6','severity_not_classified','P5','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('381','6','severity_warning','P4','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('382','6','trigger_id','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('383','6','zbxuser','{USER.FULLNAME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('384','7','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('385','7','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('386','8','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('387','8','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('388','8','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('389','8','priority_average','0','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('390','8','priority_default','0','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('391','8','priority_disaster','0','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('392','8','priority_high','0','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('393','8','priority_information','0','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('394','8','priority_not_classified','0','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('395','8','priority_warning','0','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('396','9','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('397','9','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('398','9','discovery_host_dns','{DISCOVERY.DEVICE.DNS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('399','9','discovery_host_ip','{DISCOVERY.DEVICE.IPADDRESS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('400','9','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('401','9','host_conn','{HOST.CONN}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('402','23','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('403','23','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('404','23','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('405','23','event_recovery_value','{EVENT.RECOVERY.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('406','23','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('407','23','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('408','23','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('409','23','priority_average','Medium','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('410','23','priority_default','Low','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('411','23','priority_disaster','Critical','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('412','23','priority_high','High','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('413','23','samanage_incident_id','{EVENT.TAGS.__zbx_solarwinds_inc_id}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('414','23','samanage_token','<PUT YOUR TOKEN HERE>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('415','23','samanage_url','<PUT YOUR INSTANCE URL HERE>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('416','24','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('417','24','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('418','24','event_id','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('419','24','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('420','24','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('421','24','event_update_message','{EVENT.UPDATE.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('422','24','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('423','24','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('424','24','sysaid_auth_password','<PUT YOUR USER PASSWORD>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('425','24','sysaid_auth_user','<PUT YOUR USER NAME>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('426','24','sysaid_category_level_1','<PUT YOUR CATEGORY>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('427','24','sysaid_category_level_2','<PUT YOUR SUB-CATEGORY>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('428','24','sysaid_category_level_3','<PUT YOUR THIRD LEVEL CATEGORY>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('429','24','sysaid_default_priority_id','1','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('430','24','sysaid_incident_id','{EVENT.TAGS.__zbx_sysaid_incident_id}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('431','24','sysaid_incident_state','1','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('432','24','sysaid_template_id','<PUT YOUR TEMPLATE ID>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('433','24','sysaid_urgency_id','<PUT YOUR URGENCY ID>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('434','24','sysaid_url','<PUT YOUR SYSAID URL>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('435','24','trigger_id','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('436','24','zabbix_url','{$ZABBIX.URL}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('437','25','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('438','25','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('439','25','event_id','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('440','25','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('441','25','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('442','25','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('443','25','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('444','25','severity_average','P3','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('445','25','severity_default','P5','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('446','25','severity_disaster','P1','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('447','25','severity_high','P2','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('448','25','severity_information','P5','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('449','25','severity_not_classified','P5','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('450','25','severity_warning','P4','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('451','25','topdesk_api','<put your TOPdesk API URL>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('452','25','topdesk_issue_key','{EVENT.TAGS.__zbx_tpd_issuekey}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('453','25','topdesk_password','<put your TOPdesk application password>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('454','25','topdesk_status','<put default status for new tickets>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('455','25','topdesk_user','<put your TOPdesk username>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('456','25','trigger_id','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('457','25','zbxurl','{$ZABBIX.URL}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('458','26','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('459','26','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('460','26','event_recovery_value','{EVENT.RECOVERY.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('461','26','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('462','26','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('463','26','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('464','26','itop_api_version','1.3','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('465','26','itop_class','UserRequest','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('466','26','itop_comment','Created by Zabbix action {ACTION.NAME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('467','26','itop_id','{EVENT.TAGS.__zbx_itop_id}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('468','26','itop_log','private_log','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('469','26','itop_organization_id','<PLACE ORGANIZATION ID>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('470','26','itop_password','<PLACE PASSWORD OR TOKEN>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('471','26','itop_url','<PLACE YOUR ITOP URL>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('472','26','itop_user','<PLACE LOGIN>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('473','27','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('474','27','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('475','27','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('476','27','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('477','27','event_update_action','{EVENT.UPDATE.ACTION}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('478','27','event_update_message','{EVENT.UPDATE.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('479','27','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('480','27','event_update_user','{USER.FULLNAME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('481','27','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('482','27','field_1_full:Host','{HOST.NAME} [{HOST.IP}]','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('483','27','field_2_short:Severity','{EVENT.SEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('484','27','field_3_short:Event time','{EVENT.DATE} {EVENT.TIME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('485','27','field_3_short_r:Recovery time','{EVENT.RECOVERY.DATE} {EVENT.RECOVERY.TIME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('486','27','field_4_short_r:Event duration','{EVENT.DURATION}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('487','27','field_5_short:Operational data','{EVENT.OPDATA}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('488','27','field_999_full_p:Trigger description','{TRIGGER.DESCRIPTION}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('489','27','rc_api_url','api/v1/','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('490','27','rc_msg_id','{EVENT.TAGS.__zbx_rc_id}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('491','27','rc_room_id','{EVENT.TAGS.__zbx_rc_rid}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('492','27','rc_send_to','{ALERT.SENDTO}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('493','27','rc_title_link','{$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('494','27','rc_url','<PLACE YOUR INSTANCE URL HERE>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('495','27','rc_user_id','<PLACE USER ID HERE>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('496','27','rc_user_token','<PLACE TOKEN HERE>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('497','27','use_default_message','false','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('498','28','event_info','{$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('499','28','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('500','28','event_recovery_value','{EVENT.RECOVERY.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('501','28','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('502','28','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('503','28','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('504','28','field:entity_display_name','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('505','28','field:entity_id','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('506','28','field:hostname','{HOST.NAME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('507','28','field:monitoring_tool','Zabbix','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('508','28','field:operational_data','{EVENT.OPDATA}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('509','28','field:severity','{EVENT.SEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('510','28','field:state_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('511','28','field_p:trigger_description','{TRIGGER.DESCRIPTION}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('512','28','field_r:event_duration','{EVENT.DURATION}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('513','28','field_r:recovery time','{EVENT.RECOVERY.DATE} {EVENT.RECOVERY.TIME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('514','28','priority_average','WARNING','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('515','28','priority_default','INFO','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('516','28','priority_disaster','CRITICAL','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('517','28','priority_high','WARNING','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('518','28','priority_information','INFO','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('519','28','priority_not_classified','INFO','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('520','28','priority_resolved','OK','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('521','28','priority_update','INFO','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('522','28','priority_warning','INFO','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('523','28','vops_endpoint','<PLACE ENDPOINT URL HERE>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('524','28','vops_routing_key','{ALERT.SENDTO}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('525','29','endpoint','<PLACE HTTP API URL>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('526','29','flash','false','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('527','29','password','<PLACE PASSWORD>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('528','29','ring','false','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('529','29','send_to','{ALERT.SENDTO}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('530','29','telauto','true','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('531','29','text','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('532','29','username','<PLACE USERNAME>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('535','30','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('536','30','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('537','30','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('538','30','express_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('539','30','express_send_to','{ALERT.SENDTO}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('540','30','express_tags','{EVENT.TAGSJSON}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('541','30','express_token','<PLACE BOT TOKEN>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('542','30','express_url','<PLACE INSTANCE URL>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('543','31','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('544','31','event_recovery_value','{EVENT.RECOVERY.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('545','31','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('546','31','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('547','31','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('548','31','field_ref:requester','<PLACE API USER NAME>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('549','31','field_string:description','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('550','31','field_string:subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('551','31','priority_average','Normal','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('552','31','priority_default','Normal','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('553','31','priority_disaster','High','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('554','31','priority_high','High','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('555','31','priority_information','Low','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('556','31','priority_not_classified','Low','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('557','31','priority_warning','Medium','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('558','31','sd_on_demand_client_id','<PLACE ON DEMAND CLIENT ID>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('559','31','sd_on_demand_client_secret','<PLACE ON DEMAND CLIENT SECRET>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('560','31','sd_on_demand_refresh_token','<PLACE ON DEMAND REFRESH TOKEN>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('561','31','sd_on_demand_url_auth','<PLACE AUTHENTICATION URL FOR ON DEMAND>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('562','31','sd_on_premise','true','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('563','31','sd_on_premise_auth_token','<PLACE ON PREMISE TECHNICIAN_KEY>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('564','31','sd_request_id','{EVENT.TAGS.__zbx_sd_request_id}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('565','31','sd_url','<PLACE INSTANCE URL>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('566','31','trigger_description','{TRIGGER.DESCRIPTION}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('567','32','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('568','32','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('569','32','event_id','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('570','32','event_recovery_value','{EVENT.RECOVERY.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('571','32','event_severity','{EVENT.SEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('572','32','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('573','32','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('574','32','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('575','32','github_issue_number','{EVENT.TAGS.__zbx_github_issue_number}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('576','32','github_repo','{ALERT.SENDTO}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('577','32','github_token','<PLACE GITHUB TOKEN>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('578','32','github_url','https://api.github.com','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('579','32','github_user_agent','Zabbix/6.0','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('580','32','trigger_id','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('581','32','zabbix_url','{$ZABBIX.URL}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('582','33','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('583','33','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('584','33','event_id','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('585','33','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('586','33','event_recovery_value','{EVENT.RECOVERY.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('587','33','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('588','33','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('589','33','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('590','33','glpi_problem_id','{EVENT.TAGS.__zbx_glpi_problem_id}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('591','33','glpi_token','<PLACE GLPI TOKEN>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('592','33','glpi_url','<PLACE GLPI URL>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('593','33','trigger_id','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('594','33','zabbix_url','{$ZABBIX.URL}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('595','6','event_update_action','{EVENT.UPDATE.ACTION}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('596','6','status_counter','25','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('597','38','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('598','38','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('599','38','bot_token','<PLACE BOT TOKEN>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('600','38','event_id','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('601','38','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('602','38','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('603','38','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('604','38','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('605','38','send_to','{ALERT.SENDTO}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('606','38','trigger_description','{TRIGGER.DESCRIPTION}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('607','38','trigger_id','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('608','38','zabbix_url','{$ZABBIX.URL}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('609','39','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('610','39','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('611','39','event_id','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('612','39','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('613','39','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('614','39','event_update_message','{EVENT.UPDATE.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('615','39','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('616','39','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('617','39','otrs_auth_password','<PUT YOUR USER PASSWORD>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('618','39','otrs_auth_user','<PUT YOUR USER NAME>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('619','39','otrs_customer','<PUT YOUR CUSTOMER EMAIL>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('620','39','otrs_default_priority_id','3','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('621','39','otrs_queue','<PUT YOUR QUEUE NAME>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('622','39','otrs_ticket_id','{EVENT.TAGS.__zbx_otrs_ticket_id}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('623','39','otrs_ticket_state','new','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('624','39','otrs_time_unit','0','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('625','39','otrs_url','<PUT YOUR ((OTRS)) CE URL>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('626','39','trigger_id','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('627','39','zabbix_url','{$ZABBIX.URL}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('628','40','acknowledged','{EVENT.ACK.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('629','40','endpoint','/endpoint','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('630','40','event_date','{EVENT.DATE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('631','40','event_id','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('632','40','event_name','{EVENT.NAME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('633','40','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('634','40','event_object','{EVENT.OBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('635','40','event_severity','{EVENT.SEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('636','40','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('637','40','event_tags','{EVENT.TAGSJSON}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('638','40','event_time','{EVENT.TIME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('639','40','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('640','40','host_groups','{TRIGGER.HOSTGROUP.NAME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('641','40','host_host','{HOST.HOST}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('642','40','host_id','{HOST.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('643','40','host_ip','{HOST.IP}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('644','40','host_port','{HOST.PORT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('645','40','HTTPProxy','','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('646','40','monitoring_source','Zabbix sever','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('647','40','operation_data','{EVENT.OPDATA}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('648','40','send_to','{ALERT.SENDTO}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('649','40','subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('650','40','trigger_description','{TRIGGER.DESCRIPTION}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('651','40','trigger_id','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('652','40','trigger_name','{TRIGGER.NAME}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('653','41','alert_message','{ALERT.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('654','41','alert_sendto','{ALERT.SENDTO}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('655','41','alert_subject','{ALERT.SUBJECT}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('656','41','event_id','{EVENT.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('657','41','event_nseverity','{EVENT.NSEVERITY}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('658','41','event_recovery_value','{EVENT.RECOVERY.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('659','41','event_source','{EVENT.SOURCE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('660','41','event_tagsjson','{EVENT.TAGSJSON}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('661','41','event_update_action','{EVENT.UPDATE.ACTION}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('662','41','event_update_message','{EVENT.UPDATE.MESSAGE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('663','41','event_update_status','{EVENT.UPDATE.STATUS}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('664','41','event_value','{EVENT.VALUE}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('665','41','mantisbt_category','[All Projects] General','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('666','41','mantisbt_issue_number','{EVENT.TAGS.__zbx_mantisbt_issue_number}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('667','41','mantisbt_token','<PLACE MANTISBT TOKEN>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('668','41','mantisbt_url','<PLACE MANTISBT URL>','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('669','41','mantisbt_use_zabbix_tags','true','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('670','41','trigger_id','{TRIGGER.ID}','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value,sortorder)
values ('671','41','zabbix_url','{$ZABBIX.URL}','0')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('1','1','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('2','1','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Problem duration: {EVENT.DURATION}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('3','1','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('4','1','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('5','1','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('6','3','0','0','','{EVENT.SEVERITY}: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || '{EVENT.DATE} {EVENT.TIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('7','3','0','1','','Resolved in {EVENT.DURATION}: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || '{EVENT.DATE} {EVENT.TIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('8','3','0','2','','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem in {EVENT.AGE} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('9','3','1','0','','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('10','3','2','0','','Autoregistration: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('11','4','0','0','Problem: {EVENT.NAME}','<b>Problem started</b> at {EVENT.TIME} on {EVENT.DATE}<br><b>Problem name:</b> {EVENT.NAME}<br><b>Host:</b> {HOST.NAME}<br><b>Severity:</b> {EVENT.SEVERITY}<br><b>Operational data:</b> {EVENT.OPDATA}<br><b>Original problem ID:</b> {EVENT.ID}<br>{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('12','4','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','<b>Problem has been resolved</b> at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}<br><b>Problem name:</b> {EVENT.NAME}<br><b>Problem duration:</b> {EVENT.DURATION}<br><b>Host:</b> {HOST.NAME}<br><b>Severity:</b> {EVENT.SEVERITY}<br><b>Original problem ID:</b> {EVENT.ID}<br>{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('13','4','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','<b>{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem</b> at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.<br>{EVENT.UPDATE.MESSAGE}<br><br><b>Current problem status:</b> {EVENT.STATUS}<br><b>Age:</b> {EVENT.AGE}<br><b>Acknowledged:</b> {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('14','4','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','<b>Discovery rule:</b> {DISCOVERY.RULE.NAME}<br><br><b>Device IP:</b> {DISCOVERY.DEVICE.IPADDRESS}<br><b>Device DNS:</b> {DISCOVERY.DEVICE.DNS}<br><b>Device status:</b> {DISCOVERY.DEVICE.STATUS}<br><b>Device uptime:</b> {DISCOVERY.DEVICE.UPTIME}<br><br><b>Device service name:</b> {DISCOVERY.SERVICE.NAME}<br><b>Device service port:</b> {DISCOVERY.SERVICE.PORT}<br><b>Device service status:</b> {DISCOVERY.SERVICE.STATUS}<br><b>Device service uptime:</b> {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('15','4','2','0','Autoregistration: {HOST.HOST}','<b>Host name:</b> {HOST.HOST}<br><b>Host IP:</b> {HOST.IP}<br><b>Agent port:</b> {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('16','11','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('17','11','0','1','Resolved: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('18','11','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('19','11','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('20','11','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('21','12','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('22','12','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('23','12','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('24','12','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('25','12','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('31','14','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('32','14','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('33','14','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('34','14','0','1','Resolved: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('35','14','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('36','15','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('37','15','0','1','Resolved: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('38','15','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('39','15','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('40','15','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('41','16','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('42','16','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('43','16','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('44','16','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('45','16','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('46','17','0','0','{EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('47','17','0','1','{EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('48','17','0','2','{EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('49','17','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('50','17','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('51','17','3','0','Internal problem: {EVENT.NAME}','Internal problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('52','18','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('53','18','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('54','18','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('55','18','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('56','18','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('57','19','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('58','19','0','1','Resolved: {EVENT.RECOVERY.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.RECOVERY.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('59','19','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('60','19','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('61','19','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('62','20','0','0','{EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('63','20','0','1','{EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('64','20','0','2','{EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('65','20','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('66','20','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('67','21','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('68','21','0','1','Resolved: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('69','21','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('70','21','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('71','21','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('72','10','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('73','10','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('74','10','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('75','10','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('76','10','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('77','22','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('78','22','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('79','22','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Problem duration: {EVENT.DURATION}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('80','5','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('81','5','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Problem duration: {EVENT.DURATION}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('82','5','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('83','5','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('84','5','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('85','6','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('86','6','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('87','6','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('88','6','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('89','6','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Problem duration: {EVENT.DURATION}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('90','7','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('91','7','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Problem duration: {EVENT.DURATION}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('92','7','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('93','7','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('94','7','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('95','8','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('96','8','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Problem duration: {EVENT.DURATION}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('97','8','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('98','8','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('99','8','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('100','9','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('101','9','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Problem duration: {EVENT.DURATION}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('102','9','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('103','9','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('104','9','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('105','23','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Trigger description: {TRIGGER.DESCRIPTION}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('106','23','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('107','23','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('108','23','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('109','23','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('110','24','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('111','24','0','1','Resolved: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('112','24','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('113','24','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('114','24','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('115','25','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('116','25','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Problem duration: {EVENT.DURATION}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('117','25','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('118','25','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('119','25','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('120','26','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('121','26','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('122','26','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('123','26','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('124','26','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('125','27','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('126','27','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('127','27','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('128','27','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('129','27','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('130','28','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('131','28','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Problem duration: {EVENT.DURATION}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('132','28','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('133','28','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('134','28','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('135','29','0','0','[{EVENT.STATUS}] {EVENT.NAME}','[{EVENT.STATUS}] {EVENT.NAME}' || chr(13) || chr(10) || 'Started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Event info: {$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('136','29','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','[{EVENT.STATUS}] {EVENT.NAME}' || chr(13) || chr(10) || 'Resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Event info: {$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('137','29','0','2','[{EVENT.STATUS}] {EVENT.NAME}','[{EVENT.STATUS}] {EVENT.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('138','29','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('139','29','2','0','Autoregistration: {HOST.HOST}','Autoregistration: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('140','30','0','0','[{EVENT.STATUS}] {EVENT.NAME}','[{EVENT.STATUS}] {EVENT.NAME}' || chr(13) || chr(10) || 'Started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Event info: {$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('141','30','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','[{EVENT.STATUS}] {EVENT.NAME}' || chr(13) || chr(10) || 'Resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Event info: {$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('142','30','0','2','[{EVENT.STATUS}] {EVENT.NAME}','[{EVENT.STATUS}] {EVENT.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('143','30','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('144','30','2','0','Autoregistration: {HOST.HOST}','Autoregistration: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('145','31','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('146','31','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('147','31','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('148','31','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('149','31','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('150','32','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('151','32','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('152','32','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('153','32','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('154','32','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('155','33','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('156','33','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('157','33','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('158','33','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('159','33','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('160','34','0','0','Problem: {EVENT.NAME}','<b>Problem started</b> at {EVENT.TIME} on {EVENT.DATE}<br><b>Problem name:</b> {EVENT.NAME}<br><b>Host:</b> {HOST.NAME}<br><b>Severity:</b> {EVENT.SEVERITY}<br><b>Operational data:</b> {EVENT.OPDATA}<br><b>Original problem ID:</b> {EVENT.ID}<br>{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('161','34','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','<b>Problem has been resolved</b> at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}<br><b>Problem name:</b> {EVENT.NAME}<br><b>Problem duration:</b> {EVENT.DURATION}<br><b>Host:</b> {HOST.NAME}<br><b>Severity:</b> {EVENT.SEVERITY}<br><b>Original problem ID:</b> {EVENT.ID}<br>{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('162','34','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','<b>{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem</b> at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.<br>{EVENT.UPDATE.MESSAGE}<br><br><b>Current problem status:</b> {EVENT.STATUS}<br><b>Age:</b> {EVENT.AGE}<br><b>Acknowledged:</b> {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('163','34','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','<b>Discovery rule:</b> {DISCOVERY.RULE.NAME}<br><br><b>Device IP:</b> {DISCOVERY.DEVICE.IPADDRESS}<br><b>Device DNS:</b> {DISCOVERY.DEVICE.DNS}<br><b>Device status:</b> {DISCOVERY.DEVICE.STATUS}<br><b>Device uptime:</b> {DISCOVERY.DEVICE.UPTIME}<br><br><b>Device service name:</b> {DISCOVERY.SERVICE.NAME}<br><b>Device service port:</b> {DISCOVERY.SERVICE.PORT}<br><b>Device service status:</b> {DISCOVERY.SERVICE.STATUS}<br><b>Device service uptime:</b> {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('164','34','2','0','Autoregistration: {HOST.HOST}','<b>Host name:</b> {HOST.HOST}<br><b>Host IP:</b> {HOST.IP}<br><b>Agent port:</b> {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('165','35','0','0','Problem: {EVENT.NAME}','<b>Problem started</b> at {EVENT.TIME} on {EVENT.DATE}<br><b>Problem name:</b> {EVENT.NAME}<br><b>Host:</b> {HOST.NAME}<br><b>Severity:</b> {EVENT.SEVERITY}<br><b>Operational data:</b> {EVENT.OPDATA}<br><b>Original problem ID:</b> {EVENT.ID}<br>{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('166','35','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','<b>Problem has been resolved</b> at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}<br><b>Problem name:</b> {EVENT.NAME}<br><b>Problem duration:</b> {EVENT.DURATION}<br><b>Host:</b> {HOST.NAME}<br><b>Severity:</b> {EVENT.SEVERITY}<br><b>Original problem ID:</b> {EVENT.ID}<br>{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('167','35','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','<b>{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem</b> at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.<br>{EVENT.UPDATE.MESSAGE}<br><br><b>Current problem status:</b> {EVENT.STATUS}<br><b>Age:</b> {EVENT.AGE}<br><b>Acknowledged:</b> {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('168','35','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','<b>Discovery rule:</b> {DISCOVERY.RULE.NAME}<br><br><b>Device IP:</b> {DISCOVERY.DEVICE.IPADDRESS}<br><b>Device DNS:</b> {DISCOVERY.DEVICE.DNS}<br><b>Device status:</b> {DISCOVERY.DEVICE.STATUS}<br><b>Device uptime:</b> {DISCOVERY.DEVICE.UPTIME}<br><br><b>Device service name:</b> {DISCOVERY.SERVICE.NAME}<br><b>Device service port:</b> {DISCOVERY.SERVICE.PORT}<br><b>Device service status:</b> {DISCOVERY.SERVICE.STATUS}<br><b>Device service uptime:</b> {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('169','35','2','0','Autoregistration: {HOST.HOST}','<b>Host name:</b> {HOST.HOST}<br><b>Host IP:</b> {HOST.IP}<br><b>Agent port:</b> {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('170','36','0','0','Problem: {EVENT.NAME}','<b>Problem started</b> at {EVENT.TIME} on {EVENT.DATE}<br><b>Problem name:</b> {EVENT.NAME}<br><b>Host:</b> {HOST.NAME}<br><b>Severity:</b> {EVENT.SEVERITY}<br><b>Operational data:</b> {EVENT.OPDATA}<br><b>Original problem ID:</b> {EVENT.ID}<br>{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('171','36','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','<b>Problem has been resolved</b> at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}<br><b>Problem name:</b> {EVENT.NAME}<br><b>Problem duration:</b> {EVENT.DURATION}<br><b>Host:</b> {HOST.NAME}<br><b>Severity:</b> {EVENT.SEVERITY}<br><b>Original problem ID:</b> {EVENT.ID}<br>{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('172','36','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','<b>{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem</b> at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.<br>{EVENT.UPDATE.MESSAGE}<br><br><b>Current problem status:</b> {EVENT.STATUS}<br><b>Age:</b> {EVENT.AGE}<br><b>Acknowledged:</b> {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('173','36','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','<b>Discovery rule:</b> {DISCOVERY.RULE.NAME}<br><br><b>Device IP:</b> {DISCOVERY.DEVICE.IPADDRESS}<br><b>Device DNS:</b> {DISCOVERY.DEVICE.DNS}<br><b>Device status:</b> {DISCOVERY.DEVICE.STATUS}<br><b>Device uptime:</b> {DISCOVERY.DEVICE.UPTIME}<br><br><b>Device service name:</b> {DISCOVERY.SERVICE.NAME}<br><b>Device service port:</b> {DISCOVERY.SERVICE.PORT}<br><b>Device service status:</b> {DISCOVERY.SERVICE.STATUS}<br><b>Device service uptime:</b> {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('174','36','2','0','Autoregistration: {HOST.HOST}','<b>Host name:</b> {HOST.HOST}<br><b>Host IP:</b> {HOST.IP}<br><b>Agent port:</b> {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('175','37','0','0','Problem: {EVENT.NAME}','<b>Problem started</b> at {EVENT.TIME} on {EVENT.DATE}<br><b>Problem name:</b> {EVENT.NAME}<br><b>Host:</b> {HOST.NAME}<br><b>Severity:</b> {EVENT.SEVERITY}<br><b>Operational data:</b> {EVENT.OPDATA}<br><b>Original problem ID:</b> {EVENT.ID}<br>{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('176','37','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','<b>Problem has been resolved</b> at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}<br><b>Problem name:</b> {EVENT.NAME}<br><b>Problem duration:</b> {EVENT.DURATION}<br><b>Host:</b> {HOST.NAME}<br><b>Severity:</b> {EVENT.SEVERITY}<br><b>Original problem ID:</b> {EVENT.ID}<br>{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('177','37','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','<b>{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem</b> at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.<br>{EVENT.UPDATE.MESSAGE}<br><br><b>Current problem status:</b> {EVENT.STATUS}<br><b>Age:</b> {EVENT.AGE}<br><b>Acknowledged:</b> {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('178','37','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','<b>Discovery rule:</b> {DISCOVERY.RULE.NAME}<br><br><b>Device IP:</b> {DISCOVERY.DEVICE.IPADDRESS}<br><b>Device DNS:</b> {DISCOVERY.DEVICE.DNS}<br><b>Device status:</b> {DISCOVERY.DEVICE.STATUS}<br><b>Device uptime:</b> {DISCOVERY.DEVICE.UPTIME}<br><br><b>Device service name:</b> {DISCOVERY.SERVICE.NAME}<br><b>Device service port:</b> {DISCOVERY.SERVICE.PORT}<br><b>Device service status:</b> {DISCOVERY.SERVICE.STATUS}<br><b>Device service uptime:</b> {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('179','37','2','0','Autoregistration: {HOST.HOST}','<b>Host name:</b> {HOST.HOST}<br><b>Host IP:</b> {HOST.IP}<br><b>Agent port:</b> {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('180','10','4','0','Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Service problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Service problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Service: {SERVICE.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || 'Service description: {SERVICE.DESCRIPTION}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '{SERVICE.ROOTCAUSE}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('181','10','4','1','Service "{SERVICE.NAME}" resolved in {EVENT.DURATION}: {EVENT.NAME}','Service "{SERVICE.NAME}" has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Problem duration: {EVENT.DURATION}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || 'Service description: {SERVICE.DESCRIPTION}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('182','10','4','2','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} in {EVENT.AGE}','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || 'Current problem age is {EVENT.AGE}.' || chr(13) || chr(10) || 'Service description: {SERVICE.DESCRIPTION}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '{SERVICE.ROOTCAUSE}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('183','14','4','0','Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Service problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Service problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Service: {SERVICE.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || 'Service description: {SERVICE.DESCRIPTION}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '{SERVICE.ROOTCAUSE}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('184','14','4','1','Service "{SERVICE.NAME}" resolved in {EVENT.DURATION}: {EVENT.NAME}','Service "{SERVICE.NAME}" has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Problem duration: {EVENT.DURATION}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || 'Service description: {SERVICE.DESCRIPTION}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('185','14','4','2','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} in {EVENT.AGE}','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || 'Current problem age is {EVENT.AGE}.' || chr(13) || chr(10) || 'Service description: {SERVICE.DESCRIPTION}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '{SERVICE.ROOTCAUSE}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('186','38','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('187','38','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Problem duration: {EVENT.DURATION}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('188','38','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('189','38','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('190','38','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('191','39','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('192','39','0','1','Resolved: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('193','39','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('194','39','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('195','39','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('196','40','0','0','Event ID: {EVENT.ID}, Host: {HOST.HOST}, Problem: {EVENT.NAME}','')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('197','41','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('198','41','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('199','41','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('200','41','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('201','41','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('202','41','3','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('203','41','3','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}')
/

INSERT INTO usrgrp (usrgrpid,name,gui_access,users_status,debug_mode,userdirectoryid,mfa_status,mfaid)
values ('7','Zabbix administrators','0','0','0',NULL,'0',NULL)
/

INSERT INTO usrgrp (usrgrpid,name,gui_access,users_status,debug_mode,userdirectoryid,mfa_status,mfaid)
values ('8','Guests','0','0','0',NULL,'0',NULL)
/

INSERT INTO usrgrp (usrgrpid,name,gui_access,users_status,debug_mode,userdirectoryid,mfa_status,mfaid)
values ('9','Disabled','0','1','0',NULL,'0',NULL)
/

INSERT INTO usrgrp (usrgrpid,name,gui_access,users_status,debug_mode,userdirectoryid,mfa_status,mfaid)
values ('11','Enabled debug mode','0','0','1',NULL,'0',NULL)
/

INSERT INTO usrgrp (usrgrpid,name,gui_access,users_status,debug_mode,userdirectoryid,mfa_status,mfaid)
values ('12','No access to the frontend','3','0','0',NULL,'0',NULL)
/

INSERT INTO usrgrp (usrgrpid,name,gui_access,users_status,debug_mode,userdirectoryid,mfa_status,mfaid)
values ('13','Internal','1','0','0',NULL,'0',NULL)
/

INSERT INTO users_groups (id,usrgrpid,userid)
values ('2','8','2')
/

INSERT INTO users_groups (id,usrgrpid,userid)
values ('3','9','2')
/

INSERT INTO users_groups (id,usrgrpid,userid)
values ('4','7','1')
/

INSERT INTO users_groups (id,usrgrpid,userid)
values ('5','13','1')
/

INSERT INTO users_groups (id,usrgrpid,userid)
values ('6','13','2')
/

INSERT INTO ugset_group (ugsetid,usrgrpid)
values ('1','13')
/

INSERT INTO ugset_group (ugsetid,usrgrpid)
values ('1','8')
/

INSERT INTO ugset_group (ugsetid,usrgrpid)
values ('1','9')
/

INSERT INTO user_ugset (userid,ugsetid)
values ('2','1')
/

INSERT INTO scripts (scriptid,name,command,host_access,usrgrpid,groupid,description,confirmation,type,execute_on,timeout,scope,port,authtype,username,password,publickey,privatekey,menu_path,url,new_window,manualinput,manualinput_prompt,manualinput_validator,manualinput_validator_type,manualinput_default_value)
values ('1','Ping','ping -c 3 {HOST.CONN}; case $? in [01]) true;; *) false;; esac','2',NULL,NULL,'','','0','2','30s','2','','0','','','','','','','1','0','','','0','')
/

INSERT INTO scripts (scriptid,name,command,host_access,usrgrpid,groupid,description,confirmation,type,execute_on,timeout,scope,port,authtype,username,password,publickey,privatekey,menu_path,url,new_window,manualinput,manualinput_prompt,manualinput_validator,manualinput_validator_type,manualinput_default_value)
values ('2','Traceroute','/usr/bin/traceroute {HOST.CONN}','2',NULL,NULL,'','','0','2','30s','2','','0','','','','','','','1','0','','','0','')
/

INSERT INTO scripts (scriptid,name,command,host_access,usrgrpid,groupid,description,confirmation,type,execute_on,timeout,scope,port,authtype,username,password,publickey,privatekey,menu_path,url,new_window,manualinput,manualinput_prompt,manualinput_validator,manualinput_validator_type,manualinput_default_value)
values ('3','Detect operating system','sudo /usr/bin/nmap -O {HOST.CONN}','2','7',NULL,'','','0','2','30s','2','','0','','','','','','','1','0','','','0','')
/

INSERT INTO actions (actionid,name,eventsource,evaltype,status,esc_period,formula,pause_suppressed,notify_if_canceled,pause_symptoms)
values ('2','Auto discovery. Linux servers.','1','0','1','0','','1','1','1')
/

INSERT INTO actions (actionid,name,eventsource,evaltype,status,esc_period,formula,pause_suppressed,notify_if_canceled,pause_symptoms)
values ('3','Report problems to Zabbix administrators','0','0','1','1h','','1','1','1')
/

INSERT INTO actions (actionid,name,eventsource,evaltype,status,esc_period,formula,pause_suppressed,notify_if_canceled,pause_symptoms)
values ('4','Report not supported items','3','0','1','1h','','1','1','1')
/

INSERT INTO actions (actionid,name,eventsource,evaltype,status,esc_period,formula,pause_suppressed,notify_if_canceled,pause_symptoms)
values ('5','Report not supported low level discovery rules','3','0','1','1h','','1','1','1')
/

INSERT INTO actions (actionid,name,eventsource,evaltype,status,esc_period,formula,pause_suppressed,notify_if_canceled,pause_symptoms)
values ('6','Report unknown triggers','3','0','1','1h','','1','1','1')
/

INSERT INTO operations (operationid,actionid,operationtype,esc_period,esc_step_from,esc_step_to,evaltype,recovery)
values ('1','2','6','0','1','1','0','0')
/

INSERT INTO operations (operationid,actionid,operationtype,esc_period,esc_step_from,esc_step_to,evaltype,recovery)
values ('2','2','4','0','1','1','0','0')
/

INSERT INTO operations (operationid,actionid,operationtype,esc_period,esc_step_from,esc_step_to,evaltype,recovery)
values ('3','3','0','0','1','1','0','0')
/

INSERT INTO operations (operationid,actionid,operationtype,esc_period,esc_step_from,esc_step_to,evaltype,recovery)
values ('4','4','0','0','1','1','0','0')
/

INSERT INTO operations (operationid,actionid,operationtype,esc_period,esc_step_from,esc_step_to,evaltype,recovery)
values ('5','5','0','0','1','1','0','0')
/

INSERT INTO operations (operationid,actionid,operationtype,esc_period,esc_step_from,esc_step_to,evaltype,recovery)
values ('6','6','0','0','1','1','0','0')
/

INSERT INTO operations (operationid,actionid,operationtype,esc_period,esc_step_from,esc_step_to,evaltype,recovery)
values ('7','3','11','0','1','1','0','1')
/

INSERT INTO operations (operationid,actionid,operationtype,esc_period,esc_step_from,esc_step_to,evaltype,recovery)
values ('8','4','11','0','1','1','0','1')
/

INSERT INTO operations (operationid,actionid,operationtype,esc_period,esc_step_from,esc_step_to,evaltype,recovery)
values ('9','5','11','0','1','1','0','1')
/

INSERT INTO operations (operationid,actionid,operationtype,esc_period,esc_step_from,esc_step_to,evaltype,recovery)
values ('10','6','11','0','1','1','0','1')
/

INSERT INTO opmessage (operationid,default_msg,subject,message,mediatypeid)
values ('3','1','','',NULL)
/

INSERT INTO opmessage (operationid,default_msg,subject,message,mediatypeid)
values ('4','1','','',NULL)
/

INSERT INTO opmessage (operationid,default_msg,subject,message,mediatypeid)
values ('5','1','','',NULL)
/

INSERT INTO opmessage (operationid,default_msg,subject,message,mediatypeid)
values ('6','1','','',NULL)
/

INSERT INTO opmessage (operationid,default_msg,subject,message,mediatypeid)
values ('7','1','','',NULL)
/

INSERT INTO opmessage (operationid,default_msg,subject,message,mediatypeid)
values ('8','1','','',NULL)
/

INSERT INTO opmessage (operationid,default_msg,subject,message,mediatypeid)
values ('9','1','','',NULL)
/

INSERT INTO opmessage (operationid,default_msg,subject,message,mediatypeid)
values ('10','1','','',NULL)
/

INSERT INTO opmessage_grp (opmessage_grpid,operationid,usrgrpid)
values ('1','3','7')
/

INSERT INTO opmessage_grp (opmessage_grpid,operationid,usrgrpid)
values ('2','4','7')
/

INSERT INTO opmessage_grp (opmessage_grpid,operationid,usrgrpid)
values ('3','5','7')
/

INSERT INTO opmessage_grp (opmessage_grpid,operationid,usrgrpid)
values ('4','6','7')
/

INSERT INTO opgroup (opgroupid,operationid,groupid)
values ('1','2','2')
/

INSERT INTO conditions (conditionid,actionid,conditiontype,operator,value,value2)
values ('2','2','10','0','0','')
/

INSERT INTO conditions (conditionid,actionid,conditiontype,operator,value,value2)
values ('3','2','8','0','9','')
/

INSERT INTO conditions (conditionid,actionid,conditiontype,operator,value,value2)
values ('4','2','12','2','Linux','')
/

INSERT INTO conditions (conditionid,actionid,conditiontype,operator,value,value2)
values ('6','4','23','0','0','')
/

INSERT INTO conditions (conditionid,actionid,conditiontype,operator,value,value2)
values ('7','5','23','0','2','')
/

INSERT INTO conditions (conditionid,actionid,conditiontype,operator,value,value2)
values ('8','6','23','0','4','')
/

INSERT INTO config (configid,work_period,alert_usrgrpid,discovery_groupid,dbversion_status,geomaps_tile_provider,ldap_userdirectoryid,server_status,mfaid,software_update_check_data)
values ('1','1-5,09:00-18:00','7','5','','OpenStreetMap.Mapnik',NULL,'',NULL,'')
/

INSERT INTO graph_theme (graphthemeid,theme,backgroundcolor,graphcolor,gridcolor,maingridcolor,gridbordercolor,textcolor,highlightcolor,leftpercentilecolor,rightpercentilecolor,nonworktimecolor,colorpalette)
values ('1','blue-theme','FFFFFF','FFFFFF','CCD5D9','ACBBC2','ACBBC2','1F2C33','E33734','429E47','E33734','EBEBEB','1A7C11,F63100,2774A4,A54F10,FC6EA3,6C59DC,AC8C14,611F27,F230E0,5CCD18,BB2A02,5A2B57,89ABF8,7EC25C,274482,2B5429,8048B4,FD5434,790E1F,87AC4D,E89DF4')
/

INSERT INTO graph_theme (graphthemeid,theme,backgroundcolor,graphcolor,gridcolor,maingridcolor,gridbordercolor,textcolor,highlightcolor,leftpercentilecolor,rightpercentilecolor,nonworktimecolor,colorpalette)
values ('2','dark-theme','2B2B2B','2B2B2B','454545','4F4F4F','4F4F4F','F2F2F2','E45959','59DB8F','E45959','333333','199C0D,F63100,2774A4,F7941D,FC6EA3,6C59DC,C7A72D,BA2A5D,F230E0,5CCD18,BB2A02,AC41A5,89ABF8,7EC25C,3165D5,79A277,AA73DE,FD5434,F21C3E,87AC4D,E89DF4')
/

INSERT INTO graph_theme (graphthemeid,theme,backgroundcolor,graphcolor,gridcolor,maingridcolor,gridbordercolor,textcolor,highlightcolor,leftpercentilecolor,rightpercentilecolor,nonworktimecolor,colorpalette)
values ('3','hc-light','FFFFFF','FFFFFF','555555','000000','333333','000000','333333','000000','000000','EBEBEB','1A7C11,F63100,2774A4,A54F10,FC6EA3,6C59DC,AC8C14,611F27,F230E0,5CCD18,BB2A02,5A2B57,89ABF8,7EC25C,274482,2B5429,8048B4,FD5434,790E1F,87AC4D,E89DF4')
/

INSERT INTO graph_theme (graphthemeid,theme,backgroundcolor,graphcolor,gridcolor,maingridcolor,gridbordercolor,textcolor,highlightcolor,leftpercentilecolor,rightpercentilecolor,nonworktimecolor,colorpalette)
values ('4','hc-dark','000000','000000','666666','888888','4F4F4F','FFFFFF','FFFFFF','FFFFFF','FFFFFF','333333','199C0D,F63100,2774A4,F7941D,FC6EA3,6C59DC,C7A72D,BA2A5D,F230E0,5CCD18,BB2A02,AC41A5,89ABF8,7EC25C,3165D5,79A277,AA73DE,FD5434,F21C3E,87AC4D,E89DF4')
/

INSERT INTO globalmacro (globalmacroid,macro,value,description,type)
values ('2','{$SNMP_COMMUNITY}','public','','0')
/

INSERT INTO regexps (regexpid,name,test_string)
values ('1','File systems for discovery','ext3')
/

INSERT INTO regexps (regexpid,name,test_string)
values ('2','Network interfaces for discovery','eth0')
/

INSERT INTO regexps (regexpid,name,test_string)
values ('3','Storage devices for SNMP discovery','/boot')
/

INSERT INTO regexps (regexpid,name,test_string)
values ('4','Windows service names for discovery','SysmonLog')
/

INSERT INTO regexps (regexpid,name,test_string)
values ('5','Windows service startup states for discovery','automatic')
/

INSERT INTO expressions (expressionid,regexpid,expression,expression_type,exp_delimiter,case_sensitive)
values ('1','1','^(btrfs|ext2|ext3|ext4|reiser|xfs|ffs|ufs|jfs|jfs2|vxfs|hfs|apfs|refs|ntfs|fat32|zfs)$','3',',','0')
/

INSERT INTO expressions (expressionid,regexpid,expression,expression_type,exp_delimiter,case_sensitive)
values ('3','3','^(Physical memory|Virtual memory|Memory buffers|Cached memory|Swap space)$','4',',','1')
/

INSERT INTO expressions (expressionid,regexpid,expression,expression_type,exp_delimiter,case_sensitive)
values ('5','4','^(MMCSS|gupdate|SysmonLog|clr_optimization_v2.0.50727_32|clr_optimization_v4.0.30319_32)$','4',',','1')
/

INSERT INTO expressions (expressionid,regexpid,expression,expression_type,exp_delimiter,case_sensitive)
values ('6','5','^(automatic|automatic delayed)$','3',',','1')
/

INSERT INTO expressions (expressionid,regexpid,expression,expression_type,exp_delimiter,case_sensitive)
values ('7','2','^Software Loopback Interface','4',',','1')
/

INSERT INTO expressions (expressionid,regexpid,expression,expression_type,exp_delimiter,case_sensitive)
values ('8','2','^(In)?[Ll]oop[Bb]ack[0-9._]*$','4',',','1')
/

INSERT INTO expressions (expressionid,regexpid,expression,expression_type,exp_delimiter,case_sensitive)
values ('9','2','^NULL[0-9.]*$','4',',','1')
/

INSERT INTO expressions (expressionid,regexpid,expression,expression_type,exp_delimiter,case_sensitive)
values ('10','2','^[Ll]o[0-9.]*$','4',',','1')
/

INSERT INTO expressions (expressionid,regexpid,expression,expression_type,exp_delimiter,case_sensitive)
values ('11','2','^[Ss]ystem$','4',',','1')
/

INSERT INTO expressions (expressionid,regexpid,expression,expression_type,exp_delimiter,case_sensitive)
values ('12','2','^Nu[0-9.]*$','4',',','1')
/

INSERT INTO config_autoreg_tls (autoreg_tlsid,tls_psk_identity,tls_psk)
values ('1','','')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('1','actionlog','widgets/actionlog','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('2','clock','widgets/clock','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('3','dataover','widgets/dataover','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('4','discovery','widgets/discovery','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('5','favgraphs','widgets/favgraphs','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('6','favmaps','widgets/favmaps','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('7','geomap','widgets/geomap','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('8','graph','widgets/graph','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('9','graphprototype','widgets/graphprototype','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('10','hostavail','widgets/hostavail','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('11','item','widgets/item','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('12','map','widgets/map','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('13','navtree','widgets/navtree','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('14','itemhistory','widgets/itemhistory','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('15','problemhosts','widgets/problemhosts','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('16','problems','widgets/problems','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('17','problemsbysv','widgets/problemsbysv','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('18','slareport','widgets/slareport','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('19','svggraph','widgets/svggraph','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('20','systeminfo','widgets/systeminfo','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('21','tophosts','widgets/tophosts','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('22','trigover','widgets/trigover','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('23','url','widgets/url','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('24','web','widgets/web','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('25','gauge','widgets/gauge','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('26','toptriggers','widgets/toptriggers','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('27','piechart','widgets/piechart','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('28','honeycomb','widgets/honeycomb','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('29','hostnavigator','widgets/hostnavigator','1','[]')
/

INSERT INTO module (moduleid,id,relative_path,status,config)
values ('30','itemnavigator','widgets/itemnavigator','1','[]')
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('1','1','0','ui.default_access','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('2','1','0','services.read','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('3','1','0','services.write','0','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('4','1','0','modules.default_access','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('5','1','0','api.access','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('6','1','0','api.mode','0','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('7','1','0','actions.default_access','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('8','2','0','ui.default_access','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('9','2','0','services.read','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('10','2','0','services.write','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('11','2','0','modules.default_access','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('12','2','0','api.access','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('13','2','0','api.mode','0','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('14','2','0','actions.default_access','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('15','3','0','ui.default_access','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('16','3','0','services.read','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('17','3','0','services.write','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('18','3','0','modules.default_access','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('19','3','0','api.access','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('20','3','0','api.mode','0','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('21','3','0','actions.default_access','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('22','4','0','ui.default_access','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('23','4','0','services.read','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('24','4','0','services.write','0','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('25','4','0','modules.default_access','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('26','4','0','api.access','0','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('27','4','0','actions.default_access','0','',NULL,NULL)
/

INSERT INTO hgset (hgsetid,hash)
values ('1','e629fa6598d732768f7c726b4b621285f9c3b85303900aa912017db7617d8bdb')
/

INSERT INTO hgset (hgsetid,hash)
values ('2','4ec9599fc203d176a301536c2e091a19bc852759b255bd6818810a42c5fed14a')
/

INSERT INTO hgset (hgsetid,hash)
values ('3','4523540f1504cd17100c4835e85b7eefd49911580f8efff0599a8f283be6b9e3')
/

INSERT INTO hgset (hgsetid,hash)
values ('4','ef8704ac79657fbf2818c74a70a571c131283abd8914eca173cd032929702789')
/

INSERT INTO hgset (hgsetid,hash)
values ('5','6f4b6612125fb3a0daecd2799dfd6c9c299424fd920f9b308110a2c1fbd8f443')
/

INSERT INTO hgset (hgsetid,hash)
values ('6','4b227777d4dd1fc61c6f884f48641d02b4d121d3fd328cb08b5531fcacdabf8a')
/

INSERT INTO hgset (hgsetid,hash)
values ('7','19581e27de7ced00ff1ce50b2047e7a567c76b1cbaebabe5ef03f7c3017bb5b7')
/

INSERT INTO hgset (hgsetid,hash)
values ('8','6b51d431df5d7f141cbececcf79edf3dd861c3b4069f0b11661a3eefacbba918')
/

INSERT INTO hgset (hgsetid,hash)
values ('9','b17ef6d19c7a5b1ee83b907c595526dcb1eb06db8227d650d5dda0a9f4ce8cd9')
/

INSERT INTO hgset (hgsetid,hash)
values ('10','4fc82b26aecb47d2868c4efbe3581732a3e7cbcc6c2efb32062c08170a05eeb8')
/

INSERT INTO hgset (hgsetid,hash)
values ('11','4a44dc15364204a80fe80e9039455cc1608281820fe2b24f1e5233ade6af1dd5')
/

INSERT INTO hgset (hgsetid,hash)
values ('12','3fdba35f04dc8c462986c992bcf875546257113072a909c162f7e470e581e278')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10001',NULL,'Linux by Zabbix agent','3','-1','2','','','Linux by Zabbix agent','0',NULL,'This is an official Linux template. It requires Zabbix agent 7.0 or newer.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Notes on filesystem (FS) discovery:' || chr(13) || chr(10) || '- The ext4/3/2 filesystem reserves space for privileged usage, typically set at 5% by default.' || chr(13) || chr(10) || '- BTRFS allocates a default of 10% of the volume for its own needs.' || chr(13) || chr(10) || '- To mitigate potential disasters, FS usage triggers are based on the maximum available space.' || chr(13) || chr(10) || '  - Utilization formula: ''pused = 100 - 100 * (available / total - free + available)''' || chr(13) || chr(10) || '- The FS utilization chart, derived from graph prototypes, reflects FS reserved space as the difference between used and available space from the total volume.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387225-discussion-thread-for-official-zabbix-template-for-linux' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','f8f7908280354f2abeed07dc788c3747','LINUX BY ZABBIX AGENT','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10047',NULL,'Zabbix server health','3','-1','2','','','Zabbix server health','0',NULL,'This template is designed to monitor internal Zabbix metrics on the local Zabbix server.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Link this template to the local Zabbix server host.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e2d2b4e4ac28483996cc11fe42823d57','ZABBIX SERVER HEALTH','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10048',NULL,'Zabbix proxy health','3','-1','2','','','Zabbix proxy health','0',NULL,'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','dd114bf0fb2f46bc84840f1bb24e2b23','ZABBIX PROXY HEALTH','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10074',NULL,'OpenBSD by Zabbix agent','3','-1','2','','','OpenBSD by Zabbix agent','0',NULL,'This is an Official OpenBSD template. It requires Zabbix agent 7.0 or newer.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Notes on filesystem (FS) discovery:' || chr(13) || chr(10) || '  - The ext4/3/2 FS reserves space for privileged usage, typically set at 5% by default.' || chr(13) || chr(10) || '  - BTRFS allocates a default of 10% of the volume for its own needs.' || chr(13) || chr(10) || '  - To mitigate potential disasters, FS usage triggers are based on the maximum available space.' || chr(13) || chr(10) || '    - Utilization formula: ''pused = 100 - 100 * (available / total - free + available)''' || chr(13) || chr(10) || '  - The FS utilization chart, derived from graph prototypes, reflects FS reserved space as the difference between used and available space from the total volume.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','760be6e1c2194a5bb7c0df47cc5f71ca','OPENBSD BY ZABBIX AGENT','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10075',NULL,'FreeBSD by Zabbix agent','3','-1','2','','','FreeBSD by Zabbix agent','0',NULL,'This is an official FreeBSD template. It requires Zabbix agent 7.0 or newer.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Notes on filesystem (FS) discovery:' || chr(13) || chr(10) || '  - The ext4/3/2 FS reserves space for privileged usage, typically set at 5% by default.' || chr(13) || chr(10) || '  - BTRFS allocates a default of 10% of the volume for its own needs.' || chr(13) || chr(10) || '  - To mitigate potential disasters, FS usage triggers are based on the maximum available space.' || chr(13) || chr(10) || '    - Utilization formula: ''pused = 100 - 100 * (available / total - free + available)''' || chr(13) || chr(10) || '  - The FS utilization chart, derived from graph prototypes, reflects FS reserved space as the difference between used and available space from the total volume.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','a3dc630729e443139f4e608954fa6e19','FREEBSD BY ZABBIX AGENT','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10076',NULL,'AIX by Zabbix agent','3','-1','2','','','AIX by Zabbix agent','0',NULL,'This is an official AIX template. It requires Zabbix agent 7.0 or newer.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Notes on filesystem (FS) discovery:' || chr(13) || chr(10) || '  - The ext4/3/2 FS reserves space for privileged usage, typically set at 5% by default.' || chr(13) || chr(10) || '  - BTRFS allocates a default of 10% of the volume for its own needs.' || chr(13) || chr(10) || '  - To mitigate potential disasters, FS usage triggers are based on the maximum available space.' || chr(13) || chr(10) || '    - Utilization formula: ''pused = 100 - 100 * (available / total - free + available)''' || chr(13) || chr(10) || '  - The FS utilization chart, derived from graph prototypes, reflects FS reserved space as the difference between used and available space from the total volume.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','7e6bb0931a72459db9514aa924b420bc','AIX BY ZABBIX AGENT','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10077',NULL,'HP-UX by Zabbix agent','3','-1','2','','','HP-UX by Zabbix agent','0',NULL,'This is an official HP-UX template. It requires Zabbix agent 7.0 or newer.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Notes on filesystem (FS) discovery:' || chr(13) || chr(10) || '  - The ext4/3/2 FS reserves space for privileged usage, typically set at 5% by default.' || chr(13) || chr(10) || '  - BTRFS allocates a default of 10% of the volume for its own needs.' || chr(13) || chr(10) || '  - To mitigate potential disasters, FS usage triggers are based on the maximum available space.' || chr(13) || chr(10) || '    - Utilization formula: ''pused = 100 - 100 * (available / total - free + available)''' || chr(13) || chr(10) || '  - The FS utilization chart, derived from graph prototypes, reflects FS reserved space as the difference between used and available space from the total volume.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','b1fd823d262042e08291313f72be9452','HP-UX BY ZABBIX AGENT','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10078',NULL,'Solaris by Zabbix agent','3','-1','2','','','Solaris by Zabbix agent','0',NULL,'This is an official Solaris OS template. It requires Zabbix agent 7.0 or newer.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Notes on filesystem (FS) discovery:' || chr(13) || chr(10) || '  - The ext4/3/2 FS reserves space for privileged usage, typically set at 5% by default.' || chr(13) || chr(10) || '  - BTRFS allocates a default of 10% of the volume for its own needs.' || chr(13) || chr(10) || '  - To mitigate potential disasters, FS usage triggers are based on the maximum available space.' || chr(13) || chr(10) || '    - Utilization formula: ''pused = 100 - 100 * (available / total - free + available)''' || chr(13) || chr(10) || '  - The FS utilization chart, derived from graph prototypes, reflects FS reserved space as the difference between used and available space from the total volume.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','eaf36c98b91843b7b79bd5184a23d377','SOLARIS BY ZABBIX AGENT','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10079',NULL,'macOS by Zabbix agent','3','-1','2','','','macOS by Zabbix agent','0',NULL,'This is an official macOS template. It requires Zabbix agent 7.0 or newer.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Notes on filesystem (FS) discovery:' || chr(13) || chr(10) || '  - The ext4/3/2 FS reserves space for privileged usage, typically set at 5% by default.' || chr(13) || chr(10) || '  - BTRFS allocates a default of 10% of the volume for its own needs.' || chr(13) || chr(10) || '  - To mitigate potential disasters, FS usage triggers are based on the maximum available space.' || chr(13) || chr(10) || '    - Utilization formula: ''pused = 100 - 100 * (available / total - free + available)''' || chr(13) || chr(10) || '  - The FS utilization chart, derived from graph prototypes, reflects FS reserved space as the difference between used and available space from the total volume.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','f895df5b37494f668cde1a2388d7af8b','MACOS BY ZABBIX AGENT','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10081',NULL,'Windows by Zabbix agent','3','-1','2','','','Windows by Zabbix agent','0',NULL,'This is an official Windows template. It requires Zabbix agent 7.0 or newer.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387224-discussion-thread-for-official-zabbix-template-for-windows' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','13b06904a6bf41cbb795e3193d896340','WINDOWS BY ZABBIX AGENT','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10084',NULL,'Zabbix server','0','-1','2','','','Zabbix server','0',NULL,'','1','1','','','','','0','0','','ZABBIX SERVER','','',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10169',NULL,'Generic Java JMX','3','-1','2','','','Generic Java JMX','0',NULL,'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','72aab08f7f27406a8f2c291648e5ba95','GENERIC JAVA JMX','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10171',NULL,'Intel SR1530 IPMI','3','-1','2','','','Intel SR1530 IPMI','0',NULL,'Template for monitoring Intel SR1530 server system.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','f01bd64eef4049fabe087cccae590226','INTEL SR1530 IPMI','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10172',NULL,'Intel SR1630 IPMI','3','-1','2','','','Intel SR1630 IPMI','0',NULL,'Template for monitoring Intel SR1630 server system.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','2327c665b46e4aa781d41240168c3867','INTEL SR1630 IPMI','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10173',NULL,'VMware','3','-1','2','','','VMware','0',NULL,'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Note: To enable discovery of hardware sensors of VMware Hypervisors, set the macro ''{$VMWARE.HV.SENSOR.DISCOVERY}'' to the value ''true'' on the discovered host level.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','56079badd056419383cc26e6a4fcc7e0','VMWARE','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10174',NULL,'VMware Guest','3','-1','2','','','VMware Guest','0',NULL,'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','7942fb93ae3b47cf9ca0ea4beb0675ce','VMWARE GUEST','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10175',NULL,'VMware Hypervisor','3','-1','2','','','VMware Hypervisor','0',NULL,'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','5899b2f0aced4085b5ac25d0461b3425','VMWARE HYPERVISOR','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10207',NULL,'Alcatel Timetra TiMOS by SNMP','3','-1','2','','','Alcatel Timetra TiMOS by SNMP','0',NULL,'Template Net Alcatel Timetra TiMOS' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'EtherLike-MIB' || chr(13) || chr(10) || 'TIMETRA-SYSTEM-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'TIMETRA-CHASSIS-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','53044571fb864d87af32473e08c76d0b','ALCATEL TIMETRA TIMOS BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10208',NULL,'Brocade FC by SNMP','3','-1','2','','','Brocade FC by SNMP','0',NULL,'Template Net Brocade FC' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'SW-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: no IF-MIB::ifAlias is available' || chr(13) || chr(10) || '  Version: v6.3.1c, v7.0.0c,  v7.4.1c' || chr(13) || chr(10) || '  Device: all' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','de96d02bd5f242bfa31308ae2131d03f','BROCADE FC BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10210',NULL,'Brocade_Foundry Nonstackable by SNMP','3','-1','2','','','Brocade_Foundry Nonstackable by SNMP','0',NULL,'Template Net Brocade Foundry Nonstackable' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'FOUNDRY-SN-AGENT-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','6ecfb7083ddf45f183ab4be50cfba37a','BROCADE_FOUNDRY NONSTACKABLE BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10211',NULL,'Brocade_Foundry Stackable by SNMP','3','-1','2','','','Brocade_Foundry Stackable by SNMP','0',NULL,'Template Brocade Foundry Stackable' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'FOUNDRY-SN-AGENT-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'FOUNDRY-SN-STACKING-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Correct fan(returns fan status as ''other(1)'' and temperature (returns 0) for the non-master Switches are not available in SNMP' || chr(13) || chr(10) || '  Version: Version 08.0.40b and above' || chr(13) || chr(10) || '  Device: ICX 7750 in stack' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','f64ad01567914165a493815e492fb315','BROCADE_FOUNDRY STACKABLE BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10218',NULL,'Cisco IOS by SNMP','3','-1','2','','','Cisco IOS by SNMP','0',NULL,'Template Cisco IOS Software releases 12.2(3.5) or later' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'CISCO-MEMORY-POOL-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || 'EtherLike-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'CISCO-ENVMON-MIB' || chr(13) || chr(10) || 'CISCO-PROCESS-MIB' || chr(13) || chr(10) || 'ENTITY-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: no if(in|out)(Errors|Discards) are available for vlan ifType' || chr(13) || chr(10) || '  Version: IOS for example: 12.1(22)EA11, 15.4(3)M2' || chr(13) || chr(10) || '  Device: C2911, C7600' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','aa3ce9bd8c1d40a2b0f83f9e642e88ee','CISCO IOS BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10220',NULL,'Cisco IOS prior to 12.0_3_T by SNMP','3','-1','2','','','Cisco IOS prior to 12.0_3_T by SNMP','0',NULL,'Cisco IOS Software releases prior to 12.0(3)T' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'OLD-CISCO-CPU-MIB' || chr(13) || chr(10) || 'CISCO-ENVMON-MIB' || chr(13) || chr(10) || 'CISCO-MEMORY-POOL-MIB' || chr(13) || chr(10) || 'ENTITY-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','1bb42fbdb9054645a62ff81f14ba3b99','CISCO IOS PRIOR TO 12.0_3_T BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10221',NULL,'Dell Force S-Series by SNMP','3','-1','2','','','Dell Force S-Series by SNMP','0',NULL,'Template Dell Force S-Series' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'F10-S-SERIES-CHASSIS-MIB' || chr(13) || chr(10) || 'EtherLike-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e5ec7acc7efc4ac491b6fa552ab077ae','DELL FORCE S-SERIES BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10222',NULL,'D-Link DES 7200 by SNMP','3','-1','2','','','D-Link DES 7200 by SNMP','0',NULL,'Template D-Link DES 7200' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'ENTITY-MIBdescription has changed' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || 'MY-PROCESS-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MY-MEMORY-MIB' || chr(13) || chr(10) || 'ENTITY-MIB' || chr(13) || chr(10) || 'MY-SYSTEM-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','395184b5d5b048a68e06c91154c56847','D-LINK DES 7200 BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10223',NULL,'D-Link DES_DGS Switch by SNMP','3','-1','2','','','D-Link DES_DGS Switch by SNMP','0',NULL,'Template D-Link DES_DGS Switch' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'EQUIPMENT-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || 'DLINK-AGENT-MIB' || chr(13) || chr(10) || 'EtherLike-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'ENTITY-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: D-Link reports missing PSU as fail(4)' || chr(13) || chr(10) || '  Version: Firmware: 1.73R008,hardware revision: B1' || chr(13) || chr(10) || '  Device: DGS-3420-26SC Gigabit Ethernet Switch' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','d3176749a5274264938f487cd89d17eb','D-LINK DES_DGS SWITCH BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10224',NULL,'Extreme EXOS by SNMP','3','-1','2','','','Extreme EXOS by SNMP','0',NULL,'Template Extreme EXOS' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'EXTREME-SYSTEM-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || 'EtherLike-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'EXTREME-SOFTWARE-MONITOR-MIB' || chr(13) || chr(10) || 'ENTITY-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','861dbdece18f4b8f85214a319995eb3e','EXTREME EXOS BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10226',NULL,'Network Generic Device by SNMP','3','-1','2','','','Network Generic Device by SNMP','0',NULL,'Template Net Network Generic Device' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'EtherLike-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','67332e679035423f85090aa985947c36','NETWORK GENERIC DEVICE BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10227',NULL,'HP Comware HH3C by SNMP','3','-1','2','','','HP Comware HH3C by SNMP','0',NULL,'Template Net HP Comware (HH3C)' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'EtherLike-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'ENTITY-MIB' || chr(13) || chr(10) || 'HH3C-ENTITY-EXT-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: No temperature sensors. All entities of them return 0 for HH3C-ENTITY-EXT-MIB::hh3cEntityExtTemperature' || chr(13) || chr(10) || '  Version: 1910-48 Switch Software Version 5.20.99, Release 1116 Copyright(c)2010-2016 Hewlett Packard Enterprise Development LP' || chr(13) || chr(10) || '  Device: HP 1910-48' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','57aeccd43b744942b9555269b79a96ad','HP COMWARE HH3C BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10229',NULL,'Huawei VRP by SNMP','3','-1','2','','','Huawei VRP by SNMP','0',NULL,'Template Net Huawei VRP' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'EtherLike-MIB' || chr(13) || chr(10) || 'HUAWEI-ENTITY-EXTENT-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'ENTITY-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','ad4c3dad4b7b492685d1fd3bd3a664f9','HUAWEI VRP BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10230',NULL,'Intel_Qlogic Infiniband by SNMP','3','-1','2','','','Intel_Qlogic Infiniband by SNMP','0',NULL,'Template Net Intel_Qlogic Infiniband' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'ICS-CHASSIS-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','6f7f2c44e13a46a4b219fbb5db92f3f7','INTEL_QLOGIC INFINIBAND BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10231',NULL,'Juniper by SNMP','3','-1','2','','','Juniper by SNMP','0',NULL,'Template Net Juniper' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'EtherLike-MIB' || chr(13) || chr(10) || 'JUNIPER-ALARM-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'JUNIPER-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','a326034825984bbd8a3a5885f3939bb3','JUNIPER BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10233',NULL,'Mikrotik by SNMP','3','-1','2','','','Mikrotik by SNMP','0',NULL,'Template Net Mikrotik' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Doesn''t have ifHighSpeed filled. fixed in more recent versions' || chr(13) || chr(10) || '  Version: RouterOS 6.28 or lower' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Doesn''t have any temperature sensors' || chr(13) || chr(10) || '  Version: RouterOS 6.38.5' || chr(13) || chr(10) || '  Device: Mikrotik 941-2nD, Mikrotik 951G-2HnD' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','815b5a81b29a477695fddbd533ad9c84','MIKROTIK BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10234',NULL,'Netgear Fastpath by SNMP','3','-1','2','','','Netgear Fastpath by SNMP','0',NULL,'Template Net Netgear Fastpath' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'FASTPATH-SWITCHING-MIB' || chr(13) || chr(10) || 'FASTPATH-BOXSERVICES-PRIVATE-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','5920713da492452889adabc25e259caa','NETGEAR FASTPATH BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10235',NULL,'QTech QSW by SNMP','3','-1','2','','','QTech QSW by SNMP','0',NULL,'Template Net QTech QSW' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'QTECH-MIB' || chr(13) || chr(10) || 'EtherLike-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'ENTITY-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','21f3e79e1d2e4f5e868d1ef81c94bbfd','QTECH QSW BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10236',NULL,'TP-LINK by SNMP','3','-1','2','','','TP-LINK by SNMP','0',NULL,'Template Net TP-LINK' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'TPLINK-SYSINFO-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'TPLINK-SYSMONITOR-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Default sysLocation, sysName and sysContact is not filled with proper data. Real hostname and location can be found only in private branch (TPLINK-SYSINFO-MIB). Please check whether this problem exists in the latest firmware: https://www.tp-link.com/en/support/download/t2600g-28ts/#Firmware' || chr(13) || chr(10) || '  Version: 2.0.0 Build 20170628 Rel.55184 (Beta)' || chr(13) || chr(10) || '  Device: T2600G-28TS 2.0' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: The Serial number of the product (tpSysInfoSerialNum) is missing in HW versions prior to V2_170323' || chr(13) || chr(10) || '  Version: Prior to version V2_170323' || chr(13) || chr(10) || '  Device: T2600G-28TS 2.0' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','2b9039885edf45b8bdd39f16dd069133','TP-LINK BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10237',NULL,'Ubiquiti AirOS by SNMP','3','-1','2','','','Ubiquiti AirOS by SNMP','0',NULL,'Template Net Ubiquiti AirOS' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'FROGFOOT-RESOURCES-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'IEEE802dot11-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: UBNT unifi reports speed: like IF-MIB::ifSpeed.1 = Gauge32: 4294967295 for all interfaces' || chr(13) || chr(10) || '  Version: Firmware: BZ.ar7240.v3.7.51.6230.170322.1513' || chr(13) || chr(10) || '  Device: UBNT UAP-LR' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: UBNT AirMax(NanoStation, NanoBridge etc) reports ifSpeed: as 0 for VLAN and wireless(ath0) interfaces' || chr(13) || chr(10) || '  Version: Firmware: XW.ar934x.v5.6-beta4.22359.140521.1836' || chr(13) || chr(10) || '  Device: NanoStation M5' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: UBNT AirMax(NanoStation, NanoBridge etc) reports always return ifType: as ethernet(6) even for wifi,vlans and other types' || chr(13) || chr(10) || '  Version: Firmware: XW.ar934x.v5.6-beta4.22359.140521.1836' || chr(13) || chr(10) || '  Device: NanoStation M5' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: ifXTable is not provided in IF-MIB. So Interfaces Simple Template is used instead' || chr(13) || chr(10) || '  Version: all above' || chr(13) || chr(10) || '  Device: NanoStation, UAP-LR' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','6c235d126c1f4895acfe2156b140a886','UBIQUITI AIROS BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10248',NULL,'Linux by SNMP','3','-1','2','','','Linux by SNMP','0',NULL,'This is an official Linux template. It requires an SNMP client.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'EtherLike-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'UCD-DISKIO-MIB' || chr(13) || chr(10) || 'UCD-SNMP-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Notes on filesystem (FS) discovery:' || chr(13) || chr(10) || '  - The ext4/3/2 FS reserves space for privileged usage, typically set at 5% by default.' || chr(13) || chr(10) || '  - BTRFS allocates a default of 10% of the volume for its own needs.' || chr(13) || chr(10) || '  - To mitigate potential disasters, FS usage triggers are based on the maximum available space.' || chr(13) || chr(10) || '    - Utilization formula: ''pused = 100 * (used / used + available)''' || chr(13) || chr(10) || '  - The FS utilization chart, derived from graph prototypes, reflects FS reserved space as the difference between used and available space from the total volume.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387225-discussion-thread-for-official-zabbix-template-for-linux' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','4d3a7adbb6964bd08f2b9d28e0da6496','LINUX BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10249',NULL,'Windows by SNMP','3','-1','2','','','Windows by SNMP','0',NULL,'This is an official Windows template. It requires an SNMP client.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description:' || chr(13) || chr(10) || '    64-bit I/O is not supported even though `IfxTable` is present.' || chr(13) || chr(10) || '    Currently, Windows gets its interface status from MIB-2. Since these 64-bit SNMP counters (`ifHCInOctets`, `ifHCOutOctets`, etc.) are defined as an extension to IF-MIB, Microsoft has not implemented it.' || chr(13) || chr(10) || '    https://social.technet.microsoft.com/Forums/windowsserver/en-US/07b62ff0-94f6-40ca-a99d-d129c1b33d70/windows-2008-r2-snmp-64bit-counters-support?forum=winservergen' || chr(13) || chr(10) || '  Version: Win2008, Win2012R2.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: MIB is not supported' || chr(13) || chr(10) || '  Version: WindowsXP' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: EtherLike MIB is not supported' || chr(13) || chr(10) || '  Version: any' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description:' || chr(13) || chr(10) || '    HOST-RESOURCES-MIB::hrStorageSize is limited to number 2147483647.' || chr(13) || chr(10) || '    Storage size is calculated using: `hrStorageSize` and `hrStorageAllocationUnits`.' || chr(13) || chr(10) || '    Allocation size of 512 bytes, sets the limit of monitored device to 1TB.' || chr(13) || chr(10) || '  Version: any' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','f9a59315c8944853bb91c0a9ec3056d7','WINDOWS BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10250',NULL,'HP Enterprise Switch by SNMP','3','-1','2','','','HP Enterprise Switch by SNMP','0',NULL,'Template Net HP Enterprise Switch' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'NETSWITCH-MIB' || chr(13) || chr(10) || 'HP-ICF-CHASSIS' || chr(13) || chr(10) || 'ENTITY-SENSORS-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || 'EtherLike-MIB' || chr(13) || chr(10) || 'SEMI-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'ENTITY-MIB' || chr(13) || chr(10) || 'STATISTICS-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','cce20a5d149a48b7ac7f5383c3510883','HP ENTERPRISE SWITCH BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10251',NULL,'Mellanox by SNMP','3','-1','2','','','Mellanox by SNMP','0',NULL,'The updated template for monitoring the Mellanox network switches over SNMP agent. All items collected in one template without any linked templates.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'ENTITY-SENSORS-MIB' || chr(13) || chr(10) || 'ENTITY-STATE-MIB' || chr(13) || chr(10) || 'ENTITY-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','a60798c651604d93a062bec0f8a89751','MELLANOX BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10253',NULL,'Cisco IOS versions 12.0_3_T-12.2_3.5 by SNMP','3','-1','2','','','Cisco IOS versions 12.0_3_T-12.2_3.5 by SNMP','0',NULL,'Cisco IOS Software releases later to 12.0(3)T and prior to 12.2(3.5)' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'CISCO-MEMORY-POOL-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'CISCO-ENVMON-MIB' || chr(13) || chr(10) || 'CISCO-PROCESS-MIB' || chr(13) || chr(10) || 'ENTITY-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','40c233aaa3424fd29dc378022ff3461d','CISCO IOS VERSIONS 12.0_3_T-12.2_3.5 BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10254',NULL,'Arista by SNMP','3','-1','2','','','Arista by SNMP','0',NULL,'Template Net Arista' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'ENTITY-SENSORS-MIB' || chr(13) || chr(10) || 'ENTITY-STATE-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || 'EtherLike-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'ENTITY-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','26674f62500e4e79b9f470bbf962130d','ARISTA BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10255',NULL,'Dell iDRAC by SNMP','3','-1','2','','','Dell iDRAC by SNMP','0',NULL,'Template Server iDRAC' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'IDRAC-MIB-SMIv2' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','43dc5c8a9a0e4786b64e44422c7f32b4','DELL IDRAC BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10256',NULL,'HP iLO by SNMP','3','-1','2','','','HP iLO by SNMP','0',NULL,'Template Server HP iLO' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'CPQHLTH-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'CPQSINFO-MIB' || chr(13) || chr(10) || 'CPQIDA-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','c2a7ddca051d4b4a9553f339c57e47a9','HP ILO BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10258',NULL,'IBM IMM by SNMP','3','-1','2','','','IBM IMM by SNMP','0',NULL,'Template Server IBM IMM' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'IMM-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Some IMMs (IMM1) do not return disks' || chr(13) || chr(10) || '  Version: IMM1' || chr(13) || chr(10) || '  Device: IBM x3250M3' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Some IMMs (IMM1) do not return fan status: fanHealthStatus' || chr(13) || chr(10) || '  Version: IMM1' || chr(13) || chr(10) || '  Device: IBM x3250M3' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: IMM1 servers (M2, M3 generations) sysObjectID is NET-SNMP-MIB::netSnmpAgentOIDs.10' || chr(13) || chr(10) || '  Version: IMM1' || chr(13) || chr(10) || '  Device: IMM1 servers (M2,M3 generations)' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: IMM1 servers (M2, M3 generations) only Ambient temperature sensor available' || chr(13) || chr(10) || '  Version: IMM1' || chr(13) || chr(10) || '  Device: IMM1 servers (M2,M3 generations)' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','c9e1acd3ae4a427ab39724b6bcaf839e','IBM IMM BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10259',NULL,'Supermicro Aten by SNMP','3','-1','2','','','Supermicro Aten by SNMP','0',NULL,'Template Server Supermicro Aten' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'ATEN-IPMI-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','cf0947cc05d3450b9a6d66b2eb180482','SUPERMICRO ATEN BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10260',NULL,'Apache Tomcat by JMX','3','-1','2','','','Apache Tomcat by JMX','0',NULL,'The template to monitor Apache Tomcat by Zabbix that work without any external scripts.' || chr(13) || chr(10) || 'The metrics are collected by JMX.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/411862-discussion-thread-for-official-zabbix-template-tomcat' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','3cc8c9ae7055458c9a803597007f70bd','APACHE TOMCAT BY JMX','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10261',NULL,'Remote Zabbix server health','3','-1','2','','','Remote Zabbix server health','0',NULL,'This template is designed to monitor internal Zabbix metrics on the remote Zabbix server.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Specify the address of the remote Zabbix server by changing {$ZABBIX.SERVER.ADDRESS} and {$ZABBIX.SERVER.PORT} macros. Don''t forget to adjust the "StatsAllowedIP" parameter in the remote server''s configuration file to allow the collection of statistics.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','79b16cbbe593444eae3de66de0cb566b','REMOTE ZABBIX SERVER HEALTH','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10262',NULL,'Remote Zabbix proxy health','3','-1','2','','','Remote Zabbix proxy health','0',NULL,'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','970c2342146549768e6b91a26089bcdf','REMOTE ZABBIX PROXY HEALTH','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10264',NULL,'Apache by Zabbix agent','3','-1','2','','','Apache by Zabbix agent','0',NULL,'Get metrics from mod_status module using HTTP agent.' || chr(13) || chr(10) || 'https://httpd.apache.org/docs/current/mod/mod_status.html' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384764-discussion-thread-for-official-zabbix-template-apache' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','a8d91e4f36794e32b73090d5edf3d7ae','APACHE BY ZABBIX AGENT','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10265',NULL,'Apache by HTTP','3','-1','2','','','Apache by HTTP','0',NULL,'This template is designed for the effortless deployment of Apache monitoring by Zabbix via HTTP and doesn''t require any external scripts.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'The template collects metrics by polling ''mod_status'' with HTTP agent remotely.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Setup:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1. See the setup instructions for mod_status:' || chr(13) || chr(10) || 'https://httpd.apache.org/docs/current/mod/mod_status.html' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Check the availability of the module with this command line:' || chr(13) || chr(10) || 'httpd -M 2>/dev/null | grep status_module' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'This is an example configuration of the Apache web server:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '<Location "/server-status">' || chr(13) || chr(10) || '  SetHandler server-status' || chr(13) || chr(10) || '  Require host example.com' || chr(13) || chr(10) || '</Location>' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '2. Set the hostname or IP address of the Apache status page host in the ''{$APACHE.STATUS.HOST}'' macro. You can also change the status page port in the ''{$APACHE.STATUS.PORT}'' macro and status page path in the ''{$APACHE.STATUS.PATH}'' macro if necessary.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384764-discussion-thread-for-official-zabbix-template-apache' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','86702e8bc514434e8c914d50c206cb94','APACHE BY HTTP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10266',NULL,'Nginx by Zabbix agent','3','-1','2','','','Nginx by Zabbix agent','0',NULL,'Get metrics from stub status module using Zabbix agent running on Linux' || chr(13) || chr(10) || 'https://nginx.ru/en/docs/http/ngx_http_stub_status_module.html' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384765-discussion-thread-for-official-zabbix-template-nginx' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','27f6424905884dbb96ab9210d987a56c','NGINX BY ZABBIX AGENT','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10267',NULL,'Nginx by HTTP','3','-1','2','','','Nginx by HTTP','0',NULL,TO_NCLOB('This template is developed to monitor Nginx by Zabbix that works without any external scripts.' || chr(13) || chr(10) || 'Most of the metrics are collected in one go, thanks to Zabbix bulk data collection.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'The template collects metrics by polling the module ''ngx_http_stub_status_module'' with HTTP agent remotely:' || chr(13) || chr(10) || 'https://nginx.ru/en/docs/http/ngx_http_stub_status_module.html' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Active connections: 291' || chr(13) || chr(10) || 'server accepts handled requests' || chr(13) || chr(10) || '16630948 16630948 31070465' || chr(13) || chr(10) || 'Reading: 6 Writing: 179 Waiting: 106' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Setup:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1. See the setup instructions for ''ngx_http_stub_status_module'':' || chr(13) || chr(10) || 'https://nginx.ru/en/docs/http/ngx_http_stub_status_module.html' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Test the availability of the ''http_stub_status_module'' with ''nginx -V 2>&1 | grep -o with-http_stub_status_module''.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Example configuration of Nginx:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'location = /basic_status {' || chr(13) || chr(10) || '    stub_status;' || chr(13) || chr(10) || '    allow <IP of your Zabbix server/proxy>;' || chr(13) || chr(10) || '    deny all;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '2. Set the hostname or IP address of the Nginx host or Nginx container in the ''{$NGINX.STUB_STATUS.HOST}'' macro. You can also change the status page port in the ''{$NGINX.STUB_STATUS.PORT}'' macro, the status page scheme in the ''{$NGINX.STUB_STATUS.SCHEME}'' macro and the status page path in the ''{$NGINX.STUB_STATUS.PATH}'' macro if necessary.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384765-discussion-thread-for-official-zabbix-template-nginx' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('Generated by official Zabbix template tool "Templator"'),'1','1','','','','','0','0','13d5bb0a4ae84228bff408aab5be338e','NGINX BY HTTP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10285',NULL,'Linux by Prom','3','-1','2','','','Linux by Prom','0',NULL,TO_NCLOB('This template collects Linux metrics from node_exporter 0.18 and above. Support for older node_exporter versions is provided as ''best effort''.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Setup:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1. Set up the node_exporter according to the official documentation:' || chr(13) || chr(10) || 'https://prometheus.io/docs/guides/node-exporter/' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Use node_exporter v0.18.0 or above.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '2. Set the hostname or IP address of the node_exporter host in the ''{$NODE_EXPORTER_HOST}'' macro. You can also change the Prometheus endpoint port in the ''{$NODE_EXPORTER_PORT}'' macro if necessary.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  - Node Exporter 0.16.0 renamed many metrics. CPU utilization for "guest" and "guest_nice" metrics are not supported in this template with Node Exporter < 0.16. Disk IO metrics are not supported. Other metrics provided as best effort. See https://github.com/prometheus/node_exporter/releases/tag/v0.16.0 for details.' || chr(13) || chr(10) || '    - version: below 0.16.0' || chr(13) || chr(10) || '  - metric node_network_info with label ''device'' cannot be found, so network discovery is not possible.' || chr(13) || chr(10) || '    - version: below 0.18' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Notes on filesystem (FS) discovery:' || chr(13) || chr(10) || '  - The ext4/3/2 FS reserves space for privileged usage, typically set at 5% by default.' || chr(13) || chr(10) || '  - BTRFS allocates a default of 10% of the volume for its own needs.' || chr(13) || chr(10) || '  - To mitigate potential disasters, FS usage triggers are based on the maximum available space.' || chr(13) || chr(10) || '    - Utilization formula: ''pused = 100 - 100 * (available / total - free + available)''' || chr(13) || chr(10) || '')||
TO_NCLOB('  - The FS utilization chart, derived from graph prototypes, reflects FS reserved space as the difference between used and available space from the total volume.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387225-discussion-thread-for-official-zabbix-template-for-linux' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('Generated by official Zabbix template tool "Templator"'),'1','1','','','','','0','0','2506b0ca01884903b547b1e19b76ce6d','LINUX BY PROM','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10300',NULL,'RabbitMQ cluster by Zabbix agent','3','-1','2','','','RabbitMQ cluster by Zabbix agent','0',NULL,'Get cluster metrics from RabbitMQ management plugin provided an HTTP-based API using Zabbix agent.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387226-discussion-thread-for-official-zabbix-template-rabbitmq' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','5fa761bc51e4432a90c6c9eece930c4a','RABBITMQ CLUSTER BY ZABBIX AGENT','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10301',NULL,'RabbitMQ node by Zabbix agent','3','-1','2','','','RabbitMQ node by Zabbix agent','0',NULL,'Get node metrics from RabbitMQ management plugin provided an HTTP-based API using Zabbix agent.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387226-discussion-thread-for-official-zabbix-template-rabbitmq' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','d5dc11ae9ab143a89c4be534bbb35188','RABBITMQ NODE BY ZABBIX AGENT','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10302',NULL,'RabbitMQ cluster by HTTP','3','-1','2','','','RabbitMQ cluster by HTTP','0',NULL,'This template is developed to monitor the messaging broker RabbitMQ cluster by Zabbix that works without any external scripts.' || chr(13) || chr(10) || 'Most of the metrics are collected in one go, thanks to Zabbix bulk data collection.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'The template collects metrics by polling RabbitMQ management plugin with HTTP agent remotely.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Setup:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1. Enable the RabbitMQ management plugin. See the RabbitMQ documentation for the instructions:' || chr(13) || chr(10) || 'https://www.rabbitmq.com/management.html' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '2. Create a user to monitor the service:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'rabbitmqctl add_user zbx_monitor <PASSWORD>' || chr(13) || chr(10) || 'rabbitmqctl set_permissions  -p / zbx_monitor "" "" ".*"' || chr(13) || chr(10) || 'rabbitmqctl set_user_tags zbx_monitor monitoring' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '3. Set the hostname or IP address of the RabbitMQ cluster host in the ''{$RABBITMQ.API.CLUSTER_HOST}'' macro. You can also change the port in the ''{$RABBITMQ.API.PORT}'' macro and the scheme in the ''{$RABBITMQ.API.SCHEME}'' macro if necessary.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '4. Set the user name and password in the macros ''{$RABBITMQ.API.USER}'' and ''{$RABBITMQ.API.PASSWORD}''.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387226-discussion-thread-for-official-zabbix-template-rabbitmq' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8c8474148c2a4eaeabe5a9331ea99d77','RABBITMQ CLUSTER BY HTTP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10303',NULL,'RabbitMQ node by HTTP','3','-1','2','','','RabbitMQ node by HTTP','0',NULL,'This template is developed to monitor the messaging broker RabbitMQ node by Zabbix that works without any external scripts.' || chr(13) || chr(10) || 'Most of the metrics are collected in one go, thanks to Zabbix bulk data collection.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'The template collects metrics by polling RabbitMQ management plugin with HTTP agent remotely.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Setup:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1. Enable the RabbitMQ management plugin. See the RabbitMQ documentation for the instructions:' || chr(13) || chr(10) || 'https://www.rabbitmq.com/management.html' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '2. Create a user to monitor the service:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'rabbitmqctl add_user zbx_monitor <PASSWORD>' || chr(13) || chr(10) || 'rabbitmqctl set_permissions  -p / zbx_monitor "" "" ".*"' || chr(13) || chr(10) || 'rabbitmqctl set_user_tags zbx_monitor monitoring' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '3. Set the hostname or IP address of the RabbitMQ node host in the ''{$RABBITMQ.API.HOST}'' macro. You can also change the port in the ''{$RABBITMQ.API.PORT}'' macro and the scheme in the ''{$RABBITMQ.API.SCHEME}'' macro if necessary.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '4. Set the user name and password in the macros ''{$RABBITMQ.API.USER}'' and ''{$RABBITMQ.API.PASSWORD}''.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387226-discussion-thread-for-official-zabbix-template-rabbitmq' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','b9514029d03b44de9adf24251778dbf3','RABBITMQ NODE BY HTTP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10304',NULL,'Cisco UCS by SNMP','3','-1','2','','','Cisco UCS by SNMP','0',NULL,'Template Server Cisco UCS' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'CISCO-UNIFIED-COMPUTING-COMPUTE-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'CISCO-UNIFIED-COMPUTING-PROCESSOR-MIB' || chr(13) || chr(10) || 'CISCO-UNIFIED-COMPUTING-EQUIPMENT-MIB' || chr(13) || chr(10) || 'CISCO-UNIFIED-COMPUTING-STORAGE-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','cb66d34564e44b3893442fc74cf6e951','CISCO UCS BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10308',NULL,'HAProxy by Zabbix agent','3','-1','2','','','HAProxy by Zabbix agent','0',NULL,'The template to monitor HAProxy by Zabbix that works without any external scripts.' || chr(13) || chr(10) || 'Most of the metrics are collected in one go, thanks to Zabbix bulk data collection.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'The template collects metrics by polling the HAProxy stats page with Zabbix agent.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Note, that this template doesn''t support authentication and redirects (limitations of ''web.page.get'').' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Setup:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1. Set up the HAProxy stats page:' || chr(13) || chr(10) || 'https://www.haproxy.com/blog/exploring-the-haproxy-stats-page/' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'The example configuration of HAProxy:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'frontend stats' || chr(13) || chr(10) || '    bind *:8404' || chr(13) || chr(10) || '    stats enable' || chr(13) || chr(10) || '    stats uri /stats' || chr(13) || chr(10) || '    stats refresh 10s' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '2. Set the hostname or IP address of the HAProxy stats host or container in the ''{$HAPROXY.STATS.HOST}'' macro. You can also change the status page port in the ''{$HAPROXY.STATS.PORT}'' macro, the status page scheme in the ''{$HAPROXY.STATS.SCHEME}'' macro and the status page path in the ''{$HAPROXY.STATS.PATH}'' macro if necessary.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/393527-discussion-thread-for-official-zabbix-template-haproxy' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','812073bf8df143bcae2a84b32c3965e5','HAPROXY BY ZABBIX AGENT','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10309',NULL,'HAProxy by HTTP','3','-1','2','','','HAProxy by HTTP','0',NULL,TO_NCLOB('The template to monitor HAProxy by Zabbix that works without any external scripts.' || chr(13) || chr(10) || 'Most of the metrics are collected in one go, thanks to Zabbix bulk data collection.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'The template collects metrics by polling the HAProxy stats page with HTTP agent.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Setup:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1. Set up the HAProxy stats page:' || chr(13) || chr(10) || 'https://www.haproxy.com/blog/exploring-the-haproxy-stats-page/' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'If you want to use authentication, set the username and password in the ''stats auth'' option of the configuration file.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'The example configuration of HAProxy:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'frontend stats' || chr(13) || chr(10) || '    bind *:8404' || chr(13) || chr(10) || '    stats enable' || chr(13) || chr(10) || '    stats uri /stats' || chr(13) || chr(10) || '    stats refresh 10s' || chr(13) || chr(10) || '    #stats auth Username:Password  # Authentication credentials' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '2. Set the hostname or IP address of the HAProxy stats host or container in the ''{$HAPROXY.STATS.HOST}'' macro. You can also change the status page port in the ''{$HAPROXY.STATS.PORT}'' macro, the status page scheme in the ''{$HAPROXY.STATS.SCHEME}'' macro and the status page path in the ''{$HAPROXY.STATS.PATH}'' macro if necessary.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '3. If you have enabled authentication in the HAProxy configuration file in step 1, set the username and password in the `{$HAPROXY.USERNAME}` and `{$HAPROXY.PASSWORD}` macros.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/393527-discussion-thread-for-official-zabbix-template-haproxy' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('Generated by official Zabbix template tool "Templator"'),'1','1','','','','','0','0','948d046cb2894e5c8d07767a518cc1a9','HAPROXY BY HTTP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10310',NULL,'Redis by Zabbix agent 2','3','-1','2','','','Redis by Zabbix agent 2','0',NULL,'Get Redis metrics from plugin for the New Zabbix Agent (zabbix-agent2).' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/389050-discussion-thread-for-official-zabbix-template-redis' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e111446745a1425b862f8727ae63bce4','REDIS BY ZABBIX AGENT 2','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10316',NULL,'MySQL by Zabbix agent','3','-1','2','','','MySQL by Zabbix agent','0',NULL,TO_NCLOB('Requirements for template operation:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1. Install Zabbix agent and MySQL client. If necessary, add the path to the ''mysql'' and ''mysqladmin'' utilities to the global environment variable PATH.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '2. Copy the ''template_db_mysql.conf'' file with user parameters into folder with Zabbix agent configuration (/etc/zabbix/zabbix_agentd.d/ by default). Don''t forget to restart Zabbix agent.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '3. Create the MySQL user that will be used for monitoring (''<password>'' at your discretion). For example:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'CREATE USER ''zbx_monitor''@''%'' IDENTIFIED BY ''<password>'';' || chr(13) || chr(10) || 'GRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW ON *.* TO ''zbx_monitor''@''%'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'For more information, please see MySQL documentation (https://dev.mysql.com/doc/refman/8.0/en/grant.html).' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '4. Create ''.my.cnf'' configuration file in the home directory of Zabbix agent for Linux distributions (/var/lib/zabbix by default) or ''my.cnf'' in c:\ for Windows. For example:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '[client]' || chr(13) || chr(10) || 'protocol=tcp' || chr(13) || chr(10) || 'user=''zbx_monitor''' || chr(13) || chr(10) || 'password=''<password>''' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'For more information, please see MySQL documentation (https://dev.mysql.com/doc/refman/8.0/en/option-files.html).' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'NOTE: Linux distributions that use SELinux may require additional steps for access configuration.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384189-discussion-thread-for-official-zabbix-template-db-mysql' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('Generated by official Zabbix template tool "Templator"'),'1','1','','','','','0','0','f255e3fc32124b55b2a17ef3c961e5f5','MYSQL BY ZABBIX AGENT','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10317',NULL,'MySQL by ODBC','3','-1','2','','','MySQL by ODBC','0',NULL,'Requirements for template operation:' || chr(13) || chr(10) || '1. Create a MySQL user for monitoring. For example:' || chr(13) || chr(10) || 'CREATE USER ''zbx_monitor''@''%'' IDENTIFIED BY ''<password>'';' || chr(13) || chr(10) || 'GRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW ON *.* TO ''zbx_monitor''@''%'';' || chr(13) || chr(10) || 'For more information read the MYSQL documentation https://dev.mysql.com/doc/refman/8.0/en/grant.html , please.' || chr(13) || chr(10) || '2. Set the user name and password in the host macros ({$MYSQL.USER} and {$MYSQL.PASSWORD}).' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384189-discussion-thread-for-official-zabbix-template-db-mysql' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e19c120027e04da69b130e0f6cea29fc','MYSQL BY ODBC','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10318',NULL,'Docker by Zabbix agent 2','3','-1','2','','','Docker by Zabbix agent 2','0',NULL,'Get Docker engine metrics from plugin for the New Zabbix Agent (zabbix-agent2).' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/435429-discussion-thread-for-official-zabbix-template-docker' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','c5fd214cdd0d4b3b8272e73b022ba5c2','DOCKER BY ZABBIX AGENT 2','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10319',NULL,'Memcached by Zabbix agent 2','3','-1','2','','','Memcached by Zabbix agent 2','0',NULL,'Get Memcached metrics from plugin for the New Zabbix Agent (zabbix-agent2).' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/398623-discussion-thread-for-official-zabbix-template-memcached' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','05894ba2c9184d33992bf1bd21c347f6','MEMCACHED BY ZABBIX AGENT 2','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10320',NULL,'MySQL by Zabbix agent 2','3','-1','2','','','MySQL by Zabbix agent 2','0',NULL,'Requirements for template operation:' || chr(13) || chr(10) || '1. Create a MySQL user for monitoring. For example:' || chr(13) || chr(10) || 'CREATE USER ''zbx_monitor''@''%'' IDENTIFIED BY ''<password>'';' || chr(13) || chr(10) || 'GRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW ON *.* TO ''zbx_monitor''@''%'';' || chr(13) || chr(10) || 'For more information please read the MySQL documentation https://dev.mysql.com/doc/refman/8.0/en/grant.html.' || chr(13) || chr(10) || '2. Set in the {$MYSQL.DSN} macro the data source name of the MySQL instance either session name from Zabbix agent 2 configuration file or URI.' || chr(13) || chr(10) || 'Examples: MySQL1, tcp://localhost:3306, tcp://172.16.0.10, unix:/var/run/mysql.sock' || chr(13) || chr(10) || 'For more information about MySQL Unix socket file please read the MySQL documentation https://dev.mysql.com/doc/refman/8.0/en/problems-with-mysql-sock.html.' || chr(13) || chr(10) || '3. If you had set URI in the {$MYSQL.DSN}, please define the user name and password in host macros ({$MYSQL.USER} and {$MYSQL.PASSWORD}).' || chr(13) || chr(10) || 'Leave macros {$MYSQL.USER} and {$MYSQL.PASSWORD} empty if you use a session name. Set the user name and password in the Plugins.Mysql.<...> section of your Zabbix agent 2 configuration file.' || chr(13) || chr(10) || 'For more information about configuring the Zabbix MySQL plugin please read the documentation https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/src/go/plugins/mysql/README.md.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384189-discussion-thread-for-official-zabbix-template-db-mysql' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','4904f84303c74c5e955b7849730c3155','MYSQL BY ZABBIX AGENT 2','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10321',NULL,'Chassis by IPMI','3','-1','2','','','Chassis by IPMI','0',NULL,'Template for monitoring servers with BMC over IPMI that work without any external scripts.' || chr(13) || chr(10) || 'All metrics are collected at once, thanks to Zabbix''s bulk data collection. The template is available starting from Zabbix version 5.0.' || chr(13) || chr(10) || 'It collects metrics by polling BMC remotely using an IPMI agent.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: If the BMC has a sensor with an empty threshold value, we get the LLD error "Cannot create trigger...".' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/398023-discussion-thread-for-official-zabbix-template-ipmi' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','02f35169a5a54a5aad8b3f06e798ab1f','CHASSIS BY IPMI','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10322',NULL,'Elasticsearch Cluster by HTTP','3','-1','2','','','Elasticsearch Cluster by HTTP','0',NULL,'The template to monitor Elasticsearch by Zabbix that work without any external scripts.' || chr(13) || chr(10) || 'It works with both standalone and cluster instances.' || chr(13) || chr(10) || 'The metrics are collected in one pass remotely using an HTTP agent.' || chr(13) || chr(10) || 'They are getting values from REST API ''_cluster/health'', ''_cluster/stats'', ''_nodes/stats'' requests.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Setup:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1. Set the hostname or IP address of the Elasticsearch host in the ''{$ELASTICSEARCH.HOST}'' macro.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '2. Set the login and password in the ''{$ELASTICSEARCH.USERNAME}'' and ''{$ELASTICSEARCH.PASSWORD}'' macros.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '3. If you use an atypical location of ES API, don''t forget to change the macros ''{$ELASTICSEARCH.SCHEME}'',''{$ELASTICSEARCH.PORT}''.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/399473-discussion-thread-for-official-zabbix-template-for-elasticsearch' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','52b2664578884d9eba62e47375c99f8e','ELASTICSEARCH CLUSTER BY HTTP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10323',NULL,'ClickHouse by HTTP','3','-1','2','','','ClickHouse by HTTP','0',NULL,'This template is designed for the effortless deployment of ClickHouse monitoring by Zabbix via HTTP and doesn''t require any external scripts.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Setup:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1. Create a user to monitor the service. For example, you could create a file ''/etc/clickhouse-server/users.d/zabbix.xml'' with the following content:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '<yandex>' || chr(13) || chr(10) || '  <users>' || chr(13) || chr(10) || '    <zabbix>' || chr(13) || chr(10) || '      <password>zabbix_pass</password>' || chr(13) || chr(10) || '      <networks incl="networks" />' || chr(13) || chr(10) || '      <profile>web</profile>' || chr(13) || chr(10) || '      <quota>default</quota>' || chr(13) || chr(10) || '      <allow_databases>' || chr(13) || chr(10) || '        <database>test</database>' || chr(13) || chr(10) || '      </allow_databases>' || chr(13) || chr(10) || '    </zabbix>' || chr(13) || chr(10) || '  </users>' || chr(13) || chr(10) || '</yandex>' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '2. Set the hostname or IP address of the ClickHouse HTTP endpoint in the ''{$CLICKHOUSE.HOST}'' macro. You can also change the port in the ''{$CLICKHOUSE.PORT}'' macro and scheme in the ''{$CLICKHOUSE.SCHEME}'' macro if necessary.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '3. Set the login and password in the macros ''{$CLICKHOUSE.USER}'' and ''{$CLICKHOUSE.PASSWORD}''. If you don''t need an authentication - remove headers from HTTP-Agent type items.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','95f2053c21094ad4968440b562cc7ea2','CLICKHOUSE BY HTTP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10324',NULL,'Etcd by HTTP','3','-1','2','','','Etcd by HTTP','0',NULL,TO_NCLOB('This template is designed to monitor ''etcd'' by Zabbix that works without any external scripts.' || chr(13) || chr(10) || 'Most of the metrics are collected in one go, thanks to Zabbix bulk data collection.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'The template ''Etcd by HTTP'' — collects metrics by help of the HTTP agent from ''/metrics'' endpoint.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Refer to the vendor documentation:' || chr(13) || chr(10) || 'https://etcd.io/docs/v3.5/op-guide/monitoring/#metrics-endpoint' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'For the users of ''etcd version <= 3.4'':' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'In ''etcd v3.5'' some metrics have been deprecated. See more details on ''Upgrade etcd from 3.4 to 3.5'':' || chr(13) || chr(10) || 'https://etcd.io/docs/v3.4/upgrades/upgrade_3_5/' || chr(13) || chr(10) || 'Please upgrade your ''etcd'' instance, or use older ''Etcd by HTTP'' template version.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Setup:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1. Make sure that ''etcd'' allows the collection of metrics. You can test it by running:' || chr(13) || chr(10) || 'curl -L http://localhost:2379/metrics' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '2. Check if ''etcd'' is accessible from Zabbix proxy or Zabbix server depending on where you are planning to do the monitoring. To verify it, run:' || chr(13) || chr(10) || 'curl -L  http://<etcd_node_address>:2379/metrics' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '3. Add the template to the ''etcd'' node. Set the hostname or IP address of the ''etcd'' host in the ''{$ETCD.HOST}'' macro. By default, the template uses a client''s port.' || chr(13) || chr(10) || 'You can configure metrics endpoint location by adding ''--listen-metrics-urls'' flag.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'For more details, see the etcd documentation:' || chr(13) || chr(10) || '')||
TO_NCLOB('https://etcd.io/docs/v3.5/op-guide/configuration/#profiling-and-monitoring' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Additional points to consider:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '- If you have specified a non-standard port for ''etcd'', don''t forget to change macros: ''{$ETCD.SCHEME}'' and ''{$ETCD.PORT}''.' || chr(13) || chr(10) || '- You can set ''{$ETCD.USERNAME}'' and ''{$ETCD.PASSWORD}'' macros in the template to use on a host level if necessary.' || chr(13) || chr(10) || '- To test availability, run : ''zabbix_get -s etcd-host -k etcd.health''.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('Generated by official Zabbix template tool "Templator"'),'1','1','','','','','0','0','b25b8b517a4743c48037bfa10af3dc3c','ETCD BY HTTP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10325',NULL,'IIS by Zabbix agent','3','-1','2','','','IIS by Zabbix agent','0',NULL,'Get metrics from IIS using Zabbix agent running on Windows.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/401862-discussion-thread-for-official-zabbix-template-internet-information-services' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','c7c7e5dc319b4801982e719beb1c5191','IIS BY ZABBIX AGENT','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10326',NULL,'IIS by Zabbix agent active','3','-1','2','','','IIS by Zabbix agent active','0',NULL,'Get metrics from IIS using Zabbix agent running on Windows.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/401862-discussion-thread-for-official-zabbix-template-internet-information-services' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','4677be3e07bf4f3285496f2f4230b928','IIS BY ZABBIX AGENT ACTIVE','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10327',NULL,'MSSQL by ODBC','3','-1','2','','','MSSQL by ODBC','0',NULL,TO_NCLOB('This template is designed for the effortless deployment of MSSQL monitoring by Zabbix via ODBC and doesn''t require any external scripts.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Setup:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1. Create an MSSQL user for monitoring.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  View Server State and View Any Definition permissions should be granted to the user.' || chr(13) || chr(10) || '  Grant this user read permissions to the sysjobschedules, sysjobhistory, and sysjobs tables.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  For more information, see MSSQL documentation:' || chr(13) || chr(10) || '  ' || chr(13) || chr(10) || '  - Create a database user: https://docs.microsoft.com/en-us/sql/relational-databases/security/authentication-access/create-a-database-user?view=sql-server-ver16' || chr(13) || chr(10) || '  ' || chr(13) || chr(10) || '  - GRANT Server Permissions: https://docs.microsoft.com/en-us/sql/t-sql/statements/grant-server-permissions-transact-sql?view=sql-server-ver16' || chr(13) || chr(10) || '  ' || chr(13) || chr(10) || '  - Configure a User to Create and Manage SQL Server Agent Jobs: https://docs.microsoft.com/en-us/sql/ssms/agent/configure-a-user-to-create-and-manage-sql-server-agent-jobs?view=sql-server-ver16' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '2. Set the user name and password in the host macros ({$MSSQL.USER} and {$MSSQL.PASSWORD}).' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '3. Do not forget to install Microsoft ODBC driver on Zabbix server or Zabbix proxy and specify data source name in macro {$MSSQL.DSN}.' || chr(13) || chr(10) || '  ' || chr(13) || chr(10) || '  See Microsoft documentation for instructions: https://docs.microsoft.com/en-us/sql/connect/odbc/linux-mac/installing-the-microsoft-odbc-driver-for-sql-server?view=sql-server-ver16.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('  Note! Credentials in the odbc.ini do not work for MSSQL.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'The "Service''s TCP port state" item uses the {$MSSQL.HOST} and {$MSSQL.PORT} macros to check the availability of the MSSQL instance, change these if necessary.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'If your instance uses a non-default TCP port, set the port in your section of odbc.ini in the line Server = IP or FQDN name, port.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Note: You can use the context macros {$MSSQL.BACKUP_FULL.USED}, {$MSSQL.BACKUP_LOG.USED}, and {$MSSQL.BACKUP_DIFF.USED} to disable backup age triggers for a certain database. If set to a value other than "1", the trigger expression for the backup age will not fire.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('Generated by official Zabbix template tool "Templator"'),'1','1','','','','','0','0','001a1677f6a949b6bddfdb2926023300','MSSQL BY ODBC','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10328',NULL,'Oracle by ODBC','3','-1','2','','','Oracle by ODBC','0',NULL,'1. Create an Oracle user for monitoring.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '2. Set the hostname or IP address of the Oracle DB instance, user name and password in host macros ({$ORACLE.HOST}, {$ORACLE.USER} and {$ORACLE.PASSWORD}).' || chr(13) || chr(10) || '  Do not forget to install the Microsoft ODBC driver on the Zabbix server or the Zabbix proxy.' || chr(13) || chr(10) || '  See Oracle documentation for instructions: https://www.oracle.com/database/technologies/releasenote-odbc-ic.html.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Note! Credentials in the odbc.ini do not work for Oracle.' || chr(13) || chr(10) || '  Note! Be sure that ODBC connects to Oracle with session parameter NLS_NUMERIC_CHARACTERS= ''.,'' It is important for correct display float numbers in Zabbix.' || chr(13) || chr(10) || 'The "Service''s TCP port state" item uses {$ORACLE.HOST} and {$ORACLE.PORT} macros to check the availability of the listener.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','00ade9277d7c41e8b57d638b22d54372','ORACLE BY ODBC','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10329',NULL,'PostgreSQL by Zabbix agent 2','3','-1','2','','','PostgreSQL by Zabbix agent 2','0',NULL,TO_NCLOB('This template is designed for the deployment of PostgreSQL monitoring by Zabbix via Zabbix agent 2 and uses a loadable plugin to run SQL queries.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Setup:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1. Deploy Zabbix agent 2 with the PostgreSQL plugin. Starting with Zabbix versions 6.0.10 / 6.2.4 / 6.4 PostgreSQL metrics are moved to a loadable plugin and require installation of a separate package or compilation of the plugin from sources (https://www.zabbix.com/documentation/7.0/manual/extensions/plugins/build).' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '2. Create the PostgreSQL user for monitoring (`<password>` at your discretion) and inherit permissions from the default role `pg_monitor`:' || chr(13) || chr(10) || 'CREATE USER zbx_monitor WITH PASSWORD ''<PASSWORD>'' INHERIT;' || chr(13) || chr(10) || 'GRANT pg_monitor TO zbx_monitor;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '3. Edit the `pg_hba.conf` configuration file to allow connections for the user `zbx_monitor`. You can check the PostgreSQL documentation for examples (https://www.postgresql.org/docs/current/auth-pg-hba-conf.html).' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '4. Set the connection string for the PostgreSQL instance in the `{$PG.CONNSTRING}` macro as URI, such as `<protocol(host:port)>`, or specify the named session - `<sessionname>`.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Note: if you want to use SSL/TLS encryption to protect communications with the remote PostgreSQL instance, a named session must be used. In that case, the instance URI should be specified in the `Plugins.PostgreSQL.Sessions.*.Uri` parameter in the PostgreSQL plugin configuration files alongside all the encryption parameters (type, cerfiticate/key filepaths if needed etc.).' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('You can check the PostgreSQL plugin documentation (https://git.zabbix.com/projects/AP/repos/postgresql/browse?at=refs%2Fheads%2Frelease%2F7.0) for details about agent plugin parameters and named sessions.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Also, it is assumed that you set up the PostgreSQL instance to work in the desired encryption mode. Check the PostgreSQL documentation (https://www.postgresql.org/docs/current/ssl-tcp.html) for details.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Note that plugin TLS certificate validation relies on checking the Subject Alternative Names (SAN) instead of the Common Name (CN), check the cryptography package documentation (https://pkg.go.dev/crypto/x509) for details.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'For example, to enable required encryption in transport mode without identity checks you could create the file `/etc/zabbix/zabbix_agent2.d/postgresql_myconn.conf` with the following configuration for the named session `myconn` (replace `<instanceip>` with the address of the PostgreSQL instance):' || chr(13) || chr(10) || 'Plugins.PostgreSQL.Sessions.myconn.Uri=tcp://<instanceip>:5432' || chr(13) || chr(10) || 'Plugins.PostgreSQL.Sessions.myconn.TLSConnect=required' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Then set the `{$PG.CONNSTRING}` macro to `myconn` to use this named session.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '5. Set the password that you specified in step 2 in the macro `{$PG.PASSWORD}`.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384190-%C2%A0discussion-thread-for-official-zabbix-template-db-postgresql' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('Generated by official Zabbix template tool "Templator"'),'1','1','','','','','0','0','d0ef7d659a8f4beaaabfc4b6134e737a','POSTGRESQL BY ZABBIX AGENT 2','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10330',NULL,'PHP-FPM by Zabbix agent','3','-1','2','','','PHP-FPM by Zabbix agent','0',NULL,'Get PHP-FPM metrics using Zabbix agent running on Linux.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Note that depending on your OS distribution, the PHP-FPM process name may vary. Please, check the actual name in the line "Name" from /proc/<pid>/status file (https://www.zabbix.com/documentation/7.0/manual/appendix/items/proc_mem_num_notes) and change {$PHP_FPM.PROCESS.NAME.PARAMETER} macro if needed.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','1cbda0970410435684135884d0cb7090','PHP-FPM BY ZABBIX AGENT','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10331',NULL,'PHP-FPM by HTTP','3','-1','2','','','PHP-FPM by HTTP','0',NULL,'Get PHP-FPM metrics using the Zabbix HTTP agent.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','49c77ce207f8478da53e761526d6eca5','PHP-FPM BY HTTP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10333',NULL,'{#HV.UUID}','0','-1','2','','','{#HV.NAME}','2',NULL,'','1','1','','','','','0','1','051a1469d4d045cbbf818fcc843a352e','{#HV.NAME}','','',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10334',NULL,'{#VM.UUID}','0','-1','2','','','{#VM.NAME}','2',NULL,'','1','1','','','','','0','1','23b9ae9d6f33414880db1cb107115810','{#VM.NAME}','','',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10335',NULL,'Oracle by Zabbix agent 2','3','-1','2','','','Oracle by Zabbix agent 2','0',NULL,'Get metrics from Oracle Database using Zabbix agent 2.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','d670c32f007d438c9dcd32db57d2b691','ORACLE BY ZABBIX AGENT 2','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10336',NULL,'Asterisk by HTTP','3','-1','2','','','Asterisk by HTTP','0',NULL,'The template gets Asterisk metrics from AMI by HTTP agent.' || chr(13) || chr(10) || 'You should enable the mini-HTTP Server, add the option webenabled=yes in the general section of the manager.conf file and create Asterisk Manager user with system and command write permissions within your Asterisk instance.' || chr(13) || chr(10) || 'Disable the PJSIP driver if you do not use PJSIP or do not have PJSIP endpoints.' || chr(13) || chr(10) || 'Please, define AMI address in the {$AMI.URL} macro. Also, set the hostname or IP address of the AMI host in the {$AMI.HOST} macro for Zabbix to check Asterisk service status.' || chr(13) || chr(10) || 'Then you can define {$AMI.USERNAME} and {$AMI.SECRET} macros in the template for using on the host level.' || chr(13) || chr(10) || 'If there are errors, increase the logging to debug level and see the Zabbix server log.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/410060-discussion-thread-for-official-zabbix-template-asterisk' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','30cc187a4e994c39b07f53d86b5cc6bc','ASTERISK BY HTTP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10343',NULL,'Linux by Zabbix agent active','3','-1','2','','','Linux by Zabbix agent active','0',NULL,'This is an official Linux template. It requires Zabbix agent 7.0 or newer.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Notes on filesystem (FS) discovery:' || chr(13) || chr(10) || '  - The ext4/3/2 FS reserves space for privileged usage, typically set at 5% by default.' || chr(13) || chr(10) || '  - BTRFS allocates a default of 10% of the volume for its own needs.' || chr(13) || chr(10) || '  - To mitigate potential disasters, FS usage triggers are based on the maximum available space.' || chr(13) || chr(10) || '    - Utilization formula: ''pused = 100 - 100 * (available / total - free + available)''' || chr(13) || chr(10) || '  - The FS utilization chart, derived from graph prototypes, reflects FS reserved space as the difference between used and available space from the total volume.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387225-discussion-thread-for-official-zabbix-template-for-linux' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e2307c94f1744af7a8f1f458a67af424','LINUX BY ZABBIX AGENT ACTIVE','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10351',NULL,'Windows by Zabbix agent active','3','-1','2','','','Windows by Zabbix agent active','0',NULL,'This is an official Windows template. It requires Zabbix agent 7.0 or newer.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387224-discussion-thread-for-official-zabbix-template-for-windows' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','5fdd2ca8b8f84962aaea5a218b46ea7d','WINDOWS BY ZABBIX AGENT ACTIVE','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10353',NULL,'Ceph by Zabbix agent 2','3','-1','2','','','Ceph by Zabbix agent 2','0',NULL,'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/410059-discussion-thread-for-official-zabbix-template-ceph' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','09fb25d089f7467f860895f6e71d3fa2','CEPH BY ZABBIX AGENT 2','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10355',NULL,'Squid by SNMP','3','-1','2','','','Squid by SNMP','0',NULL,'Template for monitoring Squid caching proxy via SNMP' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/409339-discussion-thread-for-official-zabbix-template-squid' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8e5236f799b347a8ae90a979198be85e','SQUID BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10357',NULL,'PostgreSQL by Zabbix agent','3','-1','2','','','PostgreSQL by Zabbix agent','0',NULL,TO_NCLOB('This template is designed for the deployment of PostgreSQL monitoring by Zabbix via Zabbix agent and uses user parameters to run SQL queries with the `psql` command-line tool.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Note:' || chr(13) || chr(10) || '- The template requires `pg_isready` and `psql` utilities to be installed on the same host with Zabbix agent.' || chr(13) || chr(10) || '- The template requires files with SQL queries and user parameters that can be found in the Zabbix official repository:' || chr(13) || chr(10) || 'https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/db/postgresql?at=refs%2Fheads%2Frelease%2F6.0' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Setup:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1. Deploy Zabbix agent and create the PostgreSQL user for monitoring (`<password>` at your discretion) with proper access rights to your PostgreSQL instance.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'For PostgreSQL version 10 and above:' || chr(13) || chr(10) || 'CREATE USER zbx_monitor WITH PASSWORD ''<PASSWORD>'' INHERIT;' || chr(13) || chr(10) || 'GRANT pg_monitor TO zbx_monitor;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'For PostgreSQL version 9.6 and below:' || chr(13) || chr(10) || 'CREATE USER zbx_monitor WITH PASSWORD ''<PASSWORD>'';' || chr(13) || chr(10) || 'GRANT SELECT ON pg_stat_database TO zbx_monitor;' || chr(13) || chr(10) || 'ALTER USER zbx_monitor WITH SUPERUSER;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '2. Copy the `postgresql/` directory to the `zabbix` user home directory - `/var/lib/zabbix/`. The `postgresql/` directory contains the files with SQL queries needed to obtain metrics from PostgreSQL instance.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'If the home directory of the `zabbix` user doesn''t exist, create it first:' || chr(13) || chr(10) || 'mkdir -m u=rwx,g=rwx,o= -p /var/lib/zabbix' || chr(13) || chr(10) || 'chown zabbix:zabbix /var/lib/zabbix' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '3. Copy the `template_db_postgresql.conf` file, containing user parameters, to the Zabbix agent configuration directory `/etc/zabbix/zabbix_agentd.d/` and restart Zabbix agent service.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'If you want to use SSL/TLS encryption to protect communications with the remote PostgreSQL instance, you can modify the connection string in user parameters. For example, to enable required encryption in transport mode without identity checks you could append `?sslmode=required` to the end of the connection string for all keys that use `psql`:' || chr(13) || chr(10) || 'UserParameter=pgsql.bgwriter[*], psql -qtAX postgresql://"$3":"$4"@"$1":"$2"/"$5"?sslmode=required -f "/var/lib/zabbix/postgresql/pgsql.bgwriter.sql"' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Consult the PostgreSQL documentation about protection modes (https://www.postgresql.org/docs/current/libpq-ssl.html#LIBPQ-SSL-PROTECTION) and client connection parameters (https://www.postgresql.org/docs/current/libpq-connect.html#LIBPQ-CONNECT-SSLMODE).' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Also, it is assumed that you set up the PostgreSQL instance to work in the desired encryption mode. Check the PostgreSQL documentation (https://www.postgresql.org/docs/current/ssl-tcp.html) for details.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '4. Edit the `pg_hba.conf` configuration file to allow connections for the user `zbx_monitor`. You can check the PostgreSQL documentation for examples (https://www.postgresql.org/docs/current/auth-pg-hba-conf.html).' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '5. Specify the host name or IP address in the `{$PG.HOST}` macro. Adjust the port number with `{$PG.PORT}` macro if needed.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '6. Set the password that you specified in step 1 in the macro `{$PG.PASSWORD}`.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384190-%C2%A0discussion-thread-for-official-zabbix-template-db-postgresql' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('Generated by official Zabbix template tool "Templator"'),'1','1','','','','','0','0','399bd1ee587245ecac6f39beaa99886f','POSTGRESQL BY ZABBIX AGENT','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10358',NULL,'Apache ActiveMQ by JMX','3','-1','2','','','Apache ActiveMQ by JMX','0',NULL,'The template to monitor Apache ActiveMQ by Zabbix that work without any external scripts.' || chr(13) || chr(10) || 'The metrics are collected by JMX.' || chr(13) || chr(10) || 'You can set macro values and add macros with context for specific brokers or destinations following macro description.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/411049-discussion-thread-for-official-zabbix-template-amq' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','c87e0a2e0683483ab7c6f3c380e9f840','APACHE ACTIVEMQ BY JMX','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10359',NULL,'Aranet Cloud','3','-1','2','','','Aranet Cloud','0',NULL,'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','af21edc47557400583e537904ea632aa','ARANET CLOUD','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10360',NULL,'Microsoft Exchange Server 2016 by Zabbix agent','3','-1','2','','','Microsoft Exchange Server 2016 by Zabbix agent','0',NULL,'The template to monitor Microsoft Exchange Server 2016 by Zabbix that works without any external scripts.' || chr(13) || chr(10) || 'The metrics are collected by Zabbix agent.' || chr(13) || chr(10) || 'Recommended to use it with "OS Windows by Zabbix agent" template.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/415007-discussion-thread-for-official-zabbix-template-microsoft-exchange' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','cbf70ed444394566bcf213dd63d4d352','MICROSOFT EXCHANGE SERVER 2016 BY ZABBIX AGENT','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10361',NULL,'Microsoft Exchange Server 2016 by Zabbix agent active','3','-1','2','','','Microsoft Exchange Server 2016 by Zabbix agent active','0',NULL,'The template to monitor Microsoft Exchange Server 2016 by Zabbix that works without any external scripts.' || chr(13) || chr(10) || 'The metrics are collected by Zabbix agent active.' || chr(13) || chr(10) || 'Recommended to use it with "OS Windows by Zabbix agent active" template.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/415007-discussion-thread-for-official-zabbix-template-microsoft-exchange' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','a0e05ca631034676821b7e0e1ce25488','MICROSOFT EXCHANGE SERVER 2016 BY ZABBIX AGENT ACTIVE','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10362',NULL,'GitLab by HTTP','3','-1','2','','','GitLab by HTTP','0',NULL,'Get GitLab metrics by HTTP agent from Prometheus metrics endpoint.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'To access the metrics, the client IP address must be explicitly allowed. See https://docs.gitlab.com/ee/administration/monitoring/ip_whitelist.html.' || chr(13) || chr(10) || 'Or second method, using token variable from http://your.gitlab.address/admin/health_check (fill {$GITLAB.HEALTH.TOKEN} macro with variable path like "?token=your_token").' || chr(13) || chr(10) || 'Don''t forget change macros {$GITLAB.URL}.' || chr(13) || chr(10) || 'Some metrics may not be collected depending on your Gitlab instance version and configuration. See (Gitlab''s documentation[)https://docs.gitlab.com/ee/administration/monitoring/prometheus/gitlab_metrics.html] for further information about its metric collection.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','f445dac89ff74deabaae9dcb84815998','GITLAB BY HTTP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10363',NULL,'Hadoop by HTTP','3','-1','2','','','Hadoop by HTTP','0',NULL,'The template gets the Hadoop metrics from cluster''s hosts (ResourceManager, NodeManagers, NameNode, DataNodes) by HTTP agent. You should define the IP address (or FQDN) and Web-UI port for the ResourceManager in {$HADOOP.RESOURCEMANAGER.HOST} and {$HADOOP.RESOURCEMANAGER.PORT} macros and for the NameNode in {$HADOOP.NAMENODE.HOST} and {$HADOOP.NAMENODE.PORT} macros respectively. Macros can be set in the template or overridden at the host level.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/413459-discussion-thread-for-official-zabbix-template-hadoop' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e129aeba7c814bf189772cf5919b4bbb','HADOOP BY HTTP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10364',NULL,'Apache Kafka by JMX','3','-1','2','','','Apache Kafka by JMX','0',NULL,'Official JMX Template for Apache Kafka.' || chr(13) || chr(10) || '  The metrics are collected by JMX.' || chr(13) || chr(10) || '  You can set {$KAFKA.USER} and {$KAFKA.PASSWORD} macros in the template for using on the host level.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','2eb43a3c9666467683b9ce09d2bd26d7','APACHE KAFKA BY JMX','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10365',NULL,'HashiCorp Vault by HTTP','3','-1','2','','','HashiCorp Vault by HTTP','0',NULL,'Get HashiCorp Vault metrics from Vault API HTTP Prometheus metrics endpoint.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Some metrics may not be collected depending on your Vault instance version and configuration.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','2f82248e411340429d390e8389850401','HASHICORP VAULT BY HTTP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10366',NULL,'VMware FQDN','3','-1','2','','','VMware FQDN','0',NULL,'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Note: To enable discovery of hardware sensors of VMware Hypervisors, set the macro ''{$VMWARE.HV.SENSOR.DISCOVERY}'' to the value ''true'' on the discovered host level.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','ca02e82e6c414d0aa7aedc8d78468a49','VMWARE FQDN','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10367',NULL,'{#HV.UUID}','0','-1','2','','','{#HV.NAME}','2',NULL,'','1','1','','','','','0','1','51cf7ea3e6a74f7e8dde628dbc5347a3','{#HV.NAME}','','',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10368',NULL,'{#VM.DNS}','0','-1','2','','','{#VM.NAME}','2',NULL,'','1','1','','','','','0','1','a12e25c500a14fcf99295c207371ca1b','{#VM.NAME}','','',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10369',NULL,'Zookeeper by HTTP','3','-1','2','','','Zookeeper by HTTP','0',NULL,'This template is designed for the effortless deployment of Apache Zookeeper monitoring by Zabbix via HTTP and doesn''t require any external scripts.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'This template works with standalone and cluster instances. Metrics are collected from each Zookeeper node by requests to AdminServer' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Setup:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1. Enable the AdminServer and configure the parameters according to the official documentation:' || chr(13) || chr(10) || 'https://zookeeper.apache.org/doc/current/zookeeperAdmin.html#sc_adminserver_config' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '2. Set the hostname or IP address of the Apache Zookeeper host in the ''{$ZOOKEEPER.HOST}'' macro. You can also change the ''{$ZOOKEEPER.COMMAND_URL}'', ''{$ZOOKEEPER.PORT}'' and ''{$ZOOKEEPER.SCHEME}'' macros if necessary.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum:' || chr(13) || chr(10) || 'https://www.zabbix.com/forum/zabbix-suggestions-and-feedback' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','b606eda347ea4663a33ad4d12a482750','ZOOKEEPER BY HTTP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10370',NULL,'Apache Cassandra by JMX','3','-1','2','','','Apache Cassandra by JMX','0',NULL,'The template to monitor Apache Cassandra by Zabbix that work without any external scripts.' || chr(13) || chr(10) || 'It works with both standalone and cluster instances.' || chr(13) || chr(10) || 'The metrics are collected by JMX.' || chr(13) || chr(10) || 'You can set {$CASSANDRA.USER} and {$CASSANDRA.PASSWORD} macros in the template for using on the host level.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/410057-discussion-thread-for-official-zabbix-template-apache-cassandra' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','5c42de26643c4b43b23a11159df021ce','APACHE CASSANDRA BY JMX','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10371',NULL,'Morningstar ProStar MPPT by SNMP','3','-1','2','','','Morningstar ProStar MPPT by SNMP','0',NULL,'MIBs used:' || chr(13) || chr(10) || 'PROSTAR-MPPT' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','b84324c2a40a496dbbb379bbf5dde8d5','MORNINGSTAR PROSTAR MPPT BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10372',NULL,'Morningstar ProStar PWM by SNMP','3','-1','2','','','Morningstar ProStar PWM by SNMP','0',NULL,'MIBs used:' || chr(13) || chr(10) || 'PROSTAR-PWM' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','24bed6339f0a492fab86fe757394b937','MORNINGSTAR PROSTAR PWM BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10373',NULL,'Morningstar SunSaver MPPT by SNMP','3','-1','2','','','Morningstar SunSaver MPPT by SNMP','0',NULL,'MIBs used:' || chr(13) || chr(10) || 'SUNSAVER-MPPT' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','f1336fd88ab0415a9c02892a71e50032','MORNINGSTAR SUNSAVER MPPT BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10374',NULL,'Morningstar SureSine by SNMP','3','-1','2','','','Morningstar SureSine by SNMP','0',NULL,'MIBs used:' || chr(13) || chr(10) || 'SURESINE' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','3bbfe42c78c74f04a2565431fbdd19e2','MORNINGSTAR SURESINE BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10375',NULL,'Morningstar TriStar MPPT 600V by SNMP','3','-1','2','','','Morningstar TriStar MPPT 600V by SNMP','0',NULL,'MIBs used:' || chr(13) || chr(10) || 'TRISTAR-MPPT' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','2d20a2fbd540492089fdcafc8feb60e3','MORNINGSTAR TRISTAR MPPT 600V BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10376',NULL,'Morningstar TriStar MPPT by SNMP','3','-1','2','','','Morningstar TriStar MPPT by SNMP','0',NULL,'MIBs used:' || chr(13) || chr(10) || 'TRISTAR-MPPT' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','07b32152c3654e8ead4c1eeae24efa8f','MORNINGSTAR TRISTAR MPPT BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10377',NULL,'Morningstar TriStar PWM by SNMP','3','-1','2','','','Morningstar TriStar PWM by SNMP','0',NULL,'MIBs used:' || chr(13) || chr(10) || 'TRISTAR' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','230fa9f7c1774821bbe6cdcbbba5cbc6','MORNINGSTAR TRISTAR PWM BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10378',NULL,'NetApp FAS3220 by SNMP','3','-1','2','','','NetApp FAS3220 by SNMP','0',NULL,'The template to monitor SAN NetApp FAS3220 cluster by Zabbix SNMP agent.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'NETAPP-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/416694-discussion-thread-for-official-zabbix-template-netapp-fas3220' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e118ab11c1ec4f9cbe21dfce1441c0f6','NETAPP FAS3220 BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10379',NULL,'Jenkins by HTTP','3','-1','2','','','Jenkins by HTTP','0',NULL,'Get Jenkins metrics by HTTP agent.' || chr(13) || chr(10) || 'Metrics are collected by requests to Metrics API. Install  Metrics plugin and configure access to the Metrics Servlet by issuing API key.' || chr(13) || chr(10) || 'Don''t forget to change macros {$JENKINS.URL}, {$JENKINS.USER}, {$JENKINS.API.TOKEN}, {$JENKINS.API.KEY}.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','2ef2f2eb75ee4a0bae839e22aa76e5fc','JENKINS BY HTTP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10380',NULL,'Hikvision camera by HTTP','3','-1','2','','','Hikvision camera by HTTP','0',NULL,'This template is designed for the effortless deployment of Hikvision cameras monitoring by Zabbix via HTTP and doesn''t require any external scripts.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Sample device overview page:' || chr(13) || chr(10) || 'https://www.hikvision.com/en/products/IP-Products/Network-Cameras/' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Setup:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1. Set the hostname or IP address of the Hikvision ISAPI host in the ''{$HIKVISION_ISAPI_HOST}'' macro.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '2. Set the user name and password in the ''{$PASSWORD}'' and ''{$USER}'' macros.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '3. Change other macros according to your camera configuration if necessary.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','3fb4020df2984b0ab64dfd8355ff5c65','HIKVISION CAMERA BY HTTP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10381',NULL,'Ignite by JMX','3','-1','2','','','Ignite by JMX','0',NULL,'The template to monitor Apache Ignite by Zabbix that work without any external scripts.' || chr(13) || chr(10) || '  It works with both standalone and cluster instances.' || chr(13) || chr(10) || '  The metrics are discoverable and collected by JMX.' || chr(13) || chr(10) || '  Current JMX tree hierarchy contains classloader by default. Add the following jvm option `-DIGNITE_MBEAN_APPEND_CLASS_LOADER_ID=false`to will exclude one level with Classloader name.' || chr(13) || chr(10) || '  You can set {$IGNITE.USER} and {$IGNITE.PASSWORD} macros in the template for using on the host level.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','ab05dbb15ff047f192782f617f0627ac','IGNITE BY JMX','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10382',NULL,'Microsoft SharePoint by HTTP','3','-1','2','','','Microsoft SharePoint by HTTP','0',NULL,'Overview:' || chr(13) || chr(10) || 'Template receives data via HTTP Agent.' || chr(13) || chr(10) || 'Setup:' || chr(13) || chr(10) || 'Create a new host.' || chr(13) || chr(10) || 'Define macros according to your Sharepoint web portal.' || chr(13) || chr(10) || 'It is recommended to fill in the values of the filter macros to avoid getting redundant data.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8d5fe5b4ebb64255a2429b34c7dd3681','MICROSOFT SHAREPOINT BY HTTP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10385',NULL,'Huawei OceanStor 5300 V5 by SNMP','3','-1','2','','','Huawei OceanStor 5300 V5 by SNMP','0',NULL,'The template to monitor SAN Huawei OceanStor 5300 V5 by Zabbix SNMP agent.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418855-discussion-thread-for-official-zabbix-template-huawei-oceanstor' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','c5564dd58c394b969d5365cc5de3e7f8','HUAWEI OCEANSTOR 5300 V5 BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10386',NULL,'MongoDB node by Zabbix agent 2','3','-1','2','','','MongoDB node by Zabbix agent 2','0',NULL,'Get MongoDB metrics from plugin for the zabbix-agent2.' || chr(13) || chr(10) || '  1. Setup and configure zabbix-agent2 compiled with the MongoDB monitoring plugin.' || chr(13) || chr(10) || '  2. Set the {$MONGODB.CONNSTRING} such as <protocol(host:port)> or named session.' || chr(13) || chr(10) || '  3. Set the user name and password in host macros ({$MONGODB.USER}, {$MONGODB.PASSWORD}) if you want to override parameters from the Zabbix agent configuration file.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420659-discussion-thread-for-official-zabbix-template-db-mongodb' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','81aa8c5ab5594f77a2b26fb7f5094048','MONGODB NODE BY ZABBIX AGENT 2','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10387',NULL,'MongoDB cluster by Zabbix agent 2','3','-1','2','','','MongoDB cluster by Zabbix agent 2','0',NULL,'Get MongoDB metrics from plugin for the zabbix-agent2.' || chr(13) || chr(10) || '  1. Setup and configure zabbix-agent2 compiled with the MongoDB monitoring plugin.' || chr(13) || chr(10) || '  2. Set the {$MONGODB.CONNSTRING} such as <protocol(host:port)> or named session.' || chr(13) || chr(10) || '  3. Set the user name and password in host macros ({$MONGODB.USER}, {$MONGODB.PASSWORD}) if you want to override parameters from the Zabbix agent configuration file.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  All sharded Mongodb nodes (mongod) will be discovered with attached template "MongoDB node".' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420659-discussion-thread-for-official-zabbix-template-db-mongodb' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','d38b271797bd41f2ad8c79d83b9d8d9c','MONGODB CLUSTER BY ZABBIX AGENT 2','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10388',NULL,'{#HOSTNAME}','0','-1','2','','','{#HOSTNAME}','2',NULL,'','1','1','','','','','0','0','809db5d8d32a45898e8401f288a42fac','{#HOSTNAME}','','',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10389',NULL,'{#HOSTNAME}','0','-1','2','','','{#HOSTNAME}','2',NULL,'','1','1','','','','','0','0','3fcd3244b1234186bda9a35c8f61c850','{#HOSTNAME}','','',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10390',NULL,'Cisco Catalyst 3750V2-24FS by SNMP','3','-1','2','','','Cisco Catalyst 3750V2-24FS by SNMP','0',NULL,'Template Cisco Catalyst 3750V2-24FS' || chr(13) || chr(10) || '  ' || chr(13) || chr(10) || '  MIBs used:' || chr(13) || chr(10) || '  CISCO-MEMORY-POOL-MIB' || chr(13) || chr(10) || '  IF-MIB' || chr(13) || chr(10) || '  EtherLike-MIB' || chr(13) || chr(10) || '  SNMPv2-MIB' || chr(13) || chr(10) || '  CISCO-PROCESS-MIB' || chr(13) || chr(10) || '  CISCO-ENVMON-MIB' || chr(13) || chr(10) || '  ENTITY-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418396-discussion-thread-for-official-zabbix-templates-for-cisco' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','6ff896f545e043cc98de6d98698d41df','CISCO CATALYST 3750V2-24FS BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10391',NULL,'Cisco Catalyst 3750V2-24PS by SNMP','3','-1','2','','','Cisco Catalyst 3750V2-24PS by SNMP','0',NULL,'Template Cisco Catalyst 3750V2-24PS' || chr(13) || chr(10) || '  ' || chr(13) || chr(10) || '  MIBs used:' || chr(13) || chr(10) || '  CISCO-MEMORY-POOL-MIB' || chr(13) || chr(10) || '  IF-MIB' || chr(13) || chr(10) || '  EtherLike-MIB' || chr(13) || chr(10) || '  SNMPv2-MIB' || chr(13) || chr(10) || '  CISCO-PROCESS-MIB' || chr(13) || chr(10) || '  CISCO-ENVMON-MIB' || chr(13) || chr(10) || '  ENTITY-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418396-discussion-thread-for-official-zabbix-templates-for-cisco' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','4583f0c3bc894251a6c5e7129cb5b9aa','CISCO CATALYST 3750V2-24PS BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10392',NULL,'Cisco Catalyst 3750V2-24TS by SNMP','3','-1','2','','','Cisco Catalyst 3750V2-24TS by SNMP','0',NULL,'Template Cisco Catalyst 3750V2-24TS' || chr(13) || chr(10) || '  ' || chr(13) || chr(10) || '  MIBs used:' || chr(13) || chr(10) || '  CISCO-MEMORY-POOL-MIB' || chr(13) || chr(10) || '  IF-MIB' || chr(13) || chr(10) || '  EtherLike-MIB' || chr(13) || chr(10) || '  SNMPv2-MIB' || chr(13) || chr(10) || '  CISCO-PROCESS-MIB' || chr(13) || chr(10) || '  CISCO-ENVMON-MIB' || chr(13) || chr(10) || '  ENTITY-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418396-discussion-thread-for-official-zabbix-templates-for-cisco' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','30d084c6b7844b7cab6cf820b00bb7b2','CISCO CATALYST 3750V2-24TS BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10393',NULL,'Cisco Catalyst 3750V2-48PS by SNMP','3','-1','2','','','Cisco Catalyst 3750V2-48PS by SNMP','0',NULL,'Template Cisco Catalyst 3750V2-48PS' || chr(13) || chr(10) || '  ' || chr(13) || chr(10) || '  MIBs used:' || chr(13) || chr(10) || '  CISCO-MEMORY-POOL-MIB' || chr(13) || chr(10) || '  IF-MIB' || chr(13) || chr(10) || '  EtherLike-MIB' || chr(13) || chr(10) || '  SNMPv2-MIB' || chr(13) || chr(10) || '  CISCO-PROCESS-MIB' || chr(13) || chr(10) || '  CISCO-ENVMON-MIB' || chr(13) || chr(10) || '  ENTITY-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418396-discussion-thread-for-official-zabbix-templates-for-cisco' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','ea096c13a09b4d7a9be0aab1cec95206','CISCO CATALYST 3750V2-48PS BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10394',NULL,'Cisco Catalyst 3750V2-48TS by SNMP','3','-1','2','','','Cisco Catalyst 3750V2-48TS by SNMP','0',NULL,'Template Cisco Catalyst 3750V2-48TS' || chr(13) || chr(10) || '  ' || chr(13) || chr(10) || '  MIBs used:' || chr(13) || chr(10) || '  CISCO-MEMORY-POOL-MIB' || chr(13) || chr(10) || '  IF-MIB' || chr(13) || chr(10) || '  EtherLike-MIB' || chr(13) || chr(10) || '  SNMPv2-MIB' || chr(13) || chr(10) || '  CISCO-PROCESS-MIB' || chr(13) || chr(10) || '  CISCO-ENVMON-MIB' || chr(13) || chr(10) || '  ENTITY-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418396-discussion-thread-for-official-zabbix-templates-for-cisco' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','f744679600844c07b2b4eedda9bc3d0c','CISCO CATALYST 3750V2-48TS BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10395',NULL,'APC UPS by SNMP','3','-1','2','','','APC UPS by SNMP','0',NULL,'Template Power APC UPS' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'PowerNet-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','3ec55c9966624ef5bc1b50502812d581','APC UPS BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10396',NULL,'NetApp AFF A700 by HTTP','3','-1','2','','','NetApp AFF A700 by HTTP','0',NULL,'The template to monitor SAN NetApp AFF A700 cluster by Zabbix HTTP agent.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','79267c69f54a4e59b4152aba4e8c4bd5','NETAPP AFF A700 BY HTTP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10397',NULL,'TiDB PD by HTTP','3','-1','2','','','TiDB PD by HTTP','0',NULL,'The template to monitor PD server of TiDB cluster by Zabbix that works without any external scripts.' || chr(13) || chr(10) || 'Most of the metrics are collected in one go, thanks to Zabbix bulk data collection.' || chr(13) || chr(10) || 'Don''t forget to change the macros {$PD.URL}, {$PD.PORT}.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template `TiDB PD by HTTP` — collects metrics by HTTP agent from PD /metrics endpoint and from monitoring API.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','43596328d4d74a5592906a9e08e3fd96','TIDB PD BY HTTP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10398',NULL,'TiDB by HTTP','3','-1','2','','','TiDB by HTTP','0',NULL,'The template to monitor TiDB server of TiDB cluster by Zabbix that works without any external scripts.' || chr(13) || chr(10) || 'Most of the metrics are collected in one go, thanks to Zabbix bulk data collection.' || chr(13) || chr(10) || 'Don''t forget to change the macros {$TIDB.URL}, {$TIDB.PORT}.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template `TiDB by HTTP` — collects metrics by HTTP agent from PD /metrics endpoint and from monitoring API.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8ec72ebbe3204d7789429640abcac610','TIDB BY HTTP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10399',NULL,'TiDB TiKV by HTTP','3','-1','2','','','TiDB TiKV by HTTP','0',NULL,'The template to monitor TiKV server of TiDB cluster by Zabbix that works without any external scripts.' || chr(13) || chr(10) || 'Most of the metrics are collected in one go, thanks to Zabbix bulk data collection.' || chr(13) || chr(10) || 'Don''t forget to change the macros {$TIKV.URL}, {$TIKV.PORT}.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template `TiDB TiKV by HTTP` — collects metrics by HTTP agent from TiKV /metrics endpoint.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','3a0bbbb2ec0a4c58bba3ba3a3d6ce660','TIDB TIKV BY HTTP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10400',NULL,'APC UPS Galaxy 3500 by SNMP','3','-1','2','','','APC UPS Galaxy 3500 by SNMP','0',NULL,'Template Power APC UPS Galaxy 3500' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'PowerNet-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','5d3971cd973b46e7915d7ae0750bac57','APC UPS GALAXY 3500 BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10401',NULL,'APC Smart-UPS 2200 RM by SNMP','3','-1','2','','','APC Smart-UPS 2200 RM by SNMP','0',NULL,'Template Power APC Smart-UPS 2200 RM' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'PowerNet-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e8c0b2c40e884f1598d86f3edf020ea7','APC SMART-UPS 2200 RM BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10402',NULL,'APC Smart-UPS 3000 XLM by SNMP','3','-1','2','','','APC Smart-UPS 3000 XLM by SNMP','0',NULL,'Template Power APC Smart-UPS 3000 XLM' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'PowerNet-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','eafd78764fde4110b9e46ae184f327ba','APC SMART-UPS 3000 XLM BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10403',NULL,'APC Smart-UPS RT 1000 RM XL by SNMP','3','-1','2','','','APC Smart-UPS RT 1000 RM XL by SNMP','0',NULL,'Template Power APC Smart-UPS RT 1000 RM XL' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'PowerNet-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','340ec6917c274ead8fab36925e57f30a','APC SMART-UPS RT 1000 RM XL BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10404',NULL,'APC Smart-UPS RT 1000 XL by SNMP','3','-1','2','','','APC Smart-UPS RT 1000 XL by SNMP','0',NULL,'Template Power APC Smart-UPS RT 1000 XL' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'PowerNet-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','32d3c78ff44c4c3c9ff5b893ad7f5fc9','APC SMART-UPS RT 1000 XL BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10406',NULL,'APC Smart-UPS SRT 8000 by SNMP','3','-1','2','','','APC Smart-UPS SRT 8000 by SNMP','0',NULL,'Template Power APC Smart-UPS SRT 8000' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'PowerNet-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','b3caafda8c5345cc832ac3be3cefa615','APC SMART-UPS SRT 8000 BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10407',NULL,'APC UPS Symmetra LX by SNMP','3','-1','2','','','APC UPS Symmetra LX by SNMP','0',NULL,'Template Power APC UPS Symmetra LX' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'PowerNet-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','0b9a899ff8f1467c9fdf999d02b9fd77','APC UPS SYMMETRA LX BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10408',NULL,'APC UPS Symmetra RM by SNMP','3','-1','2','','','APC UPS Symmetra RM by SNMP','0',NULL,'Template Power APC UPS Symmetra RM' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'PowerNet-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','1dac0a88c3774315b90622a48031e369','APC UPS SYMMETRA RM BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10409',NULL,'APC UPS Symmetra RX by SNMP','3','-1','2','','','APC UPS Symmetra RX by SNMP','0',NULL,'Template Power APC UPS Symmetra RX' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'PowerNet-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','4ffb0f9103084384a98379ed533865e9','APC UPS SYMMETRA RX BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10410',NULL,'WildFly Domain by JMX','3','-1','2','','','WildFly Domain by JMX','0',NULL,'Official JMX Template for WildFly.' || chr(13) || chr(10) || 'The metrics are collected by JMX. This template works with Domain Controller.' || chr(13) || chr(10) || 'You can set {$WILDFLY.USER} and {$WILDFLY.PASSWORD} macros in the template for using on the host level.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','4b27e636b6ad4ce68511d344d5604999','WILDFLY DOMAIN BY JMX','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10411',NULL,'WildFly Server by JMX','3','-1','2','','','WildFly Server by JMX','0',NULL,'Official JMX Template for WildFly.' || chr(13) || chr(10) || 'The metrics are collected by JMX. This template works with standalone and domain instances.' || chr(13) || chr(10) || 'You can set {$WILDFLY.USER} and {$WILDFLY.PASSWORD} macros in the template for using on the host level.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','2bf5827343f0420792ad953f290baa05','WILDFLY SERVER BY JMX','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10412',NULL,'APC Smart-UPS SRT 5000 by SNMP','3','-1','2','','','APC Smart-UPS SRT 5000 by SNMP','0',NULL,'Template Power APC Smart-UPS SRT 5000' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'PowerNet-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8ec76aeb703747a5affdf435bc12f572','APC SMART-UPS SRT 5000 BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10413',NULL,'Website certificate by Zabbix agent 2','3','-1','2','','','Website certificate by Zabbix agent 2','0',NULL,'The template to monitor TLS/SSL certificate on the website by Zabbix agent 2 that works without any external scripts.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Zabbix agent 2 with the WebCertificate plugin requests certificate using the web.certificate.get key and returns JSON with certificate attributes.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/428309-discussion-thread-for-official-zabbix-template-tls-ssl-certificates-monitoring' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','5630ec1b1baf449abe1bc5521f85fe6c','WEBSITE CERTIFICATE BY ZABBIX AGENT 2','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10414',NULL,'Cloudflare by HTTP','3','-1','2','','','Cloudflare by HTTP','0',NULL,'The template to monitor Cloudflare to see your web traffic and DNS metrics.' || chr(13) || chr(10) || 'It works without any external scripts and uses Script item.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','08ef3d687d754b0aba17e1dcbd77d4bd','CLOUDFLARE BY HTTP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10415',NULL,'NGINX Plus by HTTP','3','-1','2','','','NGINX Plus by HTTP','0',NULL,'Get Nginx Plus metrics by HTTP agent.' || chr(13) || chr(10) || 'Metrics are collected by requests to Nginx Plus API.' || chr(13) || chr(10) || 'Don''t forget to change macros {$NGINX.API.ENDPOINT}.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8cad0f2564694416b60bd8a414948641','NGINX PLUS BY HTTP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10416',NULL,'Systemd by Zabbix agent 2','3','-1','2','','','Systemd by Zabbix agent 2','0',NULL,'Get systemd units metrics from plugin for the zabbix-agent2.' || chr(13) || chr(10) || '  1. Setup and configure zabbix-agent2 compiled with the Systemd monitoring plugin.' || chr(13) || chr(10) || '  2. Set filters with macros if you want to override default filter parameters.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','90ac276995294a6aa88462c032d2ddaf','SYSTEMD BY ZABBIX AGENT 2','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10417',NULL,'GridGain by JMX','3','-1','2','','','GridGain by JMX','0',NULL,'The template to monitor GridGain In-Memory Computing Platform by Zabbix that work without any external scripts.' || chr(13) || chr(10) || '  It works with both standalone and cluster instances.' || chr(13) || chr(10) || '  The metrics are discoverable and collected by JMX.' || chr(13) || chr(10) || '  Current JMX tree hierarchy contains classloader by default. Add the following jvm option `-DIGNITE_MBEAN_APPEND_CLASS_LOADER_ID=false`to will exclude one level with Classloader name.' || chr(13) || chr(10) || '  You can set {$GRIDGAIN.USER} and {$GRIDGAIN.PASSWORD} macros in the template for using on the host level.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','47d87c39c121429b98a18f641aa443ea','GRIDGAIN BY JMX','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10418',NULL,'Cisco ASAv by SNMP','3','-1','2','','','Cisco ASAv by SNMP','0',NULL,'Template Net Cisco ASAv' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'CISCO-PORT-MIB' || chr(13) || chr(10) || 'CISCO-MEMORY-POOL-MIB' || chr(13) || chr(10) || 'CISCO-REMOTE-ACCESS-MONITOR-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || 'RFC1213-MIB' || chr(13) || chr(10) || 'CISCO-PROCESS-MIB' || chr(13) || chr(10) || 'ENTITY-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418396-discussion-thread-for-official-zabbix-templates-for-cisco' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','75d009cd4dc84ee7a8fc479fa2fbaeee','CISCO ASAV BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10419',NULL,'F5 Big-IP by SNMP','3','-1','2','','','F5 Big-IP by SNMP','0',NULL,'MIBs used:' || chr(13) || chr(10) || 'RFC1213-MIB' || chr(13) || chr(10) || 'F5-BIGIP-LOCAL-MIB' || chr(13) || chr(10) || 'F5-BIGIP-SYSTEM-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','44c2c2d94a4447c6a924386640e4854a','F5 BIG-IP BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10420',NULL,'ZYXEL AAM1212-51 IES-612 by SNMP','3','-1','2','','','ZYXEL AAM1212-51 IES-612 by SNMP','0',NULL,'ZYXEL AAM1212-51 / IES-612' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'RFC1213-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'ADSL-LINE-MIB' || chr(13) || chr(10) || 'ZYXEL-IESCOMMON-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.' || chr(13) || chr(10) || '  Version: all versions firmware' || chr(13) || chr(10) || '  Device: ZYXEL AAM1212-51 / IES-612' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','3a71dcdcfe0b4a0e8284d8939d335cce','ZYXEL AAM1212-51 IES-612 BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10421',NULL,'ZYXEL ES3500-8PD by SNMP','3','-1','2','','','ZYXEL ES3500-8PD by SNMP','0',NULL,'ZYXEL ES3500-8PD' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'RFC1213-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'ZYXEL-ES3500-8PD-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.' || chr(13) || chr(10) || '  Version: all versions firmware' || chr(13) || chr(10) || '  Device: ZYXEL ES3500-8PD' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','b8a6f34fd5c447b1b9310746a96f4e80','ZYXEL ES3500-8PD BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10422',NULL,'ZYXEL GS-4012F by SNMP','3','-1','2','','','ZYXEL GS-4012F by SNMP','0',NULL,'ZYXEL GS-4012F' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'ZYXEL-GS4012F-MIB' || chr(13) || chr(10) || 'RFC1213-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.' || chr(13) || chr(10) || '  Version: all versions firmware' || chr(13) || chr(10) || '  Device: ZYXEL GS-4012F' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','73f123bb9ffe4587a0269c7e8752b2ed','ZYXEL GS-4012F BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10423',NULL,'ZYXEL IES-500x by SNMP','3','-1','2','','','ZYXEL IES-500x by SNMP','0',NULL,'ZYXEL IES-500x' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'RFC1213-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'ADSL-LINE-MIB' || chr(13) || chr(10) || 'ZYXEL-IES5000-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.' || chr(13) || chr(10) || '  Version: all versions firmware' || chr(13) || chr(10) || '  Device: ZYXEL IES-500x' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','3db86b0d235e4c7b80f7d6144ca08925','ZYXEL IES-500X BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10424',NULL,'ZYXEL IES-6000 by SNMP','3','-1','2','','','ZYXEL IES-6000 by SNMP','0',NULL,'ZYXEL IES-6000' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'RFC1213-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'ADSL-LINE-MIB' || chr(13) || chr(10) || 'ZYXEL-IES5000-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.' || chr(13) || chr(10) || '  Version: all versions firmware' || chr(13) || chr(10) || '  Device: ZYXEL IES-6000' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','3645654baaf04f11927b171bcb048349','ZYXEL IES-6000 BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10425',NULL,'ZYXEL IES1248-51 by SNMP','3','-1','2','','','ZYXEL IES1248-51 by SNMP','0',NULL,'ZYXEL IES1248-51' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'RFC1213-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'ADSL-LINE-MIB' || chr(13) || chr(10) || 'ZYXEL-IESCOMMON-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.' || chr(13) || chr(10) || '  Version: all versions firmware' || chr(13) || chr(10) || '  Device: ZYXEL IES1248-51' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8e6d7067cd094e56a52db999b3199edc','ZYXEL IES1248-51 BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10426',NULL,'ZYXEL MES-3528 by SNMP','3','-1','2','','','ZYXEL MES-3528 by SNMP','0',NULL,'ZYXEL MES-3528' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'RFC1213-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'ZYXEL-MES3528-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.' || chr(13) || chr(10) || '  Version: all versions firmware' || chr(13) || chr(10) || '  Device: ZYXEL MES-3528' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','249de8d8d21e4dda9c3f766ab6201378','ZYXEL MES-3528 BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10427',NULL,'ZYXEL MES3500-10 by SNMP','3','-1','2','','','ZYXEL MES3500-10 by SNMP','0',NULL,'ZYXEL MES3500-10' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'RFC1213-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'ZYXEL-MES3500-10-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.' || chr(13) || chr(10) || '  Version: all versions firmware' || chr(13) || chr(10) || '  Device: ZYXEL MES3500-10' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','21a95afef0e74fb19691693090403d1d','ZYXEL MES3500-10 BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10428',NULL,'ZYXEL MES3500-24 by SNMP','3','-1','2','','','ZYXEL MES3500-24 by SNMP','0',NULL,'ZYXEL MES3500-24' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'RFC1213-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'ZYXEL-MES3500-24-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.' || chr(13) || chr(10) || '  Version: all versions firmware' || chr(13) || chr(10) || '  Device: ZYXEL MES3500-24' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','292970ad91204722b5e5cb3233fc0026','ZYXEL MES3500-24 BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10429',NULL,'ZYXEL MGS-3712 by SNMP','3','-1','2','','','ZYXEL MGS-3712 by SNMP','0',NULL,'ZYXEL MGS-3712' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'RFC1213-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'ZYXEL-MGS3712F-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.' || chr(13) || chr(10) || '  Version: all versions firmware' || chr(13) || chr(10) || '  Device: ZYXEL MGS-3712' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8ea7299983f24d0a913606e334f0e526','ZYXEL MGS-3712 BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10430',NULL,'ZYXEL MGS-3712F by SNMP','3','-1','2','','','ZYXEL MGS-3712F by SNMP','0',NULL,'ZYXEL MGS-3712F' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'RFC1213-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'ZYXEL-MGS3712F-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.' || chr(13) || chr(10) || '  Version: all versions firmware' || chr(13) || chr(10) || '  Device: ZYXEL MGS-3712F' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','01deb47efa1f4a9092de67fd61820a7d','ZYXEL MGS-3712F BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10431',NULL,'ZYXEL MES3500-24S by SNMP','3','-1','2','','','ZYXEL MES3500-24S by SNMP','0',NULL,'ZYXEL MES3500-24S' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'ZYXEL-TRANSCEIVER-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || 'RFC1213-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'ZYXEL-HW-MONITOR-MIB' || chr(13) || chr(10) || 'ZYXEL-PORT-MIB' || chr(13) || chr(10) || 'ZYXEL-ES-COMMON' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.' || chr(13) || chr(10) || '  Version: all versions firmware' || chr(13) || chr(10) || '  Device: ZYXEL MGS3520-28' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','89eef2fe23964f44bf9aec6d00e39efd','ZYXEL MES3500-24S BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10432',NULL,'ZYXEL MGS3520-28x by SNMP','3','-1','2','','','ZYXEL MGS3520-28x by SNMP','0',NULL,'ZYXEL MGS3520-28x' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'ZYXEL-TRANSCEIVER-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || 'RFC1213-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'ZYXEL-HW-MONITOR-MIB' || chr(13) || chr(10) || 'ZYXEL-PORT-MIB' || chr(13) || chr(10) || 'ZYXEL-ES-COMMON' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.' || chr(13) || chr(10) || '  Version: all versions firmware' || chr(13) || chr(10) || '  Device: ZYXEL MGS3520-28' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','9cc843a085bb4ee5af0dc4d764a7eee9','ZYXEL MGS3520-28X BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10433',NULL,'ZYXEL XGS-4728F by SNMP','3','-1','2','','','ZYXEL XGS-4728F by SNMP','0',NULL,'ZYXEL XGS-4728F' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'RFC1213-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'ZYXEL-XGS4728F-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.' || chr(13) || chr(10) || '  Version: all versions firmware' || chr(13) || chr(10) || '  Device: ZYXEL XGS-4728F' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','ab18a5665b7d4bed876881b5c4e8ce51','ZYXEL XGS-4728F BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10434',NULL,'Cisco UCS Manager by SNMP','3','-1','2','','','Cisco UCS Manager by SNMP','0',NULL,'This is a template for Cisco UCS Manager monitoring via Zabbix SNMP Agent that works without any external scripts.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'CISCO-UNIFIED-COMPUTING-COMPUTE-MIB' || chr(13) || chr(10) || 'CISCO-UNIFIED-COMPUTING-EQUIPMENT-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'CISCO-UNIFIED-COMPUTING-PROCESSOR-MIB' || chr(13) || chr(10) || 'CISCO-UNIFIED-COMPUTING-STORAGE-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418396-discussion-thread-for-official-zabbix-templates-for-cisco' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','d5eb4ce08a334098a85e6e02c534be90','CISCO UCS MANAGER BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10435',NULL,'DELL PowerEdge R720 by HTTP','3','-1','2','','','DELL PowerEdge R720 by HTTP','0',NULL,'Template for DELL PowerEdge R720 servers with iDRAC 8/9 firmware 4.32 and later and Redfish API enabled.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','9643f22821104f809e2486be83e1816e','DELL POWEREDGE R720 BY HTTP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10436',NULL,'DELL PowerEdge R720 by SNMP','3','-1','2','','','DELL PowerEdge R720 by SNMP','0',NULL,'Template for DELL PowerEdge R720 servers with iDRAC version 7 and later.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'IDRAC-MIB-SMIv2' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','fe5b8448661f41b9a6d948fccd7f9045','DELL POWEREDGE R720 BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10437',NULL,'DELL PowerEdge R740 by HTTP','3','-1','2','','','DELL PowerEdge R740 by HTTP','0',NULL,'Template for DELL PowerEdge R740 servers with iDRAC 8/9 firmware 4.32 and later and Redfish API enabled.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','3f707f39c32a4b6e8b214c38a260f6f9','DELL POWEREDGE R740 BY HTTP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10438',NULL,'DELL PowerEdge R740 by SNMP','3','-1','2','','','DELL PowerEdge R740 by SNMP','0',NULL,'Template for DELL PowerEdge R740 servers with iDRAC version 7 and later.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'IDRAC-MIB-SMIv2' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','9fde0e1c36f8453da72f97535d4e74ca','DELL POWEREDGE R740 BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10439',NULL,'DELL PowerEdge R820 by HTTP','3','-1','2','','','DELL PowerEdge R820 by HTTP','0',NULL,'Template for DELL PowerEdge R820 servers with iDRAC 8/9 firmware 4.32 and later and Redfish API enabled.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','1e9fe6b88c7542638c0f5d94484858b2','DELL POWEREDGE R820 BY HTTP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10440',NULL,'DELL PowerEdge R820 by SNMP','3','-1','2','','','DELL PowerEdge R820 by SNMP','0',NULL,'Template for DELL PowerEdge R820 servers with iDRAC version 7 and later.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'IDRAC-MIB-SMIv2' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','d41c5d0fa91545d68cced1b5dabe4bf1','DELL POWEREDGE R820 BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10441',NULL,'DELL PowerEdge R840 by HTTP','3','-1','2','','','DELL PowerEdge R840 by HTTP','0',NULL,'Template for DELL PowerEdge R840 servers with iDRAC 8/9 firmware 4.32 and later and Redfish API enabled.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','20147f00f92d4240aab0b70cf578c022','DELL POWEREDGE R840 BY HTTP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10442',NULL,'DELL PowerEdge R840 by SNMP','3','-1','2','','','DELL PowerEdge R840 by SNMP','0',NULL,'Template for DELL PowerEdge R840 servers with iDRAC version 7 and later.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'IDRAC-MIB-SMIv2' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','fc834b8da8864678b55557e9a237eac9','DELL POWEREDGE R840 BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10443',NULL,'HPE ProLiant BL460 by SNMP','3','-1','2','','','HPE ProLiant BL460 by SNMP','0',NULL,'Template for HPE ProLiant BL460 servers with HP iLO version 4 and later.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'CPQHLTH-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'CPQNIC-MIB' || chr(13) || chr(10) || 'CPQSINFO-MIB' || chr(13) || chr(10) || 'CPQIDA-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','172ec7e51f1c4a6ba49baffbab3dda97','HPE PROLIANT BL460 BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10444',NULL,'HPE ProLiant BL920 by SNMP','3','-1','2','','','HPE ProLiant BL920 by SNMP','0',NULL,'Template for HPE ProLiant BL920 servers with HP iLO version 4 and later.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'CPQHLTH-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'CPQNIC-MIB' || chr(13) || chr(10) || 'CPQSINFO-MIB' || chr(13) || chr(10) || 'CPQIDA-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','586119e5e27e4062a3cce8601ecb8d71','HPE PROLIANT BL920 BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10445',NULL,'HPE ProLiant DL360 by SNMP','3','-1','2','','','HPE ProLiant DL360 by SNMP','0',NULL,'Template for HPE ProLiant DL360 servers with HP iLO version 4 and later.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'CPQHLTH-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'CPQNIC-MIB' || chr(13) || chr(10) || 'CPQSINFO-MIB' || chr(13) || chr(10) || 'CPQIDA-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','60cb9ccb922e4fd194a1d9573db10237','HPE PROLIANT DL360 BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10446',NULL,'HPE ProLiant DL380 by SNMP','3','-1','2','','','HPE ProLiant DL380 by SNMP','0',NULL,'Template for HPE ProLiant DL380 servers with HP iLO version 4 and later.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'CPQHLTH-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'CPQNIC-MIB' || chr(13) || chr(10) || 'CPQSINFO-MIB' || chr(13) || chr(10) || 'CPQIDA-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','379aaf7e87574debb4f5c3947a22ec68','HPE PROLIANT DL380 BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10447',NULL,'Travis CI by HTTP','3','-1','2','','','Travis CI by HTTP','0',NULL,'Template for monitoring Travis CI https://travis-ci.com' || chr(13) || chr(10) || 'You must set {$TRAVIS.API.TOKEN} and {$TRAVIS.API.URL} macros.' || chr(13) || chr(10) || '  {$TRAVIS.API.TOKEN} is a Travis API authentication token located in User -> Settings -> API authentication.' || chr(13) || chr(10) || '  {$TRAVIS.API.URL} could be in 2 different variations:' || chr(13) || chr(10) || '   - for a private project : api.travis-ci.com' || chr(13) || chr(10) || '   - for an enterprise projects: api.example.com (where you replace example.com with the domain Travis CI is running on)' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8cdbe00a2a3046ee962d28d32567968a','TRAVIS CI BY HTTP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10448',NULL,'InfluxDB by HTTP','3','-1','2','','','InfluxDB by HTTP','0',NULL,'Get InfluxDB metrics by HTTP agent from Prometheus metrics endpoint.' || chr(13) || chr(10) || 'For organization discovery template need to use Authorization via API token. See docs: https://docs.influxdata.com/influxdb/v2.0/security/tokens/' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Don''t forget change macros {$INFLUXDB.URL}, {$INFLUXDB.API.TOKEN}.' || chr(13) || chr(10) || 'Some metrics may not be collected depending on your InfluxDB instance version and configuration.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','a6fe3640b23544e7ae15d438b38ce1cd','INFLUXDB BY HTTP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10449',NULL,'MikroTik CCR1009-7G-1C-1SPC by SNMP','3','-1','2','','','MikroTik CCR1009-7G-1C-1S+PC by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR1009-7G-1C-1S+PC.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '7x Gigabit Ethernet, 1x Combo port (SFP or Gigabit Ethernet), 1xSFP+ cage, 9' || chr(13) || chr(10) || 'cores x 1GHz CPU, 2GB RAM, LCD panel, passive cooling desktop enclosure, SmartCard' || chr(13) || chr(10) || 'slot, RouterOS L6, PSU' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','d596d6d231bf49c08890aa3ff135ecc6','MIKROTIK CCR1009-7G-1C-1S+PC BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10450',NULL,'MikroTik CCR1009-7G-1C-1S by SNMP','3','-1','2','','','MikroTik CCR1009-7G-1C-1S+ by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR1009-7G-1C-1S+.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1U rackmount, 7x Gigabit Ethernet, 1x Combo port (SFP or Gigabit Ethernet),' || chr(13) || chr(10) || '1xSFP+ cage, 9 cores x 1.2GHz CPU, 2GB RAM, LCD panel, Dual Power supplies,' || chr(13) || chr(10) || 'SmartCard slot, RouterOS L6' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','a809695fbc784b75adcd4833c86bca8d','MIKROTIK CCR1009-7G-1C-1S+ BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10451',NULL,'MikroTik CCR1009-7G-1C-PC by SNMP','3','-1','2','','','MikroTik CCR1009-7G-1C-PC by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR1009-7G-1C-PC.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '7x Gigabit Ethernet, 1x Combo port (SFP or Gigabit Ethernet), 9 cores x 1GHz' || chr(13) || chr(10) || 'CPU, 1GB RAM, passive cooling case, RouterOS L6' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','012e7043ff9849e197c42bf41cdf4d9a','MIKROTIK CCR1009-7G-1C-PC BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10452',NULL,'MikroTik CCR1016-12G by SNMP','3','-1','2','','','MikroTik CCR1016-12G by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR1016-12G.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1U rackmount, 12x Gigabit Ethernet, LCD, 16 cores x 1.2GHz CPU, 2GB RAM, 17.8mpps' || chr(13) || chr(10) || 'fastpath, Up to 12Gbit/s throughput, RouterOS L6, Dual PSU' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','5ed19d1f74224588bf5f53ac47003acc','MIKROTIK CCR1016-12G BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10453',NULL,'MikroTik CCR1016-12S-1S by SNMP','3','-1','2','','','MikroTik CCR1016-12S-1S+ by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR1016-12S-1S+.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1U rackmount, 12xSFP cage, 1xSFP+ cage, 16 cores x 1.2GHz CPU, 2GB RAM, LCD' || chr(13) || chr(10) || 'panel, Dual Power supplies, RouterOS L6' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','654910b270d9464f863ed085ba7302ce','MIKROTIK CCR1016-12S-1S+ BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10454',NULL,'MikroTik CCR1036-12G-4S-EM by SNMP','3','-1','2','','','MikroTik CCR1036-12G-4S-EM by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR1036-12G-4S-EM.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1U rackmount, 12x Gigabit Ethernet, 4xSFP cages, LCD, 36 cores x 1.2GHz CPU,' || chr(13) || chr(10) || '8GB RAM, 24 mpps fastpath, Up to 16Gbit/s throughput, RouterOS L6, Dual PSU' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','930c0e0534a9424fb01f2b6218d8ce59','MIKROTIK CCR1036-12G-4S-EM BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10455',NULL,'MikroTik CCR1036-12G-4S by SNMP','3','-1','2','','','MikroTik CCR1036-12G-4S by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR1036-12G-4S.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1U rackmount, 12x Gigabit Ethernet, 4xSFP cages, LCD, 36 cores x 1.2GHz CPU,' || chr(13) || chr(10) || '4GB RAM, 24 mpps fastpath, Up to 16Gbit/s throughput, RouterOS L6, Dual PSU' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','82b428ad78d34988b93f3d577f2b6adc','MIKROTIK CCR1036-12G-4S BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10456',NULL,'MikroTik CCR1036-8G-2SEM by SNMP','3','-1','2','','','MikroTik CCR1036-8G-2S+EM by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR1036-8G-2S+EM.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1U rackmount, 8x Gigabit Ethernet, 2xSFP+ cages, LCD, 36 cores x 1.2GHz CPU,' || chr(13) || chr(10) || '8GB RAM, 41.5mpps fastpath, Up to 28Gbit/s throughput, RouterOS L6, Dual PSU' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','7b3ecb24366f4685970df8e1143323f0','MIKROTIK CCR1036-8G-2S+EM BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10457',NULL,'MikroTik CCR1036-8G-2S by SNMP','3','-1','2','','','MikroTik CCR1036-8G-2S+ by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR1036-8G-2S+.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1U rackmount, 8x Gigabit Ethernet, 2xSFP+ cages, LCD, 36 cores x 1.2GHz CPU,' || chr(13) || chr(10) || '4GB RAM, 41.5mpps fastpath, Up to 28Gbit/s throughput, RouterOS L6, Dual PSU' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','7f44e67e3f564ec9894c9142d7276553','MIKROTIK CCR1036-8G-2S+ BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10458',NULL,'MikroTik CCR1072-1G-8S by SNMP','3','-1','2','','','MikroTik CCR1072-1G-8S+ by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR1072-1G-8S+.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1U rackmount, 1x Gigabit Ethernet, 8xSFP+ cages, LCD, 72 cores x 1GHz CPU, 16GB' || chr(13) || chr(10) || 'RAM, up to 120 million packets per second, 80Gbps throughput, RouterOS L6' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e7894db1c4c94e0f8715977e751368b3','MIKROTIK CCR1072-1G-8S+ BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10459',NULL,'MikroTik CCR2004-16G-2S by SNMP','3','-1','2','','','MikroTik CCR2004-16G-2S+ by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR2004-16G-2S+.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'This powerful and affordable router crushes all previous CCR models in single-core' || chr(13) || chr(10) || 'performance. 16x Gigabit Ethernet ports, 2x10G SFP+ cages, active cooling and' || chr(13) || chr(10) || 'the best single-core performance per watt & best overall performance per watt' || chr(13) || chr(10) || 'among all the CCR devices.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','ab871d051e304f83950171c5243aa4db','MIKROTIK CCR2004-16G-2S+ BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10460',NULL,'MikroTik CCR2004-1G-12S2XS by SNMP','3','-1','2','','','MikroTik CCR2004-1G-12S+2XS by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR2004-1G-12S+2XS.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'The Connectivity Router - your best companion when it comes to SFP, SFP+ and' || chr(13) || chr(10) || 'SFP28 management! 1, 10 and 25 Gbps ports in a single device to make your life' || chr(13) || chr(10) || 'easier.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','f2efeb94f4bd4ed9ab34a973c0363eb8','MIKROTIK CCR2004-1G-12S+2XS BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10461',NULL,'MikroTik CRS106-1C-5S by SNMP','3','-1','2','','','MikroTik CRS106-1C-5S by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS106-1C-5S.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Smart Switch, 5x SFP cages, 1x Combo port (SFP or Gigabit Ethernet), 400MHz' || chr(13) || chr(10) || 'CPU, 128MB RAM, desktop case, RouterOS L5' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','20ea139663264c21bca0dcecf2e95589','MIKROTIK CRS106-1C-5S BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10462',NULL,'MikroTik CRS109-8G-1S-2HnD-IN by SNMP','3','-1','2','','','MikroTik CRS109-8G-1S-2HnD-IN by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS109-8G-1S-2HnD-IN.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '8x Gigabit Smart Switch, 1x SFP cage, LCD, 802.11b/g/n Dual Chain wireless,' || chr(13) || chr(10) || '600MHz CPU, 128MB RAM, Metal desktop case, RouterOS L5, supports 10-57V, 802.3af/at' || chr(13) || chr(10) || 'compliant' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','fac16383680c4454be48b6db870d975e','MIKROTIK CRS109-8G-1S-2HND-IN BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10463',NULL,'MikroTik CRS112-8G-4S-IN by SNMP','3','-1','2','','','MikroTik CRS112-8G-4S-IN by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS112-8G-4S-IN.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '8x Gigabit Ethernet Smart Switch, 4x SFP cages, 400MHz CPU, 128MB RAM, desktop' || chr(13) || chr(10) || 'case, RouterOS L5' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8d7d49fd0b3f4b1f9046dc0e94457931','MIKROTIK CRS112-8G-4S-IN BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10464',NULL,'MikroTik CRS112-8P-4S-IN by SNMP','3','-1','2','','','MikroTik CRS112-8P-4S-IN by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS112-8P-4S-IN.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '8x Gigabit Ethernet Smart Switch with PoE-out, 4x SFP cages, 400MHz CPU, 128MB' || chr(13) || chr(10) || 'RAM, desktop case, RouterOS L5' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','538ec67ce01341a9b281dbd86d86d2a2','MIKROTIK CRS112-8P-4S-IN BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10465',NULL,'MikroTik CRS125-24G-1S-2HnD-IN by SNMP','3','-1','2','','','MikroTik CRS125-24G-1S-2HnD-IN by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS125-24G-1S-2HnD-IN.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '24x Gigabit Ethernet layer 3 Smart Switch, 1x SFP cage, LCD, 802.11b/g/n Dual' || chr(13) || chr(10) || 'Chain wireless, 600MHz CPU, 128MB RAM, Metal desktop case, RouterOS L5' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','c8db153405704d859ba5ee19f08b46f3','MIKROTIK CRS125-24G-1S-2HND-IN BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10466',NULL,'MikroTik CRS212-1G-10S-1SIN by SNMP','3','-1','2','','','MikroTik CRS212-1G-10S-1S+IN by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS212-1G-10S-1S+IN.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Smart Switch, 1x Gigabit LAN, 10x SFP cages, 1x SFP+ cage, LCD, 400MHz CPU,' || chr(13) || chr(10) || '64MB RAM, Metal desktop case, RouterOS L5' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','cdb6ebceb1174bada392dd24889b14d9','MIKROTIK CRS212-1G-10S-1S+IN BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10467',NULL,'MikroTik CRS305-1G-4SIN by SNMP','3','-1','2','','','MikroTik CRS305-1G-4S+IN by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS305-1G-4S+IN.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Five-port desktop switch with one Gigabit Ethernet port and four SFP+ 10Gbps' || chr(13) || chr(10) || 'ports' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','223101f878704022a04c30c3ff066e3f','MIKROTIK CRS305-1G-4S+IN BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10468',NULL,'MikroTik CRS309-1G-8SIN by SNMP','3','-1','2','','','MikroTik CRS309-1G-8S+IN by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS309-1G-8S+IN.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Desktop switch with one Gigabit Ethernet port and eight SFP+ 10Gbps ports' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','bcc01f2b466345c4bcbe0cea1a7884d1','MIKROTIK CRS309-1G-8S+IN BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10469',NULL,'MikroTik CRS312-4C8XG-RM by SNMP','3','-1','2','','','MikroTik CRS312-4C+8XG-RM by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS312-4C+8XG-RM.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Switch of the future: the first MikroTik product with 10G RJ45 Ethernet ports' || chr(13) || chr(10) || 'and SFP+' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8da94e2f01ff46e28becf0b08ff09ace','MIKROTIK CRS312-4C+8XG-RM BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10470',NULL,'MikroTik CRS317-1G-16SRM by SNMP','3','-1','2','','','MikroTik CRS317-1G-16S+RM by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS317-1G-16S+RM.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Smart Switch, 1 x Gigabit LAN, 16 x SFP+ cages, Dual Core 800MHz CPU, 1GB RAM,' || chr(13) || chr(10) || '1U rackmount passive cooling case, Dual Power Supplies' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','f474ff823fe84d689b9e4c6a4f0ce59e','MIKROTIK CRS317-1G-16S+RM BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10471',NULL,'MikroTik CRS326-24G-2SIN by SNMP','3','-1','2','','','MikroTik CRS326-24G-2S+IN by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS326-24G-2S+IN.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '24 Gigabit ports, 2 SFP+ cages and a desktop case – server room power for your' || chr(13) || chr(10) || 'home!' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','c5f41fe0f54f470f9e304384838f150a','MIKROTIK CRS326-24G-2S+IN BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10472',NULL,'MikroTik CRS326-24G-2SRM by SNMP','3','-1','2','','','MikroTik CRS326-24G-2S+RM by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS326-24G-2S+RM.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '24 Gigabit port switch with 2 x SFP+ cages in 1U rackmount case, Dual boot (RouterOS' || chr(13) || chr(10) || 'or SwitchOS)' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','bc80883918ac4f879427ca145122b5cb','MIKROTIK CRS326-24G-2S+RM BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10473',NULL,'MikroTik CRS326-24S2QRM by SNMP','3','-1','2','','','MikroTik CRS326-24S+2Q+RM by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS326-24S+2Q+RM.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Our fastest switch for the most demanding setups' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e7ed0e0cbd0b439394f6498ea90dc31d','MIKROTIK CRS326-24S+2Q+RM BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10474',NULL,'MikroTik CRS328-24P-4SRM by SNMP','3','-1','2','','','MikroTik CRS328-24P-4S+RM by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS328-24P-4S+RM.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '24 port Gigabit Ethernet router/switch with four 10Gbps SFP+ ports in 1U rackmount' || chr(13) || chr(10) || 'case, Dual Boot and PoE output, 500W' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','dcf88bca5aaf4123a10eb3daab28a9af','MIKROTIK CRS328-24P-4S+RM BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10475',NULL,'MikroTik CRS328-4C-20S-4SRM by SNMP','3','-1','2','','','MikroTik CRS328-4C-20S-4S+RM by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS328-4C-20S-4S+RM.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Smart Switch, 20 x SFP cages, 4 x SFP+ cages, 4 x Combo ports (Gigabit Ethernet' || chr(13) || chr(10) || 'or SFP), 800MHz CPU, 512MB RAM, 1U rackmount case, Dual Power Supplies, RouterOS' || chr(13) || chr(10) || 'L5 or SwitchOS (Dual Boot)' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','6742f5ed33ca4c19b8e61203770e5fe5','MIKROTIK CRS328-4C-20S-4S+RM BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10476',NULL,'MikroTik CRS354-48G-4S2QRM by SNMP','3','-1','2','','','MikroTik CRS354-48G-4S+2Q+RM by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS354-48G-4S+2Q+RM.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Best price and best performance on the market – this 48 port switch will rock' || chr(13) || chr(10) || 'any setup, including 40 Gbps devices!' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','d1c1ab5db2c34c17ae3541407f8b7faa','MIKROTIK CRS354-48G-4S+2Q+RM BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10477',NULL,'MikroTik CRS354-48P-4S2QRM by SNMP','3','-1','2','','','MikroTik CRS354-48P-4S+2Q+RM by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS354-48P-4S+2Q+RM.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'The 48 port champion you’ve been waiting for - now with PoE-out!' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','fa5e5e131eb34bbea1b1f7b2352a853d','MIKROTIK CRS354-48P-4S+2Q+RM BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10478',NULL,'MikroTik CSS326-24G-2SRM by SNMP','3','-1','2','','','MikroTik CSS326-24G-2S+RM by SNMP','0',NULL,'The template for monitoring Switch MikroTik CSS326-24G-2S+RM.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'SwOS powered 24 port Gigabit Ethernet switch with two SFP+ ports in 1U rackmount' || chr(13) || chr(10) || 'case' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','75ada0d6fb22416a9e6e5f44c2c3f64a','MIKROTIK CSS326-24G-2S+RM BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10479',NULL,'MikroTik CSS610-8G-2SIN by SNMP','3','-1','2','','','MikroTik CSS610-8G-2S+IN by SNMP','0',NULL,'The template for monitoring Switch MikroTik CSS610-8G-2S+IN.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Eight 1G Ethernet ports and two SFP+ ports for 10G fiber connectivity. Portable,' || chr(13) || chr(10) || 'powerful and extremely cost-effective - this switch is an instant classic!' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8d22b4d1a9c6457fbd6fd959263f91db','MIKROTIK CSS610-8G-2S+IN BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10480',NULL,'MikroTik FiberBox by SNMP','3','-1','2','','','MikroTik FiberBox by SNMP','0',NULL,'The template for monitoring Switch MikroTik FiberBox.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'An outdoor switch with five SFP ports' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','2bd6f566391d49dab6bee184522ab5fa','MIKROTIK FIBERBOX BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10481',NULL,'MikroTik PowerBox Pro by SNMP','3','-1','2','','','MikroTik PowerBox Pro by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik PowerBox Pro.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Five Gigabit Ethernet Router with 4xPoE-out ports, SFP cage and outdoor enclosure' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','c03e1ab0128a4ae1847bc04a34f5634e','MIKROTIK POWERBOX PRO BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10482',NULL,'MikroTik PowerBox by SNMP','3','-1','2','','','MikroTik PowerBox by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik PowerBox.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '650MHz CPU, 64MB RAM, 5xEthernet with PoE output for four ports, RouterOS L4,' || chr(13) || chr(10) || 'outdoor case, PSU' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','0c7b3c03a5854f868b56f3ab63e2d3f7','MIKROTIK POWERBOX BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10483',NULL,'MikroTik RB1100AHx4 Dude Edition by SNMP','3','-1','2','','','MikroTik RB1100AHx4 Dude Edition by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik RB1100AHx4 Dude Edition.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Powerful 1U rackmount router with 13x Gigabit Ethernet ports, 60GB M.2 drive' || chr(13) || chr(10) || 'for Dude database' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','fac50638cb77468598c29a6a47520c24','MIKROTIK RB1100AHX4 DUDE EDITION BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10484',NULL,'MikroTik RB1100AHx4 by SNMP','3','-1','2','','','MikroTik RB1100AHx4 by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik RB1100AHx4.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Powerful 1U rackmount router with 13x Gigabit Ethernet ports' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','3dfd1a55987848e5aa6ffe92c228f63b','MIKROTIK RB1100AHX4 BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10485',NULL,'MikroTik RB2011UiAS-IN by SNMP','3','-1','2','','','MikroTik RB2011UiAS-IN by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik RB2011UiAS-IN.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Desktop metal case, 5xEthernet, 5xGigabit Ethernet, USB, LCD, PoE out on port' || chr(13) || chr(10) || '10, 600MHz CPU, 128MB RAM, RouterOS L5' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8cf537f34600403b9de31d3db4eb2a1d','MIKROTIK RB2011UIAS-IN BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10486',NULL,'MikroTik RB2011UiAS-RM by SNMP','3','-1','2','','','MikroTik RB2011UiAS-RM by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik RB2011UiAS-RM.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1U rackmount, 5xEthernet, 5xGigabit Ethernet, USB, LCD, PoE out on port 10,' || chr(13) || chr(10) || '600MHz CPU, 128MB RAM, RouterOS L5' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','969cf5dca58f47f0b271ccf62ef79c13','MIKROTIK RB2011UIAS-RM BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10487',NULL,'MikroTik RB2011iL-IN by SNMP','3','-1','2','','','MikroTik RB2011iL-IN by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik RB2011iL-IN.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Desktop metal case, 5xEthernet, 5xGigabit Ethernet, PoE out on port 10, 600MHz' || chr(13) || chr(10) || 'CPU, 64MB RAM, RouterOS L4' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','141438a05f904b518c7d3ddfbbabf91f','MIKROTIK RB2011IL-IN BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10488',NULL,'MikroTik RB2011iL-RM by SNMP','3','-1','2','','','MikroTik RB2011iL-RM by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik RB2011iL-RM.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1U rackmount, 5xEthernet, 5xGigabit Ethernet, PoE out on port 10, 600MHz CPU,' || chr(13) || chr(10) || '64MB RAM, RouterOS L4' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','6d9737c72e5540d39e3553b773a587b1','MIKROTIK RB2011IL-RM BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10489',NULL,'MikroTik RB2011iLS-IN by SNMP','3','-1','2','','','MikroTik RB2011iLS-IN by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik RB2011iLS-IN.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Desktop metal case, 5xEthernet, 5xGigabit Ethernet, SFP cage, PoE out on port' || chr(13) || chr(10) || '10, 600MHz CPU, 64MB RAM, RouterOS L4' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','318fd61c22fa4f1a92a71376814d6c32','MIKROTIK RB2011ILS-IN BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10490',NULL,'MikroTik RB260GSP by SNMP','3','-1','2','','','MikroTik RB260GSP by SNMP','0',NULL,'The template for monitoring Switch MikroTik RB260GSP.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '5x Gigabit PoE out Ethernet Smart Switch, SFP cage, plastic case, SwOS' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','5331ecc3be9f47d6a8eb0732ae141239','MIKROTIK RB260GSP BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10491',NULL,'MikroTik RB260GS by SNMP','3','-1','2','','','MikroTik RB260GS by SNMP','0',NULL,'The template for monitoring Switch MikroTik RB260GS.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '5x Gigabit Ethernet Smart Switch, SFP cage, plastic case, SwOS' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','1a74dd95e7244493a1b13b94fe9dd9e8','MIKROTIK RB260GS BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10492',NULL,'MikroTik RB3011UiAS-RM by SNMP','3','-1','2','','','MikroTik RB3011UiAS-RM by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik RB3011UiAS-RM.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1U rackmount, 10xGigabit Ethernet, SFP, USB 3.0, LCD, PoE out on port 10, 2x1.4GHz' || chr(13) || chr(10) || 'CPU, 1GB RAM, RouterOS L5' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','cc762a057f0f467ab571b6d76a9bb278','MIKROTIK RB3011UIAS-RM BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10493',NULL,'MikroTik RB4011iGSRM by SNMP','3','-1','2','','','MikroTik RB4011iGS+RM by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik RB4011iGS+RM.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Powerful 10xGigabit port router with a Quad-core 1.4Ghz CPU, 1GB RAM, SFP+ 10Gbps' || chr(13) || chr(10) || 'cage and desktop case with rack ears' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','780c4a9a657e42fc83f1ab9a535f5184','MIKROTIK RB4011IGS+RM BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10494',NULL,'MikroTik RB5009UGSIN by SNMP','3','-1','2','','','MikroTik RB5009UG+S+IN by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik RB5009UG+S+IN.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'The ultimate heavy-duty home lab router with USB 3.0, 1G and 2.5G Ethernet and' || chr(13) || chr(10) || 'a 10G SFP+ cage. You can mount four of these new routers in a single 1U rackmount' || chr(13) || chr(10) || 'space! Unprecedented processing power in such a small form factor.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','7b6f7a12a6b449ca926e74c894eca354','MIKROTIK RB5009UG+S+IN BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10495',NULL,'MikroTik hEX PoE lite by SNMP','3','-1','2','','','MikroTik hEX PoE lite by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik hEX PoE lite.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '5xEthernet with PoE output for four ports, USB, 650MHz CPU, 64MB RAM, RouterOS' || chr(13) || chr(10) || 'L4' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','a5ddacdd5ac64b82bf5183769cc03e8c','MIKROTIK HEX POE LITE BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10496',NULL,'MikroTik hEX PoE by SNMP','3','-1','2','','','MikroTik hEX PoE by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik hEX PoE.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '5x Gigabit Ethernet with PoE output for four ports, SFP, USB, 800MHz CPU, 128MB' || chr(13) || chr(10) || 'RAM, RouterOS L4' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','ff57532daf924030b364e3b75acb74c4','MIKROTIK HEX POE BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10497',NULL,'MikroTik hEX S by SNMP','3','-1','2','','','MikroTik hEX S by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik hEX S.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '5x Gigabit Ethernet, SFP, Dual Core 880MHz CPU, 256MB RAM, USB, microSD, RouterOS' || chr(13) || chr(10) || 'L4, IPsec hardware encryption support and The Dude server package' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','7802db8c2f9c4a7eba7b381b8f3fa5c5','MIKROTIK HEX S BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10498',NULL,'MikroTik hEX lite by SNMP','3','-1','2','','','MikroTik hEX lite by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik hEX lite.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '5x Ethernet, Small plastic case, 850MHz CPU, 64MB RAM, Most affordable MPLS' || chr(13) || chr(10) || 'router, RouterOS L4' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','2785d83763c641a7a7937b516665d93a','MIKROTIK HEX LITE BY SNMP','Zabbix','7.0-0',NULL,'0')
/

INSERT INTO hosts (hostid,proxyid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,discover,custom_interfaces,uuid,name_upper,vendor_name,vendor_version,proxy_groupid,monitored_by)
values ('10499',NULL,'MikroTik hEX by SNMP','3','-1','2','','','MikroTik hEX by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik hEX.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '5x Gigabit Ethernet, Dual Core 880MHz CPU, 256MB RAM, USB, microSD, RouterOS' || chr(13) || chr(10) || 'L4' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13)