<?php declare(strict_types = 0);
/*
** Copyright (C) 2001-2024 Zabbix SIA
**
** This program is free software: you can redistribute it and/or modify it under the terms of
** the GNU Affero General Public License as published by the Free Software Foundation, version 3.
**
** This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
** without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** See the GNU Affero General Public License for more details.
**
** You should have received a copy of the GNU Affero General Public License along with this program.
** If not, see <https://www.gnu.org/licenses/>.
**/


namespace Widgets\Discovery\Actions;

use API,
	CArrayHelper,
	CControllerDashboardWidgetView,
	CControllerResponseData,
	CRoleHelper,
	CWebUser;

class WidgetView extends CControllerDashboardWidgetView {

	protected function doAction(): void {
		if ($this->getUserType() >= USER_TYPE_ZABBIX_ADMIN) {
			$drules = API::DRule()->get([
				'output' => ['druleid', 'name'],
				'selectDHosts' => ['status'],
				'filter' => ['status' => DHOST_STATUS_ACTIVE]
			]);
			CArrayHelper::sort($drules, ['name']);

			foreach ($drules as &$drule) {
				$drule['up'] = 0;
				$drule['down'] = 0;

				foreach ($drule['dhosts'] as $dhost){
					if ($dhost['status'] == DRULE_STATUS_DISABLED) {
						$drule['down']++;
					}
					else {
						$drule['up']++;
					}
				}
			}
			unset($drule);

			$error = null;
		}
		else {
			$drules = [];
			$error = _('No permissions to referred object or it does not exist!');
		}

		$this->setResponse(new CControllerResponseData([
			'name' => $this->getInput('name', $this->widget->getDefaultName()),
			'drules' => $drules,
			'error' => $error,
			'user' => [
				'debug_mode' => $this->getDebugMode()
			],
			'allowed_ui_discovery' => CWebUser::checkAccess(CRoleHelper::UI_MONITORING_DISCOVERY)
		]));
	}
}
