
# VMware

## Overview

This template is designed for the effortless deployment of both VMware vCenter and ESX hypervisor monitoring and doesn't require any external scripts.

The "VMware Hypervisor" and "VMware Guest" templates are used by discovery and normally should not be manually linked to a host.
For additional information please check https://www.zabbix.com/documentation/7.0/manual/vm_monitoring

## Requirements

Zabbix version: 7.0 and higher.

## Tested versions

This template has been tested on:
- VMware 6.0

## Configuration

> Zabbix should be configured according to the instructions in the [Templates out of the box](https://www.zabbix.com/documentation/7.0/manual/config/templates_out_of_the_box) section.

## Setup

1. Compile Zabbix server with the required options (`--with-libxml2` and `--with-libcurl`)
2. Set the `StartVMwareCollectors` option in Zabbix server configuration file to "1" or more
3. Create a new host
4. Set the host macros (on the host or template level) required for VMware authentication:
```text
{$VMWARE.URL}
{$VMWARE.USERNAME}
{$VMWARE.PASSWORD}
```
5. Link the template to host created earlier

Note: To enable discovery of hardware sensors of VMware Hypervisors, set the macro `{$VMWARE.HV.SENSOR.DISCOVERY}` to the value `true` on the discovered host level.

### Macros used

|Name|Description|Default|
|----|-----------|-------|
|{$VMWARE.URL}|<p>VMware service (vCenter or ESX hypervisor) SDK URL (https://servername/sdk)</p>||
|{$VMWARE.USERNAME}|<p>VMware service user name</p>||
|{$VMWARE.PASSWORD}|<p>VMware service {$USERNAME} user password</p>||
|{$VMWARE.HV.SENSOR.DISCOVERY}|<p>Set "true"/"false" to enable or disable monitoring of hardware sensors.</p>|`false`|
|{$VMWARE.HV.SENSOR.DISCOVERY.NAME.MATCHES}|<p>Sets the regex string of hardware sensor names to allow in discovery.</p>|`.*`|
|{$VMWARE.HV.SENSOR.DISCOVERY.NAME.NOT_MATCHES}|<p>Sets the regex string of hardware sensor names to ignore in discovery.</p>|`CHANGE_IF_NEEDED`|

### Items

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Event log|<p>Collect VMware event log. See also: https://www.zabbix.com/documentation/7.0/manual/config/items/preprocessing/examples#filtering_vmware_event_log_records</p>|Simple check|vmware.eventlog[{$VMWARE.URL},skip]|
|Full name|<p>VMware service full name.</p>|Simple check|vmware.fullname[{$VMWARE.URL}]<p>**Preprocessing**</p><ul><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Version|<p>VMware service version.</p>|Simple check|vmware.version[{$VMWARE.URL}]<p>**Preprocessing**</p><ul><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|

### LLD rule Discover VMware clusters

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Discover VMware clusters|<p>Discovery of clusters</p>|Simple check|vmware.cluster.discovery[{$VMWARE.URL}]|

### Item prototypes for Discover VMware clusters

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Status of "{#CLUSTER.NAME}" cluster|<p>VMware cluster status.</p>|Simple check|vmware.cluster.status[{$VMWARE.URL},{#CLUSTER.NAME}]|

### Trigger prototypes for Discover VMware clusters

|Name|Description|Expression|Severity|Dependencies and additional info|
|----|-----------|----------|--------|--------------------------------|
|The {#CLUSTER.NAME} status is Red|<p>A cluster enabled for DRS becomes invalid (red) when the tree is no longer internally consistent, that is, resource constraints are not observed. See also: https://docs.vmware.com/en/VMware-vSphere/8.0/vsphere-resource-management/GUID-C7417CAA-BD38-41D0-9529-9E7A5898BB12.html</p>|`last(/VMware/vmware.cluster.status[{$VMWARE.URL},{#CLUSTER.NAME}])=3`|High||
|The {#CLUSTER.NAME} status is Yellow|<p>A cluster becomes overcommitted (yellow) when the tree of resource pools and virtual machines is internally consistent but the cluster does not have the capacity to support all resources reserved by the child resource pools. See also: https://docs.vmware.com/en/VMware-vSphere/8.0/vsphere-resource-management/GUID-ED8240A0-FB54-4A31-BD3D-F23FE740F10C.html</p>|`last(/VMware/vmware.cluster.status[{$VMWARE.URL},{#CLUSTER.NAME}])=2`|Average|**Depends on**:<br><ul><li>The {#CLUSTER.NAME} status is Red</li></ul>|

### LLD rule Discover VMware datastores

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Discover VMware datastores||Simple check|vmware.datastore.discovery[{$VMWARE.URL}]|

### Item prototypes for Discover VMware datastores

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Average read latency of the datastore {#DATASTORE}|<p>Amount of time for a read operation from the datastore (milliseconds).</p>|Simple check|vmware.datastore.read[{$VMWARE.URL},{#DATASTORE},latency]|
|Free space on datastore {#DATASTORE} (percentage)|<p>VMware datastore space in percentage from total.</p>|Simple check|vmware.datastore.size[{$VMWARE.URL},{#DATASTORE},pfree]|
|Total size of datastore {#DATASTORE}|<p>VMware datastore space in bytes.</p>|Simple check|vmware.datastore.size[{$VMWARE.URL},{#DATASTORE}]|
|Average write latency of the datastore {#DATASTORE}|<p>Amount of time for a write operation to the datastore (milliseconds).</p>|Simple check|vmware.datastore.write[{$VMWARE.URL},{#DATASTORE},latency]|

### LLD rule Discover VMware hypervisors

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Discover VMware hypervisors|<p>Discovery of hypervisors.</p>|Simple check|vmware.hv.discovery[{$VMWARE.URL}]|

### LLD rule Discover VMware VMs

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Discover VMware VMs|<p>Discovery of guest virtual machines.</p>|Simple check|vmware.vm.discovery[{$VMWARE.URL}]|

# VMware Guest

### Macros used

|Name|Description|Default|
|----|-----------|-------|
|{$VMWARE.URL}|<p>VMware service (vCenter or ESX hypervisor) SDK URL (https://servername/sdk)</p>||
|{$VMWARE.USERNAME}|<p>VMware service user name</p>||
|{$VMWARE.PASSWORD}|<p>VMware service {$USERNAME} user password</p>||

### Items

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Cluster name|<p>Cluster name of the guest VM.</p>|Simple check|vmware.vm.cluster.name[{$VMWARE.URL},{$VMWARE.VM.UUID}]<p>**Preprocessing**</p><ul><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Number of virtual CPUs|<p>Number of virtual CPUs assigned to the guest.</p>|Simple check|vmware.vm.cpu.num[{$VMWARE.URL},{$VMWARE.VM.UUID}]<p>**Preprocessing**</p><ul><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|CPU ready|<p>Time that the virtual machine was ready, but could not get scheduled to run on the physical CPU during last measurement interval (VMware vCenter/ESXi Server performance counter sampling interval - 20 seconds)</p>|Simple check|vmware.vm.cpu.ready[{$VMWARE.URL},{$VMWARE.VM.UUID}]|
|CPU usage|<p>Current upper-bound on CPU usage. The upper-bound is based on the host the virtual machine is current running on, as well as limits configured on the virtual machine itself or any parent resource pool. Valid while the virtual machine is running.</p>|Simple check|vmware.vm.cpu.usage[{$VMWARE.URL},{$VMWARE.VM.UUID}]|
|Datacenter name|<p>Datacenter name of the guest VM.</p>|Simple check|vmware.vm.datacenter.name[{$VMWARE.URL},{$VMWARE.VM.UUID}]<p>**Preprocessing**</p><ul><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Hypervisor name|<p>Hypervisor name of the guest VM.</p>|Simple check|vmware.vm.hv.name[{$VMWARE.URL},{$VMWARE.VM.UUID}]<p>**Preprocessing**</p><ul><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Ballooned memory|<p>The amount of guest physical memory that is currently reclaimed through the balloon driver.</p>|Simple check|vmware.vm.memory.size.ballooned[{$VMWARE.URL},{$VMWARE.VM.UUID}]|
|Compressed memory|<p>The amount of memory currently in the compression cache for this VM.</p>|Simple check|vmware.vm.memory.size.compressed[{$VMWARE.URL},{$VMWARE.VM.UUID}]|
|Private memory|<p>Amount of memory backed by host memory and not being shared.</p>|Simple check|vmware.vm.memory.size.private[{$VMWARE.URL},{$VMWARE.VM.UUID}]|
|Shared memory|<p>The amount of guest physical memory shared through transparent page sharing.</p>|Simple check|vmware.vm.memory.size.shared[{$VMWARE.URL},{$VMWARE.VM.UUID}]|
|Swapped memory|<p>The amount of guest physical memory swapped out to the VM's swap device by ESX.</p>|Simple check|vmware.vm.memory.size.swapped[{$VMWARE.URL},{$VMWARE.VM.UUID}]|
|Guest memory usage|<p>The amount of guest physical memory that is being used by the VM.</p>|Simple check|vmware.vm.memory.size.usage.guest[{$VMWARE.URL},{$VMWARE.VM.UUID}]|
|Host memory usage|<p>The amount of host physical memory allocated to the VM, accounting for saving from memory sharing with other VMs.</p>|Simple check|vmware.vm.memory.size.usage.host[{$VMWARE.URL},{$VMWARE.VM.UUID}]|
|Memory size|<p>Total size of configured memory.</p>|Simple check|vmware.vm.memory.size[{$VMWARE.URL},{$VMWARE.VM.UUID}]<p>**Preprocessing**</p><ul><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Power state|<p>The current power state of the virtual machine.</p>|Simple check|vmware.vm.powerstate[{$VMWARE.URL},{$VMWARE.VM.UUID}]<p>**Preprocessing**</p><ul><li><p>Discard unchanged with heartbeat: `1h`</p></li></ul>|
|Committed storage space|<p>Total storage space, in bytes, committed to this virtual machine across all datastores.</p>|Simple check|vmware.vm.storage.committed[{$VMWARE.URL},{$VMWARE.VM.UUID}]|
|Uncommitted storage space|<p>Additional storage space, in bytes, potentially used by this virtual machine on all datastores.</p>|Simple check|vmware.vm.storage.uncommitted[{$VMWARE.URL},{$VMWARE.VM.UUID}]|
|Unshared storage space|<p>Total storage space, in bytes, occupied by the virtual machine across all datastores, that is not shared with any other virtual machine.</p>|Simple check|vmware.vm.storage.unshared[{$VMWARE.URL},{$VMWARE.VM.UUID}]|
|Uptime|<p>System uptime.</p>|Simple check|vmware.vm.uptime[{$VMWARE.URL},{$VMWARE.VM.UUID}]|
|Guest memory swapped|<p>Amount of guest physical memory that is swapped out to the swap space.</p>|Simple check|vmware.vm.guest.memory.size.swapped[{$VMWARE.URL},{$VMWARE.VM.UUID}]|
|Host memory consumed|<p>Amount of host physical memory consumed for backing up guest physical memory pages.</p>|Simple check|vmware.vm.memory.size.consumed[{$VMWARE.URL},{$VMWARE.VM.UUID}]|
|Host memory usage in percents|<p>Percentage of host physical memory that has been consumed.</p>|Simple check|vmware.vm.memory.usage[{$VMWARE.URL},{$VMWARE.VM.UUID}]|
|CPU usage in percents|<p>CPU usage as a percentage during the interval.</p>|Simple check|vmware.vm.cpu.usage.perf[{$VMWARE.URL},{$VMWARE.VM.UUID}]|
|CPU latency in percents|<p>Percentage of time the virtual machine is unable to run because it is contending for access to the physical CPU(s).</p>|Simple check|vmware.vm.cpu.latency[{$VMWARE.URL},{$VMWARE.VM.UUID}]|
|CPU readiness latency in percents|<p>Percentage of time that the virtual machine was ready, but could not get scheduled to run on the physical CPU.</p>|Simple check|vmware.vm.cpu.readiness[{$VMWARE.URL},{$VMWARE.VM.UUID}]|
|CPU swap-in latency in percents|<p>Percentage of CPU time spent waiting for swap-in.</p>|Simple check|vmware.vm.cpu.swapwait[{$VMWARE.URL},{$VMWARE.VM.UUID}]|
|Uptime of guest OS|<p>Total time elapsed since the last operating system boot-up (in seconds).</p>|Simple check|vmware.vm.guest.osuptime[{$VMWARE.URL},{$VMWARE.VM.UUID}]|

### Triggers

|Name|Description|Expression|Severity|Dependencies and additional info|
|----|-----------|----------|--------|--------------------------------|
|VM has been restarted|<p>Uptime is less than 10 minutes.</p>|`last(/VMware Guest/vmware.vm.guest.osuptime[{$VMWARE.URL},{$VMWARE.VM.UUID}])<10m`|Warning|**Manual close**: Yes|

### LLD rule Network device discovery

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Network device discovery|<p>Discovery of all network devices.</p>|Simple check|vmware.vm.net.if.discovery[{$VMWARE.URL},{$VMWARE.VM.UUID}]|

### Item prototypes for Network device discovery

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Number of bytes received on interface {#IFDESC}|<p>VMware virtual machine network interface input statistics (bytes per second).</p>|Simple check|vmware.vm.net.if.in[{$VMWARE.URL},{$VMWARE.VM.UUID},{#IFNAME},bps]|
|Number of packets received on interface {#IFDESC}|<p>VMware virtual machine network interface input statistics (packets per second).</p>|Simple check|vmware.vm.net.if.in[{$VMWARE.URL},{$VMWARE.VM.UUID},{#IFNAME},pps]|
|Number of bytes transmitted on interface {#IFDESC}|<p>VMware virtual machine network interface output statistics (bytes per second).</p>|Simple check|vmware.vm.net.if.out[{$VMWARE.URL},{$VMWARE.VM.UUID},{#IFNAME},bps]|
|Number of packets transmitted on interface {#IFDESC}|<p>VMware virtual machine network interface output statistics (packets per second).</p>|Simple check|vmware.vm.net.if.out[{$VMWARE.URL},{$VMWARE.VM.UUID},{#IFNAME},pps]|
|Network utilization on interface {#IFDESC}|<p>VMware virtual machine network utilization (combined transmit-rates and receive-rates) during the interval.</p>|Simple check|vmware.vm.net.if.usage[{$VMWARE.URL},{$VMWARE.VM.UUID},{#IFNAME}]<p>**Preprocessing**</p><ul><li><p>Custom multiplier: `1024`</p></li></ul>|

### LLD rule Disk device discovery

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Disk device discovery|<p>Discovery of all disk devices.</p>|Simple check|vmware.vm.vfs.dev.discovery[{$VMWARE.URL},{$VMWARE.VM.UUID}]|

### Item prototypes for Disk device discovery

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Average number of bytes read from the disk {#DISKDESC}|<p>VMware virtual machine disk device read statistics (bytes per second).</p>|Simple check|vmware.vm.vfs.dev.read[{$VMWARE.URL},{$VMWARE.VM.UUID},{#DISKNAME},bps]|
|Average number of reads from the disk {#DISKDESC}|<p>VMware virtual machine disk device read statistics (operations per second).</p>|Simple check|vmware.vm.vfs.dev.read[{$VMWARE.URL},{$VMWARE.VM.UUID},{#DISKNAME},ops]|
|Average number of bytes written to the disk {#DISKDESC}|<p>VMware virtual machine disk device write statistics (bytes per second).</p>|Simple check|vmware.vm.vfs.dev.write[{$VMWARE.URL},{$VMWARE.VM.UUID},{#DISKNAME},bps]|
|Average number of writes to the disk {#DISKDESC}|<p>VMware virtual machine disk device write statistics (operations per second).</p>|Simple check|vmware.vm.vfs.dev.write[{$VMWARE.URL},{$VMWARE.VM.UUID},{#DISKNAME},ops]|
|Average number of outstanding read requests to the disk {#DISKDESC}|<p>Average number of outstanding read requests to the virtual disk during the collection interval.</p>|Simple check|vmware.vm.storage.readoio[{$VMWARE.URL},{$VMWARE.VM.UUID},{#DISKNAME}]|
|Average number of outstanding write requests to the disk {#DISKDESC}|<p>Average number of outstanding write requests to the virtual disk during the collection interval.</p>|Simple check|vmware.vm.storage.writeoio[{$VMWARE.URL},{$VMWARE.VM.UUID},{#DISKNAME}]|
|Average write latency to the disk {#DISKDESC}|<p>The average time a write to the virtual disk takes.</p>|Simple check|vmware.vm.storage.totalwritelatency[{$VMWARE.URL},{$VMWARE.VM.UUID},{#DISKNAME}]|
|Average read latency to the disk {#DISKDESC}|<p>The average time a read from the virtual disk takes.</p>|Simple check|vmware.vm.storage.totalreadlatency[{$VMWARE.URL},{$VMWARE.VM.UUID},{#DISKNAME}]|

### LLD rule Mounted filesystem discovery

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Mounted filesystem discovery|<p>Discovery of all guest file systems.</p>|Simple check|vmware.vm.vfs.fs.discovery[{$VMWARE.URL},{$VMWARE.VM.UUID}]|

### Item prototypes for Mounted filesystem discovery

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Free disk space on {#FSNAME}|<p>VMware virtual machine file system statistics (bytes).</p>|Simple check|vmware.vm.vfs.fs.size[{$VMWARE.URL},{$VMWARE.VM.UUID},{#FSNAME},free]|
|Free disk space on {#FSNAME} (percentage)|<p>VMware virtual machine file system statistics (percentages).</p>|Simple check|vmware.vm.vfs.fs.size[{$VMWARE.URL},{$VMWARE.VM.UUID},{#FSNAME},pfree]|
|Total disk space on {#FSNAME}|<p>VMware virtual machine total disk space (bytes).</p>|Simple check|vmware.vm.vfs.fs.size[{$VMWARE.URL},{$VMWARE.VM.UUID},{#FSNAME},total]<p>**Preprocessing**</p><ul><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Used disk space on {#FSNAME}|<p>VMware virtual machine used disk space (bytes).</p>|Simple check|vmware.vm.vfs.fs.size[{$VMWARE.URL},{$VMWARE.VM.UUID},{#FSNAME},used]|

# VMware Hypervisor

### Macros used

|Name|Description|Default|
|----|-----------|-------|
|{$VMWARE.URL}|<p>VMware service (vCenter or ESX hypervisor) SDK URL (https://servername/sdk).</p>||
|{$VMWARE.USERNAME}|<p>VMware service user name.</p>||
|{$VMWARE.PASSWORD}|<p>VMware service {$USERNAME} user password.</p>||
|{$VMWARE.HV.SENSOR.DISCOVERY}|<p>Set "true"/"false" to enable or disable monitoring of hardware sensors.</p>|`false`|
|{$VMWARE.HV.SENSOR.DISCOVERY.NAME.MATCHES}|<p>Sets the regex string of hardware sensor names to allow in discovery.</p>|`.*`|
|{$VMWARE.HV.SENSOR.DISCOVERY.NAME.NOT_MATCHES}|<p>Sets the regex string of hardware sensor names to ignore in discovery.</p>|`CHANGE_IF_NEEDED`|

### Items

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Hypervisor ping|<p>Checks if the hypervisor is running and accepting ICMP pings.</p>|Simple check|icmpping[]<p>**Preprocessing**</p><ul><li><p>Discard unchanged with heartbeat: `10m`</p></li></ul>|
|Cluster name|<p>Cluster name of the guest VM.</p>|Simple check|vmware.hv.cluster.name[{$VMWARE.URL},{$VMWARE.HV.UUID}]<p>**Preprocessing**</p><ul><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|CPU usage|<p>Aggregated CPU usage across all cores on the host in Hz. This is only available if the host is connected.</p>|Simple check|vmware.hv.cpu.usage[{$VMWARE.URL},{$VMWARE.HV.UUID}]|
|CPU usage in percents|<p>CPU usage as a percentage during the interval.</p>|Simple check|vmware.hv.cpu.usage.perf[{$VMWARE.URL},{$VMWARE.HV.UUID}]|
|CPU utilization|<p>CPU usage as a percentage during the interval depends on power management or HT.</p>|Simple check|vmware.hv.cpu.utilization[{$VMWARE.URL},{$VMWARE.HV.UUID}]|
|Power usage|<p>Current power usage.</p>|Simple check|vmware.hv.power[{$VMWARE.URL},{$VMWARE.HV.UUID}]|
|Power usage maximum allowed|<p>Maximum allowed power usage.</p>|Simple check|vmware.hv.power[{$VMWARE.URL},{$VMWARE.HV.UUID},max]<p>**Preprocessing**</p><ul><li><p>Discard unchanged with heartbeat: `6h`</p></li></ul>|
|Datacenter name|<p>Datacenter name of the hypervisor.</p>|Simple check|vmware.hv.datacenter.name[{$VMWARE.URL},{$VMWARE.HV.UUID}]<p>**Preprocessing**</p><ul><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|Full name|<p>The complete product name, including the version information.</p>|Simple check|vmware.hv.fullname[{$VMWARE.URL},{$VMWARE.HV.UUID}]<p>**Preprocessing**</p><ul><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|CPU frequency|<p>The speed of the CPU cores. This is an average value if there are multiple speeds. The product of CPU frequency and number of cores is approximately equal to the sum of the MHz for all the individual cores on the host.</p>|Simple check|vmware.hv.hw.cpu.freq[{$VMWARE.URL},{$VMWARE.HV.UUID}]|
|CPU model|<p>The CPU model.</p>|Simple check|vmware.hv.hw.cpu.model[{$VMWARE.URL},{$VMWARE.HV.UUID}]|
|CPU cores|<p>Number of physical CPU cores on the host. Physical CPU cores are the processors contained by a CPU package.</p>|Simple check|vmware.hv.hw.cpu.num[{$VMWARE.URL},{$VMWARE.HV.UUID}]<p>**Preprocessing**</p><ul><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|
|CPU threads|<p>Number of physical CPU threads on the host.</p>|Simple check|vmware.hv.hw.cpu.threads[{$VMWARE.URL},{$VMWARE.HV.UUID}]|
|Total memory|<p>The physical memory size.</p>|Simple check|vmware.hv.hw.memory[{$VMWARE.URL},{$VMWARE.HV.UUID}]|
|Model|<p>The system model identification.</p>|Simple check|vmware.hv.hw.model[{$VMWARE.URL},{$VMWARE.HV.UUID}]|
|Bios UUID|<p>The hardware BIOS identification.</p>|Simple check|vmware.hv.hw.uuid[{$VMWARE.URL},{$VMWARE.HV.UUID}]|
|Vendor|<p>The hardware vendor identification.</p>|Simple check|vmware.hv.hw.vendor[{$VMWARE.URL},{$VMWARE.HV.UUID}]|
|Ballooned memory|<p>The amount of guest physical memory that is currently reclaimed through the balloon driver. Sum of all guest VMs.</p>|Simple check|vmware.hv.memory.size.ballooned[{$VMWARE.URL},{$VMWARE.HV.UUID}]|
|Used memory|<p>Physical memory usage on the host.</p>|Simple check|vmware.hv.memory.used[{$VMWARE.URL},{$VMWARE.HV.UUID}]|
|Number of bytes received|<p>VMware hypervisor network input statistics (bytes per second).</p>|Simple check|vmware.hv.network.in[{$VMWARE.URL},{$VMWARE.HV.UUID},bps]|
|Number of bytes transmitted|<p>VMware hypervisor network output statistics (bytes per second).</p>|Simple check|vmware.hv.network.out[{$VMWARE.URL},{$VMWARE.HV.UUID},bps]|
|Overall status|<p>The overall alarm status of the host: gray - unknown, green - ok, red - it has a problem, yellow - it might have a problem.</p>|Simple check|vmware.hv.status[{$VMWARE.URL},{$VMWARE.HV.UUID}]|
|Uptime|<p>System uptime.</p>|Simple check|vmware.hv.uptime[{$VMWARE.URL},{$VMWARE.HV.UUID}]|
|Version|<p>Dot-separated version string.</p>|Simple check|vmware.hv.version[{$VMWARE.URL},{$VMWARE.HV.UUID}]|
|Number of guest VMs|<p>Number of guest virtual machines.</p>|Simple check|vmware.hv.vm.num[{$VMWARE.URL},{$VMWARE.HV.UUID}]|
|Get sensors|<p>Master item for sensors data.</p>|Simple check|vmware.hv.sensors.get[{$VMWARE.URL},{$VMWARE.HV.UUID}]|

### Triggers

|Name|Description|Expression|Severity|Dependencies and additional info|
|----|-----------|----------|--------|--------------------------------|
|Hypervisor is down|<p>The service is unavailable or does not accept ICMP ping.</p>|`last(/VMware Hypervisor/icmpping[])=0`|Average|**Manual close**: Yes|
|The {$VMWARE.HV.UUID} health is Red|<p>One or more components in the appliance might be in an unusable status and the appliance might become unresponsive soon. Security patches might be available.</p>|`last(/VMware Hypervisor/vmware.hv.status[{$VMWARE.URL},{$VMWARE.HV.UUID}])=3`|High||
|The {$VMWARE.HV.UUID} health is Yellow|<p>One or more components in the appliance might become overloaded soon.</p>|`last(/VMware Hypervisor/vmware.hv.status[{$VMWARE.URL},{$VMWARE.HV.UUID}])=2`|Average|**Depends on**:<br><ul><li>The {$VMWARE.HV.UUID} health is Red</li></ul>|
|Hypervisor has been restarted|<p>Uptime is less than 10 minutes.</p>|`last(/VMware Hypervisor/vmware.hv.uptime[{$VMWARE.URL},{$VMWARE.HV.UUID}])<10m`|Warning|**Manual close**: Yes|

### LLD rule Datastore discovery

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Datastore discovery||Simple check|vmware.hv.datastore.discovery[{$VMWARE.URL},{$VMWARE.HV.UUID}]|

### Item prototypes for Datastore discovery

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Average read latency of the datastore {#DATASTORE}|<p>Average amount of time for a read operation from the datastore (milliseconds).</p>|Simple check|vmware.hv.datastore.read[{$VMWARE.URL},{$VMWARE.HV.UUID},{#DATASTORE},latency]|
|Free space on datastore {#DATASTORE} (percentage)|<p>VMware datastore space in percentage from total.</p>|Simple check|vmware.hv.datastore.size[{$VMWARE.URL},{$VMWARE.HV.UUID},{#DATASTORE},pfree]|
|Total size of datastore {#DATASTORE}|<p>VMware datastore space in bytes.</p>|Simple check|vmware.hv.datastore.size[{$VMWARE.URL},{$VMWARE.HV.UUID},{#DATASTORE}]|
|Average write latency of the datastore {#DATASTORE}|<p>Average amount of time for a write operation to the datastore (milliseconds).</p>|Simple check|vmware.hv.datastore.write[{$VMWARE.URL},{$VMWARE.HV.UUID},{#DATASTORE},latency]|
|Multipath count for datastore {#DATASTORE}|<p>Number of available datastore paths.</p>|Simple check|vmware.hv.datastore.multipath[{$VMWARE.URL},{$VMWARE.HV.UUID},{#DATASTORE}]|

### Trigger prototypes for Datastore discovery

|Name|Description|Expression|Severity|Dependencies and additional info|
|----|-----------|----------|--------|--------------------------------|
|The multipath count has been changed|<p>The number of available datastore paths less than registered ({#MULTIPATH.COUNT}).</p>|`last(/VMware Hypervisor/vmware.hv.datastore.multipath[{$VMWARE.URL},{$VMWARE.HV.UUID},{#DATASTORE}],#1)<>last(/VMware Hypervisor/vmware.hv.datastore.multipath[{$VMWARE.URL},{$VMWARE.HV.UUID},{#DATASTORE}],#2) and last(/VMware Hypervisor/vmware.hv.datastore.multipath[{$VMWARE.URL},{$VMWARE.HV.UUID},{#DATASTORE}])<{#MULTIPATH.COUNT}`|Average|**Manual close**: Yes|

### LLD rule Healthcheck discovery

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Healthcheck discovery|<p>VMware Rollup Health State sensor discovery.</p>|Dependent item|vmware.hv.healthcheck.discovery<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p><p>⛔️Custom on fail: Set value to: `[]`</p></li><li><p>JavaScript: `The text is too long. Please see the template.`</p></li><li><p>Discard unchanged with heartbeat: `6h`</p></li></ul>|

### Item prototypes for Healthcheck discovery

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Health state rollup|<p>The host health state rollup sensor value: gray - unknown, green - ok, red - it has a problem, yellow - it might have a problem.</p>|Dependent item|vmware.hv.sensor.health.state[{#SINGLETON}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p></li></ul>|

### Trigger prototypes for Healthcheck discovery

|Name|Description|Expression|Severity|Dependencies and additional info|
|----|-----------|----------|--------|--------------------------------|
|The {$VMWARE.HV.UUID} health is Red|<p>One or more components in the appliance might be in an unusable status and the appliance might become unresponsive soon. Security patches might be available.</p>|`last(/VMware Hypervisor/vmware.hv.sensor.health.state[{#SINGLETON}])="Red"`|High|**Depends on**:<br><ul><li>The {$VMWARE.HV.UUID} health is Red</li></ul>|
|The {$VMWARE.HV.UUID} health is Yellow|<p>One or more components in the appliance might become overloaded soon.</p>|`last(/VMware Hypervisor/vmware.hv.sensor.health.state[{#SINGLETON}])="Yellow"`|Average|**Depends on**:<br><ul><li>The {$VMWARE.HV.UUID} health is Red</li><li>The {$VMWARE.HV.UUID} health is Yellow</li><li>The {$VMWARE.HV.UUID} health is Red</li></ul>|

### LLD rule Sensor discovery

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Sensor discovery|<p>VMware hardware sensor discovery. The data is retrieved from numeric sensor probes and provides information about the health of the physical system.</p>|Dependent item|vmware.hv.sensors.discovery<p>**Preprocessing**</p><ul><li><p>JavaScript: `The text is too long. Please see the template.`</p></li><li><p>Discard unchanged with heartbeat: `6h`</p></li></ul>|

### Item prototypes for Sensor discovery

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Sensor [{#NAME}] health state|<p>VMware hardware sensor health state. One of the following:</p><p>- Unknown</p><p>- Green</p><p>- Yellow</p><p>- Red</p>|Dependent item|vmware.hv.sensor.state["{#NAME}"]<p>**Preprocessing**</p><ul><li><p>JSON Path: `The text is too long. Please see the template.`</p></li><li><p>JavaScript: `The text is too long. Please see the template.`</p></li><li><p>Discard unchanged with heartbeat: `6h`</p></li></ul>|

### Trigger prototypes for Sensor discovery

|Name|Description|Expression|Severity|Dependencies and additional info|
|----|-----------|----------|--------|--------------------------------|
|Sensor [{#NAME}] health state is Red|<p>One or more components in the appliance might be in an unusable status and the appliance might become unresponsive soon.</p>|`last(/VMware Hypervisor/vmware.hv.sensor.state["{#NAME}"])=3`|High|**Depends on**:<br><ul><li>The {$VMWARE.HV.UUID} health is Red</li></ul>|
|Sensor [{#NAME}] health state is Yellow|<p>One or more components in the appliance might become overloaded soon.</p>|`last(/VMware Hypervisor/vmware.hv.sensor.state["{#NAME}"])=2`|Average|**Depends on**:<br><ul><li>The {$VMWARE.HV.UUID} health is Red</li><li>The {$VMWARE.HV.UUID} health is Yellow</li><li>Sensor [{#NAME}] health state is Red</li></ul>|

## Feedback

Please report any issues with the template at [`https://support.zabbix.com`](https://support.zabbix.com)

You can also provide feedback, discuss the template, or ask for help at [`ZABBIX forums`](https://www.zabbix.com/forum/zabbix-suggestions-and-feedback)

