SET DEFINE OFF
INSERT INTO role (roleid,name,type,readonly)
values ('1','User role','1','0')
/

INSERT INTO role (roleid,name,type,readonly)
values ('2','Admin role','2','0')
/

INSERT INTO role (roleid,name,type,readonly)
values ('3','Super admin role','3','1')
/

INSERT INTO role (roleid,name,type,readonly)
values ('4','Guest role','1','0')
/

INSERT INTO users (userid,username,name,surname,passwd,url,autologin,autologout,refresh,rows_per_page,roleid)
values ('1','Admin','Zabbix','Administrator','$2y$10$92nDno4n0Zm7Ej7Jfsz8WukBfgSS/U0QkIuu8WkJPihXBb2A1UrEK','','1','0','30s','50','3')
/

INSERT INTO users (userid,username,name,surname,passwd,url,autologin,autologout,refresh,rows_per_page,roleid)
values ('2','guest','','','$2y$10$89otZrRNmde97rIyzclecuk6LwKAsHN0BcvoOKGjbT.BwMBfm7G06','','0','15m','30s','50','4')
/

INSERT INTO hstgrp (groupid,name,internal,flags,uuid)
values ('1','Templates','0','0','7df96b18c230490a9a0a9e2307226338')
/

INSERT INTO hstgrp (groupid,name,internal,flags,uuid)
values ('2','Linux servers','0','0','dc579cd7a1a34222933f24f52a68bcd8')
/

INSERT INTO hstgrp (groupid,name,internal,flags,uuid)
values ('4','Zabbix servers','0','0','6f6799aa69e844b4b3918f779f2abf08')
/

INSERT INTO hstgrp (groupid,name,internal,flags,uuid)
values ('5','Discovered hosts','1','0','f2481361f99448eea617b7b1d4765566')
/

INSERT INTO hstgrp (groupid,name,internal,flags,uuid)
values ('6','Virtual machines','0','0','137f19e6e2dc4219b33553b812627bc2')
/

INSERT INTO hstgrp (groupid,name,internal,flags,uuid)
values ('7','Hypervisors','0','0','1b837a3c078647049a0c00c61b4d57b5')
/

INSERT INTO hstgrp (groupid,name,internal,flags,uuid)
values ('8','Templates/Modules','0','0','57b7ae836ca64446ba2c296389c009b7')
/

INSERT INTO hstgrp (groupid,name,internal,flags,uuid)
values ('9','Templates/Network devices','0','0','36bff6c29af64692839d077febfc7079')
/

INSERT INTO hstgrp (groupid,name,internal,flags,uuid)
values ('10','Templates/Operating systems','0','0','846977d1dfed4968bc5f8bdb363285bc')
/

INSERT INTO hstgrp (groupid,name,internal,flags,uuid)
values ('11','Templates/Server hardware','0','0','e960332b3f6c46a1956486d4f3f99fce')
/

INSERT INTO hstgrp (groupid,name,internal,flags,uuid)
values ('12','Templates/Applications','0','0','a571c0d144b14fd4a87a9d9b2aa9fcd6')
/

INSERT INTO hstgrp (groupid,name,internal,flags,uuid)
values ('13','Templates/Databases','0','0','748ad4d098d447d492bb935c907f652f')
/

INSERT INTO hstgrp (groupid,name,internal,flags,uuid)
values ('14','Templates/Virtualization','0','0','02e4df4f20b848e79267641790f241da')
/

INSERT INTO hstgrp (groupid,name,internal,flags,uuid)
values ('15','Templates/Telephony','0','0','1d12408342854fd5a4436dd6d5d1bd4a')
/

INSERT INTO hstgrp (groupid,name,internal,flags,uuid)
values ('16','Templates/SAN','0','0','7c2cb727f85b492d88cd56e17127c64d')
/

INSERT INTO hstgrp (groupid,name,internal,flags,uuid)
values ('17','Templates/Video surveillance','0','0','d37f71c7e3f7469bab645852a69a2018')
/

INSERT INTO hstgrp (groupid,name,internal,flags,uuid)
values ('18','Templates/Power','0','0','3dcd5bbe90534f9e8eb5c2d53756af63')
/

INSERT INTO drules (druleid,proxy_hostid,name,iprange,delay,status)
values ('2',NULL,'Local network','192.168.0.1-254','1h','1')
/

INSERT INTO dchecks (dcheckid,druleid,type,key_,snmp_community,ports,snmpv3_securityname,snmpv3_securitylevel,snmpv3_authpassphrase,snmpv3_privpassphrase,uniq,snmpv3_authprotocol,snmpv3_privprotocol,snmpv3_contextname,host_source,name_source)
values ('2','2','9','system.uname','','10050','','0','','','0','0','0','','1','0')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description)
values ('1','0','Email','mail.example.com','example.com','zabbix@example.com','','','','','0','25','0','0','0','0','','1','3','10s','0','','30s','0','0','','','')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description)
values ('3','2','SMS','','','','','/dev/ttyS0','','','0','25','0','0','0','0','','1','3','10s','1','','30s','0','0','','','')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description)
values ('4','0','Email (HTML)','mail.example.com','example.com','zabbix@example.com','','','','','0','25','0','0','0','0','','1','3','10s','1','','30s','0','0','','','')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description)
values ('5','4','Mattermost','','','','','','','','0','25','0','0','0','0','','1','1','10s','1',TO_NCLOB('var SEVERITY_COLORS = [' || chr(13) || chr(10) || '    ''#97AAB3'', ''#7499FF'', ''#FFC859'',' || chr(13) || chr(10) || '    ''#FFA059'', ''#E97659'', ''#E45959''' || chr(13) || chr(10) || '];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'var RESOLVE_COLOR = ''#009900'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'var SEND_MODE_HANDLERS = {' || chr(13) || chr(10) || '    alarm: handlerAlarm,' || chr(13) || chr(10) || '    event: handlerEvent' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'if (!String.prototype.format) {' || chr(13) || chr(10) || '    String.prototype.format = function() {' || chr(13) || chr(10) || '        var args = arguments;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return this.replace(/{(\d+)}/g, function(match, number) {' || chr(13) || chr(10) || '            return number in args' || chr(13) || chr(10) || '                ? args[number]' || chr(13) || chr(10) || '                : match' || chr(13) || chr(10) || '            ;' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '    };' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function isEventProblem(params) {' || chr(13) || chr(10) || '    return params.event_value == 1' || chr(13) || chr(10) || '        && params.event_update_status == 0' || chr(13) || chr(10) || '    ;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function isEventUpdate(params) {' || chr(13) || chr(10) || '    return params.event_value == 1' || chr(13) || chr(10) || '        && params.event_update_status == 1' || chr(13) || chr(10) || '    ;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function isEventResolve(params) {' || chr(13) || chr(10) || '    return params.event_value == 0;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function getPermalink(mattermost_url, team_name, postid) {' || chr(13) || chr(10) || '')||
TO_NCLOB('    return ''{0}/{1}/pl/{2}''.format(' || chr(13) || chr(10) || '        mattermost_url.replace(/\/+$/, ''''),' || chr(13) || chr(10) || '        team_name,' || chr(13) || chr(10) || '        postid' || chr(13) || chr(10) || '    );' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function getChannel(send_to) {' || chr(13) || chr(10) || '    switch (true) {' || chr(13) || chr(10) || '        case /.+\/#.+/.test(send_to):' || chr(13) || chr(10) || '            return getChannelByName(send_to);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        case /@.+/.test(send_to):' || chr(13) || chr(10) || '            return getDirectChannel(send_to);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        default:' || chr(13) || chr(10) || '            return getChannelByID(send_to);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function getChannelByName(send_to) {' || chr(13) || chr(10) || '    var team_chan = send_to' || chr(13) || chr(10) || '        .trim()' || chr(13) || chr(10) || '        .split(''/#'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var resp = JSON.parse(req.get(' || chr(13) || chr(10) || '        Mattermost.channel_byname.format(team_chan[0], team_chan[1]),' || chr(13) || chr(10) || '        JSON.stringify(fields)' || chr(13) || chr(10) || '    )' || chr(13) || chr(10) || '    );' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (req.getStatus() != 200) {' || chr(13) || chr(10) || '        throw ''[{0}] {1}''.format(resp.status_code, resp.message);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return resp;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function getDirectChannel(send_to) {' || chr(13) || chr(10) || '    Zabbix.log(5, ''[ Mattermost Webhook ] Call {0}({1})''.format(' || chr(13) || chr(10) || '        arguments.callee.name,' || chr(13) || chr(10) || '')||
TO_NCLOB('        JSON.stringify(arguments)' || chr(13) || chr(10) || '    ));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var teamUser = send_to' || chr(13) || chr(10) || '            .trim()' || chr(13) || chr(10) || '            .split(''/@''),' || chr(13) || chr(10) || '        bot = getBotUser(),' || chr(13) || chr(10) || '        user = getUserByName(teamUser[1]);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var resp = JSON.parse(req.post(' || chr(13) || chr(10) || '        Mattermost.direct_channel,' || chr(13) || chr(10) || '        JSON.stringify([bot.id, user.id])' || chr(13) || chr(10) || '    )' || chr(13) || chr(10) || '    );' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Zabbix.log(5, ''[ Mattermost Webhook ] Result {0}: {1}''.format(' || chr(13) || chr(10) || '        arguments.callee.name,' || chr(13) || chr(10) || '        JSON.stringify(resp)' || chr(13) || chr(10) || '    ));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (req.getStatus() != 201) {' || chr(13) || chr(10) || '        throw ''[{0}] {1}''.format(resp.status_code, resp.message);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    resp.team_name = teamUser[0];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return resp;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function getChannelByID(channelID) {' || chr(13) || chr(10) || '    Zabbix.log(5, ''[ Mattermost Webhook ] Call {0}({1})''.format(' || chr(13) || chr(10) || '        arguments.callee.name,' || chr(13) || chr(10) || '        JSON.stringify(arguments)' || chr(13) || chr(10) || '    ));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var resp = JSON.parse(req.get(' || chr(13) || chr(10) || '        Mattermost.get_channel.format(channelID),' || chr(13) || chr(10) || '        JSON.stringify(fields)' || chr(13) || chr(10) || '    )' || chr(13) || chr(10) || '    );' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    Zabbix.log(5, ''[ Mattermost Webhook ] Result {0}: {1}''.format(' || chr(13) || chr(10) || '        arguments.callee.name,' || chr(13) || chr(10) || '        JSON.stringify(resp)' || chr(13) || chr(10) || '    ));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (req.getStatus() != 200) {' || chr(13) || chr(10) || '        throw ''[{0}] {1}''.format(resp.status_code, resp.message);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return resp;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function getBotUser() {' || chr(13) || chr(10) || '    Zabbix.log(5, ''[ Mattermost Webhook ] Call {0}({1})''.format(' || chr(13) || chr(10) || '        arguments.callee.name,' || chr(13) || chr(10) || '        JSON.stringify(arguments)' || chr(13) || chr(10) || '    ));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var resp = JSON.parse(req.get(' || chr(13) || chr(10) || '        Mattermost.bot_user,' || chr(13) || chr(10) || '        JSON.stringify(fields)' || chr(13) || chr(10) || '    )' || chr(13) || chr(10) || '    );' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Zabbix.log(5, ''[ Mattermost Webhook ] Result {0}: {1}''.format(' || chr(13) || chr(10) || '        arguments.callee.name,' || chr(13) || chr(10) || '        JSON.stringify(resp)' || chr(13) || chr(10) || '    ));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (req.getStatus() != 200) {' || chr(13) || chr(10) || '        throw ''[{0}] {1}''.format(resp.status_code, resp.message);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return resp;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function getUserByName(userName) {' || chr(13) || chr(10) || '    Zabbix.log(5, ''[ Mattermost Webhook ] Call {0}({1})''.format(' || chr(13) || chr(10) || '        arguments.callee.name,' || chr(13) || chr(10) || '        JSON.stringify(arguments)' || chr(13) || chr(10) || '')||
TO_NCLOB('    ));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var resp = JSON.parse(req.get(' || chr(13) || chr(10) || '        Mattermost.user_byname.format(userName),' || chr(13) || chr(10) || '        JSON.stringify(fields)' || chr(13) || chr(10) || '    )' || chr(13) || chr(10) || '    );' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Zabbix.log(5, ''[ Mattermost Webhook ] Result {0}: {1}''.format(' || chr(13) || chr(10) || '        arguments.callee.name,' || chr(13) || chr(10) || '        JSON.stringify(resp)' || chr(13) || chr(10) || '    ));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (req.getStatus() != 200) {' || chr(13) || chr(10) || '        throw ''[{0}] {1}''.format(resp.status_code, resp.message);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return resp;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function getTeamByID(teamID) {' || chr(13) || chr(10) || '    Zabbix.log(5, ''[ Mattermost Webhook ] Call {0}({1})''.format(' || chr(13) || chr(10) || '        arguments.callee.name,' || chr(13) || chr(10) || '        JSON.stringify(arguments)' || chr(13) || chr(10) || '    ));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var resp = JSON.parse(req.get(' || chr(13) || chr(10) || '        Mattermost.get_team.format(teamID),' || chr(13) || chr(10) || '        JSON.stringify(fields)' || chr(13) || chr(10) || '    )' || chr(13) || chr(10) || '    );' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Zabbix.log(5, ''[ Mattermost Webhook ] Result {0}: {1}''.format(' || chr(13) || chr(10) || '        arguments.callee.name,' || chr(13) || chr(10) || '        JSON.stringify(resp)' || chr(13) || chr(10) || '    ));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (req.getStatus() != 200) {' || chr(13) || chr(10) || '        throw ''[{0}] {1}''.format(resp.status_code, resp.message);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    return resp;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function createProblemURL(zabbix_url, triggerid, eventid, event_source) {' || chr(13) || chr(10) || '    var problem_url = '''';' || chr(13) || chr(10) || '    if (event_source === ''0'') {' || chr(13) || chr(10) || '        problem_url = ''{0}/tr_events.php?triggerid={1}&eventid={2}''' || chr(13) || chr(10) || '            .format(' || chr(13) || chr(10) || '                zabbix_url,' || chr(13) || chr(10) || '                triggerid,' || chr(13) || chr(10) || '                eventid' || chr(13) || chr(10) || '            );' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        problem_url = zabbix_url;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return problem_url;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function getTagValue(event_tags, key) {' || chr(13) || chr(10) || '    var pattern = new RegExp(''('' + key + '':.+)'');' || chr(13) || chr(10) || '    var tagValue = event_tags' || chr(13) || chr(10) || '        .split('','')' || chr(13) || chr(10) || '        .filter(function (v) {' || chr(13) || chr(10) || '            return v.match(pattern);' || chr(13) || chr(10) || '        })' || chr(13) || chr(10) || '        .map(function (v) {' || chr(13) || chr(10) || '            return v.split('':'')[1];' || chr(13) || chr(10) || '        })[0]' || chr(13) || chr(10) || '        || 0;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return tagValue;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function handlerAlarm(req, params) {' || chr(13) || chr(10) || '    var channel = getChannel(params.send_to);' || chr(13) || chr(10) || '    var fields = {' || chr(13) || chr(10) || '        channel_id: channel.id,' || chr(13) || chr(10) || '        props: {}' || chr(13) || chr(10) || '    };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    if (isEventProblem(params)) {' || chr(13) || chr(10) || '        var team_name = channel.team_name' || chr(13) || chr(10) || '            ? channel.team_name' || chr(13) || chr(10) || '            : getTeamByID(channel.team_id).name;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        fields.props.attachments = [' || chr(13) || chr(10) || '            createMessage(' || chr(13) || chr(10) || '                SEVERITY_COLORS[params.event_nseverity] || 0,' || chr(13) || chr(10) || '                params.event_date,' || chr(13) || chr(10) || '                params.event_time,' || chr(13) || chr(10) || '                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)' || chr(13) || chr(10) || '            )' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var resp = JSON.parse(req.post(' || chr(13) || chr(10) || '            Mattermost.post_message,' || chr(13) || chr(10) || '            JSON.stringify(fields)' || chr(13) || chr(10) || '        )' || chr(13) || chr(10) || '        );' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (req.getStatus() != 201) {' || chr(13) || chr(10) || '            throw ''[{0}] {1}''.format(resp.status_code, resp.message);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result.tags.__mattermost_post_id = resp.id;' || chr(13) || chr(10) || '        result.tags.__mattermost_channel_id = channel.id;' || chr(13) || chr(10) || '        result.tags.__mattermost_channel_name = channel.name;' || chr(13) || chr(10) || '        result.tags.__mattermost_message_link = getPermalink(' || chr(13) || chr(10) || '            params.mattermost_url,' || chr(13) || chr(10) || '            team_name,' || chr(13) || chr(10) || '            resp.id' || chr(13) || chr(10) || '        );' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '')||
TO_NCLOB('    else if (isEventUpdate(params)) {' || chr(13) || chr(10) || '        fields.root_id = getTagValue(params.event_tags, ''mattermost_post_id'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (params.event_source === ''0'') {}' || chr(13) || chr(10) || '        fields.props.attachments = [' || chr(13) || chr(10) || '            createMessage(' || chr(13) || chr(10) || '                SEVERITY_COLORS[params.event_nseverity] || 0,' || chr(13) || chr(10) || '                params.event_update_date,' || chr(13) || chr(10) || '                params.event_update_time,' || chr(13) || chr(10) || '                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source),' || chr(13) || chr(10) || '                true' || chr(13) || chr(10) || '            )' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        resp = JSON.parse(req.post(' || chr(13) || chr(10) || '            Mattermost.post_message, JSON.stringify(fields)' || chr(13) || chr(10) || '        )' || chr(13) || chr(10) || '        );' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (req.getStatus() != 201) {' || chr(13) || chr(10) || '            throw ''[{0}] {1}''.format(resp.status_code, resp.message);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else if (isEventResolve(params)) {' || chr(13) || chr(10) || '        fields.channel_id = getTagValue(params.event_tags, ''mattermost_channel_id'');' || chr(13) || chr(10) || '        fields.id = getTagValue(params.event_tags, ''mattermost_post_id'');' || chr(13) || chr(10) || '        fields.props.attachments = [' || chr(13) || chr(10) || '            createMessage(' || chr(13) || chr(10) || '                RESOLVE_COLOR,' || chr(13) || chr(10) || '                params.event_date,' || chr(13) || chr(10) || '                params.event_time,' || chr(13) || chr(10) || '')||
TO_NCLOB('                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)' || chr(13) || chr(10) || '            )' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var post_id = getTagValue(params.event_tags, ''mattermost_post_id'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        resp = JSON.parse(req.put(' || chr(13) || chr(10) || '            Mattermost.chat_update.format(post_id),' || chr(13) || chr(10) || '            JSON.stringify(fields)' || chr(13) || chr(10) || '        )' || chr(13) || chr(10) || '        );' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (req.getStatus() != 200) {' || chr(13) || chr(10) || '            throw ''[{0}] {1}''.format(resp.status_code, resp.message);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function handlerEvent(req, params) {' || chr(13) || chr(10) || '    var channel = getChannel(params.send_to);' || chr(13) || chr(10) || '    var fields = {' || chr(13) || chr(10) || '        channel_id: channel.id,' || chr(13) || chr(10) || '        props: {}' || chr(13) || chr(10) || '    };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (isEventProblem(params)) {' || chr(13) || chr(10) || '        var team_name = channel.team_name' || chr(13) || chr(10) || '            ? channel.team_name' || chr(13) || chr(10) || '            : getTeamByID(channel.team_id).name;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        fields.props.attachments = [' || chr(13) || chr(10) || '            createMessage(' || chr(13) || chr(10) || '                SEVERITY_COLORS[params.event_nseverity] || 0,' || chr(13) || chr(10) || '                params.event_date,' || chr(13) || chr(10) || '                params.event_time,' || chr(13) || chr(10) || '                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)' || chr(13) || chr(10) || '            )' || chr(13) || chr(10) || '')||
TO_NCLOB('        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var resp = JSON.parse(req.post(Mattermost.post_message, JSON.stringify(fields)));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (req.getStatus() != 201) {' || chr(13) || chr(10) || '            throw ''[{0}] {1}''.format(resp.status_code, resp.message);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result.tags.__mattermost_channel_name = channel.name;' || chr(13) || chr(10) || '        result.tags.__mattermost_message_link = getPermalink(' || chr(13) || chr(10) || '            params.mattermost_url,' || chr(13) || chr(10) || '            team_name,' || chr(13) || chr(10) || '            resp.id' || chr(13) || chr(10) || '        );' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else if (isEventUpdate(params)) {' || chr(13) || chr(10) || '        fields.props.attachments = [' || chr(13) || chr(10) || '            createMessage(' || chr(13) || chr(10) || '                SEVERITY_COLORS[params.event_nseverity] || 0,' || chr(13) || chr(10) || '                params.event_update_date,' || chr(13) || chr(10) || '                params.event_update_time,' || chr(13) || chr(10) || '                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source),' || chr(13) || chr(10) || '                false' || chr(13) || chr(10) || '            )' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        resp = JSON.parse(req.post(Mattermost.post_message, JSON.stringify(fields)));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (req.getStatus() != 201) {' || chr(13) || chr(10) || '            throw ''[{0}] {1}''.format(resp.status_code, resp.message);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else if (isEventResolve(params)) {' || chr(13) || chr(10) || '')||
TO_NCLOB('        fields.props.attachments = [' || chr(13) || chr(10) || '            createMessage(' || chr(13) || chr(10) || '                RESOLVE_COLOR,' || chr(13) || chr(10) || '                params.event_recovery_date,' || chr(13) || chr(10) || '                params.event_recovery_time,' || chr(13) || chr(10) || '                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)' || chr(13) || chr(10) || '            )' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        resp = JSON.parse(req.post(Mattermost.post_message, JSON.stringify(fields)));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (req.getStatus() != 201) {' || chr(13) || chr(10) || '            throw ''[{0}] {1}''.format(resp.status_code, resp.message);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function createMessage(' || chr(13) || chr(10) || '    event_severity_color,' || chr(13) || chr(10) || '    event_date,' || chr(13) || chr(10) || '    event_time,' || chr(13) || chr(10) || '    problem_url,' || chr(13) || chr(10) || '    isShort' || chr(13) || chr(10) || ') {' || chr(13) || chr(10) || '    var message = {' || chr(13) || chr(10) || '        fallbac: params.alert_subject,' || chr(13) || chr(10) || '        title: params.alert_subject,' || chr(13) || chr(10) || '        color: event_severity_color,' || chr(13) || chr(10) || '        title_link: problem_url,' || chr(13) || chr(10) || '        footer: problem_url,' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        fields: [' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                title: ''Host'',' || chr(13) || chr(10) || '                value: ''{0} [{1}]''.format(params.host_name, params.host_ip),' || chr(13) || chr(10) || '                short: true' || chr(13) || chr(10) || '            },' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '')||
TO_NCLOB('                title: ''Event time'',' || chr(13) || chr(10) || '                value: ''{0} {1}''.format(event_date, event_time),' || chr(13) || chr(10) || '                short: true' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '    };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    ' || chr(13) || chr(10) || '    if (params.event_source === ''0'') {' || chr(13) || chr(10) || '        message.fields.push(' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                title: ''Severity'',' || chr(13) || chr(10) || '                value: params.event_severity,' || chr(13) || chr(10) || '                short: true' || chr(13) || chr(10) || '            },' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                title: ''Opdata'',' || chr(13) || chr(10) || '                value: params.event_opdata,' || chr(13) || chr(10) || '                short: true' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        );' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (!isShort && params.event_source === ''0'') {' || chr(13) || chr(10) || '        message.fields.push(' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                title: ''Event tags'',' || chr(13) || chr(10) || '                value: ''`{0}`''.format(params.event_tags.replace(/__.+?:(.+?,|.+)/g, '''') || ''None''),' || chr(13) || chr(10) || '                short: true' || chr(13) || chr(10) || '            },' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                title: ''Trigger description'',' || chr(13) || chr(10) || '                value: params.trigger_description,' || chr(13) || chr(10) || '                short: true' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        );' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    if (params.event_source !== ''0'' || params.event_update_status === ''1'') {' || chr(13) || chr(10) || '        message.fields.push(' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                title: ''Details'',' || chr(13) || chr(10) || '                value: params.alert_message,' || chr(13) || chr(10) || '                short: false' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        );' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return message;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function validateParams(params) {' || chr(13) || chr(10) || '    if (typeof params.bot_token !== ''string'' || params.bot_token.trim() === '''') {' || chr(13) || chr(10) || '        throw ''Field "bot_token" cannot be empty'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (isNaN(params.event_id)) {' || chr(13) || chr(10) || '        throw ''Field "event_id" is not a number'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: "'' + params.event_source + ''".\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'') {' || chr(13) || chr(10) || '        params.event_nseverity = ''0'';' || chr(13) || chr(10) || '        params.event_severity = ''Not classified'';' || chr(13) || chr(10) || '        params.event_update_status = ''0'';' || chr(13) || chr(10) || '        params.send_mode = ''event'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source === ''1'' || params.event_source === ''2'') {' || chr(13) || chr(10) || '        params.event_value = ''1'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '    if (params.event_source === ''1'') {' || chr(13) || chr(10) || '        params.host_name = params.discovery_host_dns;' || chr(13) || chr(10) || '        params.host_ip = params.discovery_host_ip;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_nseverity" parameter given: '' + params.event_nseverity + ''\nMust be 0-5.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.event_severity !== ''string'' || params.event_severity.trim() === '''') {' || chr(13) || chr(10) || '        throw ''Field "event_severity" cannot be empty'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.host_ip !== ''string'' || params.host_ip.trim() === '''') {' || chr(13) || chr(10) || '        throw ''Field "host_ip" cannot be empty'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.host_name !== ''string'' || params.host_name.trim() === '''') {' || chr(13) || chr(10) || '        throw ''Field "host_name" cannot be empty'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    if (typeof params.mattermost_url !== ''string'' || params.mattermost_url.trim() === '''') {' || chr(13) || chr(10) || '        throw ''Field "mattermost_url" cannot be empty'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (!/^(http|https):\/\/.+/.test(params.mattermost_url)) {' || chr(13) || chr(10) || '        throw ''Field "mattermost_url" must contain a schema'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([''alarm'', ''event''].indexOf(params.send_mode) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "send_mode" parameter given: '' + params.send_mode + ''\nMust be "alarm" or "event".'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.send_to !== ''string'' || params.send_to.trim() === '''') {' || chr(13) || chr(10) || '        throw ''Field "send_to" cannot be empty'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (isNaN(params.trigger_id) && params.event_source === ''0'') {' || chr(13) || chr(10) || '        throw ''field "trigger_id" is not a number'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.zabbix_url !== ''string'' || params.zabbix_url.trim() === '''') {' || chr(13) || chr(10) || '        throw ''Field "zabbix_url" cannot be empty'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (!/^(http|https):\/\/.+/.test(params.zabbix_url)) {' || chr(13) || chr(10) || '        throw ''Field "zabbix_url" must contain a schema'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    validateParams(params);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var req = new HttpRequest(),' || chr(13) || chr(10) || '')||
TO_NCLOB('        fields = {},' || chr(13) || chr(10) || '        result = {tags: {}};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.HTTPProxy === ''string'' && params.HTTPProxy.trim() !== '''') {' || chr(13) || chr(10) || '        req.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    req.addHeader(''Content-Type: application/json; charset=utf-8'');' || chr(13) || chr(10) || '    req.addHeader(''Authorization: Bearer '' + params.bot_token);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    params.mattermost_url = params.mattermost_url.replace(/\/+$/, '''');' || chr(13) || chr(10) || '    params.zabbix_url = params.zabbix_url.replace(/\/+$/, '''');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var APIEndpoint = params.mattermost_url + ''/api/v4/'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var Mattermost = {' || chr(13) || chr(10) || '        post_message: APIEndpoint + ''posts'',' || chr(13) || chr(10) || '        get_channel: APIEndpoint + ''channels/{0}'',' || chr(13) || chr(10) || '        get_team: APIEndpoint + ''teams/{0}'',' || chr(13) || chr(10) || '        chat_update: APIEndpoint + ''posts/{0}'',' || chr(13) || chr(10) || '        direct_channel: APIEndpoint + ''channels/direct'',' || chr(13) || chr(10) || '        channel_byname: APIEndpoint + ''teams/name/{0}/channels/name/{1}'',' || chr(13) || chr(10) || '        user_byname: APIEndpoint + ''users/username/{0}'',' || chr(13) || chr(10) || '        bot_user: APIEndpoint + ''users/me''' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    params.send_mode = params.send_mode.toLowerCase();' || chr(13) || chr(10) || '    params.send_mode = params.send_mode in SEND_MODE_HANDLERS' || chr(13) || chr(10) || '        ? params.send_mode' || chr(13) || chr(10) || '        : ''alarm'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    SEND_MODE_HANDLERS[params.send_mode](req, params);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source === ''0'') {' || chr(13) || chr(10) || '        return JSON.stringify(result);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        return ''OK'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(4, ''[ Mattermost Webhook ] Mattermost notification failed: '' + error);' || chr(13) || chr(10) || '    throw ''Mattermost notification failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__mattermost_message_link}','Open in Mattermost: {EVENT.TAGS.__mattermost_channel_name}','')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description)
values ('6','4','Opsgenie','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',TO_NCLOB('var Media = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '    name: '''',' || chr(13) || chr(10) || '    labels: [],' || chr(13) || chr(10) || '    HTTPProxy: '''',' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Media.params = params;' || chr(13) || chr(10) || '        Media.params.api += Media.params.api.endsWith(''/'') ? '''' : ''/'';' || chr(13) || chr(10) || '        Media.params.web += Media.params.web.endsWith(''/'') ? '''' : ''/'';' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setProxy: function (HTTPProxy) {' || chr(13) || chr(10) || '        if (typeof HTTPProxy !== ''undefined'' && HTTPProxy.trim() !== '''') {' || chr(13) || chr(10) || '            Media.HTTPProxy = HTTPProxy;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setTags: function(event_tags_json) {' || chr(13) || chr(10) || '        if (typeof event_tags_json !== ''undefined'' && event_tags_json !== ''''' || chr(13) || chr(10) || '                && event_tags_json !== ''{EVENT.TAGSJSON}'') {' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                var tags = JSON.parse(event_tags_json),' || chr(13) || chr(10) || '                    label;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                tags.forEach(function (tag) {' || chr(13) || chr(10) || '                    if (typeof tag.tag === ''string'') {' || chr(13) || chr(10) || '                        label = (tag.tag + (typeof tag.value !== ''undefined''' || chr(13) || chr(10) || '')||
TO_NCLOB('                                && tag.value !== '''' ? ('':'' + tag.value) : '''')).replace(/\s/g, ''_'');' || chr(13) || chr(10) || '                        Media.labels.push(label);' || chr(13) || chr(10) || '                    }' || chr(13) || chr(10) || '                });' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ '' + Media.name + '' Webhook ] Failed to parse "event_tags_json" param'');' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (method, query, data, allow_404) {' || chr(13) || chr(10) || '        if (typeof(allow_404) === ''undefined'') {' || chr(13) || chr(10) || '            allow_404 = false;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        [''api'', ''token''].forEach(function (field) {' || chr(13) || chr(10) || '            if (typeof Media.params !== ''object'' || typeof Media.params[field] === ''undefined''' || chr(13) || chr(10) || '                    || Media.params[field] === '''') {' || chr(13) || chr(10) || '                throw ''Required '' + Media.name + '' param is not set: "'' + field + ''".'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            url = Media.params.api + query,' || chr(13) || chr(10) || '            request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '        request.addHeader(''Authorization: '' + Media.params.token);' || chr(13) || chr(10) || '        request.setProxy(Media.HTTPProxy);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ '' + Media.name + '' Webhook ] Sending request: '' +' || chr(13) || chr(10) || '            url + ((typeof data === ''string'') ? (''\n'' + data) : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (method) {' || chr(13) || chr(10) || '            case ''get'':' || chr(13) || chr(10) || '                response = request.get(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''post'':' || chr(13) || chr(10) || '                response = request.post(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''put'':' || chr(13) || chr(10) || '                response = request.put(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                throw ''Unsupported HTTP request method: '' + method;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ '' + Media.name + '' Webhook ] Received response with status code '' +' || chr(13) || chr(10) || '            request.getStatus() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ '' + Media.name + '' Webhook ] Failed to parse response.'');' || chr(13) || chr(10) || '                response = null;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if ((request.getStatus() < 200 || request.getStatus() >= 300)' || chr(13) || chr(10) || '')||
TO_NCLOB('                && (!allow_404 || request.getStatus() !== 404)) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (response !== null) {' || chr(13) || chr(10) || '                if (typeof response.errors === ''object'' && Object.keys(response.errors).length > 0) {' || chr(13) || chr(10) || '                    message += '': '' + JSON.stringify(response.errors);' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '                else if (typeof response.errorMessages === ''object'' && Object.keys(response.errorMessages).length > 0) {' || chr(13) || chr(10) || '                    message += '': '' + JSON.stringify(response.errorMessages);' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '                else if (typeof response.message === ''string'') {' || chr(13) || chr(10) || '                    message += '': '' + response.message;' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            throw message + '' Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return {' || chr(13) || chr(10) || '            status: request.getStatus(),' || chr(13) || chr(10) || '            response: response' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    getAlertId: function (requestId) {' || chr(13) || chr(10) || '        do {' || chr(13) || chr(10) || '            resp = Media.request(''get'', ''requests/'' + requestId, undefined, true);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        while (typeof resp.response !== ''object'' || typeof resp.response.data === ''undefined''' || chr(13) || chr(10) || '')||
TO_NCLOB('                || resp.response.data.success === false);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof resp.response !== ''object'' || typeof resp.response.data === ''undefined'') {' || chr(13) || chr(10) || '            throw ''Cannot get '' + Media.name + '' issue ID. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return resp;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var result = {tags: {}},' || chr(13) || chr(10) || '        params = JSON.parse(value),' || chr(13) || chr(10) || '        media = {},' || chr(13) || chr(10) || '        fields = {},' || chr(13) || chr(10) || '        resp = {},' || chr(13) || chr(10) || '        responders = [],' || chr(13) || chr(10) || '        tags = [],' || chr(13) || chr(10) || '        required_params = [' || chr(13) || chr(10) || '            ''alert_subject'',' || chr(13) || chr(10) || '            ''alert_message'',' || chr(13) || chr(10) || '            ''event_id'',' || chr(13) || chr(10) || '            ''event_source'',' || chr(13) || chr(10) || '            ''event_value'',' || chr(13) || chr(10) || '            ''event_update_status'',' || chr(13) || chr(10) || '            ''opsgenie_api'',' || chr(13) || chr(10) || '            ''opsgenie_web'',' || chr(13) || chr(10) || '            ''opsgenie_token''' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        severities = [' || chr(13) || chr(10) || '            ''not_classified'',' || chr(13) || chr(10) || '            ''information'',' || chr(13) || chr(10) || '            ''warning'',' || chr(13) || chr(10) || '            ''average'',' || chr(13) || chr(10) || '            ''high'',' || chr(13) || chr(10) || '            ''disaster'',' || chr(13) || chr(10) || '            ''resolved'',' || chr(13) || chr(10) || '            ''default''' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '')||
TO_NCLOB('        priority;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (required_params.indexOf(key) !== -1 && params[key].trim() === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" cannot be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            if (key.startsWith(''opsgenie_'')) {' || chr(13) || chr(10) || '                media[key.substring(9)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Possible values of event_source:' || chr(13) || chr(10) || '    // 0 - Trigger, 1 - Discovery, 2 - Autoregistration, 3 - Internal.' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: "'' + params.event_source + ''".\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check event_value for trigger-based and internal events.' || chr(13) || chr(10) || '    // Possible values: 1 for problem, 0 for recovering' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check event_update_status only for trigger-based events.' || chr(13) || chr(10) || '    // Possible values: 0 - Webhook was called because of problem/recovery event, 1 - Update operation.' || chr(13) || chr(10) || '')||
TO_NCLOB('    if (params.event_source === ''0'' && params.event_update_status !== ''0'' && params.event_update_status !== ''1'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check event_id for a numeric value.' || chr(13) || chr(10) || '    if (isNaN(parseInt(params.event_id)) || params.event_id < 1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_id" parameter given: '' + params.event_id + ''\nMust be a positive number.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ((params.event_source === ''1'' || params.event_source === ''2'')  && params.event_value === ''0'') {' || chr(13) || chr(10) || '        throw ''Recovery operations are supported only for Trigger and Internal actions.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {' || chr(13) || chr(10) || '        params.event_nseverity = ''7'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value === ''0'') {' || chr(13) || chr(10) || '        params.event_nseverity = ''6'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    priority = params[''severity_'' + severities[params.event_nseverity]];' || chr(13) || chr(10) || '    params.zbxurl = params.zbxurl + (params.zbxurl.endsWith(''/'') ? '''' : ''/'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Media.name = ''Opsgenie'';' || chr(13) || chr(10) || '    Media.setParams(media);' || chr(13) || chr(10) || '    Media.params.token = ''GenieKey '' + Media.params.token;' || chr(13) || chr(10) || '    Media.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    Media.setTags(params.event_tags_json); // Set Media.labels' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Create an issue.' || chr(13) || chr(10) || '')||
TO_NCLOB('    // Numeric value of the event that triggered an action (1 for problem, 0 for recovering).' || chr(13) || chr(10) || '    // Numeric value of the problem update status. Possible values:' || chr(13) || chr(10) || '    // 0 - Webhook was called because of problem/recovery event, 1 - Update operation.' || chr(13) || chr(10) || '    if ((params.event_source == 0 && params.event_value == 1 && params.event_update_status == 0)' || chr(13) || chr(10) || '            || (params.event_source == 3 && params.event_value == 1)' || chr(13) || chr(10) || '            || params.event_source == 1 || params.event_source == 2) {' || chr(13) || chr(10) || '        fields.message = params.alert_subject;' || chr(13) || chr(10) || '        fields.alias = params.event_id;' || chr(13) || chr(10) || '        fields.description = params.alert_message;' || chr(13) || chr(10) || '        fields.priority = priority;' || chr(13) || chr(10) || '        fields.source = ''Zabbix'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (params.event_source === ''0'') {' || chr(13) || chr(10) || '            fields.details = {' || chr(13) || chr(10) || '                ''Zabbix server'': params.zbxurl,' || chr(13) || chr(10) || '                Problem: params.zbxurl + ''tr_events.php?triggerid='' + params.trigger_id + ''&eventid='' + params.event_id' || chr(13) || chr(10) || '            };' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            fields.details = {''Zabbix server'': params.zbxurl};' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof params.opsgenie_teams === ''string'') {' || chr(13) || chr(10) || '            responders = params.opsgenie_teams.split('','');' || chr(13) || chr(10) || '            fields.responders = responders.map(function(team) {' || chr(13) || chr(10) || '                return {type: ''team'', name: team.trim()};' || chr(13) || chr(10) || '            });' || chr(13) || chr(10) || '')||
TO_NCLOB('        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        fields.tags = Media.labels;' || chr(13) || chr(10) || '        if (typeof params.opsgenie_tags === ''string'') {' || chr(13) || chr(10) || '            tags = params.opsgenie_tags.split('','');' || chr(13) || chr(10) || '            tags.forEach(function(item) {' || chr(13) || chr(10) || '                fields.tags.push(item.trim());' || chr(13) || chr(10) || '            });' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        resp = Media.request(''post'', '''', fields);' || chr(13) || chr(10) || '        if (typeof resp.response !== ''object'' || typeof resp.response.result === ''undefined'') {' || chr(13) || chr(10) || '            throw ''Cannot create '' + Media.name + '' issue. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (resp.status === 202) {' || chr(13) || chr(10) || '            resp = Media.getAlertId(resp.response.requestId);' || chr(13) || chr(10) || '            if (params.event_source == 0 && params.event_value == 1 && params.event_update_status == 0) {' || chr(13) || chr(10) || '                result.tags.__zbx_ops_issuekey = resp.response.data.alertId;' || chr(13) || chr(10) || '                result.tags.__zbx_ops_issuelink = Media.params.web + ''alert/detail/'' + resp.response.data.alertId;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            throw Media.name + '' response code is unexpected. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Update a created issue.' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        fields.user = (params.event_value != 0) ? params.zbxuser : '''';' || chr(13) || chr(10) || '        fields.note = params.alert_message;' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '        resp = Media.request(''post'', params.event_id + ''/notes?identifierType=alias'', fields);' || chr(13) || chr(10) || '        if (typeof resp.response !== ''object'' || typeof resp.response.result === ''undefined'') {' || chr(13) || chr(10) || '            throw ''Cannot update '' + Media.name + '' issue. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (resp.status === 202) {' || chr(13) || chr(10) || '            resp = Media.getAlertId(resp.response.requestId);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            throw Media.name + '' response code is unexpected. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return JSON.stringify(result);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ '' + Media.name + '' Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_ops_issuelink}','Opsgenie: {EVENT.TAGS.__zbx_ops_issuekey}','Please refer to https://docs.opsgenie.com/docs/alert-api and https://www.zabbix.com/documentation/6.0/manual/config/notifications/media/webhook#example_scripts.' || chr(13) || chr(10) || '  ' || chr(13) || chr(10) || 'Set global macro {$ZABBIX.URL} with your Zabbix server URL.' || chr(13) || chr(10) || 'Add dedicated user with media type "Opsgenie".' || chr(13) || chr(10) || 'Change the values of the variables opsgenie_api (https://api.opsgenie.com/v2/alerts or https://api.eu.opsgenie.com/v2/alerts),' || chr(13) || chr(10) || 'opsgenie_web (for example, https://myzabbix.app.opsgenie.com), opsgenie_token.')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description)
values ('7','4','PagerDuty','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',TO_NCLOB('try {' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        req = new HttpRequest(),' || chr(13) || chr(10) || '        fields = {},' || chr(13) || chr(10) || '        resp = '''';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Correspondence between the PagerDuty and Zabbix severity level' || chr(13) || chr(10) || '    var severityMapping = [' || chr(13) || chr(10) || '        ''info'',    // Not classified' || chr(13) || chr(10) || '        ''info'',    // Information' || chr(13) || chr(10) || '        ''warning'', // Warning' || chr(13) || chr(10) || '        ''warning'', // Average' || chr(13) || chr(10) || '        ''error'',   // High' || chr(13) || chr(10) || '        ''critical'' // Disaster' || chr(13) || chr(10) || '    ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (!severityMapping[params.severity]) {' || chr(13) || chr(10) || '        params.severity = ''0'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.HTTPProxy === ''string'' && params.HTTPProxy.trim() !== '''') {' || chr(13) || chr(10) || '        req.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (isNaN(parseInt(params.eventid)) || params.eventid < 1) {' || chr(13) || chr(10) || '        throw ''incorrect value for variable "eventid". The value must be a positive number.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    if (params.eventname.length < 1) {' || chr(13) || chr(10) || '        throw ''incorrect value for variable "eventname". The value must be a non-empty string.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    if (isNaN(parseInt(params.severity)) || (params.severity < 0 && params.severity > 5)) {' || chr(13) || chr(10) || '        throw ''incorrect value for variable "severity". The value must be a number 0..5.'';' || chr(13) || chr(10) || '')||
TO_NCLOB('    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: "'' + params.event_source + ''".\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.eventvalue !== ''0'' && params.eventvalue !== ''1''' || chr(13) || chr(10) || '        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "eventvalue" parameter given: "'' + params.eventvalue + ''".\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source === ''0'') {' || chr(13) || chr(10) || '        if (params.hostname.length < 1) {' || chr(13) || chr(10) || '            throw ''incorrect value for variable "hostname". The value must be a non-empty string.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        if (isNaN(parseInt(params.triggerid)) || params.triggerid < 1) {' || chr(13) || chr(10) || '            throw ''incorrect value for variable "triggerid". The value must be a positive number.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        if (params.eventack != ''Yes'' && params.eventack != ''No'') {' || chr(13) || chr(10) || '            throw ''incorrect value for variable "eventack". The value must be Yes or No.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        if (isNaN(parseInt(params.eventupdate)) || (params.eventupdate < 0 || params.eventupdate > 1)) {' || chr(13) || chr(10) || '            throw ''incorrect value for variable "eventupdate". The value must be 0 or 1.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    req.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    fields.routing_key = params.token;' || chr(13) || chr(10) || '    fields.dedup_key = params.eventid;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (((params.eventvalue == 1) && (params.eventupdate == 0)) || params.event_source !== ''0'') {' || chr(13) || chr(10) || '        fields.event_action = ''trigger'';' || chr(13) || chr(10) || '        fields.payload = {' || chr(13) || chr(10) || '            summary: params.eventname,' || chr(13) || chr(10) || '            source: (params.event_source === ''1'') ? ''Discovery'' : params.hostname + '' : '' + params.hostip,' || chr(13) || chr(10) || '            severity: severityMapping[params.severity],' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '        ' || chr(13) || chr(10) || '        if (params.event_source === ''0'') {' || chr(13) || chr(10) || '            fields.payload.custom_details = {' || chr(13) || chr(10) || '                ''Event date'': params.eventdate,' || chr(13) || chr(10) || '                ''Event time'': params.eventtime,' || chr(13) || chr(10) || '                ''Trigger description'': params.triggerdesc,' || chr(13) || chr(10) || '                ''Trigger opdata'': params.triggeropdata,' || chr(13) || chr(10) || '                ''Event tags'': params.eventtags,' || chr(13) || chr(10) || '                ''Event host'': params.hostname,' || chr(13) || chr(10) || '                ''Event host ip'': params.hostip' || chr(13) || chr(10) || '            };' || chr(13) || chr(10) || '            fields.links = [{' || chr(13) || chr(10) || '                href: params.url + ''/tr_events.php?triggerid='' + params.triggerid + ''&eventid='' + params.eventid,' || chr(13) || chr(10) || '                text: ''Event link''' || chr(13) || chr(10) || '            }];' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '')||
TO_NCLOB('            fields.payload.custom_details = {' || chr(13) || chr(10) || '                ''Alert message'': params.alert_message' || chr(13) || chr(10) || '            };' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        fields.client = ''Zabbix'';' || chr(13) || chr(10) || '        fields.client_url = params.url;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else if ((params.eventvalue == 1) && (params.eventupdate == 1) && (params.eventack == ''Yes''))' || chr(13) || chr(10) || '        fields.event_action = ''acknowledge'';' || chr(13) || chr(10) || '    else if (params.eventvalue == 0)' || chr(13) || chr(10) || '        fields.event_action = ''resolve'';' || chr(13) || chr(10) || '    else' || chr(13) || chr(10) || '        throw ''incorrect values. Update message without ack will not be sent.'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Zabbix.log(4, ''[PagerDuty Webhook] Sending request:'' + JSON.stringify(fields));' || chr(13) || chr(10) || '    resp = req.post(''https://events.pagerduty.com/v2/enqueue'',' || chr(13) || chr(10) || '        JSON.stringify(fields)' || chr(13) || chr(10) || '    );' || chr(13) || chr(10) || '    Zabbix.log(4, ''[PagerDuty Webhook] Receiving response:'' + resp);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    try {' || chr(13) || chr(10) || '        resp = JSON.parse(resp);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    catch (error) {' || chr(13) || chr(10) || '        throw ''incorrect response. PagerDuty returned a non-JSON object.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (req.getStatus() != 202) {' || chr(13) || chr(10) || '        if (typeof resp === ''object'' && typeof resp.errors === ''object'' && typeof resp.errors[0] === ''string'') {' || chr(13) || chr(10) || '            throw resp.errors[0];' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '')||
TO_NCLOB('            throw ''Unknown error.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (resp.status != ''success'') {' || chr(13) || chr(10) || '        throw ''Unknown error.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return ''OK'';' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[PagerDuty Webhook] Notification failed : '' + error);' || chr(13) || chr(10) || '    throw ''PagerDuty notification failed : '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','0','0','','','Please refer to https://v2.developer.pagerduty.com/docs/send-an-event-events-api-v2 and https://www.zabbix.com/documentation/6.0/manual/config/notifications/media/webhook#example_scripts.' || chr(13) || chr(10) || '  ' || chr(13) || chr(10) || 'Set global macro {$ZABBIX.URL} with your Zabbix server URL.' || chr(13) || chr(10) || 'Add a dedicated user with the media type "PagerDuty" and place the integration key in the "token" parameter to integrate into the service.')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description)
values ('8','4','Pushover','','','','','','','','0','25','0','0','0','0','','0','3','10s','1',TO_NCLOB('try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        request = new HttpRequest(),' || chr(13) || chr(10) || '        data,' || chr(13) || chr(10) || '        response,' || chr(13) || chr(10) || '        severities = [' || chr(13) || chr(10) || '            {name: ''not_classified'', color: ''#97AAB3''},' || chr(13) || chr(10) || '            {name: ''information'', color: ''#7499FF''},' || chr(13) || chr(10) || '            {name: ''warning'', color: ''#FFC859''},' || chr(13) || chr(10) || '            {name: ''average'', color: ''#FFA059''},' || chr(13) || chr(10) || '            {name: ''high'', color: ''#E97659''},' || chr(13) || chr(10) || '            {name: ''disaster'', color: ''#E45959''},' || chr(13) || chr(10) || '            {name: ''resolved'', color: ''#009900''},' || chr(13) || chr(10) || '            {name: ''default'', color: ''#000000''}' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        priority;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.HTTPProxy === ''string'' && params.HTTPProxy.trim() !== '''') {' || chr(13) || chr(10) || '        request.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: "'' + params.event_source + ''".\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {' || chr(13) || chr(10) || '        params.event_nseverity = ''7'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value === ''0'') {' || chr(13) || chr(10) || '        params.event_nseverity = ''6'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    priority = params[''priority_'' + severities[params.event_nseverity].name] || params.priority_default;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (isNaN(priority) || priority < -2 || priority > 2) {' || chr(13) || chr(10) || '        throw ''"priority" should be -2..2'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source === ''0'' && isNaN(params.triggerid)) {' || chr(13) || chr(10) || '        throw ''field "triggerid" is not a number'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (isNaN(params.eventid)) {' || chr(13) || chr(10) || '        throw ''field "eventid" is not a number'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.message !== ''string'' || params.message.trim() === '''') {' || chr(13) || chr(10) || '        throw ''field "message" cannot be empty'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    data = {' || chr(13) || chr(10) || '        token: params.token,' || chr(13) || chr(10) || '        user: params.user,' || chr(13) || chr(10) || '        title: params.title,' || chr(13) || chr(10) || '        message: params.message,' || chr(13) || chr(10) || '        url: (params.event_source === ''0'') ' || chr(13) || chr(10) || '            ? params.url + ''/tr_events.php?triggerid='' + params.triggerid + ''&eventid='' + params.eventid' || chr(13) || chr(10) || '            : params.url,' || chr(13) || chr(10) || '        url_title: params.url_title,' || chr(13) || chr(10) || '')||
TO_NCLOB('        priority: priority' || chr(13) || chr(10) || '    };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (priority == 2) {' || chr(13) || chr(10) || '        if (isNaN(params.retry) || params.retry < 30) {' || chr(13) || chr(10) || '            throw ''field "retry" should be a number with value of at least 30 if "priority" is set to 2'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (isNaN(params.expire) || params.expire > 10800) {' || chr(13) || chr(10) || '            throw ''field "expire" should be a number with value of at most 10800 if "priority" is set to 2'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        data.retry = params.retry;' || chr(13) || chr(10) || '        data.expire = params.expire;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    data = JSON.stringify(data);' || chr(13) || chr(10) || '    Zabbix.log(4, ''[ Pushover Webhook ] Sending request: '' + params.endpoint + ''\n'' + data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '    response = request.post(params.endpoint, data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Zabbix.log(4, ''[ Pushover Webhook ] Received response with status code '' + request.getStatus() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (response !== null) {' || chr(13) || chr(10) || '        try {' || chr(13) || chr(10) || '            response = JSON.parse(response);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        catch (error) {' || chr(13) || chr(10) || '            Zabbix.log(4, ''[ Pushover Webhook ] Failed to parse response received from Pushover'');' || chr(13) || chr(10) || '            response = null;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    if (request.getStatus() != 200 || response === null || typeof response !== ''object'' || response.status !== 1) {' || chr(13) || chr(10) || '        if (response !== null && typeof response === ''object'' && typeof response.errors === ''object''' || chr(13) || chr(10) || '                && typeof response.errors[0] === ''string'') {' || chr(13) || chr(10) || '            throw response.errors[0];' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            throw ''Unknown error. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return ''OK'';' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(4, ''[ Pushover Webhook ] Pushover notification failed: '' + error);' || chr(13) || chr(10) || '    throw ''Pushover notification failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','0','0','','','Please refer to setup guide here: https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/pushover' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Set token parameter with to your Pushover application key.' || chr(13) || chr(10) || 'When assigning Pushover media to the Zabbix user - add user key into send to field.')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description)
values ('9','4','Slack','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',TO_NCLOB('var SEVERITY_COLORS = [' || chr(13) || chr(10) || '    ''#97AAB3'', ''#7499FF'', ''#FFC859'',' || chr(13) || chr(10) || '    ''#FFA059'', ''#E97659'', ''#E45959''' || chr(13) || chr(10) || '];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'var RESOLVE_COLOR = ''#009900'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'var SLACK_MODE_HANDLERS = {' || chr(13) || chr(10) || '    alarm: handlerAlarm,' || chr(13) || chr(10) || '    event: handlerEvent' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'if (!String.prototype.format) {' || chr(13) || chr(10) || '    String.prototype.format = function() {' || chr(13) || chr(10) || '        var args = arguments;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return this.replace(/{(\d+)}/g, function(match, number) {' || chr(13) || chr(10) || '            return number in args' || chr(13) || chr(10) || '                ? args[number]' || chr(13) || chr(10) || '                : match' || chr(13) || chr(10) || '            ;' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '    };' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function isEventProblem(params) {' || chr(13) || chr(10) || '    return params.event_value == 1' || chr(13) || chr(10) || '        && params.event_update_status == 0' || chr(13) || chr(10) || '    ;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function isEventUpdate(params) {' || chr(13) || chr(10) || '    return params.event_value == 1' || chr(13) || chr(10) || '        && params.event_update_status == 1' || chr(13) || chr(10) || '    ;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function isEventResolve(params) {' || chr(13) || chr(10) || '    return params.event_value == 0;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('function getPermalink(channelId, messageTimestamp) {' || chr(13) || chr(10) || '    var req = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.HTTPProxy === ''string'' && params.HTTPProxy.trim() !== '''') {' || chr(13) || chr(10) || '        req.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    req.addHeader(''Content-Type: application/x-www-form-urlencoded; charset=utf-8'');' || chr(13) || chr(10) || '    req.addHeader(''Authorization: Bearer '' + params.bot_token);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var query = ''{0}?channel={1}&message_ts={2}''.format(' || chr(13) || chr(10) || '            Slack.getPermalink,' || chr(13) || chr(10) || '            encodeURIComponent(channelId),' || chr(13) || chr(10) || '            encodeURIComponent(messageTimestamp)),' || chr(13) || chr(10) || '        resp = JSON.parse(req.get(query));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (req.getStatus() != 200 || !resp.ok || resp.ok === ''false'') {' || chr(13) || chr(10) || '        throw ''message was created, but getting message link was failed with reason "'' + resp.error + ''"'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return resp.permalink;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function createProblemURL(zabbix_url, triggerid, eventid, event_source) {' || chr(13) || chr(10) || '    var problem_url = '''';' || chr(13) || chr(10) || '    if (event_source === ''0'') {' || chr(13) || chr(10) || '        problem_url = ''{0}/tr_events.php?triggerid={1}&eventid={2}''' || chr(13) || chr(10) || '            .format(' || chr(13) || chr(10) || '                zabbix_url,' || chr(13) || chr(10) || '                triggerid,' || chr(13) || chr(10) || '                eventid' || chr(13) || chr(10) || '            );' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '')||
TO_NCLOB('        problem_url = zabbix_url;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return problem_url;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function handlerAlarm(params) {' || chr(13) || chr(10) || '    var fields = {' || chr(13) || chr(10) || '        channel: params.channel,' || chr(13) || chr(10) || '        as_user: params.slack_as_user,' || chr(13) || chr(10) || '    };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (isEventProblem(params)) {' || chr(13) || chr(10) || '        fields.attachments = [' || chr(13) || chr(10) || '            createMessage(' || chr(13) || chr(10) || '                SEVERITY_COLORS[params.event_nseverity] || 0,' || chr(13) || chr(10) || '                params.event_date,' || chr(13) || chr(10) || '                params.event_time,' || chr(13) || chr(10) || '                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)' || chr(13) || chr(10) || '            )' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var resp = JSON.parse(req.post(Slack.postMessage, JSON.stringify(fields)));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (req.getStatus() != 200 || !resp.ok || resp.ok === ''false'') {' || chr(13) || chr(10) || '            throw resp.error;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result.tags = {' || chr(13) || chr(10) || '            [''__message_ts_'' + params.channel]: resp.ts,' || chr(13) || chr(10) || '            [''__channel_id_'' + params.channel]: resp.channel,' || chr(13) || chr(10) || '            [''__message_link_'' + params.channel]: getPermalink(resp.channel, resp.ts),' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else if (isEventUpdate(params)) {' || chr(13) || chr(10) || '        try {' || chr(13) || chr(10) || '')||
TO_NCLOB('            var channel_event_tags = JSON.parse(params.event_tags);' || chr(13) || chr(10) || '        } catch (error) {' || chr(13) || chr(10) || '            throw ''Cannot process event tags: '' + error;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (Array.isArray(channel_event_tags)) {' || chr(13) || chr(10) || '            for (i in channel_event_tags) {' || chr(13) || chr(10) || '                if (channel_event_tags[i].tag.includes(''__message_ts_'' + params.channel)) {' || chr(13) || chr(10) || '                    fields.thread_ts = channel_event_tags[i].value;' || chr(13) || chr(10) || '                    break;' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        fields.attachments = [' || chr(13) || chr(10) || '            createMessage(' || chr(13) || chr(10) || '                SEVERITY_COLORS[params.event_nseverity] || 0,' || chr(13) || chr(10) || '                params.event_update_date,' || chr(13) || chr(10) || '                params.event_update_time,' || chr(13) || chr(10) || '                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source),' || chr(13) || chr(10) || '                true' || chr(13) || chr(10) || '            )' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        resp = JSON.parse(req.post(Slack.postMessage, JSON.stringify(fields)));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (req.getStatus() != 200 || !resp.ok || resp.ok === ''false'') {' || chr(13) || chr(10) || '            throw resp.error;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else if (isEventResolve(params)) {' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        fields.text = '''';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('        try {' || chr(13) || chr(10) || '            var channel_event_tags = JSON.parse(params.event_tags);' || chr(13) || chr(10) || '        } catch (error) {' || chr(13) || chr(10) || '            throw ''Cannot process event tags: '' + error;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (Array.isArray(channel_event_tags)) {' || chr(13) || chr(10) || '            for (i in channel_event_tags) {' || chr(13) || chr(10) || '                if (channel_event_tags[i].tag.includes(''__channel_id_'' + params.channel)) {' || chr(13) || chr(10) || '                    fields.channel = channel_event_tags[i].value;' || chr(13) || chr(10) || '                    continue;' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '                if (channel_event_tags[i].tag.includes(''__message_ts_'' + params.channel)) {' || chr(13) || chr(10) || '                    fields.ts = channel_event_tags[i].value;' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        fields.attachments = [' || chr(13) || chr(10) || '            createMessage(' || chr(13) || chr(10) || '                RESOLVE_COLOR,' || chr(13) || chr(10) || '                params.event_date,' || chr(13) || chr(10) || '                params.event_time,' || chr(13) || chr(10) || '                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)' || chr(13) || chr(10) || '            )' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        resp = JSON.parse(req.post(Slack.chatUpdate, JSON.stringify(fields)));' || chr(13) || chr(10) || '        if (req.getStatus() != 200 || !resp.ok || resp.ok === ''false'') {' || chr(13) || chr(10) || '            throw resp.error;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '')||
TO_NCLOB('}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function handlerEvent(params) {' || chr(13) || chr(10) || '    var fields = {' || chr(13) || chr(10) || '        channel: params.channel,' || chr(13) || chr(10) || '        as_user: params.slack_as_user' || chr(13) || chr(10) || '    };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (isEventProblem(params)) {' || chr(13) || chr(10) || '        fields.attachments = [' || chr(13) || chr(10) || '            createMessage(' || chr(13) || chr(10) || '                SEVERITY_COLORS[params.event_nseverity] || 0,' || chr(13) || chr(10) || '                params.event_date,' || chr(13) || chr(10) || '                params.event_time,' || chr(13) || chr(10) || '                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)' || chr(13) || chr(10) || '            )' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var resp = JSON.parse(req.post(Slack.postMessage, JSON.stringify(fields)));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (req.getStatus() != 200 || !resp.ok || resp.ok === ''false'') {' || chr(13) || chr(10) || '            throw resp.error;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result.tags = {' || chr(13) || chr(10) || '            [''__message_link_'' + params.channel]: getPermalink(resp.channel, resp.ts)' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else if (isEventUpdate(params)) {' || chr(13) || chr(10) || '        fields.attachments = [' || chr(13) || chr(10) || '            createMessage(' || chr(13) || chr(10) || '                SEVERITY_COLORS[params.event_nseverity] || 0,' || chr(13) || chr(10) || '                params.event_update_date,' || chr(13) || chr(10) || '                params.event_update_time,' || chr(13) || chr(10) || '')||
TO_NCLOB('                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source),' || chr(13) || chr(10) || '                false' || chr(13) || chr(10) || '            )' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        resp = JSON.parse(req.post(Slack.postMessage, JSON.stringify(fields)));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (req.getStatus() != 200 || !resp.ok || resp.ok === ''false'') {' || chr(13) || chr(10) || '            throw resp.error;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else if (isEventResolve(params)) {' || chr(13) || chr(10) || '        fields.attachments = [' || chr(13) || chr(10) || '            createMessage(' || chr(13) || chr(10) || '                RESOLVE_COLOR,' || chr(13) || chr(10) || '                params.event_recovery_date,' || chr(13) || chr(10) || '                params.event_recovery_time,' || chr(13) || chr(10) || '                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)' || chr(13) || chr(10) || '            )' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        resp = JSON.parse(req.post(Slack.postMessage, JSON.stringify(fields)));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (req.getStatus() != 200 || !resp.ok || resp.ok === ''false'') {' || chr(13) || chr(10) || '            throw resp.error;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function createMessage(' || chr(13) || chr(10) || '    event_severity_color,' || chr(13) || chr(10) || '    event_date,' || chr(13) || chr(10) || '    event_time,' || chr(13) || chr(10) || '    problem_url,' || chr(13) || chr(10) || '    isShort,' || chr(13) || chr(10) || '    messageText' || chr(13) || chr(10) || ') {' || chr(13) || chr(10) || '')||
TO_NCLOB('    var message = {' || chr(13) || chr(10) || '        fallback: params.alert_subject,' || chr(13) || chr(10) || '        title: params.alert_subject,' || chr(13) || chr(10) || '        color: event_severity_color,' || chr(13) || chr(10) || '        title_link: problem_url,' || chr(13) || chr(10) || '        pretext: messageText || '''',' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        fields: [' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                title: ''Host'',' || chr(13) || chr(10) || '                value: ''{0} [{1}]''.format(params.host_name, params.host_conn),' || chr(13) || chr(10) || '                short: true' || chr(13) || chr(10) || '            },' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                title: ''Event time'',' || chr(13) || chr(10) || '                value: ''{0} {1}''.format(event_date, event_time),' || chr(13) || chr(10) || '                short: true' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '    };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source === ''0'') {' || chr(13) || chr(10) || '        message.fields.push(' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                title: ''Severity'',' || chr(13) || chr(10) || '                value: params.event_severity,' || chr(13) || chr(10) || '                short: true' || chr(13) || chr(10) || '            },' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                title: ''Opdata'',' || chr(13) || chr(10) || '                value: params.event_opdata,' || chr(13) || chr(10) || '                short: true' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        );' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (!isShort  && params.event_source === ''0'') {' || chr(13) || chr(10) || '        message[''actions''] = [' || chr(13) || chr(10) || '')||
TO_NCLOB('            {' || chr(13) || chr(10) || '                type: ''button'',' || chr(13) || chr(10) || '                text: ''Open in Zabbix'',' || chr(13) || chr(10) || '                url: problem_url' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        message.fields.push(' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                title: ''Event tags'',' || chr(13) || chr(10) || '                value: JSON.parse(params.event_tags).filter(function (e) { return !e.tag.includes(''__'') }).map(function (e) { return e.tag + '': '' + e.value }).join(''\n'') || ''None'',' || chr(13) || chr(10) || '                short: true' || chr(13) || chr(10) || '            },' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                title: ''Trigger description'',' || chr(13) || chr(10) || '                value: params.trigger_description,' || chr(13) || chr(10) || '                short: true' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        );' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' || params.event_update_status === ''1'') {' || chr(13) || chr(10) || '        message.fields.push(' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                title: ''Details'',' || chr(13) || chr(10) || '                value: params.alert_message,' || chr(13) || chr(10) || '                short: false' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        );' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return message;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function validateParams(params) {' || chr(13) || chr(10) || '    if (typeof params.bot_token !== ''string'' || params.bot_token.trim() === '''') {' || chr(13) || chr(10) || '')||
TO_NCLOB('        throw ''Field "bot_token" cannot be empty'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.channel !== ''string'' || params.channel.trim() === '''') {' || chr(13) || chr(10) || '        throw ''Field "channel" cannot be empty'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (isNaN(params.event_id)) {' || chr(13) || chr(10) || '        throw ''Field "event_id" is not a number'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: "'' + params.event_source + ''".\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'') {' || chr(13) || chr(10) || '        params.event_nseverity = ''0'';' || chr(13) || chr(10) || '        params.event_severity = ''Not classified'';' || chr(13) || chr(10) || '        params.event_update_status = ''0'';' || chr(13) || chr(10) || '        params.slack_mode = ''event'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source === ''1'' || params.event_source === ''2'') {' || chr(13) || chr(10) || '        params.event_value = ''1'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source === ''1'') {' || chr(13) || chr(10) || '        params.host_name = params.discovery_host_dns;' || chr(13) || chr(10) || '        params.host_ip = params.discovery_host_ip;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (!~[0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity))) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_nseverity" parameter given: '' + params.event_nseverity + ''\nMust be 0-5.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    if (typeof params.event_severity !== ''string'' || params.event_severity.trim() === '''') {' || chr(13) || chr(10) || '        throw ''Field "event_severity" cannot be empty'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.host_conn !== ''string'' || params.host_conn.trim() === '''') {' || chr(13) || chr(10) || '        throw ''Field "host_conn" cannot be empty'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.host_name !== ''string'' || params.host_name.trim() === '''') {' || chr(13) || chr(10) || '        throw ''Field "host_name" cannot be empty'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (!~[''true'', ''false''].indexOf(params.slack_as_user.toLowerCase())) {' || chr(13) || chr(10) || '        throw ''Incorrect "slack_as_user" parameter given: '' + params.slack_as_user + ''\nMust be "true" or "false".'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (!~[''alarm'', ''event''].indexOf(params.slack_mode)) {' || chr(13) || chr(10) || '        throw ''Incorrect "slack_mode" parameter given: '' + params.slack_mode + ''\nMust be "alarm" or "event".'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    if (isNaN(params.trigger_id) && params.event_source === ''0'') {' || chr(13) || chr(10) || '        throw ''field "trigger_id" is not a number'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.zabbix_url !== ''string'' || params.zabbix_url.trim() === '''') {' || chr(13) || chr(10) || '        throw ''Field "zabbix_url" cannot be empty'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (!/^(http|https):\/\/.+/.test(params.zabbix_url)) {' || chr(13) || chr(10) || '        throw ''Field "zabbix_url" must contain a schema'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    validateParams(params);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var req = new HttpRequest(),' || chr(13) || chr(10) || '        result = {tags: {}};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.HTTPProxy === ''string'' && params.HTTPProxy.trim() !== '''') {' || chr(13) || chr(10) || '        req.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    req.addHeader(''Content-Type: application/json; charset=utf-8'');' || chr(13) || chr(10) || '    req.addHeader(''Authorization: Bearer '' + params.bot_token);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var slack_endpoint = ''https://slack.com/api/'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var Slack = {' || chr(13) || chr(10) || '        postMessage: slack_endpoint + ''chat.postMessage'',' || chr(13) || chr(10) || '        getPermalink: slack_endpoint + ''chat.getPermalink'',' || chr(13) || chr(10) || '        chatUpdate: slack_endpoint + ''chat.update''' || chr(13) || chr(10) || '    };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    params.slack_mode = params.slack_mode.toLowerCase();' || chr(13) || chr(10) || '    params.slack_mode = params.slack_mode in SLACK_MODE_HANDLERS' || chr(13) || chr(10) || '        ? params.slack_mode' || chr(13) || chr(10) || '        : ''alarm'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    SLACK_MODE_HANDLERS[params.slack_mode](params);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source === ''0'') {' || chr(13) || chr(10) || '        return JSON.stringify(result);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        return ''OK'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(4, ''[ Slack Webhook ] Slack notification failed : '' + error);' || chr(13) || chr(10) || '    throw ''Slack notification failed : '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','0','','','')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description)
values ('10','4','Discord','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',TO_NCLOB('var SEVERITY_COLORS = [' || chr(13) || chr(10) || '    ''#97AAB3'', // Not classified.' || chr(13) || chr(10) || '    ''#7499FF'', // Information.' || chr(13) || chr(10) || '    ''#FFC859'', // Warning.' || chr(13) || chr(10) || '    ''#FFA059'', // Average.' || chr(13) || chr(10) || '    ''#E97659'', // High.' || chr(13) || chr(10) || '    ''#E45959'', // Disaster.' || chr(13) || chr(10) || '    ''#009900''  // Resolved.' || chr(13) || chr(10) || '];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'function stringTruncate(str, len) {' || chr(13) || chr(10) || '    return str.length > len ? str.substring(0, len - 3) + ''...'' : str;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    Zabbix.log(4, ''[ Discord Webhook ] Executed with params: '' + value);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var params = JSON.parse(value);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (!params.discord_endpoint) {' || chr(13) || chr(10) || '        throw ''Cannot get discord_endpoint'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        params.discord_endpoint = params.discord_endpoint.replace(''/api/'', ''/api/v7/'') + ''?wait=True'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    params.zabbix_url = (params.zabbix_url.endsWith(''/''))' || chr(13) || chr(10) || '        ? params.zabbix_url.slice(0, -1) : params.zabbix_url;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: "'' + params.event_source + ''".\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Set params to true for non trigger-based events.' || chr(13) || chr(10) || '    if (params.event_source !== ''0'') {' || chr(13) || chr(10) || '')||
TO_NCLOB('        params.use_default_message = ''true'';' || chr(13) || chr(10) || '        params.event_nseverity = ''0'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: "'' + params.event_value + ''".\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'' && params.event_source === ''0'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: "'' + params.event_update_status + ''".\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value == 0) {' || chr(13) || chr(10) || '        params.event_nseverity = ''6'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (!SEVERITY_COLORS[params.event_nseverity]) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_nseverity" parameter given: '' + params.event_nseverity + ''\nMust be 0-5.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var color = parseInt(SEVERITY_COLORS[params.event_nseverity].replace(''#'', ''''), 16),' || chr(13) || chr(10) || '        fields = [],' || chr(13) || chr(10) || '        body = {' || chr(13) || chr(10) || '            embeds: [' || chr(13) || chr(10) || '                {' || chr(13) || chr(10) || '                    color: color || 0,' || chr(13) || chr(10) || '')||
TO_NCLOB('                    url: (params.event_source === ''0'')' || chr(13) || chr(10) || '                        ? params.zabbix_url + ''/tr_events.php?triggerid='' + params.trigger_id +' || chr(13) || chr(10) || '                            ''&eventid='' + params.event_id' || chr(13) || chr(10) || '                        : params.zabbix_url' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            ]' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Default message from {ALERT.MESSAGE}.' || chr(13) || chr(10) || '    if (params.use_default_message.toLowerCase() == ''true'') {' || chr(13) || chr(10) || '        body.embeds[0].title = stringTruncate(params.alert_subject, 256);' || chr(13) || chr(10) || '        body.embeds[0].description = stringTruncate(params.alert_message, 2048);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        fields.push(' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                name: ''Host'',' || chr(13) || chr(10) || '                value: params.host_name + '' ['' + params.host_ip + '']''' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        );' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        // Resolved message.' || chr(13) || chr(10) || '        if (params.event_value == 0 && params.event_update_status == 0) {' || chr(13) || chr(10) || '            body.embeds[0].title = stringTruncate(''OK: '' + params.event_name, 256);' || chr(13) || chr(10) || '            fields.push(' || chr(13) || chr(10) || '                {' || chr(13) || chr(10) || '                    name: ''Recovery time'',' || chr(13) || chr(10) || '                    value: params.event_recovery_time + '' '' + params.event_recovery_date,' || chr(13) || chr(10) || '                    inline: ''True''' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            );' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('        // Problem message.' || chr(13) || chr(10) || '        else if (params.event_value == 1 && params.event_update_status == 0) {' || chr(13) || chr(10) || '            body.embeds[0].title = stringTruncate(''PROBLEM: '' + params.event_name, 256);' || chr(13) || chr(10) || '            fields.push(' || chr(13) || chr(10) || '                {' || chr(13) || chr(10) || '                    name: ''Event time'',' || chr(13) || chr(10) || '                    value: params.event_time + '' '' + params.event_date,' || chr(13) || chr(10) || '                    inline: ''True''' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            );' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        // Update message.' || chr(13) || chr(10) || '        else if (params.event_update_status == 1) {' || chr(13) || chr(10) || '            body.embeds[0].title = stringTruncate(''UPDATE: '' + params.event_name, 256);' || chr(13) || chr(10) || '            body.embeds[0].description = params.event_update_user + '' '' + params.event_update_action + ''.'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (params.event_update_message) {' || chr(13) || chr(10) || '                body.embeds[0].description += '' Comment:\n>>> '' + params.event_update_message;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            body.embeds[0].description = stringTruncate(body.embeds[0].description, 2048);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            fields.push(' || chr(13) || chr(10) || '                {' || chr(13) || chr(10) || '                    name: ''Event update time'',' || chr(13) || chr(10) || '                    value: params.event_update_time + '' '' + params.event_update_date,' || chr(13) || chr(10) || '                    inline: ''True''' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            );' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '        fields.push(' || chr(13) || chr(10) || '            {' || chr(13) || chr(10) || '                name: ''Severity'',' || chr(13) || chr(10) || '                value: params.event_severity,' || chr(13) || chr(10) || '                inline: ''True''' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        );' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (params.event_opdata) {' || chr(13) || chr(10) || '            fields.push(' || chr(13) || chr(10) || '                {' || chr(13) || chr(10) || '                    name: ''Operational data'',' || chr(13) || chr(10) || '                    value: stringTruncate(params.event_opdata, 1024),' || chr(13) || chr(10) || '                    inline: ''True''' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            );' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (params.event_value == 1 && params.event_update_status == 0 && params.trigger_description) {' || chr(13) || chr(10) || '            fields.push(' || chr(13) || chr(10) || '                {' || chr(13) || chr(10) || '                    name: ''Trigger description'',' || chr(13) || chr(10) || '                    value: stringTruncate(params.trigger_description, 1024)' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            );' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        body.embeds[0].footer = {' || chr(13) || chr(10) || '            text: ''Event ID: '' + params.event_id' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (params.event_tags) {' || chr(13) || chr(10) || '            body.embeds[0].footer.text += ''\nEvent tags: '' + params.event_tags;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        body.embeds[0].footer.text = stringTruncate(body.embeds[0].footer.text, 2048);' || chr(13) || chr(10) || '')||
TO_NCLOB('    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (fields.length > 0) {' || chr(13) || chr(10) || '        body.embeds[0].fields = fields;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var req = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.HTTPProxy === ''string'' && params.HTTPProxy.trim() !== '''') {' || chr(13) || chr(10) || '        req.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    req.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var resp = req.post(params.discord_endpoint, JSON.stringify(body)),' || chr(13) || chr(10) || '        data = JSON.parse(resp);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Zabbix.log(4, ''[ Discord Webhook ] JSON: '' + JSON.stringify(body));' || chr(13) || chr(10) || '    Zabbix.log(4, ''[ Discord Webhook ] Response: '' + resp);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (data.id) {' || chr(13) || chr(10) || '        return resp;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        var message = ((typeof data.message === ''string'') ? data.message : ''Unknown error'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(3, ''[ Discord Webhook ] FAILED with response: '' + resp);' || chr(13) || chr(10) || '        throw message + ''. For more details check zabbix server log.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ Discord Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','0','0','','','')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description)
values ('11','4','SIGNL4','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',TO_NCLOB('// SIGNL4 Webhook' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var response,' || chr(13) || chr(10) || '        payload,' || chr(13) || chr(10) || '        params = JSON.parse(value),' || chr(13) || chr(10) || '        endpoint = ''https://connect.signl4.com/webhook/'',' || chr(13) || chr(10) || '        request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.HTTPProxy === ''string'' && params.HTTPProxy.trim() !== '''') {' || chr(13) || chr(10) || '        request.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.teamsecret === ''string'' && params.teamsecret.trim() !== '''') {' || chr(13) || chr(10) || '        endpoint += params.teamsecret;' || chr(13) || chr(10) || '        delete params.teamsecret;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        throw ''The team secret of your SIGNL4 team cannot be empty.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.Severity === ''string'' && params.Severity === ''{EVENT.SEVERITY}'') {' || chr(13) || chr(10) || '        params.Severity = ''Not classified'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'if (typeof params.User === ''string'' && params.User === ''{USER.FULLNAME}'') {' || chr(13) || chr(10) || '        params.User = '''';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'if (typeof params.Event_Update_Action === ''string'' && params.Event_Update_Action === ''{EVENT.UPDATE.ACTION}'') {' || chr(13) || chr(10) || '        params.Event_Update_Action = '''';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '// Assemble X-S4-ExternalID for two-way integration' || chr(13) || chr(10) || '')||
TO_NCLOB('// Format: "ZabbixEventID: 222 ZabbixURL: https://your-zabbix-server/zabbix/"' || chr(13) || chr(10) || 'params[''X-S4-ExternalID''] = ''ZabbixEventID: '' + params.Event_ID;' || chr(13) || chr(10) || 'if (typeof params.Zabbix_URL === ''string'' && params.Zabbix_URL.indexOf(''http'') == 0) {' || chr(13) || chr(10) || '// Make sure the URL ends with ''/''' || chr(13) || chr(10) || 'if (params.Zabbix_URL.charAt(params.Zabbix_URL.length - 1) != ''/'') {' || chr(13) || chr(10) || 'params.Zabbix_URL = params.Zabbix_URL + ''/'';' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'params[''X-S4-ExternalID''] = params[''X-S4-ExternalID''] + '' ZabbixURL: '' +  params.Zabbix_URL;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '// Add Link parameter' || chr(13) || chr(10) || 'params[''Link''] = params.Zabbix_URL + "tr_events.php?triggerid="+params.Trigger_ID + "&eventid=" + params.Event_ID;' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '// Check if this is a new problem or a recovery' || chr(13) || chr(10) || 'if (params.Trigger_Status == ''OK'') {' || chr(13) || chr(10) || 'params[''X-S4-Status''] = ''resolved'';' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'else {' || chr(13) || chr(10) || 'params[''X-S4-Status''] = ''new'';' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    payload = JSON.stringify(params);' || chr(13) || chr(10) || '    Zabbix.log(4, ''[ SIGNL4 Webhook ] Sending request: '' + payload);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '    response = request.post(endpoint, ''payload='' + payload);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Zabbix.log(4, ''[ SIGNL4 Webhook ] Received response with status code '' +' || chr(13) || chr(10) || '            request.getStatus() + ''\n'' + response' || chr(13) || chr(10) || '    );' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (request.getStatus() !== 201) {' || chr(13) || chr(10) || '')||
TO_NCLOB('        throw ''Request failed with status code '' + request.getStatus() +' || chr(13) || chr(10) || '                ''. Check debug log for more information.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return ''OK'';' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(4, ''[ SIGNL4 Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','0','0','','','SIGNL4 is a mobile alert notification app for powerful alerting, alert management and mobile assignment of work items. It offers alerting via app push, SMS and voice calls including escalations, tracking, and duty scheduling.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Get the app at https://www.signl4.com.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Find out more including an integration video here: https://www.signl4.com/blog/portfolio_item/zabbix-mobile-alert-notification-duty-schedule-escalation/')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description)
values ('12','4','Jira','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',TO_NCLOB('var Jira = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Jira.params = params;' || chr(13) || chr(10) || '        if (typeof Jira.params.url === ''string'') {' || chr(13) || chr(10) || '            if (!Jira.params.url.endsWith(''/'')) {' || chr(13) || chr(10) || '                Jira.params.url += ''/'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            Jira.params.url += ''rest/api/latest/'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setProxy: function (HTTPProxy) {' || chr(13) || chr(10) || '        Jira.HTTPProxy = HTTPProxy;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setTags: function(event_tags_json) {' || chr(13) || chr(10) || '        if (typeof event_tags_json !== ''undefined'' && event_tags_json !== ''''' || chr(13) || chr(10) || '            && event_tags_json !== ''{EVENT.TAGSJSON}'') {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                var tags = JSON.parse(event_tags_json),' || chr(13) || chr(10) || '                    label;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                Jira.labels = [];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                tags.forEach(function (tag) {' || chr(13) || chr(10) || '                    if (typeof tag.tag !== ''undefined'' && typeof tag.value !== ''undefined''' || chr(13) || chr(10) || '                        && !tag.tag.startsWith(''__zbx'')) {' || chr(13) || chr(10) || '')||
TO_NCLOB('                        label = (tag.tag + (tag.value ? ('':'' + tag.value) : '''')).replace(/\s/g, ''_'');' || chr(13) || chr(10) || '                        if (label.length < 256) {' || chr(13) || chr(10) || '                            Jira.labels.push(label);' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '                    }' || chr(13) || chr(10) || '                });' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                // Code is not missing here.' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    escapeMarkup: function (str) {' || chr(13) || chr(10) || '        var length = str.length,' || chr(13) || chr(10) || '            result = '''',' || chr(13) || chr(10) || '            markup = [''{'', ''|'', ''}'', ''~'', ''_'', ''\\'', ''['', '']'', ''^'', ''<'', ''>'', ''?'', ''!'', ''#'', ''+'', ''*'', ''&''];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        for (var i = 0; i < length; i++) {' || chr(13) || chr(10) || '            var char = str[i];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            result += (markup.indexOf(char) !== -1) ? (''&#'' + str[i].charCodeAt() + '';'') : char;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return result;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    addCustomFields: function (data, fields) {' || chr(13) || chr(10) || '        if (typeof fields === ''object'' && Object.keys(fields).length) {' || chr(13) || chr(10) || '            var schema = Jira.getSchema(),' || chr(13) || chr(10) || '                path = [''projects'', 0, ''issuetypes'', 0, ''fields''],' || chr(13) || chr(10) || '                field;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            while ((field = path.shift()) !== undefined) {' || chr(13) || chr(10) || '                schema = schema[field];' || chr(13) || chr(10) || '')||
TO_NCLOB('                if (typeof schema === ''undefined'') {' || chr(13) || chr(10) || '                    schema = null;' || chr(13) || chr(10) || '                    break;' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (schema) {' || chr(13) || chr(10) || '                Object.keys(fields)' || chr(13) || chr(10) || '                    .forEach(function(field) {' || chr(13) || chr(10) || '                        if (typeof schema[field] === ''object'' && typeof schema[field].schema === ''object'') {' || chr(13) || chr(10) || '                            switch (schema[field].schema.type) {' || chr(13) || chr(10) || '                                case ''number'':' || chr(13) || chr(10) || '                                    data.fields[field] = parseInt(fields[field]);' || chr(13) || chr(10) || '                                    break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                                case ''datetime'':' || chr(13) || chr(10) || '                                    if (fields[field].match(/\d+[.-]\d+[.-]\d+T\d+:\d+:\d+/) !== null) {' || chr(13) || chr(10) || '                                        data.fields[field] = fields[field].replace(/\./g, ''-'');' || chr(13) || chr(10) || '                                    }' || chr(13) || chr(10) || '                                    break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                                case ''option'':' || chr(13) || chr(10) || '                                    data.fields[field] = {value: fields[field]};' || chr(13) || chr(10) || '                                    break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                                case ''array'':' || chr(13) || chr(10) || '                                    if (schema[field].schema.items === ''option'') {' || chr(13) || chr(10) || '')||
TO_NCLOB('                                        data.fields[field] = [{value: fields[field]}];' || chr(13) || chr(10) || '                                    }' || chr(13) || chr(10) || '                                    else {' || chr(13) || chr(10) || '                                        data.fields[field] = [fields[field]];' || chr(13) || chr(10) || '                                    }' || chr(13) || chr(10) || '                                    break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                                default:' || chr(13) || chr(10) || '                                    data.fields[field] = fields[field];' || chr(13) || chr(10) || '                            }' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '                    });' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ Jira Webhook ] Failed to retrieve field schema.'');' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return data;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (method, query, data) {' || chr(13) || chr(10) || '        [''url'', ''user'', ''password'', ''project_key'', ''issue_type''].forEach(function (field) {' || chr(13) || chr(10) || '            if (typeof Jira.params !== ''object'' || typeof Jira.params[field] === ''undefined''' || chr(13) || chr(10) || '                || Jira.params[field] === '''' ) {' || chr(13) || chr(10) || '                throw ''Required Jira param is not set: "'' + field + ''".'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            url = Jira.params.url + query,' || chr(13) || chr(10) || '            request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '        request.addHeader(''Authorization: Basic '' + btoa(Jira.params.user + '':'' + Jira.params.password));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof Jira.HTTPProxy !== ''undefined'' && Jira.HTTPProxy !== '''') {' || chr(13) || chr(10) || '            request.setProxy(Jira.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ Jira Webhook ] Sending request: '' + url + ((typeof data === ''string'') ? (''\n'' + data) : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (method) {' || chr(13) || chr(10) || '            case ''get'':' || chr(13) || chr(10) || '                response = request.get(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''post'':' || chr(13) || chr(10) || '                response = request.post(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''put'':' || chr(13) || chr(10) || '                response = request.put(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                throw ''Unsupported HTTP request method: '' + method;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ Jira Webhook ] Received response with status code '' + request.getStatus() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '')||
TO_NCLOB('                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ Jira Webhook ] Failed to parse response received from Jira'');' || chr(13) || chr(10) || '                response = null;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() < 200 || request.getStatus() >= 300) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (response !== null && typeof response.errors !== ''undefined''' || chr(13) || chr(10) || '                && Object.keys(response.errors).length > 0) {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.errors);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (response !== null && typeof response.errorMessages !== ''undefined''' || chr(13) || chr(10) || '                && Object.keys(response.errorMessages).length > 0) {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.errorMessages);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            throw message + '' Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return {' || chr(13) || chr(10) || '            status: request.getStatus(),' || chr(13) || chr(10) || '            response: response' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    getSchema: function() {' || chr(13) || chr(10) || '        var result = Jira.request(''get'', ''issue/createmeta?expand=projects.issuetypes.fields&projectKeys='' +' || chr(13) || chr(10) || '')||
TO_NCLOB('            encodeURIComponent(Jira.params.project_key) + ''&issuetypeNames='' +' || chr(13) || chr(10) || '            encodeURIComponent(Jira.params.issue_type));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return result.response;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    createIssue: function(summary, description, fields) {' || chr(13) || chr(10) || '        var data = {' || chr(13) || chr(10) || '            fields: {' || chr(13) || chr(10) || '                project: {' || chr(13) || chr(10) || '                    key: Jira.params.project_key' || chr(13) || chr(10) || '                },' || chr(13) || chr(10) || '                issuetype: {' || chr(13) || chr(10) || '                    name: Jira.params.issue_type' || chr(13) || chr(10) || '                },' || chr(13) || chr(10) || '                summary: summary,' || chr(13) || chr(10) || '                description: description' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (Jira.labels && Jira.labels.length > 0) {' || chr(13) || chr(10) || '            data.fields.labels = Jira.labels;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        var result = Jira.request(''post'', ''issue'', Jira.addCustomFields(data, fields));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof result.response !== ''object'' || typeof result.response.key === ''undefined'') {' || chr(13) || chr(10) || '            throw ''Cannot create Jira issue. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return result.response.key;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    updateIssue: function(summary, fields, update) {' || chr(13) || chr(10) || '        var data = {fields: {}};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('        if (summary) {' || chr(13) || chr(10) || '            data.fields.summary = summary;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Jira.request(''put'', ''issue/'' + encodeURIComponent(Jira.params.issue_key), Jira.addCustomFields(data, fields));' || chr(13) || chr(10) || '        Jira.commentIssue(update);' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    commentIssue: function(update) {' || chr(13) || chr(10) || '        var data = {};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof update === ''string'') {' || chr(13) || chr(10) || '            data.body = update;' || chr(13) || chr(10) || '            Jira.request(''post'', ''issue/'' + encodeURIComponent(Jira.params.issue_key) + ''/comment'', data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else if (update.status === ''1'') {' || chr(13) || chr(10) || '            data.body = update.user + '' '' + update.action + ''.'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (update.message) {' || chr(13) || chr(10) || '                data.body += ''\nMessage: {quote}'' + Jira.escapeMarkup(update.message) + ''{quote}'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            Jira.request(''post'', ''issue/'' + encodeURIComponent(Jira.params.issue_key) + ''/comment'', data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        fields = {},' || chr(13) || chr(10) || '        jira = {},' || chr(13) || chr(10) || '        update = {},' || chr(13) || chr(10) || '        result = {tags: {}},' || chr(13) || chr(10) || '')||
TO_NCLOB('        required_params = [''alert_subject'', ''summary'', ''event_recovery_value'', ''event_source'', ''event_value''];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (key.startsWith(''jira_'')) {' || chr(13) || chr(10) || '                jira[key.substring(5)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''customfield_'')) {' || chr(13) || chr(10) || '                fields[key] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''event_update_'')) {' || chr(13) || chr(10) || '                update[key.substring(13)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (required_params.indexOf(key) !== -1 && params[key] === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" can\''t be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '')||
TO_NCLOB('    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'' && params.event_source === ''0'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_recovery_value === ''0'') {' || chr(13) || chr(10) || '        throw ''Recovery operations are supported only for trigger-based actions.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Jira.setParams(jira);' || chr(13) || chr(10) || '    Jira.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    Jira.setTags(params.event_tags_json);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Create issue for non trigger-based events.' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_recovery_value !== ''0'') {' || chr(13) || chr(10) || '        Jira.createIssue(params.alert_subject, params.alert_message);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Create issue for trigger-based events.' || chr(13) || chr(10) || '    else if (params.event_value === ''1'' && update.status === ''0'' && !jira.issue_key.startsWith(jira.project_key)) {' || chr(13) || chr(10) || '        var key = Jira.createIssue(params.alert_subject,' || chr(13) || chr(10) || '            (Object.keys(fields).length ? params.trigger_description : params.alert_message), fields);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result.tags.__zbx_jira_issuekey = key;' || chr(13) || chr(10) || '        result.tags.__zbx_jira_issuelink = params.jira_url +' || chr(13) || chr(10) || '            (params.jira_url.endsWith(''/'') ? '''' : ''/'') + ''browse/'' + key;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Update created issue for trigger-based event.' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '')||
TO_NCLOB('        if (!jira.issue_key.startsWith(jira.project_key)) {' || chr(13) || chr(10) || '            throw ''Incorrect Issue key given: '' + jira.issue_key;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        Jira.updateIssue(params.alert_subject, fields,' || chr(13) || chr(10) || '            ((params.event_value === ''0'' && !Object.keys(fields).length)' || chr(13) || chr(10) || '                ? params.alert_message : update));' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return JSON.stringify(result);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ Jira Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_jira_issuelink}','Jira: {EVENT.TAGS.__zbx_jira_issuekey}','')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description)
values ('13','4','Jira with CustomFields','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',TO_NCLOB('var Jira = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Jira.params = params;' || chr(13) || chr(10) || '        if (typeof Jira.params.url === ''string'') {' || chr(13) || chr(10) || '            if (!Jira.params.url.endsWith(''/'')) {' || chr(13) || chr(10) || '                Jira.params.url += ''/'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            Jira.params.url += ''rest/api/latest/'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setProxy: function (HTTPProxy) {' || chr(13) || chr(10) || '        Jira.HTTPProxy = HTTPProxy;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setTags: function(event_tags_json) {' || chr(13) || chr(10) || '        if (typeof event_tags_json !== ''undefined'' && event_tags_json !== ''''' || chr(13) || chr(10) || '            && event_tags_json !== ''{EVENT.TAGSJSON}'') {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                var tags = JSON.parse(event_tags_json),' || chr(13) || chr(10) || '                    label;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                Jira.labels = [];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                tags.forEach(function (tag) {' || chr(13) || chr(10) || '                    if (typeof tag.tag !== ''undefined'' && typeof tag.value !== ''undefined'' ) {' || chr(13) || chr(10) || '                        label = (tag.tag + (tag.value ? ('':'' + tag.value) : '''')).replace(/\s/g, ''_'');' || chr(13) || chr(10) || '')||
TO_NCLOB('                        if (label.length < 256) {' || chr(13) || chr(10) || '                            Jira.labels.push(label);' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '                    }' || chr(13) || chr(10) || '                });' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                // Code is not missing here.' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    escapeMarkup: function (str) {' || chr(13) || chr(10) || '        var length = str.length,' || chr(13) || chr(10) || '            result = '''',' || chr(13) || chr(10) || '            markup = [''{'', ''|'', ''}'', ''~'', ''_'', ''\\'', ''['', '']'', ''^'', ''<'', ''>'', ''?'', ''!'', ''#'', ''+'', ''*'', ''&''];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        for (var i = 0; i < length; i++) {' || chr(13) || chr(10) || '            var char = str[i];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            result += (markup.indexOf(char) !== -1) ? (''&#'' + str[i].charCodeAt() + '';'') : char;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return result;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    addCustomFields: function (data, fields) {' || chr(13) || chr(10) || '        if (typeof fields === ''object'' && Object.keys(fields).length) {' || chr(13) || chr(10) || '            var schema = Jira.getSchema(),' || chr(13) || chr(10) || '                path = [''projects'', 0, ''issuetypes'', 0, ''fields''],' || chr(13) || chr(10) || '                field;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            while ((field = path.shift()) !== undefined) {' || chr(13) || chr(10) || '                schema = schema[field];' || chr(13) || chr(10) || '                if (typeof schema === ''undefined'') {' || chr(13) || chr(10) || '')||
TO_NCLOB('                    schema = null;' || chr(13) || chr(10) || '                    break;' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (schema) {' || chr(13) || chr(10) || '                Object.keys(fields)' || chr(13) || chr(10) || '                    .forEach(function(field) {' || chr(13) || chr(10) || '                        data.fields[field] = fields[field];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                        if (typeof schema[field] === ''object'' && typeof schema[field].schema === ''object''' || chr(13) || chr(10) || '                            && (schema[field].schema.type === ''number'' || schema[field].schema.type === ''datetime'')) {' || chr(13) || chr(10) || '                            switch (schema[field].schema.type) {' || chr(13) || chr(10) || '                                case ''number'':' || chr(13) || chr(10) || '                                    data.fields[field] = parseInt(fields[field]);' || chr(13) || chr(10) || '                                    break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                                case ''datetime'':' || chr(13) || chr(10) || '                                    if (fields[field].match(/\d+[.-]\d+[.-]\d+T\d+:\d+:\d+/) !== null) {' || chr(13) || chr(10) || '                                        data.fields[field] = fields[field].replace(/\./g, ''-'');' || chr(13) || chr(10) || '                                    }' || chr(13) || chr(10) || '                                    else {' || chr(13) || chr(10) || '                                        delete data.fields[field];' || chr(13) || chr(10) || '                                    }' || chr(13) || chr(10) || '                                    break;' || chr(13) || chr(10) || '                            }' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '                    });' || chr(13) || chr(10) || '')||
TO_NCLOB('            }' || chr(13) || chr(10) || '            else {' || chr(13) || chr(10) || '                Zabbix.Log(4, ''[ Jira Webhook ] Failed to retrieve field schema.'');' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return data;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (method, query, data) {' || chr(13) || chr(10) || '        [''url'', ''user'', ''password'', ''project_key'', ''issue_type''].forEach(function (field) {' || chr(13) || chr(10) || '            if (typeof Jira.params !== ''object'' || typeof Jira.params[field] === ''undefined''' || chr(13) || chr(10) || '                || Jira.params[field] === '''' ) {' || chr(13) || chr(10) || '                throw ''Required Jira param is not set: "'' + field + ''".'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            url = Jira.params.url + query,' || chr(13) || chr(10) || '            request = new CurlHttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.AddHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '        request.AddHeader(''Authorization: Basic '' + btoa(Jira.params.user + '':'' + Jira.params.password));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof Jira.HTTPProxy !== ''undefined'' && Jira.HTTPProxy !== '''') {' || chr(13) || chr(10) || '            request.SetProxy(Jira.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('        Zabbix.Log(4, ''[ Jira Webhook ] Sending request: '' + url + ((typeof data === ''string'') ? (''\n'' + data) : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (method) {' || chr(13) || chr(10) || '            case ''get'':' || chr(13) || chr(10) || '                response = request.Get(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''post'':' || chr(13) || chr(10) || '                response = request.Post(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''put'':' || chr(13) || chr(10) || '                response = request.Put(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                throw ''Unsupported HTTP request method: '' + method;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.Log(4, ''[ Jira Webhook ] Received response with status code '' + request.Status() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                Zabbix.Log(4, ''[ Jira Webhook ] Failed to parse response received from Jira'');' || chr(13) || chr(10) || '                response = null;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.Status() < 200 || request.Status() >= 300) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.Status();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('            if (response !== null && typeof response.errors !== ''undefined''' || chr(13) || chr(10) || '                && Object.keys(response.errors).length > 0) {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.errors);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (response !== null && typeof response.errorMessages !== ''undefined''' || chr(13) || chr(10) || '                && Object.keys(response.errorMessages).length > 0) {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.errorMessages);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            throw message + '' Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return {' || chr(13) || chr(10) || '            status: request.Status(),' || chr(13) || chr(10) || '            response: response' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    getSchema: function() {' || chr(13) || chr(10) || '        var result = Jira.request(''get'', ''issue/createmeta?expand=projects.issuetypes.fields&projectKeys='' +' || chr(13) || chr(10) || '                Jira.params.project_key + ''&issuetypeNames='' + Jira.params.issue_type);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return result.response;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    createIssue: function(summary, description, fields) {' || chr(13) || chr(10) || '        var data = {' || chr(13) || chr(10) || '            fields: {' || chr(13) || chr(10) || '                project: {' || chr(13) || chr(10) || '                    key: Jira.params.project_key' || chr(13) || chr(10) || '                },' || chr(13) || chr(10) || '                issuetype: {' || chr(13) || chr(10) || '                    name: Jira.params.issue_type' || chr(13) || chr(10) || '                },' || chr(13) || chr(10) || '')||
TO_NCLOB('                summary: summary,' || chr(13) || chr(10) || '                description: description' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (Jira.labels && Jira.labels.length > 0) {' || chr(13) || chr(10) || '            data.fields.labels = Jira.labels;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        var result = Jira.request(''post'', ''issue'', Jira.addCustomFields(data, fields));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof result.response !== ''object'' || typeof result.response.key === ''undefined'') {' || chr(13) || chr(10) || '            throw ''Cannot create Jira issue. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return result.response.key;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    updateIssue: function(summary, fields, update) {' || chr(13) || chr(10) || '        var data = {fields: {}};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (summary) {' || chr(13) || chr(10) || '            data.fields.summary = summary;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Jira.request(''put'', ''issue/'' + Jira.params.issue_key, Jira.addCustomFields(data, fields));' || chr(13) || chr(10) || '        Jira.commentIssue(update);' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    commentIssue: function(update) {' || chr(13) || chr(10) || '        var data = {};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof update === ''string'') {' || chr(13) || chr(10) || '            data.body = update;' || chr(13) || chr(10) || '            Jira.request(''post'', ''issue/'' + Jira.params.issue_key + ''/comment'', data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '')||
TO_NCLOB('        else if (update.status === ''1'') {' || chr(13) || chr(10) || '            data.body = update.user + '' '' + update.action + ''.'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (update.message) {' || chr(13) || chr(10) || '                data.body += ''\nMessage: {quote}'' + Jira.escapeMarkup(update.message) + ''{quote}'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            Jira.request(''post'', ''issue/'' + Jira.params.issue_key + ''/comment'', data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        fields = {},' || chr(13) || chr(10) || '        jira = {},' || chr(13) || chr(10) || '        update = {},' || chr(13) || chr(10) || '        result = {tags: {}},' || chr(13) || chr(10) || '        required_params = [''alert_subject'', ''summary'', ''event_recovery_value'', ''event_source'', ''event_value''];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (key.startsWith(''jira_'')) {' || chr(13) || chr(10) || '                jira[key.substring(5)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''customfield_'')) {' || chr(13) || chr(10) || '                fields[key] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''event_update_'')) {' || chr(13) || chr(10) || '                update[key.substring(13)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (required_params.indexOf(key) !== -1 && params[key] === '''') {' || chr(13) || chr(10) || '')||
TO_NCLOB('                throw ''Parameter "'' + key + ''" can\''t be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'' && params.event_source === ''0'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_recovery_value === ''0'') {' || chr(13) || chr(10) || '        throw ''Recovery operations are supported only for trigger-based actions.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Jira.setParams(jira);' || chr(13) || chr(10) || '    Jira.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    Jira.setTags(params.event_tags_json);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Create issue for non trigger-based events.' || chr(13) || chr(10) || '')||
TO_NCLOB('    if (params.event_source !== ''0'' && params.event_recovery_value !== ''0'') {' || chr(13) || chr(10) || '        Jira.createIssue(params.alert_subject, params.alert_message);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Create issue for trigger-based events.' || chr(13) || chr(10) || '    else if (params.event_value === ''1'' && update.status === ''0'' && !jira.issue_key.startsWith(jira.project_key)) {' || chr(13) || chr(10) || '        var key = Jira.createIssue(params.alert_subject,' || chr(13) || chr(10) || '            (Object.keys(fields).length ? params.trigger_description : params.alert_message), fields);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result.tags.__zbx_jira_issuekey = key;' || chr(13) || chr(10) || '        result.tags.__zbx_jira_issuelink = params.jira_url +' || chr(13) || chr(10) || '            (params.jira_url.endsWith(''/'') ? '''' : ''/'') + ''browse/'' + key;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Update created issue for trigger-based event.' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        if (!jira.issue_key.startsWith(jira.project_key)) {' || chr(13) || chr(10) || '            throw ''Incorrect Issue key given: '' + jira.issue_key;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        Jira.updateIssue(params.alert_subject, fields,' || chr(13) || chr(10) || '            ((params.event_value === ''0'' && !Object.keys(fields).length)' || chr(13) || chr(10) || '                ? params.alert_message : update));' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return JSON.stringify(result);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.Log(3, ''[ Jira Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_jira_issuelink}','Jira: {EVENT.TAGS.__zbx_jira_issuekey}','')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description)
values ('14','4','MS Teams','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',TO_NCLOB('var SEVERITY_COLORS = [' || chr(13) || chr(10) || '    ''#97AAB3'', // Not classified.' || chr(13) || chr(10) || '    ''#7499FF'', // Information.' || chr(13) || chr(10) || '    ''#FFC859'', // Warning.' || chr(13) || chr(10) || '    ''#FFA059'', // Average.' || chr(13) || chr(10) || '    ''#E97659'', // High.' || chr(13) || chr(10) || '    ''#E45959'', // Disaster.' || chr(13) || chr(10) || '    ''#009900'', // Resolved.' || chr(13) || chr(10) || '    ''#000000''  // Default.' || chr(13) || chr(10) || '];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.teams_endpoint !== ''string'' || params.teams_endpoint.trim() === '''') {' || chr(13) || chr(10) || '        throw ''Cannot get teams_endpoint'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else if (!params.teams_endpoint.startsWith(''http'')) {' || chr(13) || chr(10) || '        throw ''Invalid MS Teams webhook URL: '' + params.teams_endpoint;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    params.zabbix_url = (params.zabbix_url.endsWith(''/''))' || chr(13) || chr(10) || '        ? params.zabbix_url.slice(0, -1) : params.zabbix_url;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: "'' + params.event_source + ''".\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Set "use_default_message" to true for non trigger-based events.' || chr(13) || chr(10) || '    if (params.event_source !== ''0'') {' || chr(13) || chr(10) || '        params.use_default_message = ''true'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '            && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: "'' + params.event_value + ''".\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'' && params.event_source === ''0'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: "'' + params.event_update_status + ''".\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value == 0) {' || chr(13) || chr(10) || '        params.event_nseverity = ''6'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (!SEVERITY_COLORS[params.event_nseverity]) {' || chr(13) || chr(10) || '        params.event_nseverity = ''7'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var request = new HttpRequest(),' || chr(13) || chr(10) || '        facts = [],' || chr(13) || chr(10) || '        body = {' || chr(13) || chr(10) || '            themeColor: SEVERITY_COLORS[params.event_nseverity].replace(''#'', ''''),' || chr(13) || chr(10) || '            summary: params.alert_subject,' || chr(13) || chr(10) || '            sections: [' || chr(13) || chr(10) || '                {' || chr(13) || chr(10) || '                    markdown: ''false'',' || chr(13) || chr(10) || '                    activityTitle: params.alert_subject,' || chr(13) || chr(10) || '                    activitySubtitle: ''On '' + params.host_name + '' ['' + params.host_ip + '']'',' || chr(13) || chr(10) || '')||
TO_NCLOB('                    text: (params.use_default_message.toLowerCase() == ''true'')' || chr(13) || chr(10) || '                        ? params.alert_message' || chr(13) || chr(10) || '                        : params.trigger_description' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            ],' || chr(13) || chr(10) || '            potentialAction: [' || chr(13) || chr(10) || '                {' || chr(13) || chr(10) || '                    ''@type'': ''OpenUri'',' || chr(13) || chr(10) || '                    name: (params.event_source === ''0'')' || chr(13) || chr(10) || '                        ? ''Event Info''' || chr(13) || chr(10) || '                        : ''Zabbix Home'',' || chr(13) || chr(10) || '                    targets: [' || chr(13) || chr(10) || '                        {' || chr(13) || chr(10) || '                            os: ''default'',' || chr(13) || chr(10) || '                            uri: (params.event_source === ''0'')' || chr(13) || chr(10) || '                                ? params.zabbix_url + ''/tr_events.php?triggerid='' +' || chr(13) || chr(10) || '                                    params.trigger_id + ''&eventid='' + params.event_id' || chr(13) || chr(10) || '                                : params.zabbix_url' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '                    ]' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            ]' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.use_default_message.toLowerCase() !== ''true'') {' || chr(13) || chr(10) || '        // Problem message.' || chr(13) || chr(10) || '        if (params.event_value === ''1'' && params.event_update_status === ''0'') {' || chr(13) || chr(10) || '            facts.push({' || chr(13) || chr(10) || '                name: ''Event time'',' || chr(13) || chr(10) || '                value: params.event_time + '' '' + params.event_date' || chr(13) || chr(10) || '            });' || chr(13) || chr(10) || '')||
TO_NCLOB('        }' || chr(13) || chr(10) || '        // Update message.' || chr(13) || chr(10) || '        else if (params.event_update_status === ''1'') {' || chr(13) || chr(10) || '            body.sections[0].text = params.event_update_user + '' '' + params.event_update_action + ''.'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (params.event_update_message) {' || chr(13) || chr(10) || '                body.sections[0].text += ''<br>Message:<br>'' + params.event_update_message;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            facts.push({' || chr(13) || chr(10) || '                name: ''Event update time'',' || chr(13) || chr(10) || '                value: params.event_update_time + '' '' + params.event_update_date' || chr(13) || chr(10) || '            });' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        // Resolved message.' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            facts.push({' || chr(13) || chr(10) || '                name: ''Recovery time'',' || chr(13) || chr(10) || '                value: params.event_recovery_time + '' '' + params.event_recovery_date' || chr(13) || chr(10) || '            });' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (params.event_severity && params.event_severity !== ''{EVENT.SEVERITY}'') {' || chr(13) || chr(10) || '            facts.push({' || chr(13) || chr(10) || '                name: ''Severity'',' || chr(13) || chr(10) || '                value: params.event_severity' || chr(13) || chr(10) || '            });' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (params.event_opdata && params.event_opdata !== ''{EVENT.OPDATA}'') {' || chr(13) || chr(10) || '            facts.push({' || chr(13) || chr(10) || '                name: ''Operational data'',' || chr(13) || chr(10) || '')||
TO_NCLOB('                value: params.event_opdata' || chr(13) || chr(10) || '            });' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (params.event_tags && params.event_tags !== ''{EVENT.TAGS}'') {' || chr(13) || chr(10) || '            facts.push({' || chr(13) || chr(10) || '                name: ''Event tags'',' || chr(13) || chr(10) || '                value: params.event_tags' || chr(13) || chr(10) || '            });' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Object.keys(params)' || chr(13) || chr(10) || '            .forEach(function (key) {' || chr(13) || chr(10) || '                if (key.startsWith(''fact_'') && params[key] !== '''') {' || chr(13) || chr(10) || '                    facts.push({' || chr(13) || chr(10) || '                        name: key.substring(5),' || chr(13) || chr(10) || '                        value: params[key]' || chr(13) || chr(10) || '                    });' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '                else if (key.startsWith(''openUri_'') && params[key] !== '''' && !params[key].startsWith(''{'')) {' || chr(13) || chr(10) || '                    body.potentialAction.push({' || chr(13) || chr(10) || '                        ''@type'': ''OpenUri'',' || chr(13) || chr(10) || '                        name: key.substring(8),' || chr(13) || chr(10) || '                        targets: [' || chr(13) || chr(10) || '                            {' || chr(13) || chr(10) || '                                os: ''default'',' || chr(13) || chr(10) || '                                uri: params[key]' || chr(13) || chr(10) || '                            }' || chr(13) || chr(10) || '                        ]' || chr(13) || chr(10) || '                    });' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            });' || chr(13) || chr(10) || '        body.sections[0].facts = facts;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '    body.sections[0].text = body.sections[0].text.replace(/(?:\r\n|\r|\n)/g, ''<br>'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.HTTPProxy === ''string'' && params.HTTPProxy !== '''') {' || chr(13) || chr(10) || '        request.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Zabbix.log(4, ''[ MS Teams Webhook ] JSON: '' + JSON.stringify(body));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var response = request.post(params.teams_endpoint, JSON.stringify(body));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Zabbix.log(4, ''[ MS Teams Webhook ] Response: '' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (response === ''1'') {' || chr(13) || chr(10) || '        return ''OK'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ MS Teams Webhook ] FAILED with response: '' + response);' || chr(13) || chr(10) || '        throw response;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ MS Teams Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','0','0','','','')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description)
values ('15','4','Redmine','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',TO_NCLOB('var Redmine = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Redmine.params = params;' || chr(13) || chr(10) || '        if (typeof Redmine.params.url === ''string'') {' || chr(13) || chr(10) || '            if (!Redmine.params.url.endsWith(''/'')) {' || chr(13) || chr(10) || '                Redmine.params.url += ''/'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    addCustomFields: function (data, fields) {' || chr(13) || chr(10) || '        if (typeof fields === ''object'' && Object.keys(fields).length) {' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            data.issue.custom_fields = [];' || chr(13) || chr(10) || '            Object.keys(fields)' || chr(13) || chr(10) || '                .forEach(function (field) {' || chr(13) || chr(10) || '                    var field_value = fields[field];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                    if (field_value !== undefined) {' || chr(13) || chr(10) || '                        data.issue.custom_fields.push({ id: field, value: field_value });' || chr(13) || chr(10) || '                    }' || chr(13) || chr(10) || '                });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        return data;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (method, query, data) {' || chr(13) || chr(10) || '        [''url'', ''access_key''].forEach(function (field) {' || chr(13) || chr(10) || '')||
TO_NCLOB('            if (typeof Redmine.params !== ''object'' || typeof Redmine.params[field] === ''undefined''' || chr(13) || chr(10) || '                || Redmine.params[field] === '''' ) {' || chr(13) || chr(10) || '                throw ''Required param is not set: "'' + field + ''".'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            url = Redmine.params.url + query,' || chr(13) || chr(10) || '            request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof Redmine.HTTPProxy === ''string'' && Redmine.HTTPProxy.trim() !== '''') {' || chr(13) || chr(10) || '            request.setProxy(Redmine.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '        request.addHeader(''X-Redmine-API-Key: '' + Redmine.params.access_key);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ Redmine Webhook ] Sending request: '' +' || chr(13) || chr(10) || '            url + ((typeof data === ''string'') ? ('' '' + data) : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (method) {' || chr(13) || chr(10) || '            case ''get'':' || chr(13) || chr(10) || '                response = request.get(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''post'':' || chr(13) || chr(10) || '                response = request.post(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''put'':' || chr(13) || chr(10) || '                response = request.put(url, data);' || chr(13) || chr(10) || '')||
TO_NCLOB('                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                throw ''Unsupported HTTP request method: '' + method;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ Redmine Webhook ] Received response with status code '' + request.getStatus() + '': '' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ Redmine Webhook ] Failed to parse response received from Redmine'');' || chr(13) || chr(10) || '                response = null;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() < 200 || request.getStatus() >= 300) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (response !== null && typeof response.errors !== ''undefined''' || chr(13) || chr(10) || '                && Object.keys(response.errors).length > 0) {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.errors);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (response !== null && typeof response.errorMessages !== ''undefined''' || chr(13) || chr(10) || '                && Object.keys(response.errorMessages).length > 0) {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.errorMessages);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('            throw message + '' Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return {' || chr(13) || chr(10) || '            status: request.getStatus(),' || chr(13) || chr(10) || '            response: response' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    getProjectID: function(name) {' || chr(13) || chr(10) || '        var result = Redmine.request(''get'', ''projects.json''),' || chr(13) || chr(10) || '            project_id;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (result.response) {' || chr(13) || chr(10) || '            var projects = result.response.projects || [];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            for (var i in projects) {' || chr(13) || chr(10) || '                if (projects[i].name === name) {' || chr(13) || chr(10) || '                    project_id = projects[i].id;' || chr(13) || chr(10) || '                    break;' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            Zabbix.log(4, ''[ Redmine Webhook ] Failed to retrieve project data.'');' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof project_id === ''undefined'') {' || chr(13) || chr(10) || '            throw ''Cannot find project with name: '' + name;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return project_id;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    createIssue: function(subject, description, priority, fields) {' || chr(13) || chr(10) || '        var project_id = /^\d+$/.test(Redmine.params.project)' || chr(13) || chr(10) || '                ? Redmine.params.project' || chr(13) || chr(10) || '')||
TO_NCLOB('                : Redmine.getProjectID(Redmine.params.project),' || chr(13) || chr(10) || '            data = {' || chr(13) || chr(10) || '                issue: {' || chr(13) || chr(10) || '                    project_id: project_id,' || chr(13) || chr(10) || '                    tracker_id: Redmine.params.tracker_id,' || chr(13) || chr(10) || '                    subject: subject,' || chr(13) || chr(10) || '                    description: description' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            },' || chr(13) || chr(10) || '            result;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (priority) {' || chr(13) || chr(10) || '            data.issue.priority_id = priority;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result = Redmine.request(''post'', ''issues.json'', Redmine.addCustomFields(data, fields));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof result.response !== ''object''' || chr(13) || chr(10) || '            || typeof result.response.issue.id === ''undefined''' || chr(13) || chr(10) || '            || result.status != 201) {' || chr(13) || chr(10) || '            throw ''Cannot create Redmine issue. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return result.response.issue.id;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    updateIssue: function (note, fields, status) {' || chr(13) || chr(10) || '        var data = {' || chr(13) || chr(10) || '            issue: {' || chr(13) || chr(10) || '                notes: note || ''''' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (status) {' || chr(13) || chr(10) || '            data.issue.status_id = status;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('        Redmine.request(''put'', ''issues/'' + Redmine.params.issue_key + ''.json'', Redmine.addCustomFields(data, fields));' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        params_redmine = {},' || chr(13) || chr(10) || '        params_fields = {},' || chr(13) || chr(10) || '        params_update = {},' || chr(13) || chr(10) || '        result = {tags: {}},' || chr(13) || chr(10) || '        required_params = [' || chr(13) || chr(10) || '            ''alert_subject'', ''tracker_id'', ''project'',' || chr(13) || chr(10) || '            ''event_source'', ''event_value'',  ''event_update_status''' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        severities = [' || chr(13) || chr(10) || '            {name: ''not_classified'', color: ''#97AAB3''},' || chr(13) || chr(10) || '            {name: ''information'', color: ''#7499FF''},' || chr(13) || chr(10) || '            {name: ''warning'', color: ''#FFC859''},' || chr(13) || chr(10) || '            {name: ''average'', color: ''#FFA059''},' || chr(13) || chr(10) || '            {name: ''high'', color: ''#E97659''},' || chr(13) || chr(10) || '            {name: ''disaster'', color: ''#E45959''},' || chr(13) || chr(10) || '            {name: ''resolved'', color: ''#009900''},' || chr(13) || chr(10) || '            {name: null, color: ''#000000''}' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        priority;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (key.startsWith(''redmine_'')) {' || chr(13) || chr(10) || '                params_redmine[key.substring(8)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''customfield_'')) {' || chr(13) || chr(10) || '')||
TO_NCLOB('                params_fields[key.substring(12)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''event_update_'')) {' || chr(13) || chr(10) || '                params_update[key.substring(13)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (required_params.indexOf(key) !== -1 && params[key].trim() === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" cannot be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '    if (params.event_source === ''0'' && params.event_update_status !== ''0'' && params.event_update_status !== ''1'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    if (typeof params_redmine.close_status_id === ''string'' && params_redmine.close_status_id.trim() !== '''' && !parseInt(params_redmine.close_status_id, 10)) {' || chr(13) || chr(10) || '        throw ''Incorrect "redmine_close_status_id" parameter given! Must be an integer.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_value === ''0'') {' || chr(13) || chr(10) || '        throw ''Recovery operations are supported only for trigger-based actions.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source === ''0''' || chr(13) || chr(10) || '        && ((params.event_value === ''1'' && params.event_update_status === ''1'')' || chr(13) || chr(10) || '            || (params.event_value === ''0''' || chr(13) || chr(10) || '                && (params.event_update_status === ''0'' || params.event_update_status === ''1'')))' || chr(13) || chr(10) || '        && (isNaN(parseInt(params.redmine_issue_key)) || parseInt(params.redmine_issue_key) < 1 )) {' || chr(13) || chr(10) || '        throw ''Incorrect "redmine_issue_key" parameter given: '' + params.redmine_issue_key +' || chr(13) || chr(10) || '            ''\nMust be positive integer.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {' || chr(13) || chr(10) || '        params.event_nseverity = ''7'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value === ''0'') {' || chr(13) || chr(10) || '        params.event_nseverity = ''6'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    priority = params[''severity_'' + severities[params.event_nseverity].name];' || chr(13) || chr(10) || '    priority = priority && priority.trim() || severities[7].name;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Redmine.setParams(params_redmine);' || chr(13) || chr(10) || '')||
TO_NCLOB('    Redmine.HTTPProxy = params.HTTPProxy;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Create issue for non trigger-based events.' || chr(13) || chr(10) || '    if (params.event_source !== ''0''' || chr(13) || chr(10) || '        && params.event_value !== ''0'') {' || chr(13) || chr(10) || '        Redmine.createIssue(params.alert_subject, params.alert_message, priority);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Create issue for trigger-based events.' || chr(13) || chr(10) || '    else if (params.event_value === ''1'' && params_update.status === ''0'') {' || chr(13) || chr(10) || '        var issue_id = Redmine.createIssue(params.alert_subject,' || chr(13) || chr(10) || '            params.alert_subject + ''\n'' + params.alert_message + ''\n'' +' || chr(13) || chr(10) || '            params.zabbix_url + (params.zabbix_url.endsWith(''/'') ? '''' : ''/'') +' || chr(13) || chr(10) || '            ''tr_events.php?triggerid='' + params.trigger_id + ''&eventid='' + params.event_id + ''\n'',' || chr(13) || chr(10) || '            priority,' || chr(13) || chr(10) || '            params_fields);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result.tags.__zbx_redmine_issue_id = issue_id;' || chr(13) || chr(10) || '        result.tags.__zbx_redmine_issuelink = params.redmine_url +' || chr(13) || chr(10) || '            (params.redmine_url.endsWith(''/'') ? '''' : ''/'') + ''issues/'' + issue_id;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Close issue if parameter close_status_id is set and it is a recovery operation' || chr(13) || chr(10) || '    else if (params.event_value === ''0'' && typeof params_redmine.close_status_id === ''string'' && params_redmine.close_status_id.trim() !== '''') {' || chr(13) || chr(10) || '        Redmine.updateIssue(params.alert_subject + ''\n'' + params.alert_message, params_fields, params_redmine.close_status_id);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Update created issue for trigger-based event.' || chr(13) || chr(10) || '')||
TO_NCLOB('    else {' || chr(13) || chr(10) || '        Redmine.updateIssue(params.alert_subject + ''\n'' + params.alert_message, params_fields);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return JSON.stringify(result);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ Redmine Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_redmine_issuelink}','Redmine: issue #{EVENT.TAGS.__zbx_redmine_issue_id}','')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description)
values ('16','4','Telegram','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',TO_NCLOB('var Telegram = {' || chr(13) || chr(10) || '    token: null,' || chr(13) || chr(10) || '    to: null,' || chr(13) || chr(10) || '    message: null,' || chr(13) || chr(10) || '    proxy: null,' || chr(13) || chr(10) || '    parse_mode: null,' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    escapeMarkup: function (str, mode) {' || chr(13) || chr(10) || '        switch (mode) {' || chr(13) || chr(10) || '            case ''markdown'':' || chr(13) || chr(10) || '                return str.replace(/([_*\[`])/g, ''\\$&'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''markdownv2'':' || chr(13) || chr(10) || '                return str.replace(/([_*\[\]()~`>#+\-=|{}.!])/g, ''\\$&'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                return str;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    sendMessage: function () {' || chr(13) || chr(10) || '        var params = {' || chr(13) || chr(10) || '            chat_id: Telegram.to,' || chr(13) || chr(10) || '            text: Telegram.message,' || chr(13) || chr(10) || '            disable_web_page_preview: true,' || chr(13) || chr(10) || '            disable_notification: false' || chr(13) || chr(10) || '        },' || chr(13) || chr(10) || '        data,' || chr(13) || chr(10) || '        response,' || chr(13) || chr(10) || '        request = new HttpRequest(),' || chr(13) || chr(10) || '        url = ''https://api.telegram.org/bot'' + Telegram.token + ''/sendMessage'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (Telegram.parse_mode !== null) {' || chr(13) || chr(10) || '            params[''parse_mode''] = Telegram.parse_mode;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (Telegram.proxy) {' || chr(13) || chr(10) || '            request.setProxy(Telegram.proxy);' || chr(13) || chr(10) || '')||
TO_NCLOB('        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '        data = JSON.stringify(params);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        // Remove replace() function if you want to see the exposed token in the log file.' || chr(13) || chr(10) || '        Zabbix.log(4, ''[Telegram Webhook] URL: '' + url.replace(Telegram.token, ''<TOKEN>''));' || chr(13) || chr(10) || '        Zabbix.log(4, ''[Telegram Webhook] params: '' + data);' || chr(13) || chr(10) || '        response = request.post(url, data);' || chr(13) || chr(10) || '        Zabbix.log(4, ''[Telegram Webhook] HTTP code: '' + request.getStatus());' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        try {' || chr(13) || chr(10) || '            response = JSON.parse(response);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        catch (error) {' || chr(13) || chr(10) || '            response = null;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() !== 200 || typeof response.ok !== ''boolean'' || response.ok !== true) {' || chr(13) || chr(10) || '            if (typeof response.description === ''string'') {' || chr(13) || chr(10) || '                throw response.description;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else {' || chr(13) || chr(10) || '                throw ''Unknown error. Check debug log for more information.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.Token === ''undefined'') {' || chr(13) || chr(10) || '')||
TO_NCLOB('        throw ''Incorrect value is given for parameter "Token": parameter is missing'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Telegram.token = params.Token;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.HTTPProxy) {' || chr(13) || chr(10) || '        Telegram.proxy = params.HTTPProxy;' || chr(13) || chr(10) || '    } ' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    params.ParseMode = params.ParseMode.toLowerCase();' || chr(13) || chr(10) || '    ' || chr(13) || chr(10) || '    if ([''markdown'', ''html'', ''markdownv2''].indexOf(params.ParseMode) !== -1) {' || chr(13) || chr(10) || '        Telegram.parse_mode = params.ParseMode;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Telegram.to = params.To;' || chr(13) || chr(10) || '    Telegram.message = params.Subject + ''\n'' + params.Message;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([''markdown'', ''markdownv2''].indexOf(params.ParseMode) !== -1) {' || chr(13) || chr(10) || '        Telegram.message = Telegram.escapeMarkup(Telegram.message, params.ParseMode);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Telegram.sendMessage();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return ''OK'';' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(4, ''[Telegram Webhook] notification failed: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error + ''.'';' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'10s','0','0','','','https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/telegram' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '1. Register bot: send "/newbot" to @BotFather and follow instructions' || chr(13) || chr(10) || '2. Copy and paste the obtained token into the "Token" field above' || chr(13) || chr(10) || '3. If you want to send personal notifications, you need to get chat id of the user you want to send messages to:' || chr(13) || chr(10) || '    3.1. Send "/getid" to "@myidbot" in Telegram messenger' || chr(13) || chr(10) || '    3.2. Copy returned chat id and save it in the "Telegram Webhook" media for the user' || chr(13) || chr(10) || '    3.3. Ask the user to send "/start" to your bot (Telegram bot won''t send anything to the user without it)' || chr(13) || chr(10) || '4. If you want to send group notifications, you need to get group id of the group you want to send messages to:' || chr(13) || chr(10) || '    4.1. Add "@myidbot" to your group' || chr(13) || chr(10) || '    4.2. Send "/getgroupid@myidbot" in your group' || chr(13) || chr(10) || '    4.3. Copy returned group id save it in the "Telegram Webhook" media for the user you created for  group notifications' || chr(13) || chr(10) || '    4.4. Send "/start@your_bot_name_here" in your group (Telegram bot won''t send anything to the group without it)')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description)
values ('17','4','Zendesk','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',TO_NCLOB('var Zendesk = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zendesk.params = params;' || chr(13) || chr(10) || '        if (typeof Zendesk.params.url === ''string'') {' || chr(13) || chr(10) || '            if (!Zendesk.params.url.endsWith(''/'')) {' || chr(13) || chr(10) || '                Zendesk.params.url += ''/'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            Zendesk.params.url += ''api/v2/'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    addCustomFields: function (data, fields) {' || chr(13) || chr(10) || '        if (typeof fields === ''object'' && Object.keys(fields).length) {' || chr(13) || chr(10) || '            var schema = Zendesk.getSchema(),' || chr(13) || chr(10) || '                arr = [],' || chr(13) || chr(10) || '                i,' || chr(13) || chr(10) || '                n;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (schema) {' || chr(13) || chr(10) || '                Object.keys(fields)' || chr(13) || chr(10) || '                    .forEach(function(field) {' || chr(13) || chr(10) || '                        for (i = 0, n = schema.ticket_fields.length; i < n; i++) {' || chr(13) || chr(10) || '                            if (schema.ticket_fields[i].id == field' || chr(13) || chr(10) || '                                && [''text'', ''integer'', ''date''].indexOf(schema.ticket_fields[i].type) !== -1){' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                                switch (schema.ticket_fields[i].type) {' || chr(13) || chr(10) || '                                    case ''integer'':' || chr(13) || chr(10) || '')||
TO_NCLOB('                                        fields[field] = parseInt(fields[field]);' || chr(13) || chr(10) || '                                        break;' || chr(13) || chr(10) || '                                    case ''date'':' || chr(13) || chr(10) || '                                        if (fields[field].match(/^\d{4}[.-]\d{2}[.-]\d{2}$/) !== null) {' || chr(13) || chr(10) || '                                            fields[field] = fields[field].replace(/\./g, ''-'');' || chr(13) || chr(10) || '                                        }' || chr(13) || chr(10) || '                                        else {' || chr(13) || chr(10) || '                                            fields[field] = '''';' || chr(13) || chr(10) || '                                        }' || chr(13) || chr(10) || '                                        break;' || chr(13) || chr(10) || '                                }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                                arr.push({id: field, value: fields[field]});' || chr(13) || chr(10) || '                                break;' || chr(13) || chr(10) || '                            }' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '                    });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                if (arr.length) {' || chr(13) || chr(10) || '                    data.ticket[''custom_fields''] = arr;' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[Zendesk Webhook] Failed to retrieve field schema.'');' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return data;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (method, query, data) {' || chr(13) || chr(10) || '')||
TO_NCLOB('        [''url'', ''token'', ''type''].forEach(function (field) {' || chr(13) || chr(10) || '            if (typeof Zendesk.params !== ''object'' || typeof Zendesk.params[field] === ''undefined'') {' || chr(13) || chr(10) || '                throw ''Required Zendesk param is not set: '' + field + ''\n'' + Zendesk.params[field];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            url = Zendesk.params.url + query,' || chr(13) || chr(10) || '            request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof Zendesk.HTTPProxy === ''string'' && Zendesk.HTTPProxy.trim() !== '''') {' || chr(13) || chr(10) || '            request.setProxy(Zendesk.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '        request.addHeader(''Authorization: Basic '' + btoa(Zendesk.params.token));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[Zendesk Webhook] Sending request: '' + url + ((typeof data === ''string'') ? ('' '' + data) : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (method) {' || chr(13) || chr(10) || '            case ''get'':' || chr(13) || chr(10) || '                response = request.get(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''post'':' || chr(13) || chr(10) || '                response = request.post(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('            case ''put'':' || chr(13) || chr(10) || '                response = request.put(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                throw ''Unsupported HTTP request method: '' + method;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[Zendesk Webhook] Received response with status code '' + request.getStatus() + ''. '' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[Zendesk Webhook] Failed to parse response received from Zendesk.'');' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() < 200 || request.getStatus() >= 300) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (response !== null && typeof response.error !== ''undefined''' || chr(13) || chr(10) || '                && Object.keys(response.error).length > 0) {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.error);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (response !== null && typeof response.description !== ''undefined''' || chr(13) || chr(10) || '                && Object.keys(response.description).length > 0) {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.description);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else {' || chr(13) || chr(10) || '')||
TO_NCLOB('                message += ''. '' + response;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            throw message + ''. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return {' || chr(13) || chr(10) || '            status: request.getStatus(),' || chr(13) || chr(10) || '            response: response' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    getSchema: function() {' || chr(13) || chr(10) || '        var result = Zendesk.request(''get'', ''ticket_fields.json'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return result.response;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    createIssue: function(data, fields) {' || chr(13) || chr(10) || '        var result = Zendesk.request(''post'', ''tickets.json'', Zendesk.addCustomFields(data, fields));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof result.response !== ''object'' || typeof result.response.ticket.id === ''undefined''' || chr(13) || chr(10) || '            || result.status != 201) {' || chr(13) || chr(10) || '            throw ''Cannot create Zendesk issue. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return result.response.ticket.id;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    updateIssue: function(data, fields) {' || chr(13) || chr(10) || '        Zendesk.request(''put'', ''tickets/'' + Zendesk.params.issue_key + ''.json'', Zendesk.addCustomFields(data, fields));' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        fields = {},' || chr(13) || chr(10) || '')||
TO_NCLOB('        zendesk = {},' || chr(13) || chr(10) || '        update = {},' || chr(13) || chr(10) || '        data = {},' || chr(13) || chr(10) || '        result = {tags: {}},' || chr(13) || chr(10) || '        required_params = [' || chr(13) || chr(10) || '            ''alert_subject'',' || chr(13) || chr(10) || '            ''alert_message'',' || chr(13) || chr(10) || '            ''event_id'',' || chr(13) || chr(10) || '            ''event_source'',' || chr(13) || chr(10) || '            ''event_value'',' || chr(13) || chr(10) || '            ''event_update_status''' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        severities = [' || chr(13) || chr(10) || '            {name: ''not_classified'', color: ''#97AAB3''},' || chr(13) || chr(10) || '            {name: ''information'', color: ''#7499FF''},' || chr(13) || chr(10) || '            {name: ''warning'', color: ''#FFC859''},' || chr(13) || chr(10) || '            {name: ''average'', color: ''#FFA059''},' || chr(13) || chr(10) || '            {name: ''high'', color: ''#E97659''},' || chr(13) || chr(10) || '            {name: ''disaster'', color: ''#E45959''},' || chr(13) || chr(10) || '            {name: ''resolved'', color: ''#009900''},' || chr(13) || chr(10) || '            {name: ''default'', color: ''#000000''}' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        priority;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (key.startsWith(''zendesk_'')) {' || chr(13) || chr(10) || '                zendesk[key.substring(8)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''customfield_'')) {' || chr(13) || chr(10) || '                fields[key.substring(12)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''event_update_'')) {' || chr(13) || chr(10) || '')||
TO_NCLOB('                update[key.substring(13)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (required_params.indexOf(key) !== -1 && params[key].trim() === '''') {' || chr(13) || chr(10) || '                throw ''Parameter '' + key + '' cannot be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Possible values: question, incident, problems, task' || chr(13) || chr(10) || '    if ([''question'', ''incident'', ''problem'', ''task''].indexOf(params.zendesk_type) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "zendesk_type" parameter given: '' + params.zendesk_type +' || chr(13) || chr(10) || '            ''\nMust be one of question, incident, problem, task.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Possible values: 0 - Trigger, 1 - Discovery, 2 - Autoregistration, 3 - Internal.' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    // Possible values: 1 for problem, 0 for recovering' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '')||
TO_NCLOB('    // Possible values: 0 - Webhook was called because of problem/recovery event, 1 - Update operation.' || chr(13) || chr(10) || '    if (params.event_source === ''0'' && params.event_update_status !== ''0'' && params.event_update_status !== ''1'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_value === ''0'') {' || chr(13) || chr(10) || '        throw ''Recovery operations are supported only for trigger-based actions.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Zendesk_issue_key must be a positive integer if an update action is being performed.' || chr(13) || chr(10) || '    if (params.event_source === ''0'' && ((params.event_value === ''1'' && params.event_update_status === ''1'')' || chr(13) || chr(10) || '        || (params.event_value === ''0'' && (params.event_update_status === ''0'' || params.event_update_status === ''1'')))' || chr(13) || chr(10) || '        && (isNaN(parseInt(params.zendesk_issue_key)) || parseInt(params.zendesk_issue_key) < 1 )) {' || chr(13) || chr(10) || '        throw ''Incorrect "zendesk_issue_key" parameter given: '' + params.zendesk_issue_key +' || chr(13) || chr(10) || '            ''\nMust be positive integer.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {' || chr(13) || chr(10) || '        params.event_nseverity = ''7'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value === ''0'') {' || chr(13) || chr(10) || '        params.event_nseverity = ''6'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    priority = params[''severity_'' + severities[params.event_nseverity].name] || severities[7].name;' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '    Zendesk.setParams(zendesk);' || chr(13) || chr(10) || '    Zendesk.HTTPProxy = params.HTTPProxy;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Create issue for non trigger-based events.' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_value !== ''0'') {' || chr(13) || chr(10) || '        data = {' || chr(13) || chr(10) || '            ticket: {' || chr(13) || chr(10) || '                external_id: params.event_id,' || chr(13) || chr(10) || '                type: Zendesk.params.type,' || chr(13) || chr(10) || '                status: ''new'',' || chr(13) || chr(10) || '                subject: params.alert_subject,' || chr(13) || chr(10) || '                comment: {' || chr(13) || chr(10) || '                    body: params.alert_message,' || chr(13) || chr(10) || '                    public: ''false''' || chr(13) || chr(10) || '                },' || chr(13) || chr(10) || '                priority: priority,' || chr(13) || chr(10) || '                tags: params.event_tags' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zendesk.createIssue(data, fields);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Create issue for trigger-based events.' || chr(13) || chr(10) || '    else if (params.event_value === ''1'' && update.status === ''0'') {' || chr(13) || chr(10) || '        data = {' || chr(13) || chr(10) || '            ticket: {' || chr(13) || chr(10) || '                external_id: params.event_id,' || chr(13) || chr(10) || '                type: Zendesk.params.type,' || chr(13) || chr(10) || '                status: ''new'',' || chr(13) || chr(10) || '                subject: params.alert_subject,' || chr(13) || chr(10) || '                comment: {' || chr(13) || chr(10) || '')||
TO_NCLOB('                    body: params.zbxurl + (params.zbxurl.endsWith(''/'') ? '''' : ''/'') + ''tr_events.php?triggerid='' +' || chr(13) || chr(10) || '                        params.trigger_id + ''&eventid='' + params.event_id + ''\n'' + params.alert_message,' || chr(13) || chr(10) || '                    public: ''false''' || chr(13) || chr(10) || '                },' || chr(13) || chr(10) || '                priority: priority,' || chr(13) || chr(10) || '                tags: params.event_tags' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '        var key = Zendesk.createIssue(data, fields);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result.tags.__zbx_zdk_issuekey = key;' || chr(13) || chr(10) || '        result.tags.__zbx_zdk_issuelink = params.zendesk_url +' || chr(13) || chr(10) || '            (params.zendesk_url.endsWith(''/'') ? '''' : ''/'') + ''agent/tickets/'' + key;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Update created issue for trigger-based event.' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        data = {' || chr(13) || chr(10) || '            ticket: {' || chr(13) || chr(10) || '                type: Zendesk.params.type,' || chr(13) || chr(10) || '                subject: params.alert_subject,' || chr(13) || chr(10) || '                comment: {' || chr(13) || chr(10) || '                    body: params.alert_message,' || chr(13) || chr(10) || '                    public: ''false''' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zendesk.updateIssue(data, fields);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return JSON.stringify(result);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[Zendesk Webhook] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_zdk_issuelink}','Zendesk: {EVENT.TAGS.__zbx_zdk_issuekey}','')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description)
values ('18','4','ServiceNow','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',TO_NCLOB('var ServiceNow = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        ServiceNow.params = params;' || chr(13) || chr(10) || '        if (typeof ServiceNow.params.url === ''string'') {' || chr(13) || chr(10) || '            if (!ServiceNow.params.url.endsWith(''/'')) {' || chr(13) || chr(10) || '                ServiceNow.params.url += ''/'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            ServiceNow.params.url += ''api/now/table/incident'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setProxy: function (HTTPProxy) {' || chr(13) || chr(10) || '        ServiceNow.HTTPProxy = HTTPProxy;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setFields: function (data, fields) {' || chr(13) || chr(10) || '        if (typeof fields === ''object'' && Object.keys(fields).length) {' || chr(13) || chr(10) || '            Object.keys(fields)' || chr(13) || chr(10) || '                .forEach(function(field) {' || chr(13) || chr(10) || '                    data[field] = (fields[field].match(/^\d{4}\.\d{2}\.\d{2}$/) !== null)' || chr(13) || chr(10) || '                        ? fields[field].replace(/\./g, ''-'')' || chr(13) || chr(10) || '                        : fields[field];' || chr(13) || chr(10) || '                });' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (method, data) {' || chr(13) || chr(10) || '        [''url'', ''user'', ''password''].forEach(function (field) {' || chr(13) || chr(10) || '')||
TO_NCLOB('            if (typeof ServiceNow.params !== ''object'' || typeof ServiceNow.params[field] === ''undefined''' || chr(13) || chr(10) || '                || ServiceNow.params[field] === '''' ) {' || chr(13) || chr(10) || '                throw ''Required ServiceNow param is not set: "'' + field + ''".'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            url = ServiceNow.params.url,' || chr(13) || chr(10) || '            request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '        request.addHeader(''Authorization: Basic '' + btoa(ServiceNow.params.user + '':'' + ServiceNow.params.password));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof ServiceNow.HTTPProxy !== ''undefined'' && ServiceNow.HTTPProxy !== '''') {' || chr(13) || chr(10) || '            request.setProxy(ServiceNow.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ ServiceNow Webhook ] Sending request: '' + url + ((typeof data === ''string'')' || chr(13) || chr(10) || '            ? (''\n'' + data)' || chr(13) || chr(10) || '            : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (method) {' || chr(13) || chr(10) || '            case ''get'':' || chr(13) || chr(10) || '                response = request.get(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''post'':' || chr(13) || chr(10) || '                response = request.post(url, data);' || chr(13) || chr(10) || '')||
TO_NCLOB('                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''put'':' || chr(13) || chr(10) || '                response = request.put(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                throw ''Unsupported HTTP request method: '' + method;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ ServiceNow Webhook ] Received response with status code '' +' || chr(13) || chr(10) || '            request.getStatus() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ ServiceNow Webhook ] Failed to parse response received from ServiceNow'');' || chr(13) || chr(10) || '                response = null;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() < 200 || request.getStatus() >= 300) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (response !== null && typeof response.error.message !== ''undefined''' || chr(13) || chr(10) || '                && Object.keys(response.error).length > 0) {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.error.message);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            throw message + '' Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '')||
TO_NCLOB('        else if (typeof response.result !== ''object'' || typeof response.result.sys_id === ''undefined'') {' || chr(13) || chr(10) || '            throw ''Cannot create ServiceNow incident. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return response.result;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        fields = {},' || chr(13) || chr(10) || '        servicenow = {},' || chr(13) || chr(10) || '        data = {},' || chr(13) || chr(10) || '        result = {tags: {}},' || chr(13) || chr(10) || '        required_params = [' || chr(13) || chr(10) || '            ''alert_subject'', ''alert_message'', ''event_source'', ''event_value'',' || chr(13) || chr(10) || '            ''event_update_status'', ''event_recovery_value'', ''event_nseverity''' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        severities = [' || chr(13) || chr(10) || '            {name: ''not_classified'', color: ''#97AAB3''},' || chr(13) || chr(10) || '            {name: ''information'', color: ''#7499FF''},' || chr(13) || chr(10) || '            {name: ''warning'', color: ''#FFC859''},' || chr(13) || chr(10) || '            {name: ''average'', color: ''#FFA059''},' || chr(13) || chr(10) || '            {name: ''high'', color: ''#E97659''},' || chr(13) || chr(10) || '            {name: ''disaster'', color: ''#E45959''},' || chr(13) || chr(10) || '            {name: ''resolved'', color: ''#009900''},' || chr(13) || chr(10) || '            {name: ''default'', color: ''#000000''}' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        method = ''post'',' || chr(13) || chr(10) || '        process_tags = true;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '')||
TO_NCLOB('            if (key.startsWith(''servicenow_'')) {' || chr(13) || chr(10) || '                servicenow[key.substring(11)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''u_'')) {' || chr(13) || chr(10) || '                fields[key] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (required_params.indexOf(key) !== -1 && params[key] === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" can\''t be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {' || chr(13) || chr(10) || '        params.event_nseverity = ''7'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'' && params.event_source === ''0'') {' || chr(13) || chr(10) || '')||
TO_NCLOB('        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_recovery_value === ''0'') {' || chr(13) || chr(10) || '        throw ''Recovery operations are supported only for trigger-based actions.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    data.short_description = params.alert_subject;' || chr(13) || chr(10) || '    data.description = params.alert_message;' || chr(13) || chr(10) || '    data.comments = params.alert_message;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params[''urgency_for_'' + severities[params.event_nseverity].name] !== ''undefined'') {' || chr(13) || chr(10) || '        data.urgency = params[''urgency_for_'' + severities[params.event_nseverity].name];' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    ServiceNow.setParams(servicenow);' || chr(13) || chr(10) || '    ServiceNow.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    ServiceNow.setFields(data, fields);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source === ''0'' && (params.event_value === ''0'' || params.event_update_status === ''1'')) {' || chr(13) || chr(10) || '        process_tags = false;' || chr(13) || chr(10) || '        method = ''put'';' || chr(13) || chr(10) || '        delete data.description;' || chr(13) || chr(10) || '        delete data.urgency;' || chr(13) || chr(10) || '        ServiceNow.params.url += ''/'' + params.servicenow_sys_id;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var response = ServiceNow.request(method, data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (process_tags) {' || chr(13) || chr(10) || '        result.tags.__zbx_servicenow_sys_id = response.sys_id;' || chr(13) || chr(10) || '        result.tags.__zbx_servicenow_link = params.servicenow_url +' || chr(13) || chr(10) || '')||
TO_NCLOB('            (params.servicenow_url.endsWith(''/'') ? '''' : ''/'') + ''incident.do?sys_id='' + response.sys_id;' || chr(13) || chr(10) || '        result.tags.__zbx_servicenow_number = response.number;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return JSON.stringify(result);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ ServiceNow Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_servicenow_link}','ServiceNow: {EVENT.TAGS.__zbx_servicenow_number}','')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description)
values ('19','4','Zammad','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',TO_NCLOB('var Zammad = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zammad.params = params;' || chr(13) || chr(10) || '        if (typeof Zammad.params.url === ''string'') {' || chr(13) || chr(10) || '            if (!Zammad.params.url.endsWith(''/'')) {' || chr(13) || chr(10) || '                Zammad.params.url += ''/'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (method, query, data) {' || chr(13) || chr(10) || '        [''url'', ''access_token''].forEach(function (field) {' || chr(13) || chr(10) || '            if (typeof Zammad.params !== ''object'' || typeof Zammad.params[field] === ''undefined''' || chr(13) || chr(10) || '                || Zammad.params[field] === '''' ) {' || chr(13) || chr(10) || '                throw ''Required param is not set: "'' + field + ''".'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            url = Zammad.params.url + query,' || chr(13) || chr(10) || '            request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof Zammad.HTTPProxy === ''string'' && Zammad.HTTPProxy.trim() !== '''') {' || chr(13) || chr(10) || '            request.setProxy(Zammad.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '')||
TO_NCLOB('        request.addHeader(''Authorization: Token token='' + Zammad.params.access_token);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ Zammad Webhook ] Sending request: '' +' || chr(13) || chr(10) || '            url + ((typeof data === ''string'') ? ('' '' + data) : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (method) {' || chr(13) || chr(10) || '            case ''get'':' || chr(13) || chr(10) || '                response = request.get(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''post'':' || chr(13) || chr(10) || '                response = request.post(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''put'':' || chr(13) || chr(10) || '                response = request.put(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                throw ''Unsupported HTTP request method: '' + method;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ Zammad Webhook ] Received response with status code '' + request.getStatus() + '': '' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ Zammad Webhook ] Failed to parse response received from Zammad'');' || chr(13) || chr(10) || '                response = null;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '')||
TO_NCLOB('        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() < 200 || request.getStatus() >= 300) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (response !== null && typeof response.errors !== ''undefined''' || chr(13) || chr(10) || '                && Object.keys(response.errors).length > 0) {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.errors);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (response !== null && typeof response.errorMessages !== ''undefined''' || chr(13) || chr(10) || '                && Object.keys(response.errorMessages).length > 0) {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.errorMessages);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            throw message + '' Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return {' || chr(13) || chr(10) || '            status: request.getStatus(),' || chr(13) || chr(10) || '            response: response' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setTicketTags: function (tags, ticket_id) {' || chr(13) || chr(10) || '        var data = {' || chr(13) || chr(10) || '            item: '''',' || chr(13) || chr(10) || '            object: ''Ticket'',' || chr(13) || chr(10) || '            o_id: ticket_id' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        try {' || chr(13) || chr(10) || '            var tags_json = JSON.parse(tags),' || chr(13) || chr(10) || '                result;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('            for (var i in tags_json) {' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                if (tags_json[i].value) {' || chr(13) || chr(10) || '                    data.item = tags_json[i].tag + ": " + tags_json[i].value;' || chr(13) || chr(10) || '                } else {' || chr(13) || chr(10) || '                    data.item = tags_json[i].tag;' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '                result = Zammad.request(''post'', ''api/v1/tags/add'', data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                if (typeof result.response !== ''object'' || result.status != 200) {' || chr(13) || chr(10) || '                    Zabbix.log(4, ''[ Zammad Webhook ] Cannot add ticket tag:'' + tags_json[i].tag);' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        catch (error) {' || chr(13) || chr(10) || '            Zabbix.log(4, ''[ Zammad Webhook ] Failed to add ticket tags:'' + error);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    createTicket: function(subject, message, priority) {' || chr(13) || chr(10) || '        var data = {' || chr(13) || chr(10) || '                title: subject,' || chr(13) || chr(10) || '                group: ''Users'',' || chr(13) || chr(10) || '                article: {' || chr(13) || chr(10) || '                    subject: subject,' || chr(13) || chr(10) || '                    body: message,' || chr(13) || chr(10) || '                    type: ''note'',' || chr(13) || chr(10) || '                    internal: false' || chr(13) || chr(10) || '                },' || chr(13) || chr(10) || '                customer: Zammad.params.customer' || chr(13) || chr(10) || '            },' || chr(13) || chr(10) || '            result;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('        if (priority) {' || chr(13) || chr(10) || '            data.priority_id = priority;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result = Zammad.request(''post'', ''api/v1/tickets'', data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof result.response !== ''object''' || chr(13) || chr(10) || '            || typeof result.response.id === ''undefined''' || chr(13) || chr(10) || '            || result.status != 201) {' || chr(13) || chr(10) || '            throw ''Cannot create Zammad ticket. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return result.response.id;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    updateTicket: function(subject, message) {' || chr(13) || chr(10) || '        var data = {' || chr(13) || chr(10) || '            ticket_id: Zammad.params.ticket_id,' || chr(13) || chr(10) || '            subject: subject,' || chr(13) || chr(10) || '            body: message || '''',' || chr(13) || chr(10) || '            type: ''note'',' || chr(13) || chr(10) || '            internal: false' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result = Zammad.request(''post'', ''api/v1/ticket_articles'', data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof result.response !== ''object''' || chr(13) || chr(10) || '            || typeof result.response.id === ''undefined''' || chr(13) || chr(10) || '            || result.status != 201) {' || chr(13) || chr(10) || '            throw ''Cannot update Zammad ticket. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '')||
TO_NCLOB('        params_zammad = {},' || chr(13) || chr(10) || '        params_update = {},' || chr(13) || chr(10) || '        result = {tags: {}},' || chr(13) || chr(10) || '        required_params = [' || chr(13) || chr(10) || '            ''alert_subject'', ''customer'',' || chr(13) || chr(10) || '            ''event_source'', ''event_value'',' || chr(13) || chr(10) || '            ''event_update_status''' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        severities = [' || chr(13) || chr(10) || '            {name: ''not_classified'', color: ''#97AAB3''},' || chr(13) || chr(10) || '            {name: ''information'', color: ''#7499FF''},' || chr(13) || chr(10) || '            {name: ''warning'', color: ''#FFC859''},' || chr(13) || chr(10) || '            {name: ''average'', color: ''#FFA059''},' || chr(13) || chr(10) || '            {name: ''high'', color: ''#E97659''},' || chr(13) || chr(10) || '            {name: ''disaster'', color: ''#E45959''},' || chr(13) || chr(10) || '            {name: ''resolved'', color: ''#009900''},' || chr(13) || chr(10) || '            {name: null, color: ''#000000''}' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        priority;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (key.startsWith(''zammad_'')) {' || chr(13) || chr(10) || '                params_zammad[key.substring(7)] = params[key].trim();' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''event_update_'')) {' || chr(13) || chr(10) || '                params_update[key.substring(13)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (required_params.indexOf(key) !== -1 && params[key].trim() === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" cannot be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '')||
TO_NCLOB('        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '    if (params.event_source === ''0'' && params.event_update_status !== ''0'' && params.event_update_status !== ''1'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_value === ''0'') {' || chr(13) || chr(10) || '        throw ''Recovery operations are supported only for trigger-based actions.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source === ''0''' || chr(13) || chr(10) || '        && ((params.event_value === ''1'' && params.event_update_status === ''1'')' || chr(13) || chr(10) || '            || (params.event_value === ''0''' || chr(13) || chr(10) || '                && (params.event_update_status === ''0'' || params.event_update_status === ''1'')))' || chr(13) || chr(10) || '        && (isNaN(parseInt(params.zammad_ticket_id)) || parseInt(params.zammad_ticket_id) < 1 )) {' || chr(13) || chr(10) || '')||
TO_NCLOB('        throw ''Incorrect "zammad_ticket_id" parameter given: '' + params.zammad_ticket_id +' || chr(13) || chr(10) || '            ''\nMust be positive integer.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {' || chr(13) || chr(10) || '        params.event_nseverity = ''7'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value === ''0'') {' || chr(13) || chr(10) || '        params.event_nseverity = ''6'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    priority = params[''severity_'' + severities[params.event_nseverity].name];' || chr(13) || chr(10) || '    priority = priority && priority.trim() || severities[7].name;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Zammad.setParams(params_zammad);' || chr(13) || chr(10) || '    Zammad.HTTPProxy = params.HTTPProxy;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Create ticket for non trigger-based events.' || chr(13) || chr(10) || '    if (params.event_source !== ''0''' || chr(13) || chr(10) || '        && params.event_value !== ''0'') {' || chr(13) || chr(10) || '        Zammad.createTicket(params.alert_subject, params.alert_message, priority, params.event_tags);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Create ticket for trigger-based events.' || chr(13) || chr(10) || '    else if (params.event_value === ''1'' && params_update.status === ''0'') {' || chr(13) || chr(10) || '        var ticket_id = Zammad.createTicket(params.alert_subject,' || chr(13) || chr(10) || '            params.alert_subject + ''\n'' + params.alert_message + ''\n'' +' || chr(13) || chr(10) || '            params.zabbix_url + (params.zabbix_url.endsWith(''/'') ? '''' : ''/'') +' || chr(13) || chr(10) || '')||
TO_NCLOB('            ''tr_events.php?triggerid='' + params.trigger_id + ''&eventid='' + params.event_id + ''\n'',' || chr(13) || chr(10) || '            priority);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result.tags.__zbx_zammad_ticket_id = ticket_id;' || chr(13) || chr(10) || '        result.tags.__zbx_zammad_ticketlink = params.zammad_url +' || chr(13) || chr(10) || '            (params.zammad_url.endsWith(''/'') ? '''' : ''/'') + ''#ticket/zoom/'' + ticket_id;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (Zammad.params.enable_tags.toLowerCase() === ''true'') {' || chr(13) || chr(10) || '            Zammad.setTicketTags(params.event_tags, ticket_id);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Update created ticket for trigger-based event.' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        Zammad.updateTicket(params.alert_subject, params.alert_message);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return JSON.stringify(result);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ Zammad Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_zammad_ticketlink}','Zammad: ticket #{EVENT.TAGS.__zbx_zammad_ticket_id}','')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description)
values ('20','4','Jira ServiceDesk','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',TO_NCLOB('var Jira = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '    schema: {},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Jira.params = params;' || chr(13) || chr(10) || '        if (typeof Jira.params.url === ''string'') {' || chr(13) || chr(10) || '            if (!Jira.params.url.endsWith(''/'')) {' || chr(13) || chr(10) || '                Jira.params.url += ''/'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            Jira.params.url += ''rest/servicedeskapi/'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setProxy: function (HTTPProxy) {' || chr(13) || chr(10) || '        Jira.HTTPProxy = HTTPProxy;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setTags: function(event_tags_json) {' || chr(13) || chr(10) || '        if (!Jira.schema) {' || chr(13) || chr(10) || '            Zabbix.log(4, ''[ Jira Service Desk Webhook ] Cannot add labels because failed to retrieve field schema.'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var block = Jira.schema.requestTypeFields.filter(function(object) {' || chr(13) || chr(10) || '            return object.fieldId == ''labels'';' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (block[0] && typeof event_tags_json !== ''undefined'' && event_tags_json !== ''''' || chr(13) || chr(10) || '            && event_tags_json !== ''{EVENT.TAGSJSON}'') {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '')||
TO_NCLOB('                var tags = JSON.parse(event_tags_json),' || chr(13) || chr(10) || '                    label;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                Jira.labels = [];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                tags.forEach(function (tag) {' || chr(13) || chr(10) || '                    if (typeof tag.tag !== ''undefined'' && typeof tag.value !== ''undefined'' ) {' || chr(13) || chr(10) || '                        label = (tag.tag + (tag.value ? ('':'' + tag.value) : '''')).replace(/\s/g, ''_'');' || chr(13) || chr(10) || '                        if (label.length < 255) {' || chr(13) || chr(10) || '                            Jira.labels.push(label);' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '                    }' || chr(13) || chr(10) || '                });' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                // Code is not missing here.' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    addCustomFields: function (data, fields) {' || chr(13) || chr(10) || '        if (typeof fields === ''object'' && Object.keys(fields).length) {' || chr(13) || chr(10) || '            if (Jira.schema) {' || chr(13) || chr(10) || '                Object.keys(fields)' || chr(13) || chr(10) || '                    .forEach(function(field) {' || chr(13) || chr(10) || '                        data.requestFieldValues[field] = fields[field];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                        var block = Jira.schema.requestTypeFields.filter(function(object) {' || chr(13) || chr(10) || '                            return object.fieldId == field;' || chr(13) || chr(10) || '                        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('                        if (typeof block[0] === ''object'' && typeof block[0].jiraSchema === ''object''' || chr(13) || chr(10) || '                            && (block[0].jiraSchema.type === ''number'' || block[0].jiraSchema.type === ''datetime'')) {' || chr(13) || chr(10) || '                            switch (block[0].jiraSchema.type) {' || chr(13) || chr(10) || '                                case ''number'':' || chr(13) || chr(10) || '                                    data.requestFieldValues[field] = parseInt(fields[field]);' || chr(13) || chr(10) || '                                    break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                                case ''datetime'':' || chr(13) || chr(10) || '                                    if (fields[field].match(/\d+[.-]\d+[.-]\d+T\d+:\d+:\d+/) !== null) {' || chr(13) || chr(10) || '                                        data.requestFieldValues[field] = fields[field].replace(/\./g, ''-'');' || chr(13) || chr(10) || '                                    }' || chr(13) || chr(10) || '                                    else {' || chr(13) || chr(10) || '                                        delete data.requestFieldValues[field];' || chr(13) || chr(10) || '                                    }' || chr(13) || chr(10) || '                                    break;' || chr(13) || chr(10) || '                            }' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '                    });' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ Jira Service Desk Webhook ] Cannot add custom fields'' +' || chr(13) || chr(10) || '                    ''because failed to retrieve field schema.'');' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return data;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    request: function (method, query, data) {' || chr(13) || chr(10) || '        [''url'', ''user'', ''password'', ''servicedesk_id'', ''request_type_id''].forEach(function (field) {' || chr(13) || chr(10) || '            if (typeof Jira.params !== ''object'' || typeof Jira.params[field] === ''undefined''' || chr(13) || chr(10) || '                || Jira.params[field] === '''' ) {' || chr(13) || chr(10) || '                throw ''Required Jira param is not set: "'' + field + ''".'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            url = Jira.params.url + query,' || chr(13) || chr(10) || '            request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '        request.addHeader(''Authorization: Basic '' + btoa(Jira.params.user + '':'' + Jira.params.password));' || chr(13) || chr(10) || '        request.addHeader(''X-ExperimentalApi: opt-in'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof Jira.HTTPProxy !== ''undefined'' && Jira.HTTPProxy !== '''') {' || chr(13) || chr(10) || '            request.setProxy(Jira.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ Jira Service Desk Webhook ] Sending request: '' + url +' || chr(13) || chr(10) || '            ((typeof data === ''string'') ? (''\n'' + data) : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (method) {' || chr(13) || chr(10) || '            case ''get'':' || chr(13) || chr(10) || '                response = request.get(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '            case ''post'':' || chr(13) || chr(10) || '                response = request.post(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''put'':' || chr(13) || chr(10) || '                response = request.put(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                throw ''Unsupported HTTP request method: '' + method;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ Jira Service Desk Webhook ] Received response with status code '' +' || chr(13) || chr(10) || '            request.getStatus() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ Jira Service Desk Webhook ] Failed to parse response received from Jira'');' || chr(13) || chr(10) || '                response = null;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() < 200 || request.getStatus() >= 300) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (response !== null && typeof response.errors !== ''undefined''' || chr(13) || chr(10) || '                && Object.keys(response.errors).length > 0) {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.errors);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '')||
TO_NCLOB('            else if (response !== null && typeof response.errorMessage !== ''undefined''' || chr(13) || chr(10) || '                && Object.keys(response.errorMessage).length > 0) {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.errorMessage);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            throw message + '' Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return {' || chr(13) || chr(10) || '            status: request.getStatus(),' || chr(13) || chr(10) || '            response: response' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    getSchema: function() {' || chr(13) || chr(10) || '        var result = Jira.request(''get'', ''servicedesk/'' + Jira.params.servicedesk_id + ''/requesttype/'' +' || chr(13) || chr(10) || '            Jira.params.request_type_id + ''/field'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof Jira.schema !== ''object'' && typeof Jira.schema.requestTypeFields !== ''object'') {' || chr(13) || chr(10) || '            Jira.schema = null;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            Jira.schema = result.response;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    createRequest: function(summary, description, fields) {' || chr(13) || chr(10) || '        var data = {' || chr(13) || chr(10) || '            serviceDeskId: Jira.params.servicedesk_id,' || chr(13) || chr(10) || '            requestTypeId: Jira.params.request_type_id,' || chr(13) || chr(10) || '            requestFieldValues: {' || chr(13) || chr(10) || '                summary: summary,' || chr(13) || chr(10) || '                description: description' || chr(13) || chr(10) || '')||
TO_NCLOB('            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (Jira.labels && Jira.labels.length > 0) {' || chr(13) || chr(10) || '            data.requestFieldValues.labels = Jira.labels;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        var result = Jira.request(''post'', ''request'', Jira.addCustomFields(data, fields));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof result.response !== ''object'' || typeof result.response.issueKey === ''undefined'') {' || chr(13) || chr(10) || '            throw ''Cannot create Jira request. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return result.response.issueKey;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        fields = {},' || chr(13) || chr(10) || '        jira = {},' || chr(13) || chr(10) || '        comment = {public: true},' || chr(13) || chr(10) || '        result = {tags: {}},' || chr(13) || chr(10) || '        required_params = [' || chr(13) || chr(10) || '            ''alert_subject'', ''alert_message'', ''event_source'', ''event_value'',' || chr(13) || chr(10) || '            ''event_update_status'', ''event_recovery_value''' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (key.startsWith(''jira_'')) {' || chr(13) || chr(10) || '                jira[key.substring(5)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''customfield_'')) {' || chr(13) || chr(10) || '                fields[key] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '')||
TO_NCLOB('            else if (required_params.indexOf(key) !== -1 && params[key] === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" cannot be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'' && params.event_source === ''0'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_recovery_value === ''0'') {' || chr(13) || chr(10) || '        throw ''Recovery operations are supported only for trigger-based actions.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Jira.setParams(jira);' || chr(13) || chr(10) || '    Jira.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    Jira.getSchema();' || chr(13) || chr(10) || '')||
TO_NCLOB('    Jira.setTags(params.event_tags_json);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Create request for non trigger-based events.' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_recovery_value !== ''0'') {' || chr(13) || chr(10) || '        Jira.createRequest(params.alert_subject, params.alert_message);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Create request for trigger-based events.' || chr(13) || chr(10) || '    else if (params.event_value === ''1'' && params.event_update_status === ''0''' || chr(13) || chr(10) || '        && jira.request_key === ''{EVENT.TAGS.__zbx_jira_requestkey}'') {' || chr(13) || chr(10) || '        var key = Jira.createRequest(params.alert_subject, params.alert_message, fields);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result.tags.__zbx_jira_requestkey = key;' || chr(13) || chr(10) || '        result.tags.__zbx_jira_requestlink = params.jira_url +' || chr(13) || chr(10) || '            (params.jira_url.endsWith(''/'') ? '''' : ''/'') + ''browse/'' + key;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Comment created request for trigger-based event.' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        if (jira.request_key === ''{EVENT.TAGS.__zbx_jira_requestkey}'' || jira.request_key.trim() === '''') {' || chr(13) || chr(10) || '            throw ''Incorrect Request key given: '' + jira.request_key;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        comment.body = params.alert_message;' || chr(13) || chr(10) || '        Jira.request(''post'', ''request/'' + Jira.params.request_key + ''/comment'', comment);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return JSON.stringify(result);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ Jira Service Desk Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_jira_requestlink}','Jira ServiceDesk: {EVENT.TAGS.__zbx_jira_requestkey}','')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description)
values ('21','4','OTRS','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',TO_NCLOB('var OTRS = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '    entrypoint: ''nph-genericinterface.pl/Webservice/ZabbixTicketConnector/Ticket'',' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        OTRS.params = params;' || chr(13) || chr(10) || '        if (typeof OTRS.params.url === ''string'') {' || chr(13) || chr(10) || '            if (!OTRS.params.url.endsWith(''/'')) {' || chr(13) || chr(10) || '                OTRS.params.url += ''/'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    addDynamicFields: function (data, fields) {' || chr(13) || chr(10) || '        if (typeof fields === ''object'' && Object.keys(fields).length) {' || chr(13) || chr(10) || '            data.DynamicField = [];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            Object.keys(fields)' || chr(13) || chr(10) || '                .forEach(function(field) {' || chr(13) || chr(10) || '                    if (field !== undefined) {' || chr(13) || chr(10) || '                        if (fields[field].match(/^\d{4}[.-]\d{2}[.-]\d{2}$/)) {' || chr(13) || chr(10) || '                            fields[field] = fields[field].replace(/\./g, ''-'');' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                        data.DynamicField.push({Name: field, Value: fields[field]});' || chr(13) || chr(10) || '                    }' || chr(13) || chr(10) || '                });' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return data;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    request: function (method, query, data) {' || chr(13) || chr(10) || '        [''url'', ''auth_user'', ''auth_password'', ''queue'',' || chr(13) || chr(10) || '            ''customer'', ''ticket_state'', ''default_priority_id'', ''time_unit''].forEach(function (field) {' || chr(13) || chr(10) || '            if (typeof OTRS.params !== ''object'' || typeof OTRS.params[field] === ''undefined''' || chr(13) || chr(10) || '                || OTRS.params[field] === '''' ) {' || chr(13) || chr(10) || '                throw ''Required param is not set: "'' + field + ''".'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            request = new HttpRequest(),' || chr(13) || chr(10) || '            url = OTRS.params.url + query +' || chr(13) || chr(10) || '                ''?UserLogin='' + encodeURIComponent(OTRS.params.auth_user) +' || chr(13) || chr(10) || '                ''&Password='' + encodeURIComponent(OTRS.params.auth_password);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof OTRS.HTTPProxy !== ''undefined'' && OTRS.HTTPProxy.trim() !== '''') {' || chr(13) || chr(10) || '            request.setProxy(OTRS.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ OTRS Webhook ] Sending request: '' +' || chr(13) || chr(10) || '            url + ((typeof data === ''string'') ? ('' '' + data) : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (method) {' || chr(13) || chr(10) || '            case ''get'':' || chr(13) || chr(10) || '')||
TO_NCLOB('                response = request.get(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''post'':' || chr(13) || chr(10) || '                response = request.post(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''put'':' || chr(13) || chr(10) || '                response = request.put(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                throw ''Unsupported HTTP request method: '' + method;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ OTRS Webhook ] Received response with status code '' + request.getStatus() + '': '' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() < 200 || request.getStatus() >= 300) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            message += '': '' + response;' || chr(13) || chr(10) || '            throw message + '' Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ OTRS Webhook ] Failed to parse response received from OTRS'');' || chr(13) || chr(10) || '                response = null;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('        if (typeof response.Error !== ''undefined''' || chr(13) || chr(10) || '            && Object.keys(response.Error).length > 0) {' || chr(13) || chr(10) || '            message = ''Request failed: '' + JSON.stringify(response.Error);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return {' || chr(13) || chr(10) || '            status: request.getStatus(),' || chr(13) || chr(10) || '            response: response' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    createTicket: function(subject, message, priority, fields) {' || chr(13) || chr(10) || '        var result,' || chr(13) || chr(10) || '            data = {' || chr(13) || chr(10) || '                Ticket: {' || chr(13) || chr(10) || '                    Title: subject,' || chr(13) || chr(10) || '                    Queue: OTRS.params.queue,' || chr(13) || chr(10) || '                    State: OTRS.params.ticket_state,' || chr(13) || chr(10) || '                    PriorityID: priority || OTRS.params.default_priority_id,' || chr(13) || chr(10) || '                    CustomerUser: OTRS.params.customer' || chr(13) || chr(10) || '                },' || chr(13) || chr(10) || '                Article: {' || chr(13) || chr(10) || '                    Subject: subject,' || chr(13) || chr(10) || '                    Body: message,' || chr(13) || chr(10) || '                    TimeUnit: OTRS.params.time_unit,' || chr(13) || chr(10) || '                    ContentType: ''text/plain; charset=utf8''' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result = OTRS.request(''post'', OTRS.entrypoint, OTRS.addDynamicFields(data, fields));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof result.response !== ''object''' || chr(13) || chr(10) || '            || typeof result.response.TicketID === ''undefined''' || chr(13) || chr(10) || '')||
TO_NCLOB('            || result.status != 200) {' || chr(13) || chr(10) || '            throw ''Cannot create OTRS ticket. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return result.response.TicketID;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    updateTicket: function(subject, message) {' || chr(13) || chr(10) || '        var result,' || chr(13) || chr(10) || '            data = {' || chr(13) || chr(10) || '                Article: {' || chr(13) || chr(10) || '                    Subject: subject,' || chr(13) || chr(10) || '                    Body: message || '''',' || chr(13) || chr(10) || '                    TimeUnit: OTRS.params.time_unit,' || chr(13) || chr(10) || '                    ContentType: ''text/plain; charset=utf8''' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result = OTRS.request(''put'', OTRS.entrypoint + ''/'' + encodeURIComponent(OTRS.params.ticket_id), data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof result.response !== ''object''' || chr(13) || chr(10) || '            || typeof result.response.TicketID === ''undefined''' || chr(13) || chr(10) || '            || result.status != 200) {' || chr(13) || chr(10) || '            throw ''Cannot update OTRS ticket. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        params_otrs = {},' || chr(13) || chr(10) || '        params_fields = {},' || chr(13) || chr(10) || '        params_update = {},' || chr(13) || chr(10) || '        result = {tags: {}},' || chr(13) || chr(10) || '        required_params = [' || chr(13) || chr(10) || '')||
TO_NCLOB('            ''alert_subject'', ''event_source'',' || chr(13) || chr(10) || '            ''event_value'',  ''event_update_status''' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        severities = [' || chr(13) || chr(10) || '            {name: ''not_classified'', color: ''#97AAB3''},' || chr(13) || chr(10) || '            {name: ''information'', color: ''#7499FF''},' || chr(13) || chr(10) || '            {name: ''warning'', color: ''#FFC859''},' || chr(13) || chr(10) || '            {name: ''average'', color: ''#FFA059''},' || chr(13) || chr(10) || '            {name: ''high'', color: ''#E97659''},' || chr(13) || chr(10) || '            {name: ''disaster'', color: ''#E45959''},' || chr(13) || chr(10) || '            {name: ''resolved'', color: ''#009900''},' || chr(13) || chr(10) || '            {name: null, color: ''#000000''}' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        priority;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (key.startsWith(''otrs_'')) {' || chr(13) || chr(10) || '                params_otrs[key.substring(5)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''dynamicfield_'')) {' || chr(13) || chr(10) || '                params_fields[key.substring(13)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''event_update_'')) {' || chr(13) || chr(10) || '                params_update[key.substring(13)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (required_params.indexOf(key) !== -1 && params[key].trim() === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" cannot be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '    if (params.event_source === ''0'' && params.event_update_status !== ''0'' && params.event_update_status !== ''1'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_value === ''0'') {' || chr(13) || chr(10) || '        throw ''Recovery operations are supported only for trigger-based actions.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source === ''0''' || chr(13) || chr(10) || '        && ((params.event_value === ''1'' && params.event_update_status === ''1'')' || chr(13) || chr(10) || '            || (params.event_value === ''0''' || chr(13) || chr(10) || '                && (params.event_update_status === ''0'' || params.event_update_status === ''1'')))' || chr(13) || chr(10) || '        && (isNaN(parseInt(params.otrs_ticket_id)) || parseInt(params.otrs_ticket_id) < 1 )) {' || chr(13) || chr(10) || '')||
TO_NCLOB('        throw ''Incorrect "otrs_ticket_id" parameter given: '' + params.otrs_ticket_id +' || chr(13) || chr(10) || '            ''\nMust be positive integer.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {' || chr(13) || chr(10) || '        params.event_nseverity = ''7'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value === ''0'') {' || chr(13) || chr(10) || '        params.event_nseverity = ''6'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    priority = params[''severity_'' + severities[params.event_nseverity].name];' || chr(13) || chr(10) || '    priority = priority && priority.trim() || severities[7].name;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    OTRS.setParams(params_otrs);' || chr(13) || chr(10) || '    OTRS.HTTPProxy = params.HTTPProxy;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Create ticket for non trigger-based events.' || chr(13) || chr(10) || '    if (params.event_source !== ''0''' || chr(13) || chr(10) || '        && params.event_value !== ''0'') {' || chr(13) || chr(10) || '        OTRS.createTicket(params.alert_subject, params.alert_message, priority);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Create ticket for trigger-based events.' || chr(13) || chr(10) || '    else if (params.event_value === ''1'' && params_update.status === ''0'') {' || chr(13) || chr(10) || '        var ticket_id = OTRS.createTicket(params.alert_subject,' || chr(13) || chr(10) || '            params.alert_subject + ''\n'' + params.alert_message + ''\n'' +' || chr(13) || chr(10) || '            params.zabbix_url + (params.zabbix_url.endsWith(''/'') ? '''' : ''/'') +' || chr(13) || chr(10) || '            ''tr_events.php?triggerid='' + params.trigger_id + ''&eventid='' + params.event_id + ''\n'',' || chr(13) || chr(10) || '            priority,' || chr(13) || chr(10) || '')||
TO_NCLOB('            params_fields);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result.tags.__zbx_otrs_ticket_id = ticket_id;' || chr(13) || chr(10) || '        result.tags.__zbx_otrs_ticketlink = params.otrs_url +' || chr(13) || chr(10) || '            (params.otrs_url.endsWith(''/'') ? '''' : ''/'') + ''index.pl?Action=AgentTicketZoom;TicketID='' + ticket_id;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Update created ticket for trigger-based event.' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        OTRS.updateTicket(params.alert_subject, params.alert_message);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return JSON.stringify(result);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ OTRS Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_otrs_ticketlink}','OTRS: ticket #{EVENT.TAGS.__zbx_otrs_ticket_id}','')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description)
values ('22','4','iLert','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',TO_NCLOB('try {' || chr(13) || chr(10) || '    var result = { tags: {} },' || chr(13) || chr(10) || '        params = JSON.parse(value),' || chr(13) || chr(10) || '        req = new HttpRequest(),' || chr(13) || chr(10) || '        resp = '''';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.HTTPProxy === ''string'' && params.HTTPProxy.trim() !== '''') {' || chr(13) || chr(10) || '        req.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    var alertSourceKey = params[''.ILERT.ALERT.SOURCE.KEY''];' || chr(13) || chr(10) || '    if (!alertSourceKey || (typeof alertSourceKey === ''string'' && alertSourceKey.trim() === '''')) {' || chr(13) || chr(10) || '        throw ''incorrect value for variable "ILERT.ALERT.SOURCE.KEY". The value must be a non-empty string.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    delete params[''.ILERT.ALERT.SOURCE.KEY''];' || chr(13) || chr(10) || '    ' || chr(13) || chr(10) || '    var ilertApiBaseURL = "https://api.ilert.com";' || chr(13) || chr(10) || '    var reqURL = encodeURI(ilertApiBaseURL + "/api/v1/events/zabbix-mt/" + alertSourceKey)' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var incidentKey = "zabbix-" + params[''EVENT.ID''];' || chr(13) || chr(10) || '    var incidentViewURL = ilertApiBaseURL + "/api/v1/incidents/resolve-ik/" + alertSourceKey + "/" + incidentKey;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    req.addHeader(''Accept: application/json'');' || chr(13) || chr(10) || '    req.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Zabbix.log(4, ''[iLert Webhook] Sending request:'' + JSON.stringify(params));' || chr(13) || chr(10) || '    resp = req.post(reqURL, JSON.stringify(params));' || chr(13) || chr(10) || '    Zabbix.log(4, ''[iLert Webhook] Receiving response:'' + resp);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    try {' || chr(13) || chr(10) || '')||
TO_NCLOB('        resp = JSON.parse(resp);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    catch (error) {' || chr(13) || chr(10) || '        throw ''incorrect response. iLert returned a non-JSON object.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (req.getStatus() == 200) {' || chr(13) || chr(10) || '        result.tags.__ilert_incident_url = incidentViewURL;' || chr(13) || chr(10) || '        return JSON.stringify(result);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (req.getStatus() == 400 && typeof resp === ''object'' && typeof resp.code === ''string'') {' || chr(13) || chr(10) || '        if (resp.code === ''NO_OPEN_INCIDENT_WITH_KEY'') {' || chr(13) || chr(10) || '          return JSON.stringify(result);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        if (resp.code === ''INCIDENT_ALREADY_ACCEPTED'') {' || chr(13) || chr(10) || '          result.tags.__ilert_incident_url = incidentViewURL;' || chr(13) || chr(10) || '          return JSON.stringify(result);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof resp === ''object'' && typeof resp.message === ''string'') {' || chr(13) || chr(10) || '        throw resp.message;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        throw ''Unknown error.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[iLert Webhook] Notification failed : '' + error);' || chr(13) || chr(10) || '    throw ''iLert notification failed : '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__ilert_incident_url}','iLert incident','Please refer to https://docs.ilert.com/integrations/zabbix/native ' || chr(13) || chr(10) || '  ' || chr(13) || chr(10) || 'Set global macro {$ZABBIX.URL} with your Zabbix server URL.' || chr(13) || chr(10) || 'Add a dedicated user with the media type "iLert". You can also rewrite the incident summary via ".ILERT.INCIDENT.SUMMARY" parameter or leave it empty to use the standard pattern.')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description)
values ('23','4','SolarWinds Service Desk','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',TO_NCLOB('var SolarWinds = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        SolarWinds.params = params;' || chr(13) || chr(10) || '        SolarWinds.params.endpoint = ''https://api.samanage.com/'';' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setProxy: function (HTTPProxy) {' || chr(13) || chr(10) || '        SolarWinds.HTTPProxy = HTTPProxy;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    addCustomFields: function (data, fields) {' || chr(13) || chr(10) || '        if (typeof data.incident === ''object'' && typeof fields === ''object'' && Object.keys(fields).length) {' || chr(13) || chr(10) || '            if (typeof fields.sw_fields === ''object'' && Object.keys(fields.sw_fields).length) {' || chr(13) || chr(10) || '                Object.keys(fields.sw_fields)' || chr(13) || chr(10) || '                    .forEach(function(field) {' || chr(13) || chr(10) || '                        try {' || chr(13) || chr(10) || '                            data.incident[field] = JSON.parse(fields.sw_fields[field]);' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '                        catch (error) {' || chr(13) || chr(10) || '                            data.incident[field] = fields.sw_fields[field];' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '                    });' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (typeof fields.sw_customfields === ''object'' && Object.keys(fields.sw_customfields).length) {' || chr(13) || chr(10) || '')||
TO_NCLOB('                data.incident.custom_fields_values = {custom_fields_value: []};' || chr(13) || chr(10) || '                Object.keys(fields.sw_customfields)' || chr(13) || chr(10) || '                    .forEach(function(field) {' || chr(13) || chr(10) || '                        data.incident.custom_fields_values.custom_fields_value.push({' || chr(13) || chr(10) || '                            name: field,' || chr(13) || chr(10) || '                            value: fields.sw_customfields[field]' || chr(13) || chr(10) || '                        });' || chr(13) || chr(10) || '                    });' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return data;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (method, query, data) {' || chr(13) || chr(10) || '        [''token''].forEach(function (field) {' || chr(13) || chr(10) || '            if (typeof SolarWinds.params !== ''object'' || typeof SolarWinds.params[field] === ''undefined''' || chr(13) || chr(10) || '                || SolarWinds.params[field] === '''' ) {' || chr(13) || chr(10) || '                throw ''Required SolarWinds param is not set: "'' + field + ''".'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            url = SolarWinds.params.endpoint + query,' || chr(13) || chr(10) || '            request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '        request.addHeader(''X-Samanage-Authorization: Bearer '' + SolarWinds.params.token);' || chr(13) || chr(10) || '        request.addHeader(''Accept: application/vnd.samanage.v2.1+json'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof SolarWinds.HTTPProxy !== ''undefined'' && SolarWinds.HTTPProxy !== '''') {' || chr(13) || chr(10) || '')||
TO_NCLOB('            request.setProxy(SolarWinds.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ SolarWinds SD Webhook ] Sending request: '' + url + ((typeof data === ''string'')' || chr(13) || chr(10) || '            ? (''\n'' + data)' || chr(13) || chr(10) || '            : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (method) {' || chr(13) || chr(10) || '            case ''get'':' || chr(13) || chr(10) || '                response = request.get(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''post'':' || chr(13) || chr(10) || '                response = request.post(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''put'':' || chr(13) || chr(10) || '                response = request.put(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                throw ''Unsupported HTTP request method: '' + method;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ SolarWinds SD Webhook ] Received response with status code '' + request.getStatus() +' || chr(13) || chr(10) || '            ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '')||
TO_NCLOB('                Zabbix.log(4, ''[ SolarWinds SD Webhook ] Failed to parse response received from SolarWinds'');' || chr(13) || chr(10) || '                response = null;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() < 200 || request.getStatus() >= 300) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (response !== null && typeof response.error !== ''undefined''' || chr(13) || chr(10) || '                && Object.keys(response.error).length > 0) {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.error);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (response !== null && typeof response === ''object''' || chr(13) || chr(10) || '                && Object.keys(response).length > 0) {' || chr(13) || chr(10) || '                Object.keys(response)' || chr(13) || chr(10) || '                    .forEach(function(field) {' || chr(13) || chr(10) || '                        message += ''\n'' + field + '': '' + response[field][0];' || chr(13) || chr(10) || '                    });' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            throw message + '' Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return {' || chr(13) || chr(10) || '            status: request.getStatus(),' || chr(13) || chr(10) || '            response: response' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    createIncident: function(name, description, fields) {' || chr(13) || chr(10) || '        var data = {' || chr(13) || chr(10) || '            incident: {' || chr(13) || chr(10) || '')||
TO_NCLOB('                name: name,' || chr(13) || chr(10) || '                description: description,' || chr(13) || chr(10) || '                priority: SolarWinds.params.priority' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var result = SolarWinds.request(''post'', ''incidents.json'', SolarWinds.addCustomFields(data, fields));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof result.response !== ''object'' || typeof result.response.id === ''undefined'') {' || chr(13) || chr(10) || '            throw ''Cannot create SolarWinds incident. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return result.response.id;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    updateIncident: function(name, fields, message) {' || chr(13) || chr(10) || '        var data = {' || chr(13) || chr(10) || '            incident: {' || chr(13) || chr(10) || '                name: name,' || chr(13) || chr(10) || '                priority: SolarWinds.params.priority' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        SolarWinds.request(' || chr(13) || chr(10) || '            ''put'',' || chr(13) || chr(10) || '            ''incidents/'' + SolarWinds.params.incident_id + ''.json'',' || chr(13) || chr(10) || '            SolarWinds.addCustomFields(data, fields));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        SolarWinds.commenIncident(message);' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    commenIncident: function(message) {' || chr(13) || chr(10) || '        var data = {' || chr(13) || chr(10) || '            comment: {' || chr(13) || chr(10) || '                body: message' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '        SolarWinds.request(''post'', ''incidents/'' + SolarWinds.params.incident_id + ''/comments.json'', data);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        fields = {},' || chr(13) || chr(10) || '        samanage = {},' || chr(13) || chr(10) || '        result = {tags: {}},' || chr(13) || chr(10) || '        required_params = [''alert_subject'', ''event_recovery_value'', ''event_source'', ''event_value'', ''priority_default''],' || chr(13) || chr(10) || '        severities = [' || chr(13) || chr(10) || '            {name: ''not_classified''},' || chr(13) || chr(10) || '            {name: ''information''},' || chr(13) || chr(10) || '            {name: ''warning''},' || chr(13) || chr(10) || '            {name: ''average''},' || chr(13) || chr(10) || '            {name: ''high''},' || chr(13) || chr(10) || '            {name: ''disaster''},' || chr(13) || chr(10) || '            {name: ''resolved''},' || chr(13) || chr(10) || '            {name: ''default''}' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    fields.sw_fields = {};' || chr(13) || chr(10) || '    fields.sw_customfields = {};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (key.startsWith(''samanage_'')) {' || chr(13) || chr(10) || '                samanage[key.substring(9)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''sw_field_'')) {' || chr(13) || chr(10) || '                fields.sw_fields[key.substring(9)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''sw_customfield_'')) {' || chr(13) || chr(10) || '')||
TO_NCLOB('                fields.sw_customfields[key.substring(15)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (required_params.indexOf(key) !== -1 && params[key] === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" can\''t be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'' && params.event_source === ''0'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_recovery_value === ''0'') {' || chr(13) || chr(10) || '        throw ''Recovery operations are supported only for trigger-based actions.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {' || chr(13) || chr(10) || '        params.event_nseverity = ''7'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value === ''0'') {' || chr(13) || chr(10) || '        params.event_nseverity = ''6'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    samanage.priority = params[''priority_'' + severities[params.event_nseverity].name] || params.priority_default;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    SolarWinds.setParams(samanage);' || chr(13) || chr(10) || '    SolarWinds.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Create incident for non trigger-based events.' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_recovery_value !== ''0'') {' || chr(13) || chr(10) || '        SolarWinds.createIncident(params.alert_subject, params.alert_message);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Create incident for trigger-based events.' || chr(13) || chr(10) || '    else if (params.event_value === ''1'' && params.event_update_status === ''0''' || chr(13) || chr(10) || '            && samanage.incident_id === ''{EVENT.TAGS.__zbx_solarwinds_inc_id}'') {' || chr(13) || chr(10) || '        var key = SolarWinds.createIncident(params.alert_subject, params.alert_message, fields);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result.tags.__zbx_solarwinds_inc_id = key;' || chr(13) || chr(10) || '        result.tags.__zbx_solarwinds_inc_link = params.samanage_url +' || chr(13) || chr(10) || '            (params.samanage_url.endsWith(''/'') ? '''' : ''/'') + ''incidents/'' + key;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Update created incident for trigger-based event.' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        if (samanage.incident_id === ''{EVENT.TAGS.__zbx_solarwinds_inc_id}'' || samanage.incident_id === '''') {' || chr(13) || chr(10) || '')||
TO_NCLOB('            throw ''Incorrect incident key given: '' + samanage.incident_id;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        if (!params.alert_message) {' || chr(13) || chr(10) || '            throw ''Parameter "alert_message" can\''t be empty.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        SolarWinds.updateIncident(params.alert_subject, fields, params.alert_message);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source === ''0'') {' || chr(13) || chr(10) || '        return JSON.stringify(result);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        return ''OK'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ SolarWinds SD Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_solarwinds_inc_link}','SolarWinds incident ID: {EVENT.TAGS.__zbx_solarwinds_inc_id}','')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description)
values ('24','4','SysAid','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',TO_NCLOB('var SysAid = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        var required = [''url'', ''auth_user'', ''auth_password'', ''category_level_1'', ''category_level_2'',' || chr(13) || chr(10) || '            ''category_level_3'', ''incident_id'', ''template_id'', ''urgency_id'', ''incident_state'',' || chr(13) || chr(10) || '            ''default_priority_id''' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        required.forEach(function (field) {' || chr(13) || chr(10) || '            if (typeof params !== ''object'' || typeof params[field] === ''undefined'' || params[field] === '''') {' || chr(13) || chr(10) || '                throw ''Required param is not set: "'' + field + ''".'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        SysAid.params = params;' || chr(13) || chr(10) || '        if (typeof SysAid.params.url === ''string'' && !SysAid.params.url.endsWith(''/'')) {' || chr(13) || chr(10) || '            SysAid.params.url += ''/'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    login: function () {' || chr(13) || chr(10) || '        var result = SysAid.request(''post'', ''api/v1/login'', {' || chr(13) || chr(10) || '            user_name: SysAid.params.auth_user,' || chr(13) || chr(10) || '            password: SysAid.params.auth_password' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return result.response.user.id;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (method, query, data) {' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '')||
TO_NCLOB('            request = SysAid.req || (SysAid.req = new HttpRequest()),' || chr(13) || chr(10) || '            url = SysAid.params.url + query;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof SysAid.HTTPProxy !== ''undefined'' && SysAid.HTTPProxy.trim() !== '''') {' || chr(13) || chr(10) || '            request.setProxy(SysAid.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ SysAid Webhook ] Sending request: '' +' || chr(13) || chr(10) || '            url + ((typeof data === ''string'') ? ('' '' + data) : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (method) {' || chr(13) || chr(10) || '            case ''get'':' || chr(13) || chr(10) || '                response = request.get(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''post'':' || chr(13) || chr(10) || '                response = request.post(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''put'':' || chr(13) || chr(10) || '                response = request.put(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                throw ''Unsupported HTTP request method: '' + method;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ SysAid Webhook ] Received response with status code '' + request.getStatus() + '': '' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() !== 200) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '            message += '': '' + response;' || chr(13) || chr(10) || '            throw message + '' Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ SysAid Webhook ] Failed to parse response received from SysAid'');' || chr(13) || chr(10) || '                response = null;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response === null || (typeof response.Error !== ''undefined'' && Object.keys(response.Error).length > 0)) {' || chr(13) || chr(10) || '            throw ''Request failed: '' + JSON.stringify(response.Error);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return {' || chr(13) || chr(10) || '            status: request.getStatus(),' || chr(13) || chr(10) || '            response: response' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    createIncident: function(subject, message, priority) {' || chr(13) || chr(10) || '        var result = SysAid.request(''post'', ''api/v1/sr/?template='' + encodeURIComponent(SysAid.params.template_id), {' || chr(13) || chr(10) || '            info: [' || chr(13) || chr(10) || '                {' || chr(13) || chr(10) || '                    key: ''problem_type'',' || chr(13) || chr(10) || '                    value: [' || chr(13) || chr(10) || '                        SysAid.params.category_level_1,' || chr(13) || chr(10) || '                        SysAid.params.category_level_2,' || chr(13) || chr(10) || '')||
TO_NCLOB('                        SysAid.params.category_level_3' || chr(13) || chr(10) || '                    ].join(''_'')' || chr(13) || chr(10) || '                },' || chr(13) || chr(10) || '                {' || chr(13) || chr(10) || '                    key: ''title'',' || chr(13) || chr(10) || '                    value: subject' || chr(13) || chr(10) || '                },' || chr(13) || chr(10) || '                {' || chr(13) || chr(10) || '                    key: ''description'',' || chr(13) || chr(10) || '                    value: message' || chr(13) || chr(10) || '                },' || chr(13) || chr(10) || '                {' || chr(13) || chr(10) || '                    key: ''status'',' || chr(13) || chr(10) || '                    value: ''1''' || chr(13) || chr(10) || '                },' || chr(13) || chr(10) || '                {' || chr(13) || chr(10) || '                    key: ''urgency'',' || chr(13) || chr(10) || '                    value: SysAid.params.urgency_id' || chr(13) || chr(10) || '                },' || chr(13) || chr(10) || '                {' || chr(13) || chr(10) || '                    key: ''priority'',' || chr(13) || chr(10) || '                    value: priority || SysAid.params.default_priority_id,' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            ]' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (result.response.id === ''undefined'') {' || chr(13) || chr(10) || '            throw ''Cannot create SysAid incident. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return result.response.id;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    updateTicket: function(note) {' || chr(13) || chr(10) || '        var date = new Date().getTime();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('        SysAid.request(''put'', ''api/v1/sr/'' + encodeURIComponent(SysAid.params.incident_id), {' || chr(13) || chr(10) || '            id: SysAid.params.incident_id,' || chr(13) || chr(10) || '            info: [' || chr(13) || chr(10) || '                {' || chr(13) || chr(10) || '                    key: ''update_time'',' || chr(13) || chr(10) || '                    value: date' || chr(13) || chr(10) || '                },' || chr(13) || chr(10) || '                {' || chr(13) || chr(10) || '                    key: ''notes'',' || chr(13) || chr(10) || '                    value: [' || chr(13) || chr(10) || '                        {' || chr(13) || chr(10) || '                            userName: ''Zabbix'',' || chr(13) || chr(10) || '                            createDate: date,' || chr(13) || chr(10) || '                            text: note' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '                    ]' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            ]' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        params_sysaid = {},' || chr(13) || chr(10) || '        params_update = {},' || chr(13) || chr(10) || '        result = {tags: {}},' || chr(13) || chr(10) || '        required_params = [''alert_subject'', ''event_source'', ''event_value'',  ''event_update_status''],' || chr(13) || chr(10) || '        severities = [' || chr(13) || chr(10) || '            {name: ''not_classified'', color: ''#97AAB3''},' || chr(13) || chr(10) || '            {name: ''information'', color: ''#7499FF''},' || chr(13) || chr(10) || '            {name: ''warning'', color: ''#FFC859''},' || chr(13) || chr(10) || '            {name: ''average'', color: ''#FFA059''},' || chr(13) || chr(10) || '            {name: ''high'', color: ''#E97659''},' || chr(13) || chr(10) || '')||
TO_NCLOB('            {name: ''disaster'', color: ''#E45959''},' || chr(13) || chr(10) || '            {name: ''resolved'', color: ''#009900''},' || chr(13) || chr(10) || '            {name: null, color: ''#000000''}' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        priority;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (key.startsWith(''sysaid_'')) {' || chr(13) || chr(10) || '                params_sysaid[key.substring(7)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''event_update_'')) {' || chr(13) || chr(10) || '                params_update[key.substring(13)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (required_params.indexOf(key) !== -1 && params[key].trim() === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" cannot be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '')||
TO_NCLOB('    if (params.event_source === ''0'' && params.event_update_status !== ''0'' && params.event_update_status !== ''1'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_value === ''0'') {' || chr(13) || chr(10) || '        throw ''Recovery operations are supported only for trigger-based actions.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source === ''0'' && ((params.event_value === ''1'' && params.event_update_status === ''1'')' || chr(13) || chr(10) || '            || (params.event_value === ''0'' && (params.event_update_status === ''0'' || params.event_update_status === ''1'')))' || chr(13) || chr(10) || '            && (isNaN(parseInt(params.sysaid_incident_id)) || parseInt(params.sysaid_incident_id) < 1 )) {' || chr(13) || chr(10) || '        throw ''Incorrect "sysaid_incident_id" parameter given: '' + params.sysaid_incident_id + ''\nMust be positive integer.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {' || chr(13) || chr(10) || '        params.event_nseverity = ''7'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value === ''0'') {' || chr(13) || chr(10) || '        params.event_nseverity = ''6'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    priority = params[''severity_'' + severities[params.event_nseverity].name];' || chr(13) || chr(10) || '    priority = priority && priority.trim() || severities[7].name;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    SysAid.setParams(params_sysaid);' || chr(13) || chr(10) || '    SysAid.HTTPProxy = params.HTTPProxy;' || chr(13) || chr(10) || '')||
TO_NCLOB('    SysAid.login();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_value !== ''0'') {' || chr(13) || chr(10) || '        // Create ticket for non trigger-based events.' || chr(13) || chr(10) || '        SysAid.createIncident(params.alert_subject, params.alert_message, priority);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else if (params.event_value === ''1'' && params_update.status === ''0'') {' || chr(13) || chr(10) || '        // Create ticket for trigger-based events.' || chr(13) || chr(10) || '        var incident_id = SysAid.createIncident(params.alert_subject, params.alert_subject + ''\n'' + params.alert_message +' || chr(13) || chr(10) || '                ''\n'' + params.zabbix_url + (params.zabbix_url.endsWith(''/'') ? '''' : ''/'') + ''tr_events.php?triggerid='' +' || chr(13) || chr(10) || '                params.trigger_id + ''&eventid='' + params.event_id + ''\n'', priority' || chr(13) || chr(10) || '        );' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result.tags.__zbx_sysaid_incident_id = incident_id;' || chr(13) || chr(10) || '        result.tags.__zbx_sysaid_incidentlink = params.sysaid_url +' || chr(13) || chr(10) || '            (params.sysaid_url.endsWith(''/'') ? '''' : ''/'') + ''SREdit.jsp?id='' + incident_id + ''&fromId=IncidentsList'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        // Update created ticket for trigger-based event.' || chr(13) || chr(10) || '        SysAid.updateTicket(params.alert_subject + ''\n'' + params.alert_message);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return JSON.stringify(result);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ SysAid Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_sysaid_incidentlink}','SysAid: incident #{EVENT.TAGS.__zbx_sysaid_incident_id}','')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description)
values ('25','4','TOPdesk','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',TO_NCLOB('var Media = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '    name: '''',' || chr(13) || chr(10) || '    labels: [],' || chr(13) || chr(10) || '    HTTPProxy: '''',' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Media.params = params;' || chr(13) || chr(10) || '        Media.params.api += Media.params.api.endsWith(''/'') ? '''' : ''/'';' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setProxy: function (HTTPProxy) {' || chr(13) || chr(10) || '        if (typeof HTTPProxy !== ''undefined'' && HTTPProxy.trim() !== '''') {' || chr(13) || chr(10) || '            Media.HTTPProxy = HTTPProxy;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (method, query, data) {' || chr(13) || chr(10) || '        [''api'', ''token''].forEach(function (field) {' || chr(13) || chr(10) || '            if (typeof Media.params !== ''object'' || typeof Media.params[field] === ''undefined''' || chr(13) || chr(10) || '                    || Media.params[field] === '''') {' || chr(13) || chr(10) || '                throw ''Required '' + Media.name + '' param is not set: "'' + field + ''".'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            url = Media.params.api + query,' || chr(13) || chr(10) || '            request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '        request.addHeader(''Accept: application/json'');' || chr(13) || chr(10) || '')||
TO_NCLOB('        request.addHeader(''Authorization: '' + Media.params.token);' || chr(13) || chr(10) || '        request.setProxy(Media.HTTPProxy);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ '' + Media.name + '' Webhook ] Sending request: '' +' || chr(13) || chr(10) || '            url + ((typeof data === ''string'') ? (''\n'' + data) : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (method) {' || chr(13) || chr(10) || '            case ''get'':' || chr(13) || chr(10) || '                response = request.get(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''post'':' || chr(13) || chr(10) || '                response = request.post(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''put'':' || chr(13) || chr(10) || '                response = request.put(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                throw ''Unsupported HTTP request method: '' + method;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ '' + Media.name + '' Webhook ] Received response with status code '' +' || chr(13) || chr(10) || '            request.getStatus() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '')||
TO_NCLOB('                Zabbix.log(4, ''[ '' + Media.name + '' Webhook ] Failed to parse response.'');' || chr(13) || chr(10) || '                response = null;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() < 200 || request.getStatus() >= 300) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (response !== null) {' || chr(13) || chr(10) || '                if (typeof response.errors === ''object'' && Object.keys(response.errors).length > 0) {' || chr(13) || chr(10) || '                    message += '': '' + JSON.stringify(response.errors);' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '                else if (typeof response.errorMessages === ''object'' && Object.keys(response.errorMessages).length > 0) {' || chr(13) || chr(10) || '                    message += '': '' + JSON.stringify(response.errorMessages);' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '                else if (typeof response.message === ''string'') {' || chr(13) || chr(10) || '                    message += '': '' + response.message;' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            throw message + '' Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return {' || chr(13) || chr(10) || '            status: request.getStatus(),' || chr(13) || chr(10) || '            response: response' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var result = {tags: {}},' || chr(13) || chr(10) || '')||
TO_NCLOB('        params = JSON.parse(value),' || chr(13) || chr(10) || '        media = {},' || chr(13) || chr(10) || '        fields = {},' || chr(13) || chr(10) || '        resp = {},' || chr(13) || chr(10) || '        required_params = [' || chr(13) || chr(10) || '            ''alert_subject'',' || chr(13) || chr(10) || '            ''alert_message'',' || chr(13) || chr(10) || '            ''event_id'',' || chr(13) || chr(10) || '            ''event_source'',' || chr(13) || chr(10) || '            ''event_value'',' || chr(13) || chr(10) || '            ''event_update_status'',' || chr(13) || chr(10) || '            ''topdesk_api'',' || chr(13) || chr(10) || '            ''topdesk_user'',' || chr(13) || chr(10) || '            ''topdesk_password''' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        severities = [' || chr(13) || chr(10) || '            ''not_classified'',' || chr(13) || chr(10) || '            ''information'',' || chr(13) || chr(10) || '            ''warning'',' || chr(13) || chr(10) || '            ''average'',' || chr(13) || chr(10) || '            ''high'',' || chr(13) || chr(10) || '            ''disaster'',' || chr(13) || chr(10) || '            ''resolved'',' || chr(13) || chr(10) || '            ''default''' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        priority;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (required_params.indexOf(key) !== -1 && params[key].trim() === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" cannot be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            if (key.startsWith(''topdesk_'')) {' || chr(13) || chr(10) || '                media[key.substring(8)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Possible values of event_source:' || chr(13) || chr(10) || '')||
TO_NCLOB('    // 0 - Trigger, 1 - Discovery, 2 - Autoregistration, 3 - Internal.' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: "'' + params.event_source + ''".\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check event_value for trigger-based and internal events.' || chr(13) || chr(10) || '    // Possible values: 1 for problem, 0 for recovering' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check event_update_status only for trigger-based events.' || chr(13) || chr(10) || '    // Possible values: 0 - Webhook was called because of problem/recovery event, 1 - Update operation.' || chr(13) || chr(10) || '    if (params.event_source === ''0'' && params.event_update_status !== ''0'' && params.event_update_status !== ''1'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check event_id for a numeric value.' || chr(13) || chr(10) || '    if (isNaN(parseInt(params.event_id)) || params.event_id < 1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_id" parameter given: '' + params.event_id + ''\nMust be a positive number.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ((params.event_source === ''1'' || params.event_source === ''2'')  && params.event_value === ''0'') {' || chr(13) || chr(10) || '')||
TO_NCLOB('        throw ''Recovery operations are supported only for Trigger and Internal actions.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {' || chr(13) || chr(10) || '        params.event_nseverity = ''7'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value === ''0'') {' || chr(13) || chr(10) || '        params.event_nseverity = ''6'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    priority = params[''severity_'' + severities[params.event_nseverity]];' || chr(13) || chr(10) || '    params.zbxurl = params.zbxurl + (params.zbxurl.endsWith(''/'') ? '''' : ''/'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Media.name = ''TOPdesk'';' || chr(13) || chr(10) || '    Media.setParams(media);' || chr(13) || chr(10) || '    Media.params.token = ''Basic '' + btoa(Media.params.user + '':'' + Media.params.password);' || chr(13) || chr(10) || '    Media.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Create an issue.' || chr(13) || chr(10) || '    // Numeric value of the event that triggered an action (1 for problem, 0 for recovering).' || chr(13) || chr(10) || '    // Numeric value of the problem update status. Possible values:' || chr(13) || chr(10) || '    // 0 - Webhook was called because of problem/recovery event, 1 - Update operation.' || chr(13) || chr(10) || '    if ((params.event_source == 0 && params.event_value == 1 && params.event_update_status == 0)' || chr(13) || chr(10) || '            || (params.event_source == 3 && params.event_value == 1)' || chr(13) || chr(10) || '            || params.event_source == 1 || params.event_source == 2) {' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ '' + Media.name + '' Webhook ] Request of the ticket creating.'');' || chr(13) || chr(10) || '')||
TO_NCLOB('        fields.caller = {dynamicName: ''Zabbix''};' || chr(13) || chr(10) || '        fields.briefDescription = params.alert_subject;' || chr(13) || chr(10) || '        fields.request = params.alert_message.replace(/\n/g, ''<br>'');' || chr(13) || chr(10) || '        fields.priority = {name: priority};' || chr(13) || chr(10) || '        fields.processingStatus = {name: Media.params.status};' || chr(13) || chr(10) || '        fields.externalNumber = params.event_id;' || chr(13) || chr(10) || '        fields.request += ''<br>'' + params.zbxurl;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (params.event_source === ''0'') {' || chr(13) || chr(10) || '            fields.request += ''tr_events.php?triggerid='' + params.trigger_id + ''&eventid='' + params.event_id;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        resp = Media.request(''post'', ''tas/api/incidents'', fields);' || chr(13) || chr(10) || '        if (typeof resp.response !== ''object'' || typeof resp.response.id === ''undefined'') {' || chr(13) || chr(10) || '            throw ''Cannot create '' + Media.name + '' issue. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (params.event_source == 0 && params.event_value == 1 && params.event_update_status == 0) {' || chr(13) || chr(10) || '            result.tags.__zbx_tpd_issuekey = resp.response.number;' || chr(13) || chr(10) || '            result.tags.__zbx_tpd_issuelink = Media.params.api +' || chr(13) || chr(10) || '                ''tas/secure/incident?action=show&unid='' + resp.response.id;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Update a created issue.' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        if (params.event_source == 3 && params.event_value == 0) {' || chr(13) || chr(10) || '            throw ''Internal event recovery actions are not supported.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ '' + Media.name + '' Webhook ] Request of the ticket updating.'');' || chr(13) || chr(10) || '        fields.action = params.alert_message.replace(/\n/g, ''<br>'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        resp = Media.request(''put'', ''tas/api/incidents/number/'' + Media.params.issue_key, fields);' || chr(13) || chr(10) || '        if (typeof resp.response !== ''object'' || typeof resp.response.id === ''undefined''' || chr(13) || chr(10) || '                || resp.response.number !== Media.params.issue_key) {' || chr(13) || chr(10) || '            throw ''Cannot update '' + Media.name + '' issue. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return JSON.stringify(result);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ '' + Media.name + '' Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_tpd_issuelink}','TOPdesk: {EVENT.TAGS.__zbx_tpd_issuekey}','Please refer to https://developers.topdesk.com/documentation/index.html and https://www.zabbix.com/documentation/6.0/manual/config/notifications/media/webhook#example_scripts.' || chr(13) || chr(10) || '  ' || chr(13) || chr(10) || 'Set global macro {$ZABBIX.URL} with your Zabbix server URL.' || chr(13) || chr(10) || 'Add a dedicated user with the media type "TOPdesk".' || chr(13) || chr(10) || 'Change the values of the variables topdesk_api (URL), topdesk_password, topdesk_user. The topdesk_status is the default status for creating a new TOPdesk ticket.')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description)
values ('26','4','iTop','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',TO_NCLOB('var Itop = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (params.log !== ''private_log'' && params.log !== ''public_log'') {' || chr(13) || chr(10) || '            throw ''Incorrect "itop_log" parameter given: '' + params.log + ''\nMust be "private_log" or "public_log".'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Itop.params = params;' || chr(13) || chr(10) || '        if (typeof Itop.params.url === ''string'') {' || chr(13) || chr(10) || '            if (!Itop.params.url.endsWith(''/'')) {' || chr(13) || chr(10) || '                Itop.params.url += ''/'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            Itop.params.url += ''webservices/rest.php?version='' + encodeURIComponent(Itop.params.api_version);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setProxy: function (HTTPProxy) {' || chr(13) || chr(10) || '        Itop.HTTPProxy = HTTPProxy;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setCreatePayload: function () {' || chr(13) || chr(10) || '        json_data.operation = ''core/create'';' || chr(13) || chr(10) || '        json_data.fields.org_id = Itop.params.organization_id;' || chr(13) || chr(10) || '        json_data.fields.title = params.alert_subject;' || chr(13) || chr(10) || '        json_data.fields.description = params.alert_message.replace(''<'', ''&lt;'')' || chr(13) || chr(10) || '            .replace(''>'', ''&gt;'')' || chr(13) || chr(10) || '            .replace(/(?:\r\n|\r|\n)/g, ''<br>'');' || chr(13) || chr(10) || '')||
TO_NCLOB('    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setUpdatePayload: function () {' || chr(13) || chr(10) || '        json_data.operation = ''core/update'';' || chr(13) || chr(10) || '        json_data.key = Itop.params.id;' || chr(13) || chr(10) || '        json_data.fields.title = params.alert_subject;' || chr(13) || chr(10) || '        json_data.fields[Itop.params.log] = {' || chr(13) || chr(10) || '            add_item: {' || chr(13) || chr(10) || '                message: params.alert_subject + ''\n'' + params.alert_message,' || chr(13) || chr(10) || '                format: ''text''' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (data) {' || chr(13) || chr(10) || '        [''url'', ''user'', ''password'', ''organization_id'', ''class'', ''api_version'', ''id''].forEach(function (field) {' || chr(13) || chr(10) || '            if (typeof Itop.params !== ''object'' || typeof Itop.params[field] === ''undefined''' || chr(13) || chr(10) || '                    || Itop.params[field] === '''' ) {' || chr(13) || chr(10) || '                throw ''Required Itop param is not set: "itop_'' + field + ''".'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            url = Itop.params.url,' || chr(13) || chr(10) || '            request = new HttpRequest(),' || chr(13) || chr(10) || '            object;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: multipart/form-data'');' || chr(13) || chr(10) || '        request.addHeader(''Authorization: Basic '' + btoa(Itop.params.user + '':'' + Itop.params.password));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (Itop.HTTPProxy) {' || chr(13) || chr(10) || '            request.setProxy(Itop.HTTPProxy);' || chr(13) || chr(10) || '')||
TO_NCLOB('        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ iTop Webhook ] Sending request: '' + url + ''&json_data='' + data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        response = request.post(url + ''&json_data='' + encodeURIComponent(data));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ iTop Webhook ] Received response with status code '' + request.getStatus() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        try {' || chr(13) || chr(10) || '            response = JSON.parse(response);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        catch (error) {' || chr(13) || chr(10) || '            Zabbix.log(4, ''[ iTop Webhook ] Failed to parse response received from iTop'');' || chr(13) || chr(10) || '            throw ''Failed to parse response received from iTop.\nRequest status code '' +' || chr(13) || chr(10) || '                    request.getStatus() + ''. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() < 200 || request.getStatus() >= 300) {' || chr(13) || chr(10) || '            throw ''Request failed with status code '' + request.getStatus() + ''. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else if (typeof response.code !== ''undefined'' && response.code !== 0) {' || chr(13) || chr(10) || '            throw ''Request failed with iTop code '' + response.code + '': '' +' || chr(13) || chr(10) || '                    JSON.stringify(response.message) + ''. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '')||
TO_NCLOB('            Object.keys(response.objects)' || chr(13) || chr(10) || '                .forEach(function (key) {' || chr(13) || chr(10) || '                    object = response.objects[key];' || chr(13) || chr(10) || '                });' || chr(13) || chr(10) || '    ' || chr(13) || chr(10) || '            return {' || chr(13) || chr(10) || '                status: request.getStatus(),' || chr(13) || chr(10) || '                response: object.fields' || chr(13) || chr(10) || '            };' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        json_data = {},' || chr(13) || chr(10) || '        itop_params = {},' || chr(13) || chr(10) || '        result = {tags: {}},' || chr(13) || chr(10) || '        required_params = [' || chr(13) || chr(10) || '            ''alert_subject'', ''summary'', ''event_recovery_value'',' || chr(13) || chr(10) || '            ''event_source'', ''event_value'', ''action_name''' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (key.startsWith(''itop_'')) {' || chr(13) || chr(10) || '                itop_params[key.substring(5)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (required_params.indexOf(key) !== -1 && params[key] === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" can\''t be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '')||
TO_NCLOB('        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '            && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'' && params.event_source === ''0'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_recovery_value === ''0'') {' || chr(13) || chr(10) || '        throw ''Recovery operations are supported only for trigger-based actions.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Itop.setParams(itop_params);' || chr(13) || chr(10) || '    Itop.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    json_data.operation = '''';' || chr(13) || chr(10) || '    json_data.class = Itop.params.class;' || chr(13) || chr(10) || '    json_data.comment = Itop.params.comment;' || chr(13) || chr(10) || '    json_data.output_fields = ''id, friendlyname'';' || chr(13) || chr(10) || '    json_data.fields = {};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Create issue for non trigger-based events.' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_recovery_value !== ''0'') {' || chr(13) || chr(10) || '')||
TO_NCLOB('        Itop.setCreatePayload();' || chr(13) || chr(10) || '        Itop.request(json_data);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Create issue for trigger-based events.' || chr(13) || chr(10) || '    else if (params.event_value === ''1'' && params.event_update_status === ''0''' || chr(13) || chr(10) || '            && Itop.params.id === ''{EVENT.TAGS.__zbx_itop_id}'') {' || chr(13) || chr(10) || '        Itop.setCreatePayload();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response = Itop.request(json_data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result.tags.__zbx_itop_id = response.response.id;' || chr(13) || chr(10) || '        result.tags.__zbx_itop_key = response.response.friendlyname;' || chr(13) || chr(10) || '        result.tags.__zbx_itop_link = params.itop_url + (params.itop_url.endsWith(''/'') ? '''' : ''/'') +' || chr(13) || chr(10) || '                ''pages/UI.php?operation=details&class='' + encodeURIComponent(Itop.params.class) + ''&id='' +' || chr(13) || chr(10) || '                encodeURIComponent(response.response.id);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Update created issue for trigger-based event.' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        if (Itop.params.id === ''{EVENT.TAGS.__zbx_itop_id}'') {' || chr(13) || chr(10) || '            throw ''Incorrect iTop ticket ID given: '' + Itop.params.id;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        Itop.setUpdatePayload();' || chr(13) || chr(10) || '        Itop.request(json_data);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return JSON.stringify(result);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ iTop Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_itop_link}','iTop: {EVENT.TAGS.__zbx_itop_key}','')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description)
values ('27','4','Rocket.Chat','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',TO_NCLOB('var RocketChat = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        RocketChat.params = params;' || chr(13) || chr(10) || '        if (RocketChat.params.url && RocketChat.params.api_url) {' || chr(13) || chr(10) || '            if (!RocketChat.params.url.endsWith(''/'')) {' || chr(13) || chr(10) || '                RocketChat.params.url += ''/'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            if (!RocketChat.params.api_url.endsWith(''/'')) {' || chr(13) || chr(10) || '                RocketChat.params.api_url += ''/'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            if (RocketChat.params.api_url.startsWith(''/'')) {' || chr(13) || chr(10) || '                RocketChat.params.api_url = RocketChat.params.api_url.substring(1);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            RocketChat.params.url += RocketChat.params.api_url;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setProxy: function (HTTPProxy) {' || chr(13) || chr(10) || '        RocketChat.HTTPProxy = HTTPProxy;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    addFields: function (fields) {' || chr(13) || chr(10) || '        var data = [];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof fields === ''object'' && Object.keys(fields).length) {' || chr(13) || chr(10) || '            Object.keys(fields)' || chr(13) || chr(10) || '                .forEach(function(field) {' || chr(13) || chr(10) || '                    if (fields[field] === '''') {' || chr(13) || chr(10) || '')||
TO_NCLOB('                        Zabbix.log(4, ''[ RocketChat Webhook ] Field "'' + field +' || chr(13) || chr(10) || '                            ''" can\''t be empty. The field ignored.'');' || chr(13) || chr(10) || '                    }' || chr(13) || chr(10) || '                    else {' || chr(13) || chr(10) || '                        try {' || chr(13) || chr(10) || '                            var parts = field.split('':''),' || chr(13) || chr(10) || '                                prefix = parts[0].split(''_'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                            if (typeof prefix[2] === ''undefined''' || chr(13) || chr(10) || '                                    || (prefix[2] === ''p'' && params.event_value === ''1'')' || chr(13) || chr(10) || '                                    || (prefix[2] === ''r'' && params.event_value === ''0'')) {' || chr(13) || chr(10) || '                                data.push({' || chr(13) || chr(10) || '                                    title: field.substring(field.indexOf('':'') + 1),' || chr(13) || chr(10) || '                                    value: fields[field],' || chr(13) || chr(10) || '                                    short: prefix[1] === ''short''' || chr(13) || chr(10) || '                                });' || chr(13) || chr(10) || '                            }' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '                        catch (error) {' || chr(13) || chr(10) || '                            Zabbix.log(4, ''[ RocketChat Webhook ] Can\''t parse field "'' + field +' || chr(13) || chr(10) || '                                ''". The field ignored.'');' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '                    }' || chr(13) || chr(10) || '                });' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return data;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    request: function (method, query, data) {' || chr(13) || chr(10) || '        [''url'', ''api_url'', ''user_id'', ''user_token'', ''send_to''].forEach(function (field) {' || chr(13) || chr(10) || '            if (typeof RocketChat.params !== ''object'' || typeof RocketChat.params[field] === ''undefined''' || chr(13) || chr(10) || '                    || RocketChat.params[field] === '''' ) {' || chr(13) || chr(10) || '                throw ''Required parameter is not set: "'' + field + ''".'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            url = RocketChat.params.url + query,' || chr(13) || chr(10) || '            request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '        request.addHeader(''X-Auth-Token:'' + RocketChat.params.user_token);' || chr(13) || chr(10) || '        request.addHeader(''X-User-Id:'' + RocketChat.params.user_id);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof RocketChat.HTTPProxy !== ''undefined'' && RocketChat.HTTPProxy !== '''') {' || chr(13) || chr(10) || '            request.setProxy(RocketChat.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ RocketChat Webhook ] Sending request: '' + url +' || chr(13) || chr(10) || '            ((typeof data === ''string'') ? (''\n'' + data) : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (method) {' || chr(13) || chr(10) || '            case ''get'':' || chr(13) || chr(10) || '                response = request.get(url, data);' || chr(13) || chr(10) || '')||
TO_NCLOB('                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''post'':' || chr(13) || chr(10) || '                response = request.post(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                throw ''Unsupported HTTP request method: '' + method;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ RocketChat Webhook ] Received response with status code '' +' || chr(13) || chr(10) || '            request.getStatus() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ RocketChat Webhook ] Failed to parse response received from RocketChat'');' || chr(13) || chr(10) || '                response = null;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() < 200 || request.getStatus() >= 300) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (response !== null && typeof response.message !== ''undefined'') {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.message);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (response !== null && typeof response.error !== ''undefined'') {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.error);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '            throw message + ''. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return {' || chr(13) || chr(10) || '            status: request.getStatus(),' || chr(13) || chr(10) || '            response: response' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    postMessage: function(use_default_message, message, fields) {' || chr(13) || chr(10) || '        var data = {' || chr(13) || chr(10) || '            channel: RocketChat.params.send_to,' || chr(13) || chr(10) || '            attachments: [{' || chr(13) || chr(10) || '                collapsed: false,' || chr(13) || chr(10) || '                color: RocketChat.params.color,' || chr(13) || chr(10) || '                title: params.alert_subject' || chr(13) || chr(10) || '            }]' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (RocketChat.params.title_link) {' || chr(13) || chr(10) || '            data.attachments[0].title_link = RocketChat.params.title_link;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (use_default_message) {' || chr(13) || chr(10) || '            data.attachments[0].text = message;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            data.attachments[0].fields = RocketChat.addFields(fields);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var result = RocketChat.request(''post'', ''chat.postMessage'', data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof result.response !== ''object'' || typeof result.response.message._id === ''undefined'') {' || chr(13) || chr(10) || '            throw ''Cannot send RocketChat message. Check debug log for more information.'';' || chr(13) || chr(10) || '')||
TO_NCLOB('        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return {' || chr(13) || chr(10) || '            id: result.response.message._id,' || chr(13) || chr(10) || '            rid: result.response.message.rid,' || chr(13) || chr(10) || '            channel: result.response.channel' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    sendMessage: function(update, fields) {' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var data = {' || chr(13) || chr(10) || '            message: {' || chr(13) || chr(10) || '                rid: RocketChat.params.room_id,' || chr(13) || chr(10) || '                tmid: RocketChat.params.msg_id,' || chr(13) || chr(10) || '                tshow: true' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (update.status === ''0'') {' || chr(13) || chr(10) || '            data.message.attachments = [{' || chr(13) || chr(10) || '                collapsed: false,' || chr(13) || chr(10) || '                color: RocketChat.params.color,' || chr(13) || chr(10) || '                title: params.alert_subject,' || chr(13) || chr(10) || '                title_link: RocketChat.params.title_link,' || chr(13) || chr(10) || '                fields: RocketChat.addFields(fields)' || chr(13) || chr(10) || '            }];' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            data.message.alias = update.user;' || chr(13) || chr(10) || '            data.message.msg = update.action;' || chr(13) || chr(10) || '            if (update.message) {' || chr(13) || chr(10) || '                data.message.attachments = [{' || chr(13) || chr(10) || '                    color: RocketChat.params.color,' || chr(13) || chr(10) || '                    text: update.message' || chr(13) || chr(10) || '                }];' || chr(13) || chr(10) || '')||
TO_NCLOB('            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        RocketChat.request(''post'', ''chat.sendMessage'', data);' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    getMessageLink: function(rid, id) {' || chr(13) || chr(10) || '        var room = RocketChat.request(''get'', ''rooms.info?roomId='' + encodeURIComponent(rid)),' || chr(13) || chr(10) || '            link = params.rc_url +' || chr(13) || chr(10) || '                (params.rc_url.endsWith(''/'') ? '''' : ''/'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (room.response.room.t) {' || chr(13) || chr(10) || '            case ''c'':' || chr(13) || chr(10) || '                link += ''channel/'' + room.response.room.name + ''?msg='' + id;' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''p'':' || chr(13) || chr(10) || '                link += ''group/'' + room.response.room.name + ''?msg='' + id;' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''d'':' || chr(13) || chr(10) || '                link += ''direct/'' + rid + ''?msg='' + id;' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ RocketChat Webhook ] Can\''t get room type. Link to message will not be added.'');' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return link;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        response,' || chr(13) || chr(10) || '        fields = {},' || chr(13) || chr(10) || '        rc = {},' || chr(13) || chr(10) || '')||
TO_NCLOB('        update = {},' || chr(13) || chr(10) || '        result = {tags: {}},' || chr(13) || chr(10) || '        required_params = [''alert_subject'', ''alert_message'', ''event_source'', ''event_value''],' || chr(13) || chr(10) || '        severities = [' || chr(13) || chr(10) || '            {name: ''not_classified'', color: ''#97AAB3''},' || chr(13) || chr(10) || '            {name: ''information'', color: ''#7499FF''},' || chr(13) || chr(10) || '            {name: ''warning'', color: ''#FFC859''},' || chr(13) || chr(10) || '            {name: ''average'', color: ''#FFA059''},' || chr(13) || chr(10) || '            {name: ''high'', color: ''#E97659''},' || chr(13) || chr(10) || '            {name: ''disaster'', color: ''#E45959''},' || chr(13) || chr(10) || '            {name: ''resolved'', color: ''#009900''},' || chr(13) || chr(10) || '            {name: ''default'', color: ''#000000''}' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (key.startsWith(''rc_'')) {' || chr(13) || chr(10) || '                rc[key.substring(3)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''field_'')) {' || chr(13) || chr(10) || '                fields[key.substring(6)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''event_update_'')) {' || chr(13) || chr(10) || '                update[key.substring(13)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (required_params.indexOf(key) !== -1 && params[key] === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" can\''t be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Forcing parameters for non trigger-based events.' || chr(13) || chr(10) || '    if (params.event_source !== ''0'') {' || chr(13) || chr(10) || '        params.use_default_message = ''true'';' || chr(13) || chr(10) || '        params.event_nseverity = ''0'';' || chr(13) || chr(10) || '        params.rc_title_link = false;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '            && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'' && params.event_source === ''0'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {' || chr(13) || chr(10) || '        params.event_nseverity = ''7'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value === ''0'') {' || chr(13) || chr(10) || '        params.event_nseverity = ''6'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    RocketChat.setParams(rc);' || chr(13) || chr(10) || '    RocketChat.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    RocketChat.params.color = severities[params.event_nseverity].color;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Send default message if use_default_message === true.' || chr(13) || chr(10) || '    if (params.use_default_message.toLowerCase() === ''true'') {' || chr(13) || chr(10) || '        response = RocketChat.postMessage(true, params.alert_message);' || chr(13) || chr(10) || '        result.tags.__zbx_rc_id = response.id;' || chr(13) || chr(10) || '        result.tags.__zbx_rc_rid = response.rid;' || chr(13) || chr(10) || '        result.tags.__zbx_rc_msg_url = RocketChat.getMessageLink(response.rid, response.id);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Send message for trigger-based events.' || chr(13) || chr(10) || '    else if (params.event_value === ''1'' && update.status === ''0'') {' || chr(13) || chr(10) || '        response = RocketChat.postMessage(false, params.alert_message, fields);' || chr(13) || chr(10) || '        result.tags.__zbx_rc_id = response.id;' || chr(13) || chr(10) || '        result.tags.__zbx_rc_rid = response.rid;' || chr(13) || chr(10) || '        result.tags.__zbx_rc_msg_url = RocketChat.getMessageLink(response.rid, response.id);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Send thread message for trigger-based event.' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        RocketChat.sendMessage(update, fields);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return JSON.stringify(result);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ RocketChat Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_rc_msg_url}','Rocket.Chat','')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description)
values ('28','4','VictorOps','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',TO_NCLOB('var VictorOps = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        VictorOps.params = params;' || chr(13) || chr(10) || '        if (VictorOps.params.endpoint) {' || chr(13) || chr(10) || '            if (!VictorOps.params.endpoint.endsWith(''/'')) {' || chr(13) || chr(10) || '                VictorOps.params.endpoint += ''/'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (typeof VictorOps.params.routing_key !== ''undefined''' || chr(13) || chr(10) || '                    && VictorOps.params.routing_key !== ''{ALERT.SENDTO}''' || chr(13) || chr(10) || '                    && VictorOps.params.routing_key !== ''Default'') {' || chr(13) || chr(10) || '                VictorOps.params.endpoint += VictorOps.params.routing_key;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setProxy: function (HTTPProxy) {' || chr(13) || chr(10) || '        VictorOps.HTTPProxy = HTTPProxy;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    addFields: function (fields) {' || chr(13) || chr(10) || '        var data = {};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof fields === ''object'') {' || chr(13) || chr(10) || '            Object.keys(fields)' || chr(13) || chr(10) || '                .forEach(function(field) {' || chr(13) || chr(10) || '                    if (fields[field] === '''') {' || chr(13) || chr(10) || '                        Zabbix.log(4, ''[ VictorOps Webhook ] Field "'' + field +' || chr(13) || chr(10) || '')||
TO_NCLOB('                            ''" can\''t be empty. The field ignored.'');' || chr(13) || chr(10) || '                    }' || chr(13) || chr(10) || '                    else {' || chr(13) || chr(10) || '                        try {' || chr(13) || chr(10) || '                            var parts = field.split('':''),' || chr(13) || chr(10) || '                                prefix = parts[0].split(''_'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                            if (typeof prefix[1] === ''undefined''' || chr(13) || chr(10) || '                                    || (prefix[1] === ''p'' && params.event_value === ''1''' || chr(13) || chr(10) || '                                        && (params.event_update_status === ''0''' || chr(13) || chr(10) || '                                            || params.event_update_status === ''{EVENT.UPDATE.STATUS}''))' || chr(13) || chr(10) || '                                    || (prefix[1] === ''r'' && params.event_value === ''0''' || chr(13) || chr(10) || '                                        && (params.event_update_status === ''0''' || chr(13) || chr(10) || '                                            || params.event_update_status === ''{EVENT.UPDATE.STATUS}''))' || chr(13) || chr(10) || '                                    || (prefix[1] === ''u'' && params.event_update_status === ''1'')) {' || chr(13) || chr(10) || '                                data[field.substring(field.indexOf('':'') + 1)] = fields[field];' || chr(13) || chr(10) || '                            }' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '                        catch (error) {' || chr(13) || chr(10) || '                            Zabbix.log(4, ''[ VictorOps Webhook ] Can\''t parse field "'' + field +' || chr(13) || chr(10) || '                                ''". The field ignored.'');' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '                    }' || chr(13) || chr(10) || '                });' || chr(13) || chr(10) || '')||
TO_NCLOB('        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return data;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (data) {' || chr(13) || chr(10) || '        if (typeof VictorOps.params !== ''object'' || typeof VictorOps.params.endpoint === ''undefined''' || chr(13) || chr(10) || '                || VictorOps.params.endpoint === '''' ) {' || chr(13) || chr(10) || '            throw ''Required parameter is not set: "vops_endpoint".'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            url = VictorOps.params.endpoint,' || chr(13) || chr(10) || '            request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof VictorOps.HTTPProxy !== ''undefined'' && VictorOps.HTTPProxy !== '''') {' || chr(13) || chr(10) || '            request.setProxy(VictorOps.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ VictorOps Webhook ] Sending request: '' + url +' || chr(13) || chr(10) || '            ((typeof data === ''string'') ? (''\n'' + data) : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        response = request.post(url, data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ VictorOps Webhook ] Received response with status code '' +' || chr(13) || chr(10) || '            request.getStatus() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '')||
TO_NCLOB('                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ VictorOps Webhook ] Failed to parse response received from VictorOps'');' || chr(13) || chr(10) || '                response = null;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() < 200 || request.getStatus() >= 300) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (response !== null && typeof response.messages !== ''undefined'') {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.messages);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            throw message + ''. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return response;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        fields = {},' || chr(13) || chr(10) || '        vops = {},' || chr(13) || chr(10) || '        required_params = [''event_source'', ''event_value'', ''priority_update''],' || chr(13) || chr(10) || '        severities = [' || chr(13) || chr(10) || '            {name: ''not_classified'', color: ''#97AAB3''},' || chr(13) || chr(10) || '            {name: ''information'', color: ''#7499FF''},' || chr(13) || chr(10) || '            {name: ''warning'', color: ''#FFC859''},' || chr(13) || chr(10) || '            {name: ''average'', color: ''#FFA059''},' || chr(13) || chr(10) || '            {name: ''high'', color: ''#E97659''},' || chr(13) || chr(10) || '')||
TO_NCLOB('            {name: ''disaster'', color: ''#E45959''},' || chr(13) || chr(10) || '            {name: ''resolved'', color: ''#009900''},' || chr(13) || chr(10) || '            {name: ''default'', color: ''#000000''}' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (key.startsWith(''vops_'')) {' || chr(13) || chr(10) || '                vops[key.substring(5)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''field'')) {' || chr(13) || chr(10) || '                fields[key.substring(5)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (required_params.indexOf(key) !== -1 && params[key] === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" can\''t be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '            && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '')||
TO_NCLOB('    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'' && params.event_source === ''0'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {' || chr(13) || chr(10) || '        params.event_nseverity = ''7'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value === ''0'') {' || chr(13) || chr(10) || '        params.event_nseverity = ''6'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_update_status === ''1'') {' || chr(13) || chr(10) || '        fields['':message_type''] = params.priority_update;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        fields['':message_type''] = params[''priority_'' + severities[params.event_nseverity].name]' || chr(13) || chr(10) || '            || ''INFO'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_info && params.event_source === ''0'') {' || chr(13) || chr(10) || '        fields['':event_info''] = params.event_info;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    VictorOps.setParams(vops);' || chr(13) || chr(10) || '    VictorOps.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    VictorOps.request(VictorOps.addFields(fields));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return ''OK'';' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ VictorOps Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','0','0','','','')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description)
values ('29','4','Brevis.one','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',TO_NCLOB('var BrevisOne = {' || chr(13) || chr(10) || '    params: [],' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    addParam: function (name, value) {' || chr(13) || chr(10) || '        BrevisOne.params.push(name + ''='' + encodeURIComponent(value));' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setProxy: function (HTTPProxy) {' || chr(13) || chr(10) || '        BrevisOne.HTTPProxy = HTTPProxy;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setPayload: function (params) {' || chr(13) || chr(10) || '        var parts = params.send_to.split('':''),' || chr(13) || chr(10) || '            defaultValues = {' || chr(13) || chr(10) || '                ring: ''true'',' || chr(13) || chr(10) || '                flash: ''true'',' || chr(13) || chr(10) || '                telauto: ''false''' || chr(13) || chr(10) || '            };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        BrevisOne.addParam(''username'', params.username);' || chr(13) || chr(10) || '        BrevisOne.addParam(''password'', params.password);' || chr(13) || chr(10) || '        BrevisOne.addParam(''text'', params.text);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (parts.length > 1) {' || chr(13) || chr(10) || '            BrevisOne.addParam(''mode'', parts[0]);' || chr(13) || chr(10) || '            BrevisOne.addParam(''to'', parts[1]);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            BrevisOne.addParam(''to'', parts[0]);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Object.keys(defaultValues)' || chr(13) || chr(10) || '            .forEach(function (key) {' || chr(13) || chr(10) || '                if (params[key] && params[key].trim() && params[key].toLowerCase() === defaultValues[key]) {' || chr(13) || chr(10) || '')||
TO_NCLOB('                    BrevisOne.addParam(key, defaultValues[key]);' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            });' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function () {' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            request = new HttpRequest(),' || chr(13) || chr(10) || '            data = ''?'' + BrevisOne.params.join(''&'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: multipart/form-data'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof BrevisOne.HTTPProxy !== ''undefined'' && BrevisOne.HTTPProxy !== '''') {' || chr(13) || chr(10) || '            request.setProxy(BrevisOne.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ BrevisOne Webhook ] Sending request.'');' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        response = request.post(params.endpoint + data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ BrevisOne Webhook ] Received response with status code '' +' || chr(13) || chr(10) || '            request.getStatus() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() < 200 || request.getStatus() >= 300) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (response) {' || chr(13) || chr(10) || '                message += '': '' + response;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            throw message + ''. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value);' || chr(13) || chr(10) || '')||
TO_NCLOB('' || chr(13) || chr(10) || '    [''endpoint'', ''password'', ''username'', ''text'', ''send_to''].forEach(function (field) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'' || typeof params[field] === ''undefined''' || chr(13) || chr(10) || '                || !params[field].trim()) {' || chr(13) || chr(10) || '            throw ''Required parameter is not set: "'' + field + ''".'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.send_to === ''{ALERT.SENDTO}'') {' || chr(13) || chr(10) || '        throw ''Required parameter is not set: "send_to".'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    BrevisOne.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '    BrevisOne.setPayload(params);' || chr(13) || chr(10) || '    BrevisOne.request();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return ''OK'';' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ BrevisOne Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','0','0','','','')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description)
values ('30','4','Express.ms','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',TO_NCLOB('var Express = {' || chr(13) || chr(10) || '    params: [],' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Express.params = params;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof Express.params.url === ''string'' && !Express.params.url.endsWith(''/'')) {' || chr(13) || chr(10) || '            Express.params.url += ''/'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setProxy: function (HTTPProxy) {' || chr(13) || chr(10) || '        Express.HTTPProxy = HTTPProxy;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (query, data) {' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            url = Express.params.url + query,' || chr(13) || chr(10) || '            request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '        request.addHeader(''Authorization: Bearer '' + Express.params.token);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof Express.HTTPProxy !== ''undefined'' && Express.HTTPProxy !== '''') {' || chr(13) || chr(10) || '            request.setProxy(Express.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ Express Webhook ] Sending request: '' + url +' || chr(13) || chr(10) || '')||
TO_NCLOB('            ((typeof data === ''string'') ? (''\n'' + data) : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        response = request.post(url, data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ Express Webhook ] Received response with status code '' +' || chr(13) || chr(10) || '            request.getStatus() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ Express Webhook ] Failed to parse response received from Express'');' || chr(13) || chr(10) || '                response = {};' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response.status !== ''ok'') {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (typeof response.reason !== ''undefined'') {' || chr(13) || chr(10) || '                message += '': '' + JSON.stringify(response.reason);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            throw message + ''. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return response.result;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    postMessage: function (is_problem) {' || chr(13) || chr(10) || '        var data,' || chr(13) || chr(10) || '            url,' || chr(13) || chr(10) || '            result = {tags: {}},' || chr(13) || chr(10) || '            response;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('        if (is_problem) {' || chr(13) || chr(10) || '            data = {' || chr(13) || chr(10) || '                group_chat_id: Express.params.send_to,' || chr(13) || chr(10) || '                notification: {' || chr(13) || chr(10) || '                    status: ''ok'',' || chr(13) || chr(10) || '                    body: Express.params.message' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            };' || chr(13) || chr(10) || '            url = ''api/v4/botx/notifications/direct'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            data = {' || chr(13) || chr(10) || '                reply: {' || chr(13) || chr(10) || '                    status: ''ok'',' || chr(13) || chr(10) || '                    body: Express.params.message' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            };' || chr(13) || chr(10) || '            url = ''api/v3/botx/events/reply_event'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                var tags = JSON.parse(Express.params.tags);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                throw ''Value of "express_tags" is not JSON. Value: '' + Express.params.tags + ''.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            tags.forEach(function(tag) {' || chr(13) || chr(10) || '                if (tag.tag === ''__zbx_ex_sync_id_'' + Express.params.send_to) {' || chr(13) || chr(10) || '                    data.source_sync_id = tag.value;' || chr(13) || chr(10) || '                }' || chr(13) || chr(10) || '            });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (!data.source_sync_id) {' || chr(13) || chr(10) || '                throw ''Cannot update data. sync_id for the provided sender is unknown.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '')||
TO_NCLOB('        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        response = Express.request(url, data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (is_problem && response.sync_id) {' || chr(13) || chr(10) || '            result.tags[''__zbx_ex_sync_id_'' + Express.params.send_to] = response.sync_id;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            return JSON.stringify(result);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            return ''OK'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        express = {},' || chr(13) || chr(10) || '        required_params = [' || chr(13) || chr(10) || '            ''express_url'', ''express_send_to'', ''express_message'', ''express_tags'', ''express_token'',' || chr(13) || chr(10) || '            ''event_source'', ''event_value'', ''event_update_status''' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (key.startsWith(''express_'')) {' || chr(13) || chr(10) || '                express[key.substring(8)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (required_params.indexOf(key) !== -1' || chr(13) || chr(10) || '                    && (params[key].trim() === '''' || params[key] === ''{ALERT.SENDTO}'')) {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" can\''t be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Forcing event_value and event_update_status for non trigger-based events.' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' ) {' || chr(13) || chr(10) || '        params.event_value = ''1'';' || chr(13) || chr(10) || '        params.event_update_status = ''0'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'' && params.event_source === ''0'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Express.setParams(express);' || chr(13) || chr(10) || '    Express.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return Express.postMessage(params.event_value === ''1'' && params.event_update_status === ''0'');' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ Express Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','0','','','')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description)
values ('31','4','ManageEngine ServiceDesk','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',TO_NCLOB('var MEngine = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        MEngine.params = params;' || chr(13) || chr(10) || '        if (typeof MEngine.params.url === ''string'') {' || chr(13) || chr(10) || '            if (!MEngine.params.url.endsWith(''/'')) {' || chr(13) || chr(10) || '                MEngine.params.url += ''/'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            MEngine.params.url += ''api/v3/'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (MEngine.params.on_premise.toLowerCase() !== ''true''' || chr(13) || chr(10) || '                && typeof MEngine.params.on_demand_url_auth === ''string'') {' || chr(13) || chr(10) || '            if (!MEngine.params.on_demand_url_auth.endsWith(''/'')) {' || chr(13) || chr(10) || '                MEngine.params.on_demand_url_auth += ''/'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            MEngine.params.on_demand_url_auth += ''oauth/v2/token?'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setProxy: function (HTTPProxy) {' || chr(13) || chr(10) || '        MEngine.HTTPProxy = HTTPProxy;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    createLink: function (id, url) {' || chr(13) || chr(10) || '        return url + (url.endsWith(''/'') ? '''' : ''/'') +' || chr(13) || chr(10) || '            ((MEngine.params.on_premise.toLowerCase() === ''true'')' || chr(13) || chr(10) || '                ? (''WorkOrder.do?woMode=viewWO&woID='' + id)' || chr(13) || chr(10) || '')||
TO_NCLOB('                : (''app/itdesk/ui/requests/'' + id + ''/details'')' || chr(13) || chr(10) || '            );' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    refreshAccessToken: function () {' || chr(13) || chr(10) || '        [' || chr(13) || chr(10) || '            ''on_demand_url_auth'',' || chr(13) || chr(10) || '            ''on_demand_refresh_token'',' || chr(13) || chr(10) || '            ''on_demand_client_id'',' || chr(13) || chr(10) || '            ''on_demand_client_secret''' || chr(13) || chr(10) || '        ].forEach(function (field) {' || chr(13) || chr(10) || '            if (typeof MEngine.params !== ''object'' || typeof MEngine.params[field] === ''undefined''' || chr(13) || chr(10) || '                    || MEngine.params[field].trim() === '''' ) {' || chr(13) || chr(10) || '                throw ''Required MEngine param is not set: "sd_'' + field + ''".'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            request = new HttpRequest(),' || chr(13) || chr(10) || '            url = MEngine.params.on_demand_url_auth +' || chr(13) || chr(10) || '                ''refresh_token='' + encodeURIComponent(MEngine.params.on_demand_refresh_token) +' || chr(13) || chr(10) || '                ''&grant_type=refresh_token&client_id='' + encodeURIComponent(MEngine.params.on_demand_client_id) +' || chr(13) || chr(10) || '                ''&client_secret='' + encodeURIComponent(MEngine.params.on_demand_client_secret) +' || chr(13) || chr(10) || '                ''&redirect_uri=https://www.zoho.com&scope=SDPOnDemand.requests.ALL'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (MEngine.HTTPProxy) {' || chr(13) || chr(10) || '            request.setProxy(MEngine.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('        Zabbix.log(4, ''[ ManageEngine Webhook ] Refreshing access token. Request: '' + url);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        response = request.post(url);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ ManageEngine Webhook ] Received response with status code '' +' || chr(13) || chr(10) || '        request.getStatus() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        try {' || chr(13) || chr(10) || '            response = JSON.parse(response);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        catch (error) {' || chr(13) || chr(10) || '            Zabbix.log(4, ''[ ManageEngine Webhook ] Failed to parse response received from Zoho Accounts'');' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if ((request.getStatus() < 200 || request.getStatus() >= 300) && !response.access_token) {' || chr(13) || chr(10) || '            throw ''Access token refresh failed with HTTP status code '' + request.getStatus() +' || chr(13) || chr(10) || '                ''. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            MEngine.params.on_demand_auth_token = response.access_token;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (method, query, data) {' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            url = MEngine.params.url + query,' || chr(13) || chr(10) || '            input,' || chr(13) || chr(10) || '            request = new HttpRequest(),' || chr(13) || chr(10) || '            message;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (MEngine.params.on_premise.toLowerCase() === ''true'') {' || chr(13) || chr(10) || '            request.addHeader(''TECHNICIAN_KEY: '' + MEngine.params.on_premise_auth_token);' || chr(13) || chr(10) || '')||
TO_NCLOB('        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            request.addHeader(''Authorization: Zoho-oauthtoken '' + MEngine.params.on_demand_auth_token);' || chr(13) || chr(10) || '            request.addHeader(''Accept: application/v3+json'');' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (MEngine.HTTPProxy) {' || chr(13) || chr(10) || '            request.setProxy(MEngine.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        input = ''input_data='' + encodeURIComponent(data);' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ ManageEngine Webhook ] Sending request: '' + url + ''?'' + input);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (method) {' || chr(13) || chr(10) || '            case ''post'':' || chr(13) || chr(10) || '                response = request.post(url, input);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''put'':' || chr(13) || chr(10) || '                response = request.put(url, input);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                throw ''Unsupported HTTP request method: '' + method;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ ManageEngine Webhook ] Received response with status code '' +' || chr(13) || chr(10) || '            request.getStatus() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        try {' || chr(13) || chr(10) || '            response = JSON.parse(response);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '')||
TO_NCLOB('        catch (error) {' || chr(13) || chr(10) || '            Zabbix.log(4, ''[ ManageEngine Webhook ] Failed to parse response received from ManageEngine'');' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if ((request.getStatus() < 200 || request.getStatus() >= 300)' || chr(13) || chr(10) || '                && typeof response.response_status !== ''object'') {' || chr(13) || chr(10) || '            throw ''Request failed with HTTP status code '' + request.getStatus() +' || chr(13) || chr(10) || '                ''. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else if (typeof response.response_status === ''object'' && response.response_status.status === ''failed'') {' || chr(13) || chr(10) || '            message = ''Request failed with status_code '';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (typeof response.response_status.messages === ''object''' || chr(13) || chr(10) || '                    && response.response_status.messages[0]' || chr(13) || chr(10) || '                    && response.response_status.messages[0].message) {' || chr(13) || chr(10) || '                message += response.response_status.messages[0].status_code +' || chr(13) || chr(10) || '                    ''. Message: '' + response.response_status.messages[0].message;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else {' || chr(13) || chr(10) || '                message += response.response_status.status_code;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            message += ''. Check debug log for more information.'';' || chr(13) || chr(10) || '            throw message;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else if (response.request) {' || chr(13) || chr(10) || '            return response.request.id;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '')||
TO_NCLOB('    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    createPaylaod: function (fields, isNote) {' || chr(13) || chr(10) || '        var data = {},' || chr(13) || chr(10) || '            result;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (isNote) {' || chr(13) || chr(10) || '            data.description = fields[''field_string:description''].replace(/(?:\r\n|\r|\n)/g, ''<br>'');' || chr(13) || chr(10) || '            result = {request_note: data};' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        else {' || chr(13) || chr(10) || '            Object.keys(fields)' || chr(13) || chr(10) || '                .forEach(function(field) {' || chr(13) || chr(10) || '                    if (fields[field].trim() === '''') {' || chr(13) || chr(10) || '                        Zabbix.log(4, ''[ ManageEngine Webhook ] Field "'' + field +' || chr(13) || chr(10) || '                            ''" can\''t be empty. The field ignored.'');' || chr(13) || chr(10) || '                    }' || chr(13) || chr(10) || '                    else {' || chr(13) || chr(10) || '                        try {' || chr(13) || chr(10) || '                            var prefix = field.split('':'')[0],' || chr(13) || chr(10) || '                                root;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                            if  (prefix.startsWith(''udf_'') && !data.udf_fields) {' || chr(13) || chr(10) || '                                data.udf_fields = {};' || chr(13) || chr(10) || '                                root = data.udf_fields;' || chr(13) || chr(10) || '                            }' || chr(13) || chr(10) || '                            else if (prefix.startsWith(''udf_'')) {' || chr(13) || chr(10) || '                                root = data.udf_fields;' || chr(13) || chr(10) || '                            }' || chr(13) || chr(10) || '                            else {' || chr(13) || chr(10) || '')||
TO_NCLOB('                                root = data;' || chr(13) || chr(10) || '                            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '                            if (prefix.endsWith(''string'')) {' || chr(13) || chr(10) || '                                root[field.substring(field.indexOf('':'') + 1)' || chr(13) || chr(10) || '                                    .toLowerCase()] = fields[field];' || chr(13) || chr(10) || '                            }' || chr(13) || chr(10) || '                            else {' || chr(13) || chr(10) || '                                root[field.substring(field.indexOf('':'') + 1)' || chr(13) || chr(10) || '                                    .toLowerCase()] = {' || chr(13) || chr(10) || '                                    name: fields[field]' || chr(13) || chr(10) || '                                };' || chr(13) || chr(10) || '                            }' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '                        catch (error) {' || chr(13) || chr(10) || '                            Zabbix.log(4, ''[ ManageEngine Webhook ] Can\''t parse field "'' + field +' || chr(13) || chr(10) || '                                ''". The field ignored.'');' || chr(13) || chr(10) || '                        }' || chr(13) || chr(10) || '                    }' || chr(13) || chr(10) || '                });' || chr(13) || chr(10) || '            if (data.description) {' || chr(13) || chr(10) || '                data.description = data.description.replace(/(?:\r\n|\r|\n)/g, ''<br>'');' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            result = {request: data};' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return result;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        fields = {},' || chr(13) || chr(10) || '')||
TO_NCLOB('        sd = {},' || chr(13) || chr(10) || '        result = {tags: {}},' || chr(13) || chr(10) || '        required_params = [' || chr(13) || chr(10) || '            ''sd_on_premise'', ''field_string:subject'', ''field_string:description'',' || chr(13) || chr(10) || '            ''event_recovery_value'', ''event_source'', ''event_value'', ''event_update_status''' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        severities = [' || chr(13) || chr(10) || '            {name: ''not_classified'', color: ''#97AAB3''},' || chr(13) || chr(10) || '            {name: ''information'', color: ''#7499FF''},' || chr(13) || chr(10) || '            {name: ''warning'', color: ''#FFC859''},' || chr(13) || chr(10) || '            {name: ''average'', color: ''#FFA059''},' || chr(13) || chr(10) || '            {name: ''high'', color: ''#E97659''},' || chr(13) || chr(10) || '            {name: ''disaster'', color: ''#E45959''},' || chr(13) || chr(10) || '            {name: ''default'', color: ''#000000''}' || chr(13) || chr(10) || '        ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (key.startsWith(''sd_'')) {' || chr(13) || chr(10) || '                sd[key.substring(3)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (key.startsWith(''field_'') || key.startsWith(''udf_field_'')) {' || chr(13) || chr(10) || '                fields[key] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (required_params.indexOf(key) !== -1 && params[key].trim() === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" can\''t be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'' && params.event_source === ''0'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_recovery_value === ''0'') {' || chr(13) || chr(10) || '        throw ''Recovery operations are supported only for trigger-based actions.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {' || chr(13) || chr(10) || '        params.event_nseverity = ''6'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_update_status === ''1'' && (typeof params.sd_request_id === ''undefined''' || chr(13) || chr(10) || '            || params.sd_request_id.trim() === ''''' || chr(13) || chr(10) || '            || params.sd_request_id === ''{EVENT.TAGS.__zbx_sd_request_id}'')) {' || chr(13) || chr(10) || '')||
TO_NCLOB('        throw ''Parameter "sd_request_id" can\''t be empty for update operation.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    MEngine.setParams(sd);' || chr(13) || chr(10) || '    MEngine.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (MEngine.params.on_premise.toLowerCase() !== ''true'') {' || chr(13) || chr(10) || '        MEngine.refreshAccessToken();' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Create issue for non trigger-based events.' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_recovery_value !== ''0'') {' || chr(13) || chr(10) || '        fields[''field_object:priority''] = params[''priority_'' + severities[params.event_nseverity].name]' || chr(13) || chr(10) || '        || ''Normal'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        MEngine.request(''post'', ''requests'', MEngine.createPaylaod(fields));' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Create issue for trigger-based events.' || chr(13) || chr(10) || '    else if (params.event_value === ''1'' && params.event_update_status === ''0'') {' || chr(13) || chr(10) || '        fields[''field_object:priority''] = params[''priority_'' + severities[params.event_nseverity].name]' || chr(13) || chr(10) || '        || ''Normal'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var id = MEngine.request(''post'', ''requests'', MEngine.createPaylaod(fields));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        result.tags.__zbx_sd_request_id = id;' || chr(13) || chr(10) || '        result.tags.__zbx_sd_request_link = MEngine.createLink(id, params.sd_url);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '    // Update created issue for trigger-based event.' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        if (params.event_update_status === ''1'') {' || chr(13) || chr(10) || '')||
TO_NCLOB('            MEngine.request(''post'', ''requests/'' + params.sd_request_id + ''/notes'',' || chr(13) || chr(10) || '                MEngine.createPaylaod(fields, true)' || chr(13) || chr(10) || '            );' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        delete fields[''field_string:description''];' || chr(13) || chr(10) || '        MEngine.request(''put'', ''requests/'' + params.sd_request_id, MEngine.createPaylaod(fields));' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    return JSON.stringify(result);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(3, ''[ ManageEngine Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_sd_request_link}','ManageEngine: {EVENT.TAGS.__zbx_sd_request_id}','')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description)
values ('32','4','Github','','','','','','','','0','25','0','0','0','0','','1','3','10s','1',TO_NCLOB('var Github = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        Github.params = params;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setProxy: function (HTTPProxy) {' || chr(13) || chr(10) || '        Github.HTTPProxy = HTTPProxy;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    urlCheckFormat: function (url) {' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof url === ''string'' && !url.endsWith(''/'')) {' || chr(13) || chr(10) || '            url += ''/'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (url.indexOf(''http://'') === -1 && url.indexOf(''https://'') === -1) {' || chr(13) || chr(10) || '            url = ''https://'' + url;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return url;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    createProblemURL: function (zabbix_url, triggerid, eventid, event_source) {' || chr(13) || chr(10) || '        var problem_url = zabbix_url;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (event_source === ''0'') {' || chr(13) || chr(10) || '            problem_url += ''tr_events.php?triggerid='' + triggerid + ''&eventid='' + eventid;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return problem_url;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (method, url, data) {' || chr(13) || chr(10) || '        [''token'', ''user_agent''].forEach(function (field) {' || chr(13) || chr(10) || '')||
TO_NCLOB('            if (typeof Github.params !== ''object'' || typeof Github.params[field] === ''undefined'' || Github.params[field] === '''') {' || chr(13) || chr(10) || '                throw ''Required Github param is not set: "'' + field + ''".'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''User-Agent: '' + Github.params.user_agent);' || chr(13) || chr(10) || '        request.addHeader(''Accept: application/vnd.github.v3+json'');' || chr(13) || chr(10) || '        request.addHeader(''Authorization: token '' + Github.params.token);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof Github.HTTPProxy !== ''undefined'' && Github.HTTPProxy !== '''') {' || chr(13) || chr(10) || '            request.setProxy(Github.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ Github Webhook ] Sending request: '' + url + ((typeof data === ''string'')' || chr(13) || chr(10) || '            ? (''\n'' + data)' || chr(13) || chr(10) || '            : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (method) {' || chr(13) || chr(10) || '            case ''post'':' || chr(13) || chr(10) || '                response = request.post(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''patch'':' || chr(13) || chr(10) || '                response = request.patch(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('            default:' || chr(13) || chr(10) || '                throw ''Unsupported HTTP request method: '' + method;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ Github Webhook ] Received response with status code '' +' || chr(13) || chr(10) || '            request.getStatus() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ Github Webhook ] Failed to parse response received from Github'');' || chr(13) || chr(10) || '                response = null;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof response !== ''object'') {' || chr(13) || chr(10) || '            throw ''Failed to process response received from Github. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() < 200 || request.getStatus() >= 300) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (response.message) {' || chr(13) || chr(10) || '                message += '': '' + response.message;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            throw message + '' Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return response;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '')||
TO_NCLOB('    var params = JSON.parse(value),' || chr(13) || chr(10) || '        github = {},' || chr(13) || chr(10) || '        url = '''',' || chr(13) || chr(10) || '        data = {},' || chr(13) || chr(10) || '        comment_data,' || chr(13) || chr(10) || '        result = { tags: {} },' || chr(13) || chr(10) || '        required_params = [' || chr(13) || chr(10) || '            ''alert_subject'', ''alert_message'', ''event_source'', ''event_value'',' || chr(13) || chr(10) || '            ''event_update_status'', ''event_recovery_value'', ''event_severity'',' || chr(13) || chr(10) || '            ''event_id'', ''trigger_id'', ''zabbix_url'',' || chr(13) || chr(10) || '            ''github_token'', ''github_url'', ''github_user_agent''' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        method = ''post'',' || chr(13) || chr(10) || '        process_tags = true;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (key.startsWith(''github_'')) {' || chr(13) || chr(10) || '                github[key.substring(7)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (required_params.indexOf(key) !== -1 && params[key] === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" can\''t be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '')||
TO_NCLOB('        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'' && params.event_source === ''0'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_recovery_value === ''0'') {' || chr(13) || chr(10) || '        throw ''Recovery operations are supported only for trigger-based actions.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.zabbix_url !== ''string'' || params.zabbix_url.trim() === '''' || params.zabbix_url === ''{$ZABBIX.URL}'') {' || chr(13) || chr(10) || '        throw ''Field "zabbix_url" cannot be empty.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check for backslash in the end of url and schema.' || chr(13) || chr(10) || '    github.url = Github.urlCheckFormat(github.url);' || chr(13) || chr(10) || '    params.zabbix_url = Github.urlCheckFormat(params.zabbix_url);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Default url for creating issue' || chr(13) || chr(10) || '    url = github.url + ''repos/'' + github.repo + ''/issues'';' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    data.title = params.alert_subject;' || chr(13) || chr(10) || '    data.body = params.alert_message;' || chr(13) || chr(10) || '    data.labels = [' || chr(13) || chr(10) || '        { name: "Zabbix" }' || chr(13) || chr(10) || '')||
TO_NCLOB('    ];' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Adding label corresponding to trigger severity in Zabbix.' || chr(13) || chr(10) || '    if (params.event_severity !== ''undefined'' && params.event_source === ''0'') {' || chr(13) || chr(10) || '        data.labels.push({ name: params.event_severity });' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // In case of update or resolve event.' || chr(13) || chr(10) || '    if (params.event_source === ''0'' && (params.event_value === ''0'' || params.event_update_status === ''1'')) {' || chr(13) || chr(10) || '        process_tags = false;' || chr(13) || chr(10) || '        method = ''patch'';' || chr(13) || chr(10) || '        url = github.url + ''repos/'' + github.repo + ''/issues/'' + github.issue_number;' || chr(13) || chr(10) || '        comment_data = Object.assign({}, data);' || chr(13) || chr(10) || '        delete data.body;' || chr(13) || chr(10) || '    } else {' || chr(13) || chr(10) || '        problem_url = Github.createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source);' || chr(13) || chr(10) || '        data.body += ''\nEvent details in Zabbix: ['' + problem_url + '']('' + problem_url + '')'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Github.setParams(github);' || chr(13) || chr(10) || '    Github.setProxy(params.HTTPProxy);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    var response = Github.request(method, url, data);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Leave a comment if comment_data present.' || chr(13) || chr(10) || '    if (typeof comment_data === ''object'') {' || chr(13) || chr(10) || '        url = github.url + ''repos/'' + github.repo + ''/issues/'' + github.issue_number + ''/comments'';' || chr(13) || chr(10) || '        Github.request("post", url, comment_data);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '')||
TO_NCLOB('    if (process_tags) {' || chr(13) || chr(10) || '        result.tags.__zbx_github_issue_number = response.number;' || chr(13) || chr(10) || '        result.tags.__zbx_github_repo = github.repo;' || chr(13) || chr(10) || '        result.tags.__zbx_github_link = response.html_url;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Zabbix.log(4, ''[ Github Webhook ] Result: '' + JSON.stringify(result));' || chr(13) || chr(10) || '    return JSON.stringify(result);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '    Zabbix.log(4, ''[ Github Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_github_link}','Github: Issue {EVENT.TAGS.__zbx_github_issue_number}','')
/

INSERT INTO media_type (mediatypeid,type,name,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,username,passwd,status,smtp_port,smtp_security,smtp_verify_peer,smtp_verify_host,smtp_authentication,exec_params,maxsessions,maxattempts,attempt_interval,content_type,script,timeout,process_tags,show_event_menu,event_menu_url,event_menu_name,description)
values ('33','4','GLPi','','','','','','','','0','25','0','0','0','0','','1','1','10s','1',TO_NCLOB('var GLPi = {' || chr(13) || chr(10) || '    params: {},' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setParams: function (params) {' || chr(13) || chr(10) || '        if (typeof params !== ''object'') {' || chr(13) || chr(10) || '            return;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '        GLPi.params = params;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    setProxy: function (HTTPProxy) {' || chr(13) || chr(10) || '        GLPi.HTTPProxy = HTTPProxy;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    urlCheckFormat: function (url) {' || chr(13) || chr(10) || '        if (typeof url === ''string'' && !url.endsWith(''/'')) {' || chr(13) || chr(10) || '            url += ''/'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (url.indexOf(''http://'') === -1 && url.indexOf(''https://'') === -1) {' || chr(13) || chr(10) || '            url = ''https://'' + url;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return url;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    getAuthToken: function (url, token) {' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '        request.addHeader(''Authorization: user_token '' + token);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        response = request.get(url + "apirest.php/initSession");' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '')||
TO_NCLOB('            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ GLPi Webhook ] Failed to receive authentication token from GLPi.'');' || chr(13) || chr(10) || '                response = null;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (Array.isArray(response)) {' || chr(13) || chr(10) || '            if (response[1]) {' || chr(13) || chr(10) || '                throw ''Error received from GLPi: '' + response[1];' || chr(13) || chr(10) || '            } else {' || chr(13) || chr(10) || '                throw ''Failed to receive authentication token from GLPi.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof response !== ''object'' || !response.session_token) {' || chr(13) || chr(10) || '            throw ''Failed to process response received from getting GLPi authentication token. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return response.session_token;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    getProblemUrl: function (zabbix_url, triggerid, eventid, event_source) {' || chr(13) || chr(10) || '        var problem_url = zabbix_url;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (event_source === ''0'') {' || chr(13) || chr(10) || '            problem_url += ''tr_events.php?triggerid='' + triggerid + ''&eventid='' + eventid;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return problem_url;' || chr(13) || chr(10) || '    },' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    request: function (method, url, data) {' || chr(13) || chr(10) || '')||
TO_NCLOB('        if (typeof GLPi.params !== ''object'' || typeof GLPi.params.authToken === ''undefined'' || GLPi.params.authToken === '''') {' || chr(13) || chr(10) || '            throw ''Required GLPi param authToken is not set.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        var response,' || chr(13) || chr(10) || '            request = new HttpRequest();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        request.addHeader(''Content-Type: application/json'');' || chr(13) || chr(10) || '        request.addHeader(''Session-Token:'' + GLPi.params.authToken);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof GLPi.HTTPProxy !== ''undefined'' && GLPi.HTTPProxy !== '''') {' || chr(13) || chr(10) || '            request.setProxy(GLPi.HTTPProxy);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof data !== ''undefined'') {' || chr(13) || chr(10) || '            data = JSON.stringify(data);' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ GLPi Webhook ] Sending request: '' + url + ((typeof data === ''string'')' || chr(13) || chr(10) || '            ? (''\n'' + data)' || chr(13) || chr(10) || '            : ''''));' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        switch (method) {' || chr(13) || chr(10) || '            case ''post'':' || chr(13) || chr(10) || '                response = request.post(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            case ''put'':' || chr(13) || chr(10) || '                response = request.put(url, data);' || chr(13) || chr(10) || '                break;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            default:' || chr(13) || chr(10) || '                throw ''Unsupported HTTP request method: '' + method;' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        Zabbix.log(4, ''[ GLPi Webhook ] Received response with status code '' +' || chr(13) || chr(10) || '')||
TO_NCLOB('            request.getStatus() + ''\n'' + response);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (response !== null) {' || chr(13) || chr(10) || '            try {' || chr(13) || chr(10) || '                response = JSON.parse(response);' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            catch (error) {' || chr(13) || chr(10) || '                Zabbix.log(4, ''[ GLPi Webhook ] Failed to parse response received from GLPi'');' || chr(13) || chr(10) || '                response = null;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (typeof response !== ''object'' || typeof response === ''undefined'' || response === null) {' || chr(13) || chr(10) || '            throw ''Failed to process response received from GLPi. Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        if (request.getStatus() < 200 || request.getStatus() >= 300) {' || chr(13) || chr(10) || '            var message = ''Request failed with status code '' + request.getStatus();' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            if (response.message) {' || chr(13) || chr(10) || '                message += '': '' + response.message;' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '            throw message + '' Check debug log for more information.'';' || chr(13) || chr(10) || '        }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        return response;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '};' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'try {' || chr(13) || chr(10) || '    var params = JSON.parse(value),' || chr(13) || chr(10) || '        glpi = {},' || chr(13) || chr(10) || '        url = '''',' || chr(13) || chr(10) || '        data = {},' || chr(13) || chr(10) || '        comment_data,' || chr(13) || chr(10) || '')||
TO_NCLOB('        result = { tags: {} },' || chr(13) || chr(10) || '        required_params = [' || chr(13) || chr(10) || '            ''alert_subject'', ''alert_message'', ''event_source'', ''event_value'',' || chr(13) || chr(10) || '            ''event_update_status'', ''event_recovery_value'',' || chr(13) || chr(10) || '            ''event_id'', ''trigger_id'', ''zabbix_url'',' || chr(13) || chr(10) || '            ''glpi_token'', ''glpi_url''' || chr(13) || chr(10) || '        ],' || chr(13) || chr(10) || '        method = ''post'',' || chr(13) || chr(10) || '        process_tags = true,' || chr(13) || chr(10) || '        response;' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Object.keys(params)' || chr(13) || chr(10) || '        .forEach(function (key) {' || chr(13) || chr(10) || '            if (key.startsWith(''glpi_'')) {' || chr(13) || chr(10) || '                glpi[key.substring(5)] = params[key];' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '            else if (required_params.indexOf(key) !== -1 && params[key] === '''') {' || chr(13) || chr(10) || '                throw ''Parameter "'' + key + ''" can\''t be empty.'';' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        });' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_source" parameter given: '' + params.event_source + ''\nMust be 0-3.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.VALUE} for trigger-based and internal events.' || chr(13) || chr(10) || '    if (params.event_value !== ''0'' && params.event_value !== ''1''' || chr(13) || chr(10) || '        && (params.event_source === ''0'' || params.event_source === ''3'')) {' || chr(13) || chr(10) || '        throw ''Incorrect "event_value" parameter given: '' + params.event_value + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '')||
TO_NCLOB('    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.' || chr(13) || chr(10) || '    if (params.event_update_status !== ''0'' && params.event_update_status !== ''1'' && params.event_source === ''0'') {' || chr(13) || chr(10) || '        throw ''Incorrect "event_update_status" parameter given: '' + params.event_update_status + ''\nMust be 0 or 1.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (params.event_source !== ''0'' && params.event_recovery_value === ''0'') {' || chr(13) || chr(10) || '        throw ''Recovery operations are supported only for trigger-based actions.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (typeof params.zabbix_url !== ''string'' || params.zabbix_url.trim() === '''' || params.zabbix_url === ''{$ZABBIX.URL}'') {' || chr(13) || chr(10) || '        throw ''Field "zabbix_url" cannot be empty.'';' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // Check for backslash in the end of url and schema.' || chr(13) || chr(10) || '    glpi.url = GLPi.urlCheckFormat(glpi.url);' || chr(13) || chr(10) || '    params.zabbix_url = GLPi.urlCheckFormat(params.zabbix_url);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    glpi.authToken = GLPi.getAuthToken(glpi.url, glpi.token);' || chr(13) || chr(10) || '    GLPi.setParams(glpi);' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    data = {' || chr(13) || chr(10) || '        ''input'': {' || chr(13) || chr(10) || '            ''name'': params.alert_subject,' || chr(13) || chr(10) || '            ''content'': params.alert_message + ''\n<a href='' + GLPi.getProblemUrl(params.zabbix_url, params.trigger_id, params.event_id, params.event_source) + ''>Link to problem in Zabbix</a>'',' || chr(13) || chr(10) || '            ''status'': 1,  // Set status "New"' || chr(13) || chr(10) || '            ''urgency'': params.event_nseverity' || chr(13) || chr(10) || '')||
TO_NCLOB('        }' || chr(13) || chr(10) || '    };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // In case of resolve' || chr(13) || chr(10) || '    if (params.event_source === ''0'' && params.event_value === ''0'') {' || chr(13) || chr(10) || '        process_tags = false;' || chr(13) || chr(10) || '        dataFollowup = {' || chr(13) || chr(10) || '            ''input'': {' || chr(13) || chr(10) || '                ''items_id'': glpi.problem_id,' || chr(13) || chr(10) || '                ''itemtype'': ''Problem'',' || chr(13) || chr(10) || '                ''content'': params.alert_message + ''\n<a href='' + GLPi.getProblemUrl(params.zabbix_url, params.trigger_id, params.event_id, params.event_source) + ''>Link to problem in Zabbix</a>''' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '        dataProblem = {' || chr(13) || chr(10) || '            ''id'': glpi.problem_id,' || chr(13) || chr(10) || '            ''input'': {' || chr(13) || chr(10) || '                ''name'': params.alert_subject,' || chr(13) || chr(10) || '                ''status'': 5,  // Set status "Solved"' || chr(13) || chr(10) || '                ''urgency'': params.event_nseverity' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        GLPi.request(''put'', glpi.url + ''apirest.php/Problem/'' + glpi.problem_id, dataProblem);' || chr(13) || chr(10) || '        GLPi.request(''post'', glpi.url + ''apirest.php/Problem/'' + glpi.problem_id + ''/ITILFollowup'', dataFollowup);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // In case of update' || chr(13) || chr(10) || '    else if (params.event_source === ''0'' && params.event_update_status === ''1'') {' || chr(13) || chr(10) || '        process_tags = false;' || chr(13) || chr(10) || '        dataFollowup = {' || chr(13) || chr(10) || '            ''input'': {' || chr(13) || chr(10) || '')||
TO_NCLOB('                ''items_id'': glpi.problem_id,' || chr(13) || chr(10) || '                ''itemtype'': ''Problem'',' || chr(13) || chr(10) || '                ''content'': params.alert_message + ''\n<a href='' + GLPi.getProblemUrl(params.zabbix_url, params.trigger_id, params.event_id, params.event_source) + ''>Link to problem in Zabbix</a>''' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '        dataProblem = {' || chr(13) || chr(10) || '            ''id'': glpi.problem_id,' || chr(13) || chr(10) || '            ''input'': {' || chr(13) || chr(10) || '                ''name'': params.alert_subject,' || chr(13) || chr(10) || '                ''urgency'': params.event_nseverity' || chr(13) || chr(10) || '            }' || chr(13) || chr(10) || '        };' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '        GLPi.request(''put'', glpi.url + ''apirest.php/Problem/'' + glpi.problem_id, dataProblem);' || chr(13) || chr(10) || '        GLPi.request(''post'', glpi.url + ''apirest.php/Problem/'' + glpi.problem_id + ''/ITILFollowup'', dataFollowup);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    // In case of problem' || chr(13) || chr(10) || '    else {' || chr(13) || chr(10) || '        response = GLPi.request(''post'', glpi.url + ''apirest.php/Problem/'', data);' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    if (process_tags) {' || chr(13) || chr(10) || '        result.tags.__zbx_glpi_problem_id = response.id;' || chr(13) || chr(10) || '        result.tags.__zbx_glpi_link = glpi.url + ''front/problem.form.php?id='' + response.id;' || chr(13) || chr(10) || '    }' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '    Zabbix.log(4, ''[ GLPi Webhook ] Result: '' + JSON.stringify(result));' || chr(13) || chr(10) || '    return JSON.stringify(result);' || chr(13) || chr(10) || '}' || chr(13) || chr(10) || 'catch (error) {' || chr(13) || chr(10) || '')||
TO_NCLOB('    Zabbix.log(4, ''[ GLPi Webhook ] ERROR: '' + error);' || chr(13) || chr(10) || '    throw ''Sending failed: '' + error;' || chr(13) || chr(10) || '')||
TO_NCLOB('}'),'30s','1','1','{EVENT.TAGS.__zbx_glpi_link}','GLPi: Problem {EVENT.TAGS.__zbx_glpi_problem_id}','')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('1','5','zabbix_url','{$ZABBIX.URL}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('2','5','bot_token','<YOUR BOT TOKEN>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('3','5','mattermost_url','<YOUR MATTERMOST URL>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('4','5','send_mode','alarm')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('5','5','send_to','{ALERT.SENDTO}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('6','5','event_tags','{EVENT.TAGS}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('8','5','event_nseverity','{EVENT.NSEVERITY}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('10','5','event_value','{EVENT.VALUE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('11','5','event_update_status','{EVENT.UPDATE.STATUS}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('12','5','event_date','{EVENT.DATE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('13','5','event_time','{EVENT.TIME}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('14','5','event_severity','{EVENT.SEVERITY}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('15','5','event_opdata','{EVENT.OPDATA}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('16','5','event_id','{EVENT.ID}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('18','5','trigger_id','{TRIGGER.ID}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('19','5','trigger_description','{TRIGGER.DESCRIPTION}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('20','5','host_name','{HOST.HOST}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('21','5','host_ip','{HOST.IP}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('22','5','event_update_date','{EVENT.UPDATE.DATE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('23','5','event_update_time','{EVENT.UPDATE.TIME}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('24','5','event_recovery_date','{EVENT.RECOVERY.DATE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('25','5','event_recovery_time','{EVENT.RECOVERY.TIME}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('37','6','zbxurl','{$ZABBIX.URL}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('39','7','token','<put your key>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('40','7','eventid','{EVENT.ID}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('41','7','eventname','{ALERT.SUBJECT}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('42','7','hostname','{HOST.NAME}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('43','7','hostip','{HOST.IP}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('44','7','severity','{EVENT.NSEVERITY}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('45','7','triggerdesc','{TRIGGER.DESCRIPTION}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('46','7','triggeropdata','{EVENT.OPDATA}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('47','7','eventtags','{EVENT.TAGS}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('48','7','triggerid','{TRIGGER.ID}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('49','7','eventdate','{EVENT.DATE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('50','7','eventtime','{EVENT.TIME}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('52','7','eventack','{EVENT.ACK.STATUS}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('53','7','eventupdate','{EVENT.UPDATE.STATUS}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('54','7','eventvalue','{EVENT.VALUE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('55','7','url','{$ZABBIX.URL}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('56','8','token','<PUSHOVER TOKEN HERE>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('57','8','user','{ALERT.SENDTO}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('58','8','message','{ALERT.MESSAGE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('59','8','title','{ALERT.SUBJECT}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('60','8','url','{$ZABBIX.URL}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('61','8','url_title','Zabbix')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('63','8','eventid','{EVENT.ID}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('64','8','triggerid','{TRIGGER.ID}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('65','9','zabbix_url','{$ZABBIX.URL}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('66','9','bot_token','<PLACE YOUR KEY HERE>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('67','9','channel','{ALERT.SENDTO}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('68','9','slack_mode','alarm')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('69','9','slack_as_user','true')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('71','9','event_tags','{EVENT.TAGSJSON}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('73','9','event_nseverity','{EVENT.NSEVERITY}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('75','9','event_value','{EVENT.VALUE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('76','9','event_update_status','{EVENT.UPDATE.STATUS}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('77','9','event_date','{EVENT.DATE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('78','9','event_time','{EVENT.TIME}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('79','9','event_severity','{EVENT.SEVERITY}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('80','9','event_opdata','{EVENT.OPDATA}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('81','9','event_id','{EVENT.ID}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('83','9','trigger_id','{TRIGGER.ID}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('84','9','trigger_description','{TRIGGER.DESCRIPTION}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('85','9','host_name','{HOST.NAME}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('87','9','event_update_date','{EVENT.UPDATE.DATE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('88','9','event_update_time','{EVENT.UPDATE.TIME}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('89','9','event_recovery_date','{EVENT.RECOVERY.DATE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('90','9','event_recovery_time','{EVENT.RECOVERY.TIME}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('91','10','zabbix_url','{$ZABBIX.URL}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('92','10','discord_endpoint','{ALERT.SENDTO}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('93','10','use_default_message','false')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('94','10','alert_message','{ALERT.MESSAGE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('95','10','alert_subject','{ALERT.SUBJECT}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('96','10','event_name','{EVENT.NAME}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('97','10','event_id','{EVENT.ID}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('98','10','event_severity','{EVENT.SEVERITY}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('99','10','event_nseverity','{EVENT.NSEVERITY}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('100','10','event_opdata','{EVENT.OPDATA}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('101','10','event_tags','{EVENT.TAGS}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('102','10','event_time','{EVENT.TIME}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('103','10','event_date','{EVENT.DATE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('104','10','event_recovery_date','{EVENT.RECOVERY.DATE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('105','10','event_recovery_time','{EVENT.RECOVERY.TIME}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('106','10','event_update_date','{EVENT.UPDATE.DATE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('107','10','event_update_time','{EVENT.UPDATE.TIME}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('108','10','event_update_action','{EVENT.UPDATE.ACTION}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('109','10','event_update_message','{EVENT.UPDATE.MESSAGE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('110','10','event_update_status','{EVENT.UPDATE.STATUS}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('111','10','event_update_user','{USER.FULLNAME}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('112','10','event_value','{EVENT.VALUE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('113','10','host_ip','{HOST.IP}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('114','10','host_name','{HOST.NAME}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('115','10','trigger_description','{TRIGGER.DESCRIPTION}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('116','10','trigger_id','{TRIGGER.ID}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('117','8','endpoint','https://api.pushover.net/1/messages.json')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('118','8','retry','60')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('119','8','expire','1200')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('120','11','teamsecret','{ALERT.SENDTO}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('121','11','Subject','{ALERT.SUBJECT}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('122','11','Message','{ALERT.MESSAGE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('123','11','Severity','{EVENT.SEVERITY}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('125','11','Hostname','{HOST.NAME}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('127','12','alert_message','{ALERT.MESSAGE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('128','12','alert_subject','{ALERT.SUBJECT}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('129','12','event_recovery_value','{EVENT.RECOVERY.VALUE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('130','12','event_source','{EVENT.SOURCE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('131','12','event_tags_json','{EVENT.TAGSJSON}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('132','12','event_update_action','{EVENT.UPDATE.ACTION}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('133','12','event_update_message','{EVENT.UPDATE.MESSAGE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('134','12','event_update_status','{EVENT.UPDATE.STATUS}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('135','12','event_update_user','{USER.FULLNAME}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('136','12','event_value','{EVENT.VALUE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('137','12','jira_issue_key','{EVENT.TAGS.__zbx_jira_issuekey}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('138','12','jira_issue_type','<PLACE ISSUETYPE NAME>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('139','12','jira_password','<PLACE PASSWORD OR TOKEN>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('140','12','jira_project_key','<PLACE PROJECT KEY>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('141','12','jira_url','<PLACE YOUR JIRA URL>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('142','12','jira_user','<PLACE LOGIN>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('143','12','trigger_description','{TRIGGER.DESCRIPTION}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('144','13','<''DATETIME'' CUSTOMFIELD FOR EVENT RECOVERY TIME>','{EVENT.RECOVERY.DATE}T{EVENT.RECOVERY.TIME}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('145','13','<''DATETIME'' CUSTOMFIELD FOR EVENT TIME>','{EVENT.DATE}T{EVENT.TIME}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('146','13','<''NUMBER'' CUSTOMFIELD FOR EVENT.ID>','{EVENT.ID}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('147','13','<''NUMBER'' CUSTOMFIELD FOR TRIGGER.ID>','{TRIGGER.ID}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('148','13','<''STRING'' CUSTOMFIELD FOR HOST\IP>','{HOST.HOST} [{HOST.IP}]')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('149','13','<''STRING'' CUSTOMFIELD FOR OPERATIONAL DATA>','{EVENT.OPDATA}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('150','13','<''STRING'' CUSTOMFIELD FOR SEVERITY>','{EVENT.SEVERITY}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('151','13','<''URL'' CUSTOMFIELD FOR EVENT URL>','{$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('152','13','alert_message','{ALERT.MESSAGE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('153','13','alert_subject','{ALERT.SUBJECT}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('154','13','event_recovery_value','{EVENT.RECOVERY.VALUE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('155','13','event_source','{EVENT.SOURCE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('156','13','event_tags_json','{EVENT.TAGSJSON}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('157','13','event_update_action','{EVENT.UPDATE.ACTION}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('158','13','event_update_message','{EVENT.UPDATE.MESSAGE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('159','13','event_update_status','{EVENT.UPDATE.STATUS}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('160','13','event_update_user','{USER.FULLNAME}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('161','13','event_value','{EVENT.VALUE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('162','13','jira_issue_key','{EVENT.TAGS.__zbx_jira_issuekey}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('163','13','jira_issue_type','<PLACE ISSUETYPE NAME>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('164','13','jira_password','<PLACE PASSWORD OR TOKEN>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('165','13','jira_project_key','<PLACE PROJECT KEY>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('166','13','jira_url','<PLACE YOUR JIRA URL>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('167','13','jira_user','<PLACE LOGIN>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('168','13','trigger_description','{TRIGGER.DESCRIPTION}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('169','14','alert_message','{ALERT.MESSAGE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('170','14','alert_subject','{ALERT.SUBJECT}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('171','14','event_date','{EVENT.DATE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('172','14','event_id','{EVENT.ID}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('173','14','event_nseverity','{EVENT.NSEVERITY}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('174','14','event_opdata','{EVENT.OPDATA}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('175','14','event_recovery_date','{EVENT.RECOVERY.DATE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('176','14','event_recovery_time','{EVENT.RECOVERY.TIME}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('177','14','event_severity','{EVENT.SEVERITY}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('178','14','event_source','{EVENT.SOURCE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('179','14','event_status','{EVENT.STATUS}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('180','14','event_tags','{EVENT.TAGS}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('181','14','event_time','{EVENT.TIME}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('182','14','event_update_action','{EVENT.UPDATE.ACTION}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('183','14','event_update_date','{EVENT.UPDATE.DATE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('184','14','event_update_message','{EVENT.UPDATE.MESSAGE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('185','14','event_update_status','{EVENT.UPDATE.STATUS}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('186','14','event_update_time','{EVENT.UPDATE.TIME}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('187','14','event_update_user','{USER.FULLNAME}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('188','14','event_value','{EVENT.VALUE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('189','14','host_ip','{HOST.IP}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('190','14','host_name','{HOST.NAME}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('191','14','teams_endpoint','<PLACE WEBHOOK URL HERE>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('192','14','trigger_description','{TRIGGER.DESCRIPTION}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('193','14','trigger_id','{TRIGGER.ID}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('194','14','use_default_message','false')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('195','14','zabbix_url','{$ZABBIX.URL}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('196','15','alert_message','{ALERT.MESSAGE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('197','15','alert_subject','{ALERT.SUBJECT}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('198','15','event_id','{EVENT.ID}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('199','15','event_nseverity','{EVENT.NSEVERITY}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('200','15','event_source','{EVENT.SOURCE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('201','15','event_update_message','{EVENT.UPDATE.MESSAGE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('202','15','event_update_status','{EVENT.UPDATE.STATUS}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('203','15','event_value','{EVENT.VALUE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('204','15','redmine_access_key','<PUT YOUR ACCESS KEY>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('205','15','redmine_issue_key','{EVENT.TAGS.__zbx_redmine_issue_id}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('206','15','redmine_project','<PUT YOUR PROJECT ID OR NAME>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('207','15','redmine_tracker_id','<PUT YOUR TRACKER ID>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('208','15','redmine_url','<PUT YOUR REDMINE URL>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('209','15','trigger_id','{TRIGGER.ID}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('210','15','zabbix_url','{$ZABBIX.URL}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('211','16','Message','{ALERT.MESSAGE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('212','16','ParseMode','')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('213','16','Subject','{ALERT.SUBJECT}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('214','16','To','{ALERT.SENDTO}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('215','16','Token','<PLACE YOUR TOKEN>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('216','17','alert_message','{ALERT.MESSAGE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('217','17','alert_subject','{ALERT.SUBJECT}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('218','17','event_id','{EVENT.ID}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('219','17','event_nseverity','{EVENT.NSEVERITY}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('220','17','event_source','{EVENT.SOURCE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('221','17','event_tags','{EVENT.TAGS}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('222','17','event_update_status','{EVENT.UPDATE.STATUS}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('223','17','event_value','{EVENT.VALUE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('224','17','severity_average','normal')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('225','17','severity_default','-')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('226','17','severity_disaster','urgent')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('227','17','severity_high','high')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('228','17','severity_information','low')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('229','17','severity_not_classified','low')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('230','17','severity_warning','normal')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('231','17','trigger_id','{TRIGGER.ID}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('232','17','zbxurl','{$ZABBIX.URL}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('233','17','zendesk_issue_key','{EVENT.TAGS.__zbx_zdk_issuekey}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('234','17','zendesk_token','<put your {enduser_email_address}/token:{api_token}>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('235','17','zendesk_type','incident')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('236','17','zendesk_url','<put your Zendesk URL>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('237','18','alert_message','{ALERT.MESSAGE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('238','18','alert_subject','{ALERT.SUBJECT}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('239','18','event_nseverity','{EVENT.NSEVERITY}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('240','18','event_recovery_value','{EVENT.RECOVERY.VALUE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('241','18','event_source','{EVENT.SOURCE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('242','18','event_update_status','{EVENT.UPDATE.STATUS}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('243','18','event_value','{EVENT.VALUE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('244','18','servicenow_password','<PLACE PASSWORD HERE>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('245','18','servicenow_sys_id','{EVENT.TAGS.__zbx_servicenow_sys_id}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('246','18','servicenow_url','{ALERT.SENDTO}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('247','18','servicenow_user','<PLACE USERNAME HERE>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('248','18','urgency_for_average','2')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('249','18','urgency_for_disaster','1')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('250','18','urgency_for_high','2')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('251','18','urgency_for_information','3')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('252','18','urgency_for_not_classified','3')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('253','18','urgency_for_warning','3')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('254','19','alert_message','{ALERT.MESSAGE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('255','19','alert_subject','{ALERT.SUBJECT}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('256','19','event_id','{EVENT.ID}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('257','19','event_nseverity','{EVENT.NSEVERITY}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('258','19','event_source','{EVENT.SOURCE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('259','19','event_tags','{EVENT.TAGSJSON}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('260','19','event_update_message','{EVENT.UPDATE.MESSAGE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('261','19','event_update_status','{EVENT.UPDATE.STATUS}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('262','19','event_value','{EVENT.VALUE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('263','19','trigger_id','{TRIGGER.ID}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('264','19','zabbix_url','{$ZABBIX.URL}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('265','19','zammad_access_token','<PUT YOUR ACCESS TOKEN>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('266','19','zammad_customer','<PUT YOUR CUSTOMER EMAIL>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('267','19','zammad_enable_tags','true')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('268','19','zammad_ticket_id','{EVENT.TAGS.__zbx_zammad_ticket_id}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('269','19','zammad_url','<PUT YOUR ZAMMAD URL>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('270','20','alert_message','{ALERT.MESSAGE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('271','20','alert_subject','{ALERT.SUBJECT}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('272','20','event_recovery_value','{EVENT.RECOVERY.VALUE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('273','20','event_source','{EVENT.SOURCE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('274','20','event_tags_json','{EVENT.TAGSJSON}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('275','20','event_update_status','{EVENT.UPDATE.STATUS}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('276','20','event_value','{EVENT.VALUE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('277','20','jira_password','<PLACE PASSWORD OR TOKEN>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('278','20','jira_request_key','{EVENT.TAGS.__zbx_jira_requestkey}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('279','20','jira_request_type_id','<PLACE REQUEST TYPE ID>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('280','20','jira_servicedesk_id','<PLACE SERVICEDESK ID>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('281','20','jira_url','<PLACE YOUR JIRA URL>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('282','20','jira_user','<PLACE LOGIN>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('283','21','alert_message','{ALERT.MESSAGE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('284','21','alert_subject','{ALERT.SUBJECT}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('285','21','event_id','{EVENT.ID}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('286','21','event_nseverity','{EVENT.NSEVERITY}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('287','21','event_source','{EVENT.SOURCE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('288','21','event_update_message','{EVENT.UPDATE.MESSAGE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('289','21','event_update_status','{EVENT.UPDATE.STATUS}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('290','21','event_value','{EVENT.VALUE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('291','21','otrs_auth_password','<PUT YOUR USER PASSWORD>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('292','21','otrs_auth_user','<PUT YOUR USER NAME>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('293','21','otrs_customer','<PUT YOUR CUSTOMER EMAIL>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('294','21','otrs_default_priority_id','3')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('295','21','otrs_queue','<PUT YOUR QUEUE NAME>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('296','21','otrs_ticket_id','{EVENT.TAGS.__zbx_otrs_ticket_id}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('297','21','otrs_ticket_state','new')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('298','21','otrs_time_unit','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('299','21','otrs_url','<PUT YOUR OTRS URL>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('300','21','trigger_id','{TRIGGER.ID}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('301','21','zabbix_url','{$ZABBIX.URL}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('302','11','Event_Ack_Status','{EVENT.ACK.STATUS}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('303','11','Event_Date_Time','{EVENT.DATE} {EVENT.TIME}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('304','11','Event_ID','{EVENT.ID}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('305','11','Event_Update_Action','{EVENT.UPDATE.ACTION}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('306','11','Event_Update_Status','{EVENT.UPDATE.STATUS}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('307','11','Host_IP','{HOST.IP}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('308','11','Trigger_ID','{TRIGGER.ID}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('309','11','Trigger_Status','{TRIGGER.STATUS}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('310','11','User','{USER.FULLNAME}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('311','11','Zabbix_URL','{$ZABBIX.URL}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('312','10','event_source','{EVENT.SOURCE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('313','22','.ILERT.ALERT.SOURCE.KEY','{ALERT.SENDTO}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('314','22','.ILERT.INCIDENT.SUMMARY','')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('315','22','ALERT.MESSAGE','{ALERT.MESSAGE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('316','22','ALERT.SUBJECT','{ALERT.SUBJECT}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('317','22','EVENT.ACK.STATUS','{EVENT.ACK.STATUS}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('318','22','EVENT.DATE','{EVENT.DATE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('319','22','EVENT.ID','{EVENT.ID}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('320','22','EVENT.NAME','{EVENT.NAME}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('321','22','EVENT.NSEVERITY','{EVENT.NSEVERITY}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('322','22','EVENT.OPDATA','{EVENT.OPDATA}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('323','22','EVENT.RECOVERY.DATE','{EVENT.RECOVERY.DATE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('324','22','EVENT.RECOVERY.TIME','{EVENT.RECOVERY.TIME}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('325','22','EVENT.RECOVERY.VALUE','{EVENT.RECOVERY.VALUE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('326','22','EVENT.SEVERITY','{EVENT.SEVERITY}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('327','22','EVENT.TAGS','{EVENT.TAGS}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('328','22','EVENT.TIME','{EVENT.TIME}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('329','22','EVENT.UPDATE.ACTION','{EVENT.UPDATE.ACTION}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('330','22','EVENT.UPDATE.DATE','{EVENT.UPDATE.DATE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('331','22','EVENT.UPDATE.MESSAGE','{EVENT.UPDATE.MESSAGE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('332','22','EVENT.UPDATE.STATUS','{EVENT.UPDATE.STATUS}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('333','22','EVENT.UPDATE.TIME','{EVENT.UPDATE.TIME}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('334','22','EVENT.VALUE','{EVENT.VALUE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('335','22','HOST.HOST','{HOST.HOST}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('336','22','HOST.IP','{HOST.IP}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('337','22','HOST.NAME','{HOST.NAME}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('338','22','ITEM.ID1','{ITEM.ID1}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('339','22','ITEM.ID2','{ITEM.ID2}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('340','22','ITEM.ID3','{ITEM.ID3}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('341','22','ITEM.ID4','{ITEM.ID4}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('342','22','ITEM.ID5','{ITEM.ID5}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('343','22','ITEM.NAME1','{ITEM.NAME1}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('344','22','ITEM.NAME2','{ITEM.NAME2}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('345','22','ITEM.NAME3','{ITEM.NAME3}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('346','22','ITEM.NAME4','{ITEM.NAME4}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('347','22','ITEM.NAME5','{ITEM.NAME5}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('348','22','TRIGGER.DESCRIPTION','{TRIGGER.DESCRIPTION}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('349','22','TRIGGER.ID','{TRIGGER.ID}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('350','22','TRIGGER.NAME','{TRIGGER.NAME}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('351','22','TRIGGER.SEVERITY','{TRIGGER.SEVERITY}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('352','22','TRIGGER.STATUS','{TRIGGER.STATUS}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('353','22','TRIGGER.URL','{TRIGGER.URL}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('354','22','TRIGGER.VALUE','{TRIGGER.VALUE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('355','22','USER.FULLNAME','{USER.FULLNAME}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('356','22','ZABBIX.URL','{$ZABBIX.URL}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('357','5','alert_message','{ALERT.MESSAGE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('358','5','alert_subject','{ALERT.SUBJECT}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('359','5','discovery_host_dns','{DISCOVERY.DEVICE.DNS}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('360','5','discovery_host_ip','{DISCOVERY.DEVICE.IPADDRESS}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('361','5','event_source','{EVENT.SOURCE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('362','6','alert_message','{ALERT.MESSAGE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('363','6','alert_subject','{ALERT.SUBJECT}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('364','6','event_id','{EVENT.ID}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('365','6','event_nseverity','{EVENT.NSEVERITY}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('366','6','event_source','{EVENT.SOURCE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('367','6','event_tags_json','{EVENT.TAGSJSON}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('368','6','event_update_status','{EVENT.UPDATE.STATUS}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('369','6','event_value','{EVENT.VALUE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('370','6','opsgenie_api','<put your opsgenie api>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('371','6','opsgenie_tags','')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('372','6','opsgenie_teams','')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('373','6','opsgenie_token','<put your token>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('374','6','opsgenie_web','<put your opsgenie web>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('375','6','severity_average','P3')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('376','6','severity_default','P5')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('377','6','severity_disaster','P1')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('378','6','severity_high','P2')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('379','6','severity_information','P5')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('380','6','severity_not_classified','P5')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('381','6','severity_warning','P4')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('382','6','trigger_id','{TRIGGER.ID}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('383','6','zbxuser','{USER.FULLNAME}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('384','7','alert_message','{ALERT.MESSAGE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('385','7','event_source','{EVENT.SOURCE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('386','8','event_nseverity','{EVENT.NSEVERITY}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('387','8','event_source','{EVENT.SOURCE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('388','8','event_value','{EVENT.VALUE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('389','8','priority_average','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('390','8','priority_default','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('391','8','priority_disaster','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('392','8','priority_high','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('393','8','priority_information','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('394','8','priority_not_classified','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('395','8','priority_warning','0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('396','9','alert_message','{ALERT.MESSAGE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('397','9','alert_subject','{ALERT.SUBJECT}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('398','9','discovery_host_dns','{DISCOVERY.DEVICE.DNS}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('399','9','discovery_host_ip','{DISCOVERY.DEVICE.IPADDRESS}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('400','9','event_source','{EVENT.SOURCE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('401','9','host_conn','{HOST.CONN}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('402','23','alert_message','{ALERT.MESSAGE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('403','23','alert_subject','{ALERT.SUBJECT}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('404','23','event_nseverity','{EVENT.NSEVERITY}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('405','23','event_recovery_value','{EVENT.RECOVERY.VALUE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('406','23','event_source','{EVENT.SOURCE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('407','23','event_update_status','{EVENT.UPDATE.STATUS}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('408','23','event_value','{EVENT.VALUE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('409','23','priority_average','Medium')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('410','23','priority_default','Low')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('411','23','priority_disaster','Critical')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('412','23','priority_high','High')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('413','23','samanage_incident_id','{EVENT.TAGS.__zbx_solarwinds_inc_id}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('414','23','samanage_token','<PUT YOUR TOKEN HERE>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('415','23','samanage_url','<PUT YOUR INSTANCE URL HERE>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('416','24','alert_message','{ALERT.MESSAGE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('417','24','alert_subject','{ALERT.SUBJECT}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('418','24','event_id','{EVENT.ID}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('419','24','event_nseverity','{EVENT.NSEVERITY}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('420','24','event_source','{EVENT.SOURCE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('421','24','event_update_message','{EVENT.UPDATE.MESSAGE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('422','24','event_update_status','{EVENT.UPDATE.STATUS}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('423','24','event_value','{EVENT.VALUE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('424','24','sysaid_auth_password','<PUT YOUR USER PASSWORD>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('425','24','sysaid_auth_user','<PUT YOUR USER NAME>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('426','24','sysaid_category_level_1','<PUT YOUR CATEGORY>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('427','24','sysaid_category_level_2','<PUT YOUR SUB-CATEGORY>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('428','24','sysaid_category_level_3','<PUT YOUR THIRD LEVEL CATEGORY>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('429','24','sysaid_default_priority_id','1')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('430','24','sysaid_incident_id','{EVENT.TAGS.__zbx_sysaid_incident_id}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('431','24','sysaid_incident_state','1')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('432','24','sysaid_template_id','<PUT YOUR TEMPLATE ID>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('433','24','sysaid_urgency_id','<PUT YOUR URGENCY ID>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('434','24','sysaid_url','<PUT YOUR SYSAID URL>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('435','24','trigger_id','{TRIGGER.ID}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('436','24','zabbix_url','{$ZABBIX.URL}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('437','25','alert_message','{ALERT.MESSAGE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('438','25','alert_subject','{ALERT.SUBJECT}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('439','25','event_id','{EVENT.ID}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('440','25','event_nseverity','{EVENT.NSEVERITY}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('441','25','event_source','{EVENT.SOURCE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('442','25','event_update_status','{EVENT.UPDATE.STATUS}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('443','25','event_value','{EVENT.VALUE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('444','25','severity_average','P3')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('445','25','severity_default','P5')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('446','25','severity_disaster','P1')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('447','25','severity_high','P2')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('448','25','severity_information','P5')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('449','25','severity_not_classified','P5')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('450','25','severity_warning','P4')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('451','25','topdesk_api','<put your TOPdesk API URL>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('452','25','topdesk_issue_key','{EVENT.TAGS.__zbx_tpd_issuekey}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('453','25','topdesk_password','<put your TOPdesk application password>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('454','25','topdesk_status','<put default status for new tickets>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('455','25','topdesk_user','<put your TOPdesk username>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('456','25','trigger_id','{TRIGGER.ID}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('457','25','zbxurl','{$ZABBIX.URL}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('458','26','alert_message','{ALERT.MESSAGE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('459','26','alert_subject','{ALERT.SUBJECT}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('460','26','event_recovery_value','{EVENT.RECOVERY.VALUE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('461','26','event_source','{EVENT.SOURCE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('462','26','event_update_status','{EVENT.UPDATE.STATUS}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('463','26','event_value','{EVENT.VALUE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('464','26','itop_api_version','1.3')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('465','26','itop_class','UserRequest')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('466','26','itop_comment','Created by Zabbix action {ACTION.NAME}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('467','26','itop_id','{EVENT.TAGS.__zbx_itop_id}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('468','26','itop_log','private_log')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('469','26','itop_organization_id','<PLACE ORGANIZATION ID>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('470','26','itop_password','<PLACE PASSWORD OR TOKEN>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('471','26','itop_url','<PLACE YOUR ITOP URL>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('472','26','itop_user','<PLACE LOGIN>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('473','27','alert_message','{ALERT.MESSAGE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('474','27','alert_subject','{ALERT.SUBJECT}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('475','27','event_nseverity','{EVENT.NSEVERITY}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('476','27','event_source','{EVENT.SOURCE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('477','27','event_update_action','{EVENT.UPDATE.ACTION}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('478','27','event_update_message','{EVENT.UPDATE.MESSAGE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('479','27','event_update_status','{EVENT.UPDATE.STATUS}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('480','27','event_update_user','{USER.FULLNAME}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('481','27','event_value','{EVENT.VALUE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('482','27','field_1_full:Host','{HOST.NAME} [{HOST.IP}]')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('483','27','field_2_short:Severity','{EVENT.SEVERITY}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('484','27','field_3_short:Event time','{EVENT.DATE} {EVENT.TIME}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('485','27','field_3_short_r:Recovery time','{EVENT.RECOVERY.DATE} {EVENT.RECOVERY.TIME}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('486','27','field_4_short_r:Event duration','{EVENT.DURATION}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('487','27','field_5_short:Operational data','{EVENT.OPDATA}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('488','27','field_999_full_p:Trigger description','{TRIGGER.DESCRIPTION}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('489','27','rc_api_url','api/v1/')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('490','27','rc_msg_id','{EVENT.TAGS.__zbx_rc_id}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('491','27','rc_room_id','{EVENT.TAGS.__zbx_rc_rid}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('492','27','rc_send_to','{ALERT.SENDTO}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('493','27','rc_title_link','{$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('494','27','rc_url','<PLACE YOUR INSTANCE URL HERE>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('495','27','rc_user_id','<PLACE USER ID HERE>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('496','27','rc_user_token','<PLACE TOKEN HERE>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('497','27','use_default_message','false')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('498','28','event_info','{$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('499','28','event_nseverity','{EVENT.NSEVERITY}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('500','28','event_recovery_value','{EVENT.RECOVERY.VALUE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('501','28','event_source','{EVENT.SOURCE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('502','28','event_update_status','{EVENT.UPDATE.STATUS}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('503','28','event_value','{EVENT.VALUE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('504','28','field:entity_display_name','{ALERT.SUBJECT}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('505','28','field:entity_id','{EVENT.ID}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('506','28','field:hostname','{HOST.NAME}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('507','28','field:monitoring_tool','Zabbix')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('508','28','field:operational_data','{EVENT.OPDATA}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('509','28','field:severity','{EVENT.SEVERITY}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('510','28','field:state_message','{ALERT.MESSAGE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('511','28','field_p:trigger_description','{TRIGGER.DESCRIPTION}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('512','28','field_r:event_duration','{EVENT.DURATION}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('513','28','field_r:recovery time','{EVENT.RECOVERY.DATE} {EVENT.RECOVERY.TIME}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('514','28','priority_average','WARNING')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('515','28','priority_default','INFO')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('516','28','priority_disaster','CRITICAL')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('517','28','priority_high','WARNING')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('518','28','priority_information','INFO')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('519','28','priority_not_classified','INFO')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('520','28','priority_resolved','OK')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('521','28','priority_update','INFO')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('522','28','priority_warning','INFO')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('523','28','vops_endpoint','<PLACE ENDPOINT URL HERE>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('524','28','vops_routing_key','{ALERT.SENDTO}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('525','29','endpoint','<PLACE HTTP API URL>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('526','29','flash','false')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('527','29','password','<PLACE PASSWORD>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('528','29','ring','false')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('529','29','send_to','{ALERT.SENDTO}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('530','29','telauto','true')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('531','29','text','{ALERT.MESSAGE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('532','29','username','<PLACE USERNAME>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('535','30','event_source','{EVENT.SOURCE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('536','30','event_update_status','{EVENT.UPDATE.STATUS}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('537','30','event_value','{EVENT.VALUE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('538','30','express_message','{ALERT.MESSAGE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('539','30','express_send_to','{ALERT.SENDTO}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('540','30','express_tags','{EVENT.TAGSJSON}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('541','30','express_token','<PLACE BOT TOKEN>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('542','30','express_url','<PLACE INSTANCE URL>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('543','31','event_nseverity','{EVENT.NSEVERITY}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('544','31','event_recovery_value','{EVENT.RECOVERY.VALUE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('545','31','event_source','{EVENT.SOURCE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('546','31','event_update_status','{EVENT.UPDATE.STATUS}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('547','31','event_value','{EVENT.VALUE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('548','31','field_ref:requester','<PLACE API USER NAME>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('549','31','field_string:description','{ALERT.MESSAGE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('550','31','field_string:subject','{ALERT.SUBJECT}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('551','31','priority_average','Normal')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('552','31','priority_default','Normal')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('553','31','priority_disaster','High')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('554','31','priority_high','High')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('555','31','priority_information','Low')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('556','31','priority_not_classified','Low')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('557','31','priority_warning','Medium')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('558','31','sd_on_demand_client_id','<PLACE ON DEMAND CLIENT ID>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('559','31','sd_on_demand_client_secret','<PLACE ON DEMAND CLIENT SECRET>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('560','31','sd_on_demand_refresh_token','<PLACE ON DEMAND REFRESH TOKEN>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('561','31','sd_on_demand_url_auth','<PLACE AUTHENTICATION URL FOR ON DEMAND>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('562','31','sd_on_premise','true')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('563','31','sd_on_premise_auth_token','<PLACE ON PREMISE TECHNICIAN_KEY>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('564','31','sd_request_id','{EVENT.TAGS.__zbx_sd_request_id}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('565','31','sd_url','<PLACE INSTANCE URL>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('566','31','trigger_description','{TRIGGER.DESCRIPTION}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('567','32','alert_message','{ALERT.MESSAGE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('568','32','alert_subject','{ALERT.SUBJECT}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('569','32','event_id','{EVENT.ID}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('570','32','event_recovery_value','{EVENT.RECOVERY.VALUE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('571','32','event_severity','{EVENT.SEVERITY}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('572','32','event_source','{EVENT.SOURCE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('573','32','event_update_status','{EVENT.UPDATE.STATUS}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('574','32','event_value','{EVENT.VALUE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('575','32','github_issue_number','{EVENT.TAGS.__zbx_github_issue_number}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('576','32','github_repo','{ALERT.SENDTO}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('577','32','github_token','<PLACE GITHUB TOKEN>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('578','32','github_url','https://api.github.com')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('579','32','github_user_agent','Zabbix/6.0')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('580','32','trigger_id','{TRIGGER.ID}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('581','32','zabbix_url','{$ZABBIX.URL}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('582','33','alert_message','{ALERT.MESSAGE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('583','33','alert_subject','{ALERT.SUBJECT}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('584','33','event_id','{EVENT.ID}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('585','33','event_nseverity','{EVENT.NSEVERITY}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('586','33','event_recovery_value','{EVENT.RECOVERY.VALUE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('587','33','event_source','{EVENT.SOURCE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('588','33','event_update_status','{EVENT.UPDATE.STATUS}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('589','33','event_value','{EVENT.VALUE}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('590','33','glpi_problem_id','{EVENT.TAGS.__zbx_glpi_problem_id}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('591','33','glpi_token','<PLACE GLPI TOKEN>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('592','33','glpi_url','<PLACE GLPI URL>')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('593','33','trigger_id','{TRIGGER.ID}')
/

INSERT INTO media_type_param (mediatype_paramid,mediatypeid,name,value)
values ('594','33','zabbix_url','{$ZABBIX.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('1','1','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('2','1','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Problem duration: {EVENT.DURATION}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('3','1','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('4','1','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('5','1','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('6','3','0','0','','{EVENT.SEVERITY}: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || '{EVENT.DATE} {EVENT.TIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('7','3','0','1','','Resolved in {EVENT.DURATION}: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || '{EVENT.DATE} {EVENT.TIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('8','3','0','2','','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem in {EVENT.AGE} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('9','3','1','0','','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('10','3','2','0','','Autoregistration: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('11','4','0','0','Problem: {EVENT.NAME}','<b>Problem started</b> at {EVENT.TIME} on {EVENT.DATE}<br><b>Problem name:</b> {EVENT.NAME}<br><b>Host:</b> {HOST.NAME}<br><b>Severity:</b> {EVENT.SEVERITY}<br><b>Operational data:</b> {EVENT.OPDATA}<br><b>Original problem ID:</b> {EVENT.ID}<br>{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('12','4','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','<b>Problem has been resolved</b> at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}<br><b>Problem name:</b> {EVENT.NAME}<br><b>Problem duration:</b> {EVENT.DURATION}<br><b>Host:</b> {HOST.NAME}<br><b>Severity:</b> {EVENT.SEVERITY}<br><b>Original problem ID:</b> {EVENT.ID}<br>{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('13','4','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','<b>{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem</b> at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.<br>{EVENT.UPDATE.MESSAGE}<br><br><b>Current problem status:</b> {EVENT.STATUS}<br><b>Age:</b> {EVENT.AGE}<br><b>Acknowledged:</b> {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('14','4','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','<b>Discovery rule:</b> {DISCOVERY.RULE.NAME}<br><br><b>Device IP:</b> {DISCOVERY.DEVICE.IPADDRESS}<br><b>Device DNS:</b> {DISCOVERY.DEVICE.DNS}<br><b>Device status:</b> {DISCOVERY.DEVICE.STATUS}<br><b>Device uptime:</b> {DISCOVERY.DEVICE.UPTIME}<br><br><b>Device service name:</b> {DISCOVERY.SERVICE.NAME}<br><b>Device service port:</b> {DISCOVERY.SERVICE.PORT}<br><b>Device service status:</b> {DISCOVERY.SERVICE.STATUS}<br><b>Device service uptime:</b> {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('15','4','2','0','Autoregistration: {HOST.HOST}','<b>Host name:</b> {HOST.HOST}<br><b>Host IP:</b> {HOST.IP}<br><b>Agent port:</b> {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('16','11','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('17','11','0','1','Resolved: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('18','11','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('19','11','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('20','11','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('21','12','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('22','12','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('23','12','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('24','12','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('25','12','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('26','13','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('27','13','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('28','13','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('29','13','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('30','13','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('31','14','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('32','14','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('33','14','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('34','14','0','1','Resolved: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('35','14','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('36','15','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('37','15','0','1','Resolved: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('38','15','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('39','15','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('40','15','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('41','16','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('42','16','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('43','16','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('44','16','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('45','16','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('46','17','0','0','{EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('47','17','0','1','{EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('48','17','0','2','{EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('49','17','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('50','17','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('51','17','3','0','Internal problem: {EVENT.NAME}','Internal problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('52','18','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('53','18','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('54','18','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('55','18','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('56','18','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('57','19','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('58','19','0','1','Resolved: {EVENT.RECOVERY.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.RECOVERY.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('59','19','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('60','19','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('61','19','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('62','20','0','0','{EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('63','20','0','1','{EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('64','20','0','2','{EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('65','20','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('66','20','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('67','21','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('68','21','0','1','Resolved: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('69','21','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('70','21','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('71','21','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('72','10','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('73','10','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('74','10','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('75','10','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('76','10','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('77','22','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('78','22','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('79','22','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Problem duration: {EVENT.DURATION}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('80','5','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('81','5','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Problem duration: {EVENT.DURATION}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('82','5','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('83','5','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('84','5','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('85','6','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('86','6','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('87','6','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('88','6','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('89','6','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Problem duration: {EVENT.DURATION}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('90','7','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('91','7','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Problem duration: {EVENT.DURATION}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('92','7','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('93','7','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('94','7','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('95','8','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('96','8','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Problem duration: {EVENT.DURATION}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('97','8','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('98','8','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('99','8','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('100','9','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('101','9','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Problem duration: {EVENT.DURATION}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('102','9','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('103','9','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('104','9','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('105','23','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Trigger description: {TRIGGER.DESCRIPTION}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('106','23','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('107','23','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('108','23','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('109','23','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('110','24','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('111','24','0','1','Resolved: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('112','24','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('113','24','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('114','24','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('115','25','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('116','25','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Problem duration: {EVENT.DURATION}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('117','25','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('118','25','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('119','25','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('120','26','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('121','26','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('122','26','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('123','26','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('124','26','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('125','27','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('126','27','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('127','27','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('128','27','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('129','27','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('130','28','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('131','28','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Problem duration: {EVENT.DURATION}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('132','28','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('133','28','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('134','28','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('135','29','0','0','[{EVENT.STATUS}] {EVENT.NAME}','[{EVENT.STATUS}] {EVENT.NAME}' || chr(13) || chr(10) || 'Started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Event info: {$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('136','29','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','[{EVENT.STATUS}] {EVENT.NAME}' || chr(13) || chr(10) || 'Resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Event info: {$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('137','29','0','2','[{EVENT.STATUS}] {EVENT.NAME}','[{EVENT.STATUS}] {EVENT.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('138','29','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('139','29','2','0','Autoregistration: {HOST.HOST}','Autoregistration: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('140','30','0','0','[{EVENT.STATUS}] {EVENT.NAME}','[{EVENT.STATUS}] {EVENT.NAME}' || chr(13) || chr(10) || 'Started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Event info: {$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('141','30','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','[{EVENT.STATUS}] {EVENT.NAME}' || chr(13) || chr(10) || 'Resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Event info: {$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('142','30','0','2','[{EVENT.STATUS}] {EVENT.NAME}','[{EVENT.STATUS}] {EVENT.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('143','30','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('144','30','2','0','Autoregistration: {HOST.HOST}','Autoregistration: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('145','31','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('146','31','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('147','31','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('148','31','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('149','31','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('150','32','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('151','32','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('152','32','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('153','32','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('154','32','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('155','33','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Operational data: {EVENT.OPDATA}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('156','33','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}' || chr(13) || chr(10) || 'Problem name: {EVENT.NAME}' || chr(13) || chr(10) || 'Host: {HOST.NAME}' || chr(13) || chr(10) || 'Severity: {EVENT.SEVERITY}' || chr(13) || chr(10) || 'Original problem ID: {EVENT.ID}' || chr(13) || chr(10) || '{TRIGGER.URL}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('157','33','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.' || chr(13) || chr(10) || '{EVENT.UPDATE.MESSAGE}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Current problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('158','33','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device IP: {DISCOVERY.DEVICE.IPADDRESS}' || chr(13) || chr(10) || 'Device DNS: {DISCOVERY.DEVICE.DNS}' || chr(13) || chr(10) || 'Device status: {DISCOVERY.DEVICE.STATUS}' || chr(13) || chr(10) || 'Device uptime: {DISCOVERY.DEVICE.UPTIME}' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Device service name: {DISCOVERY.SERVICE.NAME}' || chr(13) || chr(10) || 'Device service port: {DISCOVERY.SERVICE.PORT}' || chr(13) || chr(10) || 'Device service status: {DISCOVERY.SERVICE.STATUS}' || chr(13) || chr(10) || 'Device service uptime: {DISCOVERY.SERVICE.UPTIME}')
/

INSERT INTO media_type_message (mediatype_messageid,mediatypeid,eventsource,recovery,subject,message)
values ('159','33','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}' || chr(13) || chr(10) || 'Host IP: {HOST.IP}' || chr(13) || chr(10) || 'Agent port: {HOST.PORT}')
/

INSERT INTO usrgrp (usrgrpid,name,gui_access,users_status,debug_mode)
values ('7','Zabbix administrators','0','0','0')
/

INSERT INTO usrgrp (usrgrpid,name,gui_access,users_status,debug_mode)
values ('8','Guests','1','0','0')
/

INSERT INTO usrgrp (usrgrpid,name,gui_access,users_status,debug_mode)
values ('9','Disabled','0','1','0')
/

INSERT INTO usrgrp (usrgrpid,name,gui_access,users_status,debug_mode)
values ('11','Enabled debug mode','0','0','1')
/

INSERT INTO usrgrp (usrgrpid,name,gui_access,users_status,debug_mode)
values ('12','No access to the frontend','3','0','0')
/

INSERT INTO users_groups (id,usrgrpid,userid)
values ('2','8','2')
/

INSERT INTO users_groups (id,usrgrpid,userid)
values ('3','9','2')
/

INSERT INTO users_groups (id,usrgrpid,userid)
values ('4','7','1')
/

INSERT INTO scripts (scriptid,name,command,host_access,usrgrpid,groupid,description,confirmation,type,execute_on,timeout,scope,port,authtype,username,password,publickey,privatekey,menu_path)
values ('1','Ping','ping -c 3 {HOST.CONN}; case $? in [01]) true;; *) false;; esac','2',NULL,NULL,'','','0','2','30s','2','','0','','','','','')
/

INSERT INTO scripts (scriptid,name,command,host_access,usrgrpid,groupid,description,confirmation,type,execute_on,timeout,scope,port,authtype,username,password,publickey,privatekey,menu_path)
values ('2','Traceroute','/usr/bin/traceroute {HOST.CONN}','2',NULL,NULL,'','','0','2','30s','2','','0','','','','','')
/

INSERT INTO scripts (scriptid,name,command,host_access,usrgrpid,groupid,description,confirmation,type,execute_on,timeout,scope,port,authtype,username,password,publickey,privatekey,menu_path)
values ('3','Detect operating system','sudo /usr/bin/nmap -O {HOST.CONN}','2','7',NULL,'','','0','2','30s','2','','0','','','','','')
/

INSERT INTO actions (actionid,name,eventsource,evaltype,status,esc_period,formula,pause_suppressed,notify_if_canceled)
values ('2','Auto discovery. Linux servers.','1','0','1','0','','1','1')
/

INSERT INTO actions (actionid,name,eventsource,evaltype,status,esc_period,formula,pause_suppressed,notify_if_canceled)
values ('3','Report problems to Zabbix administrators','0','0','1','1h','','1','1')
/

INSERT INTO actions (actionid,name,eventsource,evaltype,status,esc_period,formula,pause_suppressed,notify_if_canceled)
values ('4','Report not supported items','3','0','1','1h','','1','1')
/

INSERT INTO actions (actionid,name,eventsource,evaltype,status,esc_period,formula,pause_suppressed,notify_if_canceled)
values ('5','Report not supported low level discovery rules','3','0','1','1h','','1','1')
/

INSERT INTO actions (actionid,name,eventsource,evaltype,status,esc_period,formula,pause_suppressed,notify_if_canceled)
values ('6','Report unknown triggers','3','0','1','1h','','1','1')
/

INSERT INTO operations (operationid,actionid,operationtype,esc_period,esc_step_from,esc_step_to,evaltype,recovery)
values ('1','2','6','0','1','1','0','0')
/

INSERT INTO operations (operationid,actionid,operationtype,esc_period,esc_step_from,esc_step_to,evaltype,recovery)
values ('2','2','4','0','1','1','0','0')
/

INSERT INTO operations (operationid,actionid,operationtype,esc_period,esc_step_from,esc_step_to,evaltype,recovery)
values ('3','3','0','0','1','1','0','0')
/

INSERT INTO operations (operationid,actionid,operationtype,esc_period,esc_step_from,esc_step_to,evaltype,recovery)
values ('4','4','0','0','1','1','0','0')
/

INSERT INTO operations (operationid,actionid,operationtype,esc_period,esc_step_from,esc_step_to,evaltype,recovery)
values ('5','5','0','0','1','1','0','0')
/

INSERT INTO operations (operationid,actionid,operationtype,esc_period,esc_step_from,esc_step_to,evaltype,recovery)
values ('6','6','0','0','1','1','0','0')
/

INSERT INTO operations (operationid,actionid,operationtype,esc_period,esc_step_from,esc_step_to,evaltype,recovery)
values ('7','3','11','0','1','1','0','1')
/

INSERT INTO operations (operationid,actionid,operationtype,esc_period,esc_step_from,esc_step_to,evaltype,recovery)
values ('8','4','11','0','1','1','0','1')
/

INSERT INTO operations (operationid,actionid,operationtype,esc_period,esc_step_from,esc_step_to,evaltype,recovery)
values ('9','5','11','0','1','1','0','1')
/

INSERT INTO operations (operationid,actionid,operationtype,esc_period,esc_step_from,esc_step_to,evaltype,recovery)
values ('10','6','11','0','1','1','0','1')
/

INSERT INTO opmessage (operationid,default_msg,subject,message,mediatypeid)
values ('3','1','','',NULL)
/

INSERT INTO opmessage (operationid,default_msg,subject,message,mediatypeid)
values ('4','1','','',NULL)
/

INSERT INTO opmessage (operationid,default_msg,subject,message,mediatypeid)
values ('5','1','','',NULL)
/

INSERT INTO opmessage (operationid,default_msg,subject,message,mediatypeid)
values ('6','1','','',NULL)
/

INSERT INTO opmessage (operationid,default_msg,subject,message,mediatypeid)
values ('7','1','','',NULL)
/

INSERT INTO opmessage (operationid,default_msg,subject,message,mediatypeid)
values ('8','1','','',NULL)
/

INSERT INTO opmessage (operationid,default_msg,subject,message,mediatypeid)
values ('9','1','','',NULL)
/

INSERT INTO opmessage (operationid,default_msg,subject,message,mediatypeid)
values ('10','1','','',NULL)
/

INSERT INTO opmessage_grp (opmessage_grpid,operationid,usrgrpid)
values ('1','3','7')
/

INSERT INTO opmessage_grp (opmessage_grpid,operationid,usrgrpid)
values ('2','4','7')
/

INSERT INTO opmessage_grp (opmessage_grpid,operationid,usrgrpid)
values ('3','5','7')
/

INSERT INTO opmessage_grp (opmessage_grpid,operationid,usrgrpid)
values ('4','6','7')
/

INSERT INTO opgroup (opgroupid,operationid,groupid)
values ('1','2','2')
/

INSERT INTO conditions (conditionid,actionid,conditiontype,operator,value,value2)
values ('2','2','10','0','0','')
/

INSERT INTO conditions (conditionid,actionid,conditiontype,operator,value,value2)
values ('3','2','8','0','9','')
/

INSERT INTO conditions (conditionid,actionid,conditiontype,operator,value,value2)
values ('4','2','12','2','Linux','')
/

INSERT INTO conditions (conditionid,actionid,conditiontype,operator,value,value2)
values ('6','4','23','0','0','')
/

INSERT INTO conditions (conditionid,actionid,conditiontype,operator,value,value2)
values ('7','5','23','0','2','')
/

INSERT INTO conditions (conditionid,actionid,conditiontype,operator,value,value2)
values ('8','6','23','0','4','')
/

INSERT INTO config (configid,work_period,alert_usrgrpid,discovery_groupid,dbversion_status,geomaps_tile_provider)
values ('1','1-5,09:00-18:00','7','5','','OpenStreetMap.Mapnik')
/

INSERT INTO graph_theme (graphthemeid,theme,backgroundcolor,graphcolor,gridcolor,maingridcolor,gridbordercolor,textcolor,highlightcolor,leftpercentilecolor,rightpercentilecolor,nonworktimecolor,colorpalette)
values ('1','blue-theme','FFFFFF','FFFFFF','CCD5D9','ACBBC2','ACBBC2','1F2C33','E33734','429E47','E33734','EBEBEB','1A7C11,F63100,2774A4,A54F10,FC6EA3,6C59DC,AC8C14,611F27,F230E0,5CCD18,BB2A02,5A2B57,89ABF8,7EC25C,274482,2B5429,8048B4,FD5434,790E1F,87AC4D,E89DF4')
/

INSERT INTO graph_theme (graphthemeid,theme,backgroundcolor,graphcolor,gridcolor,maingridcolor,gridbordercolor,textcolor,highlightcolor,leftpercentilecolor,rightpercentilecolor,nonworktimecolor,colorpalette)
values ('2','dark-theme','2B2B2B','2B2B2B','454545','4F4F4F','4F4F4F','F2F2F2','E45959','59DB8F','E45959','333333','199C0D,F63100,2774A4,F7941D,FC6EA3,6C59DC,C7A72D,BA2A5D,F230E0,5CCD18,BB2A02,AC41A5,89ABF8,7EC25C,3165D5,79A277,AA73DE,FD5434,F21C3E,87AC4D,E89DF4')
/

INSERT INTO graph_theme (graphthemeid,theme,backgroundcolor,graphcolor,gridcolor,maingridcolor,gridbordercolor,textcolor,highlightcolor,leftpercentilecolor,rightpercentilecolor,nonworktimecolor,colorpalette)
values ('3','hc-light','FFFFFF','FFFFFF','555555','000000','333333','000000','333333','000000','000000','EBEBEB','1A7C11,F63100,2774A4,A54F10,FC6EA3,6C59DC,AC8C14,611F27,F230E0,5CCD18,BB2A02,5A2B57,89ABF8,7EC25C,274482,2B5429,8048B4,FD5434,790E1F,87AC4D,E89DF4')
/

INSERT INTO graph_theme (graphthemeid,theme,backgroundcolor,graphcolor,gridcolor,maingridcolor,gridbordercolor,textcolor,highlightcolor,leftpercentilecolor,rightpercentilecolor,nonworktimecolor,colorpalette)
values ('4','hc-dark','000000','000000','666666','888888','4F4F4F','FFFFFF','FFFFFF','FFFFFF','FFFFFF','333333','199C0D,F63100,2774A4,F7941D,FC6EA3,6C59DC,C7A72D,BA2A5D,F230E0,5CCD18,BB2A02,AC41A5,89ABF8,7EC25C,3165D5,79A277,AA73DE,FD5434,F21C3E,87AC4D,E89DF4')
/

INSERT INTO globalmacro (globalmacroid,macro,value,description,type)
values ('2','{$SNMP_COMMUNITY}','public','','0')
/

INSERT INTO regexps (regexpid,name,test_string)
values ('1','File systems for discovery','ext3')
/

INSERT INTO regexps (regexpid,name,test_string)
values ('2','Network interfaces for discovery','eth0')
/

INSERT INTO regexps (regexpid,name,test_string)
values ('3','Storage devices for SNMP discovery','/boot')
/

INSERT INTO regexps (regexpid,name,test_string)
values ('4','Windows service names for discovery','SysmonLog')
/

INSERT INTO regexps (regexpid,name,test_string)
values ('5','Windows service startup states for discovery','automatic')
/

INSERT INTO expressions (expressionid,regexpid,expression,expression_type,exp_delimiter,case_sensitive)
values ('1','1','^(btrfs|ext2|ext3|ext4|reiser|xfs|ffs|ufs|jfs|jfs2|vxfs|hfs|apfs|refs|ntfs|fat32|zfs)$','3',',','0')
/

INSERT INTO expressions (expressionid,regexpid,expression,expression_type,exp_delimiter,case_sensitive)
values ('3','3','^(Physical memory|Virtual memory|Memory buffers|Cached memory|Swap space)$','4',',','1')
/

INSERT INTO expressions (expressionid,regexpid,expression,expression_type,exp_delimiter,case_sensitive)
values ('5','4','^(MMCSS|gupdate|SysmonLog|clr_optimization_v2.0.50727_32|clr_optimization_v4.0.30319_32)$','4',',','1')
/

INSERT INTO expressions (expressionid,regexpid,expression,expression_type,exp_delimiter,case_sensitive)
values ('6','5','^(automatic|automatic delayed)$','3',',','1')
/

INSERT INTO expressions (expressionid,regexpid,expression,expression_type,exp_delimiter,case_sensitive)
values ('7','2','^Software Loopback Interface','4',',','1')
/

INSERT INTO expressions (expressionid,regexpid,expression,expression_type,exp_delimiter,case_sensitive)
values ('8','2','^(In)?[Ll]oop[Bb]ack[0-9._]*$','4',',','1')
/

INSERT INTO expressions (expressionid,regexpid,expression,expression_type,exp_delimiter,case_sensitive)
values ('9','2','^NULL[0-9.]*$','4',',','1')
/

INSERT INTO expressions (expressionid,regexpid,expression,expression_type,exp_delimiter,case_sensitive)
values ('10','2','^[Ll]o[0-9.]*$','4',',','1')
/

INSERT INTO expressions (expressionid,regexpid,expression,expression_type,exp_delimiter,case_sensitive)
values ('11','2','^[Ss]ystem$','4',',','1')
/

INSERT INTO expressions (expressionid,regexpid,expression,expression_type,exp_delimiter,case_sensitive)
values ('12','2','^Nu[0-9.]*$','4',',','1')
/

INSERT INTO config_autoreg_tls (autoreg_tlsid,tls_psk_identity,tls_psk)
values ('1','','')
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('1','1','0','ui.default_access','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('2','1','0','services.read','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('3','1','0','services.write','0','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('4','1','0','modules.default_access','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('5','1','0','api.access','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('6','1','0','api.mode','0','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('7','1','0','actions.default_access','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('8','2','0','ui.default_access','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('9','2','0','services.read','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('10','2','0','services.write','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('11','2','0','modules.default_access','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('12','2','0','api.access','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('13','2','0','api.mode','0','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('14','2','0','actions.default_access','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('15','3','0','ui.default_access','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('16','3','0','services.read','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('17','3','0','services.write','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('18','3','0','modules.default_access','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('19','3','0','api.access','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('20','3','0','api.mode','0','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('21','3','0','actions.default_access','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('22','4','0','ui.default_access','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('23','4','0','services.read','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('24','4','0','services.write','0','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('25','4','0','modules.default_access','1','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('26','4','0','api.access','0','',NULL,NULL)
/

INSERT INTO role_rule (role_ruleid,roleid,type,name,value_int,value_str,value_moduleid,value_serviceid)
values ('27','4','0','actions.default_access','0','',NULL,NULL)
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10001',NULL,'Linux by Zabbix agent','3','-1','2','','','Linux by Zabbix agent','0',NULL,'Official Linux template. Requires agent of Zabbix 3.0.14, 3.4.5 and 4.0.0 or newer.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Network discovery. Zabbix agent as of 4.2 doesn''t support items such as net.if.status, net.if.speed.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387225-discussion-thread-for-official-zabbix-template-for-linux' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','f8f7908280354f2abeed07dc788c3747')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10047',NULL,'Zabbix server health','3','-1','2','','','Zabbix server health','0',NULL,'Template tooling version used: 0.41','1','1','','','','','','1','0','0','e2d2b4e4ac28483996cc11fe42823d57')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10048',NULL,'Zabbix proxy health','3','-1','2','','','Zabbix proxy health','0',NULL,'Template tooling version used: 0.41','1','1','','','','','','1','0','0','dd114bf0fb2f46bc84840f1bb24e2b23')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10050',NULL,'Zabbix agent','3','-1','2','','','Zabbix agent','0',NULL,'Use this template for agents reachable from Zabbix server/proxy (passive mode).' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','8aa4557f6c3f4aadbc03447fca3af9f6')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10074',NULL,'OpenBSD by Zabbix agent','3','-1','2','','','OpenBSD by Zabbix agent','0',NULL,'Official OpenBSD template. Requires agent of Zabbix 6.0 or newer.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','760be6e1c2194a5bb7c0df47cc5f71ca')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10075',NULL,'FreeBSD by Zabbix agent','3','-1','2','','','FreeBSD by Zabbix agent','0',NULL,'Official FreeBSD template. Requires agent of Zabbix 6.0 or newer.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','a3dc630729e443139f4e608954fa6e19')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10076',NULL,'AIX by Zabbix agent','3','-1','2','','','AIX by Zabbix agent','0',NULL,'Official AIX template. Requires agent of Zabbix 4.0.0 or newer.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','7e6bb0931a72459db9514aa924b420bc')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10077',NULL,'HP-UX by Zabbix agent','3','-1','2','','','HP-UX by Zabbix agent','0',NULL,'Official HP-UX template. Requires agent of Zabbix 4.0.0 or newer.+' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','b1fd823d262042e08291313f72be9452')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10078',NULL,'Solaris','3','-1','2','','','Solaris','0',NULL,'Official Solaris OS template. Requires Zabbix agent 4.0.0 or newer.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/+' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','eaf36c98b91843b7b79bd5184a23d377')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10079',NULL,'macOS','3','-1','2','','','macOS','0',NULL,'Official macOS template. Requires Zabbix agent 4.0.0 or newer.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','f895df5b37494f668cde1a2388d7af8b')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10081',NULL,'Windows by Zabbix agent','3','-1','2','','','Windows by Zabbix agent','0',NULL,'Official Windows template. Requires agent of Zabbix 4.4 and newer.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387224-discussion-thread-for-official-zabbix-template-for-windows' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','13b06904a6bf41cbb795e3193d896340')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10084',NULL,'Zabbix server','0','-1','2','','','Zabbix server','0',NULL,'','1','1','','','','','','1','0','0','')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10093',NULL,'FTP Service','3','-1','2','','','FTP Service','0',NULL,'Template module for monitoring FTP service' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','3324b78f737e42fb8e6e05005c581b39')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10094',NULL,'HTTP Service','3','-1','2','','','HTTP Service','0',NULL,'Template module for monitoring HTTP service' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','ae6029df63724ff4a15819939ef74edd')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10095',NULL,'HTTPS Service','3','-1','2','','','HTTPS Service','0',NULL,'Template module for monitoring HTTPS service' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','c3ca7daa5168458f8a00852652a7f99d')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10096',NULL,'IMAP Service','3','-1','2','','','IMAP Service','0',NULL,'Template module for monitoring IMAP service' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','dd0c49d976444f168535b9c1a2db981b')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10097',NULL,'LDAP Service','3','-1','2','','','LDAP Service','0',NULL,'Template module for monitoring LDAP service' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','736d92e82cfb48a592c8a976c45ef76f')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10098',NULL,'NNTP Service','3','-1','2','','','NNTP Service','0',NULL,'Template module for monitoring NNTP service' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','22c53db48be0472cb97209c74418cf16')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10099',NULL,'NTP Service','3','-1','2','','','NTP Service','0',NULL,'Template module for monitoring NTP service' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','b28c13fdd0194ddcb5f6b18723a575ae')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10100',NULL,'POP Service','3','-1','2','','','POP Service','0',NULL,'Template module for monitoring POP service' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','e042c0e455f74e7eb2384c203edcb26e')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10101',NULL,'SMTP Service','3','-1','2','','','SMTP Service','0',NULL,'Template module for monitoring SMTP service' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','ea3cad7f70f9481ea85f797ef6ea684e')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10102',NULL,'SSH Service','3','-1','2','','','SSH Service','0',NULL,'Template module for monitoring SSH service' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','0bbd5e407d7544b28a508e18db81c235')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10103',NULL,'Telnet Service','3','-1','2','','','Telnet Service','0',NULL,'Template module for monitoring telnet service' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','7fc69c6afd334bcab0a133174983939f')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10169',NULL,'Generic Java JMX','3','-1','2','','','Generic Java JMX','0',NULL,'Template tooling version used: 0.41','1','1','','','','','','1','0','0','72aab08f7f27406a8f2c291648e5ba95')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10171',NULL,'Intel SR1530 IPMI','3','-1','2','','','Intel SR1530 IPMI','0',NULL,'Template for monitoring Intel SR1530 server system' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','f01bd64eef4049fabe087cccae590226')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10172',NULL,'Intel SR1630 IPMI','3','-1','2','','','Intel SR1630 IPMI','0',NULL,'Template for monitoring Intel SR1630 server system' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','2327c665b46e4aa781d41240168c3867')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10173',NULL,'VMware','3','-1','2','','','VMware','0',NULL,'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','56079badd056419383cc26e6a4fcc7e0')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10174',NULL,'VMware Guest','3','-1','2','','','VMware Guest','0',NULL,'Template tooling version used: 0.41','1','1','','','','','','1','0','0','7942fb93ae3b47cf9ca0ea4beb0675ce')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10175',NULL,'VMware Hypervisor','3','-1','2','','','VMware Hypervisor','0',NULL,'Template tooling version used: 0.41','1','1','','','','','','1','0','0','5899b2f0aced4085b5ac25d0461b3425')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10183',NULL,'EtherLike-MIB SNMP','3','-1','2','','','EtherLike-MIB SNMP','0',NULL,'Template EtherLike-MIB (duplex control only)' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'EtherLike-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','3598da1effdf4ed48074608f1422e3fd')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10185',NULL,'HOST-RESOURCES-MIB SNMP','3','-1','2','','','HOST-RESOURCES-MIB SNMP','0',NULL,'HOST-RESOURCES-MIB: CPU, memory and storage(vfs.fs.file) linked together.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','5c70662d333246668444276cb011e646')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10186',NULL,'ICMP Ping','3','-1','2','','','ICMP Ping','0',NULL,'Template Module ICMP Ping' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','37e5eb5606bc4abba66c8b20381a1e8a')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10188',NULL,'Interfaces Simple SNMP','3','-1','2','','','Interfaces Simple SNMP','0',NULL,'Template Module Interfaces Simple (no ifXTable). This is the exact copy of Template Module Interfaces template with the exception that metrics from ifXTable are replaced with ifTable counters where possible. Use this template with devices where IF-MIB::ifXtable is not available. If supported by the host - use Template Module Interfaces template instead.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: 32bit counters are used in this template (since there is no ifXtable available). If busy interfaces return incorrect bits sent/received - set update interval to 1m or less.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','7cd8aaa8d18d4b22a79edfb769e839b3')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10190',NULL,'Interfaces SNMP','3','-1','2','','','Interfaces SNMP','0',NULL,'Template Module Interfaces' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','809cd59886464ff3ad0a66d16fb1f2d8')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10192',NULL,'Interfaces Windows SNMP','3','-1','2','','','Interfaces Windows SNMP','0',NULL,'Template Interfaces Windows' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: 32bit counters are used in this template (since 64bit are not supported by Windows OS). If busy interfaces return incorrect bits sent/received - set update interval to 1m or less.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','d7af232ed629481e95d2df9952c519c8')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10204',NULL,'Generic SNMP','3','-1','2','','','Generic SNMP','0',NULL,'Template Module Generic' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','4cb1aabe2b704b5c882963c2ef87d8f6')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10207',NULL,'Alcatel Timetra TiMOS SNMP','3','-1','2','','','Alcatel Timetra TiMOS SNMP','0',NULL,'Template Net Alcatel Timetra TiMOS' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'EtherLike-MIB' || chr(13) || chr(10) || 'TIMETRA-SYSTEM-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'TIMETRA-CHASSIS-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','53044571fb864d87af32473e08c76d0b')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10208',NULL,'Brocade FC SNMP','3','-1','2','','','Brocade FC SNMP','0',NULL,'Template Net Brocade FC' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'SW-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: no IF-MIB::ifAlias is available' || chr(13) || chr(10) || '  Version: v6.3.1c, v7.0.0c,  v7.4.1c' || chr(13) || chr(10) || '  Device: all' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','de96d02bd5f242bfa31308ae2131d03f')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10209',NULL,'Brocade_Foundry Performance SNMP','3','-1','2','','','Brocade_Foundry Performance SNMP','0',NULL,'Template Module Brocade_Foundry Performance' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'FOUNDRY-SN-AGENT-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','c55052212c774e3fbab00343050b3db5')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10210',NULL,'Brocade_Foundry Nonstackable SNMP','3','-1','2','','','Brocade_Foundry Nonstackable SNMP','0',NULL,'Template Net Brocade_Foundry Nonstackable' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'FOUNDRY-SN-AGENT-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','6ecfb7083ddf45f183ab4be50cfba37a')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10211',NULL,'Brocade_Foundry Stackable SNMP','3','-1','2','','','Brocade_Foundry Stackable SNMP','0',NULL,'Template Brocade_Foundry Stackable' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'FOUNDRY-SN-AGENT-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'FOUNDRY-SN-STACKING-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Correct fan(returns fan status as ''other(1)'' and temperature (returns 0) for the non-master Switches are not available in SNMP' || chr(13) || chr(10) || '  Version: Version 08.0.40b and above' || chr(13) || chr(10) || '  Device: ICX 7750 in stack' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','f64ad01567914165a493815e492fb315')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10212',NULL,'Cisco CISCO-MEMORY-POOL-MIB SNMP','3','-1','2','','','Cisco CISCO-MEMORY-POOL-MIB SNMP','0',NULL,'Template Cisco CISCO-MEMORY-POOL-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'CISCO-MEMORY-POOL-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','d7c122cde75447248d4b1613cdc25d5b')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10213',NULL,'Cisco CISCO-PROCESS-MIB SNMP','3','-1','2','','','Cisco CISCO-PROCESS-MIB SNMP','0',NULL,'Template Cisco CISCO-PROCESS-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'CISCO-PROCESS-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','f934f5e71db642c689ed2f945f73ce6c')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10215',NULL,'Cisco OLD-CISCO-CPU-MIB SNMP','3','-1','2','','','Cisco OLD-CISCO-CPU-MIB SNMP','0',NULL,'Template Cisco OLD-CISCO-CPU-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'OLD-CISCO-CPU-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','1b0025aaf71f47ec91d08c17a399c6a6')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10216',NULL,'Cisco Inventory SNMP','3','-1','2','','','Cisco Inventory SNMP','0',NULL,'Template Cisco Inventory' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'ENTITY-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','90c99055648f40df8517005a7670158c')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10217',NULL,'Cisco CISCO-ENVMON-MIB SNMP','3','-1','2','','','Cisco CISCO-ENVMON-MIB SNMP','0',NULL,'Template Cisco CISCO-ENVMON-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'CISCO-ENVMON-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','51af5cf9312b41d38ab22e02c9af6bbc')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10218',NULL,'Cisco IOS SNMP','3','-1','2','','','Cisco IOS SNMP','0',NULL,'Template Cisco IOS Software releases 12.2(3.5) or later' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'CISCO-MEMORY-POOL-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || 'EtherLike-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'CISCO-ENVMON-MIB' || chr(13) || chr(10) || 'CISCO-PROCESS-MIB' || chr(13) || chr(10) || 'ENTITY-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: no if(in|out)(Errors|Discards) are available for vlan ifType' || chr(13) || chr(10) || '  Version: IOS for example: 12.1(22)EA11, 15.4(3)M2' || chr(13) || chr(10) || '  Device: C2911, C7600' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','aa3ce9bd8c1d40a2b0f83f9e642e88ee')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10220',NULL,'Cisco IOS prior to 12.0_3_T SNMP','3','-1','2','','','Cisco IOS prior to 12.0_3_T SNMP','0',NULL,'Cisco IOS Software releases prior to 12.0(3)T' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'OLD-CISCO-CPU-MIB' || chr(13) || chr(10) || 'CISCO-ENVMON-MIB' || chr(13) || chr(10) || 'CISCO-MEMORY-POOL-MIB' || chr(13) || chr(10) || 'ENTITY-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','1bb42fbdb9054645a62ff81f14ba3b99')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10221',NULL,'Dell Force S-Series SNMP','3','-1','2','','','Dell Force S-Series SNMP','0',NULL,'Template Dell Force S-Series' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'F10-S-SERIES-CHASSIS-MIB' || chr(13) || chr(10) || 'EtherLike-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','e5ec7acc7efc4ac491b6fa552ab077ae')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10222',NULL,'D-Link DES 7200 SNMP','3','-1','2','','','D-Link DES 7200 SNMP','0',NULL,'Template D-Link DES 7200' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'ENTITY-MIBdescription has changed' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || 'MY-PROCESS-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MY-MEMORY-MIB' || chr(13) || chr(10) || 'ENTITY-MIB' || chr(13) || chr(10) || 'MY-SYSTEM-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','395184b5d5b048a68e06c91154c56847')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10223',NULL,'D-Link DES_DGS Switch SNMP','3','-1','2','','','D-Link DES_DGS Switch SNMP','0',NULL,'Template D-Link DES_DGS Switch' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'EQUIPMENT-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || 'DLINK-AGENT-MIB' || chr(13) || chr(10) || 'EtherLike-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'ENTITY-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: D-Link reports missing PSU as fail(4)' || chr(13) || chr(10) || '  Version: Firmware: 1.73R008,hardware revision: B1' || chr(13) || chr(10) || '  Device: DGS-3420-26SC Gigabit Ethernet Switch' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','d3176749a5274264938f487cd89d17eb')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10224',NULL,'Extreme EXOS SNMP','3','-1','2','','','Extreme EXOS SNMP','0',NULL,'Template Extreme EXOS' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'EXTREME-SYSTEM-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || 'EtherLike-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'EXTREME-SOFTWARE-MONITOR-MIB' || chr(13) || chr(10) || 'ENTITY-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','861dbdece18f4b8f85214a319995eb3e')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10226',NULL,'Network Generic Device SNMP','3','-1','2','','','Network Generic Device SNMP','0',NULL,'Template Net Network Generic Device' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'EtherLike-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','67332e679035423f85090aa985947c36')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10227',NULL,'HP Comware HH3C SNMP','3','-1','2','','','HP Comware HH3C SNMP','0',NULL,'Template Net HP Comware (HH3C)' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'EtherLike-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'ENTITY-MIB' || chr(13) || chr(10) || 'HH3C-ENTITY-EXT-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: No temperature sensors. All entities of them return 0 for HH3C-ENTITY-EXT-MIB::hh3cEntityExtTemperature' || chr(13) || chr(10) || '  Version: 1910-48 Switch Software Version 5.20.99, Release 1116 Copyright(c)2010-2016 Hewlett Packard Enterprise Development LP' || chr(13) || chr(10) || '  Device: HP 1910-48' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','57aeccd43b744942b9555269b79a96ad')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10229',NULL,'Huawei VRP SNMP','3','-1','2','','','Huawei VRP SNMP','0',NULL,'Template Net Huawei VRP' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'EtherLike-MIB' || chr(13) || chr(10) || 'HUAWEI-ENTITY-EXTENT-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'ENTITY-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','ad4c3dad4b7b492685d1fd3bd3a664f9')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10230',NULL,'Intel_Qlogic Infiniband SNMP','3','-1','2','','','Intel_Qlogic Infiniband SNMP','0',NULL,'Template Net Intel_Qlogic Infiniband' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'ICS-CHASSIS-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','6f7f2c44e13a46a4b219fbb5db92f3f7')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10231',NULL,'Juniper SNMP','3','-1','2','','','Juniper SNMP','0',NULL,'Template Net Juniper' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'EtherLike-MIB' || chr(13) || chr(10) || 'JUNIPER-ALARM-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'JUNIPER-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','a326034825984bbd8a3a5885f3939bb3')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10233',NULL,'Mikrotik SNMP','3','-1','2','','','Mikrotik SNMP','0',NULL,'Template Net Mikrotik' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Doesn''t have ifHighSpeed filled. fixed in more recent versions' || chr(13) || chr(10) || '  Version: RouterOS 6.28 or lower' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Doesn''t have any temperature sensors' || chr(13) || chr(10) || '  Version: RouterOS 6.38.5' || chr(13) || chr(10) || '  Device: Mikrotik 941-2nD, Mikrotik 951G-2HnD' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','815b5a81b29a477695fddbd533ad9c84')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10234',NULL,'Netgear Fastpath SNMP','3','-1','2','','','Netgear Fastpath SNMP','0',NULL,'Template Net Netgear Fastpath' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'FASTPATH-SWITCHING-MIB' || chr(13) || chr(10) || 'FASTPATH-BOXSERVICES-PRIVATE-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','5920713da492452889adabc25e259caa')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10235',NULL,'QTech QSW SNMP','3','-1','2','','','QTech QSW SNMP','0',NULL,'Template Net QTech QSW' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'QTECH-MIB' || chr(13) || chr(10) || 'EtherLike-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'ENTITY-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','21f3e79e1d2e4f5e868d1ef81c94bbfd')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10236',NULL,'TP-LINK SNMP','3','-1','2','','','TP-LINK SNMP','0',NULL,'Template Net TP-LINK' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'TPLINK-SYSINFO-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'TPLINK-SYSMONITOR-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Default sysLocation, sysName and sysContact is not filled with proper data. Real hostname and location can be found only in private branch (TPLINK-SYSINFO-MIB). Please check whether this problem exists in the latest firmware: https://www.tp-link.com/en/support/download/t2600g-28ts/#Firmware' || chr(13) || chr(10) || '  Version: 2.0.0 Build 20170628 Rel.55184 (Beta)' || chr(13) || chr(10) || '  Device: T2600G-28TS 2.0' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: The Serial number of the product (tpSysInfoSerialNum) is missing in HW versions prior to V2_170323' || chr(13) || chr(10) || '  Version: Prior to version V2_170323' || chr(13) || chr(10) || '  Device: T2600G-28TS 2.0' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','2b9039885edf45b8bdd39f16dd069133')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10237',NULL,'Ubiquiti AirOS SNMP','3','-1','2','','','Ubiquiti AirOS SNMP','0',NULL,'Template Net Ubiquiti AirOS' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'FROGFOOT-RESOURCES-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'IEEE802dot11-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: UBNT unifi reports speed: like IF-MIB::ifSpeed.1 = Gauge32: 4294967295 for all interfaces' || chr(13) || chr(10) || '  Version: Firmware: BZ.ar7240.v3.7.51.6230.170322.1513' || chr(13) || chr(10) || '  Device: UBNT UAP-LR' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: UBNT AirMax(NanoStation, NanoBridge etc) reports ifSpeed: as 0 for VLAN and wireless(ath0) interfaces' || chr(13) || chr(10) || '  Version: Firmware: XW.ar934x.v5.6-beta4.22359.140521.1836' || chr(13) || chr(10) || '  Device: NanoStation M5' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: UBNT AirMax(NanoStation, NanoBridge etc) reports always return ifType: as ethernet(6) even for wifi,vlans and other types' || chr(13) || chr(10) || '  Version: Firmware: XW.ar934x.v5.6-beta4.22359.140521.1836' || chr(13) || chr(10) || '  Device: NanoStation M5' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: ifXTable is not provided in IF-MIB. So Interfaces Simple Template is used instead' || chr(13) || chr(10) || '  Version: all above' || chr(13) || chr(10) || '  Device: NanoStation, UAP-LR' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','6c235d126c1f4895acfe2156b140a886')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10248',NULL,'Linux SNMP','3','-1','2','','','Linux SNMP','0',NULL,'Template OS Linux' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'EtherLike-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'UCD-DISKIO-MIB' || chr(13) || chr(10) || 'UCD-SNMP-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387225-discussion-thread-for-official-zabbix-template-for-linux' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','4d3a7adbb6964bd08f2b9d28e0da6496')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10249',NULL,'Windows SNMP','3','-1','2','','','Windows SNMP','0',NULL,'Official Windows SNMP template. Requires Zabbix server 4.0.14, 4.2.8, 4.4.0 or newer (JSONPath function avg() used with types autoconversion).' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Doesn''t support In/Out 64 bit counters even though IfxTable is present:' || chr(13) || chr(10) || 'Currently, Windows gets it''s interface status from MIB-2. Since these 64bit SNMP counters (ifHCInOctets, ifHCOutOctets, etc.) are defined as an extension to IF-MIB, Microsoft has not implemented it.' || chr(13) || chr(10) || 'https://social.technet.microsoft.com/Forums/windowsserver/en-US/07b62ff0-94f6-40ca-a99d-d129c1b33d70/windows-2008-r2-snmp-64bit-counters-support?forum=winservergen' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Version: Win2008, Win2012R2.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Doesn''t support ifXTable at all' || chr(13) || chr(10) || '  Version: WindowsXP' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: EtherLike MIB is not supported' || chr(13) || chr(10) || '  Version: *' || chr(13) || chr(10) || '  Device: *' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','f9a59315c8944853bb91c0a9ec3056d7')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10250',NULL,'HP Enterprise Switch SNMP','3','-1','2','','','HP Enterprise Switch SNMP','0',NULL,'Template Net HP Enterprise Switch' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'NETSWITCH-MIB' || chr(13) || chr(10) || 'HP-ICF-CHASSIS' || chr(13) || chr(10) || 'ENTITY-SENSORS-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || 'EtherLike-MIB' || chr(13) || chr(10) || 'SEMI-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'ENTITY-MIB' || chr(13) || chr(10) || 'STATISTICS-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','cce20a5d149a48b7ac7f5383c3510883')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10251',NULL,'Mellanox SNMP','3','-1','2','','','Mellanox SNMP','0',NULL,'The updated template for monitoring the Mellanox network switches over SNMP agent. All items collected in one template without any linked templates.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'ENTITY-SENSORS-MIB' || chr(13) || chr(10) || 'ENTITY-STATE-MIB' || chr(13) || chr(10) || 'ENTITY-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','a60798c651604d93a062bec0f8a89751')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10252',NULL,'Cisco CISCO-PROCESS-MIB IOS versions 12.0_3_T-12.2_3.5 SNMP','3','-1','2','','','Cisco CISCO-PROCESS-MIB IOS versions 12.0_3_T-12.2_3.5 SNMP','0',NULL,'Template Module Cisco CISCO-PROCESS-MIB IOS versions 12.0_3_T-12.2_3.5' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'CISCO-PROCESS-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','3eadb8a2ad4a479cb59bfa6402deee3f')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10253',NULL,'Cisco IOS versions 12.0_3_T-12.2_3.5 SNMP','3','-1','2','','','Cisco IOS versions 12.0_3_T-12.2_3.5 SNMP','0',NULL,'Cisco IOS Software releases later to 12.0(3)T and prior to 12.2(3.5)' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'CISCO-MEMORY-POOL-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'CISCO-ENVMON-MIB' || chr(13) || chr(10) || 'CISCO-PROCESS-MIB' || chr(13) || chr(10) || 'ENTITY-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','40c233aaa3424fd29dc378022ff3461d')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10254',NULL,'Arista SNMP','3','-1','2','','','Arista SNMP','0',NULL,'Template Net Arista' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'ENTITY-SENSORS-MIB' || chr(13) || chr(10) || 'ENTITY-STATE-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || 'EtherLike-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'ENTITY-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','26674f62500e4e79b9f470bbf962130d')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10255',NULL,'Dell iDRAC SNMP','3','-1','2','','','Dell iDRAC SNMP','0',NULL,'Template Server iDRAC' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'IDRAC-MIB-SMIv2' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','43dc5c8a9a0e4786b64e44422c7f32b4')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10256',NULL,'HP iLO SNMP','3','-1','2','','','HP iLO SNMP','0',NULL,'Template Server HP iLO' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'CPQHLTH-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'CPQSINFO-MIB' || chr(13) || chr(10) || 'CPQIDA-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','c2a7ddca051d4b4a9553f339c57e47a9')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10258',NULL,'IBM IMM SNMP','3','-1','2','','','IBM IMM SNMP','0',NULL,'Template Server IBM IMM' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'IMM-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Some IMMs (IMM1) do not return disks' || chr(13) || chr(10) || '  Version: IMM1' || chr(13) || chr(10) || '  Device: IBM x3250M3' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Some IMMs (IMM1) do not return fan status: fanHealthStatus' || chr(13) || chr(10) || '  Version: IMM1' || chr(13) || chr(10) || '  Device: IBM x3250M3' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: IMM1 servers (M2, M3 generations) sysObjectID is NET-SNMP-MIB::netSnmpAgentOIDs.10' || chr(13) || chr(10) || '  Version: IMM1' || chr(13) || chr(10) || '  Device: IMM1 servers (M2,M3 generations)' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: IMM1 servers (M2, M3 generations) only Ambient temperature sensor available' || chr(13) || chr(10) || '  Version: IMM1' || chr(13) || chr(10) || '  Device: IMM1 servers (M2,M3 generations)' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','c9e1acd3ae4a427ab39724b6bcaf839e')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10259',NULL,'Supermicro Aten SNMP','3','-1','2','','','Supermicro Aten SNMP','0',NULL,'Template Server Supermicro Aten' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'ATEN-IPMI-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','cf0947cc05d3450b9a6d66b2eb180482')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10260',NULL,'Apache Tomcat by JMX','3','-1','2','','','Apache Tomcat by JMX','0',NULL,'The template to monitor Apache Tomcat by Zabbix that work without any external scripts.' || chr(13) || chr(10) || 'The metrics are collected by JMX.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/411862-discussion-thread-for-official-zabbix-template-tomcat' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','3cc8c9ae7055458c9a803597007f70bd')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10261',NULL,'Remote Zabbix server health','3','-1','2','','','Remote Zabbix server health','0',NULL,'Template tooling version used: 0.41','1','1','','','','','','1','0','0','79b16cbbe593444eae3de66de0cb566b')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10262',NULL,'Remote Zabbix proxy health','3','-1','2','','','Remote Zabbix proxy health','0',NULL,'Template tooling version used: 0.41','1','1','','','','','','1','0','0','970c2342146549768e6b91a26089bcdf')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10264',NULL,'Apache by Zabbix agent','3','-1','2','','','Apache by Zabbix agent','0',NULL,'Get metrics from mod_status module using HTTP agent.' || chr(13) || chr(10) || 'https://httpd.apache.org/docs/current/mod/mod_status.html' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384764-discussion-thread-for-official-zabbix-template-apache' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','a8d91e4f36794e32b73090d5edf3d7ae')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10265',NULL,'Apache by HTTP','3','-1','2','','','Apache by HTTP','0',NULL,'Get metrics from mod_status module using HTTP agent.' || chr(13) || chr(10) || 'https://httpd.apache.org/docs/current/mod/mod_status.html' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384764-discussion-thread-for-official-zabbix-template-apache' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','86702e8bc514434e8c914d50c206cb94')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10266',NULL,'Nginx by Zabbix agent','3','-1','2','','','Nginx by Zabbix agent','0',NULL,'Get metrics from stub status module using Zabbix agent running on Linux' || chr(13) || chr(10) || 'https://nginx.ru/en/docs/http/ngx_http_stub_status_module.html' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384765-discussion-thread-for-official-zabbix-template-nginx' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','27f6424905884dbb96ab9210d987a56c')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10267',NULL,'Nginx by HTTP','3','-1','2','','','Nginx by HTTP','0',NULL,'Get metrics from stub status module using HTTP agent' || chr(13) || chr(10) || 'https://nginx.ru/en/docs/http/ngx_http_stub_status_module.html.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384765-discussion-thread-for-official-zabbix-template-nginx' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','13d5bb0a4ae84228bff408aab5be338e')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10268',NULL,'Linux memory SNMP','3','-1','2','','','Linux memory SNMP','0',NULL,'MIBs used:' || chr(13) || chr(10) || 'UCD-SNMP-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Please note that memory utilization is a rough estimate, since memory available is calculated as free+buffers+cached, which is not 100% accurate, but the best we can get using SNMP.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','443e4897fb0a4eef9d4624a3baa8f174')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10269',NULL,'Linux block devices SNMP','3','-1','2','','','Linux block devices SNMP','0',NULL,'MIBs used:' || chr(13) || chr(10) || 'UCD-DISKIO-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','8278f5e79ef2420cab500a147cc72009')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10270',NULL,'Linux CPU SNMP','3','-1','2','','','Linux CPU SNMP','0',NULL,'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'UCD-SNMP-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','f55b1b1c10a44fe8aef0631f6f41b86d')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10271',NULL,'Linux filesystems SNMP','3','-1','2','','','Linux filesystems SNMP','0',NULL,'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'UCD-SNMP-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','cbaf0383cb934294ac53a28ddfd49434')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10272',NULL,'Linux CPU by Zabbix agent','3','-1','2','','','Linux CPU by Zabbix agent','0',NULL,'Template tooling version used: 0.41','1','1','','','','','','1','0','0','d4e080814aad467dbf6b95c46b862c28')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10273',NULL,'Linux filesystems by Zabbix agent','3','-1','2','','','Linux filesystems by Zabbix agent','0',NULL,'Template tooling version used: 0.41','1','1','','','','','','1','0','0','fdcdd5810fba49928922a683d32aa76f')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10274',NULL,'Linux memory by Zabbix agent','3','-1','2','','','Linux memory by Zabbix agent','0',NULL,'Template tooling version used: 0.41','1','1','','','','','','1','0','0','06c211e947414638bd00e555e206d03d')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10275',NULL,'Linux block devices by Zabbix agent','3','-1','2','','','Linux block devices by Zabbix agent','0',NULL,'Template tooling version used: 0.41','1','1','','','','','','1','0','0','45486dbbf5bf49f28866fcb212731cf0')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10276',NULL,'Linux network interfaces by Zabbix agent','3','-1','2','','','Linux network interfaces by Zabbix agent','0',NULL,'Template tooling version used: 0.41','1','1','','','','','','1','0','0','18ecfb2a7e754315bb8d7f71917153da')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10277',NULL,'Linux generic by Zabbix agent','3','-1','2','','','Linux generic by Zabbix agent','0',NULL,'Template tooling version used: 0.41','1','1','','','','','','1','0','0','38f973ee1556494fadeacb2f6b1ec987')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10285',NULL,'Linux by Prom','3','-1','2','','','Linux by Prom','0',NULL,'Official Linux template using node exporter.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: node_exporter v0.16.0 renamed many metrics. CPU utilization for ''guest'' and ''guest_nice'' metrics are not supported in this template with node_exporter < 0.16. Disk IO metrics are not supported. Other metrics provided as ''best effort''.' || chr(13) || chr(10) || 'See https://github.com/prometheus/node_exporter/releases/tag/v0.16.0 for details.' || chr(13) || chr(10) || '  Version: below 0.16.0' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: metric node_network_info with label ''device'' cannot be found, so network discovery is not possible.' || chr(13) || chr(10) || '  Version: below 0.18' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387225-discussion-thread-for-official-zabbix-template-for-linux' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','2506b0ca01884903b547b1e19b76ce6d')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10286',NULL,'Windows CPU by Zabbix agent','3','-1','2','','','Windows CPU by Zabbix agent','0',NULL,'Template tooling version used: 0.41','1','1','','','','','','1','0','0','e358504d59404f688e236444dd82d2c3')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10287',NULL,'Windows memory by Zabbix agent','3','-1','2','','','Windows memory by Zabbix agent','0',NULL,'Template tooling version used: 0.41','1','1','','','','','','1','0','0','539b4b98f6fb4e12bbdf3bcdb85df2d1')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10288',NULL,'Windows filesystems by Zabbix agent','3','-1','2','','','Windows filesystems by Zabbix agent','0',NULL,'Template tooling version used: 0.41','1','1','','','','','','1','0','0','cb28abff977b4b6eb34665ff2218163b')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10289',NULL,'Windows physical disks by Zabbix agent','3','-1','2','','','Windows physical disks by Zabbix agent','0',NULL,'Template tooling version used: 0.41','1','1','','','','','','1','0','0','4026647be95a47de98b0f09dc36ce72f')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10290',NULL,'Windows generic by Zabbix agent','3','-1','2','','','Windows generic by Zabbix agent','0',NULL,'Template tooling version used: 0.41','1','1','','','','','','1','0','0','95c4026f8ade4fa7b72f8140fc152aea')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10291',NULL,'Windows network by Zabbix agent','3','-1','2','','','Windows network by Zabbix agent','0',NULL,'Template tooling version used: 0.41','1','1','','','','','','1','0','0','6ad6a4d1e677461ca6d1d5b2dcaba6d2')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10292',NULL,'Zabbix agent active','3','-1','2','','','Zabbix agent active','0',NULL,'Use this template instead of ''Template Module Zabbix agent'' for agents running in active mode only.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','650bec3f2f364a478b82317396949459')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10300',NULL,'RabbitMQ cluster by Zabbix agent','3','-1','2','','','RabbitMQ cluster by Zabbix agent','0',NULL,'Get cluster metrics from RabbitMQ management plugin provided an HTTP-based API using Zabbix agent.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387226-discussion-thread-for-official-zabbix-template-rabbitmq' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','5fa761bc51e4432a90c6c9eece930c4a')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10301',NULL,'RabbitMQ node by Zabbix agent','3','-1','2','','','RabbitMQ node by Zabbix agent','0',NULL,'Get node metrics from RabbitMQ management plugin provided an HTTP-based API using Zabbix agent.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387226-discussion-thread-for-official-zabbix-template-rabbitmq' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','d5dc11ae9ab143a89c4be534bbb35188')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10302',NULL,'RabbitMQ cluster by HTTP','3','-1','2','','','RabbitMQ cluster by HTTP','0',NULL,'Get cluster metrics from RabbitMQ management plugin provided an HTTP-based API using HTTP agent.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387226-discussion-thread-for-official-zabbix-template-rabbitmq' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','8c8474148c2a4eaeabe5a9331ea99d77')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10303',NULL,'RabbitMQ node by HTTP','3','-1','2','','','RabbitMQ node by HTTP','0',NULL,'Get node metrics from RabbitMQ management plugin provided an HTTP-based API using HTTP agent.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387226-discussion-thread-for-official-zabbix-template-rabbitmq' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','b9514029d03b44de9adf24251778dbf3')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10304',NULL,'Cisco UCS SNMP','3','-1','2','','','Cisco UCS SNMP','0',NULL,'Template Server Cisco UCS' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'CISCO-UNIFIED-COMPUTING-COMPUTE-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'CISCO-UNIFIED-COMPUTING-PROCESSOR-MIB' || chr(13) || chr(10) || 'CISCO-UNIFIED-COMPUTING-EQUIPMENT-MIB' || chr(13) || chr(10) || 'CISCO-UNIFIED-COMPUTING-STORAGE-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','cb66d34564e44b3893442fc74cf6e951')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10305',NULL,'HOST-RESOURCES-MIB CPU SNMP','3','-1','2','','','HOST-RESOURCES-MIB CPU SNMP','0',NULL,'Requires Zabbix server 4.0.14, 4.2.8, 4.4.0 or newer (JSONPath function avg() used with types autoconversion).' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','b3dd7c4974f442d68c53a79056bc5388')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10306',NULL,'HOST-RESOURCES-MIB memory SNMP','3','-1','2','','','HOST-RESOURCES-MIB memory SNMP','0',NULL,'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','a2718bb9168a451fae8fc97486176943')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10307',NULL,'HOST-RESOURCES-MIB storage SNMP','3','-1','2','','','HOST-RESOURCES-MIB storage SNMP','0',NULL,'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','f6572ac29240452596e9f7b2a7ebb408')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10308',NULL,'HAProxy by Zabbix agent','3','-1','2','','','HAProxy by Zabbix agent','0',NULL,'Get metrics from status page using Zabbix agent' || chr(13) || chr(10) || 'https://www.haproxy.com/blog/exploring-the-haproxy-stats-page/.' || chr(13) || chr(10) || 'Example configuration of HAProxy:' || chr(13) || chr(10) || '  frontend stats' || chr(13) || chr(10) || '      bind *:8404' || chr(13) || chr(10) || '      stats enable' || chr(13) || chr(10) || '      stats uri /stats' || chr(13) || chr(10) || '      stats refresh 10s' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/393527-discussion-thread-for-official-zabbix-template-haproxy' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','812073bf8df143bcae2a84b32c3965e5')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10309',NULL,'HAProxy by HTTP','3','-1','2','','','HAProxy by HTTP','0',NULL,'Get metrics from status page using HTTP agent' || chr(13) || chr(10) || 'https://www.haproxy.com/blog/exploring-the-haproxy-stats-page/.' || chr(13) || chr(10) || 'Example configuration of HAProxy:' || chr(13) || chr(10) || '  frontend stats' || chr(13) || chr(10) || '      bind *:8404' || chr(13) || chr(10) || '      stats enable' || chr(13) || chr(10) || '      stats uri /stats' || chr(13) || chr(10) || '      stats refresh 10s' || chr(13) || chr(10) || '      #stats auth Username:Password  # Authentication credentials' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/393527-discussion-thread-for-official-zabbix-template-haproxy' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','948d046cb2894e5c8d07767a518cc1a9')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10310',NULL,'Redis by Zabbix agent 2','3','-1','2','','','Redis by Zabbix agent 2','0',NULL,'Get Redis metrics from plugin for the New Zabbix Agent (zabbix-agent2).' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/389050-discussion-thread-for-official-zabbix-template-redis' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','e111446745a1425b862f8727ae63bce4')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10314',NULL,'Windows services by Zabbix agent','3','-1','2','','','Windows services by Zabbix agent','0',NULL,'Template Services OS Windows' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','dfd6f32510a840c29f9cb4b974977770')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10316',NULL,'MySQL by Zabbix agent','3','-1','2','','','MySQL by Zabbix agent','0',NULL,'Requirements for template operation:' || chr(13) || chr(10) || '1.Install Zabbix agent and MySQL client.' || chr(13) || chr(10) || '2.Copy template_db_mysql.conf into folder with Zabbix agent configuration (/etc/zabbix/zabbix_agentd.d/ by default). Don''t forget to restart zabbix-agent.' || chr(13) || chr(10) || '3.Create MySQL user for monitoring. For example:' || chr(13) || chr(10) || 'CREATE USER ''zbx_monitor''@''%'' IDENTIFIED BY ''<password>'';' || chr(13) || chr(10) || 'GRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW ON *.* TO ''zbx_monitor''@''%'';' || chr(13) || chr(10) || 'For more information read the MySQL documentation https://dev.mysql.com/doc/refman/8.0/en/grant.html , please. ' || chr(13) || chr(10) || '4.Create .my.cnf in home directory of Zabbix agent for Linux (/var/lib/zabbix by default) or my.cnf in c:\ for Windows. For example:' || chr(13) || chr(10) || '[client]' || chr(13) || chr(10) || 'user=''zbx_monitor''' || chr(13) || chr(10) || 'password=''<password>''' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384189-discussion-thread-for-official-zabbix-template-db-mysql' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','f255e3fc32124b55b2a17ef3c961e5f5')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10317',NULL,'MySQL by ODBC','3','-1','2','','','MySQL by ODBC','0',NULL,'Requirements for template operation:' || chr(13) || chr(10) || '1. Create MySQL user for monitoring. For example:' || chr(13) || chr(10) || 'CREATE USER ''zbx_monitor''@''%'' IDENTIFIED BY ''<password>'';' || chr(13) || chr(10) || 'GRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW ON *.* TO ''zbx_monitor''@''%'';' || chr(13) || chr(10) || 'For more information read the MYSQL documentation https://dev.mysql.com/doc/refman/8.0/en/grant.html , please.' || chr(13) || chr(10) || '2. Set the user name and password in host macros ({$MYSQL.USER} and {$MYSQL.PASSWORD}).' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384189-discussion-thread-for-official-zabbix-template-db-mysql' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','e19c120027e04da69b130e0f6cea29fc')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10318',NULL,'Docker by Zabbix agent 2','3','-1','2','','','Docker by Zabbix agent 2','0',NULL,'Get Docker engine metrics from plugin for the New Zabbix Agent (zabbix-agent2).' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/435429-discussion-thread-for-official-zabbix-template-docker' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','c5fd214cdd0d4b3b8272e73b022ba5c2')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10319',NULL,'Memcached by Zabbix agent 2','3','-1','2','','','Memcached by Zabbix agent 2','0',NULL,'Get Memcached metrics from plugin for the New Zabbix Agent (zabbix-agent2).' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/398623-discussion-thread-for-official-zabbix-template-memcached' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','05894ba2c9184d33992bf1bd21c347f6')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10320',NULL,'MySQL by Zabbix agent 2','3','-1','2','','','MySQL by Zabbix agent 2','0',NULL,'Requirements for template operation:' || chr(13) || chr(10) || '1. Create MySQL user for monitoring. For example:' || chr(13) || chr(10) || 'CREATE USER ''zbx_monitor''@''%'' IDENTIFIED BY ''<password>'';' || chr(13) || chr(10) || 'GRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW ON *.* TO ''zbx_monitor''@''%'';' || chr(13) || chr(10) || 'For more information please read the MySQL documentation https://dev.mysql.com/doc/refman/8.0/en/grant.html.' || chr(13) || chr(10) || '2. Set in the {$MYSQL.DSN} macro the data source name of the MySQL instance either session name from Zabbix agent 2 configuration file or URI.' || chr(13) || chr(10) || 'Examples: MySQL1, tcp://localhost:3306, tcp://172.16.0.10, unix:/var/run/mysql.sock' || chr(13) || chr(10) || 'For more information about MySQL Unix socket file please read the MySQL documentation https://dev.mysql.com/doc/refman/8.0/en/problems-with-mysql-sock.html.' || chr(13) || chr(10) || '3. If you had set URI in the {$MYSQL.DSN}, please define the user name and password in host macros ({$MYSQL.USER} and {$MYSQL.PASSWORD}).' || chr(13) || chr(10) || 'Leave macros {$MYSQL.USER} and {$MYSQL.PASSWORD} empty if you use a session name. Set the user name and password in the Plugins.Mysql.<...> section of your Zabbix agent 2 configuration file.' || chr(13) || chr(10) || 'For more information about configuring the Zabbix MySQL plugin please read the documentation https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/src/go/plugins/mysql/README.md.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384189-discussion-thread-for-official-zabbix-template-db-mysql' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','4904f84303c74c5e955b7849730c3155')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10321',NULL,'Chassis by IPMI','3','-1','2','','','Chassis by IPMI','0',NULL,'Template for monitoring servers with BMC over IPMI that work without any external scripts.' || chr(13) || chr(10) || 'All metrics are collected at once, thanks to Zabbix''s bulk data collection. The template is available starting from Zabbix version 5.0.' || chr(13) || chr(10) || 'It collects metrics by polling BMC remotely using an IPMI agent.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: If the BMC has a sensor with an empty threshold value, we get the LLD error "Cannot create trigger...".' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/398023-discussion-thread-for-official-zabbix-template-ipmi' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','02f35169a5a54a5aad8b3f06e798ab1f')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10322',NULL,'Elasticsearch Cluster by HTTP','3','-1','2','','','Elasticsearch Cluster by HTTP','0',NULL,'The template to monitor Elasticsearch by Zabbix that work without any external scripts.' || chr(13) || chr(10) || 'It works with both standalone and cluster instances.' || chr(13) || chr(10) || 'The metrics are collected in one pass remotely using an HTTP agent.' || chr(13) || chr(10) || 'They are getting values from REST API _cluster/health, _cluster/stats, _nodes/stats requests.' || chr(13) || chr(10) || 'You can set {$ELASTICSEARCH.USERNAME} and {$ELASTICSEARCH.PASSWORD} macros in the template for using on the host level.' || chr(13) || chr(10) || 'If you use an atypical location ES API, don''t forget to change the macros {$ELASTICSEARCH.SCHEME},{$ELASTICSEARCH.PORT}.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/399473-discussion-thread-for-official-zabbix-template-for-elasticsearch' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','52b2664578884d9eba62e47375c99f8e')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10323',NULL,'ClickHouse by HTTP','3','-1','2','','','ClickHouse by HTTP','0',NULL,'Get node metrics from ClickHouse HTTP interface using HTTP agent.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','95f2053c21094ad4968440b562cc7ea2')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10324',NULL,'Etcd by HTTP','3','-1','2','','','Etcd by HTTP','0',NULL,'Get Etcd metrics by HTTP agent.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','b25b8b517a4743c48037bfa10af3dc3c')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10325',NULL,'IIS by Zabbix agent','3','-1','2','','','IIS by Zabbix agent','0',NULL,'Get metrics from IIS using Zabbix agent running on Windows.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/401862-discussion-thread-for-official-zabbix-template-internet-information-services' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','c7c7e5dc319b4801982e719beb1c5191')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10326',NULL,'IIS by Zabbix agent active','3','-1','2','','','IIS by Zabbix agent active','0',NULL,'Get metrics from IIS using Zabbix agent running on Windows.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/401862-discussion-thread-for-official-zabbix-template-internet-information-services' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','4677be3e07bf4f3285496f2f4230b928')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10327',NULL,'MSSQL by ODBC','3','-1','2','','','MSSQL by ODBC','0',NULL,'1. Create an MSSQL user for monitoring.' || chr(13) || chr(10) || '  View Server State and View Any Definition permissions should be granted to the user.' || chr(13) || chr(10) || '  Grant this user read permissions to the sysjobschedules, sysjobhistory, sysjobs tables.' || chr(13) || chr(10) || '  For more information, see MSSQL documentation.' || chr(13) || chr(10) || '2. Set the user name and password in host macros ({$MSSQL.USER} and {$MSSQL.PASSWORD}).' || chr(13) || chr(10) || '  Do not forget to install Microsoft ODBC driver on Zabbix server or Zabbix proxy.' || chr(13) || chr(10) || '  See Microsoft documentation for instructions: https://docs.microsoft.com/en-us/sql/connect/odbc/linux-mac/installing-the-microsoft-odbc-driver-for-sql-server?view=sql-server-ver15.' || chr(13) || chr(10) || '  Note! Credentials in the odbc.ini do not work for MSSQL.' || chr(13) || chr(10) || '3. For named instance set the value of {$MSSQL.INSTANCE} macro as MSSQL$instance name.' || chr(13) || chr(10) || 'The "Service''s TCP port state" item uses {HOST.CONN} and {$MSSQL.PORT} macros to check the availability of the MSSQL instance.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','001a1677f6a949b6bddfdb2926023300')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10328',NULL,'Oracle by ODBC','3','-1','2','','','Oracle by ODBC','0',NULL,'1. Create an Oracle user for monitoring.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '2. Set the user name and password in host macros ({$ORACLE.USER} and {$ORACLE.PASSWORD}).' || chr(13) || chr(10) || '  Do not forget to install the Microsoft ODBC driver on the Zabbix server or the Zabbix proxy.' || chr(13) || chr(10) || '  See Oracle documentation for instructions: https://www.oracle.com/database/technologies/releasenote-odbc-ic.html.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Note! Credentials in the odbc.ini do not work for Oracle.' || chr(13) || chr(10) || '  Note! Be sure that ODBC connects to Oracle with session parameter NLS_NUMERIC_CHARACTERS= ''.,'' It is important for correct display float numbers in Zabbix.' || chr(13) || chr(10) || 'The "Service''s TCP port state" item uses {HOST.CONN} and {$ORACLE.PORT} macros to check the availability of the listener.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','00ade9277d7c41e8b57d638b22d54372')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10329',NULL,'PostgreSQL by Zabbix agent 2','3','-1','2','','','PostgreSQL by Zabbix agent 2','0',NULL,'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384190-%C2%A0discussion-thread-for-official-zabbix-template-db-postgresql' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','d0ef7d659a8f4beaaabfc4b6134e737a')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10330',NULL,'PHP-FPM by Zabbix agent','3','-1','2','','','PHP-FPM by Zabbix agent','0',NULL,'Get PHP-FPM metrics using Zabbix agent running on Linux.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Note that depending on your OS distribution, the PHP-FPM process name may vary. Please, check the actual name in the line "Name" from /proc/<pid>/status file (https://www.zabbix.com/documentation/6.0/manual/appendix/items/proc_mem_num_notes) and change {$PHP_FPM.PROCESS_NAME} macro if needed.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','1cbda0970410435684135884d0cb7090')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10331',NULL,'PHP-FPM by HTTP','3','-1','2','','','PHP-FPM by HTTP','0',NULL,'Get PHP-FPM metrics using the Zabbix HTTP agent.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','49c77ce207f8478da53e761526d6eca5')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10333',NULL,'{#HV.UUID}','0','-1','2','','','{#HV.NAME}','2',NULL,'','1','1','','','','','','1','0','1','051a1469d4d045cbbf818fcc843a352e')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10334',NULL,'{#VM.UUID}','0','-1','2','','','{#VM.NAME}','2',NULL,'','1','1','','','','','','1','0','1','23b9ae9d6f33414880db1cb107115810')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10335',NULL,'Oracle by Zabbix agent 2','3','-1','2','','','Oracle by Zabbix agent 2','0',NULL,'Template tooling version used: 0.41','1','1','','','','','','1','0','0','d670c32f007d438c9dcd32db57d2b691')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10336',NULL,'Asterisk by HTTP','3','-1','2','','','Asterisk by HTTP','0',NULL,'The template gets Asterisk metrics from AMI by HTTP agent.' || chr(13) || chr(10) || 'You should enable the mini-HTTP Server, add the option webenabled=yes' || chr(13) || chr(10) || 'in the general section of the manager.conf file and create Asterisk Manager' || chr(13) || chr(10) || 'user with system and command write permissions within your Asterisk instance.' || chr(13) || chr(10) || 'Disable the PJSIP driver if you do not use PJSIP or do not have PJSIP endpoints.' || chr(13) || chr(10) || 'Please, define AMI address in the {$AMI.URL} macro. Also, the Zabbix host' || chr(13) || chr(10) || 'should have an Agent interface with the AMI address to check Asterisk service' || chr(13) || chr(10) || 'status.' || chr(13) || chr(10) || 'Then you can define {$AMI.USERNAME} and {$AMI.SECRET} macros in' || chr(13) || chr(10) || 'the template for using on the host level.' || chr(13) || chr(10) || 'If there are errors, increase the logging to debug level and see the Zabbix server log.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/410060-discussion-thread-for-official-zabbix-template-asterisk' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','30cc187a4e994c39b07f53d86b5cc6bc')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10337',NULL,'Linux block devices by Zabbix agent active','3','-1','2','','','Linux block devices by Zabbix agent active','0',NULL,'Template tooling version used: 0.41','1','1','','','','','','1','0','0','aa226119d3e94f53b9a2809f1d4ebaee')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10338',NULL,'Linux CPU by Zabbix agent active','3','-1','2','','','Linux CPU by Zabbix agent active','0',NULL,'Template tooling version used: 0.41','1','1','','','','','','1','0','0','da53e44145304098b4c3ff749996e3e7')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10339',NULL,'Linux filesystems by Zabbix agent active','3','-1','2','','','Linux filesystems by Zabbix agent active','0',NULL,'Template tooling version used: 0.41','1','1','','','','','','1','0','0','c626d864a2894d29a9d661d6025536ff')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10340',NULL,'Linux generic by Zabbix agent active','3','-1','2','','','Linux generic by Zabbix agent active','0',NULL,'Template tooling version used: 0.41','1','1','','','','','','1','0','0','7e4dc41320fd48bd97549025f4c3bcc6')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10341',NULL,'Linux memory by Zabbix agent active','3','-1','2','','','Linux memory by Zabbix agent active','0',NULL,'Template tooling version used: 0.41','1','1','','','','','','1','0','0','5f577b9e34a8444c920e8199170f7fe6')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10342',NULL,'Linux network interfaces by Zabbix agent active','3','-1','2','','','Linux network interfaces by Zabbix agent active','0',NULL,'Template tooling version used: 0.41','1','1','','','','','','1','0','0','fac8b6986be24a8c91f7b0b15439bccf')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10343',NULL,'Linux by Zabbix agent active','3','-1','2','','','Linux by Zabbix agent active','0',NULL,'Official Linux template. Requires agent of Zabbix 3.0.14, 3.4.5 and 4.0.0 or newer.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Network discovery. Zabbix agent as of 4.2 doesn''t support items such as net.if.status, net.if.speed.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387225-discussion-thread-for-official-zabbix-template-for-linux' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','e2307c94f1744af7a8f1f458a67af424')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10344',NULL,'Windows CPU by Zabbix agent active','3','-1','2','','','Windows CPU by Zabbix agent active','0',NULL,'Template tooling version used: 0.41','1','1','','','','','','1','0','0','296cb27ad93b4063b77aaf1a8339d40c')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10345',NULL,'Windows filesystems by Zabbix agent active','3','-1','2','','','Windows filesystems by Zabbix agent active','0',NULL,'Template tooling version used: 0.41','1','1','','','','','','1','0','0','1b04ac025fcf474cb97e6c8c95855eeb')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10346',NULL,'Windows generic by Zabbix agent active','3','-1','2','','','Windows generic by Zabbix agent active','0',NULL,'Template tooling version used: 0.41','1','1','','','','','','1','0','0','6dd37a415f4c40aa960d7ba91b6b5143')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10347',NULL,'Windows memory by Zabbix agent active','3','-1','2','','','Windows memory by Zabbix agent active','0',NULL,'Template tooling version used: 0.41','1','1','','','','','','1','0','0','e6535f54a0554463889fb8c65db11250')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10348',NULL,'Windows network by Zabbix agent active','3','-1','2','','','Windows network by Zabbix agent active','0',NULL,'Template tooling version used: 0.41','1','1','','','','','','1','0','0','792cb76a1a6340d8acb36d8802d22c00')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10349',NULL,'Windows physical disks by Zabbix agent active','3','-1','2','','','Windows physical disks by Zabbix agent active','0',NULL,'Template tooling version used: 0.41','1','1','','','','','','1','0','0','222cf73cb40941f6be62db0540524e5e')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10350',NULL,'Windows services by Zabbix agent active','3','-1','2','','','Windows services by Zabbix agent active','0',NULL,'Template Services OS Windows' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','3366a65bbc3e46348bec303e84e23b15')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10351',NULL,'Windows by Zabbix agent active','3','-1','2','','','Windows by Zabbix agent active','0',NULL,'Official Windows template. Requires agent of Zabbix 4.4 and newer.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387224-discussion-thread-for-official-zabbix-template-for-windows' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','5fdd2ca8b8f84962aaea5a218b46ea7d')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10353',NULL,'Ceph by Zabbix agent 2','3','-1','2','','','Ceph by Zabbix agent 2','0',NULL,'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/410059-discussion-thread-for-official-zabbix-template-ceph' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','09fb25d089f7467f860895f6e71d3fa2')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10355',NULL,'Squid SNMP','3','-1','2','','','Squid SNMP','0',NULL,'Template for monitoring Squid caching proxy via SNMP' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/409339-discussion-thread-for-official-zabbix-template-squid' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','8e5236f799b347a8ae90a979198be85e')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10357',NULL,'PostgreSQL by Zabbix agent','3','-1','2','','','PostgreSQL by Zabbix agent','0',NULL,'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384190-%C2%A0discussion-thread-for-official-zabbix-template-db-postgresql' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','399bd1ee587245ecac6f39beaa99886f')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10358',NULL,'Apache ActiveMQ by JMX','3','-1','2','','','Apache ActiveMQ by JMX','0',NULL,'The template to monitor Apache ActiveMQ by Zabbix that work without any external scripts.' || chr(13) || chr(10) || 'The metrics are collected by JMX.' || chr(13) || chr(10) || 'You can set macro values and add macros with context for specific brokers or destinations following macro description.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/411049-discussion-thread-for-official-zabbix-template-amq' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','c87e0a2e0683483ab7c6f3c380e9f840')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10359',NULL,'Aranet Cloud','3','-1','2','','','Aranet Cloud','0',NULL,'Template tooling version used: 0.41','1','1','','','','','','1','0','0','af21edc47557400583e537904ea632aa')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10360',NULL,'Microsoft Exchange Server 2016 by Zabbix agent','3','-1','2','','','Microsoft Exchange Server 2016 by Zabbix agent','0',NULL,'The template to monitor Microsoft Exchange Server 2016 by Zabbix that works without any external scripts.' || chr(13) || chr(10) || 'The metrics are collected by Zabbix agent.' || chr(13) || chr(10) || 'Recommended to use it with "OS Windows by Zabbix agent" template.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/415007-discussion-thread-for-official-zabbix-template-microsoft-exchange' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','cbf70ed444394566bcf213dd63d4d352')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10361',NULL,'Microsoft Exchange Server 2016 by Zabbix agent active','3','-1','2','','','Microsoft Exchange Server 2016 by Zabbix agent active','0',NULL,'The template to monitor Microsoft Exchange Server 2016 by Zabbix that works without any external scripts.' || chr(13) || chr(10) || 'The metrics are collected by Zabbix agent active.' || chr(13) || chr(10) || 'Recommended to use it with "OS Windows by Zabbix agent active" template.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/415007-discussion-thread-for-official-zabbix-template-microsoft-exchange' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','a0e05ca631034676821b7e0e1ce25488')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10362',NULL,'GitLab by HTTP','3','-1','2','','','GitLab by HTTP','0',NULL,'Get GitLab metrics by HTTP agent from Prometheus metrics endpoint.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'To access the metrics, the client IP address must be explicitly allowed. See https://docs.gitlab.com/ee/administration/monitoring/ip_whitelist.html.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Don''t forget change macros {$GITLAB.URL}.' || chr(13) || chr(10) || 'Some metrics may not be collected depending on your Gitlab instance version and configuration. See (Gitlab''s documentation[)https://docs.gitlab.com/ee/administration/monitoring/prometheus/gitlab_metrics.html] for further information about its metric collection.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','f445dac89ff74deabaae9dcb84815998')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10363',NULL,'Hadoop by HTTP','3','-1','2','','','Hadoop by HTTP','0',NULL,'The template gets the Hadoop metrics from cluster''s hosts (ResourceManager, NodeManagers, NameNode, DataNodes) by HTTP agent. You should define the IP address (or FQDN) and Web-UI port for the ResourceManager in {$HADOOP.RESOURCEMANAGER.HOST} and {$HADOOP.RESOURCEMANAGER.PORT} macros and for the NameNode in {$HADOOP.NAMENODE.HOST} and {$HADOOP.NAMENODE.PORT} macros respectively. Macros can be set in the template or overridden at the host level.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/413459-discussion-thread-for-official-zabbix-template-hadoop' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','e129aeba7c814bf189772cf5919b4bbb')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10364',NULL,'Apache Kafka by JMX','3','-1','2','','','Apache Kafka by JMX','0',NULL,'Official JMX Template for Apache Kafka.' || chr(13) || chr(10) || '  The metrics are collected by JMX.' || chr(13) || chr(10) || '  You can set {$KAFKA.USER} and {$KAFKA.PASSWORD} macros in the template for using on the host level.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','2eb43a3c9666467683b9ce09d2bd26d7')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10365',NULL,'HashiCorp Vault by HTTP','3','-1','2','','','HashiCorp Vault by HTTP','0',NULL,'Get HashiCorp Vault metrics from Vault API HTTP Prometheus metrics endpoint.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Some metrics may not be collected depending on your Vault instance version and configuration.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','2f82248e411340429d390e8389850401')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10366',NULL,'VMware FQDN','3','-1','2','','','VMware FQDN','0',NULL,'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','ca02e82e6c414d0aa7aedc8d78468a49')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10367',NULL,'{#HV.UUID}','0','-1','2','','','{#HV.NAME}','2',NULL,'','1','1','','','','','','1','0','1','51cf7ea3e6a74f7e8dde628dbc5347a3')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10368',NULL,'{#VM.DNS}','0','-1','2','','','{#VM.NAME}','2',NULL,'','1','1','','','','','','1','0','1','a12e25c500a14fcf99295c207371ca1b')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10369',NULL,'Zookeeper by HTTP','3','-1','2','','','Zookeeper by HTTP','0',NULL,'Get Apache Zookeeper metrics by HTTP agent.' || chr(13) || chr(10) || '  This template works with standalone and cluster instances. Metrics are collected from each Zookeeper node by requests to AdminServer.' || chr(13) || chr(10) || '  Don''t forget to change macros {$ZOOKEEPER.COMMAND_URL}, {$ZOOKEEPER.PORT}, {$ZOOKEEPER.SCHEME}.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','b606eda347ea4663a33ad4d12a482750')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10370',NULL,'Apache Cassandra by JMX','3','-1','2','','','Apache Cassandra by JMX','0',NULL,'The template to monitor Apache Cassandra by Zabbix that work without any external scripts.' || chr(13) || chr(10) || 'It works with both standalone and cluster instances.' || chr(13) || chr(10) || 'The metrics are collected by JMX.' || chr(13) || chr(10) || 'You can set {$CASSANDRA.USER} and {$CASSANDRA.PASSWORD} macros in the template for using on the host level.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/410057-discussion-thread-for-official-zabbix-template-apache-cassandra' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','5c42de26643c4b43b23a11159df021ce')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10371',NULL,'Morningstar ProStar MPPT SNMP','3','-1','2','','','Morningstar ProStar MPPT SNMP','0',NULL,'MIBs used:' || chr(13) || chr(10) || 'PROSTAR-MPPT' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','b84324c2a40a496dbbb379bbf5dde8d5')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10372',NULL,'Morningstar ProStar PWM SNMP','3','-1','2','','','Morningstar ProStar PWM SNMP','0',NULL,'MIBs used:' || chr(13) || chr(10) || 'PROSTAR-PWM' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','24bed6339f0a492fab86fe757394b937')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10373',NULL,'Morningstar SunSaver MPPT SNMP','3','-1','2','','','Morningstar SunSaver MPPT SNMP','0',NULL,'MIBs used:' || chr(13) || chr(10) || 'SUNSAVER-MPPT' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','f1336fd88ab0415a9c02892a71e50032')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10374',NULL,'Morningstar SureSine SNMP','3','-1','2','','','Morningstar SureSine SNMP','0',NULL,'MIBs used:' || chr(13) || chr(10) || 'SURESINE' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','3bbfe42c78c74f04a2565431fbdd19e2')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10375',NULL,'Morningstar TriStar MPPT 600V SNMP','3','-1','2','','','Morningstar TriStar MPPT 600V SNMP','0',NULL,'MIBs used:' || chr(13) || chr(10) || 'TRISTAR-MPPT' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','2d20a2fbd540492089fdcafc8feb60e3')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10376',NULL,'Morningstar TriStar MPPT SNMP','3','-1','2','','','Morningstar TriStar MPPT SNMP','0',NULL,'MIBs used:' || chr(13) || chr(10) || 'TRISTAR-MPPT' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','07b32152c3654e8ead4c1eeae24efa8f')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10377',NULL,'Morningstar TriStar PWM SNMP','3','-1','2','','','Morningstar TriStar PWM SNMP','0',NULL,'MIBs used:' || chr(13) || chr(10) || 'TRISTAR' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','230fa9f7c1774821bbe6cdcbbba5cbc6')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10378',NULL,'NetApp FAS3220 SNMP','3','-1','2','','','NetApp FAS3220 SNMP','0',NULL,'The template to monitor SAN NetApp FAS3220 cluster by Zabbix SNMP agent.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'NETAPP-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/416694-discussion-thread-for-official-zabbix-template-netapp-fas3220' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','e118ab11c1ec4f9cbe21dfce1441c0f6')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10379',NULL,'Jenkins by HTTP','3','-1','2','','','Jenkins by HTTP','0',NULL,'Get Jenkins metrics by HTTP agent.' || chr(13) || chr(10) || 'Metrics are collected by requests to Metrics API. Install  Metrics plugin and configure access to the Metrics Servlet by issuing API key.' || chr(13) || chr(10) || 'Don''t forget to change macros {$JENKINS.URL}, {$JENKINS.USER}, {$JENKINS.API.TOKEN}, {$JENKINS.API.KEY}.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','2ef2f2eb75ee4a0bae839e22aa76e5fc')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10380',NULL,'Hikvision camera by HTTP','3','-1','2','','','Hikvision camera by HTTP','0',NULL,'Template tooling version used: 0.41','1','1','','','','','','1','0','0','3fb4020df2984b0ab64dfd8355ff5c65')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10381',NULL,'Ignite by JMX','3','-1','2','','','Ignite by JMX','0',NULL,'The template to monitor Apache Ignite by Zabbix that work without any external scripts.' || chr(13) || chr(10) || '  It works with both standalone and cluster instances.' || chr(13) || chr(10) || '  The metrics are discoverable and collected by JMX.' || chr(13) || chr(10) || '  Current JMX tree hierarchy contains classloader by default. Add the following jvm option `-DIGNITE_MBEAN_APPEND_CLASS_LOADER_ID=false`to will exclude one level with Classloader name.' || chr(13) || chr(10) || '  You can set {$IGNITE.USER} and {$IGNITE.PASSWORD} macros in the template for using on the host level.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','ab05dbb15ff047f192782f617f0627ac')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10382',NULL,'Microsoft SharePoint by HTTP','3','-1','2','','','Microsoft SharePoint by HTTP','0',NULL,'Overview:' || chr(13) || chr(10) || 'Template receives data via HTTP Agent.' || chr(13) || chr(10) || 'Setup:' || chr(13) || chr(10) || 'Create a new host.' || chr(13) || chr(10) || 'Define macros according to your Sharepoint web portal.' || chr(13) || chr(10) || 'It is recommended to fill in the values of the filter macros to avoid getting redundant data.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','8d5fe5b4ebb64255a2429b34c7dd3681')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10383',NULL,'SMART by Zabbix agent 2','3','-1','2','','','SMART by Zabbix agent 2','0',NULL,'The template for monitoring S.M.A.R.T. attributes of physical disk that works without any external scripts. It collects metrics by Zabbix agent 2 version 5.0 and later with Smartmontools version 7.1 and later. Disk discovery LLD rule finds all HDD, SSD, NVMe disks with S.M.A.R.T. enabled. Attribute discovery LLD rule have pre-defined Vendor Specific Attributes for each disk, and will be discovered if attribute is present.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/415662-discussion-thread-for-official-zabbix-smart-disk-monitoring' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','7b6c6228b25f4586b42cd1bf37ff8034')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10384',NULL,'SMART by Zabbix agent 2 active','3','-1','2','','','SMART by Zabbix agent 2 active','0',NULL,'The template for monitoring S.M.A.R.T. attributes of physical disk that works without any external scripts. It collects metrics by Zabbix agent 2 version 5.0 and later with Smartmontools version 7.1 and later. Disk discovery LLD rule finds all HDD, SSD, NVMe disks with S.M.A.R.T. enabled. Attribute discovery LLD rule have pre-defined Vendor Specific Attributes for each disk, and will be discovered if attribute is present.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/415662-discussion-thread-for-official-zabbix-smart-disk-monitoring' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','e518b1340ce44d7389d2cc7c304a97b4')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10385',NULL,'Huawei OceanStor 5300 V5 SNMP','3','-1','2','','','Huawei OceanStor 5300 V5 SNMP','0',NULL,'The template to monitor SAN Huawei OceanStor 5300 V5 by Zabbix SNMP agent.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418855-discussion-thread-for-official-zabbix-template-huawei-oceanstor' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','c5564dd58c394b969d5365cc5de3e7f8')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10386',NULL,'MongoDB node by Zabbix agent 2','3','-1','2','','','MongoDB node by Zabbix agent 2','0',NULL,'Get MongoDB metrics from plugin for the zabbix-agent2.' || chr(13) || chr(10) || '  1. Setup and configure zabbix-agent2 compiled with the MongoDB monitoring plugin.' || chr(13) || chr(10) || '  2. Set the {$MONGODB.CONNSTRING} such as <protocol(host:port)> or named session.' || chr(13) || chr(10) || '  3. Set the user name and password in host macros ({$MONGODB.USER}, {$MONGODB.PASSWORD}) if you want to override parameters from the Zabbix agent configuration file.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420659-discussion-thread-for-official-zabbix-template-db-mongodb' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','81aa8c5ab5594f77a2b26fb7f5094048')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10387',NULL,'MongoDB cluster by Zabbix agent 2','3','-1','2','','','MongoDB cluster by Zabbix agent 2','0',NULL,'Get MongoDB metrics from plugin for the zabbix-agent2.' || chr(13) || chr(10) || '  1. Setup and configure zabbix-agent2 compiled with the MongoDB monitoring plugin.' || chr(13) || chr(10) || '  2. Set the {$MONGODB.CONNSTRING} such as <protocol(host:port)> or named session.' || chr(13) || chr(10) || '  3. Set the user name and password in host macros ({$MONGODB.USER}, {$MONGODB.PASSWORD}) if you want to override parameters from the Zabbix agent configuration file.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  All sharded Mongodb nodes (mongod) will be discovered with attached template "MongoDB node".' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420659-discussion-thread-for-official-zabbix-template-db-mongodb' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','d38b271797bd41f2ad8c79d83b9d8d9c')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10388',NULL,'{#HOSTNAME}','0','-1','2','','','{#HOSTNAME}','2',NULL,'','1','1','','','','','','1','0','0','809db5d8d32a45898e8401f288a42fac')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10389',NULL,'{#HOSTNAME}','0','-1','2','','','{#HOSTNAME}','2',NULL,'','1','1','','','','','','1','0','0','3fcd3244b1234186bda9a35c8f61c850')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10390',NULL,'Cisco Catalyst 3750V2-24FS SNMP','3','-1','2','','','Cisco Catalyst 3750V2-24FS SNMP','0',NULL,'Template Cisco Catalyst 3750V2-24FS' || chr(13) || chr(10) || '  ' || chr(13) || chr(10) || '  MIBs used:' || chr(13) || chr(10) || '  CISCO-MEMORY-POOL-MIB' || chr(13) || chr(10) || '  IF-MIB' || chr(13) || chr(10) || '  EtherLike-MIB' || chr(13) || chr(10) || '  SNMPv2-MIB' || chr(13) || chr(10) || '  CISCO-PROCESS-MIB' || chr(13) || chr(10) || '  CISCO-ENVMON-MIB' || chr(13) || chr(10) || '  ENTITY-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418396-discussion-thread-for-official-zabbix-templates-for-cisco' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','6ff896f545e043cc98de6d98698d41df')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10391',NULL,'Cisco Catalyst 3750V2-24PS SNMP','3','-1','2','','','Cisco Catalyst 3750V2-24PS SNMP','0',NULL,'Template Cisco Catalyst 3750V2-24PS' || chr(13) || chr(10) || '  ' || chr(13) || chr(10) || '  MIBs used:' || chr(13) || chr(10) || '  CISCO-MEMORY-POOL-MIB' || chr(13) || chr(10) || '  IF-MIB' || chr(13) || chr(10) || '  EtherLike-MIB' || chr(13) || chr(10) || '  SNMPv2-MIB' || chr(13) || chr(10) || '  CISCO-PROCESS-MIB' || chr(13) || chr(10) || '  CISCO-ENVMON-MIB' || chr(13) || chr(10) || '  ENTITY-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418396-discussion-thread-for-official-zabbix-templates-for-cisco' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','4583f0c3bc894251a6c5e7129cb5b9aa')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10392',NULL,'Cisco Catalyst 3750V2-24TS SNMP','3','-1','2','','','Cisco Catalyst 3750V2-24TS SNMP','0',NULL,'Template Cisco Catalyst 3750V2-24TS' || chr(13) || chr(10) || '  ' || chr(13) || chr(10) || '  MIBs used:' || chr(13) || chr(10) || '  CISCO-MEMORY-POOL-MIB' || chr(13) || chr(10) || '  IF-MIB' || chr(13) || chr(10) || '  EtherLike-MIB' || chr(13) || chr(10) || '  SNMPv2-MIB' || chr(13) || chr(10) || '  CISCO-PROCESS-MIB' || chr(13) || chr(10) || '  CISCO-ENVMON-MIB' || chr(13) || chr(10) || '  ENTITY-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418396-discussion-thread-for-official-zabbix-templates-for-cisco' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','30d084c6b7844b7cab6cf820b00bb7b2')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10393',NULL,'Cisco Catalyst 3750V2-48PS SNMP','3','-1','2','','','Cisco Catalyst 3750V2-48PS SNMP','0',NULL,'Template Cisco Catalyst 3750V2-48PS' || chr(13) || chr(10) || '  ' || chr(13) || chr(10) || '  MIBs used:' || chr(13) || chr(10) || '  CISCO-MEMORY-POOL-MIB' || chr(13) || chr(10) || '  IF-MIB' || chr(13) || chr(10) || '  EtherLike-MIB' || chr(13) || chr(10) || '  SNMPv2-MIB' || chr(13) || chr(10) || '  CISCO-PROCESS-MIB' || chr(13) || chr(10) || '  CISCO-ENVMON-MIB' || chr(13) || chr(10) || '  ENTITY-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418396-discussion-thread-for-official-zabbix-templates-for-cisco' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','ea096c13a09b4d7a9be0aab1cec95206')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10394',NULL,'Cisco Catalyst 3750V2-48TS SNMP','3','-1','2','','','Cisco Catalyst 3750V2-48TS SNMP','0',NULL,'Template Cisco Catalyst 3750V2-48TS' || chr(13) || chr(10) || '  ' || chr(13) || chr(10) || '  MIBs used:' || chr(13) || chr(10) || '  CISCO-MEMORY-POOL-MIB' || chr(13) || chr(10) || '  IF-MIB' || chr(13) || chr(10) || '  EtherLike-MIB' || chr(13) || chr(10) || '  SNMPv2-MIB' || chr(13) || chr(10) || '  CISCO-PROCESS-MIB' || chr(13) || chr(10) || '  CISCO-ENVMON-MIB' || chr(13) || chr(10) || '  ENTITY-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418396-discussion-thread-for-official-zabbix-templates-for-cisco' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','f744679600844c07b2b4eedda9bc3d0c')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10395',NULL,'APC UPS SNMP','3','-1','2','','','APC UPS SNMP','0',NULL,'Template Power APC UPS' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'PowerNet-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','3ec55c9966624ef5bc1b50502812d581')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10396',NULL,'NetApp AFF A700 by HTTP','3','-1','2','','','NetApp AFF A700 by HTTP','0',NULL,'The template to monitor SAN NetApp AFF A700 cluster by Zabbix HTTP agent.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','79267c69f54a4e59b4152aba4e8c4bd5')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10397',NULL,'TiDB PD by HTTP','3','-1','2','','','TiDB PD by HTTP','0',NULL,'The template to monitor PD server of TiDB cluster by Zabbix that works without any external scripts.' || chr(13) || chr(10) || 'Most of the metrics are collected in one go, thanks to Zabbix bulk data collection.' || chr(13) || chr(10) || 'Don''t forget to change the macros {$PD.URL}, {$PD.PORT}.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template `TiDB PD by HTTP` — collects metrics by HTTP agent from PD /metrics endpoint and from monitoring API.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','43596328d4d74a5592906a9e08e3fd96')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10398',NULL,'TiDB by HTTP','3','-1','2','','','TiDB by HTTP','0',NULL,'The template to monitor TiDB server of TiDB cluster by Zabbix that works without any external scripts.' || chr(13) || chr(10) || 'Most of the metrics are collected in one go, thanks to Zabbix bulk data collection.' || chr(13) || chr(10) || 'Don''t forget to change the macros {$TIDB.URL}, {$TIDB.PORT}.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template `TiDB by HTTP` — collects metrics by HTTP agent from PD /metrics endpoint and from monitoring API.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','8ec72ebbe3204d7789429640abcac610')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10399',NULL,'TiDB TiKV by HTTP','3','-1','2','','','TiDB TiKV by HTTP','0',NULL,'The template to monitor TiKV server of TiDB cluster by Zabbix that works without any external scripts.' || chr(13) || chr(10) || 'Most of the metrics are collected in one go, thanks to Zabbix bulk data collection.' || chr(13) || chr(10) || 'Don''t forget to change the macros {$TIKV.URL}, {$TIKV.PORT}.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template `TiDB TiKV by HTTP` — collects metrics by HTTP agent from TiKV /metrics endpoint.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','3a0bbbb2ec0a4c58bba3ba3a3d6ce660')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10400',NULL,'APC UPS Galaxy 3500 SNMP','3','-1','2','','','APC UPS Galaxy 3500 SNMP','0',NULL,'Template Power APC UPS Galaxy 3500' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'PowerNet-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','5d3971cd973b46e7915d7ae0750bac57')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10401',NULL,'APC Smart-UPS 2200 RM SNMP','3','-1','2','','','APC Smart-UPS 2200 RM SNMP','0',NULL,'Template Power APC Smart-UPS 2200 RM' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'PowerNet-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','e8c0b2c40e884f1598d86f3edf020ea7')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10402',NULL,'APC Smart-UPS 3000 XLM SNMP','3','-1','2','','','APC Smart-UPS 3000 XLM SNMP','0',NULL,'Template Power APC Smart-UPS 3000 XLM' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'PowerNet-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','eafd78764fde4110b9e46ae184f327ba')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10403',NULL,'APC Smart-UPS RT 1000 RM XL SNMP','3','-1','2','','','APC Smart-UPS RT 1000 RM XL SNMP','0',NULL,'Template Power APC Smart-UPS RT 1000 RM XL' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'PowerNet-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','340ec6917c274ead8fab36925e57f30a')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10404',NULL,'APC Smart-UPS RT 1000 XL SNMP','3','-1','2','','','APC Smart-UPS RT 1000 XL SNMP','0',NULL,'Template Power APC Smart-UPS RT 1000 XL' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'PowerNet-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','32d3c78ff44c4c3c9ff5b893ad7f5fc9')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10406',NULL,'APC Smart-UPS SRT 8000 SNMP','3','-1','2','','','APC Smart-UPS SRT 8000 SNMP','0',NULL,'Template Power APC Smart-UPS SRT 8000' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'PowerNet-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','b3caafda8c5345cc832ac3be3cefa615')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10407',NULL,'APC UPS Symmetra LX SNMP','3','-1','2','','','APC UPS Symmetra LX SNMP','0',NULL,'Template Power APC UPS Symmetra LX' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'PowerNet-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','0b9a899ff8f1467c9fdf999d02b9fd77')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10408',NULL,'APC UPS Symmetra RM SNMP','3','-1','2','','','APC UPS Symmetra RM SNMP','0',NULL,'Template Power APC UPS Symmetra RM' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'PowerNet-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','1dac0a88c3774315b90622a48031e369')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10409',NULL,'APC UPS Symmetra RX SNMP','3','-1','2','','','APC UPS Symmetra RX SNMP','0',NULL,'Template Power APC UPS Symmetra RX' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'PowerNet-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','4ffb0f9103084384a98379ed533865e9')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10410',NULL,'WildFly Domain by JMX','3','-1','2','','','WildFly Domain by JMX','0',NULL,'Official JMX Template for WildFly.' || chr(13) || chr(10) || 'The metrics are collected by JMX. This template works with Domain Controller.' || chr(13) || chr(10) || 'You can set {$WILDFLY.USER} and {$WILDFLY.PASSWORD} macros in the template for using on the host level.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','4b27e636b6ad4ce68511d344d5604999')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10411',NULL,'WildFly Server by JMX','3','-1','2','','','WildFly Server by JMX','0',NULL,'Official JMX Template for WildFly.' || chr(13) || chr(10) || 'The metrics are collected by JMX. This template works with standalone and domain instances.' || chr(13) || chr(10) || 'You can set {$WILDFLY.USER} and {$WILDFLY.PASSWORD} macros in the template for using on the host level.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','2bf5827343f0420792ad953f290baa05')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10412',NULL,'APC Smart-UPS SRT 5000 SNMP','3','-1','2','','','APC Smart-UPS SRT 5000 SNMP','0',NULL,'Template Power APC Smart-UPS SRT 5000' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'PowerNet-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','8ec76aeb703747a5affdf435bc12f572')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10413',NULL,'Website certificate by Zabbix agent 2','3','-1','2','','','Website certificate by Zabbix agent 2','0',NULL,'The template to monitor TLS/SSL certificate on the website by Zabbix agent 2 that works without any external scripts.' || chr(13) || chr(10) || 'Zabbix agent 2 with the WebCertificate plugin requests certificate using the web.certificate.get key and returns JSON with certificate attributes.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/428309-discussion-thread-for-official-zabbix-template-tls-ssl-certificates-monitoring' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','5630ec1b1baf449abe1bc5521f85fe6c')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10414',NULL,'Cloudflare by HTTP','3','-1','2','','','Cloudflare by HTTP','0',NULL,'The template to monitor Cloudflare to see your web traffic and DNS metrics. It works without any external scripts and uses Script item.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','08ef3d687d754b0aba17e1dcbd77d4bd')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10415',NULL,'Nginx Plus by HTTP','3','-1','2','','','Nginx Plus by HTTP','0',NULL,'Get Nginx Plus metrics by HTTP agent.' || chr(13) || chr(10) || 'Metrics are collected by requests to Nginx Plus API.' || chr(13) || chr(10) || 'Don''t forget to change macros {$NGINX.API.ENDPOINT}.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','8cad0f2564694416b60bd8a414948641')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10416',NULL,'Systemd by Zabbix agent 2','3','-1','2','','','Systemd by Zabbix agent 2','0',NULL,'Get systemd units metrics from plugin for the zabbix-agent2.' || chr(13) || chr(10) || '  1. Setup and configure zabbix-agent2 compiled with the Systemd monitoring plugin.' || chr(13) || chr(10) || '  2. Set filters with macros if you want to override default filter parameters.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','90ac276995294a6aa88462c032d2ddaf')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10417',NULL,'GridGain by JMX','3','-1','2','','','GridGain by JMX','0',NULL,'The template to monitor GridGain In-Memory Computing Platform by Zabbix that work without any external scripts.' || chr(13) || chr(10) || '  It works with both standalone and cluster instances.' || chr(13) || chr(10) || '  The metrics are discoverable and collected by JMX.' || chr(13) || chr(10) || '  Current JMX tree hierarchy contains classloader by default. Add the following jvm option `-DIGNITE_MBEAN_APPEND_CLASS_LOADER_ID=false`to will exclude one level with Classloader name.' || chr(13) || chr(10) || '  You can set {$GRIDGAIN.USER} and {$GRIDGAIN.PASSWORD} macros in the template for using on the host level.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','47d87c39c121429b98a18f641aa443ea')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10418',NULL,'Cisco ASAv SNMP','3','-1','2','','','Cisco ASAv SNMP','0',NULL,'Template Net Cisco ASAv' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'CISCO-PORT-MIB' || chr(13) || chr(10) || 'CISCO-MEMORY-POOL-MIB' || chr(13) || chr(10) || 'CISCO-REMOTE-ACCESS-MONITOR-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || 'RFC1213-MIB' || chr(13) || chr(10) || 'CISCO-PROCESS-MIB' || chr(13) || chr(10) || 'ENTITY-MIB' || chr(13) || chr(10) || ' CISCO-REMOTE-ACCESS-MONITOR-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418396-discussion-thread-for-official-zabbix-templates-for-cisco' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','75d009cd4dc84ee7a8fc479fa2fbaeee')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10419',NULL,'F5 Big-IP SNMP','3','-1','2','','','F5 Big-IP SNMP','0',NULL,'MIBs used:' || chr(13) || chr(10) || 'RFC1213-MIB' || chr(13) || chr(10) || 'F5-BIGIP-LOCAL-MIB' || chr(13) || chr(10) || 'F5-BIGIP-SYSTEM-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','44c2c2d94a4447c6a924386640e4854a')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10420',NULL,'ZYXEL AAM1212-51 IES-612 SNMP','3','-1','2','','','ZYXEL AAM1212-51 IES-612 SNMP','0',NULL,'ZYXEL AAM1212-51 / IES-612' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'RFC1213-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'ADSL-LINE-MIB' || chr(13) || chr(10) || 'ZYXEL-IESCOMMON-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.' || chr(13) || chr(10) || '  Version: all versions firmware' || chr(13) || chr(10) || '  Device: ZYXEL AAM1212-51 / IES-612' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','3a71dcdcfe0b4a0e8284d8939d335cce')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10421',NULL,'ZYXEL ES3500-8PD SNMP','3','-1','2','','','ZYXEL ES3500-8PD SNMP','0',NULL,'ZYXEL ES3500-8PD' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'RFC1213-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || ' ZYXEL-ES3500-8PD-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || 'ZYXEL-ES3500-8PD-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.' || chr(13) || chr(10) || '  Version: all versions firmware' || chr(13) || chr(10) || '  Device: ZYXEL ES3500-8PD' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','b8a6f34fd5c447b1b9310746a96f4e80')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10422',NULL,'ZYXEL GS-4012F SNMP','3','-1','2','','','ZYXEL GS-4012F SNMP','0',NULL,'ZYXEL GS-4012F' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'ZYXEL-GS4012F-MIB' || chr(13) || chr(10) || 'RFC1213-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.' || chr(13) || chr(10) || '  Version: all versions firmware' || chr(13) || chr(10) || '  Device: ZYXEL GS-4012F' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','73f123bb9ffe4587a0269c7e8752b2ed')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10423',NULL,'ZYXEL IES-500x SNMP','3','-1','2','','','ZYXEL IES-500x SNMP','0',NULL,'ZYXEL IES-500x' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'RFC1213-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'ADSL-LINE-MIB' || chr(13) || chr(10) || 'ZYXEL-IES5000-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.' || chr(13) || chr(10) || '  Version: all versions firmware' || chr(13) || chr(10) || '  Device: ZYXEL IES-500x' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','3db86b0d235e4c7b80f7d6144ca08925')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10424',NULL,'ZYXEL IES-6000 SNMP','3','-1','2','','','ZYXEL IES-6000 SNMP','0',NULL,'ZYXEL IES-6000' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'RFC1213-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'ADSL-LINE-MIB' || chr(13) || chr(10) || 'ZYXEL-IES5000-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.' || chr(13) || chr(10) || '  Version: all versions firmware' || chr(13) || chr(10) || '  Device: ZYXEL IES-6000' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','3645654baaf04f11927b171bcb048349')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10425',NULL,'ZYXEL IES1248-51 SNMP','3','-1','2','','','ZYXEL IES1248-51 SNMP','0',NULL,'ZYXEL IES1248-51' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'RFC1213-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'ADSL-LINE-MIB' || chr(13) || chr(10) || 'ZYXEL-IESCOMMON-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.' || chr(13) || chr(10) || '  Version: all versions firmware' || chr(13) || chr(10) || '  Device: ZYXEL IES1248-51' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','8e6d7067cd094e56a52db999b3199edc')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10426',NULL,'ZYXEL MES-3528 SNMP','3','-1','2','','','ZYXEL MES-3528 SNMP','0',NULL,'ZYXEL MES-3528' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'RFC1213-MIB' || chr(13) || chr(10) || ' ZYXEL-MES3528-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'ZYXEL-MES3528-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.' || chr(13) || chr(10) || '  Version: all versions firmware' || chr(13) || chr(10) || '  Device: ZYXEL MES-3528' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','249de8d8d21e4dda9c3f766ab6201378')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10427',NULL,'ZYXEL MES3500-10 SNMP','3','-1','2','','','ZYXEL MES3500-10 SNMP','0',NULL,'ZYXEL MES3500-10' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'RFC1213-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'ZYXEL-MES3500-10-MIB' || chr(13) || chr(10) || ' ZYXEL-MES3500-10-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.' || chr(13) || chr(10) || '  Version: all versions firmware' || chr(13) || chr(10) || '  Device: ZYXEL MES3500-10' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','21a95afef0e74fb19691693090403d1d')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10428',NULL,'ZYXEL MES3500-24 SNMP','3','-1','2','','','ZYXEL MES3500-24 SNMP','0',NULL,'ZYXEL MES3500-24' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'RFC1213-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || ' ZYXEL-MES3500-24-MIB' || chr(13) || chr(10) || 'ZYXEL-MES3500-24-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.' || chr(13) || chr(10) || '  Version: all versions firmware' || chr(13) || chr(10) || '  Device: ZYXEL MES3500-24' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','292970ad91204722b5e5cb3233fc0026')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10429',NULL,'ZYXEL MGS-3712 SNMP','3','-1','2','','','ZYXEL MGS-3712 SNMP','0',NULL,'ZYXEL MGS-3712' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'RFC1213-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'ZYXEL-MGS3712F-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.' || chr(13) || chr(10) || '  Version: all versions firmware' || chr(13) || chr(10) || '  Device: ZYXEL MGS-3712' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','8ea7299983f24d0a913606e334f0e526')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10430',NULL,'ZYXEL MGS-3712F SNMP','3','-1','2','','','ZYXEL MGS-3712F SNMP','0',NULL,'ZYXEL MGS-3712F' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'RFC1213-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'ZYXEL-MGS3712F-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.' || chr(13) || chr(10) || '  Version: all versions firmware' || chr(13) || chr(10) || '  Device: ZYXEL MGS-3712F' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','01deb47efa1f4a9092de67fd61820a7d')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10431',NULL,'ZYXEL MES3500-24S SNMP','3','-1','2','','','ZYXEL MES3500-24S SNMP','0',NULL,'ZYXEL MES3500-24S' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'ZYXEL-TRANSCEIVER-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || 'RFC1213-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'ZYXEL-HW-MONITOR-MIB' || chr(13) || chr(10) || 'ZYXEL-PORT-MIB' || chr(13) || chr(10) || 'ZYXEL-ES-COMMON' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.' || chr(13) || chr(10) || '  Version: all versions firmware' || chr(13) || chr(10) || '  Device: ZYXEL MGS3520-28' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','89eef2fe23964f44bf9aec6d00e39efd')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10432',NULL,'ZYXEL MGS3520-28x SNMP','3','-1','2','','','ZYXEL MGS3520-28x SNMP','0',NULL,'ZYXEL MGS3520-28x' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'ZYXEL-TRANSCEIVER-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || 'RFC1213-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'ZYXEL-HW-MONITOR-MIB' || chr(13) || chr(10) || 'ZYXEL-PORT-MIB' || chr(13) || chr(10) || 'ZYXEL-ES-COMMON' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.' || chr(13) || chr(10) || '  Version: all versions firmware' || chr(13) || chr(10) || '  Device: ZYXEL MGS3520-28' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','9cc843a085bb4ee5af0dc4d764a7eee9')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10433',NULL,'ZYXEL XGS-4728F SNMP','3','-1','2','','','ZYXEL XGS-4728F SNMP','0',NULL,'ZYXEL XGS-4728F' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'RFC1213-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'ZYXEL-XGS4728F-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || ' ZYXEL-XGS4728F-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Known Issues:' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.' || chr(13) || chr(10) || '  Version: all versions firmware' || chr(13) || chr(10) || '  Device: ZYXEL XGS-4728F' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','ab18a5665b7d4bed876881b5c4e8ce51')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10434',NULL,'Cisco UCS Manager SNMP','3','-1','2','','','Cisco UCS Manager SNMP','0',NULL,'This is a template for Cisco UCS Manager monitoring via Zabbix SNMP Agent that works without any external scripts.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'CISCO-UNIFIED-COMPUTING-COMPUTE-MIB' || chr(13) || chr(10) || 'CISCO-UNIFIED-COMPUTING-EQUIPMENT-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'CISCO-UNIFIED-COMPUTING-PROCESSOR-MIB' || chr(13) || chr(10) || 'CISCO-UNIFIED-COMPUTING-STORAGE-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418396-discussion-thread-for-official-zabbix-templates-for-cisco' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','d5eb4ce08a334098a85e6e02c534be90')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10435',NULL,'DELL PowerEdge R720 by HTTP','3','-1','2','','','DELL PowerEdge R720 by HTTP','0',NULL,'Template for DELL PowerEdge R720 servers with iDRAC 8/9 firmware 4.32 and later and Redfish API enabled.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','9643f22821104f809e2486be83e1816e')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10436',NULL,'DELL PowerEdge R720 SNMP','3','-1','2','','','DELL PowerEdge R720 SNMP','0',NULL,'Template for DELL PowerEdge R720 servers with iDRAC version 7 and later.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'IDRAC-MIB-SMIv2' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','fe5b8448661f41b9a6d948fccd7f9045')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10437',NULL,'DELL PowerEdge R740 by HTTP','3','-1','2','','','DELL PowerEdge R740 by HTTP','0',NULL,'Template for DELL PowerEdge R740 servers with iDRAC 8/9 firmware 4.32 and later and Redfish API enabled.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','3f707f39c32a4b6e8b214c38a260f6f9')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10438',NULL,'DELL PowerEdge R740 SNMP','3','-1','2','','','DELL PowerEdge R740 SNMP','0',NULL,'Template for DELL PowerEdge R740 servers with iDRAC version 7 and later.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'IDRAC-MIB-SMIv2' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','9fde0e1c36f8453da72f97535d4e74ca')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10439',NULL,'DELL PowerEdge R820 by HTTP','3','-1','2','','','DELL PowerEdge R820 by HTTP','0',NULL,'Template for DELL PowerEdge R820 servers with iDRAC 8/9 firmware 4.32 and later and Redfish API enabled.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','1e9fe6b88c7542638c0f5d94484858b2')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10440',NULL,'DELL PowerEdge R820 SNMP','3','-1','2','','','DELL PowerEdge R820 SNMP','0',NULL,'Template for DELL PowerEdge R820 servers with iDRAC version 7 and later.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'IDRAC-MIB-SMIv2' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','d41c5d0fa91545d68cced1b5dabe4bf1')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10441',NULL,'DELL PowerEdge R840 by HTTP','3','-1','2','','','DELL PowerEdge R840 by HTTP','0',NULL,'Template for DELL PowerEdge R840 servers with iDRAC 8/9 firmware 4.32 and later and Redfish API enabled.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','20147f00f92d4240aab0b70cf578c022')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10442',NULL,'DELL PowerEdge R840 SNMP','3','-1','2','','','DELL PowerEdge R840 SNMP','0',NULL,'Template for DELL PowerEdge R840 servers with iDRAC version 7 and later.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'IDRAC-MIB-SMIv2' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','fc834b8da8864678b55557e9a237eac9')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10443',NULL,'HPE ProLiant BL460 SNMP','3','-1','2','','','HPE ProLiant BL460 SNMP','0',NULL,'Template for HPE ProLiant BL460 servers with HP iLO version 4 and later.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'CPQHLTH-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'CPQNIC-MIB' || chr(13) || chr(10) || 'CPQSINFO-MIB' || chr(13) || chr(10) || 'CPQIDA-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','172ec7e51f1c4a6ba49baffbab3dda97')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10444',NULL,'HPE ProLiant BL920 SNMP','3','-1','2','','','HPE ProLiant BL920 SNMP','0',NULL,'Template for HPE ProLiant BL920 servers with HP iLO version 4 and later.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'CPQHLTH-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'CPQNIC-MIB' || chr(13) || chr(10) || 'CPQSINFO-MIB' || chr(13) || chr(10) || 'CPQIDA-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','586119e5e27e4062a3cce8601ecb8d71')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10445',NULL,'HPE ProLiant DL360 SNMP','3','-1','2','','','HPE ProLiant DL360 SNMP','0',NULL,'Template for HPE ProLiant DL360 servers with HP iLO version 4 and later.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'CPQHLTH-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'CPQNIC-MIB' || chr(13) || chr(10) || 'CPQSINFO-MIB' || chr(13) || chr(10) || 'CPQIDA-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','60cb9ccb922e4fd194a1d9573db10237')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10446',NULL,'HPE ProLiant DL380 SNMP','3','-1','2','','','HPE ProLiant DL380 SNMP','0',NULL,'Template for HPE ProLiant DL380 servers with HP iLO version 4 and later.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'CPQHLTH-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'CPQNIC-MIB' || chr(13) || chr(10) || 'CPQSINFO-MIB' || chr(13) || chr(10) || 'CPQIDA-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','379aaf7e87574debb4f5c3947a22ec68')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10447',NULL,'Travis CI by HTTP','3','-1','2','','','Travis CI by HTTP','0',NULL,'Template for monitoring Travis CI https://travis-ci.com' || chr(13) || chr(10) || 'You must set {$TRAVIS.API.TOKEN} and {$TRAVIS.API.URL} macros.' || chr(13) || chr(10) || '  {$TRAVIS.API.TOKEN} is a Travis API authentication token located in User -> Settings -> API authentication.' || chr(13) || chr(10) || '  {$TRAVIS.API.URL} could be in 2 different variations:' || chr(13) || chr(10) || '   - for a private project : api.travis-ci.com' || chr(13) || chr(10) || '   - for an enterprise projects: api.example.com (where you replace example.com with the domain Travis CI is running on)' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','8cdbe00a2a3046ee962d28d32567968a')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10448',NULL,'InfluxDB by HTTP','3','-1','2','','','InfluxDB by HTTP','0',NULL,'Get InfluxDB metrics by HTTP agent from Prometheus metrics endpoint.' || chr(13) || chr(10) || 'For organization discovery template need to use Authorization via API token. See docs: https://docs.influxdata.com/influxdb/v2.0/security/tokens/' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Don''t forget change macros {$INFLUXDB.URL}, {$INFLUXDB.API.TOKEN}.' || chr(13) || chr(10) || 'Some metrics may not be collected depending on your InfluxDB instance version and configuration.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','a6fe3640b23544e7ae15d438b38ce1cd')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10449',NULL,'MikroTik CCR1009-7G-1C-1SPC SNMP','3','-1','2','','','MikroTik CCR1009-7G-1C-1S+PC SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR1009-7G-1C-1S+PC.' || chr(13) || chr(10) || '7x Gigabit Ethernet, 1x Combo port (SFP or Gigabit Ethernet), 1xSFP+ cage, 9 cores x 1GHz CPU, 2GB RAM, LCD panel, passive cooling desktop enclosure, SmartCard slot, RouterOS L6, PSU' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','d596d6d231bf49c08890aa3ff135ecc6')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10450',NULL,'MikroTik CCR1009-7G-1C-1S SNMP','3','-1','2','','','MikroTik CCR1009-7G-1C-1S+ SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR1009-7G-1C-1S+.' || chr(13) || chr(10) || '1U rackmount, 7x Gigabit Ethernet, 1x Combo port (SFP or Gigabit Ethernet), 1xSFP+ cage, 9 cores x 1.2GHz CPU, 2GB RAM, LCD panel, Dual Power supplies, SmartCard slot, RouterOS L6' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','a809695fbc784b75adcd4833c86bca8d')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10451',NULL,'MikroTik CCR1009-7G-1C-PC SNMP','3','-1','2','','','MikroTik CCR1009-7G-1C-PC SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR1009-7G-1C-PC.' || chr(13) || chr(10) || '7x Gigabit Ethernet, 1x Combo port (SFP or Gigabit Ethernet), 9 cores x 1GHz CPU, 1GB RAM, passive cooling case, RouterOS L6' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','012e7043ff9849e197c42bf41cdf4d9a')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10452',NULL,'MikroTik CCR1016-12G SNMP','3','-1','2','','','MikroTik CCR1016-12G SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR1016-12G.' || chr(13) || chr(10) || '1U rackmount, 12x Gigabit Ethernet, LCD, 16 cores x 1.2GHz CPU, 2GB RAM, 17.8mpps fastpath, Up to 12Gbit/s throughput, RouterOS L6, Dual PSU' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','5ed19d1f74224588bf5f53ac47003acc')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10453',NULL,'MikroTik CCR1016-12S-1S SNMP','3','-1','2','','','MikroTik CCR1016-12S-1S+ SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR1016-12S-1S+.' || chr(13) || chr(10) || '1U rackmount, 12xSFP cage, 1xSFP+ cage, 16 cores x 1.2GHz CPU, 2GB RAM, LCD panel, Dual Power supplies, RouterOS L6' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','654910b270d9464f863ed085ba7302ce')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10454',NULL,'MikroTik CCR1036-12G-4S-EM SNMP','3','-1','2','','','MikroTik CCR1036-12G-4S-EM SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR1036-12G-4S-EM.' || chr(13) || chr(10) || '1U rackmount, 12x Gigabit Ethernet, 4xSFP cages, LCD, 36 cores x 1.2GHz CPU, 8GB RAM, 24 mpps fastpath, Up to 16Gbit/s throughput, RouterOS L6, Dual PSU' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','930c0e0534a9424fb01f2b6218d8ce59')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10455',NULL,'MikroTik CCR1036-12G-4S SNMP','3','-1','2','','','MikroTik CCR1036-12G-4S SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR1036-12G-4S.' || chr(13) || chr(10) || '1U rackmount, 12x Gigabit Ethernet, 4xSFP cages, LCD, 36 cores x 1.2GHz CPU, 4GB RAM, 24 mpps fastpath, Up to 16Gbit/s throughput, RouterOS L6, Dual PSU' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','82b428ad78d34988b93f3d577f2b6adc')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10456',NULL,'MikroTik CCR1036-8G-2SEM SNMP','3','-1','2','','','MikroTik CCR1036-8G-2S+EM SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR1036-8G-2S+EM.' || chr(13) || chr(10) || '1U rackmount, 8x Gigabit Ethernet, 2xSFP+ cages, LCD, 36 cores x 1.2GHz CPU, 8GB RAM, 41.5mpps fastpath, Up to 28Gbit/s throughput, RouterOS L6, Dual PSU' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','7b3ecb24366f4685970df8e1143323f0')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10457',NULL,'MikroTik CCR1036-8G-2S SNMP','3','-1','2','','','MikroTik CCR1036-8G-2S+ SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR1036-8G-2S+.' || chr(13) || chr(10) || '1U rackmount, 8x Gigabit Ethernet, 2xSFP+ cages, LCD, 36 cores x 1.2GHz CPU, 4GB RAM, 41.5mpps fastpath, Up to 28Gbit/s throughput, RouterOS L6, Dual PSU' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','7f44e67e3f564ec9894c9142d7276553')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10458',NULL,'MikroTik CCR1072-1G-8S SNMP','3','-1','2','','','MikroTik CCR1072-1G-8S+ SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR1072-1G-8S+.' || chr(13) || chr(10) || '1U rackmount, 1x Gigabit Ethernet, 8xSFP+ cages, LCD, 72 cores x 1GHz CPU, 16GB RAM, up to 120 million packets per second, 80Gbps throughput, RouterOS L6' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','e7894db1c4c94e0f8715977e751368b3')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10459',NULL,'MikroTik CCR2004-16G-2S SNMP','3','-1','2','','','MikroTik CCR2004-16G-2S+ SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR2004-16G-2S+.' || chr(13) || chr(10) || 'This powerful and affordable router crushes all previous CCR models in single-core performance. 16x Gigabit Ethernet ports, 2x10G SFP+ cages, active cooling and the best single-core performance per watt & best overall performance per watt among all the CCR devices.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','ab871d051e304f83950171c5243aa4db')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10460',NULL,'MikroTik CCR2004-1G-12S2XS SNMP','3','-1','2','','','MikroTik CCR2004-1G-12S+2XS SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR2004-1G-12S+2XS.' || chr(13) || chr(10) || 'The Connectivity Router - your best companion when it comes to SFP, SFP+ and SFP28 management! 1, 10 and 25 Gbps ports in a single device to make your life easier.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','f2efeb94f4bd4ed9ab34a973c0363eb8')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10461',NULL,'MikroTik CRS106-1C-5S SNMP','3','-1','2','','','MikroTik CRS106-1C-5S SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS106-1C-5S.' || chr(13) || chr(10) || 'Smart Switch, 5x SFP cages, 1x Combo port (SFP or Gigabit Ethernet), 400MHz CPU, 128MB RAM, desktop case, RouterOS L5' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','20ea139663264c21bca0dcecf2e95589')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10462',NULL,'MikroTik CRS109-8G-1S-2HnD-IN SNMP','3','-1','2','','','MikroTik CRS109-8G-1S-2HnD-IN SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS109-8G-1S-2HnD-IN.' || chr(13) || chr(10) || '8x Gigabit Smart Switch, 1x SFP cage, LCD, 802.11b/g/n Dual Chain wireless, 600MHz CPU, 128MB RAM, Metal desktop case, RouterOS L5, supports 10-57V, 802.3af/at compliant' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','fac16383680c4454be48b6db870d975e')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10463',NULL,'MikroTik CRS112-8G-4S-IN SNMP','3','-1','2','','','MikroTik CRS112-8G-4S-IN SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS112-8G-4S-IN.' || chr(13) || chr(10) || '8x Gigabit Ethernet Smart Switch, 4x SFP cages, 400MHz CPU, 128MB RAM, desktop case, RouterOS L5' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','8d7d49fd0b3f4b1f9046dc0e94457931')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10464',NULL,'MikroTik CRS112-8P-4S-IN SNMP','3','-1','2','','','MikroTik CRS112-8P-4S-IN SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS112-8P-4S-IN.' || chr(13) || chr(10) || '8x Gigabit Ethernet Smart Switch with PoE-out, 4x SFP cages, 400MHz CPU, 128MB RAM, desktop case, RouterOS L5' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','538ec67ce01341a9b281dbd86d86d2a2')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10465',NULL,'MikroTik CRS125-24G-1S-2HnD-IN SNMP','3','-1','2','','','MikroTik CRS125-24G-1S-2HnD-IN SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS125-24G-1S-2HnD-IN.' || chr(13) || chr(10) || '24x Gigabit Ethernet layer 3 Smart Switch, 1x SFP cage, LCD, 802.11b/g/n Dual Chain wireless, 600MHz CPU, 128MB RAM, Metal desktop case, RouterOS L5' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','c8db153405704d859ba5ee19f08b46f3')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10466',NULL,'MikroTik CRS212-1G-10S-1SIN SNMP','3','-1','2','','','MikroTik CRS212-1G-10S-1S+IN SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS212-1G-10S-1S+IN.' || chr(13) || chr(10) || 'Smart Switch, 1x Gigabit LAN, 10x SFP cages, 1x SFP+ cage, LCD, 400MHz CPU, 64MB RAM, Metal desktop case, RouterOS L5' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','cdb6ebceb1174bada392dd24889b14d9')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10467',NULL,'MikroTik CRS305-1G-4SIN SNMP','3','-1','2','','','MikroTik CRS305-1G-4S+IN SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS305-1G-4S+IN.' || chr(13) || chr(10) || 'Five-port desktop switch with one Gigabit Ethernet port and four SFP+ 10Gbps ports' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','223101f878704022a04c30c3ff066e3f')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10468',NULL,'MikroTik CRS309-1G-8SIN SNMP','3','-1','2','','','MikroTik CRS309-1G-8S+IN SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS309-1G-8S+IN.' || chr(13) || chr(10) || 'Desktop switch with one Gigabit Ethernet port and eight SFP+ 10Gbps ports' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','bcc01f2b466345c4bcbe0cea1a7884d1')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10469',NULL,'MikroTik CRS312-4C8XG-RM SNMP','3','-1','2','','','MikroTik CRS312-4C+8XG-RM SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS312-4C+8XG-RM.' || chr(13) || chr(10) || 'Switch of the future: the first MikroTik product with 10G RJ45 Ethernet ports and SFP+' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','8da94e2f01ff46e28becf0b08ff09ace')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10470',NULL,'MikroTik CRS317-1G-16SRM SNMP','3','-1','2','','','MikroTik CRS317-1G-16S+RM SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS317-1G-16S+RM.' || chr(13) || chr(10) || 'Smart Switch, 1 x Gigabit LAN, 16 x SFP+ cages, Dual Core 800MHz CPU, 1GB RAM, 1U rackmount passive cooling case, Dual Power Supplies' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','f474ff823fe84d689b9e4c6a4f0ce59e')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10471',NULL,'MikroTik CRS326-24G-2SIN SNMP','3','-1','2','','','MikroTik CRS326-24G-2S+IN SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS326-24G-2S+IN.' || chr(13) || chr(10) || '24 Gigabit ports, 2 SFP+ cages and a desktop case – server room power for your home!' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','c5f41fe0f54f470f9e304384838f150a')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10472',NULL,'MikroTik CRS326-24G-2SRM SNMP','3','-1','2','','','MikroTik CRS326-24G-2S+RM SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS326-24G-2S+RM.' || chr(13) || chr(10) || '24 Gigabit port switch with 2 x SFP+ cages in 1U rackmount case, Dual boot (RouterOS or SwitchOS)' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','bc80883918ac4f879427ca145122b5cb')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10473',NULL,'MikroTik CRS326-24S2QRM SNMP','3','-1','2','','','MikroTik CRS326-24S+2Q+RM SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS326-24S+2Q+RM.' || chr(13) || chr(10) || 'Our fastest switch for the most demanding setups' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','e7ed0e0cbd0b439394f6498ea90dc31d')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10474',NULL,'MikroTik CRS328-24P-4SRM SNMP','3','-1','2','','','MikroTik CRS328-24P-4S+RM SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS328-24P-4S+RM.' || chr(13) || chr(10) || '24 port Gigabit Ethernet router/switch with four 10Gbps SFP+ ports in 1U rackmount case, Dual Boot and PoE output, 500W' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','dcf88bca5aaf4123a10eb3daab28a9af')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10475',NULL,'MikroTik CRS328-4C-20S-4SRM SNMP','3','-1','2','','','MikroTik CRS328-4C-20S-4S+RM SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS328-4C-20S-4S+RM.' || chr(13) || chr(10) || 'Smart Switch, 20 x SFP cages, 4 x SFP+ cages, 4 x Combo ports (Gigabit Ethernet or SFP), 800MHz CPU, 512MB RAM, 1U rackmount case, Dual Power Supplies, RouterOS L5 or SwitchOS (Dual Boot)' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','6742f5ed33ca4c19b8e61203770e5fe5')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10476',NULL,'MikroTik CRS354-48G-4S2QRM SNMP','3','-1','2','','','MikroTik CRS354-48G-4S+2Q+RM SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS354-48G-4S+2Q+RM.' || chr(13) || chr(10) || 'Best price and best performance on the market – this 48 port switch will rock any setup, including 40 Gbps devices!' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','d1c1ab5db2c34c17ae3541407f8b7faa')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10477',NULL,'MikroTik CRS354-48P-4S2QRM SNMP','3','-1','2','','','MikroTik CRS354-48P-4S+2Q+RM SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS354-48P-4S+2Q+RM.' || chr(13) || chr(10) || 'The 48 port champion you’ve been waiting for - now with PoE-out!' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','fa5e5e131eb34bbea1b1f7b2352a853d')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10478',NULL,'MikroTik CSS326-24G-2SRM SNMP','3','-1','2','','','MikroTik CSS326-24G-2S+RM SNMP','0',NULL,'The template for monitoring Switch MikroTik CSS326-24G-2S+RM.' || chr(13) || chr(10) || 'SwOS powered 24 port Gigabit Ethernet switch with two SFP+ ports in 1U rackmount case' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','75ada0d6fb22416a9e6e5f44c2c3f64a')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10479',NULL,'MikroTik CSS610-8G-2SIN SNMP','3','-1','2','','','MikroTik CSS610-8G-2S+IN SNMP','0',NULL,'The template for monitoring Switch MikroTik CSS610-8G-2S+IN.' || chr(13) || chr(10) || 'Eight 1G Ethernet ports and two SFP+ ports for 10G fiber connectivity. Portable, powerful and extremely cost-effective – this switch is an instant classic!' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','8d22b4d1a9c6457fbd6fd959263f91db')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10480',NULL,'MikroTik FiberBox SNMP','3','-1','2','','','MikroTik FiberBox SNMP','0',NULL,'The template for monitoring Switch MikroTik FiberBox.' || chr(13) || chr(10) || 'An outdoor switch with five SFP ports' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','2bd6f566391d49dab6bee184522ab5fa')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10481',NULL,'MikroTik PowerBox Pro SNMP','3','-1','2','','','MikroTik PowerBox Pro SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik PowerBox Pro.' || chr(13) || chr(10) || 'Five Gigabit Ethernet Router with 4xPoE-out ports, SFP cage and outdoor enclosure' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','c03e1ab0128a4ae1847bc04a34f5634e')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10482',NULL,'MikroTik PowerBox SNMP','3','-1','2','','','MikroTik PowerBox SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik PowerBox.' || chr(13) || chr(10) || '650MHz CPU, 64MB RAM, 5xEthernet with PoE output for four ports, RouterOS L4, outdoor case, PSU' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','0c7b3c03a5854f868b56f3ab63e2d3f7')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10483',NULL,'MikroTik RB1100AHx4 Dude Edition SNMP','3','-1','2','','','MikroTik RB1100AHx4 Dude Edition SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik RB1100AHx4 Dude Edition.' || chr(13) || chr(10) || 'Powerful 1U rackmount router with 13x Gigabit Ethernet ports, 60GB M.2 drive for Dude database' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','fac50638cb77468598c29a6a47520c24')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10484',NULL,'MikroTik RB1100AHx4 SNMP','3','-1','2','','','MikroTik RB1100AHx4 SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik RB1100AHx4.' || chr(13) || chr(10) || 'Powerful 1U rackmount router with 13x Gigabit Ethernet ports' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','3dfd1a55987848e5aa6ffe92c228f63b')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10485',NULL,'MikroTik RB2011UiAS-IN SNMP','3','-1','2','','','MikroTik RB2011UiAS-IN SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik RB2011UiAS-IN.' || chr(13) || chr(10) || 'Desktop metal case, 5xEthernet, 5xGigabit Ethernet, USB, LCD, PoE out on port 10, 600MHz CPU, 128MB RAM, RouterOS L5' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','8cf537f34600403b9de31d3db4eb2a1d')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10486',NULL,'MikroTik RB2011UiAS-RM SNMP','3','-1','2','','','MikroTik RB2011UiAS-RM SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik RB2011UiAS-RM.' || chr(13) || chr(10) || '1U rackmount, 5xEthernet, 5xGigabit Ethernet, USB, LCD, PoE out on port 10, 600MHz CPU, 128MB RAM, RouterOS L5' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','969cf5dca58f47f0b271ccf62ef79c13')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10487',NULL,'MikroTik RB2011iL-IN SNMP','3','-1','2','','','MikroTik RB2011iL-IN SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik RB2011iL-IN.' || chr(13) || chr(10) || 'Desktop metal case, 5xEthernet, 5xGigabit Ethernet, PoE out on port 10, 600MHz CPU, 64MB RAM, RouterOS L4' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','141438a05f904b518c7d3ddfbbabf91f')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10488',NULL,'MikroTik RB2011iL-RM SNMP','3','-1','2','','','MikroTik RB2011iL-RM SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik RB2011iL-RM.' || chr(13) || chr(10) || '1U rackmount, 5xEthernet, 5xGigabit Ethernet, PoE out on port 10, 600MHz CPU, 64MB RAM, RouterOS L4' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','6d9737c72e5540d39e3553b773a587b1')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10489',NULL,'MikroTik RB2011iLS-IN SNMP','3','-1','2','','','MikroTik RB2011iLS-IN SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik RB2011iLS-IN.' || chr(13) || chr(10) || 'Desktop metal case, 5xEthernet, 5xGigabit Ethernet, SFP cage, PoE out on port 10, 600MHz CPU, 64MB RAM, RouterOS L4' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','318fd61c22fa4f1a92a71376814d6c32')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10490',NULL,'MikroTik RB260GSP SNMP','3','-1','2','','','MikroTik RB260GSP SNMP','0',NULL,'The template for monitoring Switch MikroTik RB260GSP.' || chr(13) || chr(10) || '5x Gigabit PoE out Ethernet Smart Switch, SFP cage, plastic case, SwOS' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','5331ecc3be9f47d6a8eb0732ae141239')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10491',NULL,'MikroTik RB260GS SNMP','3','-1','2','','','MikroTik RB260GS SNMP','0',NULL,'The template for monitoring Switch MikroTik RB260GS.' || chr(13) || chr(10) || '5x Gigabit Ethernet Smart Switch, SFP cage, plastic case, SwOS' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','1a74dd95e7244493a1b13b94fe9dd9e8')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10492',NULL,'MikroTik RB3011UiAS-RM SNMP','3','-1','2','','','MikroTik RB3011UiAS-RM SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik RB3011UiAS-RM.' || chr(13) || chr(10) || '1U rackmount, 10xGigabit Ethernet, SFP, USB 3.0, LCD, PoE out on port 10, 2x1.4GHz CPU, 1GB RAM, RouterOS L5' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','cc762a057f0f467ab571b6d76a9bb278')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10493',NULL,'MikroTik RB4011iGSRM SNMP','3','-1','2','','','MikroTik RB4011iGS+RM SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik RB4011iGS+RM.' || chr(13) || chr(10) || 'Powerful 10xGigabit port router with a Quad-core 1.4Ghz CPU, 1GB RAM, SFP+ 10Gbps cage and desktop case with rack ears' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','780c4a9a657e42fc83f1ab9a535f5184')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10494',NULL,'MikroTik RB5009UGSIN SNMP','3','-1','2','','','MikroTik RB5009UG+S+IN SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik RB5009UG+S+IN.' || chr(13) || chr(10) || 'The ultimate heavy-duty home lab router with USB 3.0, 1G and 2.5G Ethernet and a 10G SFP+ cage. You can mount four of these new routers in a single 1U rackmount space! Unprecedented processing power in such a small form factor.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','7b6f7a12a6b449ca926e74c894eca354')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10495',NULL,'MikroTik hEX PoE lite SNMP','3','-1','2','','','MikroTik hEX PoE lite SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik hEX PoE lite.' || chr(13) || chr(10) || '5xEthernet with PoE output for four ports, USB, 650MHz CPU, 64MB RAM, RouterOS L4' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','a5ddacdd5ac64b82bf5183769cc03e8c')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10496',NULL,'MikroTik hEX PoE SNMP','3','-1','2','','','MikroTik hEX PoE SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik hEX PoE.' || chr(13) || chr(10) || '5x Gigabit Ethernet with PoE output for four ports, SFP, USB, 800MHz CPU, 128MB RAM, RouterOS L4' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','ff57532daf924030b364e3b75acb74c4')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10497',NULL,'MikroTik hEX S SNMP','3','-1','2','','','MikroTik hEX S SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik hEX S.' || chr(13) || chr(10) || '5x Gigabit Ethernet, SFP, Dual Core 880MHz CPU, 256MB RAM, USB, microSD, RouterOS L4, IPsec hardware encryption support and The Dude server package' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','7802db8c2f9c4a7eba7b381b8f3fa5c5')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10498',NULL,'MikroTik hEX lite SNMP','3','-1','2','','','MikroTik hEX lite SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik hEX lite.' || chr(13) || chr(10) || '5x Ethernet, Small plastic case, 850MHz CPU, 64MB RAM, Most affordable MPLS router, RouterOS L4' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','2785d83763c641a7a7937b516665d93a')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10499',NULL,'MikroTik hEX SNMP','3','-1','2','','','MikroTik hEX SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik hEX.' || chr(13) || chr(10) || '5x Gigabit Ethernet, Dual Core 880MHz CPU, 256MB RAM, USB, microSD, RouterOS L4' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','68c2034014f24115ae9e910962530472')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10500',NULL,'MikroTik netPower 15FR SNMP','3','-1','2','','','MikroTik netPower 15FR SNMP','0',NULL,'The template for monitoring Switch MikroTik netPower 15FR.' || chr(13) || chr(10) || 'An outdoor 18 port switch with 15 reverse PoE ports and SFP. Cut costs, not speed – choose GPEN over GPON!' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','f1928e12f9554599a9adb516f38b6bf6')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10501',NULL,'MikroTik netPower 16P SNMP','3','-1','2','','','MikroTik netPower 16P SNMP','0',NULL,'The template for monitoring Switch MikroTik netPower 16P.' || chr(13) || chr(10) || 'An outdoor 18 port switch with 16 Gigabit PoE-out ports and 2 SFP+. Power all your access points anywhere!' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','b126aaf4499d49d7b4fcee0329b7dea7')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10502',NULL,'MikroTik netPower Lite 7R SNMP','3','-1','2','','','MikroTik netPower Lite 7R SNMP','0',NULL,'The template for monitoring Switch MikroTik netPower Lite 7R.' || chr(13) || chr(10) || 'An outdoor reverse PoE switch with Gigabit Ethernet and 10G SFP+ ports.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'MIKROTIK-MIB' || chr(13) || chr(10) || 'IF-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','1782caa5bf724f66a23e7dbb96ef7ba2')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10503',NULL,'VMWare SD-WAN VeloCloud by HTTP','3','-1','2','','','VMWare SD-WAN VeloCloud by HTTP','0',NULL,'Template for monitoring VMWare SD-WAN VeloCloud https://www.vmware.com/products/sd-wan.html' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','e1ca624566424496bff9d90c261ab37b')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10504',NULL,'Kubernetes API server by HTTP','3','-1','2','','','Kubernetes API server by HTTP','0',NULL,'Get Kubernetes API server metrics by HTTP agent from Prometheus metrics endpoint.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Don''t forget change macros {$KUBE.API.SERVER.URL}, {$KUBE.API.TOKEN}.' || chr(13) || chr(10) || 'Some metrics may not be collected depending on your Kubernetes API server instance version and configuration.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.42','1','1','','','','','','1','0','0','85ce114c802e4e28a5f3597e07d07032')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10505',NULL,'Kubernetes Controller manager by HTTP','3','-1','2','','','Kubernetes Controller manager by HTTP','0',NULL,'Get Kubernetes Controller manager metrics by HTTP agent from Prometheus metrics endpoint.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Don''t forget change macros {$KUBE.API.SERVER.URL}.' || chr(13) || chr(10) || 'Some metrics may not be collected depending on your Kubernetes Controller manager instance version and configuration.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','2420a8a4fda74fbc81743aed69fafa3b')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10506',NULL,'Kubernetes Kubelet by HTTP','3','-1','2','','','Kubernetes Kubelet by HTTP','0',NULL,'Get Kubernetes kubelet metrics by HTTP agent from Prometheus metrics endpoint.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Don''t forget change macros {$KUBE.KUBELET.URL}, {$KUBE.API.TOKEN}.' || chr(13) || chr(10) || 'Some metrics may not be collected depending on your Kubernetes API server instance version and configuration.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','e785916967c14544b59c3644c3edda3a')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10507',NULL,'Kubernetes nodes by HTTP','3','-1','2','','','Kubernetes nodes by HTTP','0',NULL,'Get Kubernetes nodes metrics by HTTP.' || chr(13) || chr(10) || 'Metrics are collected by requests to Kubernetes API.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Don''t forget to read the README.md for the correct setup of the template.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.42','1','1','','','','','','1','0','0','f397be2340734d24bc666102fbe184a5')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10508',NULL,'{#NAME}','0','-1','2','','','{#NAME}','2',NULL,'','1','1','','','','','','1','0','1','bfcbf26edd704bdfaa65e244a987839e')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10509',NULL,'Kubernetes Scheduler by HTTP','3','-1','2','','','Kubernetes Scheduler by HTTP','0',NULL,'Get Kubernetes Scheduler metrics by HTTP agent from Prometheus metrics endpoint.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Don''t forget change macros {$KUBE.API.SERVER.URL}.' || chr(13) || chr(10) || 'Some metrics may not be collected depending on your Kubernetes Scheduler instance version and configuration.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','ece96efdf0a045b99ede7978fa9366d6')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10510',NULL,'Kubernetes cluster state by HTTP','3','-1','2','','','Kubernetes cluster state by HTTP','0',NULL,'Get Kubernetes state metrics by HTTP.' || chr(13) || chr(10) || 'Metrics are collected by requests to Kubernetes API.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Don''t forget to read the README.md for the correct setup of the template.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.42','1','1','','','','','','1','0','0','07695028a2ba4b66a5414797bec791df')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10511',NULL,'API {#NAME}','0','-1','2','','','API {#NAME}','2',NULL,'','1','1','','','','','','1','0','1','a67ac5100e6d499088e4c81856f947fc')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10512',NULL,'Controller manager {#NAME}','0','-1','2','','','Controller manager {#NAME}','2',NULL,'','1','1','','','','','','1','0','1','9d529f3924fc4831a62fb1eec79b64d7')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10513',NULL,'Scheduler {#NAME}','0','-1','2','','','Scheduler {#NAME}','2',NULL,'','1','1','','','','','','1','0','1','46da4b85c58f4c59825e61778a64a58e')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10514',NULL,'Kubelet {#NAME}','0','-1','2','','','Kubelet {#NAME}','2',NULL,'','1','1','','','','','','1','0','1','c1c4807f378a47dfa59e9bbc8e43f5e2')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10515',NULL,'PFSense SNMP','3','-1','2','','','PFSense SNMP','0',NULL,'Template for monitoring pfSense by SNMP' || chr(13) || chr(10) || 'Setup:' || chr(13) || chr(10) || '  1. Enable SNMP daemon at Services in pfSense web interface https://docs.netgate.com/pfsense/en/latest/services/snmp.html' || chr(13) || chr(10) || '  2. Setup firewall rule to get access from Zabbix proxy or Zabbix server by SNMP https://docs.netgate.com/pfsense/en/latest/firewall/index.html#managing-firewall-rules' || chr(13) || chr(10) || '  3. Link template to the host' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'BEGEMOT-PF-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','16f281aeb8904d3db8b66dda94611fcc')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10516',NULL,'OpenWeatherMap by HTTP','3','-1','2','','','OpenWeatherMap by HTTP','0',NULL,'Get weather metrics from OpenWeatherMap current weather API by HTTP.' || chr(13) || chr(10) || 'It works without any external scripts and uses the Script item.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Setup:' || chr(13) || chr(10) || '  1. Create a host.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  2. Link the template to the host.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '  3. Customize the values of {$OPENWEATHERMAP.API.TOKEN} and {$LOCATION} macros.  ' || chr(13) || chr(10) || '      OpenWeatherMap API Tokens are available in your OpenWeatherMap account https://home.openweathermap.org/api_keys.  ' || chr(13) || chr(10) || '      Locations can be set by few ways:' || chr(13) || chr(10) || '        - by geo coordinates (for example: 56.95,24.0833)' || chr(13) || chr(10) || '        - by location name (for example: Riga)' || chr(13) || chr(10) || '        - by location ID. Link to the list of city ID: http://bulk.openweathermap.org/sample/city.list.json.gz' || chr(13) || chr(10) || '        - by zip/post code with a country code (for example: 94040,us)' || chr(13) || chr(10) || '      A few locations can be added to the macro at the same time by "|" delimiter. ' || chr(13) || chr(10) || '      For example: 43.81821,7.76115|Riga|2643743|94040,us.' || chr(13) || chr(10) || '      Please note that API requests by city name, zip-codes and city id will be deprecated soon.' || chr(13) || chr(10) || '      ' || chr(13) || chr(10) || '      Language and units macros can be customized too if necessary.' || chr(13) || chr(10) || '      List of available languages: https://openweathermap.org/current#multi.' || chr(13) || chr(10) || '      Available units of measurement are: standard, metric and imperial https://openweathermap.org/current#data.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','8098b3c157ab456abd55d3840eef79c1')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10517',NULL,'Proxmox VE by HTTP','3','-1','2','','','Proxmox VE by HTTP','0',NULL,'Template tooling version used: 0.41','1','1','','','','','','1','0','0','4958b76448d74ff1b6d7d6280449beee')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10518',NULL,'TrueNAS SNMP','3','-1','2','','','TrueNAS SNMP','0',NULL,'Template for monitoring TrueNAS by SNMP' || chr(13) || chr(10) || 'Setup:' || chr(13) || chr(10) || '  1. Import template into Zabbix' || chr(13) || chr(10) || '  2. Enable SNMP daemon at Services in TrueNAS web interface https://www.truenas.com/docs/core/services/snmp' || chr(13) || chr(10) || '  3. Link template to the host' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || 'SNMPv2-MIB' || chr(13) || chr(10) || 'UCD-DISKIO-MIB' || chr(13) || chr(10) || 'UCD-SNMP-MIB' || chr(13) || chr(10) || 'FREENAS-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','28e31ef9402d4c1ba2fbc730a288d2d8')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10519',NULL,'HashiCorp Consul Node by HTTP','3','-1','2','','','HashiCorp Consul Node by HTTP','0',NULL,'Get HashiCorp Consul Node metrics by HTTP agent from metrics endpoint.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Don''t forget to change macros {$CONSUL.NODE.API.URL}, {$CONSUL.TOKEN}.' || chr(13) || chr(10) || 'Some metrics may not be collected depending on your HashiCorp Consul instance version and configuration.' || chr(13) || chr(10) || 'More information about metrics you can find in official documentation: https://www.consul.io/docs/agent/telemetry' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.42','1','1','','','','','','1','0','0','884bdbeea93c4be0a11a2c92a5f8adce')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10520',NULL,'HashiCorp Consul Cluster by HTTP','3','-1','2','','','HashiCorp Consul Cluster by HTTP','0',NULL,'Get HashiCorp Consul Cluster services and nodes by HTTP agent from API endpoints.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Don''t forget to change macros {$CONSUL.CLUSTER.URL}, {$CONSUL.TOKEN}.' || chr(13) || chr(10) || 'Some metrics may not be collected depending on your HashiCorp Consul instance version and configuration.' || chr(13) || chr(10) || 'More information about metrics you can find in official documentation: https://www.consul.io/docs/agent/telemetry' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.42','1','1','','','','','','1','0','0','3db29bb6b2b14fa289ba7915264efcdf')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10521',NULL,'Consul {#NODE_NAME}','0','-1','2','','','Consul {#NODE_NAME}','2',NULL,'','1','1','','','','','','1','0','1','20efdd208e1548a7877a970e1600e5ba')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10522',NULL,'Envoy Proxy by HTTP','3','-1','2','','','Envoy Proxy by HTTP','0',NULL,'Get Envoy Proxy metrics by HTTP agent from metrics endpoint.' || chr(13) || chr(10) || 'https://www.envoyproxy.io/docs/envoy/v1.20.0/operations/stats_overview' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Don''t forget to change macros {$ENVOY.URL}, {$ENVOY.METRICS.PATH}.' || chr(13) || chr(10) || 'Some metrics may not be collected depending on your Envoy Proxy instance version and configuration.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','0368ca599bbb49729587b9c43ac83084')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10523',NULL,'CockroachDB by HTTP','3','-1','2','','','CockroachDB by HTTP','0',NULL,'Get CockroachDB metrics from Prometheus and health endpoints by HTTP agent.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Internal node metrics are collected from Prometheus /_status/vars endpoint.' || chr(13) || chr(10) || 'Node health metrics are collected from /health and /health?ready=1 endpoints.' || chr(13) || chr(10) || 'Template doesn''t require usage of session token.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Don''t forget change macros {$COCKROACHDB.API.SCHEME} according to your situation (secure/insecure node).' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','36116d8675da47b8a678193969d5a787')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10524',NULL,'HPE MSA 2040 Storage by HTTP','3','-1','2','','','HPE MSA 2040 Storage by HTTP','0',NULL,'The template to monitor HPE MSA 2040 by HTTP.' || chr(13) || chr(10) || 'It works without any external scripts and uses the script item.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Setup:' || chr(13) || chr(10) || '1. Create user "zabbix" with monitor role on the storage.' || chr(13) || chr(10) || '2. Link the template to a host.' || chr(13) || chr(10) || '3. Configure {$HPE.MSA.API.PASSWORD} and an interface with address through which API is accessible.' || chr(13) || chr(10) || '4. Change {$HPE.MSA.API.SCHEME} and {$HPE.MSA.API.PORT} macros if needed.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','be10b1140fce4cc08247260b71bcd037')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10525',NULL,'HPE MSA 2060 Storage by HTTP','3','-1','2','','','HPE MSA 2060 Storage by HTTP','0',NULL,'The template to monitor HPE MSA 2060 by HTTP.' || chr(13) || chr(10) || 'It works without any external scripts and uses the script item.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Setup:' || chr(13) || chr(10) || '1. Create user "zabbix" with monitor role on the storage.' || chr(13) || chr(10) || '2. Link the template to a host.' || chr(13) || chr(10) || '3. Configure {$HPE.MSA.API.PASSWORD} and an interface with address through which API is accessible.' || chr(13) || chr(10) || '4. Change {$HPE.MSA.API.SCHEME} and {$HPE.MSA.API.PORT} macros if needed.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','10537641cfa3416ab0f1451cdb61d804')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10526',NULL,'HPE Primera by HTTP','3','-1','2','','','HPE Primera by HTTP','0',NULL,'The template to monitor HPE Primera by HTTP.' || chr(13) || chr(10) || 'It works without any external scripts and uses the script item.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Setup:' || chr(13) || chr(10) || '  1. Create user zabbix on the storage with browse role and enable it for all domains.' || chr(13) || chr(10) || '  2. The WSAPI server does not start automatically.' || chr(13) || chr(10) || '     - Log in to the CLI as Super, Service, or any role granted the wsapi_set right.' || chr(13) || chr(10) || '     - Start the WSAPI server by command: `startwsapi`.' || chr(13) || chr(10) || '     - To check WSAPI state use command: `showwsapi`.' || chr(13) || chr(10) || '  3. Link template to the host.' || chr(13) || chr(10) || '  4. Configure macros {$HPE.PRIMERA.USERNAME} and {$HPE.PRIMERA.PASSWORD}.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','b8750c02b5624c6889979b129735bd56')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10527',NULL,'HPE Synergy by HTTP','3','-1','2','','','HPE Synergy by HTTP','0',NULL,'The template to monitor HPE Synergy by HTTP.' || chr(13) || chr(10) || 'It works without any external scripts and uses the script item.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Setup:' || chr(13) || chr(10) || '  1. Link template to the host.' || chr(13) || chr(10) || '  2. Configure macros {$HPE.SYNERGY.API.USERNAME} and {$HPE.SYNERGY.API.PASSWORD}.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','0ffde4421f524bcbac2f47fec87c0f95')
/

INSERT INTO hosts (hostid,proxy_hostid,host,status,ipmi_authtype,ipmi_privilege,ipmi_username,ipmi_password,name,flags,templateid,description,tls_connect,tls_accept,tls_issuer,tls_subject,tls_psk_identity,tls_psk,proxy_address,auto_compress,discover,custom_interfaces,uuid)
values ('10528',NULL,'OPNsense SNMP','3','-1','2','','','OPNsense SNMP','0',NULL,'Template for monitoring OPNsense by SNMP' || chr(13) || chr(10) || 'Setup:' || chr(13) || chr(10) || '  1. Enable bsnmpd daemon by creating new config file "/etc/rc.conf.d/bsnmpd" with the following content:' || chr(13) || chr(10) || '  bsnmpd_enable="YES"' || chr(13) || chr(10) || '  2. Uncomment the following lines in "/etc/snmpd.config" file to enable required SNMP modules:' || chr(13) || chr(10) || '  begemotSnmpdModulePath."hostres" = "/usr/lib/snmp_hostres.so"' || chr(13) || chr(10) || '  begemotSnmpdModulePath."pf"     = "/usr/lib/snmp_pf.so"' || chr(13) || chr(10) || '  3. Start bsnmpd daemon with the following command:' || chr(13) || chr(10) || '  /etc/rc.d/bsnmpd start' || chr(13) || chr(10) || '  4. Setup a firewall rule to get access from Zabbix proxy or Zabbix server by SNMP (https://docs.opnsense.org/manual/firewall.html).' || chr(13) || chr(10) || '  5. Link the template to a host.' || chr(13) || chr(10) || '' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'MIBs used:' || chr(13) || chr(10) || 'BEGEMOT-PF-MIB' || chr(13) || chr(10) || 'HOST-RESOURCES-MIB' || chr(13) || chr(10) || '' || chr(13) || chr(10) || 'Template tooling version used: 0.41','1','1','','','','','','1','0','0','0c94915edb4c41bf8c627dddb4f68f5a')
/

INSERT INTO group_prototype (group_prototypeid,hostid,name,groupid,templateid)
values ('1','10333','{#CLUSTER.NAME}',NULL,NULL)
/

INSERT INTO group_prototype (group_prototypeid,hostid,name,groupid,templateid)
values ('2','10333','{#DATACENTER.NAME}',NULL,NULL)
/

INSERT INTO group_prototype (group_prototypeid,hostid,name,groupid,templateid)
values ('4','10334','{#CLUSTER.NAME} (vm)',NULL,NULL)
/

INSERT INTO group_prototype (group_prototypeid,hostid,name,groupid,templateid)
values ('6','10334','{#HV.NAME}',NULL,NULL)
/

INSERT INTO group_prototype (group_prototypeid,hostid,name,groupid,templateid)
values ('16','10367','{#CLUSTER.NAME}',NULL,NULL)
/

INSERT INTO group_prototype (group_prototypeid,hostid,name,groupid,templateid)
values ('17','10367','{#DATACENTER.NAME}',NULL,NULL)
/

INSERT INTO group_prototype (group_prototypeid,hostid,name,groupid,templateid)
values ('19','10368','{#CLUSTER.NAME} (vm)',NULL,NULL)
/

INSERT INTO group_prototype (group_prototypeid,hostid,name,groupid,templateid)
values ('21','10368','{#HV.NAME}',NULL,NULL)
/

INSERT INTO group_prototype (group_prototypeid,hostid,name,groupid,templateid)
values ('35','10388','MongoDB sharded cluster/{#REPLICASET}',NULL,NULL)
/

INSERT INTO group_prototype (group_prototypeid,hostid,name,groupid,templateid)
values ('37','10389','MongoDB sharded cluster/{#ID}',NULL,NULL)
/

INSERT INTO group_prototype (group_prototypeid,hostid,name,groupid,templateid)
values ('54','10334','{#DATACENTER.NAME}/{#VM.FOLDER} (vm)',NULL,NULL)
/

INSERT INTO group_prototype (group_prototypeid,hostid,name,groupid,templateid)
values ('57','10368','{#DATACENTER.NAME}/{#VM.FOLDER} (vm)',NULL,NULL)
/

INSERT INTO group_prototype (group_prototypeid,hostid,name,groupid,templateid)
values ('136','10508','','12',NULL)
/

INSERT INTO group_prototype (group_prototypeid,hostid,name,groupid,templateid)
values ('137','10511','','12',NULL)
/

INSERT INTO group_prototype (group_prototypeid,hostid,name,groupid,templateid)
values ('138','10512','','12',NULL)
/

INSERT INTO group_prototype (group_prototypeid,hostid,name,groupid,templateid)
values ('139','10513','','12',NULL)
/

INSERT INTO group_prototype (group_prototypeid,hostid,name,groupid,templateid)
values ('140','10514','','12',NULL)
/

INSERT INTO group_prototype (group_prototypeid,hostid,name,groupid,templateid)
values ('141','10333','','12',NULL)
/

INSERT INTO group_prototype (group_prototypeid,hostid,name,groupid,templateid)
values ('142','10334','','12',NULL)
/

INSERT INTO group_prototype (group_prototypeid,hostid,name,groupid,templateid)
values ('143','10367','','12',NULL)
/

INSERT INTO group_prototype (group_prototypeid,hostid,name,groupid,templateid)
values ('144','10368','','12',NULL)
/

INSERT INTO group_prototype (group_prototypeid,hostid,name,groupid,templateid)
values ('145','10388','','13',NULL)
/

INSERT INTO group_prototype (group_prototypeid,hostid,name,groupid,templateid)
values ('146','10389','','13',NULL)
/

INSERT INTO group_prototype (group_prototypeid,hostid,name,groupid,templateid)
values ('151','10521','','12',NULL)
/

INSERT INTO group_prototype (group_prototypeid,hostid,name,groupid,templateid)
values ('152','10521','Consul cluster/{#NODE_DATACENTER}',NULL,NULL)
/

INSERT INTO group_prototype (group_prototypeid,hostid,name,groupid,templateid)
values ('153','10508','{#CLUSTER_HOSTNAME}: Kubernetes/Nodes/Role: {#ROLES}',NULL,NULL)
/

INSERT INTO group_prototype (group_prototypeid,hostid,name,groupid,templateid)
values ('154','10511','{#CLUSTER_HOSTNAME}: Kubernetes/Components: {#COMPONENT.API}',NULL,NULL)
/

INSERT INTO group_prototype (group_prototypeid,hostid,name,groupid,templateid)
values ('155','10512','{#CLUSTER_HOSTNAME}: Kubernetes/Components: {#COMPONENT.CONTROLLER}',NULL,NULL)
/

INSERT INTO group_prototype (group_prototypeid,hostid,name,groupid,templateid)
values ('156','10514','{#CLUSTER_HOSTNAME}: Kubernetes/Components: {#COMPONENT}',NULL,NULL)
/

INSERT INTO group_prototype (group_prototypeid,hostid,name,groupid,templateid)
values ('157','10513','{#CLUSTER_HOSTNAME}: Kubernetes/Components: {#COMPONENT.SCHEDULER}',NULL,NULL)
/

INSERT INTO interface (interfaceid,hostid,main,type,useip,ip,dns,port)
values ('1','10084','1','1','1','127.0.0.1','','10050')
/

INSERT INTO interface (interfaceid,hostid,main,type,useip,ip,dns,port)
values ('2','10333','1','1','1','{#HV.IP}','','10050')
/

INSERT INTO interface (interfaceid,hostid,main,type,useip,ip,dns,port)
values ('3','10334','1','1','1','{#VM.IP}','','10050')
/

INSERT INTO interface (interfaceid,hostid,main,type,useip,ip,dns,port)
values ('4','10367','1','1','1','{#HV.IP}','','10050')
/

INSERT INTO interface (interfaceid,hostid,main,type,useip,ip,dns,port)
values ('5','10368','1','1','1','{#VM.IP}','','10050')
/

INSERT INTO interface (interfaceid,hostid,main,type,useip,ip,dns,port)
values ('6','10508','1','1','1','{#IP}','','10050')
/

INSERT INTO interface (interfaceid,hostid,main,type,useip,ip,dns,port)
values ('7','10511','1','1','1','{#IP}','','10050')
/

INSERT INTO interface (interfaceid,hostid,main,type,useip,ip,dns,port)
values ('8','10512','1','1','1','{#IP}','','10050')
/

INSERT INTO interface (interfaceid,hostid,main,type,useip,ip,dns,port)
values ('9','10513','1','1','1','{#IP}','','10050')
/

INSERT INTO interface (interfaceid,hostid,main,type,useip,ip,dns,port)
values ('10','10514','1','1','1','{#IP}','','10050')
/

INSERT INTO interface (interfaceid,hostid,main,type,useip,ip,dns,port)
values ('11','10521','1','1','1','{#NODE_ADDRESS}','','10050')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('1','10093','Service state','c363fc0046f4493eb7ba6379c41d3e58')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('2','10094','Service state','2ad1e9aeb097470ba36a09c56c67eadd')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('3','10095','Service state','3fea65dd433444ac86936134d0a28fd2')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('4','10096','Service state','17353d47bd0a4a03a8f3ab799207e157')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('5','10097','Service state','ddbdab3aa88f4ad0b331a65504cceca5')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('6','10098','Service state','e0acc1611fcf43e38d6d1de761c48409')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('7','10099','Service state','1fb344806bc84930a4c45b84fd375cc8')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('8','10100','Service state','603906e741e94b349db9e5116aa2c81b')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('9','10101','Service state','41d22d9ad511457ba57ff86c11453f0b')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('10','10102','Service state','80377235a65c4d119745137e4658ef67')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('11','10103','Service state','1d4d40a040d84b0eae345be144dee1b7')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('12','10186','Service state','bdb5d65d925542eaa61c302dc40fbfe8')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('13','10264','Service state','452297e814a84b08a72730a7b777e378')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('14','10265','Service state','a5d1f911fb264bd4bc087ea582626d7f')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('15','10266','Service state','53c8528c18814f30a45d1540ab9e5c00')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('16','10267','Service state','5c0883d194e8494498474106c22be2ca')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('17','10301','Service state','c369d410303349b4973431b6ff8dcb85')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('18','10303','Service state','aaf7d0b8b306412b8a3272343708518f')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('19','10308','Service state','4980ec41c6644ecb9d5b52027a381fd8')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('20','10309','Service state','a8a0c20f1d404a79900064ac5d11a8b2')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('21','10310','Service state','ae3eec95cd1c440ba6c67ed5d7b7b915')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('22','10316','Service state','4f2d7ca3c89246c6b691557447230031')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('23','10317','Service state','622c38d0af2a4b6ea7a640a5d1a22b93')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('24','10318','Service state','8effc3f81db14540996e2373dde6eca9')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('25','10319','Service state','acd57d4f29a34286a801ce49cd6553fe')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('26','10320','Service state','f2e8233fcf0a4dd2b53a82ca48436a88')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('27','10322','Service state','15d416d869894fdb959ca2cda2c5e37c')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('28','10323','Service state','94147888c7ad4f5bae864eb2698f0237')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('29','10324','Service state','1735a8d251b24c3fbab32e766064536b')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('30','10325','Service state','5f3f78a3470c48b69442d942f21d11d0')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('31','10326','Service state','41be60c561114627b861677603b92acb')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('32','10327','Service state','03cde96b90a641598db572a662dc2064')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('33','10328','Service state','45ad479873b84113a98fa21b21081c65')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('34','10330','Service state','1caa1e7c41e14c7492ab8112f93ea068')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('35','10331','Service state','8e8fa515c14c4ac181db791c2c68c518')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('36','10335','Service state','31c489581d8b4246942c663b88fbaf9f')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('37','10336','Service state','d6e38832f2d44ec0bf6761e36fd7668f')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('38','10353','Service state','22fe6d6c74454775994f07fc05d7bafd')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('39','10355','Service state','1bd791d250e441aeb1c73e499d96e98e')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('40','10357','Service state','372bc939f3924aafa13c4821b83a9276')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('41','10363','Service state','6c967c4df18d4c7ebb0fd4be17df292a')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('42','10365','Service state','547a6b8002d44a8f8f363023c6097b1e')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('43','10175','Service state','25d04e2838af4fcca9ddd21df6781497')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('44','10378','Service state','a84db909cb1841c688acc6b4b1b28af4')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('45','10314','Windows service state','5d9a045df1df48daaa6752bd75f1681d')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('46','10325','Windows service state','d65f1af3c1e24a338983c52c5aa07d27')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('47','10326','Windows service state','6dc834d8e50842d3a7337b0f88540b61')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('48','10350','Windows service state','af7bd46d70ed4058afa4961d130dc0b2')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('49','10050','Zabbix agent ping status','e5a39fd666b04b70b6eea53e2373b564')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('50','10292','Zabbix agent ping status','9bf3eef7e8d8402ca6f826b377ea2db6')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('51','10174','VMware VirtualMachinePowerState','78f08f5c5c0047b999a2e8daa96cf8b7')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('52','10173','VMware status','3c59c22905054d42ac4ee8b72fe5f270')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('53','10175','VMware status','2b324fd8d7624874a3a81449b62c2cd6')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('54','10366','VMware status','5e5e3b01ef334bd39441568ebd0c31c0')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('55','10047','Value cache operating mode','97bbea700550483bbd8405b4dd9d8005')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('56','10261','Value cache operating mode','5dff563dde3c45d8b6d92525111384c6')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('57','10251','ENTITY-SENSORS-MIB::EntitySensorStatus','d42214398aea4362b4fc61a090f188e1')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('58','10254','ENTITY-SENSORS-MIB::EntitySensorStatus','318f3041aea04848a223de86e589c232')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('59','10183','EtherLike-MIB::dot3StatsDuplexStatus','6c35799bc36d413b94c0ac110224f208')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('60','10188','IF-MIB::ifOperStatus','4578589110ec40e19297e1d35d17c82f')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('61','10190','IF-MIB::ifOperStatus','692e46f1836c4e2682a0dc882fec89a0')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('62','10192','IF-MIB::ifOperStatus','4b84f531e2df454a8824070608bfbf49')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('63','10276','ifOperStatus','8513cf23b8d34952b92a31bbd82a31d3')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('64','10285','ifOperStatus','4827063819f14d539f509552c84f5f94')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('65','10342','ifOperStatus','9bc9524635a349409e244ad5215c80c1')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('66','10188','IF-MIB::ifType','4e22cbad0d9146059d9fbf89714e6460')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('67','10190','IF-MIB::ifType','7a288ac5cdbf429b9d568b12b312ad70')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('68','10192','IF-MIB::ifType','41952f292f004232b94f4d201e6bf727')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('69','10204','zabbix.host.available','ced60845a741400390ba002e69e26b0f')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('70','10050','zabbix.host.available','0d5e922550954e6bad89b22f1d9d0c65')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('71','10207','TIMETRA-CHASSIS-MIB::TmnxDeviceState','95a194271a584008a81564fd80189c5a')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('72','10208','SW-MIB::swSensorStatus','73618556ee4b4e8f9ec9acf0893e13ea')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('73','10208','SW-MIB::swOperStatus','54427fdf694547c598e3662df09a980a')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('74','10210','FOUNDRY-SN-AGENT-MIB::snChasPwrSupplyOperStatus','fe1c4f9f35a34b6189110fc95e21b086')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('75','10211','FOUNDRY-SN-AGENT-MIB::snChasPwrSupplyOperStatus','7b767e61825544bb857347f303a1f077')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('76','10210','FOUNDRY-SN-AGENT-MIB::snChasFanOperStatus','d457efd8cee74f168bd88f4fb2376142')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('77','10211','FOUNDRY-SN-AGENT-MIB::snChasFanOperStatus','41fadae69fa64af4a21c853fc00f23c0')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('78','10217','CISCO-ENVMON-MIB::CiscoEnvMonState','96da9a43fa60420696714c57d3e72f13')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('79','10221','F10-S-SERIES-CHASSIS-MIB::chSysFanTrayOperStatus','b389c759db0448ffbe28d4572fbfb3e9')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('80','10221','F10-S-SERIES-CHASSIS-MIB::chSysPowerSupplyOperStatus','2532df482bd348ba8202c3eb2b76340b')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('81','10222','MY-SYSTEM-MIB::mySystemFanIsNormal','5889e276245d411bacd130427ae4a5d4')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('82','10223','EQUIPMENT-MIB::swFanStatus','e7ab460cf1bf4fca8afc22566257fc3a')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('83','10223','EQUIPMENT-MIB::swPowerStatus','a46e6b21933f4aa7be17f9f11b1356ee')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('84','10224','EXTREME-SYSTEM-MIB::extremeFanOperational','b71a1b2d06324275a37a1952f13e29b3')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('85','10224','EXTREME-SYSTEM-MIB::extremeOverTemperatureAlarm','34c686dbaf8649b3b7dcc243068a739a')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('86','10224','EXTREME-SYSTEM-MIB::extremePowerSupplyStatus','85bfdbc16637406fb5f1a23a15f16c77')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('87','10227','HH3C-ENTITY-EXT-MIB::hh3cEntityExtErrorStatus','d7832aa00dd743bb8451cabff4e90e60')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('88','10250','HP-ICF-CHASSIS::hpicfSensorStatus','3c0731bf0669419fa8ebfdf9f7ec14de')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('89','10229','HUAWEI-ENTITY-EXTENT-MIB::hwEntityFanState','5d3f20a830b34f668c5f3ece41a039cd')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('90','10230','ICS-CHASSIS-MIB::icsChassisFanOperStatus','39299506ad14445fa7b7a9e78cc54619')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('91','10230','ICS-CHASSIS-MIB::icsChassisSensorSlotOperStatus','4c80241c4d5d4b949577e9741710a32b')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('92','10230','ICS-CHASSIS-MIB::icsChassisPowerSupplyOperStatus','535cb21845474749994bf7c395e39312')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('93','10231','JUNIPER-ALARM-MIB::jnxRedAlarmState','3aaa451c55cd4e72ab84b65dd8310564')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('94','10231','JUNIPER-ALARM-MIB::jnxOperatingState','64128e7f2adf44988b0ca3edd76cba61')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('95','10251','ENTITY-STATE-MIB::EntityOperState','bd1dc90aa54849d0a5ae9bdf368d03a9')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('96','10254','ENTITY-STATE-MIB::EntityOperState','15ba17df88eb435d9d48145fba8d9029')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('97','10234','FASTPATH-BOXSERVICES-PRIVATE-MIB::boxServicesPowSupplyItemState','d11e2b2f01c641728d1b7f764fa49f37')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('98','10234','FASTPATH-BOXSERVICES-PRIVATE-MIB::boxServicesFanItemState','3046d246b1064c749c1c9144442c0fac')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('99','10234','FASTPATH-BOXSERVICES-PRIVATE-MIB::boxServicesTempSensorState','4da55a4de7284012890e1fd5458f039a')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('100','10235','QTECH-MIB::sysFanStatus','fe2ada3a06844e138b3c4fed1a8c8d2d')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('101','10235','QTECH-MIB::sysPowerStatus','439cee4220954720aa34725fdc6c365e')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('102','10256','CPQSINFO-MIB::status','8374297ea234491b980591a8daa88e1f')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('103','10256','CPQHLTH-MIB::cpqHeTemperatureLocale','f1e590a8cc744e22b900595851833357')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('104','10256','CPQIDA-MIB::cpqDaCntlrModel','140a21785b764c95a3f78c8c05ed0844')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('105','10256','CPQIDA-MIB::cpqDaPhyDrvStatus','68bc7370fb8a43ee9957240e29636562')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('106','10258','IMM-MIB::systemHealthStat','61bded84be1d419083d8bd8a8bd25152')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('107','10255','IDRAC-MIB-SMIv2::ObjectStatusEnum','f90ca4bbf10f41deb68b458b795f6bb2')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('108','10255','IDRAC-MIB-SMIv2::StatusProbeEnum','ba7ff497325e4488af87afcc58e0cd42')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('109','10255','IDRAC-MIB-SMIv2::physicalDiskComponentStatus','3277b276bbb241699ac6011387e90126')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('110','10255','IDRAC-MIB-SMIv2::BooleanType','7648c14caa6e4dd4b0d2bc28e594090c')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('111','10255','IDRAC-MIB-SMIv2::physicalDiskMediaType','3d57a8ee9167490cabf6429d9cd14b4a')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('112','10255','IDRAC-MIB-SMIv2::batteryState','3459ea1c2ec94b3b8e39b8b7f76def81')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('113','10255','IDRAC-MIB-SMIv2::virtualDiskLayout','65e49bfeafcd4a7287ac779cf405d4eb')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('114','10255','IDRAC-MIB-SMIv2::virtualDiskOperationalState','6b8270d891b54aef8d7889ddce498ff2')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('115','10255','IDRAC-MIB-SMIv2::virtualDiskWritePolicy','12019ceefc2e4ab896ea8106efac48b8')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('116','10255','IDRAC-MIB-SMIv2::virtualDiskState','9da59b80065d4c46a270a544e00f18d7')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('117','10256','CPQIDA-MIB::cpqDaPhyDrvSmartStatus','54b288da67e1431c9d401cf47a518bcc')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('118','10256','CPQIDA-MIB::cpqDaAccelStatus','20d96ea63e994ba49244b94a4c24aec3')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('119','10256','CPQIDA-MIB::cpqDaAccelBattery','7502d61cf7644a2d9cff7462f53569ee')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('120','10256','CPQIDA-MIB::cpqDaPhyDrvMediaType','8351a024aa4d42d1915b44abe8acc4aa')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('121','10256','CPQIDA-MIB::cpqDaLogDrvFaultTol','442c9095de9f4aa5bcca659292b2c12b')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('122','10256','CPQIDA-MIB::cpqDaLogDrvStatus','8db38b47aba64739ae9f078f43b42888')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('123','10329','PostgreSQL recovery role','9f38c01c325248d4b538c0582432b541')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('124','10357','PostgreSQL recovery role','2e376ee568d04e7bbe98cbae4181f313')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('125','10329','PostgreSQL replication status','0fba38eefa4c4073b46d3f8579fda314')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('126','10357','PostgreSQL replication status','7f553f18ef6544ceaa4b50c4ebf0e583')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('127','10276','Linux::Interface protocol types','e2db25377a2b49c897bbb8b6c30831e2')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('128','10285','Linux::Interface protocol types','4d912f1ee95942038f306ddefb3a57b3')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('129','10342','Linux::Interface protocol types','8f709b791d1342a48615632e86969c92')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('130','10291','Win32_NetworkAdapter::AdapterTypeId','dd37c51d4ded48ceb449fa633dd707e2')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('131','10348','Win32_NetworkAdapter::AdapterTypeId','7300d3f66dec4f90bcd6889d206db89f')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('132','10291','Win32_NetworkAdapter::NetConnectionStatus','3265d77e34ba44f688b7aaceeeccda6b')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('133','10348','Win32_NetworkAdapter::NetConnectionStatus','a1e647b6b26547bfbc044d213150c71b')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('134','10301','RabbitMQ healthcheck','08ee896f31a1457a8e9b4f6f251700d4')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('135','10303','RabbitMQ healthcheck','55188bbb2ede4300a6292b373ee36ab7')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('136','10301','Alarm state','ce579def20ac488dbce1ff69baaa8c50')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('137','10303','Alarm state','e65c3d3e8ea443a281b37c51ca461c26')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('138','10304','CISCO-UNIFIED-COMPUTING-TC-MIB::CucsEquipmentOperability','e1686896f31e483f9add962dbbd90afb')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('139','10304','CISCO-UNIFIED-COMPUTING-TC-MIB::CucsLsOperState','398aa5bf5eb44a8c8dd96babd98f1bd3')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('140','10304','CISCO-UNIFIED-COMPUTING-TC-MIB::CucsStoragePDriveStatus','9b7c7078039c4e348ab417da71b96f5c')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('141','10304','CISCO-UNIFIED-COMPUTING-TC-MIB::CucsStorageLunType','7d3e38476c894ae59ecac6640b24f833')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('142','10304','CISCO-UNIFIED-COMPUTING-TC-MIB::CucsEquipmentPresence','5055674c42a241e3a2156de1dc1715bf')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('143','10310','Redis bgwrite status','098c2240a8e947fc9f6f0a677ffcbc0e')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('144','10310','Redis flag','3b6cd97c65d14e10bdabf5c42d767ad9')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('145','10310','Redis repl offset','47c80efdf46745f1959eee76f68014e7')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('146','10310','Redis bgsave time','82f4dc4ef0c9471d82dbe3605f4f31d0')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('147','10318','Docker flag','c289195aa4dc47ab883fa95c9cb6fd07')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('148','10322','ES cluster state','d651bdf75d0849d5ab2b0802fab76e22')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('149','10323','Replicas state','4d926c30529447b3816cec3f1440b47a')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('150','10324','Etcd healthcheck','f25e21a70baa4e009bdbcb44acb1a22e')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('151','10324','Etcd leader','7bcaf8a520e24613a96d49e63a91a55b')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('152','10325','Application pool state','63d1ad6b4cf643da870b14c53da6c52f')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('153','10326','Application pool state','636c6915a8154b6ea1ea5b00f015c149')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('154','10327','MSSQL DB state','bac1a10dad134d50add5bc9550e2ebf3')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('155','10327','MSSQL AG Connected state','bfbb00eb85d747dabeda2954a5d659b7')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('156','10327','MSSQL AG Join state','47413c135c094cdc8b59f18a9b195a78')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('157','10327','MSSQL AG Operational state','a570f341d9a8470797aecfebd376b2b8')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('158','10327','MSSQL AG Recovery health','4ec6a96ff6c64756b2f27e47972fd9f6')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('159','10327','MSSQL AG Role','596556fba6064efb8155233371eb2950')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('160','10327','MSSQL AG Synchronization health','2ab0923b3ce14ffc9dd454114f6b15be')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('161','10327','MSSQL - Yes / No','c66ee50a8b3f4b6788b732bb8a6b514e')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('162','10327','MSSQL Mirroring State','f1c105c262c5476798a93eaa4c46fbda')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('163','10327','MSSQL Mirroring Role','09aaa82ccd6a444b80d5d3bb182fbafd')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('164','10327','MSSQL Safety level','e70421b2c3db4ce1937791bdb432040e')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('165','10327','MSSQL Witness state','aa9de6e21d08486db04f29e10d11a94c')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('166','10328','Oracle DB open status','d0912db18fe54941b9345ebf869fd1a6')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('167','10335','Oracle DB open status','015a0c94ba2644c6aa343d3f792a4072')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('168','10328','Oracle DB role','df05d594141f42ebb294cf6adca5fd6b')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('169','10335','Oracle DB role','afade10cda4e453982355342ba9d8d9f')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('170','10328','Oracle instance status','41e105c52bf045899c3c4a1cb4e16865')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('171','10335','Oracle instance status','4893318c780f47719e12e839c9a846c2')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('172','10328','Oracle instance role','97b689d7ddc04bcd9b9f92af6ba783bd')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('173','10335','Oracle instance role','53d97b73db8449959420e03114d345c3')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('174','10328','Oracle archiver state','3afaab75342c4be186fb4f595ed62a31')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('175','10335','Oracle archiver state','f39e64058fef423bb858ba45834a3455')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('176','10328','Oracle tablespace status','c6633e4ef9a84fa7b843529479a06158')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('177','10335','Oracle tablespace status','f14ed94cf12740a19e221ddaa4855c54')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('178','10328','Oracle Archivelog status','79af6c068ba141ba9806f4341edd9266')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('179','10335','Oracle Archivelog status','5a90da8dd6124159a7f82a7a996f0a53')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('180','10328','Oracle force log status','f00ca5c45ab84df788820af2642e4784')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('181','10335','Oracle force log status','1d9f4a44f2f94a799768f147cb712331')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('182','10328','Oracle log mode','809554f521d645ea8e8850c3b1f41579')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('183','10335','Oracle log mode','910dd4a87f75434289fa2e345778d18d')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('184','10353','Ceph cluster status','2a4b2a8c55ba48b2a815e4123c9ea7fa')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('185','10360','Exchange database copy role','4a0e19e58ade4e8c878a6b87f4021416')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('186','10361','Exchange database copy role','0797c152a163407aa9490a63f80a8fd1')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('187','10360','Exchange database state','2d131c4a033c4145a6bd66ec4c0c030a')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('188','10361','Exchange database state','a4fac47b56e4470c9c6d435d7eb06845')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('189','10362','GitLab healthcheck','3b40391bb8b6472e9c3fd8e1f001fe04')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('190','10364','Kafka controller state','cf2440fb69c24371b231cb0a69002333')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('191','10365','Vault flag','46edbd58c7384b53bb31775244c23343')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('192','10371','ProStar MPPT charge state','1703c3aeb1b24641821e1c6d2cb4c8b7')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('193','10371','ProStar MPPT load state','b5403a0805a54b9294f69a1e11a438b1')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('194','10372','ProStar PWM charge state','f94eb6ad54c44281878c7c018c6209d1')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('195','10372','ProStar PWM load state','f0be8765c74e4c4788d4ff99a6c5ccd4')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('196','10373','SunSaver MPPT charge state','b51b9440e801481fbb76f28b4a5431d1')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('197','10373','SunSaver MPPT load state','f21076ed51104b84ba4d78dd74bd1a5b')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('198','10374','SureSine load state','1d6f60ea7d414cb8a26ddad70fc352b2')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('199','10375','TriStar MPPT 600V charge state','8a0dfdf98d254c219905751cccc878d7')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('200','10376','TriStar MPPT charge state','3c6c60ef422c4788bf0c5b74ffab7ef0')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('201','10377','TriStar PWM charge state','4985c4742d5844e7bc0aee5aeeacc436')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('202','10377','TriStar PWM control mode','252c3fb63cc34bb1a36ae6e9cbe5880c')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('203','10377','TriStar PWM load state','735e1a0d990a4c449e59eeb402f3b40e')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('204','10378','FAS3220 HA cannot takeover cause','e078162b11ff49f59c3ab6d905f88f2c')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('205','10378','FAS3220 HA settings','d6993f0258dd4978a85aa5c141f1706e')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('206','10378','FAS3220 NVRAM battery status','1fe2bf70bd63468584708a9d09eb42a1')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('207','10378','FAS3220 Port health','ee5e67c90bca4ded84df2d82589bc2fb')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('208','10378','FAS3220 Port link state','bd6ea858292c414d9bfd435631001ef5')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('209','10378','FAS3220 Port role','c598c387157d4450b5bf8f68e6e794a4')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('210','10378','FAS3220 Port speed','6b0fec10a0eb4c70a8982419c6e635b9')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('211','10378','FAS3220 Port UP by administrator','c50cdd6dbe19482abdb870c12e7c7b8d')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('212','10379','Computer online','d1b719ea85464279bd473fcdb34008da')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('213','10379','Computer state','5313fc2399b24216945ed6416a00d55d')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('214','10379','Jenkins healthcheck','a51dacf033d1423a886ca9dbfdf9b175')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('215','10379','Service state','b45a6b0148074212bf45d6bb311565c2')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('216','10380','Login status','4c14241141504a9d852d83965c309f31')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('217','10256','CPQHLTH-MIB::cpqHeTemperatureCondition','1a03c5602a4a49f8839d820c666434fc')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('218','10382','HTTP response status code','70add725d6a84f6f9ed0917107dfffc9')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('219','10385','Huawei storage: Controller role','b5c6d9d67da54531a918c93a9c98cec8')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('220','10385','Huawei storage: Health status','b7f399070ee0419cac1722f80268ff1a')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('221','10385','Huawei storage: LUN status','e361f6b8fe92430f86d0e3dc70118ba9')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('222','10385','Huawei storage: Running status','ae5093d843784258aa32437cde486574')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('223','10300','RabbitMQ healthcheck','78275d6daacf42b4b97e3d806dfe81fe')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('224','10302','RabbitMQ healthcheck','3380e05a15774dad92e77c983448698b')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('225','10386','MongoDB flag','9f921e1503e74204b8f128966f9562bc')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('226','10386','ReplicaSet node state','a99141555eff42ff8d367f10d9a7c569')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('227','10386','Service state','b37ba44823e34a13a119f86f3d58a65a')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('228','10387','MongoDB flag','2014769595e34d4bb18dbcf4d9eaf112')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('229','10387','Service state','3cedce4712fa4a3eba63ccd7a790ecf6')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('230','10390','CISCO-ENVMON-MIB::CiscoEnvMonState','673c7626d11b4867aba08e96b0fbd149')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('231','10390','EtherLike-MIB::dot3StatsDuplexStatus','4c04fea7546044d9a9c64762a9e1ebdd')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('232','10390','IF-MIB::ifOperStatus','346b197cb4fe42cb9b304ce246e5924f')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('233','10390','IF-MIB::ifType','94e4f1da1ff24b96bdccf04ec663a1ae')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('234','10390','Service state','3a72216b3fea4ad482d0e3655e407747')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('235','10390','zabbix.host.available','868c28a7406c4ab3b48b783a6e7590ba')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('236','10391','CISCO-ENVMON-MIB::CiscoEnvMonState','cbeb53fa3c2a4b16b7f7ee92265efd8c')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('237','10391','EtherLike-MIB::dot3StatsDuplexStatus','5ef472cb5f424ef9a7393156204613ba')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('238','10391','IF-MIB::ifOperStatus','73b7c034142043b689792e1e71dd5872')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('239','10391','IF-MIB::ifType','635461b9ca404cc1b92c1fab0c6327f6')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('240','10391','Service state','142fe822cc424a76899551b6f29799d9')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('241','10391','zabbix.host.available','939c7551b81e40e9b053e624211d0901')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('242','10392','CISCO-ENVMON-MIB::CiscoEnvMonState','fea34445b6cd4847b420d212f9b0201e')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('243','10392','EtherLike-MIB::dot3StatsDuplexStatus','867b0e42f8a24a278ee15476aeadfa0b')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('244','10392','IF-MIB::ifOperStatus','3534f9f22afe4f98a712a86ce755f491')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('245','10392','IF-MIB::ifType','88b99531b08248e8be1fc0a3210acee1')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('246','10392','Service state','653ce2314e6f499b84250048df1314f8')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('247','10392','zabbix.host.available','690c4c1545894d049ac8e26e3de7ec9c')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('248','10393','CISCO-ENVMON-MIB::CiscoEnvMonState','e47b3ba8fb9c4ecf82701ddf571d55b6')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('249','10393','EtherLike-MIB::dot3StatsDuplexStatus','412b00b4bfbc48b4906370635c12dcee')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('250','10393','IF-MIB::ifOperStatus','358db91b44e645df92072f0a1449de2e')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('251','10393','IF-MIB::ifType','877039dc6b0a467783828f3421887b83')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('252','10393','Service state','1d4c62bd989748a0b7947b6455405d96')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('253','10393','zabbix.host.available','ff706c036eac4ef88570e41629e65514')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('254','10394','CISCO-ENVMON-MIB::CiscoEnvMonState','52875f5c6b1b4bb3987c3baa03860d4d')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('255','10394','EtherLike-MIB::dot3StatsDuplexStatus','8decf4d7d8744711b5f2ea68b5e73d14')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('256','10394','IF-MIB::ifOperStatus','e8815fad611e47389c987c88a029cece')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('257','10394','IF-MIB::ifType','93f29c48ad8b4bc7afe036817d946b18')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('258','10394','Service state','ee7cb62782d44458abc9f7cca816dca8')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('259','10394','zabbix.host.available','6273854a740e41718cd1354f227cf4db')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('260','10251','IF-MIB::ifOperStatus','04fa3aad27e044a094dce939b3d361ec')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('261','10251','IF-MIB::ifType','afe0ce28ed5d49dd822cc7013356c599')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('262','10251','Service state','deb16b99706645929e300b0590f013f3')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('263','10251','zabbix.host.available','a85fe23199cd4d779655f690a706d7c7')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('264','10395','PowerNet-MIB::uioSensorStatusAlarmStatus','a808aadebf964e0cb6b8724bf1165013')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('265','10395','PowerNet-MIB::upsAdvBatteryReplaceIndicator','731b036e41d147ba81bfcfb7e99b561b')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('266','10395','PowerNet-MIB::upsAdvInputLineFailCause','f310a0bceb06404d9daee67ab578e4b8')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('267','10395','PowerNet-MIB::upsBasicBatteryStatus','795c75c652124ad282bad3dfd50b8e39')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('268','10395','Service state','cbd3d7c999244cd6a44a8fc566533005')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('269','10395','zabbix.host.available','781c568d935d40f2a43951488cf2e046')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('270','10327','MSSQL Job Run Status','eefa6e0e6f8b4facbc12004437b7ee8f')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('271','10397','Service state','bce54cbdf2b8487985f9c7847a4c4918')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('272','10398','Service state','047f0303f1bc424a959f5d0ceaab77c7')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('273','10400','PowerNet-MIB::uioSensorStatusAlarmStatus','30a78904cbc94fc58609dc1a11aa48ef')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('274','10400','PowerNet-MIB::upsAdvBatteryReplaceIndicator','ace379c23ae247f3b92ccffb9eef920c')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('275','10400','PowerNet-MIB::upsAdvInputLineFailCause','19686fc030ee4c6bb69aacd3b9c735ca')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('276','10400','PowerNet-MIB::upsBasicBatteryStatus','80593b554d0a431aa89a0c4960f8565c')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('277','10400','PowerNet-MIB::upsBasicOutputStatus','f41b7d5469e64557ab0cdb81526aeac0')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('278','10400','zabbix.host.available','edd7578bf71146dd88770a39eec537e0')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('279','10401','PowerNet-MIB::uioSensorStatusAlarmStatus','6940a4d08173433bb4bc8ff3b44e578c')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('280','10401','PowerNet-MIB::upsAdvBatteryReplaceIndicator','add26e1622ed4d1fbdb4a9bdbf7facb8')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('281','10401','PowerNet-MIB::upsAdvInputLineFailCause','2597173167e34be0943fb6c81f2597e5')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('282','10401','PowerNet-MIB::upsBasicBatteryStatus','7d2a66214d4b4b96890aa9e1c9bcf050')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('283','10401','PowerNet-MIB::upsBasicOutputStatus','351383a7383a4472a31c09009cf9d1f5')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('284','10401','zabbix.host.available','3aadc179423b4298b2e8a6e4850466a5')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('285','10402','PowerNet-MIB::uioSensorStatusAlarmStatus','55fecbd639c44c328b4199569a7305ef')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('286','10402','PowerNet-MIB::upsAdvBatteryReplaceIndicator','1ce6860b108948bda40d514fd4e3ed69')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('287','10402','PowerNet-MIB::upsAdvInputLineFailCause','db1fa20d76c8416c83fa0b7fda536fa8')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('288','10402','PowerNet-MIB::upsBasicBatteryStatus','50b6ae187875406ea8ba1669add70899')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('289','10402','PowerNet-MIB::upsBasicOutputStatus','9c5fd52c36f6451ea3f502a871e821d7')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('290','10402','zabbix.host.available','89597d423b454a42aa80fa8f7a20f273')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('291','10403','PowerNet-MIB::uioSensorStatusAlarmStatus','7cf932d3b9304f2cb151134e9ea3be82')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('292','10403','PowerNet-MIB::upsAdvBatteryReplaceIndicator','63c5f0e1601947e5a02abd25a07a9af4')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('293','10403','PowerNet-MIB::upsAdvInputLineFailCause','70d097ce846c45aeb3c8be031c427511')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('294','10403','PowerNet-MIB::upsBasicBatteryStatus','3424a9229a134b47b8544d611be082fb')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('295','10403','PowerNet-MIB::upsBasicOutputStatus','05a60d9c47274f5a8f6c92efe8158b8e')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('296','10403','zabbix.host.available','d4ee88b3cf5d4d95b27be2e7b2f20e3c')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('297','10404','PowerNet-MIB::uioSensorStatusAlarmStatus','b2af1e2dcb874d43949c383f9b347f36')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('298','10404','PowerNet-MIB::upsAdvBatteryReplaceIndicator','b06b54b07e6840e5a0c52ba7a6acf86a')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('299','10404','PowerNet-MIB::upsAdvInputLineFailCause','a62f96735c47467da94b6bcf98cc013d')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('300','10404','PowerNet-MIB::upsBasicBatteryStatus','ed12e8780c384caba8035fbb1c78e115')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('301','10404','PowerNet-MIB::upsBasicOutputStatus','ae2ed0c2c99a4ad496f7a35226e3d4f0')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('302','10404','zabbix.host.available','8cddc4f99ecb4866b1638b82b145ea8b')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('309','10406','PowerNet-MIB::uioSensorStatusAlarmStatus','864d59cbfcc8431cb334b812bf7ef3a3')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('310','10406','PowerNet-MIB::upsAdvBatteryReplaceIndicator','cc42cb7a7fb4417fa1c143e214958c1d')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('311','10406','PowerNet-MIB::upsAdvInputLineFailCause','a3bbd0be8c7c4dc1aa9accb9f22292c9')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('312','10406','PowerNet-MIB::upsBasicBatteryStatus','f801d4fb07c644e4be1f01e99ba48aa7')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('313','10406','PowerNet-MIB::upsBasicOutputStatus','28964e9cf2b849fbb2f8d998cecdacda')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('314','10406','zabbix.host.available','12058346f9e046388767c2939bbed2cf')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('315','10395','PowerNet-MIB::upsBasicOutputStatus','c536d9dc64724643a9291c9b601b1eac')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('316','10407','PowerNet-MIB::uioSensorStatusAlarmStatus','aec3362485c242ec928cb8ecfe5e61cf')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('317','10407','PowerNet-MIB::upsAdvBatteryReplaceIndicator','912d8834176b4fe4a2f6bd12ef3ee3c1')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('318','10407','PowerNet-MIB::upsAdvInputLineFailCause','e079fa8cc9614245b0fecf4b8f42feca')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('319','10407','PowerNet-MIB::upsBasicBatteryStatus','24229472978c42739cdbe7aa47e1d34c')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('320','10407','PowerNet-MIB::upsBasicOutputStatus','8c2c9721615c4408976f7632180ecfe3')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('321','10407','zabbix.host.available','625f28bd49f14e49a1a7a4da01429906')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('322','10408','PowerNet-MIB::uioSensorStatusAlarmStatus','8516e97893ed4f2ebe70766d17eeacde')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('323','10408','PowerNet-MIB::upsAdvBatteryReplaceIndicator','84387eb0a5ef4523ac5d990eb4a6a796')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('324','10408','PowerNet-MIB::upsAdvInputLineFailCause','58104ecf15d34fe38922f3fe5fa25027')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('325','10408','PowerNet-MIB::upsBasicBatteryStatus','43715c15fed840fc8e188d062c0ef2da')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('326','10408','PowerNet-MIB::upsBasicOutputStatus','d9b5340729684dd0a450b6de6b14b590')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('327','10408','zabbix.host.available','cdf3578a66db4cfda6c36b4bbb295173')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('328','10409','PowerNet-MIB::uioSensorStatusAlarmStatus','e2877a188bd24918992f8c7878550924')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('329','10409','PowerNet-MIB::upsAdvBatteryReplaceIndicator','33d83523ceee4f3e916c885ebb33e8b9')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('330','10409','PowerNet-MIB::upsAdvInputLineFailCause','c50ef9a9476d47e6935a6026bbb24d06')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('331','10409','PowerNet-MIB::upsBasicBatteryStatus','96a985d8351f48be86c5b00472b48feb')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('332','10409','PowerNet-MIB::upsBasicOutputStatus','160f7a39770d492c93403097650c1568')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('333','10409','zabbix.host.available','cc7a368057bc47eeb834dc9363183c59')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('334','10410','WildFly flag','e23e06cfd0ce4e069b9d996f101f6ee6')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('335','10411','WildFly flag','4004b5f2501f44a69dc86afce3daa4d1')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('336','10412','PowerNet-MIB::uioSensorStatusAlarmStatus','41e166e2a5f948488238198920ab4b17')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('337','10412','PowerNet-MIB::upsAdvBatteryReplaceIndicator','224af0a6a5db48ef9c8861bc61873ea9')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('338','10412','PowerNet-MIB::upsAdvInputLineFailCause','ded19296204545b9ab463d4fc65f3cfd')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('339','10412','PowerNet-MIB::upsBasicBatteryStatus','271d8f0594cf451a8aaa98c84850ebf7')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('340','10412','PowerNet-MIB::upsBasicOutputStatus','171d4d5bf01442e391b04f9e448df5a0')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('341','10412','zabbix.host.available','8b4f199f5e704cbea67182d4abf9b8de')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('342','10308','Server mode','bf2e9463450d4f4899abcac85cde0a92')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('343','10309','Server mode','450c1b2c6d58432b8a5b34dd3b5e8870')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('344','10416','Unit Active State','fe20979701834a80a823c514d11c19e7')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('345','10416','Unit File State','e0a5e55e5a074a26935386c5e29a0e36')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('346','10416','Unit Load State','0309ef57e92a4ea2ae4404a685f0e7b8')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('347','10418','Cisco ASAv algorithm validate packets','764f7c162b8a45d9b41e795cf2f5f8da')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('348','10418','Cisco ASAv encryption algorithm','f38e3c5200c941aa831857698eb3ea8b')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('349','10418','Cisco ASAv port admin status','8395b87d3ff3496aabafdfd1d2e1c4be')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('350','10418','Cisco ASAv port operational status','e97c331986454b68917c771c3bba9a3d')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('351','10418','Cisco ASAv session protocol','22e5704487924e4ebca70e2062d40da4')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('352','10418','Cisco ASAv user authenticate method','8dd72ccb744e4bd989ea739e21da7820')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('353','10418','Physical class','3c3b7c75af4b4fedb12e30fb74406a23')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('354','10418','SNMP available','91e8696b05654efca8f03b700ea74b0b')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('355','10419','Chassis status','849febb31f524e9296afc5ec6ffb2fe3')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('356','10419','Module provision level','ed7e1317987b433e9aa7168db3824c94')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('357','10419','Pause state','6e590fa7db7441d5a4b145204ee254bb')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('358','10419','SNMP available','b615a47192fc48f4b2cedb205c33f7d0')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('359','10420','SNMP available','2b7c7c3eecb743e8a30ab3adc74ffd06')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('360','10420','ZYXEL AAM1212-51 / IES-612 port admin status','db7f61bebcac452c8081b2c58d1013d8')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('361','10420','ZYXEL AAM1212-51 / IES-612 port operational status','6c2a29dac43340399990340fe26a7a72')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('362','10421','SNMP available','494c8983c4cf453789d2f0bbbe5cbbf3')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('363','10421','ZYXEL ES3500-8PD operational mode port link up type','7cfe02e1eb224f6abe5216aaec31402c')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('364','10421','ZYXEL ES3500-8PD operational mode port speed duplex','b568c9f69a1a4dd5951f1121523475c9')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('365','10421','ZYXEL ES3500-8PD port admin status','4a20dd55c16b4c9082f267c532a4507a')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('366','10421','ZYXEL ES3500-8PD port operational status','17635045a1ee4b8bba21b7d44634c57f')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('367','10421','ZYXEL ES3500-8PD SFP status','875833a6ca71431da2b3747c4c1e3008')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('368','10422','SNMP available','c6ba6086ed584ba0a4dd58ffe8564fbf')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('369','10422','ZYXEL GS-4012F operational mode port link up type','82cce670bef64a47b326bb8b1a2f6cd8')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('370','10422','ZYXEL GS-4012F operational mode port speed duplex','d7d38cadffc240f9a01434546659d036')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('371','10422','ZYXEL GS-4012F port admin status','7456d212b8f44f7da215fc86f39e3956')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('372','10422','ZYXEL GS-4012F port operational status','afa699db0bfc4cfbb48729932967230e')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('373','10423','SNMP available','10dd3d9951014a38bc3517df54381a66')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('374','10423','ZYXEL IES-500x module status','efd6a6086011465ca956b1664f7d6474')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('375','10423','ZYXEL IES-500x module type','892651d2b1e3431490f2c531a50e2732')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('376','10423','ZYXEL IES-500x port admin status','9174dafc199e438994256eff4dd87bdd')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('377','10423','ZYXEL IES-500x port operational status','f64c046f1eca45e09dad683603f4674b')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('378','10424','SNMP available','5247e9e5efcd4b29b864e336619eafcf')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('379','10424','ZYXEL IES-6000 module status','0236177f088340ff8ce5adb9361b8df8')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('380','10424','ZYXEL IES-6000 module type','7ad4e124b8184fb8abc454c70c67e309')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('381','10424','ZYXEL IES-6000 port admin status','b20f50ac559f45369de16c04f5ccf523')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('382','10424','ZYXEL IES-6000 port operational status','2f3b061e1d6f46a3b8216b2398fc2896')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('383','10425','SNMP available','34ea860866f24498927b73f4ce438837')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('384','10425','ZYXEL IES1248-51 port admin status','b933d3a98256457d906de8f7da377bac')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('385','10425','ZYXEL IES1248-51 port operational status','e780cc91765849a0ace3d2eb2e4824a0')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('386','10426','SNMP available','ac3d8b1e51074733a8bce57814528d83')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('387','10426','ZYXEL MES-3528 operational mode port link up type','042fc0ecdef34baab224062d4f746b96')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('388','10426','ZYXEL MES-3528 operational mode port speed duplex','cce63413576040fe8df5969886da993d')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('389','10426','ZYXEL MES-3528 port admin status','6220d70f35404dd6834674510e0ae9ea')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('390','10426','ZYXEL MES-3528 port operational status','36e992f6794a492e87c3c5a9749e26b3')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('391','10426','ZYXEL MES-3528 SFP status','da9692b414de47d5bac9cd3287492e0b')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('392','10427','SNMP available','7ad9362759b542d98a67796dd13fc5d4')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('393','10427','ZYXEL MES3500-10 operational mode port link up type','064efc8dae8e47ae9c14713c7b31a36c')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('394','10427','ZYXEL MES3500-10 operational mode port speed duplex','4ad7b4bf94494c93bdcbf36af095d5c3')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('395','10427','ZYXEL MES3500-10 port admin status','e6a8dc82d4ca4b989daafd66ef1ab2ce')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('396','10427','ZYXEL MES3500-10 port operational status','a96f6ed4d9e34a0cb79cee8bdbd672f5')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('397','10427','ZYXEL MES3500-10 SFP status','8e9755ff129740298ab5f5497c6c17a2')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('398','10428','SNMP available','dbb03955eb7043dda4dea1a9d7e8e043')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('399','10428','ZYXEL MES3500-24 operational mode port link up type','c0f699295af740e2aabbb06c6718e8f8')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('400','10428','ZYXEL MES3500-24 operational mode port speed duplex','f94441e46ffe4908a8a57089cbdaeaa7')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('401','10428','ZYXEL MES3500-24 port admin status','df2213aff9984b3f837f99944f3c9bc0')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('402','10428','ZYXEL MES3500-24 port operational status','679674c6b9364083a1eb1c9c9be136a2')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('403','10428','ZYXEL MES3500-24 SFP status','f12de6ba6b4c4556b276f9d5d509ffcf')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('404','10429','SNMP available','6e923e1e3ed34b8f87357b5fd7407c54')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('405','10429','ZYXEL MGS-3712 operational mode port link up type','7c5d7efbd17f48619a3f4211a269b38d')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('406','10429','ZYXEL MGS-3712 operational mode port speed duplex','da42da17340044ea83521107ac4dee04')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('407','10429','ZYXEL MGS-3712 port admin status','7e107b2d754945dbaf833955fcae7f48')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('408','10429','ZYXEL MGS-3712 port operational status','ed71a5038bf34198a3a56b0020ad728e')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('409','10429','ZYXEL MGS-3712 SFP status','b89570749c5d4dcb9378b7951803b8e4')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('410','10430','SNMP available','bf6cbe819fb94c85becf4364c47ef1c4')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('411','10430','ZYXEL MGS-3712F operational mode port link up type','2695f35dedcf41e1aade2037e931c57e')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('412','10430','ZYXEL MGS-3712F operational mode port speed duplex','c2b235ab2e6042568c096fdfb466f7dc')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('413','10430','ZYXEL MGS-3712F port admin status','d145d8ee5ad2423f906335d30bfef592')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('414','10430','ZYXEL MGS-3712F port operational status','655823ba854540c78a8078d4e7594bf9')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('415','10430','ZYXEL MGS-3712F SFP status','bf0d94784c404b209d4c75c8f582a5c6')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('416','10431','SNMP available','9e4265c1129d482fa12a09e657a7cda3')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('417','10431','ZYXEL MES3500-24S operational mode port link up type','615d399b1a6045359dfc262b364b4c55')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('418','10431','ZYXEL MES3500-24S operational mode port speed duplex','4217cd5f5c1f4b438cd4701c023da375')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('419','10431','ZYXEL MES3500-24S port admin status','7e705fdb791341b8a1c86ee7d85fbfea')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('420','10431','ZYXEL MES3500-24S port operational status','08e22f2eac034c9db9bba73040cea453')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('421','10431','ZYXEL MES3500-24S SFP status','161770392cdb4dcd92c3596b5ad6d06a')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('422','10432','SNMP available','5c5037a96f084a8182a5fb00f49ff285')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('423','10432','ZYXEL MGS3520-28x operational mode port link up type','2b38ddd0e1a34cfab7dd6af9ebf28aca')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('424','10432','ZYXEL MGS3520-28x operational mode port speed duplex','f23ebe496cfc4e659a09eff530b81a24')
/

INSERT INTO valuemap (valuemapid,hostid,name,uuid)
values ('425','10