
# Chassis by IPMI

## Overview

Template for monitoring servers with BMC over IPMI that work without any external scripts.
All metrics are collected at once, thanks to Zabbix's bulk data collection.
It collects metrics by polling BMC remotely using an IPMI agent.

###Known Issues

- Description: If the BMC has a sensor with an empty threshold value, we get the LLD error "Cannot create trigger...".


## Requirements

Zabbix version: 6.0 and higher.

## Tested versions

This template has been tested on:
- HP iLO, DELL DRAC, IBM RSA

## Configuration

> Zabbix should be configured according to the instructions in the [Templates out of the box](https://www.zabbix.com/documentation/6.0/manual/config/templates_out_of_the_box) section.

## Setup

You can set {$IPMI.USER} and {$IPMI.PASSWORD} macros in the template for using on the host level.


### Macros used

|Name|Description|Default|
|----|-----------|-------|
|{$IPMI.USER}|<p>This macro is used for access to BMC. It can be overridden on the host or linked template level.</p>||
|{$IPMI.PASSWORD}|<p>This macro is used for access to BMC. It can be overridden on the host or linked template level.</p>||
|{$IPMI.SENSOR_TYPE.MATCHES}|<p>This macro is used in sensors discovery. It can be overridden on the host or linked template level.</p>|`.*`|
|{$IPMI.SENSOR_TYPE.NOT_MATCHES}|<p>This macro is used in sensors discovery. It can be overridden on the host or linked template level.</p>|`invalid`|

### Items

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|IPMI: Get IPMI sensors|<p>The master item that receives all sensors with values for LLD and dependent elements from BMC.</p>|IPMI agent|ipmi.get|

### LLD rule Discrete sensors discovery

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Discrete sensors discovery|<p>Discovery of the discrete IPMI sensors.</p>|Dependent item|ipmi.discrete.discovery|

### Item prototypes for Discrete sensors discovery

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|IPMI: {#SENSOR_ID}|<p>It is a state of the discrete IPMI sensor.</p>|Dependent item|ipmi.state_text[{#SENSOR_ID}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.[?(@.id=='{#SENSOR_ID}')].state.text.first()`</p></li><li><p>Discard unchanged with heartbeat: `1d`</p></li></ul>|

### Trigger prototypes for Discrete sensors discovery

|Name|Description|Expression|Severity|Dependencies and additional info|
|----|-----------|----------|--------|--------------------------------|
|IPMI: {#SENSOR_ID} value has changed|<p>The trigger is informing about changes in a state of the discrete IPMI sensor. A problem generated by this trigger can be manually closed.</p>|`last(/Chassis by IPMI/ipmi.state_text[{#SENSOR_ID}],#1)<>last(/Chassis by IPMI/ipmi.state_text[{#SENSOR_ID}],#2)`|Info|**Manual close**: Yes|

### LLD rule Threshold sensors discovery

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|Threshold sensors discovery|<p>Discovery of the threshold IPMI sensors.</p>|Dependent item|ipmi.sensors.discovery|

### Item prototypes for Threshold sensors discovery

|Name|Description|Type|Key and additional info|
|----|-----------|----|-----------------------|
|IPMI: {#SENSOR_ID}, {#SENSOR_UNIT}|<p>It is a state of the threshold IPMI sensor.</p>|Dependent item|ipmi.value[{#SENSOR_ID}]<p>**Preprocessing**</p><ul><li><p>JSON Path: `$.[?(@.id=='{#SENSOR_ID}')].value.first()`</p></li><li><p>Discard unchanged with heartbeat: `1h`</p></li></ul>|

### Trigger prototypes for Threshold sensors discovery

|Name|Description|Expression|Severity|Dependencies and additional info|
|----|-----------|----------|--------|--------------------------------|
|IPMI: {#SENSOR_ID} value is below non-critical low|<p>The trigger is informing that a value less than the lower non-critical threshold has been reached.</p>|`min(/Chassis by IPMI/ipmi.value[{#SENSOR_ID}],5m)<{#SENSOR_LO_WARN}`|Warning|**Depends on**:<br><ul><li>IPMI: {#SENSOR_ID} value is below critical low</li><li>IPMI: {#SENSOR_ID} value is below non-recoverable low</li></ul>|
|IPMI: {#SENSOR_ID} value is below critical low|<p>The trigger is informing that a value less than the lower critical threshold has been reached.</p>|`min(/Chassis by IPMI/ipmi.value[{#SENSOR_ID}],5m)<{#SENSOR_LO_CRIT}`|High|**Depends on**:<br><ul><li>IPMI: {#SENSOR_ID} value is below non-recoverable low</li></ul>|
|IPMI: {#SENSOR_ID} value is below non-recoverable low|<p>The trigger is informing that a value less than the lower non-recoverable threshold has been reached.</p>|`min(/Chassis by IPMI/ipmi.value[{#SENSOR_ID}],5m)<{#SENSOR_LO_DISAST}`|Disaster||
|IPMI: {#SENSOR_ID} value is above non-critical high|<p>The trigger is informing that a value higher than the upper non-critical threshold has been reached.</p>|`min(/Chassis by IPMI/ipmi.value[{#SENSOR_ID}],5m)>{#SENSOR_HI_WARN}`|Warning|**Depends on**:<br><ul><li>IPMI: {#SENSOR_ID} value is above critical high</li><li>IPMI: {#SENSOR_ID} value is above non-recoverable high</li></ul>|
|IPMI: {#SENSOR_ID} value is above critical high|<p>The trigger is informing that a value higher than the upper critical threshold has been reached.</p>|`min(/Chassis by IPMI/ipmi.value[{#SENSOR_ID}],5m)>{#SENSOR_HI_CRIT}`|High|**Depends on**:<br><ul><li>IPMI: {#SENSOR_ID} value is above non-recoverable high</li></ul>|
|IPMI: {#SENSOR_ID} value is above non-recoverable high|<p>The trigger is informing that a value higher than the upper non-recoverable threshold has been reached.</p>|`min(/Chassis by IPMI/ipmi.value[{#SENSOR_ID}],5m)>{#SENSOR_HI_DISAST}`|Disaster||

## Feedback

Please report any issues with the template at [`https://support.zabbix.com`](https://support.zabbix.com)

You can also provide feedback, discuss the template, or ask for help at [`ZABBIX forums`](https://www.zabbix.com/forum/zabbix-suggestions-and-feedback)

