/*
** Zabbix
** Copyright (C) 2001-2013 Zabbix SIA
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/

#include "sysinfo.h"

int	SYSTEM_SW_ARCH(AGENT_REQUEST *request, AGENT_RESULT *result)
{
	typedef void (WINAPI *PGNSI)(LPSYSTEM_INFO);

	SYSTEM_INFO	si;
	char		*os = NULL;
	PGNSI		pGNSI;

	memset(&si, 0, sizeof(si));

	if (NULL != (pGNSI = (PGNSI)GetProcAddress(GetModuleHandle(TEXT("kernel32.dll")), "GetNativeSystemInfo")))
		pGNSI(&si);
	else
		GetSystemInfo(&si);

	switch (si.wProcessorArchitecture)
	{
		case PROCESSOR_ARCHITECTURE_INTEL:
			os = zbx_malloc(os, 4);
			zbx_strdup(os, "x86");
			break;
		case PROCESSOR_ARCHITECTURE_AMD64:
			os = zbx_malloc(os, 4);
			zbx_strdup(os, "x64");
			break;
		case PROCESSOR_ARCHITECTURE_IA64:
			os = zbx_malloc(os, 20);
			zbx_strdup(os, "Intel Itanium-based");
			break;
		default :
			return SYSINFO_RET_FAIL;
	}

	SET_STR_RESULT(result, os);

	return SYSINFO_RET_OK;
}
