/* 
** ZABBIX
** Copyright (C) 2000-2005 SIA Zabbix
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**/

#include "common.h"
#include "dbschema.h"

ZBX_TABLE	tables[]={
	{"slideshows",	"slideshowid",	ZBX_SYNC,
		{
		{"slideshowid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"name",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"delay",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"slides",	"slideid",	ZBX_SYNC,
		{
		{"slideid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"slideshowid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"screenid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"step",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"delay",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"drules",	"druleid",	ZBX_SYNC,
		{
		{"druleid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"proxy_hostid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"name",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"iprange",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{"delay",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{"nextcheck",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"status",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{0}
		}
	},
	{"dchecks",	"dcheckid",	ZBX_SYNC,
		{
		{"dcheckid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"druleid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{"type",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{"key_",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{"snmp_community",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{"ports",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{0}
		}
	},
	{"dhosts",	"dhostid",	ZBX_SYNC,
		{
		{"dhostid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"druleid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"ip",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"status",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"lastup",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"lastdown",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"dservices",	"dserviceid",	ZBX_SYNC,
		{
		{"dserviceid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"dhostid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"type",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"key_",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"value",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"port",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"status",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"lastup",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"lastdown",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"ids",	"nodeid,table_name,field_name",	0,
		{
		{"nodeid",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"table_name",	ZBX_TYPE_CHAR,	ZBX_NOTNULL},
		{"field_name",	ZBX_TYPE_CHAR,	ZBX_NOTNULL},
		{"nextid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{0}
		}
	},
	{"httptest",	"httptestid",	ZBX_SYNC,
		{
		{"httptestid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"name",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"applicationid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"lastcheck",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"nextcheck",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"curstate",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"curstep",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"lastfailedstep",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"delay",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"status",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"macros",	ZBX_TYPE_BLOB,	ZBX_NOTNULL | ZBX_SYNC},
		{"agent",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"time",	ZBX_TYPE_FLOAT,	ZBX_NOTNULL | ZBX_SYNC},
		{"error",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"httpstep",	"httpstepid",	ZBX_SYNC,
		{
		{"httpstepid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"httptestid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"name",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"no",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"url",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"timeout",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"posts",	ZBX_TYPE_BLOB,	ZBX_NOTNULL | ZBX_SYNC},
		{"required",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"status_codes",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"httpstepitem",	"httpstepitemid",	ZBX_SYNC,
		{
		{"httpstepitemid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"httpstepid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"itemid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"type",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"httptestitem",	"httptestitemid",	ZBX_SYNC,
		{
		{"httptestitemid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"httptestid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"itemid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"type",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"nodes",	"nodeid",	0,
		{
		{"nodeid",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"name",	ZBX_TYPE_CHAR,	ZBX_NOTNULL},
		{"timezone",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"ip",	ZBX_TYPE_CHAR,	ZBX_NOTNULL},
		{"port",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"slave_history",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"slave_trends",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"nodetype",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"masterid",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{0}
		}
	},
	{"node_cksum",	"",	0,
		{
		{"nodeid",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"tablename",	ZBX_TYPE_CHAR,	ZBX_NOTNULL},
		{"recordid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"cksumtype",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"cksum",	ZBX_TYPE_TEXT,	ZBX_NOTNULL},
		{"sync",	ZBX_TYPE_CHAR,	ZBX_NOTNULL},
		{0}
		}
	},
	{"services_times",	"timeid",	ZBX_SYNC,
		{
		{"timeid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"serviceid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"type",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"ts_from",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"ts_to",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"note",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"alerts",	"alertid",	ZBX_HISTORY,
		{
		{"alertid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"actionid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"eventid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"userid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"clock",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"mediatypeid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"sendto",	ZBX_TYPE_CHAR,	ZBX_NOTNULL},
		{"subject",	ZBX_TYPE_CHAR,	ZBX_NOTNULL},
		{"message",	ZBX_TYPE_BLOB,	ZBX_NOTNULL},
		{"status",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"retries",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"error",	ZBX_TYPE_CHAR,	ZBX_NOTNULL},
		{"nextcheck",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"esc_step",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"alerttype",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{0}
		}
	},
	{"history",	"",	0,
		{
		{"itemid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"clock",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"value",	ZBX_TYPE_FLOAT,	ZBX_NOTNULL},
		{0}
		}
	},
	{"history_sync",	"id",	ZBX_HISTORY_SYNC,
		{
		{"id",	ZBX_TYPE_UINT,	ZBX_NOTNULL},
		{"nodeid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"itemid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_HISTORY_SYNC},
		{"clock",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_HISTORY_SYNC},
		{"value",	ZBX_TYPE_FLOAT,	ZBX_NOTNULL | ZBX_HISTORY_SYNC},
		{0}
		}
	},
	{"history_uint",	"",	0,
		{
		{"itemid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"clock",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"value",	ZBX_TYPE_UINT,	ZBX_NOTNULL},
		{0}
		}
	},
	{"history_uint_sync",	"id",	ZBX_HISTORY_SYNC,
		{
		{"id",	ZBX_TYPE_UINT,	ZBX_NOTNULL},
		{"nodeid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"itemid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_HISTORY_SYNC},
		{"clock",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_HISTORY_SYNC},
		{"value",	ZBX_TYPE_UINT,	ZBX_NOTNULL | ZBX_HISTORY_SYNC},
		{0}
		}
	},
	{"history_str",	"",	0,
		{
		{"itemid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"clock",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"value",	ZBX_TYPE_CHAR,	ZBX_NOTNULL},
		{0}
		}
	},
	{"history_str_sync",	"id",	ZBX_HISTORY_SYNC,
		{
		{"id",	ZBX_TYPE_UINT,	ZBX_NOTNULL},
		{"nodeid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"itemid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_HISTORY_SYNC},
		{"clock",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_HISTORY_SYNC},
		{"value",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_HISTORY_SYNC},
		{0}
		}
	},
	{"history_log",	"id",	ZBX_HISTORY,
		{
		{"id",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"itemid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"clock",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"timestamp",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"source",	ZBX_TYPE_CHAR,	ZBX_NOTNULL},
		{"severity",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"value",	ZBX_TYPE_TEXT,	ZBX_NOTNULL},
		{0}
		}
	},
	{"history_text",	"id",	ZBX_HISTORY,
		{
		{"id",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"itemid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"clock",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"value",	ZBX_TYPE_TEXT,	ZBX_NOTNULL},
		{0}
		}
	},
	{"proxy_history",	"id",	0,
		{
		{"id",	ZBX_TYPE_UINT,	ZBX_NOTNULL},
		{"itemid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"clock",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"timestamp",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"source",	ZBX_TYPE_CHAR,	ZBX_NOTNULL},
		{"severity",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"value",	ZBX_TYPE_TEXT,	ZBX_NOTNULL},
		{0}
		}
	},
	{"proxy_dhistory",	"id",	0,
		{
		{"id",	ZBX_TYPE_UINT,	ZBX_NOTNULL},
		{"clock",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"druleid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"type",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"ip",	ZBX_TYPE_CHAR,	ZBX_NOTNULL},
		{"port",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"key_",	ZBX_TYPE_CHAR,	ZBX_NOTNULL},
		{"value",	ZBX_TYPE_CHAR,	ZBX_NOTNULL},
		{"status",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{0}
		}
	},
	{"events",	"eventid",	ZBX_HISTORY,
		{
		{"eventid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"source",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"object",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"objectid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"clock",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"value",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"acknowledged",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{0}
		}
	},
	{"trends",	"itemid,clock",	ZBX_HISTORY_TRENDS,
		{
		{"itemid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"clock",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"num",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"value_min",	ZBX_TYPE_FLOAT,	ZBX_NOTNULL},
		{"value_avg",	ZBX_TYPE_FLOAT,	ZBX_NOTNULL},
		{"value_max",	ZBX_TYPE_FLOAT,	ZBX_NOTNULL},
		{0}
		}
	},
	{"trends_uint",	"itemid,clock",	ZBX_HISTORY_TRENDS,
		{
		{"itemid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"clock",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"num",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"value_min",	ZBX_TYPE_UINT,	ZBX_NOTNULL},
		{"value_avg",	ZBX_TYPE_UINT,	ZBX_NOTNULL},
		{"value_max",	ZBX_TYPE_UINT,	ZBX_NOTNULL},
		{0}
		}
	},
	{"acknowledges",	"acknowledgeid",	ZBX_HISTORY,
		{
		{"acknowledgeid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"userid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"eventid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"clock",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"message",	ZBX_TYPE_CHAR,	ZBX_NOTNULL},
		{0}
		}
	},
	{"auditlog",	"auditid",	ZBX_HISTORY,
		{
		{"auditid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"userid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"clock",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"action",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"resourcetype",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"details",	ZBX_TYPE_CHAR,	ZBX_NOTNULL},
		{0}
		}
	},
	{"service_alarms",	"servicealarmid",	ZBX_HISTORY,
		{
		{"servicealarmid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"serviceid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"clock",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"value",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{0}
		}
	},
	{"actions",	"actionid",	ZBX_SYNC,
		{
		{"actionid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"name",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"eventsource",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"evaltype",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"status",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"esc_period",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"def_shortdata",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"def_longdata",	ZBX_TYPE_BLOB,	ZBX_NOTNULL | ZBX_SYNC},
		{"recovery_msg",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"r_shortdata",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"r_longdata",	ZBX_TYPE_BLOB,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"operations",	"operationid",	ZBX_SYNC,
		{
		{"operationid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"actionid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"operationtype",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"object",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"objectid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"shortdata",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"longdata",	ZBX_TYPE_BLOB,	ZBX_NOTNULL | ZBX_SYNC},
		{"esc_period",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"esc_step_from",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"esc_step_to",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"default_msg",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"evaltype",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"opconditions",	"opconditionid",	ZBX_SYNC,
		{
		{"opconditionid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"operationid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"conditiontype",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"operator",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"value",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"escalations",	"escalationid",	0,
		{
		{"escalationid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"actionid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"triggerid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"eventid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"r_eventid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"nextcheck",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"esc_step",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"status",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{0}
		}
	},
	{"applications",	"applicationid",	ZBX_SYNC,
		{
		{"applicationid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"hostid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"name",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"templateid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"conditions",	"conditionid",	ZBX_SYNC,
		{
		{"conditionid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"actionid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"conditiontype",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"operator",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"value",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"config",	"configid",	ZBX_SYNC,
		{
		{"configid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"alert_history",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"event_history",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"refresh_unsupported",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"work_period",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"alert_usrgrpid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"event_ack_enable",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"event_expire",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"event_show_max",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"default_theme",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"authentication_type",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"ldap_host",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"ldap_port",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"ldap_base_dn",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"ldap_bind_dn",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"ldap_bind_password",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"ldap_search_attribute",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"functions",	"functionid",	ZBX_SYNC,
		{
		{"functionid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"itemid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"triggerid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"lastvalue",	ZBX_TYPE_CHAR,	0},
		{"function",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"parameter",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"graphs",	"graphid",	ZBX_SYNC,
		{
		{"graphid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"name",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"width",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"height",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"yaxistype",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"yaxismin",	ZBX_TYPE_FLOAT,	ZBX_NOTNULL | ZBX_SYNC},
		{"yaxismax",	ZBX_TYPE_FLOAT,	ZBX_NOTNULL | ZBX_SYNC},
		{"templateid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"show_work_period",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"show_triggers",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"graphtype",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"show_legend",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"show_3d",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"percent_left",	ZBX_TYPE_FLOAT,	ZBX_NOTNULL | ZBX_SYNC},
		{"percent_right",	ZBX_TYPE_FLOAT,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"graphs_items",	"gitemid",	ZBX_SYNC,
		{
		{"gitemid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"graphid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"itemid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"drawtype",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"sortorder",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"color",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"yaxisside",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"calc_fnc",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"type",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"periods_cnt",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"groups",	"groupid",	ZBX_SYNC,
		{
		{"groupid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"name",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"help_items",	"itemtype,key_",	0,
		{
		{"itemtype",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"key_",	ZBX_TYPE_CHAR,	ZBX_NOTNULL},
		{"description",	ZBX_TYPE_CHAR,	ZBX_NOTNULL},
		{0}
		}
	},
	{"hosts",	"hostid",	ZBX_SYNC,
		{
		{"hostid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"proxy_hostid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"host",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{"dns",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{"useip",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{"ip",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{"port",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{"status",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{"disable_until",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"error",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"available",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"errors_from",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"lastaccess",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"inbytes",	ZBX_TYPE_UINT,	ZBX_NOTNULL | ZBX_SYNC},
		{"outbytes",	ZBX_TYPE_UINT,	ZBX_NOTNULL | ZBX_SYNC},
		{"useipmi",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{"ipmi_port",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{"ipmi_authtype",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{"ipmi_privilege",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{"ipmi_username",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{"ipmi_password",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{"ipmi_disable_until",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"ipmi_available",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"snmp_disable_until",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"snmp_available",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"hosts_groups",	"hostgroupid",	ZBX_SYNC,
		{
		{"hostgroupid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"hostid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"groupid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"hosts_profiles",	"hostid",	ZBX_SYNC,
		{
		{"hostid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"devicetype",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"name",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"os",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"serialno",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"tag",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"macaddress",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"hardware",	ZBX_TYPE_BLOB,	ZBX_NOTNULL | ZBX_SYNC},
		{"software",	ZBX_TYPE_BLOB,	ZBX_NOTNULL | ZBX_SYNC},
		{"contact",	ZBX_TYPE_BLOB,	ZBX_NOTNULL | ZBX_SYNC},
		{"location",	ZBX_TYPE_BLOB,	ZBX_NOTNULL | ZBX_SYNC},
		{"notes",	ZBX_TYPE_BLOB,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"hosts_profiles_ext",	"hostid",	ZBX_SYNC,
		{
		{"hostid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"device_alias",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"device_type",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"device_chassis",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"device_os",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"device_os_short",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"device_hw_arch",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"device_serial",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"device_model",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"device_tag",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"device_vendor",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"device_contract",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"device_who",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"device_status",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"device_app_01",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"device_app_02",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"device_app_03",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"device_app_04",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"device_app_05",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"device_url_1",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"device_url_2",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"device_url_3",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"device_networks",	ZBX_TYPE_BLOB,	ZBX_NOTNULL | ZBX_SYNC},
		{"device_notes",	ZBX_TYPE_BLOB,	ZBX_NOTNULL | ZBX_SYNC},
		{"device_hardware",	ZBX_TYPE_BLOB,	ZBX_NOTNULL | ZBX_SYNC},
		{"device_software",	ZBX_TYPE_BLOB,	ZBX_NOTNULL | ZBX_SYNC},
		{"ip_subnet_mask",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"ip_router",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"ip_macaddress",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"oob_ip",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"oob_subnet_mask",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"oob_router",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"date_hw_buy",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"date_hw_install",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"date_hw_expiry",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"date_hw_decomm",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"site_street_1",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"site_street_2",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"site_street_3",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"site_city",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"site_state",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"site_country",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"site_zip",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"site_rack",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"site_notes",	ZBX_TYPE_BLOB,	ZBX_NOTNULL | ZBX_SYNC},
		{"poc_1_name",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"poc_1_email",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"poc_1_phone_1",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"poc_1_phone_2",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"poc_1_cell",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"poc_1_screen",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"poc_1_notes",	ZBX_TYPE_BLOB,	ZBX_NOTNULL | ZBX_SYNC},
		{"poc_2_name",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"poc_2_email",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"poc_2_phone_1",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"poc_2_phone_2",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"poc_2_cell",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"poc_2_screen",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"poc_2_notes",	ZBX_TYPE_BLOB,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"hosts_templates",	"hosttemplateid",	ZBX_SYNC,
		{
		{"hosttemplateid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"hostid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"templateid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"housekeeper",	"housekeeperid",	0,
		{
		{"housekeeperid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"tablename",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"field",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"value",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"images",	"imageid",	ZBX_SYNC,
		{
		{"imageid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"imagetype",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"name",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"image",	ZBX_TYPE_BLOB,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"items",	"itemid",	ZBX_SYNC,
		{
		{"itemid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"type",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{"snmp_community",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{"snmp_oid",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{"snmp_port",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{"hostid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{"description",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"key_",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{"delay",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{"history",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"trends",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"nextcheck",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"lastvalue",	ZBX_TYPE_CHAR,	0},
		{"lastclock",	ZBX_TYPE_INT,	0},
		{"prevvalue",	ZBX_TYPE_CHAR,	0},
		{"status",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{"value_type",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{"trapper_hosts",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{"units",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{"multiplier",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{"delta",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{"prevorgvalue",	ZBX_TYPE_CHAR,	0},
		{"snmpv3_securityname",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{"snmpv3_securitylevel",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{"snmpv3_authpassphrase",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{"snmpv3_privpassphrase",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{"formula",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{"error",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"lastlogsize",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"logtimefmt",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{"templateid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{"valuemapid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{"delay_flex",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{"params",	ZBX_TYPE_TEXT,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{"ipmi_sensor",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC | ZBX_PROXY},
		{0}
		}
	},
	{"items_applications",	"itemappid",	ZBX_SYNC,
		{
		{"itemappid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"applicationid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"itemid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"mappings",	"mappingid",	ZBX_SYNC,
		{
		{"mappingid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"valuemapid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"value",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"newvalue",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"media",	"mediaid",	ZBX_SYNC,
		{
		{"mediaid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"userid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"mediatypeid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"sendto",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"active",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"severity",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"period",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"media_type",	"mediatypeid",	ZBX_SYNC,
		{
		{"mediatypeid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"type",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"description",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"smtp_server",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"smtp_helo",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"smtp_email",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"exec_path",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"gsm_modem",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"username",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"passwd",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"profiles",	"profileid",	ZBX_SYNC,
		{
		{"profileid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"userid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"idx",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"idx2",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"value_id",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"value_int",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"value_str",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"source",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"type",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"rights",	"rightid",	ZBX_SYNC,
		{
		{"rightid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"groupid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"permission",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"id",	ZBX_TYPE_ID,	ZBX_SYNC},
		{0}
		}
	},
	{"scripts",	"scriptid",	ZBX_SYNC,
		{
		{"scriptid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"name",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"command",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"host_access",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"usrgrpid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"groupid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"screens",	"screenid",	ZBX_SYNC,
		{
		{"screenid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"name",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"hsize",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"vsize",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"screens_items",	"screenitemid",	ZBX_SYNC,
		{
		{"screenitemid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"screenid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"resourcetype",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"resourceid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"width",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"height",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"x",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"y",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"colspan",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"rowspan",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"elements",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"valign",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"halign",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"style",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"url",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"dynamic",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"services",	"serviceid",	ZBX_SYNC,
		{
		{"serviceid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"name",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"status",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"algorithm",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"triggerid",	ZBX_TYPE_ID,	ZBX_SYNC},
		{"showsla",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"goodsla",	ZBX_TYPE_FLOAT,	ZBX_NOTNULL | ZBX_SYNC},
		{"sortorder",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"services_links",	"linkid",	ZBX_SYNC,
		{
		{"linkid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"serviceupid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"servicedownid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"soft",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"sessions",	"sessionid",	0,
		{
		{"sessionid",	ZBX_TYPE_CHAR,	ZBX_NOTNULL},
		{"userid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"lastaccess",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{"status",	ZBX_TYPE_INT,	ZBX_NOTNULL},
		{0}
		}
	},
	{"sysmaps_links",	"linkid",	ZBX_SYNC,
		{
		{"linkid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"sysmapid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"selementid1",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"selementid2",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"drawtype",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"color",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"sysmaps_link_triggers",	"linktriggerid",	ZBX_SYNC,
		{
		{"linktriggerid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"linkid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"triggerid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"drawtype",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"color",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"sysmaps_elements",	"selementid",	ZBX_SYNC,
		{
		{"selementid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"sysmapid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"elementid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"elementtype",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"iconid_off",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"iconid_on",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"iconid_unknown",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"label",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"label_location",	ZBX_TYPE_INT,	ZBX_SYNC},
		{"x",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"y",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"url",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"iconid_disabled",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"sysmaps",	"sysmapid",	ZBX_SYNC,
		{
		{"sysmapid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"name",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"width",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"height",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"backgroundid",	ZBX_TYPE_UINT,	ZBX_NOTNULL | ZBX_SYNC},
		{"label_type",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"label_location",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"triggers",	"triggerid",	ZBX_SYNC,
		{
		{"triggerid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"expression",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"description",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"url",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"status",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"value",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"priority",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"lastchange",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"dep_level",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"comments",	ZBX_TYPE_BLOB,	ZBX_NOTNULL | ZBX_SYNC},
		{"error",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"templateid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"type",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"trigger_depends",	"triggerdepid",	ZBX_SYNC,
		{
		{"triggerdepid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"triggerid_down",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"triggerid_up",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"users",	"userid",	ZBX_SYNC,
		{
		{"userid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"alias",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"name",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"surname",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"passwd",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"url",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"autologin",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"autologout",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"lang",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"refresh",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"type",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"theme",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"attempt_failed",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"attempt_ip",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"attempt_clock",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"usrgrp",	"usrgrpid",	ZBX_SYNC,
		{
		{"usrgrpid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"name",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{"gui_access",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{"users_status",	ZBX_TYPE_INT,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"users_groups",	"id",	ZBX_SYNC,
		{
		{"id",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"usrgrpid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{"userid",	ZBX_TYPE_ID,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{"valuemaps",	"valuemapid",	ZBX_SYNC,
		{
		{"valuemapid",	ZBX_TYPE_ID,	ZBX_NOTNULL},
		{"name",	ZBX_TYPE_CHAR,	ZBX_NOTNULL | ZBX_SYNC},
		{0}
		}
	},
	{0}
};

#ifdef HAVE_MYSQL
const char *db_schema= {"\
CREATE TABLE slideshows (\
	slideshowid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	name		varchar(255)		DEFAULT ''	NOT NULL,\
	delay		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (slideshowid)\
)  ype=InnoDB;\
CREATE TABLE slides (\
	slideid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	slideshowid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	screenid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	s ep		in eger		DEFAULT '0'	NOT NULL,\
	delay		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (slideid)\
)  ype=InnoDB;\
CREATE INDEX slides_slides_1 on slides (slideshowid);\
CREATE TABLE drules (\
	druleid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	proxy_hos id		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	name		varchar(255)		DEFAULT ''	NOT NULL,\
	iprange		varchar(255)		DEFAULT ''	NOT NULL,\
	delay		in eger		DEFAULT '0'	NOT NULL,\
	nex check		in eger		DEFAULT '0'	NOT NULL,\
	s a us		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (druleid)\
)  ype=InnoDB;\
CREATE TABLE dchecks (\
	dcheckid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	druleid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	 ype		in eger		DEFAULT '0'	NOT NULL,\
	key_		varchar(255)		DEFAULT '0'	NOT NULL,\
	snmp_communi y		varchar(255)		DEFAULT '0'	NOT NULL,\
	por s		varchar(255)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (dcheckid)\
)  ype=InnoDB;\
CREATE TABLE dhos s (\
	dhos id		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	druleid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	ip		varchar(39)		DEFAULT ''	NOT NULL,\
	s a us		in eger		DEFAULT '0'	NOT NULL,\
	las up		in eger		DEFAULT '0'	NOT NULL,\
	las down		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (dhos id)\
)  ype=InnoDB;\
CREATE TABLE dservices (\
	dserviceid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	dhos id		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	 ype		in eger		DEFAULT '0'	NOT NULL,\
	key_		varchar(255)		DEFAULT '0'	NOT NULL,\
	value		varchar(255)		DEFAULT '0'	NOT NULL,\
	por 		in eger		DEFAULT '0'	NOT NULL,\
	s a us		in eger		DEFAULT '0'	NOT NULL,\
	las up		in eger		DEFAULT '0'	NOT NULL,\
	las down		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (dserviceid)\
)  ype=InnoDB;\
CREATE TABLE ids (\
	nodeid		in eger		DEFAULT '0'	NOT NULL,\
	 able_name		varchar(64)		DEFAULT ''	NOT NULL,\
	field_name		varchar(64)		DEFAULT ''	NOT NULL,\
	nex id		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (nodeid, able_name,field_name)\
)  ype=InnoDB;\
CREATE TABLE h p es  (\
	h p es id		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	name		varchar(64)		DEFAULT ''	NOT NULL,\
	applica ionid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	las check		in eger		DEFAULT '0'	NOT NULL,\
	nex check		in eger		DEFAULT '0'	NOT NULL,\
	curs a e		in eger		DEFAULT '0'	NOT NULL,\
	curs ep		in eger		DEFAULT '0'	NOT NULL,\
	las faileds ep		in eger		DEFAULT '0'	NOT NULL,\
	delay		in eger		DEFAULT '60'	NOT NULL,\
	s a us		in eger		DEFAULT '0'	NOT NULL,\
	macros		blob			NOT NULL,\
	agen 		varchar(255)		DEFAULT ''	NOT NULL,\
	 ime		double(16,4)		DEFAULT '0'	NOT NULL,\
	error		varchar(255)		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (h p es id)\
)  ype=InnoDB;\
CREATE INDEX h p es _h p es _1 on h p es  (applica ionid);\
CREATE TABLE h ps ep (\
	h ps epid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	h p es id		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	name		varchar(64)		DEFAULT ''	NOT NULL,\
	no		in eger		DEFAULT '0'	NOT NULL,\
	url		varchar(255)		DEFAULT ''	NOT NULL,\
	 imeou 		in eger		DEFAULT '30'	NOT NULL,\
	pos s		blob			NOT NULL,\
	required		varchar(255)		DEFAULT ''	NOT NULL,\
	s a us_codes		varchar(255)		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (h ps epid)\
)  ype=InnoDB;\
CREATE INDEX h ps ep_h ps ep_1 on h ps ep (h p es id);\
CREATE TABLE h ps epi em (\
	h ps epi emid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	h ps epid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	i emid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	 ype		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (h ps epi emid)\
)  ype=InnoDB;\
CREATE UNIQUE INDEX h ps epi em_h ps epi em_1 on h ps epi em (h ps epid,i emid);\
CREATE TABLE h p es i em (\
	h p es i emid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	h p es id		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	i emid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	 ype		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (h p es i emid)\
)  ype=InnoDB;\
CREATE UNIQUE INDEX h p es i em_h p es i em_1 on h p es i em (h p es id,i emid);\
CREATE TABLE nodes (\
	nodeid		in eger		DEFAULT '0'	NOT NULL,\
	name		varchar(64)		DEFAULT '0'	NOT NULL,\
	 imezone		in eger		DEFAULT '0'	NOT NULL,\
	ip		varchar(39)		DEFAULT ''	NOT NULL,\
	por 		in eger		DEFAULT '10051'	NOT NULL,\
	slave_his ory		in eger		DEFAULT '30'	NOT NULL,\
	slave_ rends		in eger		DEFAULT '365'	NOT NULL,\
	node ype		in eger		DEFAULT '0'	NOT NULL,\
	mas erid		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (nodeid)\
)  ype=InnoDB;\
CREATE TABLE node_cksum (\
	nodeid		in eger		DEFAULT '0'	NOT NULL,\
	 ablename		varchar(64)		DEFAULT ''	NOT NULL,\
	recordid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	cksum ype		in eger		DEFAULT '0'	NOT NULL,\
	cksum		 ex 			NOT NULL,\
	sync		char(128)		DEFAULT ''	NOT NULL\
)  ype=InnoDB;\
CREATE INDEX node_cksum_cksum_1 on node_cksum (nodeid, ablename,recordid,cksum ype);\
CREATE TABLE services_ imes (\
	 imeid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	serviceid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	 ype		in eger		DEFAULT '0'	NOT NULL,\
	 s_from		in eger		DEFAULT '0'	NOT NULL,\
	 s_ o		in eger		DEFAULT '0'	NOT NULL,\
	no e		varchar(255)		DEFAULT ''	NOT NULL,\
	PRIMARY KEY ( imeid)\
)  ype=InnoDB;\
CREATE INDEX services_ imes_ imes_1 on services_ imes (serviceid, ype, s_from, s_ o);\
CREATE TABLE aler s (\
	aler id		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	ac ionid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	even id		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	userid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	media ypeid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	send o		varchar(100)		DEFAULT ''	NOT NULL,\
	subjec 		varchar(255)		DEFAULT ''	NOT NULL,\
	message		blob			NOT NULL,\
	s a us		in eger		DEFAULT '0'	NOT NULL,\
	re ries		in eger		DEFAULT '0'	NOT NULL,\
	error		varchar(128)		DEFAULT ''	NOT NULL,\
	nex check		in eger		DEFAULT '0'	NOT NULL,\
	esc_s ep		in eger		DEFAULT '0'	NOT NULL,\
	aler ype		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (aler id)\
)  ype=InnoDB;\
CREATE INDEX aler s_1 on aler s (ac ionid);\
CREATE INDEX aler s_2 on aler s (clock);\
CREATE INDEX aler s_3 on aler s (even id);\
CREATE INDEX aler s_4 on aler s (s a us,re ries);\
CREATE INDEX aler s_5 on aler s (media ypeid);\
CREATE INDEX aler s_6 on aler s (userid);\
CREATE TABLE his ory (\
	i emid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	value		double(16,4)		DEFAULT '0.0000'	NOT NULL\
)  ype=InnoDB;\
CREATE INDEX his ory_1 on his ory (i emid,clock);\
CREATE TABLE his ory_sync (\
	id		bigin  unsigned			NOT NULL	au o_incremen  unique,\
	nodeid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	i emid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	value		double(16,4)		DEFAULT '0.0000'	NOT NULL,\
	PRIMARY KEY (id)\
)  ype=InnoDB;\
CREATE INDEX his ory_sync_1 on his ory_sync (nodeid,id);\
CREATE TABLE his ory_uin  (\
	i emid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	value		bigin  unsigned		DEFAULT '0'	NOT NULL\
)  ype=InnoDB;\
CREATE INDEX his ory_uin _1 on his ory_uin  (i emid,clock);\
CREATE TABLE his ory_uin _sync (\
	id		bigin  unsigned			NOT NULL	au o_incremen  unique,\
	nodeid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	i emid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	value		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (id)\
)  ype=InnoDB;\
CREATE INDEX his ory_uin _sync_1 on his ory_uin _sync (nodeid,id);\
CREATE TABLE his ory_s r (\
	i emid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	value		varchar(255)		DEFAULT ''	NOT NULL\
)  ype=InnoDB;\
CREATE INDEX his ory_s r_1 on his ory_s r (i emid,clock);\
CREATE TABLE his ory_s r_sync (\
	id		bigin  unsigned			NOT NULL	au o_incremen  unique,\
	nodeid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	i emid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	value		varchar(255)		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (id)\
)  ype=InnoDB;\
CREATE INDEX his ory_s r_sync_1 on his ory_s r_sync (nodeid,id);\
CREATE TABLE his ory_log (\
	id		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	i emid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	 imes amp		in eger		DEFAULT '0'	NOT NULL,\
	source		varchar(64)		DEFAULT ''	NOT NULL,\
	severi y		in eger		DEFAULT '0'	NOT NULL,\
	value		 ex 			NOT NULL,\
	PRIMARY KEY (id)\
)  ype=InnoDB;\
CREATE INDEX his ory_log_1 on his ory_log (i emid,clock);\
CREATE TABLE his ory_ ex  (\
	id		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	i emid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	value		 ex 			NOT NULL,\
	PRIMARY KEY (id)\
)  ype=InnoDB;\
CREATE INDEX his ory_ ex _1 on his ory_ ex  (i emid,clock);\
CREATE TABLE proxy_his ory (\
	id		bigin  unsigned			NOT NULL	au o_incremen  unique,\
	i emid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	 imes amp		in eger		DEFAULT '0'	NOT NULL,\
	source		varchar(64)		DEFAULT ''	NOT NULL,\
	severi y		in eger		DEFAULT '0'	NOT NULL,\
	value		 ex 			NOT NULL,\
	PRIMARY KEY (id)\
)  ype=InnoDB;\
CREATE INDEX proxy_his ory_1 on proxy_his ory (clock);\
CREATE TABLE proxy_dhis ory (\
	id		bigin  unsigned			NOT NULL	au o_incremen  unique,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	druleid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	 ype		in eger		DEFAULT '0'	NOT NULL,\
	ip		varchar(39)		DEFAULT ''	NOT NULL,\
	por 		in eger		DEFAULT '0'	NOT NULL,\
	key_		varchar(255)		DEFAULT '0'	NOT NULL,\
	value		varchar(255)		DEFAULT '0'	NOT NULL,\
	s a us		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (id)\
)  ype=InnoDB;\
CREATE INDEX proxy_dhis ory_1 on proxy_dhis ory (clock);\
CREATE TABLE even s (\
	even id		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	source		in eger		DEFAULT '0'	NOT NULL,\
	objec 		in eger		DEFAULT '0'	NOT NULL,\
	objec id		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	value		in eger		DEFAULT '0'	NOT NULL,\
	acknowledged		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (even id)\
)  ype=InnoDB;\
CREATE INDEX even s_1 on even s (objec ,objec id,even id);\
CREATE INDEX even s_2 on even s (clock);\
CREATE TABLE  rends (\
	i emid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	num		in eger		DEFAULT '0'	NOT NULL,\
	value_min		double(16,4)		DEFAULT '0.0000'	NOT NULL,\
	value_avg		double(16,4)		DEFAULT '0.0000'	NOT NULL,\
	value_max		double(16,4)		DEFAULT '0.0000'	NOT NULL,\
	PRIMARY KEY (i emid,clock)\
)  ype=InnoDB;\
CREATE TABLE  rends_uin  (\
	i emid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	num		in eger		DEFAULT '0'	NOT NULL,\
	value_min		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	value_avg		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	value_max		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (i emid,clock)\
)  ype=InnoDB;\
CREATE TABLE acknowledges (\
	acknowledgeid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	userid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	even id		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	message		varchar(255)		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (acknowledgeid)\
)  ype=InnoDB;\
CREATE INDEX acknowledges_1 on acknowledges (userid);\
CREATE INDEX acknowledges_2 on acknowledges (even id);\
CREATE INDEX acknowledges_3 on acknowledges (clock);\
CREATE TABLE audi log (\
	audi id		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	userid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	ac ion		in eger		DEFAULT '0'	NOT NULL,\
	resource ype		in eger		DEFAULT '0'	NOT NULL,\
	de ails		varchar(128)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (audi id)\
)  ype=InnoDB;\
CREATE INDEX audi log_1 on audi log (userid,clock);\
CREATE INDEX audi log_2 on audi log (clock);\
CREATE TABLE service_alarms (\
	servicealarmid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	serviceid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	value		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (servicealarmid)\
)  ype=InnoDB;\
CREATE INDEX service_alarms_1 on service_alarms (serviceid,clock);\
CREATE INDEX service_alarms_2 on service_alarms (clock);\
CREATE TABLE ac ions (\
	ac ionid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	name		varchar(255)		DEFAULT ''	NOT NULL,\
	even source		in eger		DEFAULT '0'	NOT NULL,\
	eval ype		in eger		DEFAULT '0'	NOT NULL,\
	s a us		in eger		DEFAULT '0'	NOT NULL,\
	esc_period		in eger		DEFAULT '0'	NOT NULL,\
	def_shor da a		varchar(255)		DEFAULT ''	NOT NULL,\
	def_longda a		blob			NOT NULL,\
	recovery_msg		in eger		DEFAULT '0'	NOT NULL,\
	r_shor da a		varchar(255)		DEFAULT ''	NOT NULL,\
	r_longda a		blob			NOT NULL,\
	PRIMARY KEY (ac ionid)\
)  ype=InnoDB;\
CREATE TABLE opera ions (\
	opera ionid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	ac ionid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	opera ion ype		in eger		DEFAULT '0'	NOT NULL,\
	objec 		in eger		DEFAULT '0'	NOT NULL,\
	objec id		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	shor da a		varchar(255)		DEFAULT ''	NOT NULL,\
	longda a		blob			NOT NULL,\
	esc_period		in eger		DEFAULT '0'	NOT NULL,\
	esc_s ep_from		in eger		DEFAULT '0'	NOT NULL,\
	esc_s ep_ o		in eger		DEFAULT '0'	NOT NULL,\
	defaul _msg		in eger		DEFAULT '0'	NOT NULL,\
	eval ype		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (opera ionid)\
)  ype=InnoDB;\
CREATE INDEX opera ions_1 on opera ions (ac ionid);\
CREATE TABLE opcondi ions (\
	opcondi ionid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	opera ionid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	condi ion ype		in eger		DEFAULT '0'	NOT NULL,\
	opera or		in eger		DEFAULT '0'	NOT NULL,\
	value		varchar(255)		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (opcondi ionid)\
)  ype=InnoDB;\
CREATE INDEX opcondi ions_1 on opcondi ions (opera ionid);\
CREATE TABLE escala ions (\
	escala ionid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	ac ionid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	 riggerid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	even id		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	r_even id		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	nex check		in eger		DEFAULT '0'	NOT NULL,\
	esc_s ep		in eger		DEFAULT '0'	NOT NULL,\
	s a us		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (escala ionid)\
)  ype=InnoDB;\
CREATE INDEX escala ions_1 on escala ions (ac ionid, riggerid);\
CREATE TABLE applica ions (\
	applica ionid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	hos id		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	name		varchar(255)		DEFAULT ''	NOT NULL,\
	 empla eid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (applica ionid)\
)  ype=InnoDB;\
CREATE INDEX applica ions_1 on applica ions ( empla eid);\
CREATE UNIQUE INDEX applica ions_2 on applica ions (hos id,name);\
CREATE TABLE condi ions (\
	condi ionid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	ac ionid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	condi ion ype		in eger		DEFAULT '0'	NOT NULL,\
	opera or		in eger		DEFAULT '0'	NOT NULL,\
	value		varchar(255)		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (condi ionid)\
)  ype=InnoDB;\
CREATE INDEX condi ions_1 on condi ions (ac ionid);\
CREATE TABLE config (\
	configid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	aler _his ory		in eger		DEFAULT '0'	NOT NULL,\
	even _his ory		in eger		DEFAULT '0'	NOT NULL,\
	refresh_unsuppor ed		in eger		DEFAULT '0'	NOT NULL,\
	work_period		varchar(100)		DEFAULT '1-5,00:00-24:00'	NOT NULL,\
	aler _usrgrpid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	even _ack_enable		in eger		DEFAULT '1'	NOT NULL,\
	even _expire		in eger		DEFAULT '7'	NOT NULL,\
	even _show_max		in eger		DEFAULT '100'	NOT NULL,\
	defaul _ heme		varchar(128)		DEFAULT 'defaul .css'	NOT NULL,\
	au hen ica ion_ ype		in eger		DEFAULT 0	NOT NULL,\
	ldap_hos 		varchar(255)		DEFAULT ''	NOT NULL,\
	ldap_por 		in eger		DEFAULT 389	NOT NULL,\
	ldap_base_dn		varchar(255)		DEFAULT ''	NOT NULL,\
	ldap_bind_dn		varchar(255)		DEFAULT ''	NOT NULL,\
	ldap_bind_password		varchar(128)		DEFAULT ''	NOT NULL,\
	ldap_search_a ribu e		varchar(128)		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (configid)\
)  ype=InnoDB;\
CREATE TABLE func ions (\
	func ionid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	i emid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	 riggerid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	las value		varchar(255)			,\
	func ion		varchar(12)		DEFAULT ''	NOT NULL,\
	parame er		varchar(255)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (func ionid)\
)  ype=InnoDB;\
CREATE INDEX func ions_1 on func ions ( riggerid);\
CREATE INDEX func ions_2 on func ions (i emid,func ion,parame er);\
CREATE TABLE graphs (\
	graphid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	name		varchar(128)		DEFAULT ''	NOT NULL,\
	wid h		in eger		DEFAULT '0'	NOT NULL,\
	heigh 		in eger		DEFAULT '0'	NOT NULL,\
	yaxis ype		in eger		DEFAULT '0'	NOT NULL,\
	yaxismin		double(16,4)		DEFAULT '0'	NOT NULL,\
	yaxismax		double(16,4)		DEFAULT '0'	NOT NULL,\
	 empla eid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	show_work_period		in eger		DEFAULT '1'	NOT NULL,\
	show_ riggers		in eger		DEFAULT '1'	NOT NULL,\
	graph ype		in eger		DEFAULT '0'	NOT NULL,\
	show_legend		in eger		DEFAULT '0'	NOT NULL,\
	show_3d		in eger		DEFAULT '0'	NOT NULL,\
	percen _lef 		double(16,4)		DEFAULT '0'	NOT NULL,\
	percen _righ 		double(16,4)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (graphid)\
)  ype=InnoDB;\
CREATE INDEX graphs_graphs_1 on graphs (name);\
CREATE TABLE graphs_i ems (\
	gi emid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	graphid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	i emid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	draw ype		in eger		DEFAULT '0'	NOT NULL,\
	sor order		in eger		DEFAULT '0'	NOT NULL,\
	color		varchar(32)		DEFAULT '009600'	NOT NULL,\
	yaxisside		in eger		DEFAULT '1'	NOT NULL,\
	calc_fnc		in eger		DEFAULT '2'	NOT NULL,\
	 ype		in eger		DEFAULT '0'	NOT NULL,\
	periods_cn 		in eger		DEFAULT '5'	NOT NULL,\
	PRIMARY KEY (gi emid)\
)  ype=InnoDB;\
CREATE TABLE groups (\
	groupid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	name		varchar(64)		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (groupid)\
)  ype=InnoDB;\
CREATE INDEX groups_1 on groups (name);\
CREATE TABLE help_i ems (\
	i em ype		in eger		DEFAULT '0'	NOT NULL,\
	key_		varchar(255)		DEFAULT ''	NOT NULL,\
	descrip ion		varchar(255)		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (i em ype,key_)\
)  ype=InnoDB;\
CREATE TABLE hos s (\
	hos id		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	proxy_hos id		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	hos 		varchar(64)		DEFAULT ''	NOT NULL,\
	dns		varchar(64)		DEFAULT ''	NOT NULL,\
	useip		in eger		DEFAULT '1'	NOT NULL,\
	ip		varchar(39)		DEFAULT '127.0.0.1'	NOT NULL,\
	por 		in eger		DEFAULT '10050'	NOT NULL,\
	s a us		in eger		DEFAULT '0'	NOT NULL,\
	disable_un il		in eger		DEFAULT '0'	NOT NULL,\
	error		varchar(128)		DEFAULT ''	NOT NULL,\
	available		in eger		DEFAULT '0'	NOT NULL,\
	errors_from		in eger		DEFAULT '0'	NOT NULL,\
	las access		in eger		DEFAULT '0'	NOT NULL,\
	inby es		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	ou by es		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	useipmi		in eger		DEFAULT '0'	NOT NULL,\
	ipmi_por 		in eger		DEFAULT '623'	NOT NULL,\
	ipmi_au h ype		in eger		DEFAULT '0'	NOT NULL,\
	ipmi_privilege		in eger		DEFAULT '2'	NOT NULL,\
	ipmi_username		varchar(16)		DEFAULT ''	NOT NULL,\
	ipmi_password		varchar(20)		DEFAULT ''	NOT NULL,\
	ipmi_disable_un il		in eger		DEFAULT '0'	NOT NULL,\
	ipmi_available		in eger		DEFAULT '0'	NOT NULL,\
	snmp_disable_un il		in eger		DEFAULT '0'	NOT NULL,\
	snmp_available		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (hos id)\
)  ype=InnoDB;\
CREATE INDEX hos s_1 on hos s (hos );\
CREATE INDEX hos s_2 on hos s (s a us);\
CREATE INDEX hos s_3 on hos s (proxy_hos id);\
CREATE TABLE hos s_groups (\
	hos groupid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	hos id		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	groupid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (hos groupid)\
)  ype=InnoDB;\
CREATE INDEX hos s_groups_groups_1 on hos s_groups (hos id,groupid);\
CREATE TABLE hos s_profiles (\
	hos id		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	device ype		varchar(64)		DEFAULT ''	NOT NULL,\
	name		varchar(64)		DEFAULT ''	NOT NULL,\
	os		varchar(64)		DEFAULT ''	NOT NULL,\
	serialno		varchar(64)		DEFAULT ''	NOT NULL,\
	 ag		varchar(64)		DEFAULT ''	NOT NULL,\
	macaddress		varchar(64)		DEFAULT ''	NOT NULL,\
	hardware		blob			NOT NULL,\
	sof ware		blob			NOT NULL,\
	con ac 		blob			NOT NULL,\
	loca ion		blob			NOT NULL,\
	no es		blob			NOT NULL,\
	PRIMARY KEY (hos id)\
)  ype=InnoDB;\
CREATE TABLE hos s_profiles_ex  (\
	hos id		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	device_alias		varchar(64)		DEFAULT ''	NOT NULL,\
	device_ ype		varchar(64)		DEFAULT ''	NOT NULL,\
	device_chassis		varchar(64)		DEFAULT ''	NOT NULL,\
	device_os		varchar(64)		DEFAULT ''	NOT NULL,\
	device_os_shor 		varchar(64)		DEFAULT ''	NOT NULL,\
	device_hw_arch		varchar(32)		DEFAULT ''	NOT NULL,\
	device_serial		varchar(64)		DEFAULT ''	NOT NULL,\
	device_model		varchar(64)		DEFAULT ''	NOT NULL,\
	device_ ag		varchar(64)		DEFAULT ''	NOT NULL,\
	device_vendor		varchar(64)		DEFAULT ''	NOT NULL,\
	device_con rac 		varchar(64)		DEFAULT ''	NOT NULL,\
	device_who		varchar(64)		DEFAULT ''	NOT NULL,\
	device_s a us		varchar(64)		DEFAULT ''	NOT NULL,\
	device_app_01		varchar(64)		DEFAULT ''	NOT NULL,\
	device_app_02		varchar(64)		DEFAULT ''	NOT NULL,\
	device_app_03		varchar(64)		DEFAULT ''	NOT NULL,\
	device_app_04		varchar(64)		DEFAULT ''	NOT NULL,\
	device_app_05		varchar(64)		DEFAULT ''	NOT NULL,\
	device_url_1		varchar(255)		DEFAULT ''	NOT NULL,\
	device_url_2		varchar(255)		DEFAULT ''	NOT NULL,\
	device_url_3		varchar(255)		DEFAULT ''	NOT NULL,\
	device_ne works		blob			NOT NULL,\
	device_no es		blob			NOT NULL,\
	device_hardware		blob			NOT NULL,\
	device_sof ware		blob			NOT NULL,\
	ip_subne _mask		varchar(39)		DEFAULT ''	NOT NULL,\
	ip_rou er		varchar(39)		DEFAULT ''	NOT NULL,\
	ip_macaddress		varchar(64)		DEFAULT ''	NOT NULL,\
	oob_ip		varchar(39)		DEFAULT ''	NOT NULL,\
	oob_subne _mask		varchar(39)		DEFAULT ''	NOT NULL,\
	oob_rou er		varchar(39)		DEFAULT ''	NOT NULL,\
	da e_hw_buy		varchar(64)		DEFAULT ''	NOT NULL,\
	da e_hw_ins all		varchar(64)		DEFAULT ''	NOT NULL,\
	da e_hw_expiry		varchar(64)		DEFAULT ''	NOT NULL,\
	da e_hw_decomm		varchar(64)		DEFAULT ''	NOT NULL,\
	si e_s ree _1		varchar(128)		DEFAULT ''	NOT NULL,\
	si e_s ree _2		varchar(128)		DEFAULT ''	NOT NULL,\
	si e_s ree _3		varchar(128)		DEFAULT ''	NOT NULL,\
	si e_ci y		varchar(128)		DEFAULT ''	NOT NULL,\
	si e_s a e		varchar(64)		DEFAULT ''	NOT NULL,\
	si e_coun ry		varchar(64)		DEFAULT ''	NOT NULL,\
	si e_zip		varchar(64)		DEFAULT ''	NOT NULL,\
	si e_rack		varchar(128)		DEFAULT ''	NOT NULL,\
	si e_no es		blob			NOT NULL,\
	poc_1_name		varchar(128)		DEFAULT ''	NOT NULL,\
	poc_1_email		varchar(128)		DEFAULT ''	NOT NULL,\
	poc_1_phone_1		varchar(64)		DEFAULT ''	NOT NULL,\
	poc_1_phone_2		varchar(64)		DEFAULT ''	NOT NULL,\
	poc_1_cell		varchar(64)		DEFAULT ''	NOT NULL,\
	poc_1_screen		varchar(64)		DEFAULT ''	NOT NULL,\
	poc_1_no es		blob			NOT NULL,\
	poc_2_name		varchar(128)		DEFAULT ''	NOT NULL,\
	poc_2_email		varchar(128)		DEFAULT ''	NOT NULL,\
	poc_2_phone_1		varchar(64)		DEFAULT ''	NOT NULL,\
	poc_2_phone_2		varchar(64)		DEFAULT ''	NOT NULL,\
	poc_2_cell		varchar(64)		DEFAULT ''	NOT NULL,\
	poc_2_screen		varchar(64)		DEFAULT ''	NOT NULL,\
	poc_2_no es		blob			NOT NULL,\
	PRIMARY KEY (hos id)\
)  ype=InnoDB;\
CREATE TABLE hos s_ empla es (\
	hos empla eid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	hos id		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	 empla eid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (hos empla eid)\
)  ype=InnoDB;\
CREATE UNIQUE INDEX hos s_ empla es_1 on hos s_ empla es (hos id, empla eid);\
CREATE TABLE housekeeper (\
	housekeeperid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	 ablename		varchar(64)		DEFAULT ''	NOT NULL,\
	field		varchar(64)		DEFAULT ''	NOT NULL,\
	value		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (housekeeperid)\
)  ype=InnoDB;\
CREATE TABLE images (\
	imageid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	image ype		in eger		DEFAULT '0'	NOT NULL,\
	name		varchar(64)		DEFAULT '0'	NOT NULL,\
	image		longblob			NOT NULL,\
	PRIMARY KEY (imageid)\
)  ype=InnoDB;\
CREATE INDEX images_1 on images (image ype,name);\
CREATE TABLE i ems (\
	i emid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	 ype		in eger		DEFAULT '0'	NOT NULL,\
	snmp_communi y		varchar(64)		DEFAULT ''	NOT NULL,\
	snmp_oid		varchar(255)		DEFAULT ''	NOT NULL,\
	snmp_por 		in eger		DEFAULT '161'	NOT NULL,\
	hos id		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	descrip ion		varchar(255)		DEFAULT ''	NOT NULL,\
	key_		varchar(255)		DEFAULT ''	NOT NULL,\
	delay		in eger		DEFAULT '0'	NOT NULL,\
	his ory		in eger		DEFAULT '90'	NOT NULL,\
	 rends		in eger		DEFAULT '365'	NOT NULL,\
	nex check		in eger		DEFAULT '0'	NOT NULL,\
	las value		varchar(255)			NULL,\
	las clock		in eger			NULL,\
	prevvalue		varchar(255)			NULL,\
	s a us		in eger		DEFAULT '0'	NOT NULL,\
	value_ ype		in eger		DEFAULT '0'	NOT NULL,\
	 rapper_hos s		varchar(255)		DEFAULT ''	NOT NULL,\
	uni s		varchar(10)		DEFAULT ''	NOT NULL,\
	mul iplier		in eger		DEFAULT '0'	NOT NULL,\
	del a		in eger		DEFAULT '0'	NOT NULL,\
	prevorgvalue		varchar(255)			NULL,\
	snmpv3_securi yname		varchar(64)		DEFAULT ''	NOT NULL,\
	snmpv3_securi ylevel		in eger		DEFAULT '0'	NOT NULL,\
	snmpv3_au hpassphrase		varchar(64)		DEFAULT ''	NOT NULL,\
	snmpv3_privpassphrase		varchar(64)		DEFAULT ''	NOT NULL,\
	formula		varchar(255)		DEFAULT '1'	NOT NULL,\
	error		varchar(128)		DEFAULT ''	NOT NULL,\
	las logsize		in eger		DEFAULT '0'	NOT NULL,\
	log imefm 		varchar(64)		DEFAULT ''	NOT NULL,\
	 empla eid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	valuemapid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	delay_flex		varchar(255)		DEFAULT ''	NOT NULL,\
	params		 ex 			NOT NULL,\
	ipmi_sensor		varchar(128)		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (i emid)\
)  ype=InnoDB;\
CREATE UNIQUE INDEX i ems_1 on i ems (hos id,key_);\
CREATE INDEX i ems_2 on i ems (nex check);\
CREATE INDEX i ems_3 on i ems (s a us);\
CREATE INDEX i ems_4 on i ems ( empla eid);\
CREATE TABLE i ems_applica ions (\
	i emappid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	applica ionid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	i emid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (i emappid)\
)  ype=InnoDB;\
CREATE INDEX i ems_applica ions_1 on i ems_applica ions (applica ionid,i emid);\
CREATE INDEX i ems_applica ions_2 on i ems_applica ions (i emid);\
CREATE TABLE mappings (\
	mappingid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	valuemapid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	value		varchar(64)		DEFAULT ''	NOT NULL,\
	newvalue		varchar(64)		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (mappingid)\
)  ype=InnoDB;\
CREATE INDEX mappings_1 on mappings (valuemapid);\
CREATE TABLE media (\
	mediaid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	userid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	media ypeid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	send o		varchar(100)		DEFAULT ''	NOT NULL,\
	ac ive		in eger		DEFAULT '0'	NOT NULL,\
	severi y		in eger		DEFAULT '63'	NOT NULL,\
	period		varchar(100)		DEFAULT '1-7,00:00-23:59'	NOT NULL,\
	PRIMARY KEY (mediaid)\
)  ype=InnoDB;\
CREATE INDEX media_1 on media (userid);\
CREATE INDEX media_2 on media (media ypeid);\
CREATE TABLE media_ ype (\
	media ypeid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	 ype		in eger		DEFAULT '0'	NOT NULL,\
	descrip ion		varchar(100)		DEFAULT ''	NOT NULL,\
	sm p_server		varchar(255)		DEFAULT ''	NOT NULL,\
	sm p_helo		varchar(255)		DEFAULT ''	NOT NULL,\
	sm p_email		varchar(255)		DEFAULT ''	NOT NULL,\
	exec_pa h		varchar(255)		DEFAULT ''	NOT NULL,\
	gsm_modem		varchar(255)		DEFAULT ''	NOT NULL,\
	username		varchar(255)		DEFAULT ''	NOT NULL,\
	passwd		varchar(255)		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (media ypeid)\
)  ype=InnoDB;\
CREATE TABLE profiles (\
	profileid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	userid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	idx		varchar(96)		DEFAULT ''	NOT NULL,\
	idx2		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	value_id		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	value_in 		in eger		DEFAULT '0'	NOT NULL,\
	value_s r		varchar(255)		DEFAULT ''	NOT NULL,\
	source		varchar(96)		DEFAULT ''	NOT NULL,\
	 ype		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (profileid)\
)  ype=InnoDB;\
CREATE INDEX profiles_1 on profiles (userid,idx,idx2);\
CREATE TABLE righ s (\
	righ id		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	groupid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	permission		in eger		DEFAULT '0'	NOT NULL,\
	id		bigin  unsigned			,\
	PRIMARY KEY (righ id)\
)  ype=InnoDB;\
CREATE INDEX righ s_1 on righ s (groupid);\
CREATE TABLE scrip s (\
	scrip id		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	name		varchar(255)		DEFAULT ''	NOT NULL,\
	command		varchar(255)		DEFAULT ''	NOT NULL,\
	hos _access		in eger		DEFAULT '2'	NOT NULL,\
	usrgrpid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	groupid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (scrip id)\
)  ype=InnoDB;\
CREATE TABLE screens (\
	screenid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	name		varchar(255)		DEFAULT 'Screen'	NOT NULL,\
	hsize		in eger		DEFAULT '1'	NOT NULL,\
	vsize		in eger		DEFAULT '1'	NOT NULL,\
	PRIMARY KEY (screenid)\
)  ype=InnoDB;\
CREATE TABLE screens_i ems (\
	screeni emid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	screenid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	resource ype		in eger		DEFAULT '0'	NOT NULL,\
	resourceid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	wid h		in eger		DEFAULT '320'	NOT NULL,\
	heigh 		in eger		DEFAULT '200'	NOT NULL,\
	x		in eger		DEFAULT '0'	NOT NULL,\
	y		in eger		DEFAULT '0'	NOT NULL,\
	colspan		in eger		DEFAULT '0'	NOT NULL,\
	rowspan		in eger		DEFAULT '0'	NOT NULL,\
	elemen s		in eger		DEFAULT '25'	NOT NULL,\
	valign		in eger		DEFAULT '0'	NOT NULL,\
	halign		in eger		DEFAULT '0'	NOT NULL,\
	s yle		in eger		DEFAULT '0'	NOT NULL,\
	url		varchar(255)		DEFAULT ''	NOT NULL,\
	dynamic		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (screeni emid)\
)  ype=InnoDB;\
CREATE TABLE services (\
	serviceid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	name		varchar(128)		DEFAULT ''	NOT NULL,\
	s a us		in eger		DEFAULT '0'	NOT NULL,\
	algori hm		in eger		DEFAULT '0'	NOT NULL,\
	 riggerid		bigin  unsigned			,\
	showsla		in eger		DEFAULT '0'	NOT NULL,\
	goodsla		double(16,4)		DEFAULT '99.9'	NOT NULL,\
	sor order		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (serviceid)\
)  ype=InnoDB;\
CREATE TABLE services_links (\
	linkid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	serviceupid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	servicedownid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	sof 		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (linkid)\
)  ype=InnoDB;\
CREATE INDEX services_links_links_1 on services_links (servicedownid);\
CREATE UNIQUE INDEX services_links_links_2 on services_links (serviceupid,servicedownid);\
CREATE TABLE sessions (\
	sessionid		varchar(32)		DEFAULT ''	NOT NULL,\
	userid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	las access		in eger		DEFAULT '0'	NOT NULL,\
	s a us		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (sessionid)\
)  ype=InnoDB;\
CREATE TABLE sysmaps_links (\
	linkid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	sysmapid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	selemen id1		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	selemen id2		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	draw ype		in eger		DEFAULT '0'	NOT NULL,\
	color		varchar(6)		DEFAULT '000000'	NOT NULL,\
	PRIMARY KEY (linkid)\
)  ype=InnoDB;\
CREATE TABLE sysmaps_link_ riggers (\
	link riggerid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	linkid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	 riggerid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	draw ype		in eger		DEFAULT '0'	NOT NULL,\
	color		varchar(6)		DEFAULT '000000'	NOT NULL,\
	PRIMARY KEY (link riggerid)\
)  ype=InnoDB;\
CREATE UNIQUE INDEX sysmaps_link_ riggers_1 on sysmaps_link_ riggers (linkid, riggerid);\
CREATE TABLE sysmaps_elemen s (\
	selemen id		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	sysmapid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	elemen id		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	elemen ype		in eger		DEFAULT '0'	NOT NULL,\
	iconid_off		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	iconid_on		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	iconid_unknown		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	label		varchar(128)		DEFAULT ''	NOT NULL,\
	label_loca ion		in eger			NULL,\
	x		in eger		DEFAULT '0'	NOT NULL,\
	y		in eger		DEFAULT '0'	NOT NULL,\
	url		varchar(255)		DEFAULT ''	NOT NULL,\
	iconid_disabled		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (selemen id)\
)  ype=InnoDB;\
CREATE TABLE sysmaps (\
	sysmapid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	name		varchar(128)		DEFAULT ''	NOT NULL,\
	wid h		in eger		DEFAULT '0'	NOT NULL,\
	heigh 		in eger		DEFAULT '0'	NOT NULL,\
	backgroundid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	label_ ype		in eger		DEFAULT '0'	NOT NULL,\
	label_loca ion		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (sysmapid)\
)  ype=InnoDB;\
CREATE INDEX sysmaps_1 on sysmaps (name);\
CREATE TABLE  riggers (\
	 riggerid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	expression		varchar(255)		DEFAULT ''	NOT NULL,\
	descrip ion		varchar(255)		DEFAULT ''	NOT NULL,\
	url		varchar(255)		DEFAULT ''	NOT NULL,\
	s a us		in eger		DEFAULT '0'	NOT NULL,\
	value		in eger		DEFAULT '0'	NOT NULL,\
	priori y		in eger		DEFAULT '0'	NOT NULL,\
	las change		in eger		DEFAULT '0'	NOT NULL,\
	dep_level		in eger		DEFAULT '0'	NOT NULL,\
	commen s		blob			NOT NULL,\
	error		varchar(128)		DEFAULT ''	NOT NULL,\
	 empla eid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	 ype		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY ( riggerid)\
)  ype=InnoDB;\
CREATE INDEX  riggers_1 on  riggers (s a us);\
CREATE INDEX  riggers_2 on  riggers (value);\
CREATE TABLE  rigger_depends (\
	 riggerdepid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	 riggerid_down		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	 riggerid_up		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY ( riggerdepid)\
)  ype=InnoDB;\
CREATE INDEX  rigger_depends_1 on  rigger_depends ( riggerid_down, riggerid_up);\
CREATE INDEX  rigger_depends_2 on  rigger_depends ( riggerid_up);\
CREATE TABLE users (\
	userid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	alias		varchar(100)		DEFAULT ''	NOT NULL,\
	name		varchar(100)		DEFAULT ''	NOT NULL,\
	surname		varchar(100)		DEFAULT ''	NOT NULL,\
	passwd		char(32)		DEFAULT ''	NOT NULL,\
	url		varchar(255)		DEFAULT ''	NOT NULL,\
	au ologin		in eger		DEFAULT '0'	NOT NULL,\
	au ologou 		in eger		DEFAULT '900'	NOT NULL,\
	lang		varchar(5)		DEFAULT 'en_gb'	NOT NULL,\
	refresh		in eger		DEFAULT '30'	NOT NULL,\
	 ype		in eger		DEFAULT '0'	NOT NULL,\
	 heme		varchar(128)		DEFAULT 'defaul .css'	NOT NULL,\
	a emp _failed		in eger		DEFAULT 0	NOT NULL,\
	a emp _ip		varchar(39)		DEFAULT ''	NOT NULL,\
	a emp _clock		in eger		DEFAULT 0	NOT NULL,\
	PRIMARY KEY (userid)\
)  ype=InnoDB;\
CREATE INDEX users_1 on users (alias);\
CREATE TABLE usrgrp (\
	usrgrpid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	name		varchar(64)		DEFAULT ''	NOT NULL,\
	gui_access		in eger		DEFAULT '0'	NOT NULL,\
	users_s a us		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (usrgrpid)\
)  ype=InnoDB;\
CREATE INDEX usrgrp_1 on usrgrp (name);\
CREATE TABLE users_groups (\
	id		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	usrgrpid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	userid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (id)\
)  ype=InnoDB;\
CREATE INDEX users_groups_1 on users_groups (usrgrpid,userid);\
CREATE TABLE valuemaps (\
	valuemapid		bigin  unsigned		DEFAULT '0'	NOT NULL,\
	name		varchar(64)		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (valuemapid)\
)  ype=InnoDB;\
CREATE INDEX valuemaps_1 on valuemaps (name);\
"};
#elif HAVE_POSTGRESQL
const char *db_schema = {"\
CREATE TABLE slideshows (\
	slideshowid		bigin 		DEFAULT '0'	NOT NULL,\
	name		varchar(255)		DEFAULT ''	NOT NULL,\
	delay		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (slideshowid)\
) wi h OIDS;\
CREATE TABLE slides (\
	slideid		bigin 		DEFAULT '0'	NOT NULL,\
	slideshowid		bigin 		DEFAULT '0'	NOT NULL,\
	screenid		bigin 		DEFAULT '0'	NOT NULL,\
	s ep		in eger		DEFAULT '0'	NOT NULL,\
	delay		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (slideid)\
) wi h OIDS;\
CREATE INDEX slides_slides_1 on slides (slideshowid);\
CREATE TABLE drules (\
	druleid		bigin 		DEFAULT '0'	NOT NULL,\
	proxy_hos id		bigin 		DEFAULT '0'	NOT NULL,\
	name		varchar(255)		DEFAULT ''	NOT NULL,\
	iprange		varchar(255)		DEFAULT ''	NOT NULL,\
	delay		in eger		DEFAULT '0'	NOT NULL,\
	nex check		in eger		DEFAULT '0'	NOT NULL,\
	s a us		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (druleid)\
) wi h OIDS;\
CREATE TABLE dchecks (\
	dcheckid		bigin 		DEFAULT '0'	NOT NULL,\
	druleid		bigin 		DEFAULT '0'	NOT NULL,\
	 ype		in eger		DEFAULT '0'	NOT NULL,\
	key_		varchar(255)		DEFAULT '0'	NOT NULL,\
	snmp_communi y		varchar(255)		DEFAULT '0'	NOT NULL,\
	por s		varchar(255)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (dcheckid)\
) wi h OIDS;\
CREATE TABLE dhos s (\
	dhos id		bigin 		DEFAULT '0'	NOT NULL,\
	druleid		bigin 		DEFAULT '0'	NOT NULL,\
	ip		varchar(39)		DEFAULT ''	NOT NULL,\
	s a us		in eger		DEFAULT '0'	NOT NULL,\
	las up		in eger		DEFAULT '0'	NOT NULL,\
	las down		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (dhos id)\
) wi h OIDS;\
CREATE TABLE dservices (\
	dserviceid		bigin 		DEFAULT '0'	NOT NULL,\
	dhos id		bigin 		DEFAULT '0'	NOT NULL,\
	 ype		in eger		DEFAULT '0'	NOT NULL,\
	key_		varchar(255)		DEFAULT '0'	NOT NULL,\
	value		varchar(255)		DEFAULT '0'	NOT NULL,\
	por 		in eger		DEFAULT '0'	NOT NULL,\
	s a us		in eger		DEFAULT '0'	NOT NULL,\
	las up		in eger		DEFAULT '0'	NOT NULL,\
	las down		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (dserviceid)\
) wi h OIDS;\
CREATE TABLE ids (\
	nodeid		in eger		DEFAULT '0'	NOT NULL,\
	 able_name		varchar(64)		DEFAULT ''	NOT NULL,\
	field_name		varchar(64)		DEFAULT ''	NOT NULL,\
	nex id		bigin 		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (nodeid, able_name,field_name)\
) wi h OIDS;\
CREATE TABLE h p es  (\
	h p es id		bigin 		DEFAULT '0'	NOT NULL,\
	name		varchar(64)		DEFAULT ''	NOT NULL,\
	applica ionid		bigin 		DEFAULT '0'	NOT NULL,\
	las check		in eger		DEFAULT '0'	NOT NULL,\
	nex check		in eger		DEFAULT '0'	NOT NULL,\
	curs a e		in eger		DEFAULT '0'	NOT NULL,\
	curs ep		in eger		DEFAULT '0'	NOT NULL,\
	las faileds ep		in eger		DEFAULT '0'	NOT NULL,\
	delay		in eger		DEFAULT '60'	NOT NULL,\
	s a us		in eger		DEFAULT '0'	NOT NULL,\
	macros		 ex 		DEFAULT ''	NOT NULL,\
	agen 		varchar(255)		DEFAULT ''	NOT NULL,\
	 ime		numeric(16,4)		DEFAULT '0'	NOT NULL,\
	error		varchar(255)		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (h p es id)\
) wi h OIDS;\
CREATE INDEX h p es _h p es _1 on h p es  (applica ionid);\
CREATE TABLE h ps ep (\
	h ps epid		bigin 		DEFAULT '0'	NOT NULL,\
	h p es id		bigin 		DEFAULT '0'	NOT NULL,\
	name		varchar(64)		DEFAULT ''	NOT NULL,\
	no		in eger		DEFAULT '0'	NOT NULL,\
	url		varchar(255)		DEFAULT ''	NOT NULL,\
	 imeou 		in eger		DEFAULT '30'	NOT NULL,\
	pos s		 ex 		DEFAULT ''	NOT NULL,\
	required		varchar(255)		DEFAULT ''	NOT NULL,\
	s a us_codes		varchar(255)		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (h ps epid)\
) wi h OIDS;\
CREATE INDEX h ps ep_h ps ep_1 on h ps ep (h p es id);\
CREATE TABLE h ps epi em (\
	h ps epi emid		bigin 		DEFAULT '0'	NOT NULL,\
	h ps epid		bigin 		DEFAULT '0'	NOT NULL,\
	i emid		bigin 		DEFAULT '0'	NOT NULL,\
	 ype		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (h ps epi emid)\
) wi h OIDS;\
CREATE UNIQUE INDEX h ps epi em_h ps epi em_1 on h ps epi em (h ps epid,i emid);\
CREATE TABLE h p es i em (\
	h p es i emid		bigin 		DEFAULT '0'	NOT NULL,\
	h p es id		bigin 		DEFAULT '0'	NOT NULL,\
	i emid		bigin 		DEFAULT '0'	NOT NULL,\
	 ype		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (h p es i emid)\
) wi h OIDS;\
CREATE UNIQUE INDEX h p es i em_h p es i em_1 on h p es i em (h p es id,i emid);\
CREATE TABLE nodes (\
	nodeid		in eger		DEFAULT '0'	NOT NULL,\
	name		varchar(64)		DEFAULT '0'	NOT NULL,\
	 imezone		in eger		DEFAULT '0'	NOT NULL,\
	ip		varchar(39)		DEFAULT ''	NOT NULL,\
	por 		in eger		DEFAULT '10051'	NOT NULL,\
	slave_his ory		in eger		DEFAULT '30'	NOT NULL,\
	slave_ rends		in eger		DEFAULT '365'	NOT NULL,\
	node ype		in eger		DEFAULT '0'	NOT NULL,\
	mas erid		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (nodeid)\
) wi h OIDS;\
CREATE TABLE node_cksum (\
	nodeid		in eger		DEFAULT '0'	NOT NULL,\
	 ablename		varchar(64)		DEFAULT ''	NOT NULL,\
	recordid		bigin 		DEFAULT '0'	NOT NULL,\
	cksum ype		in eger		DEFAULT '0'	NOT NULL,\
	cksum		 ex 		DEFAULT ''	NOT NULL,\
	sync		char(128)		DEFAULT ''	NOT NULL\
) wi h OIDS;\
CREATE INDEX node_cksum_cksum_1 on node_cksum (nodeid, ablename,recordid,cksum ype);\
CREATE TABLE services_ imes (\
	 imeid		bigin 		DEFAULT '0'	NOT NULL,\
	serviceid		bigin 		DEFAULT '0'	NOT NULL,\
	 ype		in eger		DEFAULT '0'	NOT NULL,\
	 s_from		in eger		DEFAULT '0'	NOT NULL,\
	 s_ o		in eger		DEFAULT '0'	NOT NULL,\
	no e		varchar(255)		DEFAULT ''	NOT NULL,\
	PRIMARY KEY ( imeid)\
) wi h OIDS;\
CREATE INDEX services_ imes_ imes_1 on services_ imes (serviceid, ype, s_from, s_ o);\
CREATE TABLE aler s (\
	aler id		bigin 		DEFAULT '0'	NOT NULL,\
	ac ionid		bigin 		DEFAULT '0'	NOT NULL,\
	even id		bigin 		DEFAULT '0'	NOT NULL,\
	userid		bigin 		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	media ypeid		bigin 		DEFAULT '0'	NOT NULL,\
	send o		varchar(100)		DEFAULT ''	NOT NULL,\
	subjec 		varchar(255)		DEFAULT ''	NOT NULL,\
	message		 ex 		DEFAULT ''	NOT NULL,\
	s a us		in eger		DEFAULT '0'	NOT NULL,\
	re ries		in eger		DEFAULT '0'	NOT NULL,\
	error		varchar(128)		DEFAULT ''	NOT NULL,\
	nex check		in eger		DEFAULT '0'	NOT NULL,\
	esc_s ep		in eger		DEFAULT '0'	NOT NULL,\
	aler ype		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (aler id)\
) wi h OIDS;\
CREATE INDEX aler s_1 on aler s (ac ionid);\
CREATE INDEX aler s_2 on aler s (clock);\
CREATE INDEX aler s_3 on aler s (even id);\
CREATE INDEX aler s_4 on aler s (s a us,re ries);\
CREATE INDEX aler s_5 on aler s (media ypeid);\
CREATE INDEX aler s_6 on aler s (userid);\
CREATE TABLE his ory (\
	i emid		bigin 		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	value		numeric(16,4)		DEFAULT '0.0000'	NOT NULL\
) wi h OIDS;\
CREATE INDEX his ory_1 on his ory (i emid,clock);\
CREATE TABLE his ory_sync (\
	id		serial			NOT NULL,\
	nodeid		bigin 		DEFAULT '0'	NOT NULL,\
	i emid		bigin 		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	value		numeric(16,4)		DEFAULT '0.0000'	NOT NULL,\
	PRIMARY KEY (id)\
) wi h OIDS;\
CREATE INDEX his ory_sync_1 on his ory_sync (nodeid,id);\
CREATE TABLE his ory_uin  (\
	i emid		bigin 		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	value		bigin 		DEFAULT '0'	NOT NULL\
) wi h OIDS;\
CREATE INDEX his ory_uin _1 on his ory_uin  (i emid,clock);\
CREATE TABLE his ory_uin _sync (\
	id		serial			NOT NULL,\
	nodeid		bigin 		DEFAULT '0'	NOT NULL,\
	i emid		bigin 		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	value		bigin 		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (id)\
) wi h OIDS;\
CREATE INDEX his ory_uin _sync_1 on his ory_uin _sync (nodeid,id);\
CREATE TABLE his ory_s r (\
	i emid		bigin 		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	value		varchar(255)		DEFAULT ''	NOT NULL\
) wi h OIDS;\
CREATE INDEX his ory_s r_1 on his ory_s r (i emid,clock);\
CREATE TABLE his ory_s r_sync (\
	id		serial			NOT NULL,\
	nodeid		bigin 		DEFAULT '0'	NOT NULL,\
	i emid		bigin 		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	value		varchar(255)		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (id)\
) wi h OIDS;\
CREATE INDEX his ory_s r_sync_1 on his ory_s r_sync (nodeid,id);\
CREATE TABLE his ory_log (\
	id		bigin 		DEFAULT '0'	NOT NULL,\
	i emid		bigin 		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	 imes amp		in eger		DEFAULT '0'	NOT NULL,\
	source		varchar(64)		DEFAULT ''	NOT NULL,\
	severi y		in eger		DEFAULT '0'	NOT NULL,\
	value		 ex 		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (id)\
) wi h OIDS;\
CREATE INDEX his ory_log_1 on his ory_log (i emid,clock);\
CREATE TABLE his ory_ ex  (\
	id		bigin 		DEFAULT '0'	NOT NULL,\
	i emid		bigin 		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	value		 ex 		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (id)\
) wi h OIDS;\
CREATE INDEX his ory_ ex _1 on his ory_ ex  (i emid,clock);\
CREATE TABLE proxy_his ory (\
	id		serial			NOT NULL,\
	i emid		bigin 		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	 imes amp		in eger		DEFAULT '0'	NOT NULL,\
	source		varchar(64)		DEFAULT ''	NOT NULL,\
	severi y		in eger		DEFAULT '0'	NOT NULL,\
	value		 ex 		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (id)\
) wi h OIDS;\
CREATE INDEX proxy_his ory_1 on proxy_his ory (clock);\
CREATE TABLE proxy_dhis ory (\
	id		serial			NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	druleid		bigin 		DEFAULT '0'	NOT NULL,\
	 ype		in eger		DEFAULT '0'	NOT NULL,\
	ip		varchar(39)		DEFAULT ''	NOT NULL,\
	por 		in eger		DEFAULT '0'	NOT NULL,\
	key_		varchar(255)		DEFAULT '0'	NOT NULL,\
	value		varchar(255)		DEFAULT '0'	NOT NULL,\
	s a us		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (id)\
) wi h OIDS;\
CREATE INDEX proxy_dhis ory_1 on proxy_dhis ory (clock);\
CREATE TABLE even s (\
	even id		bigin 		DEFAULT '0'	NOT NULL,\
	source		in eger		DEFAULT '0'	NOT NULL,\
	objec 		in eger		DEFAULT '0'	NOT NULL,\
	objec id		bigin 		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	value		in eger		DEFAULT '0'	NOT NULL,\
	acknowledged		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (even id)\
) wi h OIDS;\
CREATE INDEX even s_1 on even s (objec ,objec id,even id);\
CREATE INDEX even s_2 on even s (clock);\
CREATE TABLE  rends (\
	i emid		bigin 		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	num		in eger		DEFAULT '0'	NOT NULL,\
	value_min		numeric(16,4)		DEFAULT '0.0000'	NOT NULL,\
	value_avg		numeric(16,4)		DEFAULT '0.0000'	NOT NULL,\
	value_max		numeric(16,4)		DEFAULT '0.0000'	NOT NULL,\
	PRIMARY KEY (i emid,clock)\
) wi h OIDS;\
CREATE TABLE  rends_uin  (\
	i emid		bigin 		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	num		in eger		DEFAULT '0'	NOT NULL,\
	value_min		bigin 		DEFAULT '0'	NOT NULL,\
	value_avg		bigin 		DEFAULT '0'	NOT NULL,\
	value_max		bigin 		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (i emid,clock)\
) wi h OIDS;\
CREATE TABLE acknowledges (\
	acknowledgeid		bigin 		DEFAULT '0'	NOT NULL,\
	userid		bigin 		DEFAULT '0'	NOT NULL,\
	even id		bigin 		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	message		varchar(255)		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (acknowledgeid)\
) wi h OIDS;\
CREATE INDEX acknowledges_1 on acknowledges (userid);\
CREATE INDEX acknowledges_2 on acknowledges (even id);\
CREATE INDEX acknowledges_3 on acknowledges (clock);\
CREATE TABLE audi log (\
	audi id		bigin 		DEFAULT '0'	NOT NULL,\
	userid		bigin 		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	ac ion		in eger		DEFAULT '0'	NOT NULL,\
	resource ype		in eger		DEFAULT '0'	NOT NULL,\
	de ails		varchar(128)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (audi id)\
) wi h OIDS;\
CREATE INDEX audi log_1 on audi log (userid,clock);\
CREATE INDEX audi log_2 on audi log (clock);\
CREATE TABLE service_alarms (\
	servicealarmid		bigin 		DEFAULT '0'	NOT NULL,\
	serviceid		bigin 		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	value		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (servicealarmid)\
) wi h OIDS;\
CREATE INDEX service_alarms_1 on service_alarms (serviceid,clock);\
CREATE INDEX service_alarms_2 on service_alarms (clock);\
CREATE TABLE ac ions (\
	ac ionid		bigin 		DEFAULT '0'	NOT NULL,\
	name		varchar(255)		DEFAULT ''	NOT NULL,\
	even source		in eger		DEFAULT '0'	NOT NULL,\
	eval ype		in eger		DEFAULT '0'	NOT NULL,\
	s a us		in eger		DEFAULT '0'	NOT NULL,\
	esc_period		in eger		DEFAULT '0'	NOT NULL,\
	def_shor da a		varchar(255)		DEFAULT ''	NOT NULL,\
	def_longda a		 ex 		DEFAULT ''	NOT NULL,\
	recovery_msg		in eger		DEFAULT '0'	NOT NULL,\
	r_shor da a		varchar(255)		DEFAULT ''	NOT NULL,\
	r_longda a		 ex 		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (ac ionid)\
) wi h OIDS;\
CREATE TABLE opera ions (\
	opera ionid		bigin 		DEFAULT '0'	NOT NULL,\
	ac ionid		bigin 		DEFAULT '0'	NOT NULL,\
	opera ion ype		in eger		DEFAULT '0'	NOT NULL,\
	objec 		in eger		DEFAULT '0'	NOT NULL,\
	objec id		bigin 		DEFAULT '0'	NOT NULL,\
	shor da a		varchar(255)		DEFAULT ''	NOT NULL,\
	longda a		 ex 		DEFAULT ''	NOT NULL,\
	esc_period		in eger		DEFAULT '0'	NOT NULL,\
	esc_s ep_from		in eger		DEFAULT '0'	NOT NULL,\
	esc_s ep_ o		in eger		DEFAULT '0'	NOT NULL,\
	defaul _msg		in eger		DEFAULT '0'	NOT NULL,\
	eval ype		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (opera ionid)\
) wi h OIDS;\
CREATE INDEX opera ions_1 on opera ions (ac ionid);\
CREATE TABLE opcondi ions (\
	opcondi ionid		bigin 		DEFAULT '0'	NOT NULL,\
	opera ionid		bigin 		DEFAULT '0'	NOT NULL,\
	condi ion ype		in eger		DEFAULT '0'	NOT NULL,\
	opera or		in eger		DEFAULT '0'	NOT NULL,\
	value		varchar(255)		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (opcondi ionid)\
) wi h OIDS;\
CREATE INDEX opcondi ions_1 on opcondi ions (opera ionid);\
CREATE TABLE escala ions (\
	escala ionid		bigin 		DEFAULT '0'	NOT NULL,\
	ac ionid		bigin 		DEFAULT '0'	NOT NULL,\
	 riggerid		bigin 		DEFAULT '0'	NOT NULL,\
	even id		bigin 		DEFAULT '0'	NOT NULL,\
	r_even id		bigin 		DEFAULT '0'	NOT NULL,\
	nex check		in eger		DEFAULT '0'	NOT NULL,\
	esc_s ep		in eger		DEFAULT '0'	NOT NULL,\
	s a us		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (escala ionid)\
) wi h OIDS;\
CREATE INDEX escala ions_1 on escala ions (ac ionid, riggerid);\
CREATE TABLE applica ions (\
	applica ionid		bigin 		DEFAULT '0'	NOT NULL,\
	hos id		bigin 		DEFAULT '0'	NOT NULL,\
	name		varchar(255)		DEFAULT ''	NOT NULL,\
	 empla eid		bigin 		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (applica ionid)\
) wi h OIDS;\
CREATE INDEX applica ions_1 on applica ions ( empla eid);\
CREATE UNIQUE INDEX applica ions_2 on applica ions (hos id,name);\
CREATE TABLE condi ions (\
	condi ionid		bigin 		DEFAULT '0'	NOT NULL,\
	ac ionid		bigin 		DEFAULT '0'	NOT NULL,\
	condi ion ype		in eger		DEFAULT '0'	NOT NULL,\
	opera or		in eger		DEFAULT '0'	NOT NULL,\
	value		varchar(255)		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (condi ionid)\
) wi h OIDS;\
CREATE INDEX condi ions_1 on condi ions (ac ionid);\
CREATE TABLE config (\
	configid		bigin 		DEFAULT '0'	NOT NULL,\
	aler _his ory		in eger		DEFAULT '0'	NOT NULL,\
	even _his ory		in eger		DEFAULT '0'	NOT NULL,\
	refresh_unsuppor ed		in eger		DEFAULT '0'	NOT NULL,\
	work_period		varchar(100)		DEFAULT '1-5,00:00-24:00'	NOT NULL,\
	aler _usrgrpid		bigin 		DEFAULT '0'	NOT NULL,\
	even _ack_enable		in eger		DEFAULT '1'	NOT NULL,\
	even _expire		in eger		DEFAULT '7'	NOT NULL,\
	even _show_max		in eger		DEFAULT '100'	NOT NULL,\
	defaul _ heme		varchar(128)		DEFAULT 'defaul .css'	NOT NULL,\
	au hen ica ion_ ype		in eger		DEFAULT 0	NOT NULL,\
	ldap_hos 		varchar(255)		DEFAULT ''	NOT NULL,\
	ldap_por 		in eger		DEFAULT 389	NOT NULL,\
	ldap_base_dn		varchar(255)		DEFAULT ''	NOT NULL,\
	ldap_bind_dn		varchar(255)		DEFAULT ''	NOT NULL,\
	ldap_bind_password		varchar(128)		DEFAULT ''	NOT NULL,\
	ldap_search_a ribu e		varchar(128)		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (configid)\
) wi h OIDS;\
CREATE TABLE func ions (\
	func ionid		bigin 		DEFAULT '0'	NOT NULL,\
	i emid		bigin 		DEFAULT '0'	NOT NULL,\
	 riggerid		bigin 		DEFAULT '0'	NOT NULL,\
	las value		varchar(255)			,\
	func ion		varchar(12)		DEFAULT ''	NOT NULL,\
	parame er		varchar(255)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (func ionid)\
) wi h OIDS;\
CREATE INDEX func ions_1 on func ions ( riggerid);\
CREATE INDEX func ions_2 on func ions (i emid,func ion,parame er);\
CREATE TABLE graphs (\
	graphid		bigin 		DEFAULT '0'	NOT NULL,\
	name		varchar(128)		DEFAULT ''	NOT NULL,\
	wid h		in eger		DEFAULT '0'	NOT NULL,\
	heigh 		in eger		DEFAULT '0'	NOT NULL,\
	yaxis ype		in eger		DEFAULT '0'	NOT NULL,\
	yaxismin		numeric(16,4)		DEFAULT '0'	NOT NULL,\
	yaxismax		numeric(16,4)		DEFAULT '0'	NOT NULL,\
	 empla eid		bigin 		DEFAULT '0'	NOT NULL,\
	show_work_period		in eger		DEFAULT '1'	NOT NULL,\
	show_ riggers		in eger		DEFAULT '1'	NOT NULL,\
	graph ype		in eger		DEFAULT '0'	NOT NULL,\
	show_legend		in eger		DEFAULT '0'	NOT NULL,\
	show_3d		in eger		DEFAULT '0'	NOT NULL,\
	percen _lef 		numeric(16,4)		DEFAULT '0'	NOT NULL,\
	percen _righ 		numeric(16,4)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (graphid)\
) wi h OIDS;\
CREATE INDEX graphs_graphs_1 on graphs (name);\
CREATE TABLE graphs_i ems (\
	gi emid		bigin 		DEFAULT '0'	NOT NULL,\
	graphid		bigin 		DEFAULT '0'	NOT NULL,\
	i emid		bigin 		DEFAULT '0'	NOT NULL,\
	draw ype		in eger		DEFAULT '0'	NOT NULL,\
	sor order		in eger		DEFAULT '0'	NOT NULL,\
	color		varchar(32)		DEFAULT '009600'	NOT NULL,\
	yaxisside		in eger		DEFAULT '1'	NOT NULL,\
	calc_fnc		in eger		DEFAULT '2'	NOT NULL,\
	 ype		in eger		DEFAULT '0'	NOT NULL,\
	periods_cn 		in eger		DEFAULT '5'	NOT NULL,\
	PRIMARY KEY (gi emid)\
) wi h OIDS;\
CREATE TABLE groups (\
	groupid		bigin 		DEFAULT '0'	NOT NULL,\
	name		varchar(64)		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (groupid)\
) wi h OIDS;\
CREATE INDEX groups_1 on groups (name);\
CREATE TABLE help_i ems (\
	i em ype		in eger		DEFAULT '0'	NOT NULL,\
	key_		varchar(255)		DEFAULT ''	NOT NULL,\
	descrip ion		varchar(255)		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (i em ype,key_)\
) wi h OIDS;\
CREATE TABLE hos s (\
	hos id		bigin 		DEFAULT '0'	NOT NULL,\
	proxy_hos id		bigin 		DEFAULT '0'	NOT NULL,\
	hos 		varchar(64)		DEFAULT ''	NOT NULL,\
	dns		varchar(64)		DEFAULT ''	NOT NULL,\
	useip		in eger		DEFAULT '1'	NOT NULL,\
	ip		varchar(39)		DEFAULT '127.0.0.1'	NOT NULL,\
	por 		in eger		DEFAULT '10050'	NOT NULL,\
	s a us		in eger		DEFAULT '0'	NOT NULL,\
	disable_un il		in eger		DEFAULT '0'	NOT NULL,\
	error		varchar(128)		DEFAULT ''	NOT NULL,\
	available		in eger		DEFAULT '0'	NOT NULL,\
	errors_from		in eger		DEFAULT '0'	NOT NULL,\
	las access		in eger		DEFAULT '0'	NOT NULL,\
	inby es		bigin 		DEFAULT '0'	NOT NULL,\
	ou by es		bigin 		DEFAULT '0'	NOT NULL,\
	useipmi		in eger		DEFAULT '0'	NOT NULL,\
	ipmi_por 		in eger		DEFAULT '623'	NOT NULL,\
	ipmi_au h ype		in eger		DEFAULT '0'	NOT NULL,\
	ipmi_privilege		in eger		DEFAULT '2'	NOT NULL,\
	ipmi_username		varchar(16)		DEFAULT ''	NOT NULL,\
	ipmi_password		varchar(20)		DEFAULT ''	NOT NULL,\
	ipmi_disable_un il		in eger		DEFAULT '0'	NOT NULL,\
	ipmi_available		in eger		DEFAULT '0'	NOT NULL,\
	snmp_disable_un il		in eger		DEFAULT '0'	NOT NULL,\
	snmp_available		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (hos id)\
) wi h OIDS;\
CREATE INDEX hos s_1 on hos s (hos );\
CREATE INDEX hos s_2 on hos s (s a us);\
CREATE INDEX hos s_3 on hos s (proxy_hos id);\
CREATE TABLE hos s_groups (\
	hos groupid		bigin 		DEFAULT '0'	NOT NULL,\
	hos id		bigin 		DEFAULT '0'	NOT NULL,\
	groupid		bigin 		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (hos groupid)\
) wi h OIDS;\
CREATE INDEX hos s_groups_groups_1 on hos s_groups (hos id,groupid);\
CREATE TABLE hos s_profiles (\
	hos id		bigin 		DEFAULT '0'	NOT NULL,\
	device ype		varchar(64)		DEFAULT ''	NOT NULL,\
	name		varchar(64)		DEFAULT ''	NOT NULL,\
	os		varchar(64)		DEFAULT ''	NOT NULL,\
	serialno		varchar(64)		DEFAULT ''	NOT NULL,\
	 ag		varchar(64)		DEFAULT ''	NOT NULL,\
	macaddress		varchar(64)		DEFAULT ''	NOT NULL,\
	hardware		 ex 		DEFAULT ''	NOT NULL,\
	sof ware		 ex 		DEFAULT ''	NOT NULL,\
	con ac 		 ex 		DEFAULT ''	NOT NULL,\
	loca ion		 ex 		DEFAULT ''	NOT NULL,\
	no es		 ex 		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (hos id)\
) wi h OIDS;\
CREATE TABLE hos s_profiles_ex  (\
	hos id		bigin 		DEFAULT '0'	NOT NULL,\
	device_alias		varchar(64)		DEFAULT ''	NOT NULL,\
	device_ ype		varchar(64)		DEFAULT ''	NOT NULL,\
	device_chassis		varchar(64)		DEFAULT ''	NOT NULL,\
	device_os		varchar(64)		DEFAULT ''	NOT NULL,\
	device_os_shor 		varchar(64)		DEFAULT ''	NOT NULL,\
	device_hw_arch		varchar(32)		DEFAULT ''	NOT NULL,\
	device_serial		varchar(64)		DEFAULT ''	NOT NULL,\
	device_model		varchar(64)		DEFAULT ''	NOT NULL,\
	device_ ag		varchar(64)		DEFAULT ''	NOT NULL,\
	device_vendor		varchar(64)		DEFAULT ''	NOT NULL,\
	device_con rac 		varchar(64)		DEFAULT ''	NOT NULL,\
	device_who		varchar(64)		DEFAULT ''	NOT NULL,\
	device_s a us		varchar(64)		DEFAULT ''	NOT NULL,\
	device_app_01		varchar(64)		DEFAULT ''	NOT NULL,\
	device_app_02		varchar(64)		DEFAULT ''	NOT NULL,\
	device_app_03		varchar(64)		DEFAULT ''	NOT NULL,\
	device_app_04		varchar(64)		DEFAULT ''	NOT NULL,\
	device_app_05		varchar(64)		DEFAULT ''	NOT NULL,\
	device_url_1		varchar(255)		DEFAULT ''	NOT NULL,\
	device_url_2		varchar(255)		DEFAULT ''	NOT NULL,\
	device_url_3		varchar(255)		DEFAULT ''	NOT NULL,\
	device_ne works		 ex 		DEFAULT ''	NOT NULL,\
	device_no es		 ex 		DEFAULT ''	NOT NULL,\
	device_hardware		 ex 		DEFAULT ''	NOT NULL,\
	device_sof ware		 ex 		DEFAULT ''	NOT NULL,\
	ip_subne _mask		varchar(39)		DEFAULT ''	NOT NULL,\
	ip_rou er		varchar(39)		DEFAULT ''	NOT NULL,\
	ip_macaddress		varchar(64)		DEFAULT ''	NOT NULL,\
	oob_ip		varchar(39)		DEFAULT ''	NOT NULL,\
	oob_subne _mask		varchar(39)		DEFAULT ''	NOT NULL,\
	oob_rou er		varchar(39)		DEFAULT ''	NOT NULL,\
	da e_hw_buy		varchar(64)		DEFAULT ''	NOT NULL,\
	da e_hw_ins all		varchar(64)		DEFAULT ''	NOT NULL,\
	da e_hw_expiry		varchar(64)		DEFAULT ''	NOT NULL,\
	da e_hw_decomm		varchar(64)		DEFAULT ''	NOT NULL,\
	si e_s ree _1		varchar(128)		DEFAULT ''	NOT NULL,\
	si e_s ree _2		varchar(128)		DEFAULT ''	NOT NULL,\
	si e_s ree _3		varchar(128)		DEFAULT ''	NOT NULL,\
	si e_ci y		varchar(128)		DEFAULT ''	NOT NULL,\
	si e_s a e		varchar(64)		DEFAULT ''	NOT NULL,\
	si e_coun ry		varchar(64)		DEFAULT ''	NOT NULL,\
	si e_zip		varchar(64)		DEFAULT ''	NOT NULL,\
	si e_rack		varchar(128)		DEFAULT ''	NOT NULL,\
	si e_no es		 ex 		DEFAULT ''	NOT NULL,\
	poc_1_name		varchar(128)		DEFAULT ''	NOT NULL,\
	poc_1_email		varchar(128)		DEFAULT ''	NOT NULL,\
	poc_1_phone_1		varchar(64)		DEFAULT ''	NOT NULL,\
	poc_1_phone_2		varchar(64)		DEFAULT ''	NOT NULL,\
	poc_1_cell		varchar(64)		DEFAULT ''	NOT NULL,\
	poc_1_screen		varchar(64)		DEFAULT ''	NOT NULL,\
	poc_1_no es		 ex 		DEFAULT ''	NOT NULL,\
	poc_2_name		varchar(128)		DEFAULT ''	NOT NULL,\
	poc_2_email		varchar(128)		DEFAULT ''	NOT NULL,\
	poc_2_phone_1		varchar(64)		DEFAULT ''	NOT NULL,\
	poc_2_phone_2		varchar(64)		DEFAULT ''	NOT NULL,\
	poc_2_cell		varchar(64)		DEFAULT ''	NOT NULL,\
	poc_2_screen		varchar(64)		DEFAULT ''	NOT NULL,\
	poc_2_no es		 ex 		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (hos id)\
) wi h OIDS;\
CREATE TABLE hos s_ empla es (\
	hos empla eid		bigin 		DEFAULT '0'	NOT NULL,\
	hos id		bigin 		DEFAULT '0'	NOT NULL,\
	 empla eid		bigin 		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (hos empla eid)\
) wi h OIDS;\
CREATE UNIQUE INDEX hos s_ empla es_1 on hos s_ empla es (hos id, empla eid);\
CREATE TABLE housekeeper (\
	housekeeperid		bigin 		DEFAULT '0'	NOT NULL,\
	 ablename		varchar(64)		DEFAULT ''	NOT NULL,\
	field		varchar(64)		DEFAULT ''	NOT NULL,\
	value		bigin 		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (housekeeperid)\
) wi h OIDS;\
CREATE TABLE images (\
	imageid		bigin 		DEFAULT '0'	NOT NULL,\
	image ype		in eger		DEFAULT '0'	NOT NULL,\
	name		varchar(64)		DEFAULT '0'	NOT NULL,\
	image		by ea		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (imageid)\
) wi h OIDS;\
CREATE INDEX images_1 on images (image ype,name);\
CREATE TABLE i ems (\
	i emid		bigin 		DEFAULT '0'	NOT NULL,\
	 ype		in eger		DEFAULT '0'	NOT NULL,\
	snmp_communi y		varchar(64)		DEFAULT ''	NOT NULL,\
	snmp_oid		varchar(255)		DEFAULT ''	NOT NULL,\
	snmp_por 		in eger		DEFAULT '161'	NOT NULL,\
	hos id		bigin 		DEFAULT '0'	NOT NULL,\
	descrip ion		varchar(255)		DEFAULT ''	NOT NULL,\
	key_		varchar(255)		DEFAULT ''	NOT NULL,\
	delay		in eger		DEFAULT '0'	NOT NULL,\
	his ory		in eger		DEFAULT '90'	NOT NULL,\
	 rends		in eger		DEFAULT '365'	NOT NULL,\
	nex check		in eger		DEFAULT '0'	NOT NULL,\
	las value		varchar(255)			NULL,\
	las clock		in eger			NULL,\
	prevvalue		varchar(255)			NULL,\
	s a us		in eger		DEFAULT '0'	NOT NULL,\
	value_ ype		in eger		DEFAULT '0'	NOT NULL,\
	 rapper_hos s		varchar(255)		DEFAULT ''	NOT NULL,\
	uni s		varchar(10)		DEFAULT ''	NOT NULL,\
	mul iplier		in eger		DEFAULT '0'	NOT NULL,\
	del a		in eger		DEFAULT '0'	NOT NULL,\
	prevorgvalue		varchar(255)			NULL,\
	snmpv3_securi yname		varchar(64)		DEFAULT ''	NOT NULL,\
	snmpv3_securi ylevel		in eger		DEFAULT '0'	NOT NULL,\
	snmpv3_au hpassphrase		varchar(64)		DEFAULT ''	NOT NULL,\
	snmpv3_privpassphrase		varchar(64)		DEFAULT ''	NOT NULL,\
	formula		varchar(255)		DEFAULT '1'	NOT NULL,\
	error		varchar(128)		DEFAULT ''	NOT NULL,\
	las logsize		in eger		DEFAULT '0'	NOT NULL,\
	log imefm 		varchar(64)		DEFAULT ''	NOT NULL,\
	 empla eid		bigin 		DEFAULT '0'	NOT NULL,\
	valuemapid		bigin 		DEFAULT '0'	NOT NULL,\
	delay_flex		varchar(255)		DEFAULT ''	NOT NULL,\
	params		 ex 		DEFAULT ''	NOT NULL,\
	ipmi_sensor		varchar(128)		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (i emid)\
) wi h OIDS;\
CREATE UNIQUE INDEX i ems_1 on i ems (hos id,key_);\
CREATE INDEX i ems_2 on i ems (nex check);\
CREATE INDEX i ems_3 on i ems (s a us);\
CREATE INDEX i ems_4 on i ems ( empla eid);\
CREATE TABLE i ems_applica ions (\
	i emappid		bigin 		DEFAULT '0'	NOT NULL,\
	applica ionid		bigin 		DEFAULT '0'	NOT NULL,\
	i emid		bigin 		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (i emappid)\
) wi h OIDS;\
CREATE INDEX i ems_applica ions_1 on i ems_applica ions (applica ionid,i emid);\
CREATE INDEX i ems_applica ions_2 on i ems_applica ions (i emid);\
CREATE TABLE mappings (\
	mappingid		bigin 		DEFAULT '0'	NOT NULL,\
	valuemapid		bigin 		DEFAULT '0'	NOT NULL,\
	value		varchar(64)		DEFAULT ''	NOT NULL,\
	newvalue		varchar(64)		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (mappingid)\
) wi h OIDS;\
CREATE INDEX mappings_1 on mappings (valuemapid);\
CREATE TABLE media (\
	mediaid		bigin 		DEFAULT '0'	NOT NULL,\
	userid		bigin 		DEFAULT '0'	NOT NULL,\
	media ypeid		bigin 		DEFAULT '0'	NOT NULL,\
	send o		varchar(100)		DEFAULT ''	NOT NULL,\
	ac ive		in eger		DEFAULT '0'	NOT NULL,\
	severi y		in eger		DEFAULT '63'	NOT NULL,\
	period		varchar(100)		DEFAULT '1-7,00:00-23:59'	NOT NULL,\
	PRIMARY KEY (mediaid)\
) wi h OIDS;\
CREATE INDEX media_1 on media (userid);\
CREATE INDEX media_2 on media (media ypeid);\
CREATE TABLE media_ ype (\
	media ypeid		bigin 		DEFAULT '0'	NOT NULL,\
	 ype		in eger		DEFAULT '0'	NOT NULL,\
	descrip ion		varchar(100)		DEFAULT ''	NOT NULL,\
	sm p_server		varchar(255)		DEFAULT ''	NOT NULL,\
	sm p_helo		varchar(255)		DEFAULT ''	NOT NULL,\
	sm p_email		varchar(255)		DEFAULT ''	NOT NULL,\
	exec_pa h		varchar(255)		DEFAULT ''	NOT NULL,\
	gsm_modem		varchar(255)		DEFAULT ''	NOT NULL,\
	username		varchar(255)		DEFAULT ''	NOT NULL,\
	passwd		varchar(255)		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (media ypeid)\
) wi h OIDS;\
CREATE TABLE profiles (\
	profileid		bigin 		DEFAULT '0'	NOT NULL,\
	userid		bigin 		DEFAULT '0'	NOT NULL,\
	idx		varchar(96)		DEFAULT ''	NOT NULL,\
	idx2		bigin 		DEFAULT '0'	NOT NULL,\
	value_id		bigin 		DEFAULT '0'	NOT NULL,\
	value_in 		in eger		DEFAULT '0'	NOT NULL,\
	value_s r		varchar(255)		DEFAULT ''	NOT NULL,\
	source		varchar(96)		DEFAULT ''	NOT NULL,\
	 ype		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (profileid)\
) wi h OIDS;\
CREATE INDEX profiles_1 on profiles (userid,idx,idx2);\
CREATE TABLE righ s (\
	righ id		bigin 		DEFAULT '0'	NOT NULL,\
	groupid		bigin 		DEFAULT '0'	NOT NULL,\
	permission		in eger		DEFAULT '0'	NOT NULL,\
	id		bigin 			,\
	PRIMARY KEY (righ id)\
) wi h OIDS;\
CREATE INDEX righ s_1 on righ s (groupid);\
CREATE TABLE scrip s (\
	scrip id		bigin 		DEFAULT '0'	NOT NULL,\
	name		varchar(255)		DEFAULT ''	NOT NULL,\
	command		varchar(255)		DEFAULT ''	NOT NULL,\
	hos _access		in eger		DEFAULT '2'	NOT NULL,\
	usrgrpid		bigin 		DEFAULT '0'	NOT NULL,\
	groupid		bigin 		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (scrip id)\
) wi h OIDS;\
CREATE TABLE screens (\
	screenid		bigin 		DEFAULT '0'	NOT NULL,\
	name		varchar(255)		DEFAULT 'Screen'	NOT NULL,\
	hsize		in eger		DEFAULT '1'	NOT NULL,\
	vsize		in eger		DEFAULT '1'	NOT NULL,\
	PRIMARY KEY (screenid)\
) wi h OIDS;\
CREATE TABLE screens_i ems (\
	screeni emid		bigin 		DEFAULT '0'	NOT NULL,\
	screenid		bigin 		DEFAULT '0'	NOT NULL,\
	resource ype		in eger		DEFAULT '0'	NOT NULL,\
	resourceid		bigin 		DEFAULT '0'	NOT NULL,\
	wid h		in eger		DEFAULT '320'	NOT NULL,\
	heigh 		in eger		DEFAULT '200'	NOT NULL,\
	x		in eger		DEFAULT '0'	NOT NULL,\
	y		in eger		DEFAULT '0'	NOT NULL,\
	colspan		in eger		DEFAULT '0'	NOT NULL,\
	rowspan		in eger		DEFAULT '0'	NOT NULL,\
	elemen s		in eger		DEFAULT '25'	NOT NULL,\
	valign		in eger		DEFAULT '0'	NOT NULL,\
	halign		in eger		DEFAULT '0'	NOT NULL,\
	s yle		in eger		DEFAULT '0'	NOT NULL,\
	url		varchar(255)		DEFAULT ''	NOT NULL,\
	dynamic		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (screeni emid)\
) wi h OIDS;\
CREATE TABLE services (\
	serviceid		bigin 		DEFAULT '0'	NOT NULL,\
	name		varchar(128)		DEFAULT ''	NOT NULL,\
	s a us		in eger		DEFAULT '0'	NOT NULL,\
	algori hm		in eger		DEFAULT '0'	NOT NULL,\
	 riggerid		bigin 			,\
	showsla		in eger		DEFAULT '0'	NOT NULL,\
	goodsla		numeric(16,4)		DEFAULT '99.9'	NOT NULL,\
	sor order		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (serviceid)\
) wi h OIDS;\
CREATE TABLE services_links (\
	linkid		bigin 		DEFAULT '0'	NOT NULL,\
	serviceupid		bigin 		DEFAULT '0'	NOT NULL,\
	servicedownid		bigin 		DEFAULT '0'	NOT NULL,\
	sof 		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (linkid)\
) wi h OIDS;\
CREATE INDEX services_links_links_1 on services_links (servicedownid);\
CREATE UNIQUE INDEX services_links_links_2 on services_links (serviceupid,servicedownid);\
CREATE TABLE sessions (\
	sessionid		varchar(32)		DEFAULT ''	NOT NULL,\
	userid		bigin 		DEFAULT '0'	NOT NULL,\
	las access		in eger		DEFAULT '0'	NOT NULL,\
	s a us		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (sessionid)\
) wi h OIDS;\
CREATE TABLE sysmaps_links (\
	linkid		bigin 		DEFAULT '0'	NOT NULL,\
	sysmapid		bigin 		DEFAULT '0'	NOT NULL,\
	selemen id1		bigin 		DEFAULT '0'	NOT NULL,\
	selemen id2		bigin 		DEFAULT '0'	NOT NULL,\
	draw ype		in eger		DEFAULT '0'	NOT NULL,\
	color		varchar(6)		DEFAULT '000000'	NOT NULL,\
	PRIMARY KEY (linkid)\
) wi h OIDS;\
CREATE TABLE sysmaps_link_ riggers (\
	link riggerid		bigin 		DEFAULT '0'	NOT NULL,\
	linkid		bigin 		DEFAULT '0'	NOT NULL,\
	 riggerid		bigin 		DEFAULT '0'	NOT NULL,\
	draw ype		in eger		DEFAULT '0'	NOT NULL,\
	color		varchar(6)		DEFAULT '000000'	NOT NULL,\
	PRIMARY KEY (link riggerid)\
) wi h OIDS;\
CREATE UNIQUE INDEX sysmaps_link_ riggers_1 on sysmaps_link_ riggers (linkid, riggerid);\
CREATE TABLE sysmaps_elemen s (\
	selemen id		bigin 		DEFAULT '0'	NOT NULL,\
	sysmapid		bigin 		DEFAULT '0'	NOT NULL,\
	elemen id		bigin 		DEFAULT '0'	NOT NULL,\
	elemen ype		in eger		DEFAULT '0'	NOT NULL,\
	iconid_off		bigin 		DEFAULT '0'	NOT NULL,\
	iconid_on		bigin 		DEFAULT '0'	NOT NULL,\
	iconid_unknown		bigin 		DEFAULT '0'	NOT NULL,\
	label		varchar(128)		DEFAULT ''	NOT NULL,\
	label_loca ion		in eger			NULL,\
	x		in eger		DEFAULT '0'	NOT NULL,\
	y		in eger		DEFAULT '0'	NOT NULL,\
	url		varchar(255)		DEFAULT ''	NOT NULL,\
	iconid_disabled		bigin 		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (selemen id)\
) wi h OIDS;\
CREATE TABLE sysmaps (\
	sysmapid		bigin 		DEFAULT '0'	NOT NULL,\
	name		varchar(128)		DEFAULT ''	NOT NULL,\
	wid h		in eger		DEFAULT '0'	NOT NULL,\
	heigh 		in eger		DEFAULT '0'	NOT NULL,\
	backgroundid		bigin 		DEFAULT '0'	NOT NULL,\
	label_ ype		in eger		DEFAULT '0'	NOT NULL,\
	label_loca ion		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (sysmapid)\
) wi h OIDS;\
CREATE INDEX sysmaps_1 on sysmaps (name);\
CREATE TABLE  riggers (\
	 riggerid		bigin 		DEFAULT '0'	NOT NULL,\
	expression		varchar(255)		DEFAULT ''	NOT NULL,\
	descrip ion		varchar(255)		DEFAULT ''	NOT NULL,\
	url		varchar(255)		DEFAULT ''	NOT NULL,\
	s a us		in eger		DEFAULT '0'	NOT NULL,\
	value		in eger		DEFAULT '0'	NOT NULL,\
	priori y		in eger		DEFAULT '0'	NOT NULL,\
	las change		in eger		DEFAULT '0'	NOT NULL,\
	dep_level		in eger		DEFAULT '0'	NOT NULL,\
	commen s		 ex 		DEFAULT ''	NOT NULL,\
	error		varchar(128)		DEFAULT ''	NOT NULL,\
	 empla eid		bigin 		DEFAULT '0'	NOT NULL,\
	 ype		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY ( riggerid)\
) wi h OIDS;\
CREATE INDEX  riggers_1 on  riggers (s a us);\
CREATE INDEX  riggers_2 on  riggers (value);\
CREATE TABLE  rigger_depends (\
	 riggerdepid		bigin 		DEFAULT '0'	NOT NULL,\
	 riggerid_down		bigin 		DEFAULT '0'	NOT NULL,\
	 riggerid_up		bigin 		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY ( riggerdepid)\
) wi h OIDS;\
CREATE INDEX  rigger_depends_1 on  rigger_depends ( riggerid_down, riggerid_up);\
CREATE INDEX  rigger_depends_2 on  rigger_depends ( riggerid_up);\
CREATE TABLE users (\
	userid		bigin 		DEFAULT '0'	NOT NULL,\
	alias		varchar(100)		DEFAULT ''	NOT NULL,\
	name		varchar(100)		DEFAULT ''	NOT NULL,\
	surname		varchar(100)		DEFAULT ''	NOT NULL,\
	passwd		char(32)		DEFAULT ''	NOT NULL,\
	url		varchar(255)		DEFAULT ''	NOT NULL,\
	au ologin		in eger		DEFAULT '0'	NOT NULL,\
	au ologou 		in eger		DEFAULT '900'	NOT NULL,\
	lang		varchar(5)		DEFAULT 'en_gb'	NOT NULL,\
	refresh		in eger		DEFAULT '30'	NOT NULL,\
	 ype		in eger		DEFAULT '0'	NOT NULL,\
	 heme		varchar(128)		DEFAULT 'defaul .css'	NOT NULL,\
	a emp _failed		in eger		DEFAULT 0	NOT NULL,\
	a emp _ip		varchar(39)		DEFAULT ''	NOT NULL,\
	a emp _clock		in eger		DEFAULT 0	NOT NULL,\
	PRIMARY KEY (userid)\
) wi h OIDS;\
CREATE INDEX users_1 on users (alias);\
CREATE TABLE usrgrp (\
	usrgrpid		bigin 		DEFAULT '0'	NOT NULL,\
	name		varchar(64)		DEFAULT ''	NOT NULL,\
	gui_access		in eger		DEFAULT '0'	NOT NULL,\
	users_s a us		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (usrgrpid)\
) wi h OIDS;\
CREATE INDEX usrgrp_1 on usrgrp (name);\
CREATE TABLE users_groups (\
	id		bigin 		DEFAULT '0'	NOT NULL,\
	usrgrpid		bigin 		DEFAULT '0'	NOT NULL,\
	userid		bigin 		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (id)\
) wi h OIDS;\
CREATE INDEX users_groups_1 on users_groups (usrgrpid,userid);\
CREATE TABLE valuemaps (\
	valuemapid		bigin 		DEFAULT '0'	NOT NULL,\
	name		varchar(64)		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (valuemapid)\
) wi h OIDS;\
CREATE INDEX valuemaps_1 on valuemaps (name);\
"};
#elif HAVE_ORACLE
const char *db_schema = {"\
CREATE TABLE slideshows (\
	slideshowid		number(20)		DEFAULT '0'	NOT NULL,\
	name		varchar2(255)		DEFAULT ''	,\
	delay		number(10)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (slideshowid)\
);\
CREATE TABLE slides (\
	slideid		number(20)		DEFAULT '0'	NOT NULL,\
	slideshowid		number(20)		DEFAULT '0'	NOT NULL,\
	screenid		number(20)		DEFAULT '0'	NOT NULL,\
	s ep		number(10)		DEFAULT '0'	NOT NULL,\
	delay		number(10)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (slideid)\
);\
CREATE INDEX slides_slides_1 on slides (slideshowid);\
CREATE TABLE drules (\
	druleid		number(20)		DEFAULT '0'	NOT NULL,\
	proxy_hos id		number(20)		DEFAULT '0'	NOT NULL,\
	name		varchar2(255)		DEFAULT ''	,\
	iprange		varchar2(255)		DEFAULT ''	,\
	delay		number(10)		DEFAULT '0'	NOT NULL,\
	nex check		number(10)		DEFAULT '0'	NOT NULL,\
	s a us		number(10)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (druleid)\
);\
CREATE TABLE dchecks (\
	dcheckid		number(20)		DEFAULT '0'	NOT NULL,\
	druleid		number(20)		DEFAULT '0'	NOT NULL,\
	 ype		number(10)		DEFAULT '0'	NOT NULL,\
	key_		varchar2(255)		DEFAULT '0'	,\
	snmp_communi y		varchar2(255)		DEFAULT '0'	,\
	por s		varchar2(255)		DEFAULT '0'	,\
	PRIMARY KEY (dcheckid)\
);\
CREATE TABLE dhos s (\
	dhos id		number(20)		DEFAULT '0'	NOT NULL,\
	druleid		number(20)		DEFAULT '0'	NOT NULL,\
	ip		varchar2(39)		DEFAULT ''	,\
	s a us		number(10)		DEFAULT '0'	NOT NULL,\
	las up		number(10)		DEFAULT '0'	NOT NULL,\
	las down		number(10)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (dhos id)\
);\
CREATE TABLE dservices (\
	dserviceid		number(20)		DEFAULT '0'	NOT NULL,\
	dhos id		number(20)		DEFAULT '0'	NOT NULL,\
	 ype		number(10)		DEFAULT '0'	NOT NULL,\
	key_		varchar2(255)		DEFAULT '0'	,\
	value		varchar2(255)		DEFAULT '0'	,\
	por 		number(10)		DEFAULT '0'	NOT NULL,\
	s a us		number(10)		DEFAULT '0'	NOT NULL,\
	las up		number(10)		DEFAULT '0'	NOT NULL,\
	las down		number(10)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (dserviceid)\
);\
CREATE TABLE ids (\
	nodeid		number(10)		DEFAULT '0'	NOT NULL,\
	 able_name		varchar2(64)		DEFAULT ''	,\
	field_name		varchar2(64)		DEFAULT ''	,\
	nex id		number(20)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (nodeid, able_name,field_name)\
);\
CREATE TABLE h p es  (\
	h p es id		number(20)		DEFAULT '0'	NOT NULL,\
	name		varchar2(64)		DEFAULT ''	,\
	applica ionid		number(20)		DEFAULT '0'	NOT NULL,\
	las check		number(10)		DEFAULT '0'	NOT NULL,\
	nex check		number(10)		DEFAULT '0'	NOT NULL,\
	curs a e		number(10)		DEFAULT '0'	NOT NULL,\
	curs ep		number(10)		DEFAULT '0'	NOT NULL,\
	las faileds ep		number(10)		DEFAULT '0'	NOT NULL,\
	delay		number(10)		DEFAULT '60'	NOT NULL,\
	s a us		number(10)		DEFAULT '0'	NOT NULL,\
	macros		varchar2(2048)		DEFAULT ''	,\
	agen 		varchar2(255)		DEFAULT ''	,\
	 ime		number(20,4)		DEFAULT '0'	NOT NULL,\
	error		varchar2(255)		DEFAULT ''	,\
	PRIMARY KEY (h p es id)\
);\
CREATE INDEX h p es _h p es _1 on h p es  (applica ionid);\
CREATE TABLE h ps ep (\
	h ps epid		number(20)		DEFAULT '0'	NOT NULL,\
	h p es id		number(20)		DEFAULT '0'	NOT NULL,\
	name		varchar2(64)		DEFAULT ''	,\
	no		number(10)		DEFAULT '0'	NOT NULL,\
	url		varchar2(255)		DEFAULT ''	,\
	 imeou 		number(10)		DEFAULT '30'	NOT NULL,\
	pos s		varchar2(2048)		DEFAULT ''	,\
	required		varchar2(255)		DEFAULT ''	,\
	s a us_codes		varchar2(255)		DEFAULT ''	,\
	PRIMARY KEY (h ps epid)\
);\
CREATE INDEX h ps ep_h ps ep_1 on h ps ep (h p es id);\
CREATE TABLE h ps epi em (\
	h ps epi emid		number(20)		DEFAULT '0'	NOT NULL,\
	h ps epid		number(20)		DEFAULT '0'	NOT NULL,\
	i emid		number(20)		DEFAULT '0'	NOT NULL,\
	 ype		number(10)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (h ps epi emid)\
);\
CREATE UNIQUE INDEX h ps epi em_h ps epi em_1 on h ps epi em (h ps epid,i emid);\
CREATE TABLE h p es i em (\
	h p es i emid		number(20)		DEFAULT '0'	NOT NULL,\
	h p es id		number(20)		DEFAULT '0'	NOT NULL,\
	i emid		number(20)		DEFAULT '0'	NOT NULL,\
	 ype		number(10)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (h p es i emid)\
);\
CREATE UNIQUE INDEX h p es i em_h p es i em_1 on h p es i em (h p es id,i emid);\
CREATE TABLE nodes (\
	nodeid		number(10)		DEFAULT '0'	NOT NULL,\
	name		varchar2(64)		DEFAULT '0'	,\
	 imezone		number(10)		DEFAULT '0'	NOT NULL,\
	ip		varchar2(39)		DEFAULT ''	,\
	por 		number(10)		DEFAULT '10051'	NOT NULL,\
	slave_his ory		number(10)		DEFAULT '30'	NOT NULL,\
	slave_ rends		number(10)		DEFAULT '365'	NOT NULL,\
	node ype		number(10)		DEFAULT '0'	NOT NULL,\
	mas erid		number(10)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (nodeid)\
);\
CREATE TABLE node_cksum (\
	nodeid		number(10)		DEFAULT '0'	NOT NULL,\
	 ablename		varchar2(64)		DEFAULT ''	,\
	recordid		number(20)		DEFAULT '0'	NOT NULL,\
	cksum ype		number(10)		DEFAULT '0'	NOT NULL,\
	cksum		clob		DEFAULT ''	NOT NULL,\
	sync		varchar2(128)		DEFAULT ''	\
);\
CREATE INDEX node_cksum_cksum_1 on node_cksum (nodeid, ablename,recordid,cksum ype);\
CREATE TABLE services_ imes (\
	 imeid		number(20)		DEFAULT '0'	NOT NULL,\
	serviceid		number(20)		DEFAULT '0'	NOT NULL,\
	 ype		number(10)		DEFAULT '0'	NOT NULL,\
	 s_from		number(10)		DEFAULT '0'	NOT NULL,\
	 s_ o		number(10)		DEFAULT '0'	NOT NULL,\
	no e		varchar2(255)		DEFAULT ''	,\
	PRIMARY KEY ( imeid)\
);\
CREATE INDEX services_ imes_ imes_1 on services_ imes (serviceid, ype, s_from, s_ o);\
CREATE TABLE aler s (\
	aler id		number(20)		DEFAULT '0'	NOT NULL,\
	ac ionid		number(20)		DEFAULT '0'	NOT NULL,\
	even id		number(20)		DEFAULT '0'	NOT NULL,\
	userid		number(20)		DEFAULT '0'	NOT NULL,\
	clock		number(10)		DEFAULT '0'	NOT NULL,\
	media ypeid		number(20)		DEFAULT '0'	NOT NULL,\
	send o		varchar2(100)		DEFAULT ''	,\
	subjec 		varchar2(255)		DEFAULT ''	,\
	message		varchar2(2048)		DEFAULT ''	,\
	s a us		number(10)		DEFAULT '0'	NOT NULL,\
	re ries		number(10)		DEFAULT '0'	NOT NULL,\
	error		varchar2(128)		DEFAULT ''	,\
	nex check		number(10)		DEFAULT '0'	NOT NULL,\
	esc_s ep		number(10)		DEFAULT '0'	NOT NULL,\
	aler ype		number(10)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (aler id)\
);\
CREATE INDEX aler s_1 on aler s (ac ionid);\
CREATE INDEX aler s_2 on aler s (clock);\
CREATE INDEX aler s_3 on aler s (even id);\
CREATE INDEX aler s_4 on aler s (s a us,re ries);\
CREATE INDEX aler s_5 on aler s (media ypeid);\
CREATE INDEX aler s_6 on aler s (userid);\
CREATE TABLE his ory (\
	i emid		number(20)		DEFAULT '0'	NOT NULL,\
	clock		number(10)		DEFAULT '0'	NOT NULL,\
	value		number(20,4)		DEFAULT '0.0000'	NOT NULL\
);\
CREATE INDEX his ory_1 on his ory (i emid,clock);\
CREATE TABLE his ory_sync (\
	id		number(20)			NOT NULL,\
	nodeid		number(20)		DEFAULT '0'	NOT NULL,\
	i emid		number(20)		DEFAULT '0'	NOT NULL,\
	clock		number(10)		DEFAULT '0'	NOT NULL,\
	value		number(20,4)		DEFAULT '0.0000'	NOT NULL,\
	PRIMARY KEY (id)\
);\
CREATE INDEX his ory_sync_1 on his ory_sync (nodeid,id);\
CREATE TABLE his ory_uin  (\
	i emid		number(20)		DEFAULT '0'	NOT NULL,\
	clock		number(10)		DEFAULT '0'	NOT NULL,\
	value		number(20)		DEFAULT '0'	NOT NULL\
);\
CREATE INDEX his ory_uin _1 on his ory_uin  (i emid,clock);\
CREATE TABLE his ory_uin _sync (\
	id		number(20)			NOT NULL,\
	nodeid		number(20)		DEFAULT '0'	NOT NULL,\
	i emid		number(20)		DEFAULT '0'	NOT NULL,\
	clock		number(10)		DEFAULT '0'	NOT NULL,\
	value		number(20)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (id)\
);\
CREATE INDEX his ory_uin _sync_1 on his ory_uin _sync (nodeid,id);\
CREATE TABLE his ory_s r (\
	i emid		number(20)		DEFAULT '0'	NOT NULL,\
	clock		number(10)		DEFAULT '0'	NOT NULL,\
	value		varchar2(255)		DEFAULT ''	\
);\
CREATE INDEX his ory_s r_1 on his ory_s r (i emid,clock);\
CREATE TABLE his ory_s r_sync (\
	id		number(20)			NOT NULL,\
	nodeid		number(20)		DEFAULT '0'	NOT NULL,\
	i emid		number(20)		DEFAULT '0'	NOT NULL,\
	clock		number(10)		DEFAULT '0'	NOT NULL,\
	value		varchar2(255)		DEFAULT ''	,\
	PRIMARY KEY (id)\
);\
CREATE INDEX his ory_s r_sync_1 on his ory_s r_sync (nodeid,id);\
CREATE TABLE his ory_log (\
	id		number(20)		DEFAULT '0'	NOT NULL,\
	i emid		number(20)		DEFAULT '0'	NOT NULL,\
	clock		number(10)		DEFAULT '0'	NOT NULL,\
	 imes amp		number(10)		DEFAULT '0'	NOT NULL,\
	source		varchar2(64)		DEFAULT ''	,\
	severi y		number(10)		DEFAULT '0'	NOT NULL,\
	value		varchar2(2048)		DEFAULT ''	,\
	PRIMARY KEY (id)\
);\
CREATE INDEX his ory_log_1 on his ory_log (i emid,clock);\
CREATE TABLE his ory_ ex  (\
	id		number(20)		DEFAULT '0'	NOT NULL,\
	i emid		number(20)		DEFAULT '0'	NOT NULL,\
	clock		number(10)		DEFAULT '0'	NOT NULL,\
	value		clob		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (id)\
);\
CREATE INDEX his ory_ ex _1 on his ory_ ex  (i emid,clock);\
CREATE TABLE proxy_his ory (\
	id		number(20)			NOT NULL,\
	i emid		number(20)		DEFAULT '0'	NOT NULL,\
	clock		number(10)		DEFAULT '0'	NOT NULL,\
	 imes amp		number(10)		DEFAULT '0'	NOT NULL,\
	source		varchar2(64)		DEFAULT ''	,\
	severi y		number(10)		DEFAULT '0'	NOT NULL,\
	value		varchar2(2048)		DEFAULT ''	,\
	PRIMARY KEY (id)\
);\
CREATE INDEX proxy_his ory_1 on proxy_his ory (clock);\
CREATE TABLE proxy_dhis ory (\
	id		number(20)			NOT NULL,\
	clock		number(10)		DEFAULT '0'	NOT NULL,\
	druleid		number(20)		DEFAULT '0'	NOT NULL,\
	 ype		number(10)		DEFAULT '0'	NOT NULL,\
	ip		varchar2(39)		DEFAULT ''	,\
	por 		number(10)		DEFAULT '0'	NOT NULL,\
	key_		varchar2(255)		DEFAULT '0'	,\
	value		varchar2(255)		DEFAULT '0'	,\
	s a us		number(10)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (id)\
);\
CREATE INDEX proxy_dhis ory_1 on proxy_dhis ory (clock);\
CREATE TABLE even s (\
	even id		number(20)		DEFAULT '0'	NOT NULL,\
	source		number(10)		DEFAULT '0'	NOT NULL,\
	objec 		number(10)		DEFAULT '0'	NOT NULL,\
	objec id		number(20)		DEFAULT '0'	NOT NULL,\
	clock		number(10)		DEFAULT '0'	NOT NULL,\
	value		number(10)		DEFAULT '0'	NOT NULL,\
	acknowledged		number(10)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (even id)\
);\
CREATE INDEX even s_1 on even s (objec ,objec id,even id);\
CREATE INDEX even s_2 on even s (clock);\
CREATE TABLE  rends (\
	i emid		number(20)		DEFAULT '0'	NOT NULL,\
	clock		number(10)		DEFAULT '0'	NOT NULL,\
	num		number(10)		DEFAULT '0'	NOT NULL,\
	value_min		number(20,4)		DEFAULT '0.0000'	NOT NULL,\
	value_avg		number(20,4)		DEFAULT '0.0000'	NOT NULL,\
	value_max		number(20,4)		DEFAULT '0.0000'	NOT NULL,\
	PRIMARY KEY (i emid,clock)\
);\
CREATE TABLE  rends_uin  (\
	i emid		number(20)		DEFAULT '0'	NOT NULL,\
	clock		number(10)		DEFAULT '0'	NOT NULL,\
	num		number(10)		DEFAULT '0'	NOT NULL,\
	value_min		number(20)		DEFAULT '0'	NOT NULL,\
	value_avg		number(20)		DEFAULT '0'	NOT NULL,\
	value_max		number(20)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (i emid,clock)\
);\
CREATE TABLE acknowledges (\
	acknowledgeid		number(20)		DEFAULT '0'	NOT NULL,\
	userid		number(20)		DEFAULT '0'	NOT NULL,\
	even id		number(20)		DEFAULT '0'	NOT NULL,\
	clock		number(10)		DEFAULT '0'	NOT NULL,\
	message		varchar2(255)		DEFAULT ''	,\
	PRIMARY KEY (acknowledgeid)\
);\
CREATE INDEX acknowledges_1 on acknowledges (userid);\
CREATE INDEX acknowledges_2 on acknowledges (even id);\
CREATE INDEX acknowledges_3 on acknowledges (clock);\
CREATE TABLE audi log (\
	audi id		number(20)		DEFAULT '0'	NOT NULL,\
	userid		number(20)		DEFAULT '0'	NOT NULL,\
	clock		number(10)		DEFAULT '0'	NOT NULL,\
	ac ion		number(10)		DEFAULT '0'	NOT NULL,\
	resource ype		number(10)		DEFAULT '0'	NOT NULL,\
	de ails		varchar2(128)		DEFAULT '0'	,\
	PRIMARY KEY (audi id)\
);\
CREATE INDEX audi log_1 on audi log (userid,clock);\
CREATE INDEX audi log_2 on audi log (clock);\
CREATE TABLE service_alarms (\
	servicealarmid		number(20)		DEFAULT '0'	NOT NULL,\
	serviceid		number(20)		DEFAULT '0'	NOT NULL,\
	clock		number(10)		DEFAULT '0'	NOT NULL,\
	value		number(10)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (servicealarmid)\
);\
CREATE INDEX service_alarms_1 on service_alarms (serviceid,clock);\
CREATE INDEX service_alarms_2 on service_alarms (clock);\
CREATE TABLE ac ions (\
	ac ionid		number(20)		DEFAULT '0'	NOT NULL,\
	name		varchar2(255)		DEFAULT ''	,\
	even source		number(10)		DEFAULT '0'	NOT NULL,\
	eval ype		number(10)		DEFAULT '0'	NOT NULL,\
	s a us		number(10)		DEFAULT '0'	NOT NULL,\
	esc_period		number(10)		DEFAULT '0'	NOT NULL,\
	def_shor da a		varchar2(255)		DEFAULT ''	,\
	def_longda a		varchar2(2048)		DEFAULT ''	,\
	recovery_msg		number(10)		DEFAULT '0'	NOT NULL,\
	r_shor da a		varchar2(255)		DEFAULT ''	,\
	r_longda a		varchar2(2048)		DEFAULT ''	,\
	PRIMARY KEY (ac ionid)\
);\
CREATE TABLE opera ions (\
	opera ionid		number(20)		DEFAULT '0'	NOT NULL,\
	ac ionid		number(20)		DEFAULT '0'	NOT NULL,\
	opera ion ype		number(10)		DEFAULT '0'	NOT NULL,\
	objec 		number(10)		DEFAULT '0'	NOT NULL,\
	objec id		number(20)		DEFAULT '0'	NOT NULL,\
	shor da a		varchar2(255)		DEFAULT ''	,\
	longda a		varchar2(2048)		DEFAULT ''	,\
	esc_period		number(10)		DEFAULT '0'	NOT NULL,\
	esc_s ep_from		number(10)		DEFAULT '0'	NOT NULL,\
	esc_s ep_ o		number(10)		DEFAULT '0'	NOT NULL,\
	defaul _msg		number(10)		DEFAULT '0'	NOT NULL,\
	eval ype		number(10)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (opera ionid)\
);\
CREATE INDEX opera ions_1 on opera ions (ac ionid);\
CREATE TABLE opcondi ions (\
	opcondi ionid		number(20)		DEFAULT '0'	NOT NULL,\
	opera ionid		number(20)		DEFAULT '0'	NOT NULL,\
	condi ion ype		number(10)		DEFAULT '0'	NOT NULL,\
	opera or		number(10)		DEFAULT '0'	NOT NULL,\
	value		varchar2(255)		DEFAULT ''	,\
	PRIMARY KEY (opcondi ionid)\
);\
CREATE INDEX opcondi ions_1 on opcondi ions (opera ionid);\
CREATE TABLE escala ions (\
	escala ionid		number(20)		DEFAULT '0'	NOT NULL,\
	ac ionid		number(20)		DEFAULT '0'	NOT NULL,\
	 riggerid		number(20)		DEFAULT '0'	NOT NULL,\
	even id		number(20)		DEFAULT '0'	NOT NULL,\
	r_even id		number(20)		DEFAULT '0'	NOT NULL,\
	nex check		number(10)		DEFAULT '0'	NOT NULL,\
	esc_s ep		number(10)		DEFAULT '0'	NOT NULL,\
	s a us		number(10)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (escala ionid)\
);\
CREATE INDEX escala ions_1 on escala ions (ac ionid, riggerid);\
CREATE TABLE applica ions (\
	applica ionid		number(20)		DEFAULT '0'	NOT NULL,\
	hos id		number(20)		DEFAULT '0'	NOT NULL,\
	name		varchar2(255)		DEFAULT ''	,\
	 empla eid		number(20)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (applica ionid)\
);\
CREATE INDEX applica ions_1 on applica ions ( empla eid);\
CREATE UNIQUE INDEX applica ions_2 on applica ions (hos id,name);\
CREATE TABLE condi ions (\
	condi ionid		number(20)		DEFAULT '0'	NOT NULL,\
	ac ionid		number(20)		DEFAULT '0'	NOT NULL,\
	condi ion ype		number(10)		DEFAULT '0'	NOT NULL,\
	opera or		number(10)		DEFAULT '0'	NOT NULL,\
	value		varchar2(255)		DEFAULT ''	,\
	PRIMARY KEY (condi ionid)\
);\
CREATE INDEX condi ions_1 on condi ions (ac ionid);\
CREATE TABLE config (\
	configid		number(20)		DEFAULT '0'	NOT NULL,\
	aler _his ory		number(10)		DEFAULT '0'	NOT NULL,\
	even _his ory		number(10)		DEFAULT '0'	NOT NULL,\
	refresh_unsuppor ed		number(10)		DEFAULT '0'	NOT NULL,\
	work_period		varchar2(100)		DEFAULT '1-5,00:00-24:00'	,\
	aler _usrgrpid		number(20)		DEFAULT '0'	NOT NULL,\
	even _ack_enable		number(10)		DEFAULT '1'	NOT NULL,\
	even _expire		number(10)		DEFAULT '7'	NOT NULL,\
	even _show_max		number(10)		DEFAULT '100'	NOT NULL,\
	defaul _ heme		varchar2(128)		DEFAULT 'defaul .css'	,\
	au hen ica ion_ ype		number(10)		DEFAULT 0	NOT NULL,\
	ldap_hos 		varchar2(255)		DEFAULT ''	,\
	ldap_por 		number(10)		DEFAULT 389	NOT NULL,\
	ldap_base_dn		varchar2(255)		DEFAULT ''	,\
	ldap_bind_dn		varchar2(255)		DEFAULT ''	,\
	ldap_bind_password		varchar2(128)		DEFAULT ''	,\
	ldap_search_a ribu e		varchar2(128)		DEFAULT ''	,\
	PRIMARY KEY (configid)\
);\
CREATE TABLE func ions (\
	func ionid		number(20)		DEFAULT '0'	NOT NULL,\
	i emid		number(20)		DEFAULT '0'	NOT NULL,\
	 riggerid		number(20)		DEFAULT '0'	NOT NULL,\
	las value		varchar2(255)			,\
	func ion		varchar2(12)		DEFAULT ''	,\
	parame er		varchar2(255)		DEFAULT '0'	,\
	PRIMARY KEY (func ionid)\
);\
CREATE INDEX func ions_1 on func ions ( riggerid);\
CREATE INDEX func ions_2 on func ions (i emid,func ion,parame er);\
CREATE TABLE graphs (\
	graphid		number(20)		DEFAULT '0'	NOT NULL,\
	name		varchar2(128)		DEFAULT ''	,\
	wid h		number(10)		DEFAULT '0'	NOT NULL,\
	heigh 		number(10)		DEFAULT '0'	NOT NULL,\
	yaxis ype		number(10)		DEFAULT '0'	NOT NULL,\
	yaxismin		number(20,4)		DEFAULT '0'	NOT NULL,\
	yaxismax		number(20,4)		DEFAULT '0'	NOT NULL,\
	 empla eid		number(20)		DEFAULT '0'	NOT NULL,\
	show_work_period		number(10)		DEFAULT '1'	NOT NULL,\
	show_ riggers		number(10)		DEFAULT '1'	NOT NULL,\
	graph ype		number(10)		DEFAULT '0'	NOT NULL,\
	show_legend		number(10)		DEFAULT '0'	NOT NULL,\
	show_3d		number(10)		DEFAULT '0'	NOT NULL,\
	percen _lef 		number(20,4)		DEFAULT '0'	NOT NULL,\
	percen _righ 		number(20,4)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (graphid)\
);\
CREATE INDEX graphs_graphs_1 on graphs (name);\
CREATE TABLE graphs_i ems (\
	gi emid		number(20)		DEFAULT '0'	NOT NULL,\
	graphid		number(20)		DEFAULT '0'	NOT NULL,\
	i emid		number(20)		DEFAULT '0'	NOT NULL,\
	draw ype		number(10)		DEFAULT '0'	NOT NULL,\
	sor order		number(10)		DEFAULT '0'	NOT NULL,\
	color		varchar2(32)		DEFAULT '009600'	,\
	yaxisside		number(10)		DEFAULT '1'	NOT NULL,\
	calc_fnc		number(10)		DEFAULT '2'	NOT NULL,\
	 ype		number(10)		DEFAULT '0'	NOT NULL,\
	periods_cn 		number(10)		DEFAULT '5'	NOT NULL,\
	PRIMARY KEY (gi emid)\
);\
CREATE TABLE groups (\
	groupid		number(20)		DEFAULT '0'	NOT NULL,\
	name		varchar2(64)		DEFAULT ''	,\
	PRIMARY KEY (groupid)\
);\
CREATE INDEX groups_1 on groups (name);\
CREATE TABLE help_i ems (\
	i em ype		number(10)		DEFAULT '0'	NOT NULL,\
	key_		varchar2(255)		DEFAULT ''	,\
	descrip ion		varchar2(255)		DEFAULT ''	,\
	PRIMARY KEY (i em ype,key_)\
);\
CREATE TABLE hos s (\
	hos id		number(20)		DEFAULT '0'	NOT NULL,\
	proxy_hos id		number(20)		DEFAULT '0'	NOT NULL,\
	hos 		varchar2(64)		DEFAULT ''	,\
	dns		varchar2(64)		DEFAULT ''	,\
	useip		number(10)		DEFAULT '1'	NOT NULL,\
	ip		varchar2(39)		DEFAULT '127.0.0.1'	,\
	por 		number(10)		DEFAULT '10050'	NOT NULL,\
	s a us		number(10)		DEFAULT '0'	NOT NULL,\
	disable_un il		number(10)		DEFAULT '0'	NOT NULL,\
	error		varchar2(128)		DEFAULT ''	,\
	available		number(10)		DEFAULT '0'	NOT NULL,\
	errors_from		number(10)		DEFAULT '0'	NOT NULL,\
	las access		number(10)		DEFAULT '0'	NOT NULL,\
	inby es		number(20)		DEFAULT '0'	NOT NULL,\
	ou by es		number(20)		DEFAULT '0'	NOT NULL,\
	useipmi		number(10)		DEFAULT '0'	NOT NULL,\
	ipmi_por 		number(10)		DEFAULT '623'	NOT NULL,\
	ipmi_au h ype		number(10)		DEFAULT '0'	NOT NULL,\
	ipmi_privilege		number(10)		DEFAULT '2'	NOT NULL,\
	ipmi_username		varchar2(16)		DEFAULT ''	,\
	ipmi_password		varchar2(20)		DEFAULT ''	,\
	ipmi_disable_un il		number(10)		DEFAULT '0'	NOT NULL,\
	ipmi_available		number(10)		DEFAULT '0'	NOT NULL,\
	snmp_disable_un il		number(10)		DEFAULT '0'	NOT NULL,\
	snmp_available		number(10)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (hos id)\
);\
CREATE INDEX hos s_1 on hos s (hos );\
CREATE INDEX hos s_2 on hos s (s a us);\
CREATE INDEX hos s_3 on hos s (proxy_hos id);\
CREATE TABLE hos s_groups (\
	hos groupid		number(20)		DEFAULT '0'	NOT NULL,\
	hos id		number(20)		DEFAULT '0'	NOT NULL,\
	groupid		number(20)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (hos groupid)\
);\
CREATE INDEX hos s_groups_groups_1 on hos s_groups (hos id,groupid);\
CREATE TABLE hos s_profiles (\
	hos id		number(20)		DEFAULT '0'	NOT NULL,\
	device ype		varchar2(64)		DEFAULT ''	,\
	name		varchar2(64)		DEFAULT ''	,\
	os		varchar2(64)		DEFAULT ''	,\
	serialno		varchar2(64)		DEFAULT ''	,\
	 ag		varchar2(64)		DEFAULT ''	,\
	macaddress		varchar2(64)		DEFAULT ''	,\
	hardware		varchar2(2048)		DEFAULT ''	,\
	sof ware		varchar2(2048)		DEFAULT ''	,\
	con ac 		varchar2(2048)		DEFAULT ''	,\
	loca ion		varchar2(2048)		DEFAULT ''	,\
	no es		varchar2(2048)		DEFAULT ''	,\
	PRIMARY KEY (hos id)\
);\
CREATE TABLE hos s_profiles_ex  (\
	hos id		number(20)		DEFAULT '0'	NOT NULL,\
	device_alias		varchar2(64)		DEFAULT ''	,\
	device_ ype		varchar2(64)		DEFAULT ''	,\
	device_chassis		varchar2(64)		DEFAULT ''	,\
	device_os		varchar2(64)		DEFAULT ''	,\
	device_os_shor 		varchar2(64)		DEFAULT ''	,\
	device_hw_arch		varchar2(32)		DEFAULT ''	,\
	device_serial		varchar2(64)		DEFAULT ''	,\
	device_model		varchar2(64)		DEFAULT ''	,\
	device_ ag		varchar2(64)		DEFAULT ''	,\
	device_vendor		varchar2(64)		DEFAULT ''	,\
	device_con rac 		varchar2(64)		DEFAULT ''	,\
	device_who		varchar2(64)		DEFAULT ''	,\
	device_s a us		varchar2(64)		DEFAULT ''	,\
	device_app_01		varchar2(64)		DEFAULT ''	,\
	device_app_02		varchar2(64)		DEFAULT ''	,\
	device_app_03		varchar2(64)		DEFAULT ''	,\
	device_app_04		varchar2(64)		DEFAULT ''	,\
	device_app_05		varchar2(64)		DEFAULT ''	,\
	device_url_1		varchar2(255)		DEFAULT ''	,\
	device_url_2		varchar2(255)		DEFAULT ''	,\
	device_url_3		varchar2(255)		DEFAULT ''	,\
	device_ne works		varchar2(2048)		DEFAULT ''	,\
	device_no es		varchar2(2048)		DEFAULT ''	,\
	device_hardware		varchar2(2048)		DEFAULT ''	,\
	device_sof ware		varchar2(2048)		DEFAULT ''	,\
	ip_subne _mask		varchar2(39)		DEFAULT ''	,\
	ip_rou er		varchar2(39)		DEFAULT ''	,\
	ip_macaddress		varchar2(64)		DEFAULT ''	,\
	oob_ip		varchar2(39)		DEFAULT ''	,\
	oob_subne _mask		varchar2(39)		DEFAULT ''	,\
	oob_rou er		varchar2(39)		DEFAULT ''	,\
	da e_hw_buy		varchar2(64)		DEFAULT ''	,\
	da e_hw_ins all		varchar2(64)		DEFAULT ''	,\
	da e_hw_expiry		varchar2(64)		DEFAULT ''	,\
	da e_hw_decomm		varchar2(64)		DEFAULT ''	,\
	si e_s ree _1		varchar2(128)		DEFAULT ''	,\
	si e_s ree _2		varchar2(128)		DEFAULT ''	,\
	si e_s ree _3		varchar2(128)		DEFAULT ''	,\
	si e_ci y		varchar2(128)		DEFAULT ''	,\
	si e_s a e		varchar2(64)		DEFAULT ''	,\
	si e_coun ry		varchar2(64)		DEFAULT ''	,\
	si e_zip		varchar2(64)		DEFAULT ''	,\
	si e_rack		varchar2(128)		DEFAULT ''	,\
	si e_no es		varchar2(2048)		DEFAULT ''	,\
	poc_1_name		varchar2(128)		DEFAULT ''	,\
	poc_1_email		varchar2(128)		DEFAULT ''	,\
	poc_1_phone_1		varchar2(64)		DEFAULT ''	,\
	poc_1_phone_2		varchar2(64)		DEFAULT ''	,\
	poc_1_cell		varchar2(64)		DEFAULT ''	,\
	poc_1_screen		varchar2(64)		DEFAULT ''	,\
	poc_1_no es		varchar2(2048)		DEFAULT ''	,\
	poc_2_name		varchar2(128)		DEFAULT ''	,\
	poc_2_email		varchar2(128)		DEFAULT ''	,\
	poc_2_phone_1		varchar2(64)		DEFAULT ''	,\
	poc_2_phone_2		varchar2(64)		DEFAULT ''	,\
	poc_2_cell		varchar2(64)		DEFAULT ''	,\
	poc_2_screen		varchar2(64)		DEFAULT ''	,\
	poc_2_no es		varchar2(2048)		DEFAULT ''	,\
	PRIMARY KEY (hos id)\
);\
CREATE TABLE hos s_ empla es (\
	hos empla eid		number(20)		DEFAULT '0'	NOT NULL,\
	hos id		number(20)		DEFAULT '0'	NOT NULL,\
	 empla eid		number(20)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (hos empla eid)\
);\
CREATE UNIQUE INDEX hos s_ empla es_1 on hos s_ empla es (hos id, empla eid);\
CREATE TABLE housekeeper (\
	housekeeperid		number(20)		DEFAULT '0'	NOT NULL,\
	 ablename		varchar2(64)		DEFAULT ''	,\
	field		varchar2(64)		DEFAULT ''	,\
	value		number(20)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (housekeeperid)\
);\
CREATE TABLE images (\
	imageid		number(20)		DEFAULT '0'	NOT NULL,\
	image ype		number(10)		DEFAULT '0'	NOT NULL,\
	name		varchar2(64)		DEFAULT '0'	,\
	image		blob		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (imageid)\
);\
CREATE INDEX images_1 on images (image ype,name);\
CREATE TABLE i ems (\
	i emid		number(20)		DEFAULT '0'	NOT NULL,\
	 ype		number(10)		DEFAULT '0'	NOT NULL,\
	snmp_communi y		varchar2(64)		DEFAULT ''	,\
	snmp_oid		varchar2(255)		DEFAULT ''	,\
	snmp_por 		number(10)		DEFAULT '161'	NOT NULL,\
	hos id		number(20)		DEFAULT '0'	NOT NULL,\
	descrip ion		varchar2(255)		DEFAULT ''	,\
	key_		varchar2(255)		DEFAULT ''	,\
	delay		number(10)		DEFAULT '0'	NOT NULL,\
	his ory		number(10)		DEFAULT '90'	NOT NULL,\
	 rends		number(10)		DEFAULT '365'	NOT NULL,\
	nex check		number(10)		DEFAULT '0'	NOT NULL,\
	las value		varchar2(255)			,\
	las clock		number(10)			NULL,\
	prevvalue		varchar2(255)			,\
	s a us		number(10)		DEFAULT '0'	NOT NULL,\
	value_ ype		number(10)		DEFAULT '0'	NOT NULL,\
	 rapper_hos s		varchar2(255)		DEFAULT ''	,\
	uni s		varchar2(10)		DEFAULT ''	,\
	mul iplier		number(10)		DEFAULT '0'	NOT NULL,\
	del a		number(10)		DEFAULT '0'	NOT NULL,\
	prevorgvalue		varchar2(255)			,\
	snmpv3_securi yname		varchar2(64)		DEFAULT ''	,\
	snmpv3_securi ylevel		number(10)		DEFAULT '0'	NOT NULL,\
	snmpv3_au hpassphrase		varchar2(64)		DEFAULT ''	,\
	snmpv3_privpassphrase		varchar2(64)		DEFAULT ''	,\
	formula		varchar2(255)		DEFAULT '1'	,\
	error		varchar2(128)		DEFAULT ''	,\
	las logsize		number(10)		DEFAULT '0'	NOT NULL,\
	log imefm 		varchar2(64)		DEFAULT ''	,\
	 empla eid		number(20)		DEFAULT '0'	NOT NULL,\
	valuemapid		number(20)		DEFAULT '0'	NOT NULL,\
	delay_flex		varchar2(255)		DEFAULT ''	,\
	params		varchar2(2048)		DEFAULT ''	,\
	ipmi_sensor		varchar2(128)		DEFAULT ''	,\
	PRIMARY KEY (i emid)\
);\
CREATE UNIQUE INDEX i ems_1 on i ems (hos id,key_);\
CREATE INDEX i ems_2 on i ems (nex check);\
CREATE INDEX i ems_3 on i ems (s a us);\
CREATE INDEX i ems_4 on i ems ( empla eid);\
CREATE TABLE i ems_applica ions (\
	i emappid		number(20)		DEFAULT '0'	NOT NULL,\
	applica ionid		number(20)		DEFAULT '0'	NOT NULL,\
	i emid		number(20)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (i emappid)\
);\
CREATE INDEX i ems_applica ions_1 on i ems_applica ions (applica ionid,i emid);\
CREATE INDEX i ems_applica ions_2 on i ems_applica ions (i emid);\
CREATE TABLE mappings (\
	mappingid		number(20)		DEFAULT '0'	NOT NULL,\
	valuemapid		number(20)		DEFAULT '0'	NOT NULL,\
	value		varchar2(64)		DEFAULT ''	,\
	newvalue		varchar2(64)		DEFAULT ''	,\
	PRIMARY KEY (mappingid)\
);\
CREATE INDEX mappings_1 on mappings (valuemapid);\
CREATE TABLE media (\
	mediaid		number(20)		DEFAULT '0'	NOT NULL,\
	userid		number(20)		DEFAULT '0'	NOT NULL,\
	media ypeid		number(20)		DEFAULT '0'	NOT NULL,\
	send o		varchar2(100)		DEFAULT ''	,\
	ac ive		number(10)		DEFAULT '0'	NOT NULL,\
	severi y		number(10)		DEFAULT '63'	NOT NULL,\
	period		varchar2(100)		DEFAULT '1-7,00:00-23:59'	,\
	PRIMARY KEY (mediaid)\
);\
CREATE INDEX media_1 on media (userid);\
CREATE INDEX media_2 on media (media ypeid);\
CREATE TABLE media_ ype (\
	media ypeid		number(20)		DEFAULT '0'	NOT NULL,\
	 ype		number(10)		DEFAULT '0'	NOT NULL,\
	descrip ion		varchar2(100)		DEFAULT ''	,\
	sm p_server		varchar2(255)		DEFAULT ''	,\
	sm p_helo		varchar2(255)		DEFAULT ''	,\
	sm p_email		varchar2(255)		DEFAULT ''	,\
	exec_pa h		varchar2(255)		DEFAULT ''	,\
	gsm_modem		varchar2(255)		DEFAULT ''	,\
	username		varchar2(255)		DEFAULT ''	,\
	passwd		varchar2(255)		DEFAULT ''	,\
	PRIMARY KEY (media ypeid)\
);\
CREATE TABLE profiles (\
	profileid		number(20)		DEFAULT '0'	NOT NULL,\
	userid		number(20)		DEFAULT '0'	NOT NULL,\
	idx		varchar2(96)		DEFAULT ''	,\
	idx2		number(20)		DEFAULT '0'	NOT NULL,\
	value_id		number(20)		DEFAULT '0'	NOT NULL,\
	value_in 		number(10)		DEFAULT '0'	NOT NULL,\
	value_s r		varchar2(255)		DEFAULT ''	,\
	source		varchar2(96)		DEFAULT ''	,\
	 ype		number(10)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (profileid)\
);\
CREATE INDEX profiles_1 on profiles (userid,idx,idx2);\
CREATE TABLE righ s (\
	righ id		number(20)		DEFAULT '0'	NOT NULL,\
	groupid		number(20)		DEFAULT '0'	NOT NULL,\
	permission		number(10)		DEFAULT '0'	NOT NULL,\
	id		number(20)			,\
	PRIMARY KEY (righ id)\
);\
CREATE INDEX righ s_1 on righ s (groupid);\
CREATE TABLE scrip s (\
	scrip id		number(20)		DEFAULT '0'	NOT NULL,\
	name		varchar2(255)		DEFAULT ''	,\
	command		varchar2(255)		DEFAULT ''	,\
	hos _access		number(10)		DEFAULT '2'	NOT NULL,\
	usrgrpid		number(20)		DEFAULT '0'	NOT NULL,\
	groupid		number(20)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (scrip id)\
);\
CREATE TABLE screens (\
	screenid		number(20)		DEFAULT '0'	NOT NULL,\
	name		varchar2(255)		DEFAULT 'Screen'	,\
	hsize		number(10)		DEFAULT '1'	NOT NULL,\
	vsize		number(10)		DEFAULT '1'	NOT NULL,\
	PRIMARY KEY (screenid)\
);\
CREATE TABLE screens_i ems (\
	screeni emid		number(20)		DEFAULT '0'	NOT NULL,\
	screenid		number(20)		DEFAULT '0'	NOT NULL,\
	resource ype		number(10)		DEFAULT '0'	NOT NULL,\
	resourceid		number(20)		DEFAULT '0'	NOT NULL,\
	wid h		number(10)		DEFAULT '320'	NOT NULL,\
	heigh 		number(10)		DEFAULT '200'	NOT NULL,\
	x		number(10)		DEFAULT '0'	NOT NULL,\
	y		number(10)		DEFAULT '0'	NOT NULL,\
	colspan		number(10)		DEFAULT '0'	NOT NULL,\
	rowspan		number(10)		DEFAULT '0'	NOT NULL,\
	elemen s		number(10)		DEFAULT '25'	NOT NULL,\
	valign		number(10)		DEFAULT '0'	NOT NULL,\
	halign		number(10)		DEFAULT '0'	NOT NULL,\
	s yle		number(10)		DEFAULT '0'	NOT NULL,\
	url		varchar2(255)		DEFAULT ''	,\
	dynamic		number(10)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (screeni emid)\
);\
CREATE TABLE services (\
	serviceid		number(20)		DEFAULT '0'	NOT NULL,\
	name		varchar2(128)		DEFAULT ''	,\
	s a us		number(10)		DEFAULT '0'	NOT NULL,\
	algori hm		number(10)		DEFAULT '0'	NOT NULL,\
	 riggerid		number(20)			,\
	showsla		number(10)		DEFAULT '0'	NOT NULL,\
	goodsla		number(20,4)		DEFAULT '99.9'	NOT NULL,\
	sor order		number(10)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (serviceid)\
);\
CREATE TABLE services_links (\
	linkid		number(20)		DEFAULT '0'	NOT NULL,\
	serviceupid		number(20)		DEFAULT '0'	NOT NULL,\
	servicedownid		number(20)		DEFAULT '0'	NOT NULL,\
	sof 		number(10)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (linkid)\
);\
CREATE INDEX services_links_links_1 on services_links (servicedownid);\
CREATE UNIQUE INDEX services_links_links_2 on services_links (serviceupid,servicedownid);\
CREATE TABLE sessions (\
	sessionid		varchar2(32)		DEFAULT ''	,\
	userid		number(20)		DEFAULT '0'	NOT NULL,\
	las access		number(10)		DEFAULT '0'	NOT NULL,\
	s a us		number(10)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (sessionid)\
);\
CREATE TABLE sysmaps_links (\
	linkid		number(20)		DEFAULT '0'	NOT NULL,\
	sysmapid		number(20)		DEFAULT '0'	NOT NULL,\
	selemen id1		number(20)		DEFAULT '0'	NOT NULL,\
	selemen id2		number(20)		DEFAULT '0'	NOT NULL,\
	draw ype		number(10)		DEFAULT '0'	NOT NULL,\
	color		varchar2(6)		DEFAULT '000000'	,\
	PRIMARY KEY (linkid)\
);\
CREATE TABLE sysmaps_link_ riggers (\
	link riggerid		number(20)		DEFAULT '0'	NOT NULL,\
	linkid		number(20)		DEFAULT '0'	NOT NULL,\
	 riggerid		number(20)		DEFAULT '0'	NOT NULL,\
	draw ype		number(10)		DEFAULT '0'	NOT NULL,\
	color		varchar2(6)		DEFAULT '000000'	,\
	PRIMARY KEY (link riggerid)\
);\
CREATE UNIQUE INDEX sysmaps_link_ riggers_1 on sysmaps_link_ riggers (linkid, riggerid);\
CREATE TABLE sysmaps_elemen s (\
	selemen id		number(20)		DEFAULT '0'	NOT NULL,\
	sysmapid		number(20)		DEFAULT '0'	NOT NULL,\
	elemen id		number(20)		DEFAULT '0'	NOT NULL,\
	elemen ype		number(10)		DEFAULT '0'	NOT NULL,\
	iconid_off		number(20)		DEFAULT '0'	NOT NULL,\
	iconid_on		number(20)		DEFAULT '0'	NOT NULL,\
	iconid_unknown		number(20)		DEFAULT '0'	NOT NULL,\
	label		varchar2(128)		DEFAULT ''	,\
	label_loca ion		number(10)			NULL,\
	x		number(10)		DEFAULT '0'	NOT NULL,\
	y		number(10)		DEFAULT '0'	NOT NULL,\
	url		varchar2(255)		DEFAULT ''	,\
	iconid_disabled		number(20)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (selemen id)\
);\
CREATE TABLE sysmaps (\
	sysmapid		number(20)		DEFAULT '0'	NOT NULL,\
	name		varchar2(128)		DEFAULT ''	,\
	wid h		number(10)		DEFAULT '0'	NOT NULL,\
	heigh 		number(10)		DEFAULT '0'	NOT NULL,\
	backgroundid		number(20)		DEFAULT '0'	NOT NULL,\
	label_ ype		number(10)		DEFAULT '0'	NOT NULL,\
	label_loca ion		number(10)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (sysmapid)\
);\
CREATE INDEX sysmaps_1 on sysmaps (name);\
CREATE TABLE  riggers (\
	 riggerid		number(20)		DEFAULT '0'	NOT NULL,\
	expression		varchar2(255)		DEFAULT ''	,\
	descrip ion		varchar2(255)		DEFAULT ''	,\
	url		varchar2(255)		DEFAULT ''	,\
	s a us		number(10)		DEFAULT '0'	NOT NULL,\
	value		number(10)		DEFAULT '0'	NOT NULL,\
	priori y		number(10)		DEFAULT '0'	NOT NULL,\
	las change		number(10)		DEFAULT '0'	NOT NULL,\
	dep_level		number(10)		DEFAULT '0'	NOT NULL,\
	commen s		varchar2(2048)		DEFAULT ''	,\
	error		varchar2(128)		DEFAULT ''	,\
	 empla eid		number(20)		DEFAULT '0'	NOT NULL,\
	 ype		number(10)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY ( riggerid)\
);\
CREATE INDEX  riggers_1 on  riggers (s a us);\
CREATE INDEX  riggers_2 on  riggers (value);\
CREATE TABLE  rigger_depends (\
	 riggerdepid		number(20)		DEFAULT '0'	NOT NULL,\
	 riggerid_down		number(20)		DEFAULT '0'	NOT NULL,\
	 riggerid_up		number(20)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY ( riggerdepid)\
);\
CREATE INDEX  rigger_depends_1 on  rigger_depends ( riggerid_down, riggerid_up);\
CREATE INDEX  rigger_depends_2 on  rigger_depends ( riggerid_up);\
CREATE TABLE users (\
	userid		number(20)		DEFAULT '0'	NOT NULL,\
	alias		varchar2(100)		DEFAULT ''	,\
	name		varchar2(100)		DEFAULT ''	,\
	surname		varchar2(100)		DEFAULT ''	,\
	passwd		varchar2(32)		DEFAULT ''	,\
	url		varchar2(255)		DEFAULT ''	,\
	au ologin		number(10)		DEFAULT '0'	NOT NULL,\
	au ologou 		number(10)		DEFAULT '900'	NOT NULL,\
	lang		varchar2(5)		DEFAULT 'en_gb'	,\
	refresh		number(10)		DEFAULT '30'	NOT NULL,\
	 ype		number(10)		DEFAULT '0'	NOT NULL,\
	 heme		varchar2(128)		DEFAULT 'defaul .css'	,\
	a emp _failed		number(10)		DEFAULT 0	NOT NULL,\
	a emp _ip		varchar2(39)		DEFAULT ''	,\
	a emp _clock		number(10)		DEFAULT 0	NOT NULL,\
	PRIMARY KEY (userid)\
);\
CREATE INDEX users_1 on users (alias);\
CREATE TABLE usrgrp (\
	usrgrpid		number(20)		DEFAULT '0'	NOT NULL,\
	name		varchar2(64)		DEFAULT ''	,\
	gui_access		number(10)		DEFAULT '0'	NOT NULL,\
	users_s a us		number(10)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (usrgrpid)\
);\
CREATE INDEX usrgrp_1 on usrgrp (name);\
CREATE TABLE users_groups (\
	id		number(20)		DEFAULT '0'	NOT NULL,\
	usrgrpid		number(20)		DEFAULT '0'	NOT NULL,\
	userid		number(20)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (id)\
);\
CREATE INDEX users_groups_1 on users_groups (usrgrpid,userid);\
CREATE TABLE valuemaps (\
	valuemapid		number(20)		DEFAULT '0'	NOT NULL,\
	name		varchar2(64)		DEFAULT ''	,\
	PRIMARY KEY (valuemapid)\
);\
CREATE INDEX valuemaps_1 on valuemaps (name);\
"};
#elif HAVE_SQLITE3
const char *db_schema = {"\
BEGIN TRANSACTION;\
CREATE TABLE IF NOT EXISTS slideshows (\
	slideshowid		bigin 		DEFAULT '0'	NOT NULL,\
	name		varchar(255)		DEFAULT ''	NOT NULL,\
	delay		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (slideshowid)\
);\
CREATE TABLE IF NOT EXISTS slides (\
	slideid		bigin 		DEFAULT '0'	NOT NULL,\
	slideshowid		bigin 		DEFAULT '0'	NOT NULL,\
	screenid		bigin 		DEFAULT '0'	NOT NULL,\
	s ep		in eger		DEFAULT '0'	NOT NULL,\
	delay		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (slideid)\
);\
CREATE INDEX IF NOT EXISTS slides_slides_1 on slides (slideshowid);\
CREATE TABLE IF NOT EXISTS drules (\
	druleid		bigin 		DEFAULT '0'	NOT NULL,\
	proxy_hos id		bigin 		DEFAULT '0'	NOT NULL,\
	name		varchar(255)		DEFAULT ''	NOT NULL,\
	iprange		varchar(255)		DEFAULT ''	NOT NULL,\
	delay		in eger		DEFAULT '0'	NOT NULL,\
	nex check		in eger		DEFAULT '0'	NOT NULL,\
	s a us		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (druleid)\
);\
CREATE TABLE IF NOT EXISTS dchecks (\
	dcheckid		bigin 		DEFAULT '0'	NOT NULL,\
	druleid		bigin 		DEFAULT '0'	NOT NULL,\
	 ype		in eger		DEFAULT '0'	NOT NULL,\
	key_		varchar(255)		DEFAULT '0'	NOT NULL,\
	snmp_communi y		varchar(255)		DEFAULT '0'	NOT NULL,\
	por s		varchar(255)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (dcheckid)\
);\
CREATE TABLE IF NOT EXISTS dhos s (\
	dhos id		bigin 		DEFAULT '0'	NOT NULL,\
	druleid		bigin 		DEFAULT '0'	NOT NULL,\
	ip		varchar(39)		DEFAULT ''	NOT NULL,\
	s a us		in eger		DEFAULT '0'	NOT NULL,\
	las up		in eger		DEFAULT '0'	NOT NULL,\
	las down		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (dhos id)\
);\
CREATE TABLE IF NOT EXISTS dservices (\
	dserviceid		bigin 		DEFAULT '0'	NOT NULL,\
	dhos id		bigin 		DEFAULT '0'	NOT NULL,\
	 ype		in eger		DEFAULT '0'	NOT NULL,\
	key_		varchar(255)		DEFAULT '0'	NOT NULL,\
	value		varchar(255)		DEFAULT '0'	NOT NULL,\
	por 		in eger		DEFAULT '0'	NOT NULL,\
	s a us		in eger		DEFAULT '0'	NOT NULL,\
	las up		in eger		DEFAULT '0'	NOT NULL,\
	las down		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (dserviceid)\
);\
CREATE TABLE IF NOT EXISTS ids (\
	nodeid		in eger		DEFAULT '0'	NOT NULL,\
	 able_name		varchar(64)		DEFAULT ''	NOT NULL,\
	field_name		varchar(64)		DEFAULT ''	NOT NULL,\
	nex id		bigin 		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (nodeid, able_name,field_name)\
);\
CREATE TABLE IF NOT EXISTS h p es  (\
	h p es id		bigin 		DEFAULT '0'	NOT NULL,\
	name		varchar(64)		DEFAULT ''	NOT NULL,\
	applica ionid		bigin 		DEFAULT '0'	NOT NULL,\
	las check		in eger		DEFAULT '0'	NOT NULL,\
	nex check		in eger		DEFAULT '0'	NOT NULL,\
	curs a e		in eger		DEFAULT '0'	NOT NULL,\
	curs ep		in eger		DEFAULT '0'	NOT NULL,\
	las faileds ep		in eger		DEFAULT '0'	NOT NULL,\
	delay		in eger		DEFAULT '60'	NOT NULL,\
	s a us		in eger		DEFAULT '0'	NOT NULL,\
	macros		blob		DEFAULT ''	NOT NULL,\
	agen 		varchar(255)		DEFAULT ''	NOT NULL,\
	 ime		double(16,4)		DEFAULT '0'	NOT NULL,\
	error		varchar(255)		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (h p es id)\
);\
CREATE INDEX IF NOT EXISTS h p es _h p es _1 on h p es  (applica ionid);\
CREATE TABLE IF NOT EXISTS h ps ep (\
	h ps epid		bigin 		DEFAULT '0'	NOT NULL,\
	h p es id		bigin 		DEFAULT '0'	NOT NULL,\
	name		varchar(64)		DEFAULT ''	NOT NULL,\
	no		in eger		DEFAULT '0'	NOT NULL,\
	url		varchar(255)		DEFAULT ''	NOT NULL,\
	 imeou 		in eger		DEFAULT '30'	NOT NULL,\
	pos s		blob		DEFAULT ''	NOT NULL,\
	required		varchar(255)		DEFAULT ''	NOT NULL,\
	s a us_codes		varchar(255)		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (h ps epid)\
);\
CREATE INDEX IF NOT EXISTS h ps ep_h ps ep_1 on h ps ep (h p es id);\
CREATE TABLE IF NOT EXISTS h ps epi em (\
	h ps epi emid		bigin 		DEFAULT '0'	NOT NULL,\
	h ps epid		bigin 		DEFAULT '0'	NOT NULL,\
	i emid		bigin 		DEFAULT '0'	NOT NULL,\
	 ype		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (h ps epi emid)\
);\
CREATE UNIQUE INDEX IF NOT EXISTS h ps epi em_h ps epi em_1 on h ps epi em (h ps epid,i emid);\
CREATE TABLE IF NOT EXISTS h p es i em (\
	h p es i emid		bigin 		DEFAULT '0'	NOT NULL,\
	h p es id		bigin 		DEFAULT '0'	NOT NULL,\
	i emid		bigin 		DEFAULT '0'	NOT NULL,\
	 ype		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (h p es i emid)\
);\
CREATE UNIQUE INDEX IF NOT EXISTS h p es i em_h p es i em_1 on h p es i em (h p es id,i emid);\
CREATE TABLE IF NOT EXISTS nodes (\
	nodeid		in eger		DEFAULT '0'	NOT NULL,\
	name		varchar(64)		DEFAULT '0'	NOT NULL,\
	 imezone		in eger		DEFAULT '0'	NOT NULL,\
	ip		varchar(39)		DEFAULT ''	NOT NULL,\
	por 		in eger		DEFAULT '10051'	NOT NULL,\
	slave_his ory		in eger		DEFAULT '30'	NOT NULL,\
	slave_ rends		in eger		DEFAULT '365'	NOT NULL,\
	node ype		in eger		DEFAULT '0'	NOT NULL,\
	mas erid		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (nodeid)\
);\
CREATE TABLE IF NOT EXISTS node_cksum (\
	nodeid		in eger		DEFAULT '0'	NOT NULL,\
	 ablename		varchar(64)		DEFAULT ''	NOT NULL,\
	recordid		bigin 		DEFAULT '0'	NOT NULL,\
	cksum ype		in eger		DEFAULT '0'	NOT NULL,\
	cksum		 ex 		DEFAULT ''	NOT NULL,\
	sync		char(128)		DEFAULT ''	NOT NULL\
);\
CREATE INDEX IF NOT EXISTS node_cksum_cksum_1 on node_cksum (nodeid, ablename,recordid,cksum ype);\
CREATE TABLE IF NOT EXISTS services_ imes (\
	 imeid		bigin 		DEFAULT '0'	NOT NULL,\
	serviceid		bigin 		DEFAULT '0'	NOT NULL,\
	 ype		in eger		DEFAULT '0'	NOT NULL,\
	 s_from		in eger		DEFAULT '0'	NOT NULL,\
	 s_ o		in eger		DEFAULT '0'	NOT NULL,\
	no e		varchar(255)		DEFAULT ''	NOT NULL,\
	PRIMARY KEY ( imeid)\
);\
CREATE INDEX IF NOT EXISTS services_ imes_ imes_1 on services_ imes (serviceid, ype, s_from, s_ o);\
CREATE TABLE IF NOT EXISTS aler s (\
	aler id		bigin 		DEFAULT '0'	NOT NULL,\
	ac ionid		bigin 		DEFAULT '0'	NOT NULL,\
	even id		bigin 		DEFAULT '0'	NOT NULL,\
	userid		bigin 		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	media ypeid		bigin 		DEFAULT '0'	NOT NULL,\
	send o		varchar(100)		DEFAULT ''	NOT NULL,\
	subjec 		varchar(255)		DEFAULT ''	NOT NULL,\
	message		blob		DEFAULT ''	NOT NULL,\
	s a us		in eger		DEFAULT '0'	NOT NULL,\
	re ries		in eger		DEFAULT '0'	NOT NULL,\
	error		varchar(128)		DEFAULT ''	NOT NULL,\
	nex check		in eger		DEFAULT '0'	NOT NULL,\
	esc_s ep		in eger		DEFAULT '0'	NOT NULL,\
	aler ype		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (aler id)\
);\
CREATE INDEX IF NOT EXISTS aler s_1 on aler s (ac ionid);\
CREATE INDEX IF NOT EXISTS aler s_2 on aler s (clock);\
CREATE INDEX IF NOT EXISTS aler s_3 on aler s (even id);\
CREATE INDEX IF NOT EXISTS aler s_4 on aler s (s a us,re ries);\
CREATE INDEX IF NOT EXISTS aler s_5 on aler s (media ypeid);\
CREATE INDEX IF NOT EXISTS aler s_6 on aler s (userid);\
CREATE TABLE IF NOT EXISTS his ory (\
	i emid		bigin 		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	value		double(16,4)		DEFAULT '0.0000'	NOT NULL\
);\
CREATE INDEX IF NOT EXISTS his ory_1 on his ory (i emid,clock);\
CREATE TABLE IF NOT EXISTS his ory_sync (\
	id		in eger			NOT NULL	PRIMARY KEY AUTOINCREMENT,\
	nodeid		bigin 		DEFAULT '0'	NOT NULL,\
	i emid		bigin 		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	value		double(16,4)		DEFAULT '0.0000'	NOT NULL\
);\
CREATE INDEX IF NOT EXISTS his ory_sync_1 on his ory_sync (nodeid,id);\
CREATE TABLE IF NOT EXISTS his ory_uin  (\
	i emid		bigin 		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	value		bigin 		DEFAULT '0'	NOT NULL\
);\
CREATE INDEX IF NOT EXISTS his ory_uin _1 on his ory_uin  (i emid,clock);\
CREATE TABLE IF NOT EXISTS his ory_uin _sync (\
	id		in eger			NOT NULL	PRIMARY KEY AUTOINCREMENT,\
	nodeid		bigin 		DEFAULT '0'	NOT NULL,\
	i emid		bigin 		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	value		bigin 		DEFAULT '0'	NOT NULL\
);\
CREATE INDEX IF NOT EXISTS his ory_uin _sync_1 on his ory_uin _sync (nodeid,id);\
CREATE TABLE IF NOT EXISTS his ory_s r (\
	i emid		bigin 		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	value		varchar(255)		DEFAULT ''	NOT NULL\
);\
CREATE INDEX IF NOT EXISTS his ory_s r_1 on his ory_s r (i emid,clock);\
CREATE TABLE IF NOT EXISTS his ory_s r_sync (\
	id		in eger			NOT NULL	PRIMARY KEY AUTOINCREMENT,\
	nodeid		bigin 		DEFAULT '0'	NOT NULL,\
	i emid		bigin 		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	value		varchar(255)		DEFAULT ''	NOT NULL\
);\
CREATE INDEX IF NOT EXISTS his ory_s r_sync_1 on his ory_s r_sync (nodeid,id);\
CREATE TABLE IF NOT EXISTS his ory_log (\
	id		bigin 		DEFAULT '0'	NOT NULL,\
	i emid		bigin 		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	 imes amp		in eger		DEFAULT '0'	NOT NULL,\
	source		varchar(64)		DEFAULT ''	NOT NULL,\
	severi y		in eger		DEFAULT '0'	NOT NULL,\
	value		 ex 		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (id)\
);\
CREATE INDEX IF NOT EXISTS his ory_log_1 on his ory_log (i emid,clock);\
CREATE TABLE IF NOT EXISTS his ory_ ex  (\
	id		bigin 		DEFAULT '0'	NOT NULL,\
	i emid		bigin 		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	value		 ex 		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (id)\
);\
CREATE INDEX IF NOT EXISTS his ory_ ex _1 on his ory_ ex  (i emid,clock);\
CREATE TABLE IF NOT EXISTS proxy_his ory (\
	id		in eger			NOT NULL	PRIMARY KEY AUTOINCREMENT,\
	i emid		bigin 		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	 imes amp		in eger		DEFAULT '0'	NOT NULL,\
	source		varchar(64)		DEFAULT ''	NOT NULL,\
	severi y		in eger		DEFAULT '0'	NOT NULL,\
	value		 ex 		DEFAULT ''	NOT NULL\
);\
CREATE INDEX IF NOT EXISTS proxy_his ory_1 on proxy_his ory (clock);\
CREATE TABLE IF NOT EXISTS proxy_dhis ory (\
	id		in eger			NOT NULL	PRIMARY KEY AUTOINCREMENT,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	druleid		bigin 		DEFAULT '0'	NOT NULL,\
	 ype		in eger		DEFAULT '0'	NOT NULL,\
	ip		varchar(39)		DEFAULT ''	NOT NULL,\
	por 		in eger		DEFAULT '0'	NOT NULL,\
	key_		varchar(255)		DEFAULT '0'	NOT NULL,\
	value		varchar(255)		DEFAULT '0'	NOT NULL,\
	s a us		in eger		DEFAULT '0'	NOT NULL\
);\
CREATE INDEX IF NOT EXISTS proxy_dhis ory_1 on proxy_dhis ory (clock);\
CREATE TABLE IF NOT EXISTS even s (\
	even id		bigin 		DEFAULT '0'	NOT NULL,\
	source		in eger		DEFAULT '0'	NOT NULL,\
	objec 		in eger		DEFAULT '0'	NOT NULL,\
	objec id		bigin 		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	value		in eger		DEFAULT '0'	NOT NULL,\
	acknowledged		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (even id)\
);\
CREATE INDEX IF NOT EXISTS even s_1 on even s (objec ,objec id,even id);\
CREATE INDEX IF NOT EXISTS even s_2 on even s (clock);\
CREATE TABLE IF NOT EXISTS  rends (\
	i emid		bigin 		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	num		in eger		DEFAULT '0'	NOT NULL,\
	value_min		double(16,4)		DEFAULT '0.0000'	NOT NULL,\
	value_avg		double(16,4)		DEFAULT '0.0000'	NOT NULL,\
	value_max		double(16,4)		DEFAULT '0.0000'	NOT NULL,\
	PRIMARY KEY (i emid,clock)\
);\
CREATE TABLE IF NOT EXISTS  rends_uin  (\
	i emid		bigin 		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	num		in eger		DEFAULT '0'	NOT NULL,\
	value_min		bigin 		DEFAULT '0'	NOT NULL,\
	value_avg		bigin 		DEFAULT '0'	NOT NULL,\
	value_max		bigin 		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (i emid,clock)\
);\
CREATE TABLE IF NOT EXISTS acknowledges (\
	acknowledgeid		bigin 		DEFAULT '0'	NOT NULL,\
	userid		bigin 		DEFAULT '0'	NOT NULL,\
	even id		bigin 		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	message		varchar(255)		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (acknowledgeid)\
);\
CREATE INDEX IF NOT EXISTS acknowledges_1 on acknowledges (userid);\
CREATE INDEX IF NOT EXISTS acknowledges_2 on acknowledges (even id);\
CREATE INDEX IF NOT EXISTS acknowledges_3 on acknowledges (clock);\
CREATE TABLE IF NOT EXISTS audi log (\
	audi id		bigin 		DEFAULT '0'	NOT NULL,\
	userid		bigin 		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	ac ion		in eger		DEFAULT '0'	NOT NULL,\
	resource ype		in eger		DEFAULT '0'	NOT NULL,\
	de ails		varchar(128)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (audi id)\
);\
CREATE INDEX IF NOT EXISTS audi log_1 on audi log (userid,clock);\
CREATE INDEX IF NOT EXISTS audi log_2 on audi log (clock);\
CREATE TABLE IF NOT EXISTS service_alarms (\
	servicealarmid		bigin 		DEFAULT '0'	NOT NULL,\
	serviceid		bigin 		DEFAULT '0'	NOT NULL,\
	clock		in eger		DEFAULT '0'	NOT NULL,\
	value		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (servicealarmid)\
);\
CREATE INDEX IF NOT EXISTS service_alarms_1 on service_alarms (serviceid,clock);\
CREATE INDEX IF NOT EXISTS service_alarms_2 on service_alarms (clock);\
CREATE TABLE IF NOT EXISTS ac ions (\
	ac ionid		bigin 		DEFAULT '0'	NOT NULL,\
	name		varchar(255)		DEFAULT ''	NOT NULL,\
	even source		in eger		DEFAULT '0'	NOT NULL,\
	eval ype		in eger		DEFAULT '0'	NOT NULL,\
	s a us		in eger		DEFAULT '0'	NOT NULL,\
	esc_period		in eger		DEFAULT '0'	NOT NULL,\
	def_shor da a		varchar(255)		DEFAULT ''	NOT NULL,\
	def_longda a		blob		DEFAULT ''	NOT NULL,\
	recovery_msg		in eger		DEFAULT '0'	NOT NULL,\
	r_shor da a		varchar(255)		DEFAULT ''	NOT NULL,\
	r_longda a		blob		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (ac ionid)\
);\
CREATE TABLE IF NOT EXISTS opera ions (\
	opera ionid		bigin 		DEFAULT '0'	NOT NULL,\
	ac ionid		bigin 		DEFAULT '0'	NOT NULL,\
	opera ion ype		in eger		DEFAULT '0'	NOT NULL,\
	objec 		in eger		DEFAULT '0'	NOT NULL,\
	objec id		bigin 		DEFAULT '0'	NOT NULL,\
	shor da a		varchar(255)		DEFAULT ''	NOT NULL,\
	longda a		blob		DEFAULT ''	NOT NULL,\
	esc_period		in eger		DEFAULT '0'	NOT NULL,\
	esc_s ep_from		in eger		DEFAULT '0'	NOT NULL,\
	esc_s ep_ o		in eger		DEFAULT '0'	NOT NULL,\
	defaul _msg		in eger		DEFAULT '0'	NOT NULL,\
	eval ype		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (opera ionid)\
);\
CREATE INDEX IF NOT EXISTS opera ions_1 on opera ions (ac ionid);\
CREATE TABLE IF NOT EXISTS opcondi ions (\
	opcondi ionid		bigin 		DEFAULT '0'	NOT NULL,\
	opera ionid		bigin 		DEFAULT '0'	NOT NULL,\
	condi ion ype		in eger		DEFAULT '0'	NOT NULL,\
	opera or		in eger		DEFAULT '0'	NOT NULL,\
	value		varchar(255)		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (opcondi ionid)\
);\
CREATE INDEX IF NOT EXISTS opcondi ions_1 on opcondi ions (opera ionid);\
CREATE TABLE IF NOT EXISTS escala ions (\
	escala ionid		bigin 		DEFAULT '0'	NOT NULL,\
	ac ionid		bigin 		DEFAULT '0'	NOT NULL,\
	 riggerid		bigin 		DEFAULT '0'	NOT NULL,\
	even id		bigin 		DEFAULT '0'	NOT NULL,\
	r_even id		bigin 		DEFAULT '0'	NOT NULL,\
	nex check		in eger		DEFAULT '0'	NOT NULL,\
	esc_s ep		in eger		DEFAULT '0'	NOT NULL,\
	s a us		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (escala ionid)\
);\
CREATE INDEX IF NOT EXISTS escala ions_1 on escala ions (ac ionid, riggerid);\
CREATE TABLE IF NOT EXISTS applica ions (\
	applica ionid		bigin 		DEFAULT '0'	NOT NULL,\
	hos id		bigin 		DEFAULT '0'	NOT NULL,\
	name		varchar(255)		DEFAULT ''	NOT NULL,\
	 empla eid		bigin 		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (applica ionid)\
);\
CREATE INDEX IF NOT EXISTS applica ions_1 on applica ions ( empla eid);\
CREATE UNIQUE INDEX IF NOT EXISTS applica ions_2 on applica ions (hos id,name);\
CREATE TABLE IF NOT EXISTS condi ions (\
	condi ionid		bigin 		DEFAULT '0'	NOT NULL,\
	ac ionid		bigin 		DEFAULT '0'	NOT NULL,\
	condi ion ype		in eger		DEFAULT '0'	NOT NULL,\
	opera or		in eger		DEFAULT '0'	NOT NULL,\
	value		varchar(255)		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (condi ionid)\
);\
CREATE INDEX IF NOT EXISTS condi ions_1 on condi ions (ac ionid);\
CREATE TABLE IF NOT EXISTS config (\
	configid		bigin 		DEFAULT '0'	NOT NULL,\
	aler _his ory		in eger		DEFAULT '0'	NOT NULL,\
	even _his ory		in eger		DEFAULT '0'	NOT NULL,\
	refresh_unsuppor ed		in eger		DEFAULT '0'	NOT NULL,\
	work_period		varchar(100)		DEFAULT '1-5,00:00-24:00'	NOT NULL,\
	aler _usrgrpid		bigin 		DEFAULT '0'	NOT NULL,\
	even _ack_enable		in eger		DEFAULT '1'	NOT NULL,\
	even _expire		in eger		DEFAULT '7'	NOT NULL,\
	even _show_max		in eger		DEFAULT '100'	NOT NULL,\
	defaul _ heme		varchar(128)		DEFAULT 'defaul .css'	NOT NULL,\
	au hen ica ion_ ype		in eger		DEFAULT 0	NOT NULL,\
	ldap_hos 		varchar(255)		DEFAULT ''	NOT NULL,\
	ldap_por 		in eger		DEFAULT 389	NOT NULL,\
	ldap_base_dn		varchar(255)		DEFAULT ''	NOT NULL,\
	ldap_bind_dn		varchar(255)		DEFAULT ''	NOT NULL,\
	ldap_bind_password		varchar(128)		DEFAULT ''	NOT NULL,\
	ldap_search_a ribu e		varchar(128)		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (configid)\
);\
CREATE TABLE IF NOT EXISTS func ions (\
	func ionid		bigin 		DEFAULT '0'	NOT NULL,\
	i emid		bigin 		DEFAULT '0'	NOT NULL,\
	 riggerid		bigin 		DEFAULT '0'	NOT NULL,\
	las value		varchar(255)			,\
	func ion		varchar(12)		DEFAULT ''	NOT NULL,\
	parame er		varchar(255)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (func ionid)\
);\
CREATE INDEX IF NOT EXISTS func ions_1 on func ions ( riggerid);\
CREATE INDEX IF NOT EXISTS func ions_2 on func ions (i emid,func ion,parame er);\
CREATE TABLE IF NOT EXISTS graphs (\
	graphid		bigin 		DEFAULT '0'	NOT NULL,\
	name		varchar(128)		DEFAULT ''	NOT NULL,\
	wid h		in eger		DEFAULT '0'	NOT NULL,\
	heigh 		in eger		DEFAULT '0'	NOT NULL,\
	yaxis ype		in eger		DEFAULT '0'	NOT NULL,\
	yaxismin		double(16,4)		DEFAULT '0'	NOT NULL,\
	yaxismax		double(16,4)		DEFAULT '0'	NOT NULL,\
	 empla eid		bigin 		DEFAULT '0'	NOT NULL,\
	show_work_period		in eger		DEFAULT '1'	NOT NULL,\
	show_ riggers		in eger		DEFAULT '1'	NOT NULL,\
	graph ype		in eger		DEFAULT '0'	NOT NULL,\
	show_legend		in eger		DEFAULT '0'	NOT NULL,\
	show_3d		in eger		DEFAULT '0'	NOT NULL,\
	percen _lef 		double(16,4)		DEFAULT '0'	NOT NULL,\
	percen _righ 		double(16,4)		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (graphid)\
);\
CREATE INDEX IF NOT EXISTS graphs_graphs_1 on graphs (name);\
CREATE TABLE IF NOT EXISTS graphs_i ems (\
	gi emid		bigin 		DEFAULT '0'	NOT NULL,\
	graphid		bigin 		DEFAULT '0'	NOT NULL,\
	i emid		bigin 		DEFAULT '0'	NOT NULL,\
	draw ype		in eger		DEFAULT '0'	NOT NULL,\
	sor order		in eger		DEFAULT '0'	NOT NULL,\
	color		varchar(32)		DEFAULT '009600'	NOT NULL,\
	yaxisside		in eger		DEFAULT '1'	NOT NULL,\
	calc_fnc		in eger		DEFAULT '2'	NOT NULL,\
	 ype		in eger		DEFAULT '0'	NOT NULL,\
	periods_cn 		in eger		DEFAULT '5'	NOT NULL,\
	PRIMARY KEY (gi emid)\
);\
CREATE TABLE IF NOT EXISTS groups (\
	groupid		bigin 		DEFAULT '0'	NOT NULL,\
	name		varchar(64)		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (groupid)\
);\
CREATE INDEX IF NOT EXISTS groups_1 on groups (name);\
CREATE TABLE IF NOT EXISTS help_i ems (\
	i em ype		in eger		DEFAULT '0'	NOT NULL,\
	key_		varchar(255)		DEFAULT ''	NOT NULL,\
	descrip ion		varchar(255)		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (i em ype,key_)\
);\
CREATE TABLE IF NOT EXISTS hos s (\
	hos id		bigin 		DEFAULT '0'	NOT NULL,\
	proxy_hos id		bigin 		DEFAULT '0'	NOT NULL,\
	hos 		varchar(64)		DEFAULT ''	NOT NULL,\
	dns		varchar(64)		DEFAULT ''	NOT NULL,\
	useip		in eger		DEFAULT '1'	NOT NULL,\
	ip		varchar(39)		DEFAULT '127.0.0.1'	NOT NULL,\
	por 		in eger		DEFAULT '10050'	NOT NULL,\
	s a us		in eger		DEFAULT '0'	NOT NULL,\
	disable_un il		in eger		DEFAULT '0'	NOT NULL,\
	error		varchar(128)		DEFAULT ''	NOT NULL,\
	available		in eger		DEFAULT '0'	NOT NULL,\
	errors_from		in eger		DEFAULT '0'	NOT NULL,\
	las access		in eger		DEFAULT '0'	NOT NULL,\
	inby es		bigin 		DEFAULT '0'	NOT NULL,\
	ou by es		bigin 		DEFAULT '0'	NOT NULL,\
	useipmi		in eger		DEFAULT '0'	NOT NULL,\
	ipmi_por 		in eger		DEFAULT '623'	NOT NULL,\
	ipmi_au h ype		in eger		DEFAULT '0'	NOT NULL,\
	ipmi_privilege		in eger		DEFAULT '2'	NOT NULL,\
	ipmi_username		varchar(16)		DEFAULT ''	NOT NULL,\
	ipmi_password		varchar(20)		DEFAULT ''	NOT NULL,\
	ipmi_disable_un il		in eger		DEFAULT '0'	NOT NULL,\
	ipmi_available		in eger		DEFAULT '0'	NOT NULL,\
	snmp_disable_un il		in eger		DEFAULT '0'	NOT NULL,\
	snmp_available		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (hos id)\
);\
CREATE INDEX IF NOT EXISTS hos s_1 on hos s (hos );\
CREATE INDEX IF NOT EXISTS hos s_2 on hos s (s a us);\
CREATE INDEX IF NOT EXISTS hos s_3 on hos s (proxy_hos id);\
CREATE TABLE IF NOT EXISTS hos s_groups (\
	hos groupid		bigin 		DEFAULT '0'	NOT NULL,\
	hos id		bigin 		DEFAULT '0'	NOT NULL,\
	groupid		bigin 		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (hos groupid)\
);\
CREATE INDEX IF NOT EXISTS hos s_groups_groups_1 on hos s_groups (hos id,groupid);\
CREATE TABLE IF NOT EXISTS hos s_profiles (\
	hos id		bigin 		DEFAULT '0'	NOT NULL,\
	device ype		varchar(64)		DEFAULT ''	NOT NULL,\
	name		varchar(64)		DEFAULT ''	NOT NULL,\
	os		varchar(64)		DEFAULT ''	NOT NULL,\
	serialno		varchar(64)		DEFAULT ''	NOT NULL,\
	 ag		varchar(64)		DEFAULT ''	NOT NULL,\
	macaddress		varchar(64)		DEFAULT ''	NOT NULL,\
	hardware		blob		DEFAULT ''	NOT NULL,\
	sof ware		blob		DEFAULT ''	NOT NULL,\
	con ac 		blob		DEFAULT ''	NOT NULL,\
	loca ion		blob		DEFAULT ''	NOT NULL,\
	no es		blob		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (hos id)\
);\
CREATE TABLE IF NOT EXISTS hos s_profiles_ex  (\
	hos id		bigin 		DEFAULT '0'	NOT NULL,\
	device_alias		varchar(64)		DEFAULT ''	NOT NULL,\
	device_ ype		varchar(64)		DEFAULT ''	NOT NULL,\
	device_chassis		varchar(64)		DEFAULT ''	NOT NULL,\
	device_os		varchar(64)		DEFAULT ''	NOT NULL,\
	device_os_shor 		varchar(64)		DEFAULT ''	NOT NULL,\
	device_hw_arch		varchar(32)		DEFAULT ''	NOT NULL,\
	device_serial		varchar(64)		DEFAULT ''	NOT NULL,\
	device_model		varchar(64)		DEFAULT ''	NOT NULL,\
	device_ ag		varchar(64)		DEFAULT ''	NOT NULL,\
	device_vendor		varchar(64)		DEFAULT ''	NOT NULL,\
	device_con rac 		varchar(64)		DEFAULT ''	NOT NULL,\
	device_who		varchar(64)		DEFAULT ''	NOT NULL,\
	device_s a us		varchar(64)		DEFAULT ''	NOT NULL,\
	device_app_01		varchar(64)		DEFAULT ''	NOT NULL,\
	device_app_02		varchar(64)		DEFAULT ''	NOT NULL,\
	device_app_03		varchar(64)		DEFAULT ''	NOT NULL,\
	device_app_04		varchar(64)		DEFAULT ''	NOT NULL,\
	device_app_05		varchar(64)		DEFAULT ''	NOT NULL,\
	device_url_1		varchar(255)		DEFAULT ''	NOT NULL,\
	device_url_2		varchar(255)		DEFAULT ''	NOT NULL,\
	device_url_3		varchar(255)		DEFAULT ''	NOT NULL,\
	device_ne works		blob		DEFAULT ''	NOT NULL,\
	device_no es		blob		DEFAULT ''	NOT NULL,\
	device_hardware		blob		DEFAULT ''	NOT NULL,\
	device_sof ware		blob		DEFAULT ''	NOT NULL,\
	ip_subne _mask		varchar(39)		DEFAULT ''	NOT NULL,\
	ip_rou er		varchar(39)		DEFAULT ''	NOT NULL,\
	ip_macaddress		varchar(64)		DEFAULT ''	NOT NULL,\
	oob_ip		varchar(39)		DEFAULT ''	NOT NULL,\
	oob_subne _mask		varchar(39)		DEFAULT ''	NOT NULL,\
	oob_rou er		varchar(39)		DEFAULT ''	NOT NULL,\
	da e_hw_buy		varchar(64)		DEFAULT ''	NOT NULL,\
	da e_hw_ins all		varchar(64)		DEFAULT ''	NOT NULL,\
	da e_hw_expiry		varchar(64)		DEFAULT ''	NOT NULL,\
	da e_hw_decomm		varchar(64)		DEFAULT ''	NOT NULL,\
	si e_s ree _1		varchar(128)		DEFAULT ''	NOT NULL,\
	si e_s ree _2		varchar(128)		DEFAULT ''	NOT NULL,\
	si e_s ree _3		varchar(128)		DEFAULT ''	NOT NULL,\
	si e_ci y		varchar(128)		DEFAULT ''	NOT NULL,\
	si e_s a e		varchar(64)		DEFAULT ''	NOT NULL,\
	si e_coun ry		varchar(64)		DEFAULT ''	NOT NULL,\
	si e_zip		varchar(64)		DEFAULT ''	NOT NULL,\
	si e_rack		varchar(128)		DEFAULT ''	NOT NULL,\
	si e_no es		blob		DEFAULT ''	NOT NULL,\
	poc_1_name		varchar(128)		DEFAULT ''	NOT NULL,\
	poc_1_email		varchar(128)		DEFAULT ''	NOT NULL,\
	poc_1_phone_1		varchar(64)		DEFAULT ''	NOT NULL,\
	poc_1_phone_2		varchar(64)		DEFAULT ''	NOT NULL,\
	poc_1_cell		varchar(64)		DEFAULT ''	NOT NULL,\
	poc_1_screen		varchar(64)		DEFAULT ''	NOT NULL,\
	poc_1_no es		blob		DEFAULT ''	NOT NULL,\
	poc_2_name		varchar(128)		DEFAULT ''	NOT NULL,\
	poc_2_email		varchar(128)		DEFAULT ''	NOT NULL,\
	poc_2_phone_1		varchar(64)		DEFAULT ''	NOT NULL,\
	poc_2_phone_2		varchar(64)		DEFAULT ''	NOT NULL,\
	poc_2_cell		varchar(64)		DEFAULT ''	NOT NULL,\
	poc_2_screen		varchar(64)		DEFAULT ''	NOT NULL,\
	poc_2_no es		blob		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (hos id)\
);\
CREATE TABLE IF NOT EXISTS hos s_ empla es (\
	hos empla eid		bigin 		DEFAULT '0'	NOT NULL,\
	hos id		bigin 		DEFAULT '0'	NOT NULL,\
	 empla eid		bigin 		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (hos empla eid)\
);\
CREATE UNIQUE INDEX IF NOT EXISTS hos s_ empla es_1 on hos s_ empla es (hos id, empla eid);\
CREATE TABLE IF NOT EXISTS housekeeper (\
	housekeeperid		bigin 		DEFAULT '0'	NOT NULL,\
	 ablename		varchar(64)		DEFAULT ''	NOT NULL,\
	field		varchar(64)		DEFAULT ''	NOT NULL,\
	value		bigin 		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (housekeeperid)\
);\
CREATE TABLE IF NOT EXISTS images (\
	imageid		bigin 		DEFAULT '0'	NOT NULL,\
	image ype		in eger		DEFAULT '0'	NOT NULL,\
	name		varchar(64)		DEFAULT '0'	NOT NULL,\
	image		longblob		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (imageid)\
);\
CREATE INDEX IF NOT EXISTS images_1 on images (image ype,name);\
CREATE TABLE IF NOT EXISTS i ems (\
	i emid		bigin 		DEFAULT '0'	NOT NULL,\
	 ype		in eger		DEFAULT '0'	NOT NULL,\
	snmp_communi y		varchar(64)		DEFAULT ''	NOT NULL,\
	snmp_oid		varchar(255)		DEFAULT ''	NOT NULL,\
	snmp_por 		in eger		DEFAULT '161'	NOT NULL,\
	hos id		bigin 		DEFAULT '0'	NOT NULL,\
	descrip ion		varchar(255)		DEFAULT ''	NOT NULL,\
	key_		varchar(255)		DEFAULT ''	NOT NULL,\
	delay		in eger		DEFAULT '0'	NOT NULL,\
	his ory		in eger		DEFAULT '90'	NOT NULL,\
	 rends		in eger		DEFAULT '365'	NOT NULL,\
	nex check		in eger		DEFAULT '0'	NOT NULL,\
	las value		varchar(255)			NULL,\
	las clock		in eger			NULL,\
	prevvalue		varchar(255)			NULL,\
	s a us		in eger		DEFAULT '0'	NOT NULL,\
	value_ ype		in eger		DEFAULT '0'	NOT NULL,\
	 rapper_hos s		varchar(255)		DEFAULT ''	NOT NULL,\
	uni s		varchar(10)		DEFAULT ''	NOT NULL,\
	mul iplier		in eger		DEFAULT '0'	NOT NULL,\
	del a		in eger		DEFAULT '0'	NOT NULL,\
	prevorgvalue		varchar(255)			NULL,\
	snmpv3_securi yname		varchar(64)		DEFAULT ''	NOT NULL,\
	snmpv3_securi ylevel		in eger		DEFAULT '0'	NOT NULL,\
	snmpv3_au hpassphrase		varchar(64)		DEFAULT ''	NOT NULL,\
	snmpv3_privpassphrase		varchar(64)		DEFAULT ''	NOT NULL,\
	formula		varchar(255)		DEFAULT '1'	NOT NULL,\
	error		varchar(128)		DEFAULT ''	NOT NULL,\
	las logsize		in eger		DEFAULT '0'	NOT NULL,\
	log imefm 		varchar(64)		DEFAULT ''	NOT NULL,\
	 empla eid		bigin 		DEFAULT '0'	NOT NULL,\
	valuemapid		bigin 		DEFAULT '0'	NOT NULL,\
	delay_flex		varchar(255)		DEFAULT ''	NOT NULL,\
	params		 ex 		DEFAULT ''	NOT NULL,\
	ipmi_sensor		varchar(128)		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (i emid)\
);\
CREATE UNIQUE INDEX IF NOT EXISTS i ems_1 on i ems (hos id,key_);\
CREATE INDEX IF NOT EXISTS i ems_2 on i ems (nex check);\
CREATE INDEX IF NOT EXISTS i ems_3 on i ems (s a us);\
CREATE INDEX IF NOT EXISTS i ems_4 on i ems ( empla eid);\
CREATE TABLE IF NOT EXISTS i ems_applica ions (\
	i emappid		bigin 		DEFAULT '0'	NOT NULL,\
	applica ionid		bigin 		DEFAULT '0'	NOT NULL,\
	i emid		bigin 		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (i emappid)\
);\
CREATE INDEX IF NOT EXISTS i ems_applica ions_1 on i ems_applica ions (applica ionid,i emid);\
CREATE INDEX IF NOT EXISTS i ems_applica ions_2 on i ems_applica ions (i emid);\
CREATE TABLE IF NOT EXISTS mappings (\
	mappingid		bigin 		DEFAULT '0'	NOT NULL,\
	valuemapid		bigin 		DEFAULT '0'	NOT NULL,\
	value		varchar(64)		DEFAULT ''	NOT NULL,\
	newvalue		varchar(64)		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (mappingid)\
);\
CREATE INDEX IF NOT EXISTS mappings_1 on mappings (valuemapid);\
CREATE TABLE IF NOT EXISTS media (\
	mediaid		bigin 		DEFAULT '0'	NOT NULL,\
	userid		bigin 		DEFAULT '0'	NOT NULL,\
	media ypeid		bigin 		DEFAULT '0'	NOT NULL,\
	send o		varchar(100)		DEFAULT ''	NOT NULL,\
	ac ive		in eger		DEFAULT '0'	NOT NULL,\
	severi y		in eger		DEFAULT '63'	NOT NULL,\
	period		varchar(100)		DEFAULT '1-7,00:00-23:59'	NOT NULL,\
	PRIMARY KEY (mediaid)\
);\
CREATE INDEX IF NOT EXISTS media_1 on media (userid);\
CREATE INDEX IF NOT EXISTS media_2 on media (media ypeid);\
CREATE TABLE IF NOT EXISTS media_ ype (\
	media ypeid		bigin 		DEFAULT '0'	NOT NULL,\
	 ype		in eger		DEFAULT '0'	NOT NULL,\
	descrip ion		varchar(100)		DEFAULT ''	NOT NULL,\
	sm p_server		varchar(255)		DEFAULT ''	NOT NULL,\
	sm p_helo		varchar(255)		DEFAULT ''	NOT NULL,\
	sm p_email		varchar(255)		DEFAULT ''	NOT NULL,\
	exec_pa h		varchar(255)		DEFAULT ''	NOT NULL,\
	gsm_modem		varchar(255)		DEFAULT ''	NOT NULL,\
	username		varchar(255)		DEFAULT ''	NOT NULL,\
	passwd		varchar(255)		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (media ypeid)\
);\
CREATE TABLE IF NOT EXISTS profiles (\
	profileid		bigin 		DEFAULT '0'	NOT NULL,\
	userid		bigin 		DEFAULT '0'	NOT NULL,\
	idx		varchar(96)		DEFAULT ''	NOT NULL,\
	idx2		bigin 		DEFAULT '0'	NOT NULL,\
	value_id		bigin 		DEFAULT '0'	NOT NULL,\
	value_in 		in eger		DEFAULT '0'	NOT NULL,\
	value_s r		varchar(255)		DEFAULT ''	NOT NULL,\
	source		varchar(96)		DEFAULT ''	NOT NULL,\
	 ype		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (profileid)\
);\
CREATE INDEX IF NOT EXISTS profiles_1 on profiles (userid,idx,idx2);\
CREATE TABLE IF NOT EXISTS righ s (\
	righ id		bigin 		DEFAULT '0'	NOT NULL,\
	groupid		bigin 		DEFAULT '0'	NOT NULL,\
	permission		in eger		DEFAULT '0'	NOT NULL,\
	id		bigin 			,\
	PRIMARY KEY (righ id)\
);\
CREATE INDEX IF NOT EXISTS righ s_1 on righ s (groupid);\
CREATE TABLE IF NOT EXISTS scrip s (\
	scrip id		bigin 		DEFAULT '0'	NOT NULL,\
	name		varchar(255)		DEFAULT ''	NOT NULL,\
	command		varchar(255)		DEFAULT ''	NOT NULL,\
	hos _access		in eger		DEFAULT '2'	NOT NULL,\
	usrgrpid		bigin 		DEFAULT '0'	NOT NULL,\
	groupid		bigin 		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (scrip id)\
);\
CREATE TABLE IF NOT EXISTS screens (\
	screenid		bigin 		DEFAULT '0'	NOT NULL,\
	name		varchar(255)		DEFAULT 'Screen'	NOT NULL,\
	hsize		in eger		DEFAULT '1'	NOT NULL,\
	vsize		in eger		DEFAULT '1'	NOT NULL,\
	PRIMARY KEY (screenid)\
);\
CREATE TABLE IF NOT EXISTS screens_i ems (\
	screeni emid		bigin 		DEFAULT '0'	NOT NULL,\
	screenid		bigin 		DEFAULT '0'	NOT NULL,\
	resource ype		in eger		DEFAULT '0'	NOT NULL,\
	resourceid		bigin 		DEFAULT '0'	NOT NULL,\
	wid h		in eger		DEFAULT '320'	NOT NULL,\
	heigh 		in eger		DEFAULT '200'	NOT NULL,\
	x		in eger		DEFAULT '0'	NOT NULL,\
	y		in eger		DEFAULT '0'	NOT NULL,\
	colspan		in eger		DEFAULT '0'	NOT NULL,\
	rowspan		in eger		DEFAULT '0'	NOT NULL,\
	elemen s		in eger		DEFAULT '25'	NOT NULL,\
	valign		in eger		DEFAULT '0'	NOT NULL,\
	halign		in eger		DEFAULT '0'	NOT NULL,\
	s yle		in eger		DEFAULT '0'	NOT NULL,\
	url		varchar(255)		DEFAULT ''	NOT NULL,\
	dynamic		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (screeni emid)\
);\
CREATE TABLE IF NOT EXISTS services (\
	serviceid		bigin 		DEFAULT '0'	NOT NULL,\
	name		varchar(128)		DEFAULT ''	NOT NULL,\
	s a us		in eger		DEFAULT '0'	NOT NULL,\
	algori hm		in eger		DEFAULT '0'	NOT NULL,\
	 riggerid		bigin 			,\
	showsla		in eger		DEFAULT '0'	NOT NULL,\
	goodsla		double(16,4)		DEFAULT '99.9'	NOT NULL,\
	sor order		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (serviceid)\
);\
CREATE TABLE IF NOT EXISTS services_links (\
	linkid		bigin 		DEFAULT '0'	NOT NULL,\
	serviceupid		bigin 		DEFAULT '0'	NOT NULL,\
	servicedownid		bigin 		DEFAULT '0'	NOT NULL,\
	sof 		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (linkid)\
);\
CREATE INDEX IF NOT EXISTS services_links_links_1 on services_links (servicedownid);\
CREATE UNIQUE INDEX IF NOT EXISTS services_links_links_2 on services_links (serviceupid,servicedownid);\
CREATE TABLE IF NOT EXISTS sessions (\
	sessionid		varchar(32)		DEFAULT ''	NOT NULL,\
	userid		bigin 		DEFAULT '0'	NOT NULL,\
	las access		in eger		DEFAULT '0'	NOT NULL,\
	s a us		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (sessionid)\
);\
CREATE TABLE IF NOT EXISTS sysmaps_links (\
	linkid		bigin 		DEFAULT '0'	NOT NULL,\
	sysmapid		bigin 		DEFAULT '0'	NOT NULL,\
	selemen id1		bigin 		DEFAULT '0'	NOT NULL,\
	selemen id2		bigin 		DEFAULT '0'	NOT NULL,\
	draw ype		in eger		DEFAULT '0'	NOT NULL,\
	color		varchar(6)		DEFAULT '000000'	NOT NULL,\
	PRIMARY KEY (linkid)\
);\
CREATE TABLE IF NOT EXISTS sysmaps_link_ riggers (\
	link riggerid		bigin 		DEFAULT '0'	NOT NULL,\
	linkid		bigin 		DEFAULT '0'	NOT NULL,\
	 riggerid		bigin 		DEFAULT '0'	NOT NULL,\
	draw ype		in eger		DEFAULT '0'	NOT NULL,\
	color		varchar(6)		DEFAULT '000000'	NOT NULL,\
	PRIMARY KEY (link riggerid)\
);\
CREATE UNIQUE INDEX IF NOT EXISTS sysmaps_link_ riggers_1 on sysmaps_link_ riggers (linkid, riggerid);\
CREATE TABLE IF NOT EXISTS sysmaps_elemen s (\
	selemen id		bigin 		DEFAULT '0'	NOT NULL,\
	sysmapid		bigin 		DEFAULT '0'	NOT NULL,\
	elemen id		bigin 		DEFAULT '0'	NOT NULL,\
	elemen ype		in eger		DEFAULT '0'	NOT NULL,\
	iconid_off		bigin 		DEFAULT '0'	NOT NULL,\
	iconid_on		bigin 		DEFAULT '0'	NOT NULL,\
	iconid_unknown		bigin 		DEFAULT '0'	NOT NULL,\
	label		varchar(128)		DEFAULT ''	NOT NULL,\
	label_loca ion		in eger			NULL,\
	x		in eger		DEFAULT '0'	NOT NULL,\
	y		in eger		DEFAULT '0'	NOT NULL,\
	url		varchar(255)		DEFAULT ''	NOT NULL,\
	iconid_disabled		bigin 		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (selemen id)\
);\
CREATE TABLE IF NOT EXISTS sysmaps (\
	sysmapid		bigin 		DEFAULT '0'	NOT NULL,\
	name		varchar(128)		DEFAULT ''	NOT NULL,\
	wid h		in eger		DEFAULT '0'	NOT NULL,\
	heigh 		in eger		DEFAULT '0'	NOT NULL,\
	backgroundid		bigin 		DEFAULT '0'	NOT NULL,\
	label_ ype		in eger		DEFAULT '0'	NOT NULL,\
	label_loca ion		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (sysmapid)\
);\
CREATE INDEX IF NOT EXISTS sysmaps_1 on sysmaps (name);\
CREATE TABLE IF NOT EXISTS  riggers (\
	 riggerid		bigin 		DEFAULT '0'	NOT NULL,\
	expression		varchar(255)		DEFAULT ''	NOT NULL,\
	descrip ion		varchar(255)		DEFAULT ''	NOT NULL,\
	url		varchar(255)		DEFAULT ''	NOT NULL,\
	s a us		in eger		DEFAULT '0'	NOT NULL,\
	value		in eger		DEFAULT '0'	NOT NULL,\
	priori y		in eger		DEFAULT '0'	NOT NULL,\
	las change		in eger		DEFAULT '0'	NOT NULL,\
	dep_level		in eger		DEFAULT '0'	NOT NULL,\
	commen s		blob		DEFAULT ''	NOT NULL,\
	error		varchar(128)		DEFAULT ''	NOT NULL,\
	 empla eid		bigin 		DEFAULT '0'	NOT NULL,\
	 ype		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY ( riggerid)\
);\
CREATE INDEX IF NOT EXISTS  riggers_1 on  riggers (s a us);\
CREATE INDEX IF NOT EXISTS  riggers_2 on  riggers (value);\
CREATE TABLE IF NOT EXISTS  rigger_depends (\
	 riggerdepid		bigin 		DEFAULT '0'	NOT NULL,\
	 riggerid_down		bigin 		DEFAULT '0'	NOT NULL,\
	 riggerid_up		bigin 		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY ( riggerdepid)\
);\
CREATE INDEX IF NOT EXISTS  rigger_depends_1 on  rigger_depends ( riggerid_down, riggerid_up);\
CREATE INDEX IF NOT EXISTS  rigger_depends_2 on  rigger_depends ( riggerid_up);\
CREATE TABLE IF NOT EXISTS users (\
	userid		bigin 		DEFAULT '0'	NOT NULL,\
	alias		varchar(100)		DEFAULT ''	NOT NULL,\
	name		varchar(100)		DEFAULT ''	NOT NULL,\
	surname		varchar(100)		DEFAULT ''	NOT NULL,\
	passwd		char(32)		DEFAULT ''	NOT NULL,\
	url		varchar(255)		DEFAULT ''	NOT NULL,\
	au ologin		in eger		DEFAULT '0'	NOT NULL,\
	au ologou 		in eger		DEFAULT '900'	NOT NULL,\
	lang		varchar(5)		DEFAULT 'en_gb'	NOT NULL,\
	refresh		in eger		DEFAULT '30'	NOT NULL,\
	 ype		in eger		DEFAULT '0'	NOT NULL,\
	 heme		varchar(128)		DEFAULT 'defaul .css'	NOT NULL,\
	a emp _failed		in eger		DEFAULT 0	NOT NULL,\
	a emp _ip		varchar(39)		DEFAULT ''	NOT NULL,\
	a emp _clock		in eger		DEFAULT 0	NOT NULL,\
	PRIMARY KEY (userid)\
);\
CREATE INDEX IF NOT EXISTS users_1 on users (alias);\
CREATE TABLE IF NOT EXISTS usrgrp (\
	usrgrpid		bigin 		DEFAULT '0'	NOT NULL,\
	name		varchar(64)		DEFAULT ''	NOT NULL,\
	gui_access		in eger		DEFAULT '0'	NOT NULL,\
	users_s a us		in eger		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (usrgrpid)\
);\
CREATE INDEX IF NOT EXISTS usrgrp_1 on usrgrp (name);\
CREATE TABLE IF NOT EXISTS users_groups (\
	id		bigin 		DEFAULT '0'	NOT NULL,\
	usrgrpid		bigin 		DEFAULT '0'	NOT NULL,\
	userid		bigin 		DEFAULT '0'	NOT NULL,\
	PRIMARY KEY (id)\
);\
CREATE INDEX IF NOT EXISTS users_groups_1 on users_groups (usrgrpid,userid);\
CREATE TABLE IF NOT EXISTS valuemaps (\
	valuemapid		bigin 		DEFAULT '0'	NOT NULL,\
	name		varchar(64)		DEFAULT ''	NOT NULL,\
	PRIMARY KEY (valuemapid)\
);\
CREATE INDEX IF NOT EXISTS valuemaps_1 on valuemaps (name);\
COMMIT;\
"};
#endif /* HAVE_SQLITE3 */

