/**
 * \file gui/mcqr_run_view/mcqrqprocess.cpp
 * \date 12/07/2021
 * \author Thomas Renne
 * \brief Overload the Qprocess for the MCQR process
 */

/*******************************************************************************
 * Copyright (c) 2021 Thomas Renne <thomas.renne@e.email>.
 *
 * This file is part of XTPcpp.
 *
 *     XTPcpp is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     XTPcpp is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with XTPcpp.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Thomas Renne <thomas.renne@e.email> - initial API and
 *implementation
 ******************************************************************************/

#include "mcqrqprocess.h"
#include <QDebug>

McqrQProcess::McqrQProcess(QObject *parent) : QProcess(parent)
{
}

McqrQProcess::~McqrQProcess()
{
}

qint64
McqrQProcess::write(const QByteArray &byte_array)
{
  m_RscriptRun.append(byte_array);
  QProcess::write(byte_array);
  return 0;
}

QString
McqrQProcess::getRScriptRun()
{
  return m_RscriptRun;
}
