#include <string>

static std::string twod_double = R"xio({{  1.,   2.,   3.,   4.},
 {  5.,   6.,   7.,   8.},
 {  9.,  10.,  11.,  12.}})xio";


static std::string threed_double = R"xio({{{  1.,   2.},
  {  3.,   4.},
  {  5.,   6.},
  {  7.,   8.}},
 {{  9.,  10.},
  { 11.,  12.},
  {  7.,   9.},
  { 11.,  14.}},
 {{  5.,  26.},
  {  7.,   8.},
  { 10.,   8.},
  {  4.,   3.}}})xio";


static std::string precision = R"xio({{ 4.259106431606, -1.430581499421,  3.817697028755,  4.383006177616},
 {-0.177621344479,  5.600555210482, -1.781512638644,  1.593885951139},
 {-7.200984733734, -1.979648916087,  2.546340079714, -3.516982077951},
 {-5.104814402579,  3.895103503297,  1.87804795987 ,  2.635840409147},
 {-1.194856450043, -8.325470293986,  4.246603560315, -1.442730205451}})xio";


static std::string big_exp = R"xio({{ 4.259106e+000, -1.430581e+000,  3.817697e+000,  4.383006e+000},
 {-1.776213e-001,  1.000000e+220,  1.000000e-124,  1.593886e+000},
 {-7.200985e+000, -1.979649e+000,  2.546340e+000, -3.516982e+000},
 {-5.104814e+000,  3.895104e+000,  1.878048e+000,  2.635840e+000},
 {-1.194856e+000, -8.325470e+000,  4.246604e+000, -1.442730e+000}})xio";


static std::string complex_numbers = R"xio({{ 4.259106-4.705763j, -1.430581+0.520437j,  3.817697-2.597525j, 
   4.383006+3.84805j , -0.177621-0.397616j,  5.600555-3.068297j, 
  -1.781513-2.063075j,  1.593886+3.179275j, -7.200985+0.594874j, 
  -1.979649+1.779254j},
 { 2.54634 +3.091267j, -3.516982+3.685722j, -5.104814-0.820075j, 
   3.895104-4.410618j,  1.878048-0.21541j ,  2.63584 +0.211594j, 
  -1.194856+0.80632j , -8.32547 -1.90801j ,  4.246604+4.198826j, 
  -1.44273 +1.553475j},
 {-4.04439 -1.507586j, -0.158305+0.41094j ,  4.805928-0.509466j, 
  -2.845422-2.17679j , -1.655801-2.041235j,  3.094426+0.63481j , 
  -2.523971+2.151913j, -5.309743+0.176187j,  9.759906-1.479582j, 
   5.319919+1.327789j},
 { 5.540089+3.73119j , -9.440361-3.321116j, -6.52187 +4.874783j, 
  -6.918355-1.505851j, -8.45827 +3.262051j,  7.797314-4.345385j, 
   5.007574-4.946467j,  3.868065+3.869446j,  0.235268+4.113181j, 
  -0.714639-3.005922j},
 { 1.368614-4.724486j, -3.949011+3.173349j, -0.053824-2.581724j, 
   3.665258-4.43917j ,  8.333974-4.324392j, -7.821421-0.261281j, 
  -0.090164+0.094293j, -5.343281-0.832049j, -1.262787-2.441571j, 
   5.03086 -1.184879j},
 {-0.382158+3.073844j,  5.954568+3.110391j, -4.345941+1.861869j, 
  -1.331635+4.926136j, -9.804853-0.948148j, -3.18408 -3.098263j, 
   3.78544 -0.118255j,  7.387386+0.023696j, -4.643924-0.966452j, 
  -0.865042-3.189046j},
 {-4.634374-4.519702j,  6.741056+1.046913j, -4.589707-2.340888j, 
   0.60124 +3.81347j , -6.492547+0.840461j, -3.700671-0.225395j, 
   7.822182-3.28485j , -6.393274-4.4338j  , -0.113676-3.429648j, 
  -5.754038-1.613825j},
 { 0.417537-0.59357j , -6.798001+1.838431j,  8.381136-2.941283j, 
   9.885798+1.164337j, -0.459049+4.244716j, -3.80233 -4.203717j, 
   0.144086-0.146032j, -4.384136+1.985636j,  5.276734-4.184315j, 
  -7.829154+3.691024j},
 { 0.233094-0.668943j,  8.195388-0.056699j, -5.63248 -0.042595j, 
  -2.737919-1.292779j,  7.099456+4.221287j,  4.227836+3.412782j, 
  -2.141112+1.555259j, -5.37397 -0.37315j , -2.396506+0.650113j, 
   0.983242-0.760845j},
 { 1.134381-2.117881j, -9.917307-2.360193j,  2.76045 +1.907382j, 
  -8.84704 +3.328365j, -9.139462+0.923916j,  7.501023-0.334774j, 
  -4.148248+1.7366j  ,  5.255353-1.085206j, -2.642695+2.021044j, 
   7.470045+4.656976j}})xio";


static std::string cut_long = R"xio({{1, 1, 1, ..., 1, 1, 1},
 {1, 1, 1, ..., 1, 1, 1},
 {1, 1, 1, ..., 1, 1, 1},
 {1, 1, 1, ..., 1, 1, 1},
 {1, 1, 1, ..., 1, 1, 1}})xio";


static std::string cut_both = R"xio({{1, 1, 1, ..., 1, 1, 1},
 {1, 1, 1, ..., 1, 1, 1},
 {1, 1, 1, ..., 1, 1, 1},
 ..., 
 {1, 1, 1, ..., 1, 1, 1},
 {1, 1, 1, ..., 1, 1, 1},
 {1, 1, 1, ..., 1, 1, 1}})xio";


static std::string cut_4d = R"xio({{{{1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   ..., 
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1}},
  {{1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   ..., 
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1}},
  {{1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   ..., 
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1}},
  ..., 
  {{1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   ..., 
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1}},
  {{1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   ..., 
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1}},
  {{1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   ..., 
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1}}},
 {{{1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   ..., 
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1}},
  {{1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   ..., 
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1}},
  {{1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   ..., 
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1}},
  ..., 
  {{1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   ..., 
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1}},
  {{1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   ..., 
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1}},
  {{1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   ..., 
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1}}},
 {{{1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   ..., 
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1}},
  {{1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   ..., 
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1}},
  {{1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   ..., 
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1}},
  ..., 
  {{1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   ..., 
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1}},
  {{1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   ..., 
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1}},
  {{1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   ..., 
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1}}},
 ..., 
 {{{1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   ..., 
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1}},
  {{1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   ..., 
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1}},
  {{1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   ..., 
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1}},
  ..., 
  {{1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   ..., 
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1}},
  {{1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   ..., 
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1}},
  {{1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   ..., 
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1}}},
 {{{1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   ..., 
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1}},
  {{1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   ..., 
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1}},
  {{1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   ..., 
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1}},
  ..., 
  {{1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   ..., 
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1}},
  {{1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   ..., 
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1}},
  {{1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   ..., 
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1}}},
 {{{1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   ..., 
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1}},
  {{1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   ..., 
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1}},
  {{1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   ..., 
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1}},
  ..., 
  {{1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   ..., 
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1}},
  {{1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   ..., 
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1}},
  {{1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   ..., 
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1},
   {1, 1, 1, ..., 1, 1, 1}}}})xio";


static std::string random_strings = R"xio({{          some,         random,         boring},
 {       strings,             in, xtensor xarray}})xio";


static std::string float_leading_zero = R"xio({{ 0.212955, -0.071529,  0.190885,  0.21915 , -0.008881,  0.280028, 
  -0.089076,  0.079694, -0.360049, -0.098982},
 { 0.127317, -0.175849, -0.255241,  0.194755,  0.093902,  0.131792, 
  -0.059743, -0.416274,  0.21233 , -0.072137},
 {-0.20222 , -0.007915,  0.240296, -0.142271, -0.08279 ,  0.154721, 
  -0.126199, -0.265487,  0.487995,  0.265996},
 { 0.277004, -0.472018, -0.326093, -0.345918, -0.422914,  0.389866, 
   0.250379,  0.193403,  0.011763, -0.035732},
 { 0.068431, -0.197451, -0.002691,  0.183263,  0.416699, -0.391071, 
  -0.004508, -0.267164, -0.063139,  0.251543},
 {-0.019108,  0.297728, -0.217297, -0.066582, -0.490243, -0.159204, 
   0.189272,  0.369369, -0.232196, -0.043252},
 {-0.231719,  0.337053, -0.229485,  0.030062, -0.324627, -0.185034, 
   0.391109, -0.319664, -0.005684, -0.287702},
 { 0.020877, -0.3399  ,  0.419057,  0.49429 , -0.022952, -0.190116, 
   0.007204, -0.219207,  0.263837, -0.391458},
 { 0.011655,  0.409769, -0.281624, -0.136896,  0.354973,  0.211392, 
  -0.107056, -0.268699, -0.119825,  0.049162},
 { 0.056719, -0.495865,  0.138023, -0.442352, -0.456973,  0.375051, 
  -0.207412,  0.262768, -0.132135,  0.373502}})xio";


static std::string cut_high = R"xio({{1},
 {1},
 {1},
 ..., 
 {1},
 {1},
 {1}})xio";


static std::string random_nan_inf = R"xio({{ 4.259106, -1.430581,  3.817697,  4.383006, -0.177621,  5.600555, 
  -1.781513,  1.593886, -7.200985, -1.979649,  2.54634 , -3.516982, 
  -5.104814,  3.895104,  1.878048,  2.63584 , -1.194856, -8.32547 , 
   4.246604, -1.44273 },
 {-4.04439 , -1.      ,  1.      , -2.845422, -1.655801,  3.094426, 
  -2.523971, -5.309743,  9.759906,  5.319919,  5.540089, -9.440361, 
  -6.52187 , -6.918355, -8.45827 ,  7.797314,  5.007574,  3.868065, 
   0.235268, -0.714639},
 { 1.368614, -3.949011,       inf,      -inf,  8.333974, -7.821421, 
  -0.090164, -5.343281, -1.262787,  5.03086 , -0.382158,  5.954568, 
  -4.345941, -1.331635, -9.804853, -3.18408 ,  3.78544 ,  7.387386, 
  -4.643924, -0.865042},
 {-4.634374,  6.741056, -4.589707,  0.60124 , -6.492547, -3.700671, 
   7.822182, -6.393274, -0.113676, -5.754038,  0.417537, -6.798001, 
   8.381136,  9.885798, -0.459049, -3.80233 ,  0.144086, -4.384136, 
   5.276734, -7.829154},
 { 0.233094,  8.195388, -5.63248 , -2.737919,       nan,  4.227836, 
  -2.141112, -5.37397 , -2.396506,  0.983242,  1.134381, -9.917307, 
   2.76045 , -8.84704 , -9.139462,  7.501023, -4.148248,  5.255353, 
  -2.642695,  7.470045},
 {-9.411525,  1.040874, -5.19505 ,  7.6961  , -0.795232, -6.136593, 
  -4.12615 ,  6.35855 ,  1.189747,  3.558509,  6.182534,  7.371443, 
  -1.640151, -8.821237, -0.43082 ,  0.423189,  1.61264 , -3.81602 , 
   8.397652,  3.10695 },
 {-3.015172,  0.821881, -1.018932, -4.353581, -4.08247 ,  1.26962 , 
   4.303826,  0.352374, -2.959163,  2.655577,  7.462381, -6.642231, 
   9.749566, -3.011701,  6.524103, -8.690769, -9.892934,  7.738893, 
   8.226363, -6.011844},
 {-9.448972,  6.346698, -5.163448, -8.87834 , -8.648783, -0.522563, 
   0.188585, -1.664097, -4.883141, -2.369758,  6.147689,  6.220783, 
   3.723737,  9.852273, -1.896296, -6.196526, -0.23651 ,  0.047393, 
  -1.932904, -6.378091},
 {-9.039404,  2.093827, -4.681776,  7.62694 ,  1.680922, -0.45079 , 
  -6.5697  , -8.8676  , -6.859295, -3.22765 , -1.187141,  3.676862, 
  -5.882566,  2.328674,  8.489432, -8.407435, -0.292063,  3.971273, 
  -8.36863 ,  7.382047},
 {-1.337886, -0.113399, -0.085191, -2.585558,  8.442573,  6.825565, 
   3.110518, -0.746299,  1.300226, -1.52169 , -4.235761, -4.720386, 
   3.814765,  6.656731,  1.847831, -0.669548,  3.4732  , -2.170413, 
   4.042087,  9.313953},
 {-8.189802, -8.837497,  1.760348,  5.023475,  0.226348,  8.410024, 
  -3.920718, -0.139945,  9.587207, -3.529835, -6.208657, -3.895418, 
  -3.117761,  3.590606, -8.9237  ,  6.132075,  2.059004,  3.104264, 
   4.953196,  0.712524},
 {-7.81687 , -0.076074, -6.553148,  3.679784,  0.596504,  2.504485, 
  -3.69714 , -0.169787,  6.402841, -7.347591, -7.57381 , -1.075701, 
  -9.181317, -3.989666, -1.812192, -2.549612, -3.200597,  6.251402, 
   0.564111,  1.076542},
 {-7.655863,  5.692096, -1.308276, -8.455545, -6.363769,  0.420217, 
  -0.413317, -3.72915 , -8.006616,  1.931053, -5.036602,  2.086803, 
  -3.897727,  7.946099,  1.640307,  4.249848,  3.672309,  8.932418, 
   8.264625, -8.974902},
 {-2.39369 ,  1.277131, -7.348525,  1.502706, -3.548645,  9.678551, 
   1.513316,  2.594553, -1.979754,  4.892601, -1.976282,  5.309503, 
   9.648625, -6.637665, -0.508106,  0.97881 , -1.277853, -4.065374, 
  -2.128725,  6.761622},
 { 3.032851,  9.077939, -0.459995,  7.577871,  5.844156, -4.69285 , 
   5.248765,  6.454728, -2.940153,  9.48464 ,  3.504667,  3.987593, 
  -0.808062, -8.605302,  9.959603,  2.755019, -8.636948, -7.077259, 
   6.778265, -4.456102},
 { 0.789019, -8.391345,  1.326935, -2.750302, -3.635727,  3.070465, 
  -2.90194 ,  4.305136,  2.56563 ,  9.350227, -4.37165 , -5.072099, 
  -8.449633,  7.84151 , -9.3091  , -0.170497, -9.981909,  7.783972, 
  -3.212051,  2.616364},
 {-3.385869,  7.779795,  4.586448, -8.113584,  4.134024,  7.608333, 
   0.810756,  9.514617, -0.599935, -9.215927,  0.269787,  0.436816, 
   1.589945,  6.745015, -2.984754,  8.22778 , -1.991758, -2.205407, 
  -1.954704, -7.920165},
 {-0.681457,  2.961423, -4.046124,  7.84679 , -0.428581, -4.352744, 
  -1.629202, -1.682069,  5.426159,  4.759028, -0.535463,  0.037947, 
   6.713306,  4.397586,  0.211848,  4.890704, -3.313785,  0.839388, 
   1.601047, -8.551511},
 { 3.58872 ,  4.407113,  1.049608,  0.099257, -8.345609,  1.612125, 
   2.578687,  1.733626,  4.454039, -8.312231,  9.610947, -7.572344, 
  -7.769007,  0.116085, -1.100301, -6.350003, -1.589225,  7.378157, 
   5.114439, -7.273815},
 {-6.417325,  1.029412,  1.246413, -1.370279, -2.788699,  0.373218, 
  -1.76683 , -9.41086 , -8.920649, -7.659411,  2.569412, -1.410808, 
  -7.417977, -2.567283,  5.480396,  4.847727, -8.649269,  4.136584, 
  -3.603764,  9.610047}})xio";


static std::string print_options_result = R"xio({{ 4.2591064316, -1.4305814994,  3.8176970288,  4.3830061776, -0.1776213445,  5.6005552105, -1.7815126386,  1.5938859511, -7.2009847337, -1.9796489161, ..., 
   1.1343811765, -9.9173071655,  2.760450376 , -8.8470396411, -9.139461943 ,  7.5010227444, -4.1482478699,  5.2553532664, -2.6426947385,  7.4700453614},
 {-9.4115253654,  1.0408744899, -5.1950499364,  7.6961002039, -0.7952315019, -6.1365934617, -4.1261498917,  6.3585501702,  1.1897474893,  3.5585089605, ..., 
  -4.2357610156, -4.7203856627,  3.8147645182,  6.6567306578,  1.8478314906, -0.6695482385,  3.4731996107, -2.1704128909,  4.0420874091,  9.3139529141},
 {-8.1898023489, -8.8374973132,  1.7603482476,  5.0234750844,  0.2263477806,  8.4100238586, -3.9207180445, -0.139945379 ,  9.5872069321, -3.5298347424, ..., 
   3.5046670094,  3.9875929331, -0.8080616344, -8.6053016645,  9.9596034323,  2.7550191523, -8.6369483274, -7.0772591799,  6.7782654526, -4.4561017137},
 { 0.7890194329, -8.3913445067,  1.3269347791, -2.7503017751, -3.6357272732,  3.0704652279, -2.9019400135,  4.3051361271,  2.5656298621,  9.3502266157, ..., 
   2.5694116162, -1.4108075651, -7.4179767494, -2.5672834157,  5.4803960597,  4.8477269726, -8.6492687081,  4.1365841284, -3.6037635514,  9.6100473723},
 {-6.8688488358, -5.9147360722, -0.3254980504, -0.4432930783, -8.6451064241,  0.4825582218,  6.4742113124, -1.5333826165,  1.6238035236,  5.0456922596, ..., 
  -8.907970271 ,  0.18649803  , -9.9543102044, -6.2819204702,  5.3891564207, -3.3120201622, -4.3563841708, -2.219026429 ,  1.3871931164,  1.2869286246},
 {-6.3042710386, -7.8792950167,  4.8002785251,  5.9913866833,  6.2776804059,  9.7214889689,  5.4955589139,  5.6252921014,  7.577437609 ,  7.257547502 , ..., 
   8.5663364244,  6.7513786277,  4.5776524274,  1.9506977271,  3.0531497184,  4.2059602795,  3.0692081464, -0.3337777986, -1.1924831894,  5.5755222404},
 {-9.9360143174, -7.8252918939,  0.9357223565, -0.4318962485, -7.4969360956,  8.7757765577,  5.490149909 , -2.9660779553,  5.2321713202,  3.1286268453, ..., 
  -0.7865411543,  7.0944427163, -8.5003798672, -0.9705943392,  4.8865678277,  2.4922847975, -8.259579232 ,  4.8378875582,  0.5414670781,  1.876758001 },
 { 1.293892469 ,  7.8727186438, -4.972623397 , -3.5229320218,  3.3804633975,  5.8755820434, -7.2976530169, -2.5884345174,  3.4962291201,  2.5881180456, ..., 
  -8.3196069801, -5.8129397724,  3.5503994193,  1.912760341 , -2.9211608073, -1.0535730789,  9.0423519795,  2.0698228727,  0.6368620153,  6.9564823215},
 { 3.9358404762,  0.5809243981, -0.9498240938,  6.898440392 , -5.4818767592, -5.0017919505, -2.9829227958,  5.7145039411, -8.1874937034, -9.2677064906, ..., 
   2.0794398741,  2.4170323022,  7.8038475493, -7.7127253907,  7.2106577371,  7.7389202457,  1.6675980486,  8.4511451276,  3.792580503 , -6.1656516322},
 { 9.0866831126,  5.9443540369,  7.1534989647, -7.508772471 , -8.0987910974,  3.4886813262,  2.1691338193, -2.2854097703, -6.8156659851, -0.1224009932, ..., 
  -4.4368127712,  1.0803095673, -3.7147775314,  6.4971630142,  8.3919628599,  4.0877859866,  4.8276491821, -1.742215113 , -8.597945096 ,  6.8729988406},
 ..., 
 {-3.151856391 ,  2.4390118942,  9.8334549245,  2.8587256739, -4.083950175 , -6.1374355029,  0.7666708995,  8.8843617064, -4.0865416894,  3.460927625 , ..., 
   9.1923774994,  2.2861329136,  8.9983777704, -7.9231060177, -0.9049750831,  4.4464730624, -5.4762394472,  7.8770915099,  5.7033579537,  0.016548383 },
 {-2.4788852044,  1.1656576499,  6.5928665383, -6.1366555538, -8.6411857519,  5.2052450675, -3.5959077694,  3.3344935488, -2.2047991068,  9.3559814814, ..., 
  -7.4537355115, -7.1201607588,  2.3992745913, -5.6769048416, -1.108305959 ,  6.1092005967, -3.526292617 , -3.031207394 , -3.2672616002,  6.2747284327},
 { 1.2279588003, -3.6163419543, -2.0786564667, -5.1491621651,  4.8967947546,  2.0128427608,  6.5801679558, -7.7133407724,  1.2911925826, -4.3470470189, ..., 
   2.4885760741,  0.516281461 ,  2.0317043678,  9.8593572754,  9.39050558  , -6.5182817973, -6.2139035714, -6.892220281 , -4.4423667759,  0.2460085642},
 { 1.1550892391, -9.9888950269,  3.6677261546, -1.9225639445, -3.9742847089,  9.8369094525,  1.0094657806,  7.0237851259,  4.7613542349, -2.5126619176, ..., 
  -8.4162629587, -3.24552804  , -3.5550699051,  8.5579495749,  4.0636289088, -3.1650726073,  4.791227718 , -6.6433645946,  6.1247442938, -2.3697889754},
 { 0.1790187416,  3.7869978784, -3.7214265386, -5.430811068 ,  0.0320440687,  7.9734318597, -8.3428800195,  8.4875692138, -8.0981588233,  5.1545232452, ..., 
   6.2912773739,  4.9564293744,  0.0382712411, -0.2348270118, -8.732937865 ,  8.8921533464, -2.630946671 ,  3.0153719251,  9.9166161566, -6.6299812283},
 { 9.1449987496,  2.4201323765,  5.8399717306,  8.0367330041, -9.7451837364,  1.6830851238, -2.1287651061, -6.8869386991, -3.0261938917,  9.1932040255, ..., 
  -1.4246246026,  9.4138344923, -4.0763188341, -7.8716496381, -4.5449281491, -1.0316709948, -7.7429029029, -5.8385824545, -1.6484059172,  7.6987670572},
 {-3.2993450647,  0.1656660217, -5.741487258 ,  7.6658710517,  7.4421535525, -8.7237405417, -1.6565722798, -9.5092800257, -2.9103572582, -9.0512625226, ..., 
   0.956576245 , -2.1176214529,  1.224063253 ,  9.4574798674,  1.5253960498,  9.0468728933,  1.4632485328,  5.388738737 , -5.0804525812,  9.9405982276},
 {-3.8595565152,  3.9711250838, -0.7466613442, -7.8472288594, -9.7060944334,  5.8814551806,  1.5839099422, -3.2811630355, -2.5670295888, -2.2946266962, ..., 
  -8.3226376255, -6.1266055234, -8.53220412  ,  0.0712064945, -8.6836749392,  1.1484328631, -9.9792581277, -7.8110753489,  9.4993486219,  6.8471466225},
 { 4.0164446191,  2.6124123025,  3.009438323 , -5.5299690191, -4.4891102742,  5.137638025 ,  5.7287509146, -2.275257769 ,  5.6551393668, -5.2959856257, ..., 
  -0.671183266 ,  6.450851233 ,  1.0147749194, -4.3992512334, -5.7095954354,  7.7680651531,  2.5030521106,  6.6729805346,  5.0310323451, -7.5703964152},
 { 0.5886834152,  4.6679436689, -8.592678009 , -7.6868968194,  7.1161214125, -1.4239915896,  6.2509497685,  8.4953751982,  9.7493446122,  7.2939809954, ..., 
   5.6044133488, -4.1291454101, -8.28053945  ,  3.5683828275, -1.2860306048, -9.0687648703,  3.8310462403, -9.0213947232,  2.1923222357, -6.3506701839}})xio";


static std::string long_strings = R"xio({{some, random very long and very very, boring},
 {strings, in, xtensor xarray}})xio";


static std::string bool_fn = R"xio({{ true, false,  true,  true, false},
 { true, false,  true, false, false},
 { true, false, false,  true,  true},
 { true, false, false,  true, false},
 {false, false,  true, false, false}})xio";


static std::string custom_formatter_result = R"xio({{     0x1,      0x2,      0x3,      0x4},
 {    0x64,     0xc8,    0x3e8, 0x989680}})xio";


static std::string complex_zero_erasing = R"xio({{ 0.212955-0.470576j, -0.071529+0.052044j,  0.190885-0.259752j, 
   0.21915 +0.384805j, -0.008881-0.039762j,  0.280028-0.30683j , 
  -0.089076-0.206307j,  0.079694+0.317928j, -0.360049+0.059487j, 
  -0.098982+0.177925j},
 { 0.127317+0.309127j, -0.175849+0.368572j, -0.255241-0.082008j, 
   0.194755-0.441062j,  0.093902-0.021541j,  0.131792+0.021159j, 
  -0.059743+0.080632j, -0.416274-0.190801j,  0.21233 +0.419883j, 
  -0.072137+0.155348j},
 {-0.20222 -0.150759j, -0.007915+0.041094j,  0.240296-0.050947j, 
  -0.142271-0.217679j, -0.08279 -0.204123j,  0.154721+0.063481j, 
  -0.126199+0.215191j, -0.265487+0.017619j,  0.487995-0.147958j, 
   0.265996+0.132779j},
 { 0.277004+0.373119j, -0.472018-0.332112j, -0.326093+0.487478j, 
  -0.345918-0.150585j, -0.422914+0.326205j,  0.389866-0.434538j, 
   0.250379-0.494647j,  0.193403+0.386945j,  0.011763+0.411318j, 
  -0.035732-0.300592j},
 { 0.068431-0.472449j, -0.197451+0.317335j, -0.002691-0.258172j, 
   0.183263-0.443917j,  0.416699-0.432439j, -0.391071-0.026128j, 
  -0.004508+0.009429j, -0.267164-0.083205j, -0.063139-0.244157j, 
   0.251543-0.118488j},
 {-0.019108+0.307384j,  0.297728+0.311039j, -0.217297+0.186187j, 
  -0.066582+0.492614j, -0.490243-0.094815j, -0.159204-0.309826j, 
   0.189272-0.011826j,  0.369369+0.00237j , -0.232196-0.096645j, 
  -0.043252-0.318905j},
 {-0.231719-0.45197j ,  0.337053+0.104691j, -0.229485-0.234089j, 
   0.030062+0.381347j, -0.324627+0.084046j, -0.185034-0.02254j , 
   0.391109-0.328485j, -0.319664-0.44338j , -0.005684-0.342965j, 
  -0.287702-0.161383j},
 { 0.020877-0.059357j, -0.3399  +0.183843j,  0.419057-0.294128j, 
   0.49429 +0.116434j, -0.022952+0.424472j, -0.190116-0.420372j, 
   0.007204-0.014603j, -0.219207+0.198564j,  0.263837-0.418432j, 
  -0.391458+0.369102j},
 { 0.011655-0.066894j,  0.409769-0.00567j , -0.281624-0.00426j , 
  -0.136896-0.129278j,  0.354973+0.422129j,  0.211392+0.341278j, 
  -0.107056+0.155526j, -0.268699-0.037315j, -0.119825+0.065011j, 
   0.049162-0.076084j},
 { 0.056719-0.211788j, -0.495865-0.236019j,  0.138023+0.190738j, 
  -0.442352+0.332837j, -0.456973+0.092392j,  0.375051-0.033477j, 
  -0.207412+0.17366j ,  0.262768-0.108521j, -0.132135+0.202104j, 
   0.373502+0.465698j}})xio";


