/*******************************************************************
 *
 * Licensed under a dual GPL/BSD license.  (See LICENSE file for more info.)
 *
 * File: xsup_debug.h
 *
 * Authors: Chris.Hessing@utah.edu
 *
 * $Id: xsup_debug.h,v 1.11 2005/07/21 04:24:25 chessing Exp $
 * $Date: 2005/07/21 04:24:25 $
 *******************************************************************/
#ifndef XSUP_DEBUG_H_
#define XSUP_DEBUG_H_

#include <netinet/in.h>
#include <sys/types.h>

#define DEBUG_NORMAL     0

#define NUM_DEBUG_CONFIG     1
#define DEBUG_CONFIG         0x01

#define NUM_DEBUG_STATE      2
#define DEBUG_STATE          0x02

#define NUM_DEBUG_AUTHTYPES  3
#define DEBUG_AUTHTYPES      0x04

#define NUM_DEBUG_INT        4
#define DEBUG_INT            0x08

#define NUM_DEBUG_SNMP       5
#define DEBUG_SNMP           0x10

#define NUM_DEBUG_EVERYTHING 6
#define DEBUG_EVERYTHING     0x20

#define NUM_DEBUG_EXCESSIVE  7
#define DEBUG_EXCESSIVE      0x40

void logfile_setup(char *);
void logfile_cleanup();
void lowercase(char *);
void debug_setdaemon(int);
void debug_printf(unsigned char, char *, ...);
void debug_printf_nl(unsigned char, char *, ...);
void debug_hex_printf(unsigned char, u_char *, int);
void debug_hex_dump(unsigned char, u_char *, int);
void debug_set_flags(int);
void debug_alpha_set_flags(char *);
int debug_getlevel();

#endif
