/*******************************************************************
 *
 * Licensed under a dual GPL/BSD license.  (See LICENSE file for more info.)
 *
 * File: wpa_common.h
 *
 *******************************************************************/

#ifndef _WPA_COMMON_H_
#define _WPA_COMMON_H_

#define AUTH_SUITE_RESERVED 0x00
#define AUTH_SUITE_DOT1X    0x01
#define AUTH_SUITE_PSK      0x02

#define CIPHER_NONE         0x00
#define CIPHER_WEP40        0x01
#define CIPHER_TKIP         0x02
#define CIPHER_WRAP         0x03
#define CIPHER_CCMP         0x04
#define CIPHER_WEP104       0x05

#define MAX_IE_LEN          255
#define RSC_LEN             6

int aes_unwrap(u_char *, int, u_char *, u_char *);
void rc4_skip(u_char *, int, int, u_char *, int);
void wpa_print_cipher_suite(unsigned char, unsigned char);
void wpa_print_auth_suite(unsigned char, unsigned char);
void wpa_PRF(unsigned char *, int, unsigned char *, int, unsigned char *, int,
	     unsigned char *, int);
void wpa_common_swap_rx_tx_mic(u_char *);

#endif
