#!/bin/sh

set -eu

VERSION=$2
TAR=../xslthl_$VERSION.orig.tar.gz
DIR=xslthl-$VERSION
TAG=$(echo "v$VERSION" | sed -re's,\.,_,g')

svn export http://xslthl.svn.sourceforge.net/svnroot/xslthl/tags/${TAG} $DIR
tar -c -z -f $TAR --exclude '*.jar' $DIR
rm -rf $DIR ../$TAG

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $TAR $origDir
  echo "moved $TAR to $origDir"
fi
