/*
 * Copyright 2005-2007 Luc Verhaegen.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef _VIA_VIDEO_H_
#define _VIA_VIDEO_H_ 1

#define ViaXVAdaptorName "VIA Unichrome HW video overlay"

/*
 * Stream specific stuff.
 */
struct ViaXvPort {
    int  brightness;
    int  saturation;
    int  contrast;
    int  hue;
    RegionRec clip;
    CARD32  ColorKey;
    Bool  autoPaint;
    CARD8 Opacity; /* 0x00-0x0F: for alpha */
    CARD8 Deinterlace;
#define VIA_DEINT_BOB        0x01
#define VIA_DEINT_INTERLEAVE 0x02

    int FourCC;

    struct ViaMem *Front[2];
    struct ViaMem *Back[3];

    CARD16  Width;
    CARD16  Height;
    CARD32  CbOffset;
    CARD32  CrOffset;

    struct ViaMem *AlphaFB;
    CARD8 *AlphaLocal; /* local buffer */
    CARD8 *AlphaLocalUnaligned; /* need 16byte alignment for dmablit. */

    short AlphaWidth;
    short AlphaHeight;

    /* positional information */
    short Src_X;
    short Src_Y;
    short Src_W;
    short Src_H;

    short Drw_X;
    short Drw_Y;
    short Drw_W;
    short Drw_H;

    short Offset_X;
    short Offset_Y;

    short Win_X;
    short Win_Y;
    short Win_W;
    short Win_H;
};


/*
 * Shadow registers for the Video3 overlay engine.
 */
struct ViaVideo3Shadow {
    CARD32 Control; /* Video3Control */

    CARD32 Zoom; /* Video3Zoom */
    CARD32 Minify; /* Video3Minify */

    CARD32 Fetch; /* V3_FETCH_COUNT bits of Video3AlphaFetch */
    CARD32 Fifo; /* Video3AlphaFifo & V3_FIFO_MASK */
    CARD32 PreFifo; /* Video3AlphaPreFifo & V3_PREFIFO_MASK */

    CARD32 SrcWidth; /* Video3SrcWidth */
    CARD32 Stride; /* Video3Stride */
    CARD32 WindowStart; /* Video3WindowStart */
    CARD32 WindowEnd; /* Video3WindowEnd */

    CARD32 Address0; /* Video3Address0 */
    CARD32 Address1; /* Video3Address1 */
    CARD32 Address2; /* Video3Address2 */
};


/*
 * General, top level struct.
 */
#include "xf86xv.h"

struct ViaSwov {
    int  scrnIndex;

    Bool  Allowed;
    Bool  Active;

    /* former HWDiff */
    Bool HQVDisablePatch;

    /* Track frame position */
    short frameX0;
    short frameY0;

    /* Memory mapped Video/HQV register access */
    struct ViaVideoRegs *Video;
    struct ViaHQVRegs *HQV;

    /* CPU side shadow(s) of the above. */
    struct ViaVideo3Shadow V3Shadow[1];

    XF86VideoAdaptorPtr Adaptor;
    XF86VideoAdaptorPtr *Adaptors;
    struct ViaXvPort *Port;
};

#endif /* _VIA_VIDEO_H_ */
