/*
 * Copyright 2004-2007 Luc Verhaegen.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 */

#ifndef HAVE_VIA_CRTC_H
#define HAVE_VIA_CRTC_H 1

/* Crtc->ID, track output vs crtc */
#define VIA_CRTC_PRIMARY   0
#define VIA_CRTC_SECONDARY 1

struct ViaCrtc {
    int scrnIndex;

    Bool Active;

    int  ID; /* track output vs crtc */
    char *Name; /* for pwetty pwint */

    int MaxOffset; /* Offset in the framebuffer, hardware maximum */
    int Offset; /* 0ffset in the framebuffer, in bytes */
    int bpp;

    int MinPitch, MaxPitch; /* Hardware maximum pitch */
    int Pitch; /* layout in framebuffer */
    int X, Y; /* frame offset from Offset */

    int VisiblePitch; /* scanned out width */
    DisplayModePtr Current;

    DisplayModePtr Modes;

    CARD32 PLLFlags;

    int (*ModeValidate) (struct ViaCrtc *Crtc, DisplayModePtr Mode);

    void (*Enable) (struct ViaCrtc *Crtc, Bool Enable);
    void (*Reset) (struct ViaCrtc *Crtc, Bool Reset);

    void (*ModeSet) (struct ViaCrtc *Crtc, DisplayModePtr Mode);
    /* merge into ModeSet */
    void (*FIFOSet) (struct ViaCrtc *Crtc, DisplayModePtr Mode);

#define PLL_FLAG_EXTERNAL 1 /* external source defines clock */
#define PLL_FLAG_HALVE    2 /* halve actual PLL */
#define PLL_FLAG_QUARTER  4 /* 1/4 actual PLL */
    void (*PLLSet) (struct ViaCrtc *Crtc, CARD32 Clock, int Flags);

    void (*FrameSet) (struct ViaCrtc *Crtc, int X, int Y);
    void (*GammaSet) (struct ViaCrtc *Crtc, int numColors, int *indices, LOCO *colors);
};

/* prototypes */
void ViaCrtcInit(ScrnInfoPtr pScrn);
void ViaCrtcInitForFB(ScrnInfoPtr pScrn, struct ViaCrtc *Crtc);
void ViaCrtcModeSetInitial(ScrnInfoPtr pScrn);

#endif /* HAVE_VIA_CRTC_H */
