/*
  xqbiff  -- "biff" program for qmail.
  Copyright (C) 1998-2003 Yusuke Ishizawa <yu-i@wmail.plala.or.jp>

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2, or (at your option) any
  later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
/*
 * pop.c
 *
 * ᡼ؿ POP3
 *
 */

#include"mail.h"
#include"md5.h"


#define POP_PORT 110

PopInfo   popinfo;
struct hostent *servhost;
struct servent *servinfo;
struct sockaddr_in server;
BOOL apop;   /* If server can connect by APOP then this value is TRUE */

extern BOOL PopWriteALine( int fd, char snd_str[] );

#define CR   '\r'
#define LF   '\n'

/*
#define DEBUG_POP
*/

int pop_timeout = 60;


/*******************************************************/
/* GetMD5String()                                      */
/* Ϳ줿ʸMD5ǥϥå夷ʸ */
/*******************************************************/
void GetMD5String( char *src, char *ret )
{

    int i;
    unsigned char digest[16];

    md5_buffer( src, strlen(src), digest );

    for( i=0 ; i<16 ; i++ ){
	sprintf( ret+2*i, "%02x", digest[i]);
    }

    return;
}


/***********************/
/* ConnectServ()       */
/* POPФ³ */
/***********************/
BOOL ConnectServ( int s )
{
    /* Connect server */
    while( 0 != connect( s, (struct sockaddr *)&server, sizeof(server) ) ){
#ifdef DEBUG
	fprintf( stderr, "xqbiff: POP Server connect failed." );
#endif
	return FALSE;
    }

    return TRUE;
}


/*********************************/
/* PopServerLoginAPOP()          */
/* POPФAPOPǥ󤹤 */
/*  1:               */
/*  0: ѥɥ顼          */
/* -1: ͥåȥ顼        */
/* -2: APOP б               */
/*********************************/
int PopServerLoginAPOP( int s )
{
    int i;
    char *rbp;
    char rbuff[2048]; /* Buffer for message receiving */
    char sbuff[2048]; /* Buffer for message sending */
    char temp[2048], temp1[2048];

#ifdef DEBUG
    fprintf( stderr, "PopServerLoginAPOP." );
#endif


    do{
	if( FALSE == PopReadALine( s, rbuff, 2048 ) ){
	    return -1;
	}

	if( 0==strncasecmp( rbuff, "-ERR", 4 ) ){
	    PopWriteALine( s, "QUIT\n" );
	    return -1;
	}

    } while( 0!=strncasecmp( rbuff, "+OK", 3 ) );

#ifdef DEBUG_POP
    fprintf( stderr, "POP:recv:%s\n", rbuff );
#endif

    if( NULL == strchr( rbuff, '<' ) || NULL == strchr( rbuff, '>' ) )
	return -2;


    /********************/
    /* Try connect APOP */
    /********************/
    i=0;
    while( rbuff[i] != '<' && rbuff[i] != '\0' ) i++;
    if( rbuff[i] == '<' ){
	rbp = &(rbuff[i]);
	while( rbuff[i] != '>' && rbuff[i] != '\0' ) i++;
	rbuff[i+1] = '\0';

	sprintf( temp, "%s%s", rbp, popinfo.passwd );

/*
#ifdef DEBUG_POP
    fprintf( stderr, "POP:string:%s\n", temp );
#endif
*/

/*
sprintf( temp, "<1896.697170952@dbc.mtview.ca.us>tanstaaf" );
*/
	GetMD5String( temp, temp1 ); 
/*
fprintf( stderr, "%s\n", temp1 );
*/

	sprintf( sbuff, "APOP %s %s\n", popinfo.user, temp1 );

#ifdef DEBUG
	fprintf( stderr, "Try connection APOP[%s]", temp );
#endif

#ifdef DEBUG_POP
    fprintf( stderr, "POP:send:%s\n", sbuff );
#endif
	if( FALSE == PopWriteALine( s, sbuff ) ){
	    return -1;
	}
	if( FALSE == PopReadALine( s, rbuff, 2048 ) ){
	    return -1;
	}
#ifdef DEBUG_POP
    fprintf( stderr, "POP:recv:%s\n", rbuff );
#endif
	if( 0==strncasecmp( rbuff, "+OK", 3 ) ){
	    return 1;
	} else if( 0==strncasecmp( rbuff, "-ERR", 4 ) ){
	    PopWriteALine( s, "QUIT\n" );
	    return 0;
	}
    }

    return 0;
}


/********************************/
/* PopServerLoginPOP()          */
/* POPФPOPǥ󤹤 */
/*  1:              */
/*  0: ѥɥ顼         */
/* -1: ͥåȥ顼       */
/* -2: POP б顼(̤) */
/********************************/
int PopServerLoginPOP( int s )
{
    char rbuff[2048]; /* Buffer for message receiving */
    char sbuff[2048]; /* Buffer for message sending */


#ifdef DEBUG
    fprintf( stderr, "PopServerLoginPOP." );
#endif

    do{
	if( FALSE == PopReadALine( s, rbuff, 2048 ) ){
	    return -1;
	}

	if( 0==strncasecmp( rbuff, "-ERR", 4 ) ){
	    PopWriteALine( s, "QUIT\n" );
	    return -1;
	}

    } while( 0!=strncasecmp( rbuff, "+OK", 3 ) );

#ifdef DEBUG_POP
    fprintf( stderr, "POP:recv:%s\n", rbuff );
#endif

    /*******************/
    /* Try connect POP */
    /*******************/
    sprintf( sbuff, "USER %s\n", popinfo.user );

#ifdef DEBUG_POP
    fprintf( stderr, "POP:send:%s\n", sbuff );
#endif

    if( FALSE == PopWriteALine( s, sbuff ) ){
	return -1;
    }

    if( FALSE == PopReadALine( s, rbuff, 2048 ) ){
	return -1;
    }
#ifdef DEBUG_POP
    fprintf( stderr, "POP:recv:%s\n", rbuff );
#endif
    if( 0 == strncasecmp( rbuff, "-ERR", 4 ) ){
	PopWriteALine( s, "QUIT\n" );
	return -2;
    }

    sprintf( sbuff, "PASS %s\n", popinfo.passwd );

#ifdef DEBUG_POP
    fprintf( stderr, "POP:send:%s\n", sbuff );
#endif

    if( FALSE == PopWriteALine( s, sbuff ) ){
	return -1;
    }

    if( FALSE == PopReadALine( s, rbuff, 2048 ) ){
	return -1;
    }
#ifdef DEBUG_POP
    fprintf( stderr, "POP:recv:%s\n", rbuff );
#endif
    if( 0 == strncasecmp( rbuff, "+OK", 3 ) ){
	return 1;
    } else if( 0 == strncasecmp( rbuff, "-ERR", 4 ) ){
	PopWriteALine( s, "QUIT\n" );
	return 0;
    }

    return -1;
}



/***************************************/
/* CheckPopConnect()                   */
/* POPФ³ǽå */
/***************************************/
/*
 *  > 0 ｪλ
 *  0 : ѥɥ顼
 * -1 : ³顼
 * -2 : ⡼ɻꥨ顼
 */

int CheckPopConnect()
{
    int s;
    int status = FALSE;


    servhost = gethostbyname(popinfo.server);
    if( servhost == NULL ){
	switch( h_errno ){
	case HOST_NOT_FOUND:
#ifdef DEBUG
	    fprintf( stderr, "Not found host.\n" );
#endif
	    break;
	case NO_ADDRESS:
#ifdef DEBUG
	    fprintf( stderr, "Host no address.\n" );
#endif
	    break;
	case NO_RECOVERY:
	case TRY_AGAIN:
#ifdef DEBUG
	    fprintf( stderr, "Name server error.\n" );
#endif
	    break;
	}
	return -1;
    }

    memset( (char*)&server, 0, sizeof(server) );
    memcpy( (char*)&server.sin_addr, servhost->h_addr, servhost->h_length);

    server.sin_port   = htons(POP_PORT);
    server.sin_family = AF_INET;


#ifdef DEBUG
	fprintf( stderr, "CheckPopConnect." );
#endif


    if( 0 != strcasecmp( popinfo.mode, "POP" ) ){

	/* Create socket */
	if( 0 > (s = socket( AF_INET, SOCK_STREAM, 0 )) ){
	    fprintf( stderr, "Socket failed.\n" );
	    return -1;
	}

	/* Connect server */
	if( FALSE == ConnectServ(s) ){
	    close(s);
	    return -1;
	}

	/* Try connect APOP */
#ifdef DEBUG
	fprintf( stderr, "xqbiff: Try connect to %s APOP.", popinfo.server );
	fflush( stderr );
#endif

	status = PopServerLoginAPOP(s);

	if( status == 1 ){
	    PopWriteALine( s, "QUIT\n" );
	}

	close(s);

	if( status == 1 ){
	    apop = TRUE;
#ifdef DEBUG
	    fprintf( stderr, "..Ok.\n" );
#endif
	    return 1;
	} else if( status == -1 ){
#ifdef DEBUG
	    fprintf( stderr, "..network error.\n" );
#endif
	    return -1;
	}

#ifdef DEBUG
	fprintf( stderr, "..login failed.\n" );
#endif
    } 

    if( 0 != strcasecmp( popinfo.mode, "APOP" ) ){

	/* Create socket */
	if( 0 > (s = socket( AF_INET, SOCK_STREAM, 0 )) ){
	    fprintf( stderr, "Socket failed.\n" );
	    return -1;
	}

	/* Connect server */
	if( FALSE == ConnectServ(s) ){
	    close(s);
	    return -1;
	}

	/* Try connect POP */
#ifdef DEBUG
	fprintf( stderr, "xqbiff: Try connect to %s POP.", popinfo.server );
	fflush( stderr );
#endif
	status = PopServerLoginPOP(s);

	if( status == 1 ){
	    PopWriteALine( s, "QUIT\n" );
	}

	close(s);

	if( status == 1 ){
	    apop = FALSE;
#ifdef DEBUG
	    fprintf( stderr, "..Ok.\n" );
#endif
	    return 1;
	} else if( status == -1 ){
#ifdef DEBUG
	    fprintf( stderr, "..network error.\n" );
#endif
	    return -1;
	}
    }

#ifdef DEBUG
    fprintf( stderr, "..failed.\n" );
#endif

    return status;
}

/*************************************/
/* GetPopInfo()                      */
/* POPե뤫ɤ߹ */
/*************************************/
void GetPopInfo()
{
    char buff[1024];
    FILE *fp;

    if( NULL == (fp = fopen( opinfo.poprc, "r" )) ){
	fprintf( stderr, "Can't open pop resource file.\n" );
	exit(2);
    }

    iStrInit( popinfo.mode, 255 );
    iStrInit( popinfo.server, 255 );
    iStrInit( popinfo.user, 255 );
    iStrInit( popinfo.passwd, 255 );

    while( NULL != fgets( buff, 1023, fp ) ){
	if( buff[0] != '#' && buff[0] != '\n' ){
	    if( 0 == strncasecmp( buff, "POPServer:", 10 ) )
		sscanf( buff, "POPServer:%s\n", popinfo.server );
	    else if( 0 == strncasecmp( buff, "Mode:", 5 ) )
		sscanf( buff, "Mode:%s\n", popinfo.mode );
	    else if( 0 == strncasecmp( buff, "User:", 5 ) )
		sscanf( buff, "User:%s\n", popinfo.user );
	    else if( 0 == strncasecmp( buff, "Password:", 9 ) )
		sscanf( buff, "Password:%s\n", popinfo.passwd );
	}
    }

    fclose(fp);

    return;
}




/*******************************************/
/* PopWriteALine()                         */
/* POPФ˰ʬʺ1024Хȡ */
/*******************************************/
BOOL PopWriteALine( int s, char str[] )
{
    int i;
    int writesize;       /* Write size(byte) */
    int bufsize;         /* Buffer size(byte) */
    char buff[1028], *pnt;

#ifdef DEBUG
    fprintf( stderr, "PopWriteALine." );
#endif

    strncpy( buff, str, 1024 );

    /* Create send message */
    i=0;
    while( buff[i]!='\0' && buff[i]!='\n' ) i++;
    buff[i++] = CR;
    buff[i++] = LF;
    buff[i] = '\0';

    /* Send message */
    pnt = buff;
    bufsize = i;
    while( bufsize != (writesize = write(s, pnt, bufsize)) ){
	if( writesize != -1 ){
	    pnt += writesize;
	    bufsize -= writesize;
	} else {
            if ( ( errno != EINTR ) && ( errno != EWOULDBLOCK )
                 && ( errno != ENOBUFS ) )  {
#ifdef DEBUG
                fprintf( stderr, "PopWriteALine: error %d.\n", errno );
#endif
                return FALSE;
            }
	}
    }

#ifdef DEBUG
    fprintf( stderr, "..Ok.\n" );
#endif

    return TRUE;
}



/***********************************/
/* PopReadALine()                  */
/* POPФʬ     */
/* ʸ ret_size           */
/* ret_size ۤʬ˴ */
/***********************************/
BOOL PopReadALine( int s, char *ret, size_t ret_size )
{
    char *cp = ret, *np;
    static char dust[256];
    int rsize, len = ret_size;
    int res;
    fd_set  fds;
    struct timeval tv;

#ifdef DEBUG
    fprintf( stderr, "PopReadALine.s=%d\n", s );
#endif

    FD_ZERO( &fds );
    FD_SET( s, &fds );
    tv.tv_sec = pop_timeout;
    tv.tv_usec = 0;

    if( 0 == select( s+1, &fds, NULL, NULL, &tv ) ){
	fprintf(stderr,"xqbiff: POP receive timeout (%d sec).\n",pop_timeout);
	return FALSE;
    }


    for(;;) {
	if( len == 0 ){
	    cp = dust;
	    len = 256;
	}

	rsize = recv( s, cp, len, MSG_PEEK );
	if( errno == EAGAIN ){
	    fprintf( stderr, "PopReadALine: No data.\n" );
	    return FALSE;
	} else if( rsize<0 ){
	    fprintf( stderr, "PopReadALine: Read error(%d(%s)).\n",
		     errno, strerror(errno) );
	    return FALSE;
	}
	np = memchr( cp, '\n', rsize );
	if( NULL == np ){
	    res = ReadByte( s, cp, rsize );
	    if( res == FALSE ){
		fprintf( stderr, "PopReadALine: Read error.\n" );
		return FALSE;
	    }
	    cp += rsize;
	    len -= rsize;
	    if( len < 0 ){
		len = 0;
	    }
	} else {
	    rsize = np - cp + 1;
	    res = ReadByte( s, cp, rsize );
	    if( res == FALSE ){
		fprintf( stderr, "PopReadALine: Read error.\n" );
		return FALSE;
	    }
	    cp[rsize-2] = '\0';
	    break;
	}
    }

    ret[len-1] = '\0';

#ifdef DEBUG
    fprintf( stderr, "..Ok.\n" );
#endif
/*
    fprintf( stderr, "PopReadALine. \"%s\"\n", ret );
*/

    return TRUE;
}


/*********************************************************/
/* GetMailInfoPop                                        */
/* ᡼ե뤫'From''Subject''Date'ɤ߹ */
/* ᡼뤬Ƥ 2                                */
/* ᡼뤬äƤ 1                                */
/* 󤫤Ѳ̵ 0                              */
/* ̵Ǥ륨顼 -1                                 */
/* ƻԤ׵᤹ -2                             */
/* ̿Ūʥ顼 -3 ֤                            */
/*********************************************************/
int GetMailInfoPop(MailInfo **mlist, int *mlist_n,
		   MailInfo **nlist, int *nlist_n,
		   BOOL force)
{
    int i, j;
    char temp[2048], buff[2048];

    int s;
    static int mailnmb[65536];
    static int mailsiz[65536];

    char from_tmp[2048], subj_tmp[2048], date_tmp[2048], to_tmp[2048];
    BOOL flag;

    int mailn = 0;
    static int old_mailn = 0;
    static time_t lasttime = 0;
    time_t newesttime = lasttime;
    int ret;

    static BOOL topflag = TRUE;

    int code = CODE_JIS;

#ifdef DEBUG
    fprintf( stderr, "GetMailInfoPop.\n" );
#endif

    /* Create socket */
    if( 0 > (s = socket( AF_INET, SOCK_STREAM, 0 )) ){
	fprintf( stderr, "Socket failed.\n" );
	close( s );
	return -1;
    }


    /* Connect server */
    while( 0 != connect( s, (struct sockaddr *)&server, sizeof(server) ) ){
	fprintf( stderr, "xqbiff: POP Server connection failed.\n" );
	close(s);
	return -1;
    }


    /* POP Server login */
    if( apop == TRUE ){
	if( 1 != PopServerLoginAPOP(s) ){
	    close(s);
	    return -1;
	}
    } else {
	if( 1 != PopServerLoginPOP(s) ){
	    close(s);
	    return -1;
	}
    }


    /* Count mails */
    if( FALSE == PopWriteALine( s, "LIST" ) ){
	close(s); return -1;
    }
    if( FALSE == PopReadALine( s, buff, 2048 ) ){
	close(s); return -1;
    }
    if( 0==strncasecmp( buff, "-ERR", 4 ) ){
#ifdef DEBUG
	fprintf( stderr, "Can't get mail list.\n" );
#endif
	PopWriteALine( s, "QUIT" );
	close( s );
	return -1;
    }

    flag = FALSE;
    mailn = 0;
    for(;;){
	if( FALSE == PopReadALine( s, buff, 2048 ) ){
	    close(s); return -1;
	}
	if( 0 == strcmp( buff, ".\0" ) ) break;

	i = mailnmb[mailn];
	j = mailsiz[mailn];
	sscanf( buff, "%d %d", &mailnmb[mailn], &mailsiz[mailn] );

	if( i != mailnmb[mailn] || j != mailsiz[mailn] ) flag = TRUE;

	mailn++;
    }

    *mlist_n = mailn;

    /*
     * ᡼ξ֤ѲƤʤнλ
     */
    if( force==FALSE && mailn == old_mailn && flag == FALSE ){
	PopWriteALine( s, "QUIT" );
	close( s );
#ifdef DEBUG
	fprintf( stderr, "Check mails...Ok.\n" );
#endif
	return 0;
    }

    /* ᡼,¤Τݤ */
    if( *mlist != NULL ){
	free( *mlist );
	mlist = NULL;
idbgout(__func__,"Memory free mlist");
    }
    if( mailn > 0 ){
	if( NULL == (*mlist = (MailInfo*)malloc(mailn*sizeof(MailInfo))) ){
	    fprintf( stderr, "GetMailInfoPop():: malloc: Memory over!"
		     " (%dmails %dbyte\n",mailn,mailn*sizeof(MailInfo) );
	    PopWriteALine( s, "QUIT" );
	    close( s );
	    return -3;
	}
idbgout(__func__,"Memory alloc mlist");
    }
    *nlist_n = 0;

#ifdef DEBUG
    fprintf( stderr, "MailInfo malloc...Ok.\n" );
#endif


    for( i=0 ; i<mailn ; i++ ){
#ifdef DEBUG
	fprintf( stderr, "Get mail info.%d\n", i+1 );
#endif

	if( topflag == TRUE ){

	    /* TOP ޥɤȤ */
	    sprintf( temp, "TOP %d 0", mailnmb[i] );

#ifdef DEBUG
	    fprintf( stderr, "COMMAND: %s\n", temp );
#endif
	    if( FALSE == PopWriteALine( s, temp ) ){
		close(s); free(mlist); mlist=NULL; return -1;
	    }

	    if( FALSE == PopReadALine( s, buff, 2048 ) ){
		close(s); return -1;
	    }
	    if( 0==strncasecmp( buff, "-ERR", 4 ) ){
#ifdef DEBUG
		fprintf( stderr, "Can't use TOP command.\n" );
#endif

		/* TOP ޥɤȤʤ, RETR ޥɤˤ */
		topflag = FALSE;

		sprintf( temp, "RETR %d", mailnmb[i] );
		if( FALSE == PopWriteALine( s, temp ) ){
		    close(s); free(mlist); mlist=NULL; return -1;
		}
	    }

	} else {

	    /* TOP ޥɤȤʤ */
	    sprintf( temp, "RETR %d", mailnmb[i] );
#ifdef DEBUG
	    fprintf( stderr, "COMMAND: %s\n", temp );
#endif
	    if( FALSE == PopWriteALine( s, temp ) ){
		close(s); free(mlist); mlist=NULL; return -1;
	    }
	}

	/* Read From,Subject and Date */
	flag = GetMailText( s, NULL, from_tmp, subj_tmp, date_tmp, to_tmp );

#ifdef DEBUG
	fprintf( stderr, "text decode.\n" );
#endif

	/* Decode to JIS from MIME */
	mimdecode( from_tmp, from_tmp, &code );
	changecodetojis(from_tmp,(*mlist)[i].from,XQB_TEXT_LEN,code); 

	mimdecode( subj_tmp, subj_tmp, &code );
	changecodetojis(subj_tmp,(*mlist)[i].subject,XQB_TEXT_LEN,code); 

	mimdecode( to_tmp, to_tmp, &code );
	changecodetojis(to_tmp,(*mlist)[i].to,XQB_TEXT_LEN,code); 

	strncpy( (*mlist)[i].date, date_tmp, XQB_DATE_LEN );

	/* Copy to structure from buffer */
	(*mlist)[i].ID = mailnmb[i];
	(*mlist)[i].ColorID = 0;
	(*mlist)[i].time = DateToTime( (*mlist)[i].date );

	/* If need newest data then ... */
	if( lasttime < (*mlist)[i].time ){
	    if( NULL == (*nlist =
			 (MailInfo*)realloc(*nlist,((*nlist_n)+1)*
					    sizeof(MailInfo))) ){
		fprintf( stderr, "GetMailInfoPop():: "
			 "realloc: Memory over!\n" );
		
		close(s); free(mlist); mlist=NULL;
idbgout(__func__,"Memory free mlist");
		return -3;
	    }
if(*nlist_n==0)idbgout(__func__,"Memory realloc nlist.");

	    (*nlist)[*nlist_n] = (*mlist)[i];
	    newesttime = iMax( newesttime, (*mlist)[i].time );
	    (*nlist_n)++;
	    ret = 2;
	}

#ifdef DEBUG
	fprintf( stderr, "..Ok.\n" );
#endif

	/* ᡼κǸޤãƤʤ,Ĥɤ߼ΤƤ */
	if( flag == 3 ){
	    do{
		if( FALSE == PopReadALine( s, buff, 2048 ) ){
		    close(s); free(mlist); mlist=NULL;
		    return -1;
		}
	    } while( 0!=strcmp( buff, "." ) );
	}
    }
    PopWriteALine( s, "QUIT" );

#ifdef DEBUG
	    fprintf( stderr, "Get info from server...Ok.\n" );
#endif

    close(s);

    old_mailn = mailn;
    lasttime = newesttime;

    return ret;
}
