/*
  xqbiff  -- "biff" program for qmail.
  Copyright (C) 1998-2003 Yusuke Ishizawa <yu-i@wmail.plala.or.jp>

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2, or (at your option) any
  later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
/*
 * list.c
 *
 * ᡼ꥹȺؿ
 *
 */

#include"list.h"

extern Pixel pixel_bg;
extern Pixel pixel_fg;

int list_begin = 0;         /* ꥹȥԥޥåפ,(-1) */
int list_end   = 0;         /* (-1)ޤǤʬƤ뤫    */

/*
#define DEBUG_PIXMAP
*/
void SetPixel( Display *d, GC gc, Pixel pix, BOOL f )
{
    static Pixel old = 0;

    if( pix != old || f == TRUE ){
	XSetForeground( d, gc, pix );
	old = pix;
    }

    return;
}

void DrawTilePixmap( Display *d, Drawable drw, GC gc, Pixmap pmap,
		     int pw, int ph, int py,
		     int arw, int arh, int ary )
{
    int xp = 0, yp = ary;
    int pyoff = py % ph;

    if( pyoff != 0 ){
	for( xp = 0 ; xp < arw ; xp+=pw ){
	    XCopyArea( d, pmap, drw, gc, 0, pyoff, iMin(pw,(arw-xp)),
		       iMin((ph-pyoff),ph), xp, yp );
	}
	yp += (ph-pyoff);
    }

    for( ; yp < py+arh ; yp+=ph ){
	for( xp = 0 ; xp < arw ; xp+=pw ){
	    XCopyArea( d, pmap, drw, gc, 0, 0, iMin(pw,(arw-xp)),
		       iMin(ph,(py+arh-yp)), xp, yp );
	}
    }

    return;
}


/*****************************************/
/* DrawListPixmap                        */
/*****************************************/
void DrawListPixmap( Display *d, Window wnd, Colormap cmap, GC *gc,
		     Pixmap *pmap, int depth, TextInfo *tinfo, iFontSet *ifs,
		     MailInfo *minfo, int nmail, iSize *isize,
		     Pixmap bgpmap[], int y_locate, int nsbj, BOOL force )
{
    int    i, id;
    int    xl, xlb;
    char   temp[8];
    static int y_locate_old = 0;

    int sml = iMax(0,(y_locate/MH));  /* (-1)Υ᡼뤫褹뤫 */
    int nml = iMin(nmail-sml,nsbj+1); /* 鲿ʬ褹뤫 */
    int yoff, yoff_def = MH - (y_locate % MH);
    int foff, soff;


#ifdef DEBUG_PIXMAP
    fprintf( stderr, "DrawListPixmap mail=%d * %d  %d.\n", sml, nml, y_locate );
#endif


    if( force==FALSE && y_locate_old==y_locate ){
#ifdef DEBUG_PIXMAP
	fprintf( stderr, "DrawListPixmap.cancel exit. %d\n", y_locate );
#endif
	return;
    }

    y_locate_old = y_locate;

    if( force == TRUE  && *pmap != 0 ){
	XFreePixmap( d, *pmap );
	*pmap = 0;
    }
    if( *pmap == 0 ){
	/* Ԥޤä׺ƺ */
#ifdef DEBUG_PIXMAP
	fprintf( stderr, "CreateListPixmap  %d  %dx%d.\n",tinfo->tinf[0].bgc, isize->width,isize->height+2*MH);
#endif
	if( *gc != 0 ) XFreeGC( d, *gc );


	*pmap = XCreatePixmap( d, wnd, isize->width, isize->height+2*MH, depth );
	*gc = XCreateGC( d, *pmap, 0, 0 );
    }


    SetPixel( d, *gc, tinfo->tinf[0].bgc, TRUE );
    XFillRectangle( d, *pmap, *gc, 0, 0, isize->width, isize->height+2*MH );

    /*
     * 賫
     */
    xlb = 5 + XTextWidth( ifs->ascii, "000:", 5 );

    /* ط */
    yoff = yoff_def;
    for( i=0 ; i<nml ; i++ ){

	if( bgpmap[minfo[i+sml].ColorID] != 0 ){
	    XCopyArea( d, bgpmap[minfo[i+sml].ColorID], *pmap, *gc, 0, yoff-MH,
		       isize->width, MH+10, 0, yoff );
	}
	yoff += (LINE_H * 3);
    }


    yoff_def += (LINE_H - 5);

    /* Index */
    yoff = yoff_def;
    XSetFont( d, *gc, ifs->ascii->fid );
    for( i=0 ; i<nml ; i++ ){
	SetPixel( d, *gc, tinfo->tinf[minfo[i+sml].ColorID].numbc, FALSE );
	sprintf( temp, "%3d:", i + sml + 1 );
	xl = XTextWidth( ifs->ascii, temp, strlen(temp) );
	XDrawString( d, *pmap, *gc, xlb-xl, yoff, temp, strlen(temp) );
	if( tinfo->tinf[minfo[i+sml].ColorID].numbbold )
	    XDrawString( d, *pmap, *gc, xlb-xl, yoff-1, temp, strlen(temp) );

	yoff += (LINE_H * 3);
    }

    /* Date */
    yoff = yoff_def;
    for( i=0 ; i<nml ; i++ ){
	SetPixel( d, *gc, tinfo->tinf[minfo[i+sml].ColorID].datenc, FALSE );
	iXmbDrawString( d, *pmap, ifs, *gc, xlb, yoff,
			minfo[i+sml].date, strlen(minfo[i+sml].date),
			DW, tinfo->tinf[minfo[i+sml].ColorID].datenbold );
	yoff += (LINE_H * 3);
    }

    /* "From: " */
    yoff = yoff_def + LINE_H;
    foff = XTextWidth( ifs->ascii, " From:", 6 );
    for( i=0 ; i<nml ; i++ ){
	SetPixel( d, *gc, tinfo->tinf[minfo[i+sml].ColorID].fromtc, FALSE );
	XDrawString( d, *pmap, *gc, xlb, yoff, " From:", 6 );
	if( tinfo->tinf[minfo[i+sml].ColorID].fromtbold )
	    XDrawString( d, *pmap, *gc, xlb, yoff-1, " From:", 6 );
	yoff += (LINE_H * 3);
    }

    /* "Subject" */
    yoff = yoff_def + (LINE_H * 2);
    soff = XTextWidth( ifs->ascii, " Subject:", 9 );
    for( i=0 ; i<nml ; i++ ){
	SetPixel( d, *gc, tinfo->tinf[minfo[i+sml].ColorID].subjtc, FALSE );
	XDrawString( d, *pmap, *gc, xlb, yoff, " Subject:", 9 );
	if( tinfo->tinf[minfo[i+sml].ColorID].subjtbold )
	    XDrawString( d, *pmap, *gc, xlb, yoff-1, " Subject:", 9 );
	yoff += (LINE_H * 3);
    }

    /* From */
    yoff = yoff_def + LINE_H;
    for( i=0 ; i<nml ; i++ ){
	SetPixel( d, *gc, tinfo->tinf[minfo[i+sml].ColorID].fromnc, FALSE );
	iXmbDrawString( d, *pmap, ifs, *gc, xlb + foff, yoff,
			minfo[i+sml].from, strlen(minfo[i+sml].from),
			DW, tinfo->tinf[minfo[i+sml].ColorID].fromnbold );
	yoff += (LINE_H * 3);
    }

    /* Subject */
    yoff = yoff_def + (LINE_H * 2);
    for( i=0 ; i<nml ; i++ ){
	SetPixel( d, *gc, tinfo->tinf[minfo[i+sml].ColorID].subjnc, FALSE );
	iXmbDrawString( d, *pmap, ifs, *gc, xlb + soff, yoff,
			minfo[i+sml].subject,
			strlen(minfo[i+sml].subject),
			DW, tinfo->tinf[minfo[i+sml].ColorID].subjnbold );
	yoff += (LINE_H * 3);
    }

    return;
}


/************************************************/
/* GetMailRect                                  */
/* Get virtual list size from mail information. */
/************************************************/
void GetMailRect( iFontSet *ifs, MailInfo *minfo, int nmail, iSize *rsize )
{
    int i, xlb;
    int maxw = 0;

#ifdef DEBUG
    fprintf( stderr, "GetMailRect." );
#endif

    if( minfo == NULL || nmail == 0 ){
	rsize->width = 0;
	rsize->height = 0;
    } else {
	/* Τ */
	rsize->height = nmail * MH + 10;

	/* ϤФΤ */
	xlb = 5 + XTextWidth( ifs->ascii, "000:", 5 );
	for( i=0 ; i<nmail ; i++ ){
	    maxw = iMax( maxw, iXmbTextWidth( ifs,  minfo[i].date,
					      strlen(minfo[i].date) ) );
	    maxw = iMax( maxw, XTextWidth( ifs->ascii, " From:", 6 ) 
			 + iXmbTextWidth( ifs, minfo[i].from,
					  strlen(minfo[i].from) ) );
	    maxw = iMax( maxw, XTextWidth( ifs->ascii, " Subject:", 9 ) 
			 + iXmbTextWidth( ifs, minfo[i].subject,
					  strlen(minfo[i].subject) ) );
	}
	rsize->width = xlb + maxw + 20;
    }

#ifdef DEBUG
    fprintf(stderr,"GetMailRect.Ok. (%dx%d)\n",rsize->width,rsize->height);
#endif

    return;
}


/*******************************/
/* CopyList                    */
/* Copy pixmap image to window */
/*******************************/
void CopyList( Display *d, Window wnd, GC gc, Pixmap pmap,
	       int nsbj, int width, int y_locate, XSizeHints *sh )
{
    if( pmap == 0 || nsbj == 0 ) return;

    if( opinfo.nocapt == 1 ){
	XCopyArea( d, pmap, wnd, gc, 0, MH,
		   width-SCBAR_SIZE, MH*nsbj+10, 0, LINE_H+5 );
	DrawScrollBar( d, wnd, gc, width-SCBAR_SIZE, LINE_H+5 );
    } else {
	XCopyArea( d, pmap, wnd, gc, 0, MH,
		   width, MH*nsbj+10, 0, LINE_H+5 );
    }

    return;
}


/*
#define DEBUG
*/


/*******************************************/
/* CreateMessagePixmap                     */
/* ʸ褷,ԥޥåפ */
/*******************************************/
Pixmap CreateMessagePixmap( Display *d, Window wnd, Colormap cmap, int depth,
			    char *mes, TextInfo *tinfo, iFontSet *ifs,
			    iSize *isize )
{
    GC     gc;
    Pixmap pmap;
    int    i;
    int    linen = 1;
    char   *buff = NULL;
    char   *list[16] = { NULL };  /* 16Ԥޤɽ */
    int    wtmp = 0;


idbgout(__func__,"ENTER <%s>",mes);

 
    if( strlen(mes) == 0 ){
	fprintf(stderr,"xqbiff: CreateMessagePixmap() error.\n");
	return 0;
    }

    buff = (char*)malloc(strlen(mes)+1);
    strcpy(buff,mes);


   /* '\n' , Կ */
    i=0;
    list[0] = buff;
    while( buff[i] != '\0' && i < 1024 ){
	if( buff[i] == '\n' ){
	    buff[i] = '\0';
	    list[linen] = &(buff[i+1]);
	    linen++;
	}
	i++;
    }

    for( i=0 ; i<linen ; i++ ){
	wtmp = iXmbMlTextWidth( ifs, list[i], strlen(list[i]) ) + 20;
	isize->width = iMax( isize->width, wtmp );
    }
    isize->height = (LINE_H+5) * linen + 5;

#ifdef DEBUG
    fprintf( stderr, "CreateMessagePixmap.Width=%d Height=%d\n",
	     isize->width, isize->height );
#endif

    /* Create a pixmap and a gc */
    pmap = XCreatePixmap( d, wnd, isize->width, isize->height, depth );
    gc = XCreateGC( d, pmap, 0, 0 );

    /* Set and Paint background color */
    XSetForeground( d, gc, pixel_bg );
    XFillRectangle( d, pmap, gc, 0, 0, isize->width, isize->height );

    /* Set default color */
    XSetForeground( d, gc, pixel_fg );

    for( i=0 ; i<linen ; i++ ){
	iXmbDrawMlString( d, pmap, ifs, gc, 10, LINE_H*(i+1)+5,
			  list[i], strlen(list[i]), DW );
    }
    XFreeGC( d, gc );

idbgout(__func__,"EXIT");

    free(buff);

    return pmap;
}


void InitColorInfo( Display *d, Colormap cmap, TextInfo *tinfo )
{
    int i;

#ifdef HAVE_IMLIB_H
    /* Imlib бƤߤޤ礫 */
    ImlibImage *im;
    char temp[1024];
#endif

    /* ǥեȿ */
    tinfo->hdfgc = iNametoPixel( d, cmap, tinfo->headerfg );
    tinfo->hdbgc = iNametoPixel( d, cmap, tinfo->headerbg );

    /* ᡼ο */
    for( i=0 ; i<TEXT_COLOR_INFO_MAX ; i++ ){
#ifdef HAVE_IMLIB_H

	if( 0 == strcasecmp(tinfo->tinf[i].bgpname,"transparent") ){
	    /* ƩطʤΤȤ */
	    tinfo->tinf[i].bgp = -1;
	    iBitSet(transcfg,i);

	} else if( TRUE == iFilefullnameCreate( tinfo->tinf[i].bgpname, temp )
	    && 0 == iAccess( temp, I_F_OK | I_R_OK ) ){
	    /* ΤȤ */
	    ImlibColorModifier mod;

	    im = Imlib_load_image( imlibdata, temp );
	    tinfo->tinf[i].bgp_w = im->rgb_width;
	    tinfo->tinf[i].bgp_h = im->rgb_height;

	    /*  BrightnessContrast Ĵ */
	    Imlib_get_image_modifier(imlibdata,im,&mod);
	    mod.brightness = (double)mod.brightness
		* (((double)tinfo->tinf[i].bgp_brt)/100);
	    mod.contrast = (double)mod.contrast
		* (((double)tinfo->tinf[i].bgp_cont)/100);
	    Imlib_set_image_modifier(imlibdata,im,&mod);

	    if( tinfo->tinf[i].bgcname[0] != '\0' ){
		/* طʿꤵƤϲοĴѲ */
		int r, g, b;
		ImlibColorModifier rm = {0xFF,0xFF,0xFF},
		                   gm = {0xFF,0xFF,0xFF},
			           bm = {0xFF,0xFF,0xFF};

		tinfo->tinf[i].bgc = iNametoPixel(d,cmap,
						  tinfo->tinf[i].bgcname);
		iPixeltoRGB(d,cmap,tinfo->tinf[i].bgc,&r,&g,&b);
		rm.brightness = r/256;
		gm.brightness = g/256;
		bm.brightness = b/256;
		Imlib_set_image_red_modifier(imlibdata,im,&rm);
		Imlib_set_image_green_modifier(imlibdata,im,&gm);
		Imlib_set_image_blue_modifier(imlibdata,im,&bm);
	    }

	    Imlib_render( imlibdata, im, im->rgb_width, im->rgb_height );
	    tinfo->tinf[i].bgp = Imlib_move_image( imlibdata, im );

	    Imlib_kill_image( imlibdata, im );

	} else {
	    /* ΤȤ */
	    tinfo->tinf[i].bgc = iNametoPixel(d,cmap,tinfo->tinf[i].bgcname);
	}
#else
	tinfo->tinf[i].bgc = iNametoPixel(d,cmap,tinfo->tinf[i].bgcname);
#endif
	tinfo->tinf[i].fromtc = iNametoPixel(d,cmap,tinfo->tinf[i].fromt);
	tinfo->tinf[i].fromnc = iNametoPixel(d,cmap,tinfo->tinf[i].fromn);
	tinfo->tinf[i].subjtc = iNametoPixel(d,cmap,tinfo->tinf[i].subjt);
	tinfo->tinf[i].subjnc = iNametoPixel(d,cmap,tinfo->tinf[i].subjn);
	tinfo->tinf[i].datenc = iNametoPixel(d,cmap,tinfo->tinf[i].daten);
	tinfo->tinf[i].numbc = iNametoPixel(d,cmap,tinfo->tinf[i].numb);

	if( i>=1 &&
	    strlen(tinfo->tinf[0].command)>0 &&
	    strlen(tinfo->tinf[i].command) == 0 ){
	    strcpy( tinfo->tinf[i].command, tinfo->tinf[0].command );
	}
    }

    return;
}


/******************************************************/
/* ScrollList                                         */
/* ꥹȤΥͤȺɸη׻                   */
/******************************************************/
int ScrollList( int y_locate, int mov, BOOL dir, int nsbj, iSize *vsize )
{
    int ret = y_locate;

    if( dir == TRUE ){
	ret = y_locate - mov;
    } else {
	ret = y_locate + mov;
    }

    if( (vsize->height - ret) < (MH*nsbj + 10) ){
	ret = vsize->height - (MH*nsbj) - 10;
    }
    if( ret < 0 ) ret = 0;

    return ret;
}


/*****************************/
/* DrawListTitle             */
/* Draw title header string. */
/*****************************/
void DrawListTitle(Display *d, Window wnd, GC gc, Colormap cmap,
		   TextInfo *tinfo, iFontSet *ifs,
		   char *mes_title, int ww, int wh, int depth )
{
    static int tl=0, ts=0;
#ifdef __SMOOTH_COLOR__
    static int tl2=0, ts2=0;
    static int tl3=0, ts3=0;
    static int tl4=0, ts4=0;
    static int tl5=0, ts5=0;
    static int tl6=0, ts6=0;
#endif

    if( tl == 0 ){
	tl = iGetColorPixelRate( d, cmap, tinfo->hdbgc, 50, TRUE );
	ts = iGetColorPixelRate( d, cmap, tinfo->hdbgc, 75, FALSE );
#ifdef __SMOOTH_COLOR__
	if( depth >= 16 && opinfo.flat_face == FALSE ){
	    tl2 = iGetColorPixelRate( d, cmap, tinfo->hdbgc, 108, FALSE );
	    tl3 = iGetColorPixelRate( d, cmap, tinfo->hdbgc, 106, FALSE );
	    tl4 = iGetColorPixelRate( d, cmap, tinfo->hdbgc, 104, FALSE );
	    tl5 = iGetColorPixelRate( d, cmap, tinfo->hdbgc, 102, FALSE );
	    tl6 = iGetColorPixelRate( d, cmap, tinfo->hdbgc, 101, FALSE );

	    ts2 = iGetColorPixelRate( d, cmap, tinfo->hdbgc, 99, FALSE );
	    ts3 = iGetColorPixelRate( d, cmap, tinfo->hdbgc, 98, FALSE );
	    ts4 = iGetColorPixelRate( d, cmap, tinfo->hdbgc, 96, FALSE );
	    ts5 = iGetColorPixelRate( d, cmap, tinfo->hdbgc, 93, FALSE );
	    ts6 = iGetColorPixelRate( d, cmap, tinfo->hdbgc, 89, FALSE );
	}
#endif
    }

    /* Painting title area */
    XSetForeground( d, gc, tinfo->hdbgc );
    XFillRectangle( d, wnd, gc, WD, WD, ww-(WD*2), LINE_H+5-(WD*2) );

    XSetForeground( d, gc, tl );
    XFillRectangle( d, wnd, gc, 0, 0, WD, LINE_H+5 );
    XFillRectangle( d, wnd, gc, 0, 0, ww, WD );

    XSetForeground( d, gc, ts );
    XFillRectangle( d, wnd, gc, 0, LINE_H+5-WD, ww, WD );
    XFillRectangle( d, wnd, gc, ww-WD, WD, WD, LINE_H+5-WD );

#ifdef __SMOOTH_COLOR__
    if( depth >= 16 && opinfo.flat_face == FALSE ){
	XSetForeground( d, gc, tl2 );
	XFillRectangle( d, wnd, gc, WD, WD, ww-(WD*2), WD );

	XSetForeground( d, gc, ts2 );
	XFillRectangle( d, wnd, gc, WD, LINE_H+5-(WD*2), ww-(WD*2), WD );

	XSetForeground( d, gc, ts2 );
	XFillRectangle( d, wnd, gc, WD, LINE_H+5-(WD*6), ww-(WD*2), WD );
	XSetForeground( d, gc, ts3 );
	XFillRectangle( d, wnd, gc, WD, LINE_H+5-(WD*5), ww-(WD*2), WD );
	XSetForeground( d, gc, ts4 );
	XFillRectangle( d, wnd, gc, WD, LINE_H+5-(WD*4), ww-(WD*2), WD );
	XSetForeground( d, gc, ts5 );
	XFillRectangle( d, wnd, gc, WD, LINE_H+5-(WD*3), ww-(WD*2), WD );
	XSetForeground( d, gc, ts6 );
	XFillRectangle( d, wnd, gc, WD, LINE_H+5-(WD*2), ww-(WD*2), WD );

	XSetForeground( d, gc, tl2 );
	XFillRectangle( d, wnd, gc, WD, WD*2, ww-(WD*2), WD );
	XSetForeground( d, gc, tl3 );
	XFillRectangle( d, wnd, gc, WD, WD*3, ww-(WD*2), WD );
	XSetForeground( d, gc, tl4 );
	XFillRectangle( d, wnd, gc, WD, WD*4, ww-(WD*2), WD );
	XSetForeground( d, gc, tl5 );
	XFillRectangle( d, wnd, gc, WD, WD*5, ww-(WD*2), WD );
	XSetForeground( d, gc, tl6 );
	XFillRectangle( d, wnd, gc, WD, WD*6, ww-(WD*2), WD );
    }
#endif

    /* Drawing title */
    XSetForeground( d, gc, tinfo->hdfgc );
    iXmbDrawString( d, wnd, ifs, gc, 10, LINE_H-2,
		    mes_title, strlen(mes_title), DW,
		    tinfo->headerbold );

    return;
}


#ifdef HAVE_IMLIB_H
ImlibImage *GetDesktopImage( Display *d, int depth, XSizeHints *sh )
{
    ImlibImage *ret = NULL;
    Window wnd;
    XSetWindowAttributes wsa;
    unsigned long mask;
    XSizeHints wsh;

    wsa.background_pixmap = ParentRelative;
    wsa.backing_store = Always ;
    wsa.override_redirect = True;
    mask = CWBackPixmap | CWBackingStore | CWOverrideRedirect;

    wnd = XCreateWindow( d, DefaultRootWindow(d),
			 sh->x, sh->y, sh->width, sh->height,
			 0, depth, InputOutput, CopyFromParent,
			 mask, &wsa);
    if( wnd ){
	XMapRaised(d,wnd);
	XSync(d,0);
	XClearWindow(d,wnd);
	ret = Imlib_create_image_from_drawable(imlibdata, wnd, AllPlanes,
					       0, 0, sh->width, sh->height );
	XDestroyWindow(d,wnd);
    }
    return ret;
}

extern Pixmap get_desktop_pixmap(Display *d);
ImlibImage *GetDesktopImage_( Display *d, int depth, XSizeHints *sh  )
{
    ImlibImage *ret = NULL;
    Pixmap p;

    p =  get_desktop_pixmap( d );
    ret = Imlib_create_image_from_drawable(imlibdata, p, AllPlanes,
					   sh->x, sh->y,
					   sh->width, sh->height );
    if( ret == NULL ){
	ret = GetDesktopImage(d,depth,sh);
    }

    return ret;
}

#endif

void CreateBgPixmap(Display *d, Window w, Window rw, GC gc,
		    Colormap cmap, int depth, Pixmap bgpmap[], int bgnum,
		    int nsbj, TextInfo *tinfo, XSizeHints *sh,
		    BOOL scflag, BOOL tflag )
{
    int i;
#ifdef HAVE_IMLIB_H
    /* Imlib бƤߤޤ礫 */
    ImlibImage *imb = NULL, *im = NULL;
#endif

    FreeBgPixmap(d,bgpmap,bgnum);

idbgout(__func__,"enter +%d+%d",sh->x,sh->y);

    for( i=0 ; i<bgnum ; i++ ){

	if( bgpmap[i] == 0 )
	    bgpmap[i] = XCreatePixmap( d, w, sh->width, nsbj*MH+10, depth );

#ifdef HAVE_IMLIB_H
	if( tinfo->tinf[i].bgp == -1 ){
	    /*
	     * ȾƩ
	     */

	    XSizeHints tsh;

	    tsh.x = sh->x;
	    tsh.y = sh->y + (LINE_H+5);
	    tsh.height = sh->height - (LINE_H+5);
	    tsh.width = scflag ? sh->width - SCBAR_SIZE : sh->width;

	    if( tflag == FALSE ){
		continue;
	    }

	    if( imb == NULL ){
		imb = GetDesktopImage_( d, depth, &tsh );
	    }

	    im = Imlib_clone_image( imlibdata, imb );

	    if( im ){
		Pixmap p;
		ImlibColorModifier mod;

		Imlib_get_image_modifier(imlibdata,im,&mod);

		mod.brightness = (double)mod.brightness
		    * (((double)tinfo->tinf[i].bgp_brt)/100);
		mod.contrast = (double)mod.contrast
		    * (((double)tinfo->tinf[i].bgp_cont)/100);
		Imlib_set_image_modifier(imlibdata,im,&mod);

		if( tinfo->tinf[i].bgcname[0] != '\0' ){
		    /* طʿꤵƤϲοĴѲ */
		    int r, g, b;
		    ImlibColorModifier rm = {0xFF,0xFF,0xFF},
		                       gm = {0xFF,0xFF,0xFF},
			               bm = {0xFF,0xFF,0xFF};

		    tinfo->tinf[i].bgc = iNametoPixel(d,cmap,
						      tinfo->tinf[i].bgcname);
		    iPixeltoRGB(d,cmap,tinfo->tinf[i].bgc,&r,&g,&b);
		    rm.brightness = r/256;
		    gm.brightness = g/256;
		    bm.brightness = b/256;
		    Imlib_set_image_red_modifier(imlibdata,im,&rm);
		    Imlib_set_image_green_modifier(imlibdata,im,&gm);
		    Imlib_set_image_blue_modifier(imlibdata,im,&bm);
		}

		Imlib_render( imlibdata, im, im->rgb_width, im->rgb_height );
		p = Imlib_move_image( imlibdata, im );

		XCopyArea( d, p, bgpmap[i], gc, 0, 0,
			   im->width, im->height,
			   ((tsh.x<0)?((-1)*tsh.x):0),
			   ((tsh.y<0)?((-1)*tsh.y):0) );

		Imlib_free_pixmap( imlibdata, p );
		Imlib_kill_image( imlibdata, im );

	    } else {
		idbgout(__func__,"im=(NULL)");
	    }

	} else if( tinfo->tinf[i].bgp != 0 ){
	    /*
	     * 
	     */
	    DrawTilePixmap( d, bgpmap[i], gc, tinfo->tinf[i].bgp,
			    tinfo->tinf[i].bgp_w, tinfo->tinf[i].bgp_h, 0,
			    sh->width, nsbj*MH+10, 0 );
	}
	else
#endif
	{
	    /*
	     * 
	     */
	    XSetForeground( d, gc, tinfo->tinf[i].bgc );
	    XFillRectangle( d, bgpmap[i], gc, 0, 0, sh->width, nsbj*MH+10 );
	}
    }

#ifdef HAVE_IMLIB_H
    if( imb != NULL ){
	Imlib_kill_image( imlibdata, imb );
    }
#endif

    return;
}

void FreeBgPixmap( Display *d, Pixmap bgpmap[], int bgnum )
{
    int i;

    for( i=0 ; i<bgnum ; i++ ){
	if( bgpmap[i]!=0 ){
	    XFreePixmap( d, bgpmap[i] );
	    bgpmap[i] = 0;
	}
    }
}


Pixmap get_desktop_pixmap(Display *d)
{
    Pixmap p;
    Atom prop, type;
    int format;
    unsigned long length, after;
    unsigned char *data;
    Window dw = DefaultRootWindow(d);

    prop = XInternAtom( d, "_XROOTPMAP_ID", True );

    if (prop != None) {
	if( Success == XGetWindowProperty( d, dw, prop, 0, 1,
					   False, XA_PIXMAP,
					   &type, &format, &length,
					   &after, &data) ){
	    if( data && *data ){
		p = *((Pixmap*)data);
		XFree(data);
		return p;
	    }
	} else {
	    printf("xqbiff: XGetWindowProperty error.\n");
	}
    }
    printf("xqbiff: No suitable attribute found.\n");

    return 0;
}
