/*
  xqbiff  -- "biff" program for qmail.
  Copyright (C) 1998-2003 Yusuke Ishizawa <yu-i@wmail.plala.or.jp>

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2, or (at your option) any
  later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
/*
 * gui.c
 *
 * GUI 
 *
 */

#include"xqb.h"

/*
#define DEBUG
*/


/*
 * ɥȤƶĴ
 */
void SetFocus( Display *d, Window wnd, GC gc,
	      Colormap cmap, XSizeHints *sh, int focus )
{
    int r1, r2;
    static int cf = 0;

    if( cf < 3 ){ r1 = 3; r2 = 6; }
    else { r1 = 1; r2 = 3; }
    XSetForeground( d, gc, iNametoPixel( d, cmap, opinfo.bg ) );
    XDrawRectangle( d, wnd, gc, sh[cf].x-r1, sh[cf].y-r1,
		    sh[cf].width+r2, sh[cf].height+r2 );

    if( focus < 0 ) return;

    cf = focus;

    if( cf < 3 ){ r1 = 3; r2 = 6; }
    else { r1 = 1; r2 = 3; }
    XSetForeground( d, gc, iNametoPixel( d, cmap, "black" ) );
    XDrawRectangle( d, wnd, gc, sh[cf].x-r1, sh[cf].y-r1,
		    sh[cf].width+r2, sh[cf].height+r2 );

    XFlush( d );

    return;
}

/*
 * ƥȥܥåΥʽˤ
 */
void DrawCur( Display *d, Window wnd, GC gc, Colormap cmap, int x, BOOL flag )
{
    if( flag )
	XSetForeground( d, gc, iNametoPixel( d, cmap, "black" ) );
    else
	XSetForeground( d, gc, iNametoPixel( d, cmap, "White" ) );

    XDrawLine( d, wnd, gc, x+10, 0, x+10, LINE_H );

    XFlush( d );

    return;
}

/*
 * ɥΩΤˤ
 */
void WndUp( Display *d, Window wnd, GC gc,
	    XSizeHints sh, Pixel lpix, Pixel spix, int bw, BOOL flag )
{
    if( flag == FALSE ){
	Pixel t = lpix;
	lpix = spix;
	spix = t;
    }

    XSetForeground( d, gc, spix );
    XFillRectangle( d, wnd, gc, 0, sh.height+1-bw,
		    sh.width, sh.height );
    XFillRectangle( d, wnd, gc, sh.width+1-bw, 0,
		    sh.width, sh.height );

    XSetForeground( d, gc, lpix );
    XFillRectangle( d, wnd, gc, 0, 0, sh.width, bw );
    XFillRectangle( d, wnd, gc, 0, 0, bw, sh.height );

    XFlush( d );

    return;
}

/*
 * POP Υᥤ
 */
int PopPasswdInput( Display *d, Window bwnd, GC bgc, Colormap cmap,
		    iFontSet *ifs,
		    char *svbuf, char *acbuf, char *psbuf, char *mdbuf,
		    char *label, int dfc )
{
#define MAXSTR 256
#define SWIDTH(x) iXmbTextWidth(ifs,x,strlen(x))

int SPWIDTH(iFontSet *ifs, char *x, size_t y)
{
    char bf[1024];
    strcpy(bf,x);
    bf[y] = '\0';
    return iXmbTextWidth(ifs,bf,y);
}

/*
 * wnd[], sh[]
 * 0-2 Textbox
 * 3-5 APOP
 * 6-8 Button
 */
/*
 * mode
 * 0: APOP
 * 1: POP
 * 2: Auto
 */

    XEvent report;
    int  mode = 2;
    BOOL flag = FALSE;
    int i, ret = 1;
    int twidth = 0;
    Pixel lpix, spix;
    int focus;
    char buf[3][MAXSTR], pbuf[MAXSTR];
    int  blen[3];
    char lbuf[3][16];
    int curp, curx;

    Window wnd[9];
    XSizeHints bsh, sh[9];

    char dbuff[1024];


    strncpy( buf[0], svbuf, MAXSTR );
    strncpy( buf[1], acbuf, MAXSTR );
    strncpy( pbuf, psbuf, MAXSTR );
    blen[0] = strlen( buf[0] );
    blen[1] = strlen( buf[1] );
    blen[2] = strlen( pbuf );
    for( i=0 ; i<blen[2] ; i++ )
	buf[2][i] = '*';
    buf[2][blen[2]] = '\0';

#ifdef DEBUG
    fprintf( stderr, "PopPasswdInput( %s ).\n", label );
#endif

    if( 0 <= dfc && dfc < 7 ) focus = dfc;
    else if( buf[0][0] == '\0' ) focus = 0;
    else if( buf[1][0] == '\0' ) focus = 1;
    else if( buf[2][0] == '\0' ) focus = 2;
    else focus = 0;
 
    strcpy( lbuf[0], "Ok" );
    strcpy( lbuf[1], "Cancel" );
    strcpy( lbuf[2], "Quit" );

    curp = blen[focus];
    curx = SWIDTH(buf[focus]);


    if( 0 == strcasecmp( mdbuf, "APOP" ) ){
	mode = 0;
    } else if( 0 == strcasecmp( mdbuf, "POP" ) ){
	mode = 1;
    } else {
	mode = 2;
    }


#ifdef DEBUG
    fprintf( stderr, "PopPasswdInput( %s ).\n", label );
#endif


    twidth = iMax( iXmbTextWidth(ifs, "POP Server", 10),
		   iXmbTextWidth(ifs, "User account", 12) );

    twidth = iMax( twidth,
		   iXmbTextWidth(ifs, "Password", 8) );


    /*
     * Create Color Information.
     */

    spix = iGetColorPixelRate( d, cmap, iNametoPixel( d, cmap, opinfo.bg ), 75, FALSE );
    lpix = iGetColorPixelRate( d, cmap, iNametoPixel( d, cmap, opinfo.bg ), 50, TRUE );


    /*
     * Create windows.
     */
    bsh.flags  = (USPosition | PSize | PMaxSize );
    bsh.x      = (DW - LINE_H*20)/2;
    bsh.y      = (DH - LINE_H*10)/2;
    bsh.width  = LINE_H*14+twidth+60;
    bsh.height = (int)(LINE_H*12.5);

    sh[0].flags  = (PPosition | PSize | PMaxSize );
    sh[0].width  = LINE_H*14;
    sh[0].height = LINE_H;
    sh[0].x      = 30+twidth;
    sh[0].y      = LINE_H * 2;

    sh[1].flags  = (PPosition | PSize | PMaxSize );
    sh[1].width  = LINE_H*14;
    sh[1].height = LINE_H;
    sh[1].x      = 30+twidth;
    sh[1].y      = LINE_H * 3.5;

    sh[2].flags  = (PPosition | PSize | PMaxSize );
    sh[2].width  = LINE_H*14;
    sh[2].height = LINE_H;
    sh[2].x      = 30+twidth;
    sh[2].y      = LINE_H * 5;

    sh[3].flags  = (PPosition | PSize | PMaxSize );
    sh[3].width  = font_h/2;
    sh[3].height = font_h/2;
    sh[3].x      = (bsh.width - LINE_H*4) /2;
    sh[3].y      = LINE_H * 7.5 + font_h - sh[3].height;

    sh[4].flags  = (PPosition | PSize | PMaxSize );
    sh[4].width  = font_h/2;
    sh[4].height = font_h/2;
    sh[4].x      = (bsh.width - LINE_H*4) /2;
    sh[4].y         = LINE_H * 8.5 + font_h - sh[4].height;

    sh[5].flags  = (PPosition | PSize | PMaxSize );
    sh[5].width  = font_h/2;
    sh[5].height = font_h/2;
    sh[5].x      = (bsh.width - LINE_H*4) /2;
    sh[5].y      = LINE_H * 9.5 + font_h - sh[5].height;

    sh[6].flags  = (PPosition | PSize | PMaxSize );
    sh[6].x      = 50;
    sh[6].width  = LINE_H*4;
    sh[6].height = LINE_H;
    sh[6].y      = LINE_H * 11;

    sh[7].flags  = (PPosition | PSize | PMaxSize );
    sh[7].width  = LINE_H*4;
    sh[7].height = LINE_H;
    sh[7].y      = LINE_H * 11;
    sh[7].x      = (bsh.width - sh[7].width) /2;

    sh[8].flags  = (PPosition | PSize | PMaxSize );
    sh[8].width  = LINE_H*4;
    sh[8].height = LINE_H;
    sh[8].y      = LINE_H * 11;
    sh[8].x      = bsh.width-50-sh[8].width;


    SetWndName( d, bwnd, "POP " );


    for( i=0 ; i<3 ; i++ ){
	wnd[i] = XCreateSimpleWindow( d, bwnd, sh[i].x, sh[i].y,
			       sh[i].width, sh[i].height,
			       0, iNametoPixel( d, cmap, "Black" ),
			       iNametoPixel( d, cmap, "White" ) );

	XSelectInput( d, wnd[i], ButtonPressMask | ButtonReleaseMask |
		      StructureNotifyMask | SubstructureNotifyMask |
		      PointerMotionMask | ExposureMask |
		      KeyPressMask | EnterWindowMask | FocusChangeMask );
    }

    for( i=3 ; i<9 ; i++ ){
	wnd[i] = XCreateSimpleWindow( d, bwnd, sh[i].x, sh[i].y,
			       sh[i].width, sh[i].height,
			       1, iNametoPixel( d, cmap, "Black" ),
			       iNametoPixel( d, cmap, opinfo.bg ) );

	XSelectInput( d, wnd[i], ButtonPressMask | ButtonReleaseMask |
		      StructureNotifyMask | SubstructureNotifyMask |
		      PointerMotionMask | ExposureMask |
		      KeyPressMask | EnterWindowMask | FocusChangeMask );
    }


    {
	XSizeHints tsh;
	tsh = bsh;

	GetWndSizePos( d, bwnd, &tsh, &tsh );
	MapWnd( d, bwnd, &tsh );

	bsh.flags     |= (PMinSize | PMaxSize);
	bsh.min_width  = bsh.width;
	bsh.min_height = bsh.height;
	bsh.max_width  = bsh.width;
	bsh.max_height = bsh.height;

	XSetWMSizeHints( d, bwnd, &bsh, XA_WM_SIZE_HINTS );
	XSetWMNormalHints( d, bwnd, &bsh );

	XMapSubwindows( d, bwnd );

	XFlush( d );
    }

    XClearArea( d, bwnd, 0, 0, bsh.width, bsh.height, True );



    /*
     * Event loop.
     */

    while( flag == FALSE ){
	XNextEvent( d, &report );
	
	switch( report.type ){
	case Expose:
	    if( report.xexpose.window == bwnd ){
		XSetForeground( d, bgc, iNametoPixel( d, cmap, opinfo.bg) );
		XFillRectangle( d, bwnd, bgc,
				bsh.x, bsh.y, bsh.width-1, bsh.height-1 );

		WndUp( d, bwnd, bgc, bsh, lpix, spix, WD, TRUE );

		XSetForeground( d, bgc, iNametoPixel( d, cmap, opinfo.fg) );

		changecodetojis( label, dbuff, 1024, CODE_EUC );
		iXmbDrawString( d, bwnd, ifs, bgc,
				(bsh.width-SWIDTH(label))/2,
				LINE_H, dbuff, strlen(dbuff), DW, FALSE );
#ifdef DEBUG
		fprintf( stderr, "Label: %s %d %d %d %d\n",
			 label, bsh.x, bsh.y, bsh.width, bsh.height );
#endif
		iXmbDrawString( d, bwnd, ifs, bgc,
				20, sh[0].y+font_h,
				"POP server",
				10, DW, FALSE );
		iXmbDrawString( d, bwnd, ifs, bgc,
				20, sh[1].y+font_h,
				"User account",
				12, DW, FALSE );
		iXmbDrawString( d, bwnd, ifs, bgc,
				20, sh[2].y+font_h,
				"Password",
				8, DW, FALSE );
		changecodetojis( "ǧˡ", dbuff, 1024, CODE_EUC );
		iXmbDrawString( d, bwnd, ifs, bgc,
				sh[3].x, sh[3].y+ifs->ascii->ascent-LINE_H,
				dbuff,
				strlen(dbuff), DW, FALSE );
		iXmbDrawString( d, bwnd, ifs, bgc,
				sh[3].x+sh[3].width+10,
				sh[3].y+ifs->ascii->ascent,
				"APOP",
				4, DW, FALSE );
		iXmbDrawString( d, bwnd, ifs, bgc,
				sh[4].x+sh[4].width+10,
				sh[4].y+ifs->ascii->ascent,
				"POP",
				3, DW, FALSE );
		changecodetojis( "ưȽ", dbuff, 1024, CODE_EUC );
		iXmbDrawString( d, bwnd, ifs, bgc,
				sh[5].x+sh[5].width+10,
				sh[5].y+ifs->ascii->ascent,
				dbuff,
				strlen(dbuff), DW, FALSE );

		for( i=0 ; i<3 ; i++ ){
		    XSetForeground( d, bgc, lpix );
		    XFillRectangle( d, bwnd, bgc,
				    sh[i].x-WD, sh[i].y-WD,
				    sh[i].width+2*WD, sh[i].height+2*WD );

		    XSetForeground( d, bgc, spix );
		    XFillRectangle( d, bwnd, bgc,
				    sh[i].x-WD, sh[i].y-WD,
				    sh[i].width+WD, sh[i].height+WD );
		}
		SetFocus( d, bwnd, bgc, cmap, sh, focus );

		XFlush( d );
	    }
	    /*
	     * Input area.
	     */
	    else {
		for( i=0 ; i<9 ; i++ ){
		    if( report.xexpose.window == wnd[i] ){
			if( i<3 ){
			    /*
			     * Draw Text box.
			     */
			    XSetForeground( d, bgc,
					    iNametoPixel(d,cmap,"White") );
			    XFillRectangle( d, wnd[i], bgc, 0, 0,
					    sh[i].width, sh[i].height );

			    XSetForeground( d, bgc,
					    iNametoPixel(d,cmap,"Black") );
			    iXmbDrawString( d, wnd[i], ifs, bgc,
					    10, font_h, buf[i], blen[i],
					    DW, FALSE );
			    if( focus == i )
				DrawCur( d, wnd[i], bgc, cmap, curx, TRUE );

			} else if( i>5 ){
			    /*
			     * Buttons.
			     */
			    WndUp( d, wnd[i], bgc, sh[i], lpix, spix,
				   WD, TRUE );

			    XSetForeground( d, bgc,
					    iNametoPixel(d,cmap,opinfo.bg) );
			    XFillRectangle( d, wnd[i], bgc, WD, WD,
					    sh[i].width-2*WD,
					    sh[i].height-2*WD );

			    XSetForeground( d, bgc,
					    iNametoPixel(d,cmap,"Black") );
			    iXmbDrawString( d, wnd[i], ifs, bgc,
					    (sh[i].width-iXmbTextWidth(
						ifs, lbuf[i-6],
						strlen(lbuf[i-6])))/2,
					     font_h, lbuf[i-6],
					     strlen(lbuf[i-6]), DW, FALSE );
			} else if( 3<=i && i<=5 ) {

			    /*
			     * MODE
			     */
			    WndUp( d, wnd[i], bgc, sh[i], spix, lpix,
				       WD, (mode==(i-3)) );
			}
		    }
		}
	    }
	    break;

	case MapNotify:
	    
#ifdef DEBUG
	    fprintf( stderr, "MapNotify.\n" );
#endif
	    break;

	case KeyPress:
	{
	    char temp[4];
	    KeySym key;
	    int klen;

	    if( (klen = XLookupString( &(report.xkey), temp, 1, &key, NULL ))
		>= 0 ){
		if( focus < 3 ){
		    /*
		     * At Text box
		     */
		    switch(key){

		    case XK_Return:
			DrawCur( d, wnd[focus], bgc, cmap, curx, FALSE );
			WndUp( d, wnd[6], bgc, sh[6],
			       spix, lpix, WD, FALSE );
			strncpy( svbuf, buf[0], MAXSTR );
			strncpy( acbuf, buf[1], MAXSTR );
			strncpy( psbuf, pbuf, MAXSTR );
			if( mode==0 )
			    strncpy( mdbuf, "APOP", MAXSTR );
			else if( mode==1 )
			    strncpy( mdbuf, "POP", MAXSTR );
			else if( mode==2 )
			    strncpy( mdbuf, "", MAXSTR );

			flag = TRUE;

			break;


		    case XK_Up:
			if( 0 < focus ){
			    DrawCur( d, wnd[focus], bgc, cmap, curx, FALSE );
			    focus--;
			    curp = blen[focus];
			    curx = SWIDTH(buf[focus]);
			    DrawCur( d, wnd[focus], bgc, cmap, curx, TRUE );
			}
			SetFocus( d, bwnd, bgc, cmap, sh, focus );

#ifdef DEBUG
			fprintf( stderr, "Focus=%d\n", focus );
#endif

			break;


		    case XK_Down:
		    case XK_Tab:
			DrawCur( d, wnd[focus], bgc, cmap, curx, FALSE );
			focus++;
			if( focus < 3 ){
			    curp = blen[focus];
			    curx = SWIDTH(buf[focus]);
			    DrawCur( d, wnd[focus], bgc, cmap,
				     curx, TRUE );
			}
			SetFocus( d, bwnd, bgc, cmap, sh, focus );

#ifdef DEBUG
			fprintf( stderr, "Focus=%d\n", focus );
#endif
			break;


		    case XK_Escape:
			WndUp( d, wnd[7], bgc, sh[7], spix, lpix, WD, FALSE );
			flag = TRUE;
			break;


		    case XK_BackSpace:
		    case XK_Delete:
#ifdef DEBUG
			fprintf( stderr, "focus=%d BS len=%d\n",
				 focus, blen[focus] );
#endif
			if( curp > 0 ){
			    blen[focus]--;
			    curp--;
			    iStrcDelete(buf[focus],curp);
			} else {
			    XBell( d, 0 );
			}
/*
  buf[focus][blen[focus]] = '\0';
*/


			if( focus == 2 )
			    pbuf[blen[2]] = '\0';

			XSetForeground( d, bgc,
					iNametoPixel(d,cmap,"White") );
			XFillRectangle( d, wnd[focus], bgc, 0, 0,
					sh[focus].width,
					sh[focus].height );

			XSetForeground( d, bgc,
					iNametoPixel(d,cmap,"Black") );
			iXmbDrawString( d, wnd[focus],
					ifs, bgc,
					10, font_h, buf[focus],
					blen[focus], DW, FALSE );
			curx = SPWIDTH(ifs,buf[focus],curp);

			DrawCur( d, wnd[focus], bgc, cmap, curx, TRUE );

			break;


		    case XK_Right:
#ifdef DEBUG
			fprintf( stderr, "XK_Right.\n" );
#endif
			curp++;
			if( curp > blen[focus] ) curp = blen[focus];

			XSetForeground( d, bgc,
					iNametoPixel(d,cmap,"White") );
			XFillRectangle( d, wnd[focus], bgc, 0, 0,
					sh[focus].width,
					sh[focus].height );

			XSetForeground( d, bgc,
					iNametoPixel(d,cmap,"Black") );
			iXmbDrawString( d, wnd[focus],
					ifs, bgc,
					10, font_h, buf[focus],
					blen[focus], DW, FALSE );

			curx = SPWIDTH(ifs,buf[focus],curp);

			DrawCur( d, wnd[focus], bgc, cmap, curx, TRUE );
			break;


		    case XK_Left:
#ifdef DEBUG
			fprintf( stderr, "XK_Left.\n" );
#endif
			curp--;
			if( curp < 0 ) curp = 0;

			XSetForeground( d, bgc,
					iNametoPixel(d,cmap,"White") );
			XFillRectangle( d, wnd[focus], bgc, 0, 0,
					sh[focus].width,
					sh[focus].height );

			XSetForeground( d, bgc,
					iNametoPixel(d,cmap,"Black") );
			iXmbDrawString( d, wnd[focus],
					ifs, bgc,
					10, font_h, buf[focus],
					blen[focus], DW, FALSE );

			curx = SPWIDTH(ifs,buf[focus],curp);

			DrawCur( d, wnd[focus], bgc, cmap, curx, TRUE );
			break;



		    default:
			if( klen > 0 ){
#ifdef DEBUG
			    fprintf( stderr, "Key: %c\n", temp[0] );
#endif
			    if( blen[focus] < MAXSTR ){
				if( focus == 2 ){
				    buf[focus][blen[focus]] = '*';
				    buf[focus][blen[focus]+1] = '\0';
				    iStrcInsert(pbuf,temp[0],curp);
				} else {
				    iStrcInsert(buf[focus],temp[0],curp);
				}
				blen[focus]++;
				curp++;
			    }

			    XSetForeground( d, bgc,
					    iNametoPixel(d,cmap,"White") );
			    XFillRectangle( d, wnd[focus], bgc, 0, 0,
					    sh[focus].width, sh[focus].height );

			    XSetForeground( d, bgc,
					    iNametoPixel(d,cmap,"Black") );
			    iXmbDrawString( d, wnd[focus], ifs, bgc,
					    10, font_h, buf[focus],
					    blen[focus], DW, FALSE );
			    curx = SPWIDTH(ifs,buf[focus],curp);
			    DrawCur( d, wnd[focus], bgc, cmap, curx, TRUE );
			}
			break;
		    }

		} else {

		    /*
		     * At any button
		     */

		    switch(key){
		    case XK_space:
			switch(focus){
			case 3:
			case 4:
			case 5:
			    mode = focus-3;
			    for( i=3 ; i<6 ; i++ )
				WndUp( d, wnd[i], bgc, sh[i],
				       spix, lpix, WD, (i==(mode+3)) );
			    break;
			}
			break;

		    case XK_Return:
			switch(focus){
			case 3:
			case 4:
			case 5:
			    mode = focus-3;
			    for( i=3 ; i<6 ; i++ )
				WndUp( d, wnd[i], bgc, sh[i],
				       spix, lpix, WD, (i==(mode+3)) );

			case 6:
			    WndUp( d, wnd[6], bgc, sh[6],
				   spix, lpix, WD, FALSE );
			    strncpy( svbuf, buf[0], MAXSTR );
			    strncpy( acbuf, buf[1], MAXSTR );
			    strncpy( psbuf, pbuf, MAXSTR );
			    if( mode==0 )
				strncpy( mdbuf, "APOP", MAXSTR );
			    else if( mode==1 )
				strncpy( mdbuf, "POP", MAXSTR );
			    else if( mode==2 )
				strncpy( mdbuf, "", MAXSTR );

			    flag = TRUE;
			    break;

			case 7:
			    WndUp( d, wnd[7], bgc, sh[7],
				   spix, lpix, WD, FALSE );
			    flag = TRUE;
			    break;

			case 8:
			    WndUp( d, wnd[8], bgc, sh[8],
				   spix, lpix, WD, FALSE );
			    flag = TRUE;
			    ret = 0;
			    break;
			}
			SetFocus( d, bwnd, bgc, cmap, sh, focus );
			break;

		    case XK_Tab:
			focus++;
			if( focus > 8 ){
			    focus = 0;
			    curp = blen[0];
			    curx = SPWIDTH(ifs, buf[0], curp );
			    DrawCur( d, wnd[focus], bgc, cmap,
				     curx, TRUE );
			}
#ifdef DEBUG
			fprintf( stderr, "Focus=%d\n", focus );
#endif

			SetFocus( d, bwnd, bgc, cmap, sh, focus );
			break;

		    case XK_Left:
			if( focus == 7 || focus == 8 ) focus--;
			SetFocus( d, bwnd, bgc, cmap, sh, focus );
			break;

		    case XK_Right:
			if( focus == 6 || focus == 7 ) focus++;
			SetFocus( d, bwnd, bgc, cmap, sh, focus );
			break;

		    case XK_Up:
			if( focus > 5 ) focus = 5;
			else if( 0 < focus ) focus--;
			SetFocus( d, bwnd, bgc, cmap, sh, focus );
			break;

		    case XK_Down:
			if( focus < 6 ) focus++;
			SetFocus( d, bwnd, bgc, cmap, sh, focus );
			break;

		    case XK_Escape:
			WndUp( d, wnd[7], bgc, sh[7], spix, lpix, WD, FALSE );
			flag = TRUE;
			break;
		    }
		}
	    }
	}
	break;

	case ButtonPress:
	    if( report.xbutton.button != Button1 ) break;

	    if( focus < 3 )
		DrawCur( d, wnd[focus], bgc, cmap, curx, FALSE );

	    if( report.xbutton.window == wnd[0] ){
		focus = 0;

	    } else if( report.xbutton.window == wnd[1] ){
		focus = 1;
		
	    } else if( report.xbutton.window == wnd[2] ){
		focus = 2;

	    } else if( report.xbutton.window == wnd[3] ||
		       ( report.xbutton.window == bwnd &&
			 sh[3].x < report.xbutton.x &&
			 sh[3].y-font_h/4 < report.xbutton.y &&
			 report.xbutton.x < sh[3].x + LINE_H*4 &&
			 report.xbutton.y < sh[3].y + LINE_H - font_h/4 ) 
		){
		focus = 3;
		mode=0;
		for( i=3 ; i<6 ; i++ )
		    WndUp( d, wnd[i], bgc, sh[i],
			   spix, lpix, WD, (i==(mode+3)) );

	    } else if( report.xbutton.window == wnd[4] ||
		       ( report.xbutton.window == bwnd &&
			 sh[4].x < report.xbutton.x &&
			 sh[4].y-font_h/4 < report.xbutton.y &&
			 report.xbutton.x < sh[4].x + LINE_H*4 &&
			 report.xbutton.y < sh[4].y + LINE_H - font_h/4 ) 
		){
		focus = 4;
		mode=1;
		for( i=3 ; i<6 ; i++ )
		    WndUp( d, wnd[i], bgc, sh[i],
			   spix, lpix, WD, (i==(mode+3)) );

	    } else if( report.xbutton.window == wnd[5] ||
		       ( report.xbutton.window == bwnd &&
			 sh[5].x < report.xbutton.x &&
			 sh[5].y-font_h/4 < report.xbutton.y &&
			 report.xbutton.x < sh[5].x + LINE_H*4 &&
			 report.xbutton.y < sh[5].y + LINE_H - font_h/4 ) 
		){
		focus = 5;
		mode=2;
		for( i=3 ; i<6 ; i++ )
		    WndUp( d, wnd[i], bgc, sh[i],
			   spix, lpix, WD, (i==(mode+3)) );

	    } else if( report.xbutton.window == wnd[6] ){
		WndUp( d, wnd[6], bgc, sh[6], spix, lpix, WD, FALSE );
		focus = 6;
		strncpy( svbuf, buf[0], MAXSTR );
		strncpy( acbuf, buf[1], MAXSTR );
		strncpy( psbuf, pbuf, MAXSTR );
		if( mode==0 )
		    strncpy( mdbuf, "APOP", MAXSTR );
		else if( mode==1 )
		    strncpy( mdbuf, "POP", MAXSTR );
		else if( mode==2 )
		    strncpy( mdbuf, "", MAXSTR );

		flag = TRUE;

	    } else if( report.xbutton.window == wnd[7] ){
		focus = 7;
		WndUp( d, wnd[7], bgc, sh[7], spix, lpix, WD, FALSE );
		flag = TRUE;

	    } else if( report.xbutton.window == wnd[8] ){
		focus = 8;
		WndUp( d, wnd[8], bgc, sh[8], spix, lpix, WD, FALSE );
		flag = TRUE;
		ret = 0;
	    }

	    SetFocus( d, bwnd, bgc, cmap, sh, focus );

	    if( focus < 3 ){
		curp = blen[focus];
		curx = SPWIDTH(ifs, buf[focus], curp );
		DrawCur( d, wnd[focus], bgc, cmap, curx, TRUE );
	    }
	    break;

	case ClientMessage:
	    WndUp( d, wnd[8], bgc, sh[8], spix, lpix, WD, FALSE );
	    flag = TRUE;
	    ret = 0;
	    break;

	}
    }

    XFlush(d);


    XUnmapWindow( d, bwnd );
    XFlush( d );

    for( i=0 ; i<7 ; i++ )
	XDestroyWindow( d, wnd[i] );


#ifdef DEBUG
    fprintf( stderr, "PopPasswdInput()...Ok.\n" );
    fprintf( stderr, "Mode: %s.\n", mdbuf );
    fprintf( stderr, "Server: %s.\n", svbuf );
    fprintf( stderr, "Account: %s.\n", acbuf );
    fprintf( stderr, "Password: %s.\n", psbuf );
#endif

    return ret;
}
