/*-
# X-BASED PANEX(tm)
#
#  PanexP.h
#
###
#
#  Copyright (c) 1996 - 2005	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for Panex */

#ifndef _PanexP_h
#define _PanexP_h

#include "xwin.h"
#include "timer.h"
#include "Panex.h"

#ifdef WINVER
extern void DestroyPanex(HBRUSH brush);
extern void ResizePanex(PanexWidget w);
extern void SizePanex(PanexWidget w);
extern void InitializePanex(PanexWidget w, HBRUSH brush);
extern void ExposePanex(PanexWidget w);
extern void HidePanex(PanexWidget w);
extern void SelectPanex(PanexWidget w, const int x);
extern void MotionPanex(PanexWidget w, const int x);
extern void ReleasePanex(PanexWidget w, const int x);
extern void ClearPanex(PanexWidget w);
extern void GetPanex(PanexWidget w);
extern void WritePanex(PanexWidget w);
extern void UndoPanex(PanexWidget w);
extern void SolvePanex(PanexWidget w);
extern void ModePanex(PanexWidget w);
extern void SpeedPanex(PanexWidget w);
extern void SlowPanex(PanexWidget w);
extern void SoundPanex(PanexWidget w);
extern void DecrementPanex(PanexWidget w);
extern void IncrementPanex(PanexWidget w);
extern void EnterPanex(PanexWidget w);
extern void LeavePanex(PanexWidget w);

#else

/* This gets around C's inability to do inheritance */
typedef struct _PanexClassPart {
	int         ignore;
} PanexClassPart;

typedef struct _PanexClassRec {
	CoreClassPart coreClass;
	PanexClassPart panexClass;
} PanexClassRec;

extern PanexClassRec panexClassRec;
#endif

#ifndef MOVESOUND
#define MOVESOUND "move"
#endif

#define SYMBOL ':'

#define MAXSTACKS 3
#define UP 1
#define DOWN 0

#define TOP 0
#define RIGHT 1
#define BOTTOM 2
#define LEFT 3
#define COORD 4     
        
#define MAXSLICES 10
        
#define NORMAL 1    
#define DOUBLE 2
#define INSTANT 3   

typedef struct _PanexLoc {
	int         stack, loc;
} PanexLoc;

typedef struct _PanexPart {
	PanexLoc   *tileOfPosition[MAXSTACKS];
	PanexLoc   *positionOfTile[MAXSTACKS];
	int         currentStack, currentPosition, previousStack;
	Boolean     started, cheat, sound;
	Boolean     mono, reverse, focus;
	Boolean     scoreOnly, versionOnly;
	int         mode, tiles;
	int         delay, numSlices;
	Position    width, height;
	Point       tileSize, pos;
	Point       delta, puzzleOffset, letterOffset;
	GC          pyramidGC[MAXSTACKS - 1];
	GC          frameGC, stackGC, borderGC, inverseGC;
	GC          tileGC, tileBrighterGC, tileDarkerGC;
	Pixmap      bufferTiles[2];
	TimeVal     oldTime;
#ifdef WINVER
	char        userName[81], scoreFile[81], moveSound[81];
	char        pyramidChar[MAXSTACKS - 1];
#else
	int         menu;
	char       *userName, *scoreFile, *moveSound, *font;
	Colormap    colormap;
	XFontStruct *fontInfo;
	Pixel       foreground, background;
	Pixel       frameColor, tileColor, borderColor;
	Pixel       pyramidColor[MAXSTACKS - 1];
	String      pyramidName[MAXSTACKS - 1];
	XtCallbackList select;
#endif
} PanexPart;

typedef struct _PanexRec {
	CorePart    core;
	PanexPart   panex;
} PanexRec;

extern PanexLoc *startLoc[MAXSTACKS - 1];
extern void SetPanex(PanexWidget w, int reason);
extern int  MovePanex(PanexWidget w, int fromStack, int fromPosition,
	int toStack);

extern void SolveTilesFromStart(PanexWidget w);
extern void DrawAllTiles(PanexWidget w);
extern int  TopOfStack(PanexWidget w, int stack, int start);
extern Boolean CheckMiddle(PanexWidget w);
extern Boolean CheckSolved(PanexWidget w);
extern void InitMoves(void);
extern void PutMove(int from, int to);
extern void GetMove(int *from, int *to);
extern int  MadeMoves(void);
extern void FlushMoves(PanexWidget w);
extern int  NumMoves(void);
extern void ScanMoves(FILE * fp, PanexWidget w, int moves);
extern void PrintMoves(FILE * fp);
extern void ScanStartPosition(FILE * fp, PanexWidget w);
extern void PrintStartPosition(FILE * fp, PanexWidget w);
extern void SetStartPosition(PanexWidget w);

#endif /* _PanexP_h */
