.\" X-BASED MISSING LINK(tm)
.\"
.\" xmlink.man
.\"
.\" ##
.\"
.\" Copyright (c) 1994 - 2005	David Albert Bagley
.\"
.\"                   All Rights Reserved
.\"
.\" Permission to use, copy, modify, and distribute this software and
.\" its documentation for any purpose and without fee is hereby granted,
.\" provided that the above copyright notice appear in all copies and
.\" that both that copyright notice and this permission notice appear in
.\" supporting documentation, and that the name of the author not be
.\" used in advertising or publicity pertaining to distribution of the
.\" software without specific, written prior permission.
.\"
.\" This program is distributed in the hope that it will be "playable",
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
.\"
.TH MISSING_LINK 6 "05 Oct 2005" "V7.1.5"
.SH NAME
xmlink \- Missing Link X widget
.SH SYNOPSIS
.B /usr/games/xmlink
[-geometry [{width}][x{height}][{+-}{xoff}[{+-}{yoff}]]]
[-display [{host}]:[{vs}]] [-[no]mono] [-[no]{reverse|rv}]
[-{foreground|fg} {color}] [-{background|bg} {color}]
[-{border|bd} {color}] [-tile {color}]
[-face{0|1|2|3|4|5|6|7} {color}]
[-tiles {int}] [-faces {int}] [-[no]orient] [-[no]middle]
[-[no]install] [-picture {filename}] [-delay msecs]
[-[no]sound] [-bumpSound {filename}] [-moveSound {filename}]
[-base {int}] [-{font|fn} {fontname}] [-userName {string}]
[-scoreFile {filename}] [-scores] [-version]
.SH DESCRIPTION
.LP
Ideal's The Missing Link, a 4x4 puzzle, riding on the wave of Rubik's
Cube craze.  There are many variations on this theme, including the "6x6"
puzzle and Babylon Tower.  What makes the Missing Link a harder puzzle to
solve is that the 2 center positions rotate together.
.SH FEATURES
Press "\fBmouse-left\fP" button to move a tile.  Release
"\fBmouse-left\fP" button in the same row would move the tile towards the
space (unless there is no space in that row).  Release on a different row
will move the tiles up or down.
.LP
Click "\fBmouse-right\fP", or press "\fBR\fP" or "\fBr\fP" keys to
randomize the puzzle.
.LP
Press "\fBO\fP" or "\fBo\fP" keys to toggle the orient mode.  Slightly
more challenging on (default is off).
.LP
Press "\fBM\fP" or "\fBm\fP" keys to toggle the middle mode.  All the
middle tiles rotate together.  This is considerably more challenging on
(default is on).
.LP
"\fBS\fP" or "\fBs\fP" keys to start the auto-solver.  Only works on
mxn where m = 4 and n = 4.
.LP
Press "\fBU\fP" or "\fBu\fP" keys to undo a move.
.LP
Press "\fBG\fP" or "\fBg\fP" keys to get a saved puzzle.
.LP
Press "\fBW\fP" or "\fBw\fP" keys to write or save a puzzle.
.LP
Press "\fBC\fP" or "\fBc\fP" keys to clear a puzzle.
.LP
Press "\fB>\fP" or "\fB.\fP" keys to speed up the movement of tiles.
.LP
Press "\fB<\fP" or "\fB,\fP" keys to slow down the movement of tiles.
.LP
Press "\fB@\fP" key to toggle the sound.
.LP
Press "\fBEsc\fP" key to hide program.
.LP
Press "\fBQ\fP", "\fBq\fP", or "\fBCTRL-C\fP" keys to kill program.
.LP
Use the key pad, "R" keys, or arrow keys to move without the mouse.
.br
Key pad is defined for Missing Link as:
.br
  8     Up
.br
  ^
.br
4< >6   Left, Right
.br
  v
.br
  2     Down
.LP
Use the shift key and the up or down arrow keys to rotate all the tiles.
.LP
Use the control key and the keypad or arrow keys to reduce or enlarge the
complexity of the puzzle.
.LP
The title is in the following format (non-motif version):
.RS
xmlink: <row>x<column> {norm|ind<control of movement of middle tiles>} @
(<Number of moves>/{<Record number of moves>
<user name>|"NEVER noaccess"|"practice"}) - <Comment>
.RE
Movement of middle tiles are either move together or independent.
.br
If there is no record of the current puzzle, it displays "NEVER noaccess".
.SH OPTIONS
.TP 8
.B \-geometry {+|\-}\fIX\fP{+|\-}\fIY\fP
This option sets the initial position of the missing link window (resource
name "\fIgeometry\fP").
.TP 8
.B \-display \fIhost\fP:\fIdpy\fP
This option specifies the X server to contact.
.TP 8
.B \-[no]mono
This option allows you to  display on a color screen as if monochrome
(resource name "\fImono\fP").
.TP 8
.B \-[no]{reverse|rv}
This option allows you to see the missing link window in reverse video
(resource name "\fIreverse\fP").
.TP 8
.B \-{foreground|fg} \fIcolor\fP
This option specifies the foreground of the missing link window (resource name
"\fIforeground\fP").
.TP 8
.B \-{background|bg} \fIcolor\fP
This option specifies the background of the missing link window (resource name
"\fIbackground\fP").
.TP 8
.B \-{border|bd} \fIcolor\fP
This option specifies the border color of the tiles in the missing link window
(resource name "\fborderColor\fP").
.TP 8
.B \-tile \fIcolor\fP
This option specifies the tile color of the tiles in the missing link window
(resource name "\fItileColor\fP").
.TP 8
.B \-face{0|1|2|3|4|5|6|7} <\fIcolor\fP>
This option allows you to change the color of a face (resource name
"\fIfaceColorN\fP"). In mono-mode, color is represented as the first letter
of the color name.  The 0th face is the last face face on missing link
because I wanted that one to remain white by default when there are more or
less faces.
.TP 8
.B \-tiles <\fIint\fP>
This option allows you to change the number of links in a row
(resource name "\fItiles\fP").
.TP 8
.B \-faces <\fIint\fP>
This option allows you to change the number of faces in column
(resource name "\fIfaces\fP").
.TP 8
.B \-[no]orient
This option allows you to access the orient mode (resource name
"\fIorient\fP").
.TP 8
.B \-[no]middle
This option allows you to access the middle mode (resource name
"\fImiddle\fP").
.TP 8
.B \-[no]install
This option specifies if the colormap should be installed or not
(resource name "\fIinstall\fP").
.TP 8
.B \-picture \fIfilename\fP
This option specifies the file for the picture (resource name
"\fIpicture\fP").
.TP 8
.B \-delay \fImsecs\fP
This option specifies the number of milliseconds it takes to move a tile or
a group of tiles one space (1-50) (resource name "\fIdelay\fP").
.TP 8
.B \-[no]sound
This option specifies if a sliding tile should make a sound or not
(resource name "\fIsound\fP").
.TP 8
.B \-bumpSound \fIfilename\fP
This option specifies the file for the bump sound (resource name
"\fIbumpSound\fP").
.TP 8
.B \-moveSound \fIfilename\fP
This option specifies the file for the move sound (resource name
"\fImoveSound\fP").
.TP 8
.B \-base \fIint\fP
This option specifies the base used (default is base 10) (resource name
"\fIbase\fP").
.TP 8
.B \-{font|fn} \ffontname\fP
This option specifies the font that will be used (resource name
"\fIfont\fP").
.TP 8
.B \-userName \fIstring\fP
This option specifies the user name for any records made or else it will
get your login name (resource name "\fIuserName\fP").
.TP 8
.B \-scoreFile \fIfilename\fP
Specify an alternative score file (resource name "\fIscoreFile\fP").
.TP 8
.B \-scores
This option lists all the recorded scores and then exits.
.TP 8
.B \-version
This option tells you what version of xmlink you have.
.SH RECORDS
You must randomize the puzzle before a record is set, otherwise an
assumption of cheating is made if it is solved after a get.
.SH SAVE FORMAT
The format is not standard.  The reason for this is that this is simple and
I do not know what the standard is.
.sp
.RS
tiles: 1-8 <number of tiles in a row>
.br
faces: 1-8 <number of tiles in a column>
.br
middle: 0-1 <0 false, 1 true; if 1 then middle moves as one unit>
.br
orient: 0-1 <0 false, 1 true; if 1 then chain linked in order>
.br
moves: 0-MAXINT <total number of moves>
.sp
startingPosition: <array of tile positions where 0 is the empty space>
.RE
.sp
This is then followed by the moves, starting from 1.
.RS
move #: <direction> <tile> <shift>
.RE
Direction is represented as 0 up, 1 right, 2 down, and 3 left.
.br
Tile is the column of tile.
.br
Shift is represented as 0 or 1, 1 if the whole puzzle is moved at
once (here Tile does not matter), 0 if not.  The xmlink record keeper
does not count a control move as a move, but here we do.
.SH REFERENCES
L. E. Horden, Sliding Piece Puzzles (Recreations in Mathematics Series),
Oxford University Press 1986, Plate X.
.sp
you are about to find the solution: The Missing Link,
Ideal Toy Corporation, 1981.
.sp
James G Nourse, The Simple Solutions to Cubic Puzzles, Bantam Books,
New York, November 1981, pp 16-23.
.SH SEE ALSO
.LP
X(1), xrubik(6), xskewb(6), xdino(6), xpyraminx(6), xoct(6), xmball(6),
xpanex(6), xcubes(6), xtriangles(6), xhexagons(6), xabacus(6)
.SH COPYRIGHTS
.LP
\*R Copyright 1994-2005, David Albert Bagley
.SH BUG REPORTS AND PROGRAM UPDATES
.LP
Send bugs (or their reports, or fixes) to the author:
.RS
David Albert Bagley, <\fIbagleyd@tux.org\fP>
.RE
.sp
The latest version is currently at:
.RS
\fIftp://ftp.tux.org/pub/tux/bagleyd/xpuzzles\fP
.br
\fIftp://ibiblio.org/pub/Linux/games/strategy\fP
