/*-
# X-BASED MISSING LINK(tm)
#
#  MlinkP.h
#
###
#
#  Copyright (c) 1994 - 2005	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for Mlink */

#ifndef _MlinkP_h
#define _MlinkP_h

#include "xwin.h"
#include "timer.h"
#include "Mlink.h"

#ifdef WINVER
extern void DestroyMlink(HBRUSH brush);
extern void ResizeMlink(MlinkWidget w);
extern void SizeMlink(MlinkWidget w);
extern void InitializeMlink(MlinkWidget w, HBRUSH brush);
extern void ExposeMlink(MlinkWidget w);
extern void HideMlink(MlinkWidget w);
extern void SelectMlink(MlinkWidget w,
	const int x, const int y, const int shift);
extern void MotionMlink(MlinkWidget w,
	const int x, const int y, const int shift);
extern void ReleaseMlink(MlinkWidget w,
	const int x, const int y, const int shift);
extern void PracticeMlink(MlinkWidget w);
extern void PracticeMlinkMaybe(MlinkWidget w);
extern void PracticeMlink2(MlinkWidget w);
extern void RandomizeMlink(MlinkWidget w);
extern void RandomizeMlinkMaybe(MlinkWidget w);
extern void RandomizeMlink2(MlinkWidget w);
extern void ClearMlink(MlinkWidget w);
extern void GetMlink(MlinkWidget w);
extern void WriteMlink(MlinkWidget w);
extern void UndoMlink(MlinkWidget w);
extern void SolveMlink(MlinkWidget w);
extern void OrientizeMlink(MlinkWidget w);
extern void MiddleMlink(MlinkWidget w);
extern void SpeedMlink(MlinkWidget w);
extern void SlowMlink(MlinkWidget w);
extern void SoundMlink(MlinkWidget w);
extern void EnterMlink(MlinkWidget w);
extern void LeaveMlink(MlinkWidget w);
extern void MoveMlinkInput(MlinkWidget w,
	int x, int direction, int shift, int control);
extern int  MoveMlinkDir(MlinkWidget w, const int direction);

#else

/* This gets around C's inability to do inheritance */
typedef struct _MlinkClassPart {
	int         ignore;
} MlinkClassPart;

typedef struct _MlinkClassRec {
	CoreClassPart coreClass;
	MlinkClassPart mlinkClass;
} MlinkClassRec;

extern MlinkClassRec mlinkClassRec;
#endif

#ifndef BUMPSOUND
#define BUMPSOUND "bump"
#endif
#ifndef MOVESOUND
#define MOVESOUND "move"
#endif

#define SYMBOL ':'

#define TOP 0
#define RIGHT 1
#define BOTTOM 2
#define LEFT 3
#define COORD 4

#define MAXSLICES 10

#define NORMAL 1
#define DOUBLE 2
#define INSTANT 3

typedef struct _MlinkPart {
	int        *tileOfPosition, spacePosition;
	int         currentTile, currentFace, currentRef;
	Boolean     started, cheat, sound, motion;
	Boolean     practice, orient, mono, reverse, middle, focus;
	Boolean     scoreOnly, versionOnly;
	int         delay, numSlices, motionDiff, shiftDiff;
	int         base;
	int         tiles, faces, tileFaces;
	Point       offset, tileSize, faceSize, puzzleSize;
	Point       delta, puzzleOffset, digitOffset;
	GC          frameGC, borderGC, inverseGC;
	GC          tileGC, tileBrighterGC, tileDarkerGC;
	GC          faceGC[MAXFACES];
	Pixmap      bufferTiles[2];
	TimeVal     oldTime;
#ifdef WINVER
	char        userName[81], scoreFile[81], bumpSound[81], moveSound[81];
	char        picture[81];
	char        faceChar[MAXFACES];
#else
	int         menu, graphicsFormat;
	char       *userName, *scoreFile, *bumpSound, *moveSound;
	char       *picture, *font;
	Boolean     install;
	Colormap    colormap, oldColormap;
	XImage     *image;
	XFontStruct *fontInfo;
	char       *faceName[MAXFACES];
	Pixel       foreground, background;
	Pixel       frameColor, tileColor, borderColor;
	Pixel       faceColor[MAXFACES];
	XtCallbackList select;
#endif
} MlinkPart;

typedef struct _MlinkRec {
	CorePart    core;
	MlinkPart   mlink;
} MlinkRec;

extern int *startPosition;
extern void SetMlink(MlinkWidget w, int reason);
extern Boolean MoveMlink(MlinkWidget w,
	const int direction, const int tile, const int shift,
	const Boolean motion, const int fast);
extern void MoveMlinkDelay(MlinkWidget w,
	const int direction, const int tile, const Boolean all);

extern void SolveSomeTiles(MlinkWidget w);
extern void DrawAllTiles(const MlinkWidget w);
extern Boolean CheckSolved(const MlinkWidget w);
extern void InitMoves(void);
extern void PutMove(int direction, int tile, int control);
extern void GetMove(int *direction, int *tile, int *control);
extern int  MadeMoves(void);
extern void FlushMoves(MlinkWidget w);
extern int  NumMoves(void);
extern void ScanMoves(FILE * fp, MlinkWidget w, int moves);
extern void PrintMoves(FILE * fp);
extern void ScanStartPosition(FILE * fp, MlinkWidget w);
extern void PrintStartPosition(FILE * fp, MlinkWidget w);
extern void SetStartPosition(MlinkWidget w);

#endif /* _MlinkP_h */
