/*-
# X-BASED CUBES
#
#  CubesP.h
#
###
#
#  Copyright (c) 1994 - 2005	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for Cubes */

#ifndef _CubesP_h
#define _CubesP_h

#include "xwin.h"
#include "timer.h"
#include "Cubes.h"

#ifdef WINVER

extern void DestroyCubes(HBRUSH brush);
extern void ResizeCubes(CubesWidget w);
extern void SizeCubes(CubesWidget w);
extern void InitializeCubes(CubesWidget w, HBRUSH brush);
extern void ExposeCubes(CubesWidget w);
extern void HideCubes(CubesWidget w);
extern void SelectCubes(CubesWidget w, const int x, const int y);
extern void ReleaseCubes(CubesWidget w);
extern void RandomizeCubes(CubesWidget w);
extern void ClearCubes(CubesWidget w);
extern void GetCubes(CubesWidget w);
extern void WriteCubes(CubesWidget w);
extern void UndoCubes(CubesWidget w);
extern void SolveCubes(CubesWidget w);
extern void SpeedCubes(CubesWidget w);
extern void SlowCubes(CubesWidget w);
extern void SoundCubes(CubesWidget w);
extern void EnterCubes(CubesWidget w);
extern void LeaveCubes(CubesWidget w);
extern int MoveCubes(CubesWidget w, const int direction, const int control);

#else

/* This gets around C's inability to do inheritance */
typedef struct _CompatClassPart {
	int         ignore;
} CompatClassPart;

typedef struct _CubesClassPart {
	int         ignore;
} CubesClassPart;

typedef struct _CubesClassRec {
	CoreClassPart coreClass;
	CubesClassPart cubesClass;
} CubesClassRec;

extern CubesClassRec cubesClassRec;
#endif

#ifndef BUMPSOUND
#define BUMPSOUND "bump"
#endif
#ifndef DRIPSOUND
#define DRIPSOUND "drip"
#endif

#define SYMBOL ':'

#define TOP 0
#define RIGHT 1
#define BOTTOM 2
#define LEFT 3
#define INWARDS 4
#define OUTWARDS 5
#define COORD 6

#define MAXSLICES 10

#define NORMAL 1
#define DOUBLE 2
#define INSTANT 3

typedef struct _CubesPart {
	int        *blockOfPosition, spacePosition;
	int         currentPosition, currentRow[3];
	Boolean     started, cheat, sound;
	Boolean     vertical, mono, reverse, focus;
	Boolean     scoreOnly, versionOnly;
	int         delay, numSlices;
	int         base;
	int         sizeX, sizeY, sizeZ, sizeRect, sizeBlock;
	Point       offset;
	Point       blockSize, faceSize, puzzleSize;
	Point       delta, puzzleOffset, digitOffset;
	GC          frameGC, borderGC, inverseGC;
	GC          blockGC, blockBrighterGC, blockDarkerGC;
	Pixmap      bufferBlocks[2];
	TimeVal     oldTime;
#ifdef WINVER
	char        userName[81], scoreFile[81], bumpSound[81], dripSound[81];
	char        picture[81];
#else
	char       *userName, *scoreFile, *bumpSound, *dripSound;
	char       *picture, *font;
	int         menu, graphicsFormat;
	Boolean     install;
	Colormap    colormap, oldColormap;
	XImage     *image;
	XFontStruct *fontInfo;
	Pixel       foreground, background;
	Pixel       frameColor, blockColor, borderColor;
	XtCallbackList select;
#endif
} CubesPart;

typedef struct _CubesRec {
	CorePart    core;
	CubesPart   cubes;
} CubesRec;

extern int *startPosition;
extern void SetCubes(CubesWidget w, int reason);
extern int  MoveCubesDir(CubesWidget w, const int direction, const int fast);
extern void AnimateSlide(CubesWidget w, int numBlocks, int direction, int fast,
	Boolean logMoves);

extern void SolveSomeBlocks(CubesWidget w);
extern void DrawAllBlocks(const CubesWidget w);
extern Boolean CheckSolved(const CubesWidget w);
extern void InitMoves(void);
extern void PutMove(int direction);
extern void GetMove(int *direction);
extern int  MadeMoves(void);
extern void FlushMoves(CubesWidget w);
extern int  NumMoves(void);
extern void ScanMoves(FILE * fp, CubesWidget w, int moves);
extern void PrintMoves(FILE * fp);
extern void ScanStartPosition(FILE * fp, CubesWidget w);
extern void PrintStartPosition(FILE * fp, CubesWidget w);
extern void SetStartPosition(CubesWidget w);

#endif /* _CubesP_h */
