#!/usr/bin/env python
# Copyright (C) 2010-2012 Antoine Martin <antoine@devloop.org.uk>

import sys
import os.path
import shutil
from subprocess import Popen, PIPE


def main():
    root_dir = os.getcwd()
    xrv_dir = os.path.join(root_dir, "Xrv")
    #apply the patches:
    files = os.listdir(xrv_dir)
    patch_files = [x for x in files if x.find(".patch")>0]
    if sys.platform.startswith("win"):
        patch_exe = os.environ.get("PATCH_EXE")
        if not patch_exe or not os.path.isfile(patch_exe):
            print("cannot patch without having %PATCH_EXE% defined!")
            return 1
        print("using patch.exe=%s" % patch_exe)
        patch = [patch_exe, "--binary", "-p0", "<"]
    else:
        patch = ["patch", "-p0", "<"]
    for f in sorted(patch_files):
        pfile = os.path.join(xrv_dir, f)
        if sys.platform.startswith("win"):
            cmd = patch[:]+[pfile]
        else:
            cmd = "patch -p0 < %s" % pfile
        print("applying %s: command=%s" % (f, cmd))
        p = Popen(cmd, shell=True, stdin=PIPE, stdout=PIPE, stderr=PIPE, cwd=root_dir)
        out,err = p.communicate()
        if out:
            print("out=%s" % out)
        if err:
            print("err=%s" % out)
        e = p.wait()
        if e!=0:
            print("failed to apply %s: exit code=%s" % (f, e))
            return p.returncode

    #copy some files:
    renames = [("xpra.1", "Xrv.1"),
               ("xpra_launcher.1", "Xrv_launcher.1"),
               ("xpra_launcher.desktop", "Xrv_launcher.desktop"),
               ("xpra.spec", "Xrv.spec"),
               ("scripts/xpra", "scripts/Xrv"),
               ("scripts/xpra_launcher", "scripts/Xrv_launcher"),
               ("COPYING", "README.TXT")
               ]
    for old,new in renames:
        op = os.path.join(root_dir, *old.split("/"))
        np = os.path.join(root_dir, *new.split("/"))
        print("copying %s to %s" % (op, np))
        shutil.copyfile(op, np)
    return 0

if __name__ == "__main__":
    code = main()
    sys.exit(code)
