/*
* Copyright (C) 2012 Canonical Ltd
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License version 3 as
* published by the Free Software Foundation.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
*/


#include "gtest/gtest.h"

#include "utils.h"

TEST(TestUtils, test_empty_query_is_absolute)
{
    bool is_absolute = xpathselect::utils::IsQueryAbsolute("");
    ASSERT_TRUE(is_absolute);
}

TEST(TestUtils, test_absolute_queries)
{
    ASSERT_TRUE(xpathselect::utils::IsQueryAbsolute("/"));
    ASSERT_TRUE(xpathselect::utils::IsQueryAbsolute("/some"));
    ASSERT_TRUE(xpathselect::utils::IsQueryAbsolute("/some/absolute/query"));
}

TEST(TestUtils, test_relative_queries)
{
    ASSERT_FALSE(xpathselect::utils::IsQueryAbsolute("//relative"));
}

TEST(TestUtils, test_invalid_relative_query)
{
    // this isn't actually a valid query, and we treat it as an absolute
    // query internally.
    ASSERT_TRUE(xpathselect::utils::IsQueryAbsolute("//"));
}
