/*
* Copyright (C) 2012 Canonical Ltd
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License version 3 as
* published by the Free Software Foundation.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
*/

#ifndef _DUMMYNODE_H
#define _DUMMYNODE_H

#include "node.h"

#include <map>

// simple implementation of the node interface for testing purposes.
class DummyNode: public xpathselect::Node
{
public:
    DummyNode(std::string name="DummyNode")
    : name_(name)
    {}

    std::string GetName() const override
    {
        return name_;
    }

    void SetName(std::string const& name)
    {
        name_ = name;
    }

    bool MatchProperty(const std::string& name, const std::string& value) const override
    {
        auto it = properties_.find(name);
        if (it == properties_.end() || it->second != value)
            return false;
        return true;
    }

    xpathselect::NodeList Children() const override
    {
        return children_;
    }

    void AddChild(Node::Ptr const& child)
    {
        children_.push_back(child);
    }

    void AddProperty(std::string const& name, std::string const& value)
    {
        properties_[name] = value;
    }

private:
    std::string name_;
    xpathselect::NodeList children_;
    std::map<std::string, std::string> properties_;
};


#endif
