/*
* Copyright (C) 2012 Canonical Ltd
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License version 3 as
* published by the Free Software Foundation.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
*/

#include "utils.h"

namespace xpathselect
{
    namespace utils
    {

        bool IsQueryAbsolute(std::string const& query)
        {
            // we should never be dealing with empty queries, but if we do,
            // deal with them as if they were absolute.
            if (query.empty())
                return true;
            if (query.size() == 1 && query.at(0) == '/')
                return true;
            // corner case - treat '//' as an absolute query:
            if (query == "//")
                return true;
            return query.at(0) == '/' && query.at(1) != '/';
        }
    }
}
