/* Xpaint-image */

#include <Xpaint.h>

/* This is an example of a batch script - its normal use is to
 * be invoked by xpaint from command line, e.g. via
 *   
 *  xpaint -iconic batch.c
 * 
 * This batch file opens by default the 'xpaint_input' file
 * and writes the output as PNG file    'xpaint_output'
 * 
 * (see code below)
 * 
 */

/* 
 * The key-word "ImageCreate" is reserved for user-defined image routines;
 * Such a routine should create and process an image.
 * 
 * Pixels are unsigned char arrays p[0]=red, p[1]=green, p[2]=blue
 * (thus each value should be in the range 0..255)
 *
 * In the example below, op = output pixel.
 * The procedure below just creates an image by mapping given functions
 * as red, green, blue components...
 */

Image * ImageCreate()
{
    Image * input, * output;
    unsigned char *ip, *op;
    int x, y, j;
    
    input = ImageFromFile("xpaint_input");
   
/* Don't forget this otherwise xpaint may crash if input does not exist */
    if (!input) {
       RWSetMsg("Cause: cannot read default input file 'xpaint_input' !!");
       return NULL;
    }
   
    output = ImageNew(input->width, input->height);

/* Example of batch procedure:
 * 1) shift the input image horizontally by  30 pixels
 * 2) convert to grey level image
 * 3) blank all pixels such that r+g+b>200
 * 4) put a white frame of 20 pixel width on the bordure of the image
 * 
 * Just modify to your fancy !!
 */
   
   
    for (y = 0; y < input->height; y++) {
        for (x = 0; x < input->width; x++) {
	    if (x < input->width-30) {
               ip = ImagePixel(input, x+30, y);
               j = ip[0]+ip[1]+ip[2];
	    } else
	       j = 767;
            op = ImagePixel(output, x, y);
            if ((j>700) || 
                (x<=20)||(y<=20)||
                (x>=input->width-20) || (y>=input->height-20))
	       op[0]=op[1]=op[2]=255;
            else {
	       j = j/3;
	    }
        }
    }
    WritePNGn("xpaint_output", output);
    exit(0);
    return output;
}


