// This file is a part of the Dynamic Preferences Library.
//
// Copyright (c) 2004 Theodore R.Smith (donate@xmule.ws / www.xmule.ws)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F  907B CB8B 654B E33B F1ED
//
// This file is dually licensed under the terms of the following licenses:
// * Primary License: OSSAL - Open Source Software Alliance License
//   * See the included License.OSSAL for complete details.
//   * Key points:
//       5.Redistributions of source code in any non-textual form (i.e.
//          binary or object form, etc.) must not be linked to software that is
//          released with a license that requires disclosure of source code
//          (ex: the GPL).
//       6.Redistributions of source code must be licensed under more than one
//          license and must not have the terms of the OSSAL removed.
//
// * Secondary License: Creative Commons Attribution-NoDerivs License v1.0
//   * See the included License.CCANDL for complete details.
//   * Key Points:
//       * You are free:
//           * to copy, distribute, display, and perform the work
//           * to make non-commercial use of the work in its original form
//       * Under the following conditions:
//           * Attribution.You must give the original author credit.
//           * No Derivative Works.You may not alter, transform, or build upon
//             this work.
//
// * Special exceptions:
//   I, Theodore R.Smith, hereby grant, as the sole author of this library,
//   exclusive permission to the xMule Project to distribute and link to this
//   library, specifically voiding clause 5 of the OSSAL for the xMule Project.
//   As a further exclusive permission, when linked to the xMule Project,
//   the terms of the GPL concerning binary distribution must be observed.
//
// For more information on legality, see README.txt.

#include "DynPrefs.h"

#include <list>                             // Needed for std::list
#include <map>                              // Needed for std::map
#include <utility>                          // Needed for std::pair
#include <vector>                           // Needed for std::vector

#include <wx/log.h>                         // Needed for wxLogDebug

#if wxCHECK_VERSION(2, 5, 1)
    #include <wx/xml/xml.h>                 // Needed for wxXmlNode
#else
    #include <wx/xrc/xml.h>                 // Needed for wxXmlNode
#endif

#include <wx/button.h>                      // Needed for wxButton
#include <wx/checkbox.h>                    // Needed for wxCheckBox
#include <wx/combobox.h>                    // Needed for wxComboBox
#include <wx/dirdlg.h>                      // Needed for wxDirDialog
#include <wx/filesys.h>                     // Needed for wxFileSystem
#include <wx/intl.h>                        // Needed for _
#include <wx/msgdlg.h>                      // Needed for wxMessageBox
#include <wx/sizer.h>                       // Needed for wxBoxSizer
#include <wx/slider.h>                      // Needed for wxSlider
#include <wx/statline.h>                    // Needed for wxStaticLine
#include <wx/stattext.h>                    // Needed for wxStaticText
#include <wx/textctrl.h>                    // Needed for EVT_TEXT
#include <wx/valtext.h>                     // Needed for wxFILTER_NUMERIC

static std::map<const wxString, bool > bools;
static std::map<const wxString, long > longs;
static std::map<const wxString, double > doubles;
static std::map<const wxString, wxString > strings;

template <> bool DynamicPreferences::Get(const wxString& preference)
{
    return bools[preference];
}

template <> double DynamicPreferences::Get(const wxString& preference)
{
    return doubles[preference];
}

template <> long DynamicPreferences::Get(const wxString& preference)
{
    return longs[preference];
}

template <> wxString DynamicPreferences::Get(const wxString& preference)
{
    return strings[preference];
}

void DynamicPreferences::Add(const wxString& preference, bool data)
{
    bools[preference] = data;
}

void DynamicPreferences::Add(const wxString& preference, double data)
{
    doubles[preference] = data;
}

void DynamicPreferences::Add(const wxString& preference, long data)
{
    longs[preference] = data;
}

void DynamicPreferences::Add(const wxString& preference, wxString data)
{
    strings[preference] = data;
}

