// This file is part of the xmule project.
//
// Copyright (c) 2004, 2005 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef XMULEIPV4ADDRESS_H
#define XMULEIPV4ADDRESS_H

#if defined(__WXMSW__)
    #include <winsock.h>
#else
    #include <sys/socket.h>
    #include <netinet/in.h>
    #include <arpa/inet.h>
#endif

#include <wx/defs.h>                        // Needed before any other wx/*.h
#include <wx/object.h>                      // Needed by wx/sckaddr.h
#include <wx/sckaddr.h>                     // Needed for wxIPV4address

class xmuleIPV4Address: public wxIPV4address {
public:
    xmuleIPV4Address(void) { }
    virtual bool Hostname(unsigned long addr)
    {
        return (GAddress_INET_SetHostAddress(m_address, addr) == GSOCK_NOERROR);
    }

    virtual bool Hostname(const wxString& addr)
    {
        if (addr.empty() == true)
        {
            return false;
        }

        struct in_addr inaddr;
        inet_aton(static_cast<const char *>(addr.c_str()), &inaddr);

        #if wxCHECK_VERSION(2, 5, 2)
            inaddr.s_addr = ntohl(inaddr.s_addr);
        #endif
        return (GAddress_INET_SetHostAddress(m_address, inaddr.s_addr) == GSOCK_NOERROR);
    }
};

#endif // XMULEIPV4ADDRESS_H
