#ifndef __TREEMULTIITEMWINDOW_HPP_
#define __TREEMULTIITEMWINDOW_HPP_

/////////////////////////////////////////////////////////////////////////////
// Name:        TreeMultiItemWindow.h
// Author:      Jorgen Bodde
// Created:     Tuesday, February 24, 2004 22:42:08
// Copyright:   (c) Jorgen Bodde, based on wxWidgets License
/////////////////////////////////////////////////////////////////////////////

#include <wx/dynarray.h>

#include "TreeMultiItemBase.h"

class wxWindow;

class TreeMultiItemWindow : public TreeMultiItemBase
{
private:
	/** The simple control, or complex sizer that represents this window
		in the TreeMultiCtrl */
	wxWindow *_window;

	/** Top and front extra spacings, added to X, Y */
	int _topSpacing, _frontSpacing;
    int m_width;

public:
	TreeMultiItemWindow(TreeMultiItemNode *parent, const wxString &name = wxEmptyString, int width=-1);
	virtual ~TreeMultiItemWindow();

	// IsClass method
	virtual TreeMultiItemWindow *IsTreeMultiItemWindow() const {
		return (TreeMultiItemWindow *)this;
	};
	
	/** Assigns the given window to this TreeMultiItemWindow, and also destroys the 
		present window. If the assigned window is 0, this item is not drawn
		and removed from the tree visually */
	void AssignWindow(wxWindow *wnd);

	/** Get window method */
	wxWindow *GetWindow() {
		return _window;
	};

	/* Sets front spacing */
	void SetFrontSpacing(int frontSpacing) {
		_frontSpacing = frontSpacing;
	};
	/* Gets front spacing */
	int GetFrontSpacing() const {
		return _frontSpacing;
	};
	/* Sets top spacing */
	void SetTopSpacing(int topSpacing) {
		_topSpacing = topSpacing;
	};
	/* Gets top spacing */
	int GetTopSpacing() const {
		return _topSpacing;
	};

};

#endif

