// This file is a part of the xMule Project.
//
// Copyright (c) 2004, 2005 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.xmule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef EMSOCKET_H
#define EMSOCKET_H

#include "mfc.h"                            // CList - 4 Nov 2004

#include <stdint.h>                         // uint16_t
#include <wx/socket.h>

class Packet;

#define ERR_WRONGHEADER		0x01
#define ERR_TOOBIG			0x02

#define	ES_DISCONNECTED		0xFF
#define	ES_NOTCONNECTED		0x00
#define	ES_CONNECTED		0x01

#define PACKET_HEADER_SIZE 6

//WX_DECLARE_LIST(Packet,PacketListL);

class CEMSocket :
	public wxSocketClient
{
  DECLARE_DYNAMIC_CLASS(CEMSocket)
    
public:
	CEMSocket(void);
	~CEMSocket(void);
	bool	SendPacket(Packet* packet, bool delpacket = true,bool controlpacket = true);// controlpackets have a higher priority
	bool	IsBusy()	{return sendbuffer;}
	bool	IsConnected() { return byConnected==ES_CONNECTED;};
	uint8_t	GetConState()	{return byConnected;}
	void	SetDownloadLimit(uint32_t limit);
	void	DisableDownloadLimit();
	bool	AsyncSelect(long lEvent);
	//protected:
 public:
	virtual void	PacketReceived(Packet* packet)		{}
	virtual void	OnError(int nErrorCode)				{}
	virtual void	OnClose(int nErrorCode);
	virtual void	OnSend(int nErrorCode);	
	virtual void	OnReceive(int nErrorCode);
	uint8_t	byConnected;

	private:
	void	ClearQueues();	
	int		Send(char* lpBuf,int nBufLen,int nFlags = 0);

	uint32_t	downloadlimit;
	bool	limitenabled;
	bool	pendingOnReceive;

	// Download partial header
	char*	pendingHeader[PACKET_HEADER_SIZE];      
	uint32_t	pendingHeaderSize;

	// Download partial packet
	Packet* pendingPacket;
	uint32_t  pendingPacketSize;

/*  Removed since 0.30d import of cpu-less download
	char*	readbuf;
	uint32_t  readbuf_size;
	char	header[6];
*/

	char*	sendbuffer;
	uint32_t	sendblen;
	uint32_t	sent;
	bool	m_bLinkedPackets;

	CList<Packet*, Packet*> controlpacket_queue;
	CList<Packet*, Packet*> standartpacket_queue;
};

#endif // EMSOCKET_H
