// This file is a part of the xMule Project.
//
// Copyright (c) 2004, 2005 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.xmule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef DOWNLOADQUEUE_H
#define DOWNLOADQUEUE_H

#include "mfc.h"                            // Needed for wxString - audited 4 Nov 2004
#include "resource.h"                       // Needed for IDD_TRANSFER - audited 4 Nov 2004
#include "wintypes.h"                       // Needed for DWORD - audited 5 Nov 2004

#include <stdint.h>                         // Needed for uint16_t

class CED2KFileLink;
class CPartFile;
class CPreferences;
class CSafeMemFile;
class CSearchFile;
class CServer;
class CSharedFileList;
class CUpDownClient;

class CDownloadQueue
{
	friend class CAddFileThread;
	friend class CServerSocket;
public:
	CDownloadQueue(CPreferences* in_prefs, CSharedFileList* in_sharedfilelist);
	~CDownloadQueue();
	void	Process();
	void	Init();
	void	AddSearchToDownload(CSearchFile* toadd);
	void	AddSearchToDownload(wxString link);
	void	AddFileLinkToDownload(class CED2KFileLink* pLink);
	bool	IsFileExisting(unsigned char* fileid);
	bool	IsPartFile(void* totest);
	CPartFile*	GetFileByID(unsigned char* filehash);
	CPartFile* GetFileByIndex(int idx);
	void    CheckAndAddSource(CPartFile* sender,CUpDownClient* source);
	void    CheckAndAddKnownSource(CPartFile* sender,CUpDownClient* source);
	bool	RemoveSource(CUpDownClient* toremove, bool updatewindow = true);
	void	DeleteAll();
	void	RemoveFile(CPartFile* toremove);
	uint32_t	GetDatarate()			{return datarate;}
	void	SortByPriority();
	void	StopUDPRequests();
	CServer*	cur_udpserver;
	void	GetDownloadStats(int results[]);
	void	AddPartFilesToShare();
	void	AddDownload(CPartFile* newfile);
	CUpDownClient* 	GetDownloadClientByIP(uint32_t dwIP);
	void	UpdateDisplayedInfo(bool force=false);
	void	StartNextFile();
	void	AddDownDataOverheadSourceExchange(uint32_t data)	{ m_nDownDataRateMSOverhead += data;
															  m_nDownDataOverheadSourceExchange += data;
															  m_nDownDataOverheadSourceExchangePackets++;}
	void	AddDownDataOverheadFileRequest(uint32_t data)		{ m_nDownDataRateMSOverhead += data;
															  m_nDownDataOverheadFileRequest += data;
															  m_nDownDataOverheadFileRequestPackets++;}
	void	AddDownDataOverheadServer(uint32_t data)			{ m_nDownDataRateMSOverhead += data;
															  m_nDownDataOverheadServer += data;
															  m_nDownDataOverheadServerPackets++;}
	void	AddDownDataOverheadOther(uint32_t data)			{ m_nDownDataRateMSOverhead += data;
															  m_nDownDataOverheadOther += data;
															  m_nDownDataOverheadOtherPackets++;}
	void	AddLinksFromFile();
	
	uint32_t	GetDownDatarateOverhead()			{return m_nDownDatarateOverhead;}
	uint64_t	GetDownDataOverheadSourceExchange()		{return m_nDownDataOverheadSourceExchange;}
	uint64_t	GetDownDataOverheadFileRequest()		{return m_nDownDataOverheadFileRequest;}
	uint64_t	GetDownDataOverheadServer()			{return m_nDownDataOverheadServer;}
	uint64_t	GetDownDataOverheadOther()			{return m_nDownDataOverheadOther;}
	uint64_t	GetDownDataOverheadSourceExchangePackets()	{return m_nDownDataOverheadSourceExchangePackets;}
	uint64_t	GetDownDataOverheadFileRequestPackets()		{return m_nDownDataOverheadFileRequestPackets;}
	uint64_t	GetDownDataOverheadServerPackets()		{return m_nDownDataOverheadServerPackets;}
	uint64_t	GetDownDataOverheadOtherPackets()		{return m_nDownDataOverheadOtherPackets;}
	void	CompDownDatarateOverhead();
	int	GetFileCount()					{return filelist.GetCount();}
	void	ResetCatParts(int cat);
	void	SavePartFiles(bool del = false);	// InterCeptor
	void	SetCatPrio(int cat, uint8_t newprio);
	void	SetCatStatus(int cat, int newstatus);
protected:
	bool	SendNextUDPPacket();
	int	GetMaxFilesPerUDPServerPacket() const;
	bool	SendGlobGetSourcesUDPPacket(CSafeMemFile& data);
private:
	CTypedPtrList<CPtrList, CPartFile*> filelist;
	CSharedFileList* sharedfilelist;
	CPreferences*	 app_prefs;
	uint16_t	filesrdy;
	uint32_t	datarate;
	
	CPartFile*	lastfile;
	uint32_t		lastudpsearchtime;
	uint32_t		lastudpstattime;
	uint32_t		m_nLastED2KLinkCheck;
	uint8_t		udcounter;
	uint8_t		m_cRequestsSentToServer;
	int		m_iSearchedServers;

	uint32_t		m_nDownDatarateOverhead;
	uint32_t		m_nDownDataRateMSOverhead;
	uint64_t		m_nDownDataOverheadSourceExchange;
	uint64_t		m_nDownDataOverheadSourceExchangePackets;
	uint64_t		m_nDownDataOverheadFileRequest;
	uint64_t		m_nDownDataOverheadFileRequestPackets;
	uint64_t		m_nDownDataOverheadServer;
	uint64_t		m_nDownDataOverheadServerPackets;
	uint64_t		m_nDownDataOverheadOther;
	uint64_t		m_nDownDataOverheadOtherPackets;
	CList<int,int>	m_AvarageDDRO_list;

    DWORD m_lastRefreshedDLDisplay;

/* Razor 1a - Modif by MikaelB */
public:

	/* RemoveSourceFromPartFile function */
	void  RemoveSourceFromPartFile(CPartFile* file, CUpDownClient* client, POSITION position);

	/* DisableAnyA4AFAuto function */
	void  DisableAnyA4AFAuto(void); 

/* End Modif */

};


#endif
