/*=============================================================================
XMOTO
Copyright (C) 2005 Rasmus Neckelmann (neckelmann@gmail.com)

This file is part of XMOTO.

XMOTO is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

XMOTO is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with XMOTO; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
=============================================================================*/

#ifndef __xBUILTINFONT_H__
#define __xBUILTINFONT_H__

#include "VCommon.h"

#ifndef NULL
#define NULL 0
#endif

class CBuiltInFont {  
  public:
    CBuiltInFont() {m_pcData=NULL; _DecodeData();}
    ~CBuiltInFont() {delete [] m_pcData;}

    int getCharWidth(void) {return 8;} /* Always 8 pixels wide */
    int getCharHeight(void) {return 12;} /* Always 12 pixels high */

    unsigned char *fetchChar(int nChar) {
      if(nChar<33 || nChar>254) return fetchChar(254); /* default char */
      return &m_pcData[96*(nChar-33)];
    }

  private:
    void _DecodeData(void); /* decode the data. Evil :) */
    unsigned char *m_pcData;
};

#ifdef DEFINEFONTDATA

unsigned char g_cBuiltInFontData[] = {
  0x07,0xc1,0xde,0x6a,0xab,0xad,0x3b,0x66,0x1c,0x93,0x74,0x11,
  0x11,0xf1,0x37,0xb6,0x24,0x49,0x92,0xf7,0x7c,0x4f,0x56,0xf1,
  0x7c,0xcf,0xf7,0x64,0x15,0xcf,0xf7,0x4c,0xaa,0x63,0x5f,0x70,
  0xdc,0xdb,0xee,0xc8,0xd2,0x1d,0x93,0xa4,0xfa,0x1b,0x62,0xb7,
  0xdb,0xed,0x22,0xdb,0x9b,0xe4,0x4b,0xf5,0x7c,0xcf,0x5a,0xea,
  0x72,0xdb,0x79,0xed,0x44,0xbc,0xf2,0xe5,0x4c,0xf2,0x8e,0x63,
  0x37,0x49,0x92,0x24,0x67,0xb7,0xdb,0x1d,0xc7,0xdd,0xdd,0xdd,
  0x24,0xef,0xee,0xee,0xee,0x38,0x76,0xbb,0xdd,0x24,0xc9,0x88,
  0xdf,0x58,0xa1,0xbd,0x98,0x24,0x49,0xaa,0x63,0x5d,0x57,0xc7,
  0x24,0x49,0x92,0x24,0xe9,0xa5,0x97,0x6a,0x92,0x24,0x7d,0x35,
  0x49,0x92,0x24,0x49,0x92,0x2f,0xbd,0x24,0x49,0x6e,0x1b,0xbb,
  0xdd,0x6e,0xb7,0x3b,0x5b,0x92,0x2c,0xf8,0x9e,0x94,0xf3,0xda,
  0x79,0xdb,0x79,0xed,0xbc,0x82,0xe7,0xcb,0x92,0xa4,0x6f,0x63,
  0x6d,0xe3,0x38,0x8e,0x63,0x5d,0x27,0xf9,0xf6,0x22,0xe2,0xd8,
  0xed,0x76,0xbb,0xc8,0x3a,0xc9,0xb7,0x17,0xc7,0xb1,0x96,0xdd,
  0x11,0xf1,0x5b,0x92,0xdd,0x5e,0x6a,0x7b,0x4f,0x44,0x56,0xbb,
  0x63,0x6f,0x49,0x6e,0x8d,0xe3,0x38,0xcb,0xee,0x88,0xf8,0x2d,
  0x49,0x2f,0xd5,0xee,0x38,0xcb,0x8b,0x88,0x88,0xdf,0x92,0xfc,
  0xea,0xf9,0x9e,0xef,0xd8,0xed,0x76,0xc7,0x31,0x49,0x6f,0x2f,
  0x22,0x52,0xce,0x6f,0xef,0x15,0x44,0xc4,0x6f,0x49,0x6a,0x7b,
  0x11,0x11,0xf1,0x97,0xee,0xd8,0xed,0x25,0x49,0x32,0xa5,0x97,
  0xa4,0x97,0x5e,0x92,0x24,0xe9,0xa5,0x97,0xa4,0x97,0x5e,0xc6,
  0x6e,0x12,0xbb,0xdd,0x6e,0x77,0x77,0x77,0x77,0x37,0x49,0x92,
  0x5f,0x87,0x75,0x92,0x24,0xb8,0xbb,0xbb,0xbb,0xdb,0xed,0x76,
  0xbb,0x49,0xa6,0xbd,0x38,0x76,0xbb,0x63,0xc6,0x31,0x49,0x5f,
  0xf0,0x3d,0xdf,0xf3,0xda,0x79,0xed,0xbc,0x76,0x8e,0xfb,0x92,
  0xa4,0xda,0xdb,0x8b,0x88,0x88,0xac,0x11,0x11,0x11,0x93,0xb0,
  0x7e,0x11,0x11,0x91,0xe5,0x45,0x44,0xc4,0x5b,0x27,0xa9,0xed,
  0xc5,0xf3,0x3d,0xc7,0x71,0x7c,0x11,0xbf,0x25,0x61,0xa9,0x9e,
  0x2f,0x22,0x22,0x22,0x22,0xe2,0xc9,0x92,0xe4,0x57,0xf1,0x37,
  0x1c,0xd9,0x7e,0x79,0xd9,0xde,0xf1,0xb7,0x5b,0x4d,0x72,0xab,
  0x88,0xf8,0x1b,0xb2,0xfd,0xf2,0xb2,0xbd,0x63,0x6f,0x49,0xa6,
  0xbd,0x78,0xbe,0xe7,0x38,0x52,0xce,0x17,0xf1,0x97,0x24,0x27,
  0x22,0x22,0x22,0xb2,0x46,0x44,0x44,0x44,0x4c,0xf2,0xad,0x3b,
  0x8e,0xe3,0x38,0x8e,0xbd,0x25,0x99,0xd6,0x1d,0xc7,0x11,0x11,
  0x11,0xf1,0x5b,0x92,0x2f,0x88,0x88,0xe7,0x7b,0x7e,0xab,0x9e,
  0xef,0xf9,0xe2,0x15,0x4c,0x72,0xad,0x3b,0x8e,0xe3,0xf8,0x1b,
  0x22,0xe2,0xad,0x26,0x39,0xdf,0x2b,0x57,0x6e,0xf5,0x56,0xcf,
  0xdb,0xce,0xf3,0x3d,0xdf,0xf3,0x3d,0xdf,0x24,0xe7,0x7b,0xbe,
  0x57,0xf0,0xda,0x79,0xab,0xe7,0xb5,0x93,0x72,0xbe,0xe7,0x9b,
  0xe4,0x4b,0xf5,0xc4,0xf7,0x7c,0xcf,0xf7,0x7c,0xcf,0x17,0xcf,
  0x5a,0x92,0xfc,0xfa,0x45,0x44,0x44,0x96,0x77,0x1c,0x7b,0x4b,
  0x32,0xa5,0x7a,0xe2,0x7b,0xbe,0xe7,0x7b,0x52,0xce,0x6b,0x2c,
  0x63,0x6f,0xc9,0xad,0x5f,0x44,0x44,0x64,0x79,0xcf,0x17,0x11,
  0xaf,0x60,0x12,0xda,0x8b,0x88,0xb8,0x97,0xdd,0x17,0x11,0xbf,
  0x25,0xf9,0x35,0xdb,0x79,0x5b,0x75,0x1c,0xc7,0x71,0xec,0x2d,
  0xc9,0x8b,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0xdf,0x92,0xbc,
  0x88,0x88,0x88,0x88,0x88,0x88,0xf8,0xad,0x9b,0xa4,0xfa,0x9e,
  0xef,0xf9,0x9e,0xef,0x79,0xdb,0x79,0xde,0x76,0xe2,0xf9,0x9e,
  0xef,0x99,0x04,0x11,0x11,0xf1,0x5b,0xb7,0xb7,0x17,0x11,0x11,
  0x93,0x20,0x22,0x22,0x22,0x7e,0xeb,0x8e,0x63,0x6f,0x49,0x7e,
  0xf5,0xa4,0xdc,0x86,0x63,0xb7,0x3b,0xfe,0x76,0xbe,0xb7,0x9a,
  0xe4,0x5b,0x75,0x1c,0xc7,0x71,0x1c,0xa7,0x25,0x09,0xdb,0xee,
  0xee,0xee,0xee,0xee,0xee,0xbe,0x25,0xf9,0x36,0x8e,0xe3,0x38,
  0x8e,0x63,0x6d,0x49,0xdf,0xa6,0x54,0x4f,0x7c,0x93,0x24,0x49,
  0x92,0x24,0x49,0x92,0x5b,0x09,0x8e,0xbb,0x49,0x92,0x24,0x49,
  0x92,0xda,0x76,0x7f,0x41,0x44,0xfc,0x72,0x26,0xb9,0x32,0x8e,
  0xb3,0xbc,0x88,0x88,0x88,0x78,0x5e,0x49,0x92,0xe4,0xdb,0x8b,
  0x38,0x8e,0xf8,0x2d,0xc9,0x94,0x71,0xfc,0x05,0x11,0x11,0x11,
  0xf1,0xcb,0x99,0x24,0x09,0xed,0x45,0xd6,0x38,0xe2,0xb7,0x24,
  0xbd,0x54,0xcf,0x77,0xec,0x4b,0x75,0x1c,0x7b,0x4b,0x92,0xa4,
  0x97,0xf3,0x44,0x44,0xc4,0x5f,0x46,0xc4,0x6f,0xf9,0x32,0x8e,
  0xe3,0xf9,0xe5,0x44,0x44,0x44,0xbc,0x82,0x49,0xaa,0x63,0x6a,
  0x1b,0xc7,0x71,0xac,0xeb,0x24,0xdd,0x31,0xb5,0x8d,0xe3,0x38,
  0x22,0x22,0x7e,0xcb,0x97,0x71,0x1c,0x11,0xcf,0x6f,0xd5,0xf3,
  0xc5,0x2b,0x98,0x84,0x36,0x8e,0xe3,0x38,0x8e,0x63,0x5d,0x27,
  0x49,0x72,0x6b,0xbc,0xed,0x3c,0x6f,0x3b,0xcf,0xdb,0xce,0xf3,
  0xb6,0xf3,0x7c,0x93,0x24,0xb9,0xe5,0x45,0x44,0x44,0x44,0xc4,
  0x24,0x49,0xbe,0xbd,0x88,0x88,0x88,0xf8,0x2d,0x49,0x92,0xf7,
  0xca,0x8b,0x88,0x88,0x88,0x2c,0x6f,0x6f,0x49,0xd2,0xcb,0x79,
  0x22,0x22,0x22,0xe2,0x2f,0x63,0x6f,0x49,0x72,0xe5,0x7c,0xaf,
  0x50,0x4e,0x1c,0x7b,0x4b,0x92,0xa4,0xb7,0x17,0xdf,0xf8,0xe2,
  0xb7,0x24,0xe9,0xdb,0xd8,0xd7,0xef,0x38,0x8e,0x67,0x2d,0x49,
  0x92,0xbc,0x88,0x88,0x88,0x88,0xf8,0xe5,0x4c,0x92,0xe4,0x44,
  0x44,0x44,0xc4,0x6f,0xdd,0x24,0x49,0xaa,0xef,0xf9,0x9e,0xb7,
  0x9d,0xe7,0x6d,0x27,0x9e,0xef,0x99,0x24,0x09,0xbe,0x78,0xd6,
  0xd2,0x4b,0xf5,0xc4,0x37,0x49,0x12,0x44,0x44,0x44,0xc4,0x6f,
  0x63,0xf7,0x5b,0x92,0xd4,0x35,0xdb,0xdb,0xad,0x76,0x7f,0x63,
  0x9d,0xa4,0x97,0xea,0xd8,0xed,0xee,0xee,0x8e,0x7b,0x49,0xd2,
  0x1d,0xc7,0x31,0xe3,0x38,0x8e,0x49,0xbe,0xec,0x8e,0xbb,0xbb,
  0xdd,0xee,0x58,0x4b,0x92,0x29,0xb4,0xf3,0xb6,0x93,0x92,0x24,
  0x49,0x92,0xa4,0x6e,0x53,0xaa,0x27,0xbe,0xe7,0x7b,0xab,0x49,
  0x42,0x7b,0x11,0x11,0xc7,0x71,0x44,0xc4,0x6f,0xdd,0xda,0x52,
  0x45,0xc4,0x20,0x22,0x22,0x22,0x22,0x7e,0x39,0x93,0x6e,0xb7,
  0x9b,0xde,0x5e,0x64,0x8d,0x23,0x7e,0x4b,0xba,0xbd,0xbd,0x98,
  0x6f,0xbb,0xbf,0x20,0x22,0x7e,0x39,0x93,0x9c,0x88,0x98,0x6f,
  0xbb,0xbf,0x20,0x22,0x7e,0x39,0x93,0x73,0x77,0x37,0xbd,0xed,
  0xfe,0x82,0x88,0xf8,0xe5,0x4c,0xbe,0x54,0xcf,0xf7,0xac,0xe5,
  0x97,0xdd,0x5f,0x10,0x11,0xbf,0x9c,0x49,0x92,0xd0,0x5e,0xc4,
  0x71,0xc4,0x6f,0xdd,0xda,0xc6,0xde,0x5e,0xcc,0xb7,0x17,0x59,
  0xe3,0xb8,0x2f,0x49,0x10,0x11,0xf3,0xed,0x45,0xd6,0x38,0xee,
  0x4b,0x82,0xbb,0xbb,0xe9,0xed,0x45,0xd6,0x38,0xee,0x4b,0x92,
  0xf7,0x7c,0xcf,0x7c,0x1b,0xc7,0x71,0xac,0xeb,0xa4,0x6e,0x53,
  0xaa,0x67,0xbe,0x8d,0xe3,0x38,0xd6,0x75,0x82,0xbb,0xbb,0xa9,
  0x6d,0x1c,0xc7,0xb1,0xae,0x93,0x9c,0x98,0x6a,0x6f,0x2f,0x22,
  0xb2,0x46,0x44,0x4c,0xbe,0xbd,0x88,0xf8,0xad,0xb6,0x17,0x11,
  0x59,0x23,0x22,0x26,0x63,0xb7,0x5b,0xd7,0xf8,0x1b,0xce,0xf2,
  0x8e,0xbf,0xb1,0x4e,0x92,0x84,0xd5,0xea,0x79,0x2b,0xdb,0xf9,
  0x9e,0x5f,0xae,0x25,0x61,0xa1,0xbd,0xe7,0x7b,0xfe,0xea,0x79,
  0xbe,0xe7,0x7b,0xbe,0xd7,0x92,0xb7,0xb7,0x17,0xf3,0xed,0x45,
  0x44,0x44,0xc4,0x6f,0x49,0x5e,0x44,0xcc,0xb7,0x17,0x11,0x11,
  0x11,0xbf,0x25,0xef,0xee,0x6e,0x7a,0x7b,0x11,0x11,0x11,0xf1,
  0x5b,0xd2,0xed,0xed,0xc5,0x20,0x22,0x22,0x22,0x22,0x7e,0x39,
  0x93,0x73,0x77,0x37,0x55,0x44,0x44,0x44,0x44,0xfc,0x72,0x26,
  0x41,0x44,0x0c,0x22,0x22,0x22,0xe2,0xb7,0xb1,0xfb,0xad,0x8a,
  0xf9,0xf6,0x22,0x22,0x22,0x22,0x22,0xe2,0xb7,0xe4,0xc5,0x20,
  0x22,0x22,0x22,0x22,0x22,0x22,0x7e,0x4b,0xd2,0x1d,0x7b,0x7b,
  0x11,0xc7,0x11,0xbf,0x75,0xc7,0x4c,0x7b,0x11,0xc7,0xb1,0xaf,
  0xdf,0xb1,0x3b,0xab,0xc9,0x89,0x88,0x88,0x88,0xdf,0x7e,0x5d,
  0xad,0xeb,0xea,0x98,0xd4,0x56,0xb7,0xdf,0x7e,0xfb,0xed,0xb7,
  0xdf,0xbe,0xd5,0xed,0xb7,0xdf,0x68,0xb7,0xbd,0x6c,0xef,0x59,
  0x4d,0x7a,0xa9,0x9e,0xef,0x58,0xd7,0xd5,0x71,0x7c,0xcf,0x5a,
  0x92,0xd8,0xed,0xa6,0xb7,0xdd,0x5f,0x10,0x11,0xbf,0x9c,0x49,
  0xb7,0xdb,0x4d,0x6f,0xe3,0x38,0x8e,0x75,0x9d,0x74,0xbb,0xdd,
  0xf4,0xf6,0x22,0x22,0x22,0xe2,0xb7,0x64,0xb7,0xdb,0x4d,0x15,
  0x11,0x11,0x11,0x11,0xbf,0x9c,0x49,0x28,0xe7,0x79,0x25,0x2c,
  0x2f,0x22,0x22,0x22,0x22,0x26,0x5f,0xce,0xf3,0x4a,0xf0,0xbd,
  0x82,0xd7,0xce,0xf3,0xda,0x49,0x39,0xdf,0xf3,0x4d,0x42,0x7b,
  0x11,0xf1,0xd7,0xb9,0xd5,0x24,0x49,0x68,0x2f,0x22,0x7e,0xcb,
  0xaf,0x26,0x49,0xf2,0x8e,0x19,0xbb,0xdd,0x71,0xc4,0x6f,0x49,
  0x92,0xe4,0xd7,0x38,0x8e,0x49,0x92,0x24,0xb3,0x1e,0xc7,0x31,
  0x49,0x7e,0xab,0xdb,0xf9,0x9e,0x88,0x67,0xb7,0x7b,0xe5,0xac,
  0xa5,0xda,0xed,0x4b,0x72,0xfe,0x82,0x78,0x7e,0xeb,0x5e,0x39,
  0x6f,0x7d,0x5e,0x39,0x91,0xf5,0x98,0xe0,0x98,0x71,0xec,0xad,
  0xb6,0xda,0xba,0x49,0x92,0x8c,0x78,0xe2,0x89,0x88,0x2f,0xbe,
  0x98,0x24,0x89,0xf8,0xe2,0x8b,0x88,0x27,0x9e,0x98,0xd4,0x8d,
  0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,
  0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,
  0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0xed,0xb6,0xdb,0x6e,0x3b,0x6f,
  0xbb,0xed,0x36,0xb6,0xdb,0x6e,0x3b,0x6f,0xbb,0xed,0x36,0xb6,
  0xdb,0x6e,0x3b,0x6f,0xbb,0xed,0x36,0xb6,0xdb,0x6e,0x3b,0x6f,
  0xbb,0xed,0x36,0xb6,0xdb,0x6e,0x3b,0x6f,0xbb,0xed,0x36,0xb6,
  0xdb,0x6e,0x3b,0x6f,0xbb,0xed,0x36,0x3c,0xaf,0x9c,0x57,0xce,
  0x13,0xcf,0x2b,0xe7,0x95,0xf3,0xc4,0xf3,0xca,0x79,0xe5,0x3c,
  0xf1,0xbc,0x72,0x5e,0x39,0xcf,0xea,0x38,0x8e,0xe3,0x38,0x8e,
  0xe3,0x38,0x8e,0xe3,0x38,0x8e,0xe3,0x2f,0xe3,0x38,0x8e,0xe3,
  0x38,0x8e,0xe3,0xf8,0xcb,0x38,0xfe,0x32,0x8e,0xe3,0x58,0x45,
  0x44,0x44,0x44,0xc4,0x2b,0x88,0x88,0x88,0x88,0x88,0x88,0x98,
  0x24,0xb9,0x55,0x44,0x44,0x44,0x44,0x44,0xc4,0x24,0xb9,0x65,
  0x1c,0x7f,0x19,0xc7,0x71,0xac,0x22,0x22,0x22,0xe2,0x15,0x1c,
  0xc7,0x2b,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
  0x88,0x88,0x88,0x88,0x88,0x88,0x98,0x24,0xb7,0x3a,0x8e,0x57,
  0x10,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0xf1,0x0a,0x8e,0xe3,
  0xad,0x26,0x09,0x22,0x22,0x22,0x22,0xe2,0xad,0x26,0x49,0x52,
  0x1d,0xc7,0xf1,0x97,0x71,0xfc,0x25,0x49,0x92,0x24,0xbf,0x8c,
  0xe3,0x38,0x8e,0xe3,0x38,0x8e,0xe3,0x38,0x4b,0x92,0x24,0x49,
  0x92,0x95,0x71,0x1c,0xc7,0x71,0x4c,0x92,0xac,0xbc,0xe3,0x38,
  0x8e,0xe3,0x38,0x8e,0xe3,0x38,0xcb,0x3b,0x8e,0xe3,0x38,0x26,
  0x49,0x7e,0x25,0x49,0x92,0x77,0x1c,0xc7,0xf1,0x57,0xde,0x71,
  0x1c,0xc7,0x71,0x1c,0xc7,0x71,0x96,0x77,0x9c,0xe5,0x1d,0xc7,
  0xb1,0x8a,0x88,0x88,0x88,0x88,0x48,0x39,0x11,0x11,0x11,0x11,
  0x11,0x11,0x11,0x11,0x11,0x11,0x29,0xe7,0x38,0xab,0x49,0x92,
  0x24,0xb7,0x7a,0x8e,0x23,0xe5,0x44,0x44,0x44,0x44,0x44,0x44,
  0x44,0xc4,0x2b,0x94,0x64,0x25,0x49,0x92,0x64,0x25,0x29,0x94,
  0x13,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x91,0x72,0x8e,0x23,
  0xe5,0x44,0x44,0x44,0xc4,0x24,0xb9,0x95,0x64,0x25,0x49,0x4e,
  0x44,0x44,0x44,0xbc,0x42,0x49,0x0a,0xe5,0x44,0x44,0x44,0xc4,
  0xea,0x38,0x8e,0xbf,0x92,0xac,0x24,0xc9,0x89,0x88,0x88,0x88,
  0x88,0xb7,0x92,0x24,0x49,0x92,0xac,0x24,0x2b,0xef,0x38,0x8e,
  0x49,0x92,0x5f,0x39,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
  0x11,0x11,0x91,0xd5,0x24,0x49,0xde,0x71,0x1c,0x67,0x79,0xc7,
  0x59,0x92,0x24,0x49,0x7e,0x79,0xc7,0x59,0xde,0x71,0x1c,0x93,
  0x24,0x75,0xf5,0x44,0x44,0x44,0x44,0x44,0x44,0x44,0x44,0x44,
  0x44,0xc4,0x2b,0x94,0x13,0x11,0x11,0x11,0x11,0x11,0xab,0xe3,
  0x38,0xfe,0x4a,0xb2,0xf2,0x8e,0xe3,0x38,0x8e,0xe3,0x38,0xfe,
  0x92,0x24,0x49,0x92,0x64,0x96,0x77,0x1c,0xc7,0x71,0xfc,0x95,
  0x95,0x95,0x95,0x95,0x95,0x95,0x95,0x95,0x95,0x95,0x95,0x24,
  0x49,0x56,0x56,0x56,0x56,0x56,0x56,0x5a,0x6d,0xb5,0xd5,0x56,
  0x5b,0x6d,0xb5,0xd5,0x56,0x5b,0x6d,0xb5,0xd5,0x96,0x56,0x5b,
  0x6d,0xb5,0xd5,0x56,0x5b,0x6d,0xb5,0xd5,0x56,0x5b,0x6d,0x75,
  0x65,0x65,0x65,0x65,0x65,0xa5,0x25,0x49,0x92,0x24,0x57,0xce,
  0xf3,0xda,0x89,0x88,0x78,0x8d,0x72,0x26,0xa1,0xbd,0x88,0x88,
  0xe7,0x8b,0x88,0x88,0x2c,0xef,0x6e,0xd2,0xd7,0x88,0x88,0x38,
  0x8e,0xe3,0x38,0x26,0x99,0x55,0x3c,0xdf,0xf3,0x3d,0xdf,0xf3,
  0x3d,0xdf,0xf3,0x3d,0x5f,0x4c,0x72,0x6b,0xfc,0xed,0x65,0x7b,
  0x77,0xbb,0x23,0x1b,0xfe,0xc6,0x3a,0x49,0x92,0x5f,0x9f,0x6c,
  0x2f,0x22,0x22,0x7e,0x4b,0x92,0xa4,0x8a,0x88,0x88,0x88,0x88,
  0xb4,0xf3,0xec,0x26,0xd9,0xcb,0x79,0x5e,0xe9,0x8e,0xe3,0xb8,
  0x97,0x24,0xb7,0xae,0xf6,0xf6,0x22,0x22,0xe2,0xb7,0x6e,0x5d,
  0x27,0xf9,0xf6,0x22,0x22,0x22,0x6b,0x44,0x44,0xc4,0x6f,0x49,
  0xea,0x82,0xef,0xf9,0x9e,0xef,0xf9,0xe2,0xf9,0x9e,0xef,0x49,
  0xb9,0x92,0xe4,0xdb,0xbb,0xdb,0xdb,0x8b,0x88,0x88,0x88,0xdf,
  0x92,0x24,0xb5,0x9c,0xe7,0x79,0xed,0xbc,0x76,0x9e,0xe7,0x95,
  0x24,0x49,0x46,0x16,0xbc,0x76,0xde,0x76,0x5e,0x3b,0x59,0x30,
  0x49,0xd2,0xde,0xee,0x38,0x6b,0x1c,0x77,0xf7,0x96,0x24,0xdf,
  0x5e,0x44,0x44,0x44,0x44,0x44,0x44,0x4c,0x12,0xd6,0x09,0xeb,
  0x84,0x75,0x92,0xa4,0x3a,0xd6,0x75,0x75,0x4c,0x5d,0x27,0xc9,
  0xbb,0xbb,0x3b,0x76,0xbb,0xe9,0xeb,0x24,0xe9,0x76,0xbb,0xe3,
  0xee,0x6e,0x7e,0x9d,0x24,0x99,0x52,0x3d,0xdf,0xf3,0x1d,0xc7,
  0x71,0x1c,0xc7,0x71,0x1c,0xc7,0x71,0x1c,0xdf,0xf3,0x3d,0x6b,
  0x49,0x92,0x71,0x4c,0x5d,0xa7,0x3a,0x26,0x49,0x7a,0xa1,0x9d,
  0xd7,0x28,0xa1,0xd0,0xce,0x6b,0x94,0x24,0xf9,0xf6,0x22,0x22,
  0xe2,0xb7,0x24,0x49,0x92,0xa4,0x97,0x5e,0x92,0x24,0x49,0x92,
  0x74,0x93,0x24,0x49,0x4a,0xdf,0xf6,0x6d,0xdf,0x7e,0xfb,0xed,
  0x65,0xab,0xde,0xd6,0xcb,0x98,0x04,0xcf,0xea,0xf9,0x9e,0xef,
  0xf9,0x9e,0x49,0x92,0xe4,0xdb,0x6e,0xb7,0xdb,0x97,0x24,0x49,
  0x92,0xda,0x6a,0xab,0xad,0xb6,0xda,0x6a,0xab,0xad,0xb6
};

#endif

#endif

