/*    

      wmDiscotux - by Antti Takala <fragment@nic.fi>
        read the README file for more information

*/


#include <math.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <gdk/gdkx.h>

#include <X11/xpm.h>
#include <stdlib.h>
#include <stdio.h>

#include "wmgeneral.h"
#include "xmms/plugin.h"
#include "xmms/configfile.h"
#include "xmms/fullscreen.h"
#include "discotux.xpm"
#include "discotux_back.xpm"

#include "wmdiscotux.h"

#define VERSION "1.3"

discotuxConfig wmdiscotux_cfg;


static GtkWidget *configure_win = NULL;
static GtkWidget *vbox;

static GtkWidget *window = NULL,*darea;
static GdkPixmap *discotux_pixmap = NULL, *draw_pixmap = NULL, *back_pixmap = NULL;
static GdkBitmap *maski = NULL;

static GtkWidget *g_options_frame, *g_options_vbox, *g_options_fullscreen;

static GtkWidget *t_options_frame, *t_options_vbox;
static GtkWidget *t_options_headmode, *t_options_zzz, *t_options_blink;

static GtkWidget *b_options_frame, *b_options_vbox;
static GtkWidget *b_options_stroboclr_box;
static GtkWidget *b_options_strobo;
static GtkWidget *b_options_stroboclr0, *b_options_stroboclr1,
		 *b_options_stroboclr2, *b_options_stroboclr3; 

static GdkGC *gc = NULL, *gc2 = NULL;

static GtkWidget *bbox, *ok, *cancel;

static gboolean delete_event(GtkWidget *w, GdkEvent *e, void *crap);
static gboolean key_press(GtkWidget *w, GdkEventKey *ev, void *crap);

static char discotux_mask_bits[64*64];
static int discotux_mask_width = 64;
static int discotux_mask_height = 64;

static int silmat = 0;
static int suunta = 0;
static int vaihto = 0;

static int tuxx = 144, tuxy = 80;
static int xres=320, yres=240;
gint16 noise[2][4];

static int doneflag = 0;

static void discotux_about(void);
static void discotux_init(void);
static void discotux_cleanup(void);
static void discotux_playback_start(void);
static void discotux_playback_stop(void);
static void discotux_render_freq(gint16 data[2][256]);
static void discotux_adj_changed(GtkWidget *w, int *a);
static void gtkwindow_init(void);

VisPlugin discotux_vp =
{
	NULL,
	NULL,
	0,  
	"wmDiscoTux",
	0,
	2,		
	discotux_init,
	discotux_cleanup,
	discotux_about,
	discotux_conf,
	NULL,
	discotux_playback_start,
	discotux_playback_stop,
	NULL,
	discotux_render_freq
};

VisPlugin *get_vplugin_info(void)
{
	return &discotux_vp;
}

static void wmdiscotux_strobocolor_toggle_cb(GtkWidget *w, gpointer data) {
        if (GTK_TOGGLE_BUTTON(b_options_stroboclr0)->active) {
                wmdiscotux_cfg.stroboclr = 0;
        } else if (GTK_TOGGLE_BUTTON(b_options_stroboclr1)->active) {
                wmdiscotux_cfg.stroboclr = 1;
        } else if (GTK_TOGGLE_BUTTON(b_options_stroboclr2)->active) {
                wmdiscotux_cfg.stroboclr = 2;    
        } else {
                wmdiscotux_cfg.stroboclr = 3;
        }
}

static void discotux_conf_ok(GtkWidget *w, gpointer data)
{
        ConfigFile *cfg;
        gchar *filename;

        wmdiscotux_cfg.headmode = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(t_options_headmode));
	wmdiscotux_cfg.zzz = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(t_options_zzz));
        wmdiscotux_cfg.blink = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(t_options_blink));
	wmdiscotux_cfg.strobo = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(b_options_strobo));
	wmdiscotux_cfg.fullscreen = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(g_options_fullscreen));

        filename = g_strconcat(g_get_home_dir(), "/.xmms/config", NULL);
        cfg = xmms_cfg_open_file(filename);
        if (!cfg)
                cfg = xmms_cfg_new();
        xmms_cfg_write_boolean(cfg, "wmdiscotux", "usetheoriginalhead", wmdiscotux_cfg.headmode);
	xmms_cfg_write_boolean(cfg, "wmdiscotux", "showzwhenstopped", wmdiscotux_cfg.zzz);
	xmms_cfg_write_boolean(cfg, "wmdiscotux", "blinkeyeswhentooquiet", wmdiscotux_cfg.blink);
        xmms_cfg_write_boolean(cfg, "wmdiscotux", "backgroundbassstrobo", wmdiscotux_cfg.strobo);
        xmms_cfg_write_int(cfg, "wmdiscotux", "strobocolorcode", wmdiscotux_cfg.stroboclr);
	xmms_cfg_write_int(cfg, "wmdiscotux", "movingspeed", wmdiscotux_cfg.delay);

        xmms_cfg_write_file(cfg, filename);
        xmms_cfg_free(cfg);
        g_free(filename);
        gtk_widget_destroy(configure_win);

	if (wmdiscotux_cfg.fullscreen) {
        gtk_widget_show(darea);
        gtk_widget_show(window);  
	xmms_fullscreen_init(window);
	xmms_fullscreen_enter(window,&xres,&yres);
	}
}

void discotux_read_conf(void)
{
        ConfigFile *cfg;
        gchar *filename;

        wmdiscotux_cfg.fullscreen = FALSE;
        wmdiscotux_cfg.headmode = FALSE;
	wmdiscotux_cfg.zzz = TRUE;
	wmdiscotux_cfg.blink = TRUE;
        wmdiscotux_cfg.strobo = TRUE;
        wmdiscotux_cfg.stroboclr = 1;
	wmdiscotux_cfg.delay = 20;

        filename = g_strconcat(g_get_home_dir(), "/.xmms/config", NULL);
        cfg = xmms_cfg_open_file(filename);

        if (cfg)
        {
                xmms_cfg_read_boolean(cfg, "wmdiscotux", "usetheoriginalhead", &wmdiscotux_cfg.headmode);
		xmms_cfg_read_boolean(cfg, "wmdiscotux", "showzwhenstopped", &wmdiscotux_cfg.zzz);
                xmms_cfg_read_boolean(cfg, "wmdiscotux", "blinkeyeswhentooquiet", &wmdiscotux_cfg.blink);
                xmms_cfg_read_boolean(cfg, "wmdiscotux", "backgroundbassstrobo", &wmdiscotux_cfg.strobo);
                xmms_cfg_read_int(cfg, "wmdiscotux", "strobocolorcode", &wmdiscotux_cfg.stroboclr);
		xmms_cfg_read_int(cfg, "wmdiscotux", "movingspeed", &wmdiscotux_cfg.delay);
                xmms_cfg_free(cfg);
        }
        g_free(filename);
}

static void discotux_adj_changed(GtkWidget *w, int *a)
{
        *a=(int) GTK_ADJUSTMENT(w)->value;
}


void discotux_conf (void)
{
	GSList *b_options_stroboclr_group;
	GtkObject *adjst;
	GtkWidget *scale, *label;

        if(configure_win)
                return;
	
        discotux_read_conf();

        configure_win = gtk_window_new(GTK_WINDOW_DIALOG);
        gtk_container_set_border_width(GTK_CONTAINER(configure_win), 10);
        gtk_window_set_title(GTK_WINDOW(configure_win), "wmDiscoTux configuration");
        gtk_window_set_policy(GTK_WINDOW(configure_win), FALSE, FALSE, FALSE);
        gtk_window_set_position(GTK_WINDOW(configure_win), GTK_WIN_POS_MOUSE);
        gtk_signal_connect(GTK_OBJECT(configure_win), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed), &configure_win);

        vbox = gtk_vbox_new(FALSE, 5);

// general config

        g_options_frame = gtk_frame_new("General:");
        gtk_container_set_border_width(GTK_CONTAINER(g_options_frame), 5);

        g_options_vbox = gtk_vbox_new(FALSE, 5);
        gtk_container_set_border_width(GTK_CONTAINER(g_options_vbox), 5);

        g_options_fullscreen = gtk_check_button_new_with_label("Fullscreen");
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(g_options_fullscreen), wmdiscotux_cfg.fullscreen);
        gtk_box_pack_start(GTK_BOX(g_options_vbox), g_options_fullscreen, FALSE, FALSE, 0);
        gtk_widget_show(g_options_fullscreen);

        label=gtk_label_new("Speed:");
        gtk_box_pack_start(GTK_BOX(g_options_vbox), label, TRUE, TRUE, 4);
        gtk_widget_show(label);
        adjst=gtk_adjustment_new(wmdiscotux_cfg.delay, 1, 40, 1, 2, 0);
        scale=gtk_hscale_new(GTK_ADJUSTMENT(adjst));
        gtk_scale_set_draw_value(GTK_SCALE(scale), FALSE);
        gtk_widget_show(scale);
        gtk_box_pack_start(GTK_BOX(g_options_vbox), scale, TRUE, TRUE, 4);

        gtk_signal_connect(GTK_OBJECT(adjst), "value-changed", GTK_SIGNAL_FUNC(discotux_adj_changed), &wmdiscotux_cfg.delay);

        gtk_container_add(GTK_CONTAINER(g_options_frame), g_options_vbox);
        gtk_widget_show(g_options_vbox);

        gtk_box_pack_start(GTK_BOX(vbox), g_options_frame, TRUE, TRUE, 0);
        gtk_widget_show(g_options_frame);


// tux config

        t_options_frame = gtk_frame_new("Tux:");
        gtk_container_set_border_width(GTK_CONTAINER(t_options_frame), 5);

        t_options_vbox = gtk_vbox_new(FALSE, 5);
        gtk_container_set_border_width(GTK_CONTAINER(t_options_vbox), 5);

        t_options_headmode = gtk_check_button_new_with_label("Original headmoving");
        t_options_zzz = gtk_check_button_new_with_label("Show 'Z' when sleeping");
        t_options_blink = gtk_check_button_new_with_label("Blinking eyes");

        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(t_options_headmode), wmdiscotux_cfg.headmode);
        gtk_box_pack_start(GTK_BOX(t_options_vbox), t_options_headmode, FALSE, FALSE, 0);
        gtk_widget_show(t_options_headmode);

        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(t_options_zzz), wmdiscotux_cfg.zzz);
        gtk_box_pack_start(GTK_BOX(t_options_vbox), t_options_zzz, FALSE, FALSE, 0);
        gtk_widget_show(t_options_zzz);

        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(t_options_blink), wmdiscotux_cfg.blink);
        gtk_box_pack_start(GTK_BOX(t_options_vbox), t_options_blink, FALSE, FALSE, 0);
        gtk_widget_show(t_options_blink);

        gtk_container_add(GTK_CONTAINER(t_options_frame), t_options_vbox);
        gtk_widget_show(t_options_vbox);

        gtk_box_pack_start(GTK_BOX(vbox), t_options_frame, TRUE, TRUE, 0);
        gtk_widget_show(t_options_frame);

// bg config

        b_options_frame = gtk_frame_new("Background:");
        gtk_container_set_border_width(GTK_CONTAINER(b_options_frame), 5);

        b_options_vbox = gtk_vbox_new(FALSE, 5);
        gtk_container_set_border_width(GTK_CONTAINER(b_options_vbox), 5);

        b_options_strobo = gtk_check_button_new_with_label("Use strobo");
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b_options_strobo), wmdiscotux_cfg.strobo);
        gtk_box_pack_start(GTK_BOX(b_options_vbox), b_options_strobo, FALSE, FALSE, 0);
        gtk_widget_show(b_options_strobo);

        b_options_stroboclr_box = gtk_vbox_new(TRUE, 5);
        gtk_container_set_border_width(GTK_CONTAINER(b_options_stroboclr_box), 5);
        gtk_box_pack_start(GTK_BOX(b_options_vbox), b_options_stroboclr_box, TRUE, TRUE, 0);
        gtk_widget_show(b_options_stroboclr_box);

        b_options_stroboclr0 = gtk_radio_button_new_with_label(NULL, "Original white (bass)");
        if (wmdiscotux_cfg.stroboclr == 0) gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b_options_stroboclr0), TRUE);
        gtk_box_pack_start(GTK_BOX(b_options_stroboclr_box), b_options_stroboclr0, TRUE, TRUE, 0);
        gtk_widget_show(b_options_stroboclr0);

        b_options_stroboclr_group = gtk_radio_button_group(GTK_RADIO_BUTTON(b_options_stroboclr0));

        b_options_stroboclr1 = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(b_options_stroboclr0)), "Red + blue (mid + bass)");
        if (wmdiscotux_cfg.stroboclr == 1) gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b_options_stroboclr1), TRUE);
        gtk_box_pack_start(GTK_BOX(b_options_stroboclr_box), b_options_stroboclr1, TRUE, TRUE, 0);
        gtk_widget_show(b_options_stroboclr1);

        b_options_stroboclr2 = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(b_options_stroboclr1)), "Yellow (mid + bass)");
        if (wmdiscotux_cfg.stroboclr == 2) gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b_options_stroboclr2), TRUE);
        gtk_box_pack_start(GTK_BOX(b_options_stroboclr_box), b_options_stroboclr2, TRUE, TRUE, 0);
        gtk_widget_show(b_options_stroboclr2);

        b_options_stroboclr3 = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(b_options_stroboclr2)), "Green (mid)");
        if (wmdiscotux_cfg.stroboclr == 3) gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b_options_stroboclr3), TRUE);
        gtk_box_pack_start(GTK_BOX(b_options_stroboclr_box), b_options_stroboclr3, TRUE, TRUE, 0);
        gtk_widget_show(b_options_stroboclr3);


        gtk_signal_connect(GTK_OBJECT(b_options_stroboclr0), "toggled",
                        (GtkSignalFunc)wmdiscotux_strobocolor_toggle_cb, NULL);
        gtk_signal_connect(GTK_OBJECT(b_options_stroboclr1), "toggled",
                        (GtkSignalFunc)wmdiscotux_strobocolor_toggle_cb, NULL);
        gtk_signal_connect(GTK_OBJECT(b_options_stroboclr2), "toggled",
                        (GtkSignalFunc)wmdiscotux_strobocolor_toggle_cb, NULL);
        gtk_signal_connect(GTK_OBJECT(b_options_stroboclr3), "toggled",
                        (GtkSignalFunc)wmdiscotux_strobocolor_toggle_cb, NULL);

        gtk_container_add(GTK_CONTAINER(b_options_frame), b_options_vbox);
        gtk_widget_show(b_options_vbox);

        gtk_box_pack_start(GTK_BOX(vbox), b_options_frame, TRUE, TRUE, 0);
        gtk_widget_show(b_options_frame);

// buttons

        bbox = gtk_hbutton_box_new();
        gtk_button_box_set_layout(GTK_BUTTON_BOX(bbox), GTK_BUTTONBOX_END);   
        gtk_button_box_set_spacing(GTK_BUTTON_BOX(bbox), 5);
        gtk_box_pack_start(GTK_BOX(vbox), bbox, FALSE, FALSE, 0);

        ok = gtk_button_new_with_label(" Ok ");
        gtk_signal_connect(GTK_OBJECT(ok), "clicked", GTK_SIGNAL_FUNC(discotux_conf_ok), NULL);
        GTK_WIDGET_SET_FLAGS(ok, GTK_CAN_DEFAULT);
        gtk_box_pack_start(GTK_BOX(bbox), ok, TRUE, TRUE, 0);
        gtk_widget_show(ok);

        cancel = gtk_button_new_with_label("Cancel");
        gtk_signal_connect_object(GTK_OBJECT(cancel), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(configure_win));
        GTK_WIDGET_SET_FLAGS(cancel, GTK_CAN_DEFAULT);
        gtk_box_pack_start(GTK_BOX(bbox), cancel, TRUE, TRUE, 0);
        gtk_widget_show(cancel);
        gtk_widget_show(bbox);
        gtk_container_add(GTK_CONTAINER(configure_win), vbox);
        gtk_widget_show(vbox);
        gtk_widget_show(configure_win);
//        gtk_widget_grab_default(ok);   

}


static void discotux_about(void) {
        GtkWidget *dialog, *button, *label;

        dialog = gtk_dialog_new();

        gtk_widget_set_usize (dialog, 300, 200);
        gtk_window_set_title(GTK_WINDOW(dialog), "about wmDiscoTux");
        gtk_window_set_policy(GTK_WINDOW(dialog), FALSE, FALSE, FALSE);
        gtk_container_border_width(GTK_CONTAINER(dialog), 5);


        label = gtk_label_new ("
wmDiscoTux\n\
v " VERSION "\n\

by Antti Takala <fragment@nic.fi>\n\

get the newest version from:\n\
http://wmdiscotux.stc.cx/\n\

");

        gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), label, FALSE, FALSE, 0);
        gtk_widget_show(label);

        button = gtk_button_new_with_label(" Ok ");
        gtk_signal_connect_object(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(dialog));
        gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), button, FALSE, FALSE, 0);
        gtk_widget_show(button);

        gtk_widget_show(dialog);
        gtk_widget_grab_focus(button);
}


static gboolean key_press(GtkWidget *w, GdkEventKey *ev, void *crap)
{
        switch (ev->keyval)
        {
                case GDK_Escape: { 
			gdk_threads_leave();
                        xmms_fullscreen_leave(window);
                        xmms_fullscreen_cleanup(window);
			gdk_threads_enter();
	                gtk_widget_destroy(window);
			gdk_threads_leave();
			gtkwindow_init();
			wmdiscotux_cfg.fullscreen = FALSE;
			break; }
                default: break;
        }

        return TRUE;
}

static gboolean delete_event(GtkWidget *w, GdkEvent *e, void *crap)
{
        gdk_threads_leave();
	wmdiscotux_cfg.fullscreen = FALSE;
        gdk_threads_enter();
        return TRUE;
}


static void gtkwindow_init(void)
{

	gdk_threads_leave();
        gdk_threads_enter();
        gdk_rgb_init();
        gtk_widget_set_default_visual(gdk_rgb_get_visual());
        gtk_widget_set_default_colormap(gdk_rgb_get_cmap());

        window=gtk_window_new(GTK_WINDOW_DIALOG);

        gtk_window_set_title(GTK_WINDOW(window), "wmdiscotux");
        gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, FALSE);
        gtk_widget_set_usize(window, xres, yres);
	gtk_widget_realize(window);

	draw_pixmap = gdk_pixmap_new(window->window,xres,yres,gdk_rgb_get_visual()->depth);
        discotux_pixmap = gdk_pixmap_create_from_xpm_d(window->window,&maski,NULL,discotux_xpm);
        back_pixmap = gdk_pixmap_create_from_xpm_d(window->window,NULL,NULL,discotux_back_xpm);

        gc = gdk_gc_new(window->window);
        gc2 = gdk_gc_new(window->window);
	//gdk_gc_set_clip_mask(gc2, maski);
	//gdk_gc_set_clip_origin(gc2, 40, 90);

        gtk_signal_connect(GTK_OBJECT(window), "delete_event", GTK_SIGNAL_FUNC(delete_event),NULL);
        gtk_signal_connect(GTK_OBJECT(window), "key_press_event", GTK_SIGNAL_FUNC(key_press), NULL);

        darea=gtk_drawing_area_new();
        gtk_widget_set_usize(darea, xres, yres);
        gtk_container_add(GTK_CONTAINER(window), darea);

                gdk_window_set_back_pixmap(darea->window,draw_pixmap,0);
		gdk_draw_pixmap(draw_pixmap,gc,back_pixmap,0,0,0,0,320,240);
		gdk_draw_pixmap(draw_pixmap,gc,discotux_pixmap,101,0,tuxx,tuxy,53,53);
                gdk_window_clear(darea->window);

        // gtk_widget_show(darea);
        // gtk_widget_show(window);  
        gdk_window_clear(window->window);
        gdk_window_clear(darea->window);  

        gdk_threads_leave();

}


static void discotux_init(void)
{

	char *fake[] = {"wmDiscoTux"};
	discotux_read_conf();
	gtkwindow_init();

	createXBMfromXPM(discotux_mask_bits, discotux_xpm, discotux_mask_width, discotux_mask_height);
	openXwindow(1, fake, discotux_xpm, discotux_mask_bits, discotux_mask_width, discotux_mask_height);

	AddMouseRegion(0, 5, 5, 58, 58 );
	copyXPMArea(101,0,54,54,6,6);
	copyXPMArea(156,28,24,13,22,14);
	if (wmdiscotux_cfg.zzz) copyXPMArea(65,0,20,15,6,7);
	RedrawWindow();

	memset(noise, 0, 2*4*sizeof(gint16));
}

static void discotux_cleanup(void)
{
	if (wmdiscotux_cfg.fullscreen) {
	       		gdk_threads_enter();
                        xmms_fullscreen_leave(window);
                        xmms_fullscreen_cleanup(window);
	                gtk_widget_destroy(window);
		        gdk_threads_leave();
	} else {

	RedrawWindow();
	XCloseDisplay(display);
	}

	discotux_vp.disable_plugin(&discotux_vp);
}

static gint draw_func(void)
{

	int bass, treb;
        int buttonStatus = -1;
	int i,x,y, chk1, chk2, chk3;
            XEvent Event;

//	gint rgbx;
//	guchar rgb_data[320 * 240 * 3];

//        if(configure_win)
//                return FALSE;

		chk1 = noise[0][0] + noise[1][0];
		chk2 = 0; for (i=2;i<4;i++) { chk2 += noise[0][i]; }
		chk3 = 0; for (i=2;i<4;i++) { chk3 += noise[1][i]; }

		bass = (noise[0][0]+noise[1][0])/4;
		treb = (noise[0][1]+noise[1][1]+noise[0][2]+noise[1][2])/5;

		if (bass>25) bass=25;
		if (treb>25) treb=25;

	if (wmdiscotux_cfg.fullscreen) {
	if (doneflag)
		return FALSE;

	gdk_threads_enter(); {
		doneflag = 1;

// tuxx = (rand() % 320);
tuxy = 90; //-(chk1/20;

/*        for (rgbx = 0; rgbx < 320; rgbx++ ) {
		rgb_data[rgbx*3] = bass*10;
		rgb_data[rgbx*3+1] = 0;
		rgb_data[rgbx*3+2] = treb*10;
          }*/

	gdk_draw_pixmap(draw_pixmap,gc,back_pixmap,0,0,0,0,320,240);
//	gdk_draw_rgb_image(draw_pixmap,gc,0,0,320,240,GDK_RGB_DITHER_NONE,(guchar *)rgb_data, 0);
	gdk_draw_pixmap(draw_pixmap,gc,discotux_pixmap,101,0,tuxx,tuxy,53,53);


// head
	if (suunta == 0) {
		if (chk1 > 140) { gdk_draw_pixmap(draw_pixmap,gc,discotux_pixmap,223,54,tuxx+10,tuxy,35,26); vaihto = 1; }
		if (chk1 > 80 && chk1 < 140) { gdk_draw_pixmap(draw_pixmap,gc,discotux_pixmap,223,27,tuxx+10,tuxy,35,26);
			if (vaihto == 1) { vaihto = 0; suunta = 1; } }
		if (chk1 > 10 && chk1 < 80) { gdk_draw_pixmap(draw_pixmap,gc,discotux_pixmap,223,0,tuxx+10,tuxy,35,26); }
	} else {
		if (chk1 > 140) { gdk_draw_pixmap(draw_pixmap,gc,discotux_pixmap,259,54,tuxx+10,tuxy,35,26); vaihto = 1; }
		if (chk1 > 80 && chk1 < 140) { gdk_draw_pixmap(draw_pixmap,gc,discotux_pixmap,259,27,tuxx+10,tuxy,35,26);
			if (vaihto == 1) { vaihto = 0; suunta = 0; } }
		if (chk1 > 10 && chk1 < 80) { gdk_draw_pixmap(draw_pixmap,gc,discotux_pixmap,259,0,tuxx+10,tuxy,35,26); }
	}
// legs
	if (chk2 > 60) gdk_draw_pixmap(draw_pixmap,gc,discotux_pixmap,181,42,tuxx+4,tuxy+34,20,19);
       	if (chk2 > 30 && chk2 < 60) gdk_draw_pixmap(draw_pixmap,gc,discotux_pixmap,181,21,tuxx+4,tuxy+34,20,19);
        if (chk2 > 10 && chk2 < 30) gdk_draw_pixmap(draw_pixmap,gc,discotux_pixmap,181,0,tuxx+4,tuxy+34,20,19);
	if (chk3 > 60) gdk_draw_pixmap(draw_pixmap,gc,discotux_pixmap,202,42,tuxx+30,tuxy+34,20,19);
       	if (chk3 > 30 && chk3 < 60) gdk_draw_pixmap(draw_pixmap,gc,discotux_pixmap,202,21,tuxx+30,tuxy+34,20,19);
        if (chk3 > 10 && chk3 < 30) gdk_draw_pixmap(draw_pixmap,gc,discotux_pixmap,202,0,tuxx+30,tuxy+34,20,19);

	gdk_window_clear(darea->window);
	gdk_threads_leave();
	} } else {   // don't draw to dockapp if fullscreen is on

        while (XPending(display)){
	    XNextEvent(display, &Event);
            switch (Event.type) {
                        case ButtonPress:
                                i = CheckMouseRegion(Event.xbutton.x, Event.xbutton.y);
                                buttonStatus = i;
				break;
                        case ButtonRelease:
                                i = CheckMouseRegion(Event.xbutton.x, Event.xbutton.y);
                if (buttonStatus == i && buttonStatus >= 0){
                    switch (buttonStatus){
                        case 0 :
			    discotux_conf();
                            break;
                } buttonStatus = -1; break;
                        }
		}
        }

	if (doneflag)
		return FALSE;

	gdk_threads_enter(); {
		doneflag = 1;

		if (chk1+chk2+chk3 > 30) { 
			silmat = 0;

			if (wmdiscotux_cfg.headmode) {  // use original head (left only)
                              if (chk1 > 140) copyXPMArea(223,54,35,26,16,6);
                              if (chk1 > 80 && chk1 < 140) copyXPMArea(223,27,35,26,16,6);
                              if (chk1 > 10 && chk1 < 80) copyXPMArea(223,0,35,26,16,6);
			} else {

			if (suunta == 0) {  // turn head left
	                      if (chk1 > 140) { copyXPMArea(223,54,35,26,16,6); vaihto = 1; }
  	                      if (chk1 > 80 && chk1 < 140) { copyXPMArea(223,27,35,26,16,6);
 						if (vaihto == 1) { vaihto = 0; suunta = 1; } }
    	                      if (chk1 > 10 && chk1 < 80) { copyXPMArea(223,0,35,26,16,6); } 
					}

			else {  // turn head right
                              if (chk1 > 140) { copyXPMArea(259,54,35,26,16,6); vaihto = 1; }
                              if (chk1 > 80 && chk1 < 140) { copyXPMArea(259,27,35,26,16,6);
						 if (vaihto == 1) { vaihto = 0; suunta = 0; } }
                              if (chk1 > 10 && chk1 < 80) { copyXPMArea(259,0,35,26,16,6); }
					}
			}
			
			// left leg
			if (chk2 > 60) copyXPMArea(181,42,20,20,10,40);
                        if (chk2 > 30 && chk2 < 60) copyXPMArea(181,21,20,20,10,40);
                        if (chk2 > 10 && chk2 < 30) copyXPMArea(181,0,20,20,10,40);

			// right leg
                        if (chk3 > 60) copyXPMArea(202,42,20,20,36,40);
                        if (chk3 > 30 && chk3 < 60) copyXPMArea(202,21,20,20,36,40);
                        if (chk3 > 10 && chk3 < 30) copyXPMArea(202,0,20,20,36,40);

		}
		
		silmat++;

		if (silmat < 100 && silmat > 1) { // reset tux && open eyes
				copyXPMArea(101,0,54,54,6,6);
				copyXPMArea(156,0,24,13,22,14); }

                if (wmdiscotux_cfg.blink)
                {  // blink eyes if too quiet
			if (silmat > 100 && silmat < 105) copyXPMArea(156,14,24,13,22,14);
        	        if (silmat > 105 && silmat < 120) copyXPMArea(156,28,24,13,22,14);
			if (silmat > 120 && silmat < 125) copyXPMArea(156,14,24,13,22,14);
		}

		if (silmat > 125) silmat = 0;

		if (wmdiscotux_cfg.strobo) {  // draw strobo
		  for (y = 6; y < 59; y+=2) {
		    for (x = 6; x < 59; x+=2) {
		        copyXPMArea(66+(wmdiscotux_cfg.stroboclr*27)+bass,54+treb,1,1,x,y);
		    }
		  }
		}

		RedrawWindow();

	}
	gdk_threads_leave();

	}
	doneflag = 0;
	return TRUE;
}

static void discotux_playback_start(void)
{
	if (!wmdiscotux_cfg.fullscreen) {
        copyXPMArea(101,0,54,54,6,6);
	copyXPMArea(156,0,24,13,22,14);
	RedrawWindow();
	} else {
                gdk_window_set_back_pixmap(darea->window,draw_pixmap,0);
		gdk_draw_pixmap(draw_pixmap,gc,back_pixmap,0,0,0,0,320,240);
		gdk_draw_pixmap(draw_pixmap,gc,discotux_pixmap,101,0,tuxx,tuxy,53,53);
                gdk_window_clear(darea->window);
	}
}

static void discotux_playback_stop(void)
{
	if (!wmdiscotux_cfg.fullscreen) {
	copyXPMArea(101,0,54,54,6,6);
        copyXPMArea(156,28,24,13,22,14);
	if (wmdiscotux_cfg.zzz) copyXPMArea(65,0,20,15,6,7);
	memset(noise, 0, 2*4*sizeof(gint16));
	RedrawWindow();
	}

}


static void discotux_render_freq(gint16 data[2][256])
{

	int t, c, tmp;

	if (doneflag) return;
	
	for (c = 0; c < 2; c++) { 
		for (t = 0; t < 4; t++) {
			tmp = data[c][t]>>7;
			if (tmp > noise[c][t]) noise[c][t] = tmp;
			else if (noise[c][t]>wmdiscotux_cfg.delay) noise[c][t] -= wmdiscotux_cfg.delay;
			else noise[c][t] = 0; 
		}
	}

	draw_func();
	return;			
}
