/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include "sdl_gforce_config.h"

#include <glib.h>
#include <gtk/gtk.h>
#include <sys/types.h>
#include <dirent.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>

#include "singit/macros.h"
#include "singit/displayer_plugin.h"
#include "singit/control.h"

#include "sdl_gforce_status.h"

SingitConfigXMMS *displayer_sdl_gforce_config = NULL;

extern DisplayerPlugin sdl_gforce_dp;

static gpointer displayer_sdl_gforce_config_init_event
	(SingitConfigGen *scg, gpointer user_data)
{
	SDLGForceConfigData *sdl_config_data = g_malloc(sizeof(SDLGForceConfigData));

	sdl_config_data->forceGlobals = TRUE;
	sdl_config_data->debugEnable = FALSE;

	sdl_config_data->lyricFontName = NULL;

	return sdl_config_data;
}

static void displayer_sdl_gforce_config_free_event
	(SingitConfigGen *scg, SDLGForceConfigData *cfg_data, gpointer user_data)
{
	if (cfg_data->lyricFontName) { g_free(cfg_data->lyricFontName); }

	g_free(cfg_data);
}

#define GBL_VAR      forceGlobals
#define GBL_SESSION  sdl_gforce_dp.singit_session
#define CFG_DATA     cfg_data
#define CFG_FILE     cfg_file
#define SECTION     "DisplayerSDL"

static void displayer_sdl_gforce_config_load_event(SingitConfigGen *scg,
	ConfigFile* cfg_file, SDLGForceConfigData *cfg_data, gpointer user_data)
{
	READ_CFG_DEF(boolean, forceGlobals, FALSE);

	READ_CFG_DEF_GBL(boolean,hideIfNotFound,hide_if_not_found);
	READ_CFG_DEF_GBL(boolean,showEmpty,show_empty);
	READ_CFG_DEF_GBL(boolean,autoResize,auto_resize);
#ifdef CODEDEBUG
	READ_CFG_DEF_GBL(boolean,debugEnable,debug_enabled);
#endif
	READ_CFG_DEF_GBL(boolean,framerateLimitEnabled,framerate_limit_enabled);
	READ_CFG_DEF_GBL(int,framerateLimit,framerate_limit);

	// * global independant config *
	READ_CFG_DEF(boolean, hideIfNotFoundFullscreen, FALSE);
	READ_CFG_DEF(string, lyricFontName, g_strdup(SINGIT_DATA_DIR "/vixar.ttf"));
	READ_CFG_DEF(boolean, optimizeFontSize, TRUE);

	READ_CFG_DEF(int, winPosX, -1);
	READ_CFG_DEF(int, winPosY, -1);
	READ_CFG_DEF(int, lyricFontSize, 32);
	READ_CFG_DEF(int, lyricFontSizeFullscreen, 48);

	// * global config copies *
	cfg_data->gblToggleYZ =
		singit_remote_cfg_toggle_yz(sdl_gforce_dp.singit_session);
}

static void displayer_sdl_gforce_config_save_event(SingitConfigGen *scg,
	ConfigFile* cfg_file, SDLGForceConfigData *cfg_data, gpointer user_data)
{
	// * boolean values *
	WRITE_CFG(boolean, forceGlobals);
	WRITE_CFG(boolean, hideIfNotFound);
	WRITE_CFG(boolean, showEmpty);
	WRITE_CFG(boolean, autoResize);
#ifdef CODEDEBUG
	WRITE_CFG(boolean, debugEnable);
#endif
	WRITE_CFG(boolean, framerateLimitEnabled);
	WRITE_CFG(int, framerateLimit);

	// * string values *
	WRITE_CFG(del_string, lyricFontName);

	// * global independant config *
	WRITE_CFG(boolean, hideIfNotFoundFullscreen);
	WRITE_CFG(boolean, optimizeFontSize);

	WRITE_CFG(int, winPosX);
	WRITE_CFG(int, winPosY);
	WRITE_CFG(int, lyricFontSize);
	WRITE_CFG(int, lyricFontSizeFullscreen);
}

#undef SECTION
#undef CFG_FILE
#undef CFG_DATA
#undef GBL_SESSION
#undef GBL_VAR

SingitConfigGen* displayer_sdl_gforce_config_new(void)
{
	g_return_val_if_fail(STATUS != NULL, NULL);
	g_return_val_if_fail(STATUS->config == NULL,
		SINGIT_CONFIG_GEN(STATUS->config));

	STATUS->config = singit_config_xmms_new();
	singit_config_gen_clear_initial(&STATUS->config);
	singit_config_gen_set_filename
		(STATUS->config, CONFIG_FILENAME);

	gtk_signal_connect(GTK_OBJECT(STATUS->config), "init_data",
		GTK_SIGNAL_FUNC(displayer_sdl_gforce_config_init_event), NULL);
	gtk_signal_connect(GTK_OBJECT(STATUS->config), "free_data",
		GTK_SIGNAL_FUNC(displayer_sdl_gforce_config_free_event), NULL);
	gtk_signal_connect(GTK_OBJECT(STATUS->config), "load",
		GTK_SIGNAL_FUNC(displayer_sdl_gforce_config_load_event), NULL);
	gtk_signal_connect(GTK_OBJECT(STATUS->config), "save",
		GTK_SIGNAL_FUNC(displayer_sdl_gforce_config_save_event), NULL);

	return STATUS->config;
}
