
#ifndef __FOURIER_ANALYSER_H__
#define __FOURIER_ANALYSER_H__

class FourierAnalyzer {

	public:

		/* If you pluck a guitar string then slide you finger up the fret slowly, you'll hear the
		pitch (ie, freq) rise.  When you do this, the power of the sounds stays close to constant (that is, the lower
		pitch sounds as 'loud' as the high pitch).  Power is proportional to the peak mechanical deflection times
		the square of the freq (ie, P is proprotional to amplitude * w * w).  If inNormalizePower is true, the output
		of Tranform for each freq is the power of that freq.  If it's false, Transform will return the
		amplitude for each freq.  So if you were watching a freq spectrum with power equalized and you
		slid your finger up your plucked guitar string, you see a peak of a constant height slide towards
		the higher freq side of the spectrum.  */
								FourierAnalyzer( bool inNormalizePower = true );
		virtual					~FourierAnalyzer();

		/* Performs a fourier transform of inF[]:
		Pre: 	The function to be transformed is inF[] and is inN elements big
		Pre:	inBinStart >= 0
		Pre:	"Quiet" is no bias (ie, inF[ t ] == 0 means at time t, there was no signal detected)
		Pre:	outSin[] and outCos[] is at least <nBins elements big
		Post:	outSin and outCos are the frequency components of inF[]  (where outSin[] is the imaginary component)
				outSin[ w ] and outCos[ w ] are the frequency component of frequency (inFreqStart + inBinRange * w / inBins) in rads/time */
		void 					Transform( short inF[], long inN, long inBins, float inBinRange, float inFreqStart, float outSin[], float outCos[] );
		void 					Transform( float inF[], long inN, long inBins, float inBinRange, float inFreqStart, float outSin[], float outCos[] );

		/* Identical to above except the freq components returned are in polar form.
			Note:  If outAngle[] is NULL, the angular component for each frequency component isn't calculated.  */
		void 					TransformPolar( short inF[], long inN, long inBins, float inBinRange, float inFreqStart, float outMagnitude[], float outAngle[] );
		void 					TransformPolar( float inF[], long inN, long inBins, float inBinRange, float inFreqStart, float outMagnitude[], float outAngle[] );


	protected:

		float*					mTrigLookup;
		float*					mSinFT;

		float					mBinRange, mFreqStart;
		long					mN, mNumBins;

		bool					mNormalizePower;

		void					GenerateTrigTables( long inN, long inNumBins, float inBinRange, float inFreqStart );

};

#endif // __FOURIER_ANALYSER_H__
