
#ifndef __DC_VIDEO_DEVICE_H__
#define __DC_VIDEO_DEVICE_H__


#if WIN_QUICKTIME_PRESENT
#include <QuickDraw.h>
#endif

#if EG_MAC
#include <Types.h>
#endif

#include "VideoDevice.h"
#include "Eg Common.h"


/* This class represents a OS graphics port that will be a video outlet.   It's defined
by an OS graphics device context and a rectangle within that port to draw video.  Because
a port is more abstract, it doesn't have the functionality that a WindowDevice does.
Audio players like this API because it allows them to use a plugin however they like, for
example, using a plugin a background for their player. */

class DC_VideoDevice : public VideoDevice {

public:
	DC_VideoDevice( bool inForceFullRedraws );

	void			SetPort( PP_GrafPtr inPortDC, Rect& inLocalRect, bool inIsFullscreen );

	virtual int		GetDepth()											{ return mDepth;			}

	bool			GetDisplaySize( Point& ioSize );

	virtual void		Erase( bool inUpdateNow );

	bool			IsFullscreen()										{ return mIsFullscreen;		}

	bool 			GetParentDisplaySize( Point& ioSize );

	// Two different ways to obtain a display ID...
	// Use the long returned here for EnterFullscreen()...
	// Returns the (inDeviceNum)th display ID
	static long		GetDisplayID( long inDeviceNum );

	// Returns a display ID that contains the given global coordinate
	static long		GetDisplayID( long inX, long inY );

	static bool		GetDisplaySize( long inDispID, Point& ioSize );

	static long		GetDisplayID( PP_GrafPtr inPort );

protected:
	void			SetDeviceEntries( PixPort* inFrame );

	virtual void		BeginFrame_Self();
	virtual void		PreFrame_Self( PixPort* inSrceFrame );

	PP_GrafPtr		mDC;
	int			mDepth;
	long			mCurPaletteSeed;
	bool			mSetEntriesCompat;

#if EG_MAC
	GDHandle		mFS_GDevice;
#endif

	bool			mIsFullscreen;

	static int		GetPortDepth( PP_GrafPtr inPortDC );

	void			TransferBits( PixPort& inFrame, Rect& inSrce, Rect& inDest );
};


#endif
