
#include "SDL_VideoDevice.h"

#include <SDL/SDL_error.h>

SDL_VideoDevice::SDL_VideoDevice( bool inForceFullRedraws ) :
	VideoDevice( inForceFullRedraws ) {

}

void SDL_VideoDevice::SetOutput( SDL_Surface *surface ) {

	Rect rect;

	SetRect( &rect, 0, 0, surface->w, surface->h );

	mSurface 	= surface;
	mBits 		= (char*) surface->pixels;
	mBytesPerRow 	= surface->pitch;
	mDepth 		= surface->format->BitsPerPixel;
	mOutputRect 	= rect;
	mBounds		= rect;
}

void SDL_VideoDevice::TransferBits( PixPort& inFrame, Rect& inSrce, Rect& inDest ) {

	CopyBits( &inFrame, inSrce, inDest.left, inDest.top );
}

void SDL_VideoDevice::BeginFrame_Self()
{
	if ( SDL_MUSTLOCK((mSurface)) ) {
		if ( SDL_LockSurface((mSurface)) < 0 ) {
			fprintf(stderr, "Can't lock video surface: %s\n", SDL_GetError());
		}
	}
}

void SDL_VideoDevice::EndFrame_Self()
{
	if ( SDL_MUSTLOCK((mSurface)) ) {
		SDL_UnlockSurface((mSurface));
	}
}
