
#include "GeneralFileSys.h"

#include "XLongList.h"
#include "FileSysIDList.h"

#ifdef EG_MAC
#include <Errors.h>
#endif

#define MIR_FILE_SYS_UNCACHED   FILE_SYS_USER_FLAG1

GeneralFileSys::GeneralFileSys( bool inUniqueNames ) {

	// This can only be set once and cannot change after that
	mUniqueNames = inUniqueNames;

	//mCaseSensitive = inCaseSensitive;
}

GeneralFileSys::~GeneralFileSys() {

}

void GeneralFileSys::ThrowErr( long err, long inOSErr, FileObj inID, const char* inMsg ) {

	switch ( inOSErr ) {

		#ifdef EG_MAC
		case afpAccessDenied:
			err = FILE_SYS_ACCESS_DENIED;
			break;

		case fnfErr:
			err = FILE_SYS_FNF;
			break;

		case opWrErr:
		case afpFileBusy:
		case afpLockErr:
			err = FILE_SYS_IN_USE;
			break;

		case fLckdErr:
		case permErr:
			err = FILE_SYS_NO_WRITE_PERM;
			break;

		case vLckdErr:
		case wPrErr:
		case afpVolLocked:
		case afpObjectLocked:
			err = FILE_SYS_VOL_LOCKED;
			break;

		case wrPermErr:
			err = FILE_SYS_ITEM_LOCKED;
			break;

		case dskFulErr:
		case afpDiskFull:
			err = FILE_SYS_FULL_ERR;
			break;
		#endif

		#ifdef EG_WIN
		#include "winerror.h"

		case ERROR_FILE_NOT_FOUND:
		case ERROR_INVALID_ACCESS:  // FNF??
			err = FILE_SYS_FNF;
			break;

		case ERROR_PATH_NOT_FOUND:
			err = FILE_SYS_PATH_NOT_FOUND;
			break;

		case ERROR_ACCESS_DENIED:
			err = FILE_SYS_ACCESS_DENIED;
			break;

		case ERROR_OUTOFMEMORY:
		case ERROR_NO_MORE_FILES:
		case ERROR_HANDLE_DISK_FULL:
			err = FILE_SYS_FULL_ERR;
			break;

		case ERROR_WRITE_PROTECT:
			err = FILE_SYS_VOL_LOCKED;
			break;

		case ERROR_DUP_NAME:
			err = FILE_SYS_ALREADY_EXISTS;
			break;
		#endif
	}

	mLastErr.Assign( err, inOSErr, inMsg, inID );
}


void GeneralFileSys::ThrowErr( long inErr, FileObj inID, const char* inMsg ) {

	mLastErr.Assign( inErr, 0, inMsg, inID );
}



void GeneralFileSys::ThrowErr( long inErr, FileObj inID ) {

	mLastErr.Assign( inErr, 0, nil, inID );
}


void GeneralFileSys::ThrowErr( GeneralFileSys& inFileSys ) {

	mLastErr.Assign( inFileSys.mLastErr );
	//inFileSys.GetLastError( mLastErr );
}


void GeneralFileSys::SetErrorMsg( const char* inMsg ) {

	mLastErr.mErrorMsg.Assign( inMsg );
}



const char* GeneralFileSys::GetErrMsg( long inErrID, long  ) {
	const char* inMsg;

	switch ( inErrID ) {

		case FILE_SYS_FILE_NEEDED:		inMsg = "Item must be a file";							break;
		case FILE_SYS_FOLDER_NEEDED:	inMsg = "Item must be a folder";						break;
		case FILE_SYS_FNF:				inMsg = "File/Folder not found";						break;
		case FILE_SYS_AMBIGUOUS_NAME:	inMsg = "More than one item with that name exists";		break;
		case FILE_SYS_IN_USE:			inMsg = "File in use";									break;
		case FILE_SYS_NAME_TOO_LONG:	inMsg = "Name too long";								break;
		case FILE_SYS_ILLEGAL_CHARS:	inMsg = "Name contains illegal characters";				break;
		case FILE_SYS_ALREADY_EXISTS:	inMsg = "Item with that name already exists";			break;
		case FILE_SYS_NO_ROOT_PARENT:	inMsg = "The root folder does not have a parent";		break;
		case FILE_SYS_ITEM_LOCKED:		inMsg = "Item is locked";								break;
		case FILE_SYS_UNSUPPORTED_FCN:	inMsg = "Unimplemented operation in FileSys";			break;
		case FILE_SYS_PARAM_NOT_FOUND:	inMsg = "Parameter doesn't exist for GetInfo()";		break;
		case FILE_SYS_ROOT_LOCKED:		inMsg = "Can't delete the root";						break;
		case FILE_SYS_BAD_ASSIGN_SPEC:	inMsg = "Unexpected failure to assign OS file/folder spec";		break;
		case FILE_SYS_WRITE_ERR:		inMsg = "Error during writing file ";							break;
		case FILE_SYS_OPEN_ERR:			inMsg = "Error opening file";									break;
		case FILE_SYS_CREATE_ERR:		inMsg = "Error creating file";									break;
		case FILE_SYS_READ_ERR:			inMsg = "Error reading file";									break;
		case FILE_SYS_FULL_ERR:			inMsg = "Volume full";											break;
		case FILE_SYS_NO_WRITE_PERM:	inMsg = "Don't have write permission";							break;
		case FILE_SYS_VOL_LOCKED:		inMsg = "Parent volume or folder is locked";					break;
		case FILE_SYS_PATH_NOT_FOUND:	inMsg = "Path not found";										break;
		case FILE_SYS_TOME_LOAD_ERR:	inMsg = "Tome load error";										break;
		case FILE_SYS_TOME_WRITE_ERR:	inMsg = "Tome write error";										break;

		//case FILE_SYS_CANT_LOAD_IMAGE:	inMsg = "Unsupported image format or problem decoding image";	break;
		default:						inMsg = "Unknown error";
	}

	return inMsg;
}



void GeneralFileSys::GetLastError( UtilStr& outStr ) {


	if ( mLastErr.mErrorMsg.length() )
		outStr.Assign( mLastErr.mErrorMsg );
	else
		outStr.Assign( GetErrMsg( mLastErr.mErrorID, mLastErr.mOSErrorID ) );

	outStr.Append( " (" );
	outStr.Append( (long) mLastErr.mErrorID );
	if ( mLastErr.mOSErrorID ) {
		outStr.Append( ", " );
		outStr.Append( ((long) mLastErr.mOSErrorID) );
		outStr.Append( ')' );
	}
}







FileResult GeneralFileSys::Create( FileObj inParent, FileObj& outID, long inFlags ) {
	UtilStr title;
	long	tryNum = -1;
	bool	titleTaken;
	FileObj	itemID;

	// Don't make a unique title if unique titles aren't required or if we're about to replace the item
	if ( mUniqueNames && ( ( inFlags & FILE_SYS_REPLACE ) == 0 ) ) {

		// Keep trying until we get a unique title
		do {

			title.Assign( ( inFlags & FILE_SYS_FOLDER ) ? "Untitled Folder" : "Untitled" );

			tryNum++;
			if ( tryNum > 0 ) {
				title.Append( (char) ' ' );
				title.Append( tryNum );
			}

			// We know the title is taken in a parent if the fileSys can resolve title inside that parent
			if ( GetItemID( inParent, title, itemID ) )
				titleTaken = true;
			else
				titleTaken = false;

		} while ( titleTaken );
	}

	// We have a title that returned an err when we tried to resolve it, so use that
	return Create( inParent, title, outID, inFlags );
}



FileResult GeneralFileSys::GetName( FileObj inID, UtilStr& outName ) {

	const UtilStr* str = GetName( inID );

	outName.Assign( str );

	return ( str ) ? FILE_SYS_SUCCESS : FILE_SYS_FAIL;

}

FileResult GeneralFileSys::ThrowUnimp() {

	ThrowErr( FILE_SYS_UNSUPPORTED_FCN, 0, FILE_SYS_INVALID_ID );

	return FILE_SYS_FAIL;
}


long GeneralFileSys::GetLastError() {

	return mLastErr.mErrorID;
}


/*
void GeneralFileSys::GetLastError( ErrorInfo& outInfo ) {

	outInfo.Assign( mLastErr );
}
*/

FileResult GeneralFileSys::GetPathname( FileObj inID, UtilStr& outPathName, char inSepChar ) {

	FileObj parent;
	bool ok = true;

	if ( inID == FILE_SYS_ROOT_ID )
		outPathName.Wipe();
	else if ( GetParent( inID, parent ) ) {

		if ( GetPathname( parent, outPathName, inSepChar ) ) {
			if ( inID != FILE_SYS_ROOT_ID )
				outPathName.Append( inSepChar );
			outPathName.Append( GetName( inID ) );  }
		else
			ok = false;
	}

	return ok ? FILE_SYS_SUCCESS : FILE_SYS_FAIL;
}

FileResult GeneralFileSys::GetItemID( FileObj inParentID, const char* inName, FileObj& outID ) {

	UtilStr temp( inName );

	return GetItemID( inParentID, temp, outID );
}


/*


class ReadOnlyFileSys : public GeneralFileSys {

	public:

		// This fcn associates subsequent file accesses to a dir on this OS disk
		void				SetRootDir( char* inName );


		const UtilStr*		ReadFile( FileObj inObject );

		void				CacheAll();
};





void PluginGlue::BuildConfigList( char* inFolderName, FileSpecList& ioList, XLongList* ioPlayList ) {
	CEgFileSpec folder;
	int i;

	// Make a file spec list of what's in the folder
	folder.AssignFolder( inFolderName, &mMainFolder );
	ioList.ScanFolder( folder );

	// Make a random-ordered playlist
	if ( ioPlayList ) {
		ioPlayList -> RemoveAll();
		for ( i = 1; i <= ioList.Count(); i++ ) {
			ioPlayList -> Add( i );
		}
		ioPlayList -> Randomize();
	}
}


mMainFolder.AssignFolder( MAIN_CONFIGS_FOLDER );

*/
