#include "ExpressionDict.h"

#include "UtilStr.h"


ExpressionDict::ExpressionDict() :
	mVarDict() {

}



void ExpressionDict::AddVar( char* inKey, float* inPtr ) {

	UtilStr* newKey = new UtilStr( inKey );

	//  Vars and fcns are case insensitive 
	newKey -> Capitalize();
	
	mVarDict.Put( newKey, inPtr, HT_KEY_OWNED );
}


void ExpressionDict::AddFcn( char* inKey, ExprUserFcn** inFcn ) {

	UtilStr* newKey = new UtilStr( inKey );

	//  Vars and fcns are case insensitive 
	newKey -> Capitalize();	
	
	mVarDict.Put( newKey, inFcn, HT_KEY_OWNED );
}


float* ExpressionDict::LookupVar( const UtilStr& inName ) {
	float* addr;
	
	if ( mVarDict.Get( &inName, (void**) &addr ) )
		return addr;
	else
		return nil;
}


ExprUserFcn** ExpressionDict::LookupFunc( const UtilStr& inName ) {
	
	return (ExprUserFcn**) LookupVar( inName );
}
