
#include "AbstractStrAccess.h"

#include "UtilStr.h"

// Neal 4469765
// cell: 860-2357457

AbstractStrAccess::AbstractStrAccess( XStrListOptsT inOrdering ) {

	mStrOrdering = inOrdering;
}


bool AbstractStrAccess::Fetch( long inIndex, UtilStr& outStr ) const {

	const UtilStr*	str = Fetch( inIndex );

	if ( str ) {
		outStr.Assign( str );
		return true; }
	else
		return false;
}

long AbstractStrAccess::FindString( const UtilStr* inStr, bool inCaseSensitive ) const {

	if ( inStr )
		return FindString( inStr -> getCStr(), inCaseSensitive );
	else
		return 0;
}

long AbstractStrAccess::FindString( const char* inStr, bool inCaseSensitive ) const {

	int				i = 1;
	const UtilStr*	str;
	long			n = Count();

	if ( n < 1 || inStr == nil ) { }

	// If the elements are sorted case insens but the search is case sensitive
	else if ( mStrOrdering == ASA_Sorted_Case_Insensitive && inCaseSensitive ) {

		// Do a linear search starting where the first occuring case-dissimilar version of inStr would be
		// and ending where it would end (ie, when we no longer observe case insensitive matches)
		for ( i = BinarySearch( inStr, false ) + 1; i < n; i++ ) {

			// If the string matches, we found a winner!
			str = Fetch( i );
			if ( str -> compareTo( inStr, true ) == 0 )
				return i;

			// Stop checking when we hit strongs that don't even match case insensitive
			else if ( str -> compareTo( inStr, false ) != 0 )
				break;
		}
	}

	// If elements are sorted by case sensitive but the search is case insensitive...
	else if ( mStrOrdering == ASA_Sorted_Case_Sensitive && ! inCaseSensitive ) {

		// We could do a thing where we recursively close in on it in (2 log N) * inStr.length(),
		// but I'd die of angony implementing that, so...
		goto brute_force;
	}

	// If the elements are unsorted then do a brute force or "linear" search  :^(
	else if ( mStrOrdering == ASA_OrderImportant || mStrOrdering == ASA_OrderNotImportant ) {

brute_force:
		for ( i = 1; i <= n; i++ ) {
			str = Fetch( i );
			if ( str -> compareTo( inStr, inCaseSensitive ) == 0 )
				return i;
		} }

	// If the elements are sorted in the case senstivity we're using, we know right where to look
	else {
		i = BinarySearch( inStr, inCaseSensitive ) + 1;

		// If the string matches, we found a winner
		str = Fetch( i );
		if ( str ) {
			if ( str -> compareTo( inStr,  inCaseSensitive ) == 0 )
				return i;
		}
	}


	return 0;
}

long AbstractStrAccess::BinarySearch( const char* inStr, bool inCaseSensitive ) const {

	long M = 0, L = 0, R = Count() - 1;
	const UtilStr*	str;

	if ( R < 0 )
		return 0;

	while ( L <= R ) {

		M = ( L + R ) / 2;
		str = Fetch( M + 1 );

		if ( str -> compareTo( inStr, inCaseSensitive ) <= 0 )
			R = M - 1;										// Throw away right half
		else
			L = M + 1;										// Throw away left half
	}

	if ( L > R )											// Catch the case where R+1==L
		L = M;												// In this case, M specifies the critical element

	// At this point, we know L is the critical element (case: L==R or L contains M from case above)
	str = Fetch( L + 1 );
	if ( str -> compareTo( inStr, inCaseSensitive ) > 0 )
		L++;

	return L;
}

long AbstractStrAccess::FindBestMatch( const char* inStr, long inLen ) {

	long			best, bestScore, score, i;
	const UtilStr*	str;
	long			n = Count();
	best = 0;

	if ( inStr ) {

		for ( i = 1; i <= n; i++ ) {

			str = Fetch( i );
			score = str -> LCSMatchScore( inStr, inLen );
			if ( score > bestScore || i == 1 ) {
				best = i;
				bestScore = score;
			}
		}
	}

	return best;
}
