/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __TEXTURE_H__
#define __TEXTURE_H__

#include <GL/gl.h>
#include <GL/glext.h>
#include "cpicture.h"

#define MYCALLBACK

#define TEX_SECURE

typedef void (MYCALLBACK *glActiveTextureARBFunc) (GLenum texture);
typedef void (MYCALLBACK *glMultiTexCoord2fARBFunc) (GLenum target, GLfloat s, GLfloat t);
typedef void (MYCALLBACK *glMultiTexCoord4fARBFunc) (GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q);
typedef void (MYCALLBACK *glClientActiveTextureARBFunc) (GLenum texture);

enum
{
	maxTexSize = 1024 // dont hardcode
};

class CTexture : public CPicture
{
protected:
	bool isTexSizeOk();

        bool multiTexturingAvailable;
        guint32 textureID;
	gint32 lastError;
	GLenum pic_format, tex_format;
	GLenum wrapS, wrapT, minFilter, magFilter;
	GLenum texEnv;
	bool build_mipmaps;

public:
	CTexture();
	CTexture(gchar i_bpp, guint32 i_width, guint32 i_height, const gchar *i_data);
	virtual ~CTexture();

	GLenum getFormat(bool texture = true);
	bool setTexFormat (GLenum f);

	virtual bool loadFile(const gchar *szFileName, PicType type, GLenum nf = 0);
	virtual bool loadData(const gchar *data_p, const guint size, PicType type, GLenum nf = 0);

	virtual bool setRAW(gchar i_bpp, guint32 i_width, guint32 i_height);

	bool realize (bool freePic = false);
	bool bind(bool freePic = false);
	void reset();

	void setCombineOp (float fOperation);
	void initMultitexturing (glActiveTextureARBFunc f1,
		glMultiTexCoord2fARBFunc f2,
		glMultiTexCoord4fARBFunc f3,
		glClientActiveTextureARBFunc f4);
	bool multiTexCoord2f (GLenum target, GLfloat s, GLfloat t);
	bool multiTexCoord4f (GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q);
	bool setActiveTMU (GLenum target);
	void genTexCoords();

	void setEnvironmentMapping();
	void setSphereMapping();
	void setLightmap();
	void setTransparency();

	void   setMipMapping(bool v)	{ build_mipmaps = v; }
	bool   getMipMapping()		{ return build_mipmaps; }
	void   setMinFilter(GLenum v) 	{ minFilter = v; }
	GLenum getMinFilter()		{ return minFilter; }
	void   setMagFilter(GLenum v) 	{ magFilter = v; }
	GLenum getMagFilter()		{ return magFilter; }
	void   setWrapS(GLenum v) 	{ wrapS = v; }
	GLenum getWrapS()		{ return wrapS; }
	void   setWrapT(GLenum v) 	{ wrapT = v; }
	GLenum getWrapT()		{ return wrapT; }
	void   setTexEnv(GLenum v) 	{ texEnv = v; }
	GLenum getTexEnv()		{ return texEnv; }

	guint32 getId ()		{ return textureID; }

private:
	// Multitexturing function callbacks
	glActiveTextureARBFunc m_glActiveTextureARB;
	glMultiTexCoord2fARBFunc m_glMultiTexCoord2fARB;
	glMultiTexCoord4fARBFunc m_glMultiTexCoord4fARB;
	glClientActiveTextureARBFunc m_glClientActiveTextureARB;
};

#endif // __TEXTURE_H__
