/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <GL/gl.h>
#include <GL/glu.h>

#include "ccamera.h"

enum {
	X = 0,
	Y,
	Z
};

CCamera::CCamera()
{
	src[X] = 0.0f;
	src[Y] = 0.0f;
	src[Z] = 10.0f;
	dst[X] = 0.0f;
	dst[Y] = 0.0f;
	dst[Z] = 0.0f;
	up[X] = 0.0f;
	up[Y] = 1.0f;
	up[Z] = 0.0f;

	camera_rotate = 0;
}

CCamera::~CCamera()
{
}

void CCamera::lookAt(void)
{
	glLoadIdentity();

	gluLookAt(
		src[X], src[Y], src[Z],
		dst[X], dst[Y], dst[Z],
		 up[X],  up[Y],  up[Z]
	);
}

void CCamera::rotate(void)
{
	radius = 22.0f + 6.0f * Sin(radius_angle);
	radius_angle += ANGLE_2PI / 1024;
	radius_angle &= ANGLE_MASK;

	src[X] = radius * Sin(camera_rotate);
	src[Y] = 4.0f * Sin(camera_rotate2);
	src[Z] = radius * Cos(camera_rotate);
	camera_rotate += ANGLE_2PI / 768;
	camera_rotate &= ANGLE_MASK;
	camera_rotate2 += ANGLE_2PI / 768;
	camera_rotate2 &= ANGLE_MASK;
}
