/* MSA spectrum analyzer
 * Copyright (C) 2000 Michal Kunikowski <kunik@poczta.onet.pl>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __MSA_SKIN__
#define __MSA_SKIN__

#include <glib.h>

#define DEFAULT_SKIN_COLOR "000000-003639-007d7b-00ffff"
#define BLUE_SKIN_COLOR    "000000-003639-007d7b-00ffff"
#define GREEN_SKIN_COLOR   "000000-274827-4f904f-70df70"
#define AMBER_SKIN_COLOR   "000000-351c09-944e11-ff8822"

typedef struct {
	GdkColor bg;
	GdkColor low;
	GdkColor med;
	GdkColor high;
} msa_analyzer_colors;

void msaskin_unref_skin_pixmaps();
void set_logo_pixmap(GdkGC *gc, GdkPixmap *pixmap);
void add_suitable_titlebar_to_pixmap(GdkGC *gc, GdkPixmap *pixmap);
void set_suitable_analyzer_pixmaps(GdkPixmap **leds_on_pixmap, GdkPixmap **leds_off_pixmap);
void set_default_skin(GdkWindow *window, GdkGC *gc);

void msaskin_setdefaultcfg(msaskinconfig *skincfg);
void splitstr(char *dst1, char *dst2, char *src, char delim);
gboolean msaskin_loadskinconfig(msaskinconfig *skincfg, char *skindir);

void msaskin_set_std_analyzer_pixmap(GdkGC *gc, msa_analyzer_colors *colors, GdkPixmap *off_pixmap, GdkPixmap *on_pixmap);
void msaskin_set_std_rev_analyzer_pixmap(GdkGC *gc, msa_analyzer_colors *colors, GdkPixmap *off_pixmap, GdkPixmap *on_pixmap);
void msaskin_set_mirrored_analyzer_pixmap(GdkGC *gc, msa_analyzer_colors *colors, GdkPixmap *off_pixmap, GdkPixmap *on_pixmap);
void msaskin_set_mirrored_rev_analyzer_pixmap(GdkGC *gc, msa_analyzer_colors *colors, GdkPixmap *off_pixmap, GdkPixmap *on_pixmap);
void msaskin_set_default_border_pixmap(GdkGC *gc, GdkPixmap *pixmap);

#endif
